package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHiStoreInstanceInfo invokes the drds.DescribeHiStoreInstanceInfo API synchronously
func (client *Client) DescribeHiStoreInstanceInfo(request *DescribeHiStoreInstanceInfoRequest) (response *DescribeHiStoreInstanceInfoResponse, err error) {
	response = CreateDescribeHiStoreInstanceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHiStoreInstanceInfoWithChan invokes the drds.DescribeHiStoreInstanceInfo API asynchronously
func (client *Client) DescribeHiStoreInstanceInfoWithChan(request *DescribeHiStoreInstanceInfoRequest) (<-chan *DescribeHiStoreInstanceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeHiStoreInstanceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHiStoreInstanceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHiStoreInstanceInfoWithCallback invokes the drds.DescribeHiStoreInstanceInfo API asynchronously
func (client *Client) DescribeHiStoreInstanceInfoWithCallback(request *DescribeHiStoreInstanceInfoRequest, callback func(response *DescribeHiStoreInstanceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHiStoreInstanceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeHiStoreInstanceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHiStoreInstanceInfoRequest is the request struct for api DescribeHiStoreInstanceInfo
type DescribeHiStoreInstanceInfoRequest struct {
	*requests.RpcRequest
	HistoreInstanceId string `position:"Query" name:"HistoreInstanceId"`
	DrdsInstanceId    string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeHiStoreInstanceInfoResponse is the response struct for api DescribeHiStoreInstanceInfo
type DescribeHiStoreInstanceInfoResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	HiStoreInstanceInfo HiStoreInstanceInfo `json:"HiStoreInstanceInfo" xml:"HiStoreInstanceInfo"`
}

// CreateDescribeHiStoreInstanceInfoRequest creates a request to invoke DescribeHiStoreInstanceInfo API
func CreateDescribeHiStoreInstanceInfoRequest() (request *DescribeHiStoreInstanceInfoRequest) {
	request = &DescribeHiStoreInstanceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeHiStoreInstanceInfo", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHiStoreInstanceInfoResponse creates a response to parse from DescribeHiStoreInstanceInfo response
func CreateDescribeHiStoreInstanceInfoResponse() (response *DescribeHiStoreInstanceInfoResponse) {
	response = &DescribeHiStoreInstanceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
