package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartK8sApplication invokes the edas.RestartK8sApplication API synchronously
func (client *Client) RestartK8sApplication(request *RestartK8sApplicationRequest) (response *RestartK8sApplicationResponse, err error) {
	response = CreateRestartK8sApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// RestartK8sApplicationWithChan invokes the edas.RestartK8sApplication API asynchronously
func (client *Client) RestartK8sApplicationWithChan(request *RestartK8sApplicationRequest) (<-chan *RestartK8sApplicationResponse, <-chan error) {
	responseChan := make(chan *RestartK8sApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartK8sApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartK8sApplicationWithCallback invokes the edas.RestartK8sApplication API asynchronously
func (client *Client) RestartK8sApplicationWithCallback(request *RestartK8sApplicationRequest, callback func(response *RestartK8sApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartK8sApplicationResponse
		var err error
		defer close(result)
		response, err = client.RestartK8sApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartK8sApplicationRequest is the request struct for api RestartK8sApplication
type RestartK8sApplicationRequest struct {
	*requests.RoaRequest
	AppId   string           `position:"Query" name:"AppId"`
	Timeout requests.Integer `position:"Query" name:"Timeout"`
}

// RestartK8sApplicationResponse is the response struct for api RestartK8sApplication
type RestartK8sApplicationResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Code          int    `json:"Code" xml:"Code"`
	Message       string `json:"Message" xml:"Message"`
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
}

// CreateRestartK8sApplicationRequest creates a request to invoke RestartK8sApplication API
func CreateRestartK8sApplicationRequest() (request *RestartK8sApplicationRequest) {
	request = &RestartK8sApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "RestartK8sApplication", "/pop/v5/k8s/acs/restart_k8s_app", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartK8sApplicationResponse creates a response to parse from RestartK8sApplication response
func CreateRestartK8sApplicationResponse() (response *RestartK8sApplicationResponse) {
	response = &RestartK8sApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
