package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScaleWithAdjustment invokes the ess.ScaleWithAdjustment API synchronously
func (client *Client) ScaleWithAdjustment(request *ScaleWithAdjustmentRequest) (response *ScaleWithAdjustmentResponse, err error) {
	response = CreateScaleWithAdjustmentResponse()
	err = client.DoAction(request, response)
	return
}

// ScaleWithAdjustmentWithChan invokes the ess.ScaleWithAdjustment API asynchronously
func (client *Client) ScaleWithAdjustmentWithChan(request *ScaleWithAdjustmentRequest) (<-chan *ScaleWithAdjustmentResponse, <-chan error) {
	responseChan := make(chan *ScaleWithAdjustmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScaleWithAdjustment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScaleWithAdjustmentWithCallback invokes the ess.ScaleWithAdjustment API asynchronously
func (client *Client) ScaleWithAdjustmentWithCallback(request *ScaleWithAdjustmentRequest, callback func(response *ScaleWithAdjustmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScaleWithAdjustmentResponse
		var err error
		defer close(result)
		response, err = client.ScaleWithAdjustment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScaleWithAdjustmentRequest is the request struct for api ScaleWithAdjustment
type ScaleWithAdjustmentRequest struct {
	*requests.RpcRequest
	AdjustmentValue        requests.Integer `position:"Query" name:"AdjustmentValue"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	ScalingGroupId         string           `position:"Query" name:"ScalingGroupId"`
	AdjustmentType         string           `position:"Query" name:"AdjustmentType"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	MinAdjustmentMagnitude requests.Integer `position:"Query" name:"MinAdjustmentMagnitude"`
}

// ScaleWithAdjustmentResponse is the response struct for api ScaleWithAdjustment
type ScaleWithAdjustmentResponse struct {
	*responses.BaseResponse
	ScalingActivityId string `json:"ScalingActivityId" xml:"ScalingActivityId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateScaleWithAdjustmentRequest creates a request to invoke ScaleWithAdjustment API
func CreateScaleWithAdjustmentRequest() (request *ScaleWithAdjustmentRequest) {
	request = &ScaleWithAdjustmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "ScaleWithAdjustment", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScaleWithAdjustmentResponse creates a response to parse from ScaleWithAdjustment response
func CreateScaleWithAdjustmentResponse() (response *ScaleWithAdjustmentResponse) {
	response = &ScaleWithAdjustmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
