/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriority;
import org.jkiss.dbeaver.ext.exasol.model.ExasolPriorityGroup;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolConnectionGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolRoleGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSchemaGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolScriptGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSystemGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolTableGrant;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolViewGrant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class ExasolGrantee
implements DBPSaveableObject,
DBPRefreshableObject {
    private ExasolDataSource dataSource;
    private ExasolPriority priority;
    private boolean persisted;
    private static final Log log = Log.getLog(ExasolGrantee.class);

    public ExasolGrantee(ExasolDataSource dataSource, ResultSet resultSet) {
        this.dataSource = dataSource;
        if (resultSet != null) {
            this.persisted = true;
            try {
                this.priority = dataSource.getPriorityGroup((DBRProgressMonitor)new VoidProgressMonitor(), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_PRIORITY"));
            }
            catch (DBException dBException) {
                this.priority = null;
            }
        } else {
            this.persisted = false;
        }
    }

    public ExasolGrantee(ExasolDataSource dataSource, Boolean persisted) {
        this.dataSource = dataSource;
        this.persisted = persisted;
    }

    @NotNull
    public abstract String getName();

    public boolean isPersisted() {
        return this.persisted;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.dataSource.refreshObject(monitor);
        for (ExasolGrantee grantee : this.dataSource.getAllGrantees(monitor)) {
            if (!this.getClass().getSimpleName().equals(grantee.getClass().getSimpleName()) || !this.getName().equals(grantee.getName())) continue;
            return grantee;
        }
        throw new DBException("Object disappeared after refresh");
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Collection<ExasolSystemGrant> getSystemgrants(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSystemGrant> sysGrants = new ArrayList<ExasolSystemGrant>();
        for (ExasolSystemGrant grant : this.dataSource.getSystemGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            sysGrants.add(grant);
        }
        return sysGrants;
    }

    public Collection<ExasolConnectionGrant> getConnections(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolConnectionGrant> conGrants = new ArrayList<ExasolConnectionGrant>();
        for (ExasolConnectionGrant grant : this.dataSource.getConnectionGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            conGrants.add(grant);
        }
        return conGrants;
    }

    public Collection<ExasolRoleGrant> getRoles(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolRoleGrant> roleGrants = new ArrayList<ExasolRoleGrant>();
        for (ExasolRoleGrant grant : this.dataSource.getRoleGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            roleGrants.add(grant);
        }
        return roleGrants;
    }

    public Collection<ExasolTableGrant> getTables(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableGrant> grants = new ArrayList<ExasolTableGrant>();
        for (ExasolTableGrant grant : this.dataSource.getTableGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolViewGrant> getViews(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolViewGrant> grants = new ArrayList<ExasolViewGrant>();
        for (ExasolViewGrant grant : this.dataSource.getViewGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolScriptGrant> getProcedures(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolScriptGrant> grants = new ArrayList<ExasolScriptGrant>();
        for (ExasolScriptGrant grant : this.dataSource.getScriptGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    public Collection<ExasolSchemaGrant> getSchemas(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolSchemaGrant> grants = new ArrayList<ExasolSchemaGrant>();
        for (ExasolSchemaGrant grant : this.dataSource.getSchemaGrants(monitor)) {
            if (!grant.getGrantee().equals(this.getName())) continue;
            grants.add(grant);
        }
        return grants;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=PriorityListProvider.class)
    public ExasolPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ExasolPriority priority) {
        this.priority = priority;
    }

    public static class PriorityListProvider
    implements IPropertyValueListProvider<ExasolGrantee> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(ExasolGrantee object) {
            ExasolDataSource dataSource = object.getDataSource();
            try {
                if (dataSource.getUserPriviliges().hasConsumerGroups().booleanValue()) {
                    Collection<ExasolConsumerGroup> consumerGroups = dataSource.getConsumerGroups((DBRProgressMonitor)new VoidProgressMonitor());
                    return consumerGroups.toArray(new Object[0]);
                }
                Collection<ExasolPriorityGroup> priorityGroups = dataSource.getPriorityGroups((DBRProgressMonitor)new VoidProgressMonitor());
                return priorityGroups.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }
}

