/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.experiment.ab.impl.ABExperimentOption;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"KUBERNETES_TOOLWINDOW_ID", "", "shouldRunSeparateToolWindowExperiment", "", "fireKubernetesServiceChanged", "", "Lcom/intellij/openapi/project/Project;", "eventType", "Lcom/intellij/execution/services/ServiceEventListener$EventType;", "target", "", "selectKubernetesService", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "service", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesServiceViewContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesServiceViewContributor.kt\ncom/intellij/kubernetes/view/nodes/KubernetesServiceViewContributorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,238:1\n13#2:239\n*S KotlinDebug\n*F\n+ 1 KubernetesServiceViewContributor.kt\ncom/intellij/kubernetes/view/nodes/KubernetesServiceViewContributorKt\n*L\n118#1:239\n*E\n"})
public final class KubernetesServiceViewContributorKt {
    @NotNull
    public static final String KUBERNETES_TOOLWINDOW_ID = "Kubernetes";

    private static final boolean shouldRunSeparateToolWindowExperiment() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (ApplicationManagerEx.isInIntegrationTest()) {
            return false;
        }
        return ABExperimentOption.KUBERNETES_SEPARATE_SERVICE_VIEW.isEnabled();
    }

    public static final void fireKubernetesServiceChanged(@NotNull Project $this$fireKubernetesServiceChanged, @NotNull ServiceEventListener.EventType eventType, @NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)$this$fireKubernetesServiceChanged, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if ($this$fireKubernetesServiceChanged.getMessageBus().isDisposed()) {
            return;
        }
        MessageBus messageBus = $this$fireKubernetesServiceChanged.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)eventType, (Object)target, KubernetesServiceViewContributor.class));
    }

    @NotNull
    public static final Promise<Void> selectKubernetesService(@NotNull Project $this$selectKubernetesService, @NotNull Object service) {
        Intrinsics.checkNotNullParameter((Object)$this$selectKubernetesService, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesServiceViewContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger log2 = logger;
        if (log2.isDebugEnabled()) {
            String message2 = "Selecting service: " + service;
            log2.debug(message2, new Throwable(message2));
        }
        KubernetesUsageTriggerCollector.INSTANCE.getSERVICE_VIEW_SELECTED_EVENT().log(service.getClass());
        Promise promise = ServiceViewManager.getInstance((Project)$this$selectKubernetesService).select(service, KubernetesServiceViewContributor.class, true, true);
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"select(...)");
        return promise;
    }

    public static final /* synthetic */ boolean access$shouldRunSeparateToolWindowExperiment() {
        return KubernetesServiceViewContributorKt.shouldRunSeparateToolWindowExperiment();
    }
}

