/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u000f\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\u001b\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/scripts/VmFileEditor;", "Lcom/intellij/openapi/fileEditor/impl/BaseRemoteFileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/scripts/VmScriptFile;)V", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "isValid", "", "download", "", "getComponent", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/Nullable;", "getName", "", "selectNotify", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "deselectNotify", "getTextEditor", "dispose", "Companion", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nVmFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VmFileEditor.kt\ncom/intellij/javascript/debugger/scripts/VmFileEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class VmFileEditor
extends BaseRemoteFileEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VmScriptFile file;
    @Nullable
    private TextEditor textEditor;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    private volatile boolean isValid;
    @NlsSafe
    @NotNull
    private static final String editorName = "Vm";

    public VmFileEditor(@NotNull Project project, @NotNull VmScriptFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            super(project);
            this.file = file;
            this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300L);
            this.isValid = true;
            VmFileEditor $this$_init__u24lambda_u240 = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.loadingPanel.startLoading();
            for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                Promise<String> source;
                JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
                if (viewSupport.getVm() == null || (source = debugProcess.getScriptSource($this$_init__u24lambda_u240.file.getScript())).getState() == Promise.State.REJECTED) continue;
                $this$_init__u24lambda_u240.download($this$_init__u24lambda_u240.file);
                break block1;
            }
            $this$_init__u24lambda_u240.loadingPanel.stopLoading();
            $this$_init__u24lambda_u240.isValid = false;
        }
    }

    private final void download(VmScriptFile file) {
        Project project = this.myProject;
        file.ensureDownloaded().onProcessed((Consumer)new ConsumerOnEdt<VirtualFile>(this, project){
            final /* synthetic */ VmFileEditor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void consume(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                VmFileEditor.access$getLoadingPanel$p(this.this$0).stopLoading();
                FileEditor fileEditor = TextEditorProvider.Companion.getInstance().createEditor(project, file);
                Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
                TextEditor _textEditor = (TextEditor)fileEditor;
                Editor editor = _textEditor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (editor2 instanceof EditorEx) {
                    ((EditorEx)editor2).setViewer(true);
                }
                VmFileEditor.access$setTextEditor$p(this.this$0, _textEditor);
                VmFileEditor.access$contentLoaded(this.this$0);
                TextEditor textEditor = VmFileEditor.access$getTextEditor$p(this.this$0);
                Intrinsics.checkNotNull((Object)textEditor);
                textEditor.addPropertyChangeListener((PropertyChangeListener)((Object)this.this$0));
                JBLoadingPanel jBLoadingPanel = VmFileEditor.access$getLoadingPanel$p(this.this$0);
                TextEditor textEditor2 = VmFileEditor.access$getTextEditor$p(this.this$0);
                Intrinsics.checkNotNull((Object)textEditor2);
                JComponent jComponent = textEditor2.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                jBLoadingPanel.add((Component)jComponent);
            }
        }).onError(arg_0 -> VmFileEditor.download$lambda$1(arg_0 -> VmFileEditor.download$lambda$0(this, arg_0), arg_0));
    }

    public boolean isValid() {
        return this.isValid && super.isValid();
    }

    @NotNull
    public JBLoadingPanel getComponent() {
        return this.loadingPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent;
        if (this.textEditor == null) {
            jComponent = (JComponent)this.loadingPanel;
        } else {
            TextEditor textEditor = this.textEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            jComponent = textEditor.getPreferredFocusedComponent();
        }
        return jComponent;
    }

    @NotNull
    public String getName() {
        return editorName;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> VmFileEditor.selectNotify$lambda$0(this));
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> VmFileEditor.deselectNotify$lambda$0(this));
    }

    @Nullable
    protected TextEditor getTextEditor() {
        return this.textEditor;
    }

    public void dispose() {
        block0: {
            super.dispose();
            TextEditor textEditor = this.textEditor;
            if (textEditor == null) break block0;
            TextEditor it = textEditor;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    private static final Unit download$lambda$0(VmFileEditor this$0, Throwable it) {
        this$0.loadingPanel.stopLoading();
        this$0.isValid = false;
        this$0.contentRejected();
        return Unit.INSTANCE;
    }

    private static final void download$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void selectNotify$lambda$0(VmFileEditor this$0) {
        if (this$0.textEditor != null) {
            TextEditor textEditor = this$0.textEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            textEditor.selectNotify();
        }
    }

    private static final void deselectNotify$lambda$0(VmFileEditor this$0) {
        block0: {
            TextEditor textEditor = this$0.textEditor;
            if (textEditor == null) break block0;
            textEditor.deselectNotify();
        }
    }

    public static final /* synthetic */ JBLoadingPanel access$getLoadingPanel$p(VmFileEditor $this) {
        return $this.loadingPanel;
    }

    public static final /* synthetic */ void access$setTextEditor$p(VmFileEditor $this, TextEditor textEditor) {
        $this.textEditor = textEditor;
    }

    public static final /* synthetic */ void access$contentLoaded(VmFileEditor $this) {
        $this.contentLoaded();
    }

    public static final /* synthetic */ TextEditor access$getTextEditor$p(VmFileEditor $this) {
        return $this.textEditor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/scripts/VmFileEditor$Companion;", "", "<init>", "()V", "editorName", "", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

