/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.parser;

import com.intellij.javaee.utils.persistence.data.parser.Part;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.javaee.utils.persistence.data.parser.PartType;
import com.intellij.javaee.utils.persistence.data.parser.domain.OrderBySource;
import com.intellij.javaee.utils.persistence.data.parser.domain.Sort;
import com.intellij.javaee.utils.persistence.data.parser.domain.Suffix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartTree
implements Iterable<OrPart> {
    private Subject subject;
    private Predicate predicate;
    private final String mySource;
    private final PartTreeParserContext myParserContext;

    public PartTree(@NotNull String source, @NotNull PsiClass domainClass, @NotNull PartTreeParserContext parserContext) {
        if (source == null) {
            PartTree.$$$reportNull$$$0(0);
        }
        if (domainClass == null) {
            PartTree.$$$reportNull$$$0(1);
        }
        if (parserContext == null) {
            PartTree.$$$reportNull$$$0(2);
        }
        this.mySource = source;
        this.myParserContext = parserContext;
        for (Pattern pattern : parserContext.prefixTemplates()) {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.find()) continue;
            String group = PartTree.getSubjectGroup(matcher);
            this.subject = new Subject(group);
            this.predicate = new Predicate(source.substring(group.length()), domainClass, parserContext);
            break;
        }
        if (this.subject == null) {
            this.subject = new Subject(null);
            this.predicate = new Predicate(source, domainClass, parserContext);
        }
    }

    private static String getSubjectGroup(Matcher matcher) {
        try {
            return matcher.group("subject");
        }
        catch (Exception exception) {
            return matcher.group(0);
        }
    }

    public String getSource() {
        return this.mySource;
    }

    @Override
    public Iterator<OrPart> iterator() {
        return this.predicate.iterator();
    }

    public Sort getSort() {
        OrderBySource orderBySource = this.getOrderBySource();
        return orderBySource == null ? null : orderBySource.toSort();
    }

    @Nullable
    public OrderBySource getOrderBySource() {
        return this.predicate.getOrderBySource();
    }

    @NotNull
    public List<Suffix> getSuffixes() {
        List<Suffix> list = this.predicate.getSuffixes();
        if (list == null) {
            PartTree.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public Boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public Boolean isExistsProjection() {
        return this.subject.isExistsProjection();
    }

    public Boolean isDelete() {
        return this.subject.isDelete();
    }

    public Boolean isUpdate() {
        return this.subject.isUpdate();
    }

    public boolean isLimiting() {
        return this.getMaxResults() != null;
    }

    public Integer getMaxResults() {
        return this.subject.getMaxResults();
    }

    public List<Part> getParts() {
        ArrayList<Part> result = new ArrayList<Part>();
        for (OrPart orPart : this) {
            for (Part part : orPart) {
                result.add(part);
            }
        }
        return result;
    }

    public Iterable<Part> getParts(PartType type) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (Part part : this.getParts()) {
            if (!part.getType().equals(type)) continue;
            result.add(part);
        }
        return result;
    }

    public String toString() {
        OrderBySource orderBySource = this.getOrderBySource();
        return String.format("%s%s", StringUtil.join(this.predicate.nodes, (String)" or "), orderBySource == null ? "" : " " + String.valueOf(orderBySource));
    }

    private String[] split(String text, String keyword) {
        if (text.equals(keyword)) {
            return new String[]{"", ""};
        }
        String format = String.format(this.myParserContext.keywordTemplate(), keyword);
        if (text.endsWith(keyword)) {
            List splitted = ContainerUtil.append((List)StringUtil.split((String)text, (String)keyword), (Object[])new String[]{""});
            return ArrayUtil.toStringArray((Collection)splitted);
        }
        Pattern pattern = Pattern.compile(format);
        return pattern.split(text);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/persistence/data/parser/PartTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/persistence/data/parser/PartTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public class Subject {
        private static final String DISTINCT = "Distinct";
        private final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??By");
        private final Pattern EXISTS_BY_TEMPLATE;
        private final Pattern DELETE_BY_TEMPLATE;
        private final Pattern UPDATE_BY_TEMPLATE;
        private static final String LIMITING_QUERY_PATTERN = "(First|Top)(\\d*)?";
        private final Pattern LIMITED_QUERY_TEMPLATE;
        private final Pattern SUBJECT_PATTERN;
        private final String prefix;
        private final String myExpression;
        private final boolean distinct;
        private final boolean exists;
        private final boolean count;
        private final boolean delete;
        private final boolean update;
        private final Integer maxResults;

        public Subject(String subject) {
            this.EXISTS_BY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.existsPattern() + ")(\\p{Lu}.*?)??By");
            this.DELETE_BY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.deletePattern() + ")(\\p{Lu}.*?)??By");
            this.UPDATE_BY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.updatePattern() + ")(\\p{Lu}.*?)??By");
            this.LIMITED_QUERY_TEMPLATE = Pattern.compile("^(" + PartTree.this.myParserContext.queryPattern() + ")(Distinct)?(First|Top)(\\d*)?(\\p{Lu}.*?)??By");
            this.SUBJECT_PATTERN = Pattern.compile("^(" + String.join((CharSequence)"|", PartTree.this.myParserContext.queryPattern(), PartTree.this.myParserContext.updatePattern(), PartTree.this.myParserContext.countPattern(), PartTree.this.myParserContext.deletePattern(), PartTree.this.myParserContext.existsPattern()) + ")(\\p{Lu}.*?)??By");
            this.myExpression = subject;
            this.distinct = subject != null && subject.contains(DISTINCT);
            this.count = Subject.matches(subject, this.COUNT_BY_TEMPLATE);
            this.delete = Subject.matches(subject, this.DELETE_BY_TEMPLATE);
            this.exists = Subject.matches(subject, this.EXISTS_BY_TEMPLATE);
            this.update = Subject.matches(subject, this.UPDATE_BY_TEMPLATE);
            this.maxResults = this.returnMaxResultsIfFirstKSubjectOrNull(subject);
            this.prefix = this.findPrefix(subject);
        }

        private String findPrefix(String subject) {
            if (subject == null) {
                return null;
            }
            Matcher matcher = this.SUBJECT_PATTERN.matcher(subject);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        private Integer returnMaxResultsIfFirstKSubjectOrNull(String subject) {
            if (subject == null) {
                return null;
            }
            Matcher grp = this.LIMITED_QUERY_TEMPLATE.matcher(subject);
            if (!grp.find()) {
                return null;
            }
            return StringUtil.isNotEmpty((String)grp.group(4)) ? Integer.parseInt(grp.group(4)) : 1;
        }

        public Boolean isDelete() {
            return this.delete;
        }

        public Boolean isUpdate() {
            return this.update;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isExistsProjection() {
            return this.exists;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        private static boolean matches(String subject, Pattern pattern) {
            return subject != null && pattern.matcher(subject).find();
        }

        public String getExpression() {
            return this.myExpression;
        }

        public String toString() {
            return "SUBJECT ('" + this.myExpression + ")";
        }
    }

    private class Predicate {
        private final Pattern ALL_IGNORE_CASE;
        private static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes;
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;
        private final List<Suffix> suffixes;

        Predicate(@NotNull String predicate, @NotNull PsiClass domainClass, PartTreeParserContext parserContext) {
            if (predicate == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(1);
            }
            if (parserContext == null) {
                Predicate.$$$reportNull$$$0(2);
            }
            this.ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
            this.nodes = new ArrayList<OrPart>();
            this.suffixes = new ArrayList<Suffix>();
            String text = this.splitSuffixes(predicate, parserContext);
            String[] parts = PartTree.this.split(this.detectAndSetAllIgnoreCase(text), ORDER_BY);
            if (parts.length > 2) {
                // empty if block
            }
            this.buildTree(parts[0], domainClass);
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1], domainClass, parserContext) : null;
        }

        private String splitSuffixes(String predicate, @NotNull PartTreeParserContext parserContext) {
            if (parserContext == null) {
                Predicate.$$$reportNull$$$0(3);
            }
            for (String suffix : parserContext.suffixes()) {
                String[] parts = PartTree.this.split(this.detectAndSetAllIgnoreCase(predicate), suffix);
                if (parts.length != 2) continue;
                this.suffixes.add(new Suffix(suffix));
                predicate = parts[0];
            }
            return predicate;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = this.ALL_IGNORE_CASE.matcher((CharSequence)predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = ((String)predicate).substring(0, matcher.start()) + ((String)predicate).substring(matcher.end());
            }
            return predicate;
        }

        private void buildTree(@NotNull String source, @NotNull PsiClass domainClass) {
            String[] split;
            if (source == null) {
                Predicate.$$$reportNull$$$0(4);
            }
            if (domainClass == null) {
                Predicate.$$$reportNull$$$0(5);
            }
            for (String part : split = PartTree.this.split(source, "Or")) {
                this.nodes.add(new OrPart(PartTree.this, part, domainClass, this.alwaysIgnoreCase));
            }
        }

        public Iterator<OrPart> iterator() {
            return this.nodes.iterator();
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }

        public List<Suffix> getSuffixes() {
            return this.suffixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domainClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parserContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javaee/utils/persistence/data/parser/PartTree$Predicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "splitSuffixes";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class OrPart
    implements Iterable<Part> {
        private final List<Part> children;
        private final String mySource;

        OrPart(@NotNull PartTree this$0, String source, PsiClass domainClass, boolean alwaysIgnoreCase) {
            String[] split;
            if (source == null) {
                OrPart.$$$reportNull$$$0(0);
            }
            this.children = new ArrayList<Part>();
            this.mySource = source;
            for (String part : split = this$0.split(source, "And")) {
                this.children.add(new Part(part, domainClass, alwaysIgnoreCase, this$0.myParserContext));
            }
        }

        @Override
        public Iterator<Part> iterator() {
            return this.children.iterator();
        }

        public String toString() {
            return "OR ('" + this.mySource + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/utils/persistence/data/parser/PartTree$OrPart", "<init>"));
        }
    }
}

