/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution.update;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredByFileTypeCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final CompileScope myDelegate;
    private final FileType[] myExcludedFileTypes;
    private final FileTypeManager myFileTypeManager;

    public FilteredByFileTypeCompileScope(CompileScope delegate, FileType ... excludedFileTypes) {
        this.myDelegate = delegate;
        this.myExcludedFileTypes = excludedFileTypes;
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public VirtualFile @NotNull [] getFiles(@Nullable FileType fileType, boolean inSourceOnly) {
        VirtualFile[] files = this.myDelegate.getFiles(fileType, inSourceOnly);
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (ArrayUtil.contains((Object)file.getFileType(), (Object[])this.myExcludedFileTypes)) continue;
            filtered.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(filtered);
        if (virtualFileArray == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    public boolean belongs(@NotNull String url) {
        String name;
        if (url == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(1);
        }
        return !ArrayUtil.contains((Object)this.myFileTypeManager.getFileTypeByFileName(name = url.substring(url.lastIndexOf(47) + 1)), (Object[])this.myExcludedFileTypes) && this.myDelegate.belongs(url);
    }

    public Module @NotNull [] getAffectedModules() {
        Module[] moduleArray = this.myDelegate.getAffectedModules();
        if (moduleArray == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(2);
        }
        return moduleArray;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        Collection collection = this.myDelegate.getAffectedUnloadedModules();
        if (collection == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        Object data;
        if (key == null) {
            FilteredByFileTypeCompileScope.$$$reportNull$$$0(4);
        }
        if ((data = this.myDelegate.getUserData(key)) != null) {
            return (T)data;
        }
        return (T)super.getUserData(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/run/execution/update/FilteredByFileTypeCompileScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/run/execution/update/FilteredByFileTypeCompileScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4 -> new IllegalArgumentException(string);
        };
    }
}

