/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.generation.ActionScriptEventDispatchUtils;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.BindablePropertiesForm;
import com.intellij.lang.javascript.generation.EventBinder;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptGenerateAccessorHandler
extends BaseJSGenerateHandler {
    public static final String FLASH_EVENT_FQN = "flash.events.Event";
    public static final String PARAMETER_NAME = "value";
    private static final char M = 'M';
    private final JSGetterSetterGenerationMode myMode;
    private JCheckBox myMakePrivate;
    private BindablePropertiesForm myBindablePropertiesForm;

    public JavaScriptGenerateAccessorHandler(JSGetterSetterGenerationMode mode, boolean skipMemberChooserDialog) {
        super(skipMemberChooserDialog);
        this.myMode = mode;
    }

    public JavaScriptGenerateAccessorHandler(JSGetterSetterGenerationMode mode) {
        this.myMode = mode;
    }

    @Override
    protected String getTitle() {
        return this.myMode == JSGetterSetterGenerationMode.Getter ? CodeInsightBundle.message((String)"generate.getter.fields.chooser.title", (Object[])new Object[0]) : (this.myMode == JSGetterSetterGenerationMode.Setter ? CodeInsightBundle.message((String)"generate.setter.fields.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"generate.getter.setter.title", (Object[])new Object[0]));
    }

    @Override
    @NlsContexts.HintText
    @NotNull
    protected String getNoCandidatesMessage() {
        String string = this.myMode == JSGetterSetterGenerationMode.Getter ? JavaScriptBundle.message((String)"no.variables.for.getter", (Object[])new Object[0]) : (this.myMode == JSGetterSetterGenerationMode.Setter ? JavaScriptBundle.message((String)"no.variables.for.setter", (Object[])new Object[0]) : JavaScriptBundle.message((String)"no.variables.for.getter.setter", (Object[])new Object[0]));
        if (string == null) {
            JavaScriptGenerateAccessorHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected JComponent getOptionsComponent(PsiElement jsClass, Collection<JSChooserElementNode> candidates) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            for (JSChooserElementNode candidate : candidates) {
                JSAttributeList attrList;
                PsiElement element2 = candidate.getPsiElement();
                if (!(element2 instanceof JSVariable) || (attrList = ((JSVariable)element2).getAttributeList()) != null && attrList.getAccessType() == JSAttributeList.AccessType.PRIVATE) continue;
                this.myMakePrivate = new JCheckBox(JavaScriptBundle.message((String)"make.private", (Object[])new Object[0]), true);
                this.myMakePrivate.setFocusable(false);
                this.myMakePrivate.setMnemonic('M');
                break;
            }
            if (jsClass instanceof JSClass && ActionScriptEventDispatchUtils.isEventDispatcher((JSClass)jsClass)) {
                this.myBindablePropertiesForm = new BindablePropertiesForm(jsClass.getProject(), this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter);
                if (this.myMakePrivate != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)this.myBindablePropertiesForm.getMainPanel(), "Center");
                    panel.add((Component)this.myMakePrivate, "South");
                    return panel;
                }
                return this.myBindablePropertiesForm.getMainPanel();
            }
        }
        return this.myMakePrivate;
    }

    @Override
    protected BaseCreateMembersFix<JSNamedElement> createFix(final PsiElement jsClass) {
        boolean makePrivate;
        final EventBinder eventBinder = ApplicationManager.getApplication().isUnitTestMode() ? ActionScriptEventDispatchUtils.createTestEventBinder((JSClass)jsClass) : this.myBindablePropertiesForm;
        boolean bl = makePrivate = this.myMakePrivate == null || this.myMakePrivate.isSelected();
        if (this.myMode == JSGetterSetterGenerationMode.GetterAndSetter) {
            return new BaseCreateMembersFix<JSNamedElement>(this, jsClass){
                final MyBaseCreateMethodsFix generateGetterFix;
                final MyBaseCreateMethodsFix generateSetterFix;
                {
                    super(jsClass2);
                    this.generateGetterFix = new MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Getter, (JSClass)jsClass, eventBinder, makePrivate, null);
                    this.generateSetterFix = new MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Setter, (JSClass)jsClass, eventBinder, makePrivate, null);
                }

                @Override
                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.evalAnchor(editor, file);
                    for (JSNamedElement e : this.getElementsToProcess()) {
                        this.generateGetterFix.fixName(e);
                        this.anchor = this.doAddOneMethod(project, this.generateGetterFix.buildFunctionText(e, null), this.anchor);
                        this.anchor = this.doAddOneMethod(project, this.generateSetterFix.buildFunctionText(e, null), this.anchor);
                    }
                    this.generateSetterFix.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$1", "invoke"));
                }
            };
        }
        return new MyBaseCreateMethodsFix(this.myMode, (JSClass)jsClass, eventBinder, makePrivate, null);
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        boolean skipVarsThatHaveGetters = this.myMode == JSGetterSetterGenerationMode.Getter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter;
        boolean skipVarsThatHaveSetters = this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter;
        JavaScriptGenerateAccessorHandler.collectJSVariables(clazz, candidates, skipVarsThatHaveGetters, skipVarsThatHaveSetters, false, !(clazz instanceof ES6Class), true, this.myMode != JSGetterSetterGenerationMode.Getter, true);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass);
    }

    private static boolean equalsIgnoreQuotes(String newName, String varName) {
        if (newName == null || varName == null) {
            return false;
        }
        if (newName.equals(varName)) {
            return true;
        }
        if ((newName.startsWith("'") || newName.startsWith("\"")) && (varName.startsWith("'") || varName.startsWith("\""))) {
            return newName.substring(1, newName.length() - 1).equals(varName.substring(1, varName.length() - 1));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler", "getNoCandidatesMessage"));
    }

    public static class MyBaseCreateMethodsFix
    extends BaseCreateMembersFix<JSNamedElement> {
        private static final Key<String> ACCESSOR_NAME = Key.create((String)"JavaScript.Accessor.Forced.Name");
        private static final Key<String> INNER_FIELD_NAME = Key.create((String)"JavaScript.Accessor.Forced.Inner.Name");
        private final JSGetterSetterGenerationMode myMode;
        @Nullable
        private final EventBinder myEventBinder;
        private final boolean myMakePrivate;
        private final JSCodeStyleSettings codeStyleSettings;
        @Nullable
        private final String myQualifier;

        public MyBaseCreateMethodsFix(JSGetterSetterGenerationMode mode, JSClass jsClass, @Nullable EventBinder eventBinder, boolean makePrivate, @Nullable String qualifier) {
            super((PsiElement)jsClass);
            this.myMode = mode;
            this.myEventBinder = eventBinder;
            this.myMakePrivate = makePrivate;
            if (qualifier == null) {
                qualifier = JSClassUtils.getDefaultFieldQualifier((PsiElement)jsClass, (boolean)false);
            }
            this.myQualifier = qualifier;
            this.codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)jsClass);
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(0);
            }
            super.invoke(project, editor, file);
            this.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
        }

        private void createEventConstantAndImportEventIfNeeded(Project project, Editor editor, PsiElement importContext, Collection<JSNamedElement> variables) {
            if ((this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter) && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                ImportUtils.importAndShortenReference(JavaScriptGenerateAccessorHandler.FLASH_EVENT_FQN, importContext, true, false);
                if (this.myEventBinder.isCreateEventConstant()) {
                    this.createEventConstant(project, editor, variables);
                }
            }
        }

        private void createEventConstant(final Project project, final Editor editor, Collection<JSNamedElement> variables) {
            assert (this.myEventBinder != null);
            ArrayList<Pair> varNameAndAccessorNameList = new ArrayList<Pair>(variables.size());
            for (JSNamedElement variable : variables) {
                varNameAndAccessorNameList.add(Pair.create((Object)variable.getName(), (Object)this.buildName(variable)));
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            for (Pair varNameAndAccessorName : varNameAndAccessorNameList) {
                JSFunction jsFunction;
                PsiElement eventConstantIdentifier;
                String eventName = this.myEventBinder.getEventName((String)varNameAndAccessorName.first);
                String eventConstantName = this.myEventBinder.getEventConstantName((String)varNameAndAccessorName.first);
                if (this.myJsClass instanceof XmlBackedJSClassImpl) {
                    ((XmlBackedJSClassImpl)this.myJsClass).clearCaches();
                }
                if ((eventConstantIdentifier = MyBaseCreateMethodsFix.findEventConstantIdentifier((PsiElement)(jsFunction = ((JSClass)this.myJsClass).findFunctionByNameAndKind((String)varNameAndAccessorName.second, JSFunction.FunctionKind.SETTER)), eventConstantName)) == null || !eventConstantIdentifier.isValid()) continue;
                final String constantDeclaration = MessageFormat.format("public static const {0}:String = \"{1}\";", eventConstantName, eventName);
                new CreateJSVariableIntentionAction(this, eventConstantName, true, true, false){

                    @Override
                    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
                        if (anchorParent == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        template.addTextSegment(constantDeclaration);
                    }

                    public void apply(PsiElement psiElement) {
                        this.applyFix(project, psiElement, psiElement.getContainingFile(), editor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorParent", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix$1", "buildTemplate"));
                    }
                }.apply(eventConstantIdentifier);
            }
        }

        @Override
        protected boolean shouldHandleNoTypeAsAnyType() {
            return true;
        }

        private static PsiElement findEventConstantIdentifier(PsiElement psiElement, final String eventConstantName) {
            final Ref elementRef = new Ref();
            PsiTreeUtil.processElements((PsiElement)psiElement, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element2 instanceof JSReferenceExpression && element2.getText().equals(eventConstantName)) {
                        elementRef.set((Object)element2);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix$2", "execute"));
                }
            });
            return (PsiElement)elementRef.get();
        }

        @Override
        protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSNamedElement func) {
            String semicolon = this.codeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
            String innerFieldName = (String)func.getUserData(INNER_FIELD_NAME);
            String varName = innerFieldName != null ? innerFieldName : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)func, (boolean)false);
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                String checkNeedEvent = null;
                String dispatchEvent = null;
                if (this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                    Object quotedEventNameOrConstant = this.myEventBinder.isCreateEventConstant() ? this.myEventBinder.getEventConstantName(varName) : "\"" + this.myEventBinder.getEventName(varName) + "\"";
                    dispatchEvent = "\ndispatchEvent(new Event(" + (String)quotedEventNameOrConstant + "))" + semicolon;
                    checkNeedEvent = "if(" + varName + "==value) return" + semicolon + "\n";
                }
                return new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myJsClass, StringUtil.notNullize((String)varName)).setter().setQualifier(this.myQualifier).setNamedElement(func).setBeforeText(checkNeedEvent).setAfterText(dispatchEvent).generate();
            }
            if (this.myMode == JSGetterSetterGenerationMode.Getter) {
                return new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myJsClass, StringUtil.notNullize((String)varName)).setQualifier(this.myQualifier).setNamedElement(func).generate();
            }
            return " {}";
        }

        @Override
        protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSNamedElement function) {
            JSAttributeList.AccessType accessType;
            JSAttributeList list;
            String accessorName;
            JSFunction pairAccessor;
            attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
            attributeListWrapper.removeOriginalAttributes();
            if (!(DialectDetector.isActionScript((PsiElement)function) || DialectDetector.isTypeScript((PsiElement)function) && function instanceof TypeScriptField)) {
                attributeListWrapper.removeAccessModifier();
            }
            if (this.myMode == JSGetterSetterGenerationMode.Getter && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                attributeListWrapper.addAttribute("Bindable", "event", this.myEventBinder.getEventName(function.getName()));
            }
            if ((this.myMode == JSGetterSetterGenerationMode.Getter || this.myMode == JSGetterSetterGenerationMode.Setter) && this.myJsClass instanceof JSClass && (pairAccessor = ((JSClass)this.myJsClass).findFunctionByNameAndKind(accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)function.getName(), (JSCodeStyleSettings)this.codeStyleSettings), this.myMode == JSGetterSetterGenerationMode.Getter ? JSFunction.FunctionKind.SETTER : JSFunction.FunctionKind.GETTER)) != null && (list = pairAccessor.getAttributeList()) != null && (accessType = list.getAccessType()) != JSAttributeList.AccessType.PUBLIC) {
                attributeListWrapper.overrideAccessType(accessType);
            }
        }

        @Override
        protected String buildFunctionKind(JSNamedElement fun) {
            if (this.myMode == JSGetterSetterGenerationMode.Getter) {
                return "get ";
            }
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                return "set ";
            }
            return super.buildFunctionKind(fun);
        }

        @Override
        protected String buildReturnType(String typeString) {
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                return DialectDetector.isActionScript((PsiElement)this.myJsClass) ? "void" : null;
            }
            return super.buildReturnType(typeString);
        }

        private void findOrCreateConstructorPropertyBindVariable(@NotNull JSParameter parameter) {
            JSSourceElement[] body;
            String parameterName;
            if (parameter == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(1);
            }
            if ((parameterName = parameter.getName()) == null) {
                return;
            }
            String accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)parameterName, (JSCodeStyleSettings)this.codeStyleSettings);
            parameter.putUserData(ACCESSOR_NAME, (Object)accessorName);
            if (DialectDetector.isTypeScript((PsiElement)parameter)) {
                if (accessorName.equals(parameterName)) {
                    this.renameVariable((JSNamedElement)parameter, parameterName);
                }
                return;
            }
            JSFunction function = parameter.getDeclaringFunction();
            String innerFieldName = this.codeStyleSettings.FIELD_PREFIX + accessorName;
            parameter.putUserData(INNER_FIELD_NAME, (Object)innerFieldName);
            String nameAccess = StringUtil.notNullize((String)JSClassUtils.getDefaultFieldQualifier((PsiElement)function, (boolean)true)) + innerFieldName;
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
            if (block == null) {
                return;
            }
            for (JSSourceElement element2 : body = block.getStatementListItems()) {
                JSReferenceExpression reference;
                JSExpression jSExpression;
                JSAssignmentExpression assignment;
                JSDefinitionExpression definitionExpression;
                JSExpression jSExpression2;
                if (!(element2 instanceof JSExpressionStatement) || !((jSExpression2 = ((JSExpressionStatement)element2).getExpression()) instanceof JSAssignmentExpression) || (definitionExpression = (assignment = (JSAssignmentExpression)jSExpression2).getDefinitionExpression()) == null || !((jSExpression = definitionExpression.getExpression()) instanceof JSReferenceExpression) || !((reference = (JSReferenceExpression)jSExpression).getQualifier() instanceof JSThisExpression) || !parameterName.equals(JSPsiImplUtils.getInitializerReference((JSInitializerOwner)definitionExpression, (boolean)true))) continue;
                if (innerFieldName.equals(definitionExpression.getName())) {
                    return;
                }
                if (!parameterName.equals(definitionExpression.getName())) continue;
                this.renameInnerPropUsages(reference, innerFieldName);
                block.deleteChildRange((PsiElement)element2, (PsiElement)element2);
            }
            body = block.getStatementListItems();
            String assignmentText = nameAccess + "=" + parameterName + JSCodeStyleSettings.getSemicolon((PsiElement)function);
            JSStatement psiToInsert = JSPsiElementFactory.createJSStatement((String)assignmentText, (PsiElement)function);
            if (body.length == 0) {
                block.add((PsiElement)psiToInsert);
            } else {
                block.addAfter((PsiElement)psiToInsert, (PsiElement)body[body.length - 1]);
            }
        }

        private void renameInnerPropUsages(@NotNull JSReferenceExpression reference, @NotNull String newName) {
            PsiElement resolvedProperty;
            if (reference == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(3);
            }
            if (!((resolvedProperty = reference.resolve()) instanceof JSDefinitionExpression)) {
                return;
            }
            PsiElement dummy = ((JSDefinitionExpression)resolvedProperty.copy()).setName(newName);
            assert (dummy != null);
            for (PsiReference ref2 : ReferencesSearch.search((PsiElement)resolvedProperty, (SearchScope)GlobalSearchScope.fileScope((PsiFile)reference.getContainingFile())).findAll()) {
                if (JSResolveUtil.getClassOfContext((PsiElement)ref2.getElement()) != this.myJsClass || ref2.getElement() == reference) continue;
                ref2.bindToElement(dummy);
            }
        }

        private void renameInIndexAccessExpression(@NotNull JSDefinitionExpression definition) {
            if (definition == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(4);
            }
            if (!BaseJSGenerateHandler.indexedPropertyAccessCheck((JSNamedElementBase)definition, (PairProcessor<? super String, ? super String>)((PairProcessor)(existing, future) -> {
                definition.putUserData(INNER_FIELD_NAME, existing);
                definition.putUserData(ACCESSOR_NAME, future);
                return false;
            }))) {
                return;
            }
            definition.putUserData(ACCESSOR_NAME, (Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)definition, (boolean)false));
            JSExpression expression = definition.getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)expression;
                assert (reference.getQualifier() != null);
                JSReferenceExpression copy = (JSReferenceExpression)JSPsiElementFactory.createJSExpression((String)(reference.getQualifier().getText() + "." + this.codeStyleSettings.FIELD_PREFIX + String.valueOf(reference.getReferenceNameElement())), (PsiElement)expression, JSReferenceExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                reference.replace((JSExpression)copy);
            } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                String copyText;
                JSIndexedPropertyAccessExpression indexedAcc = (JSIndexedPropertyAccessExpression)expression;
                JSExpression indexed = indexedAcc.getIndexExpression();
                if (indexed instanceof JSLiteralExpression && ((JSLiteralExpression)indexed).isQuotedLiteral()) {
                    Convertor wrap = str -> this.codeStyleSettings.USE_DOUBLE_QUOTES ? "[\"" + str + "\"]" : "['" + str + "']";
                    String text = StringUtil.notNullize((String)((JSLiteralExpression)indexed).getStringValue());
                    if (text.startsWith("_")) {
                        definition.putUserData(ACCESSOR_NAME, (Object)((String)wrap.convert((Object)text.substring(1))));
                        definition.putUserData(INNER_FIELD_NAME, (Object)((String)wrap.convert((Object)text)));
                        return;
                    }
                    String innerPropText = (String)wrap.convert((Object)("_" + text));
                    definition.putUserData(INNER_FIELD_NAME, (Object)innerPropText);
                    definition.putUserData(ACCESSOR_NAME, (Object)((String)wrap.convert((Object)text)));
                    copyText = indexedAcc.getQualifier().getText() + innerPropText;
                } else {
                    String prefix = this.codeStyleSettings.USE_DOUBLE_QUOTES ? "\"_\"" : "'_'";
                    boolean parenthesis = !(indexed instanceof JSReferenceExpression);
                    Object innerText = parenthesis ? "(" + indexed.getText() + ")" : indexed.getText();
                    String newIndexed = prefix + " + " + (String)innerText;
                    copyText = indexedAcc.getQualifier().getText() + "[" + newIndexed + "]";
                }
                JSIndexedPropertyAccessExpression copy = (JSIndexedPropertyAccessExpression)JSPsiElementFactory.createJSExpression((String)copyText, (PsiElement)expression, JSIndexedPropertyAccessExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                indexedAcc.replace((JSExpression)copy);
            }
        }

        private void rebindUsages(@NotNull JSExpression copy, @NotNull JSExpression expression) {
            if (copy == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(5);
            }
            if (expression == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(6);
            }
            JSExpressionStatement definition = (JSExpressionStatement)JSPsiElementFactory.createJSStatement((String)(copy.getText() + "=1"), (PsiElement)expression, JSExpressionStatement.class);
            JSExpression assignment = definition.getExpression();
            assert (assignment instanceof JSAssignmentExpression);
            JSRefactoringUtil.rebindVariableUsages((PsiElement)expression, (PsiElement)((JSAssignmentExpression)assignment).getDefinitionExpression(), this.myJsClass);
        }

        @Override
        protected void fixName(JSNamedElement jsVariable) {
            String varName;
            if (jsVariable instanceof JSDefinitionExpression && ((JSDefinitionExpression)jsVariable).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                this.renameInIndexAccessExpression((JSDefinitionExpression)jsVariable);
                return;
            }
            if (jsVariable instanceof JSParameter && this.myJsClass instanceof ES6Class) {
                this.findOrCreateConstructorPropertyBindVariable((JSParameter)jsVariable);
                return;
            }
            String newName = JSFormatterUtil.transformVarNameToAccessorName((String)super.buildName(jsVariable), (JSCodeStyleSettings)this.codeStyleSettings);
            String variableName = jsVariable.getName();
            boolean isPrivateName = JSUtils.isPrivateSharpItem((PsiElement)jsVariable);
            String string = varName = variableName == null ? null : JSSymbolUtil.quoteIfSpecialPropertyName((String)variableName, (boolean)isPrivateName, (char)JSCodeStyleSettings.getQuoteChar((PsiElement)this.myJsClass));
            if (JavaScriptGenerateAccessorHandler.equalsIgnoreQuotes(newName, varName) && !this.codeStyleSettings.FIELD_PREFIX.isEmpty() && !varName.startsWith(this.codeStyleSettings.FIELD_PREFIX)) {
                this.renameVariable(jsVariable, varName);
            }
            if (this.myMakePrivate && jsVariable instanceof JSVariable && !(jsVariable instanceof JSParameter) && !JSUtils.isPrivateSharpItem((PsiElement)jsVariable)) {
                JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)jsVariable, JSAttributeList.AccessType.PRIVATE);
            }
        }

        private void renameVariable(JSNamedElement jsVariable, String varName) {
            this.renameVariable(jsVariable, varName, this.getNewFieldName(varName));
        }

        @NotNull
        private String getNewFieldName(String varName) {
            if (varName.startsWith("[") && varName.endsWith("]")) {
                String string = "[\"" + this.codeStyleSettings.FIELD_PREFIX + "\" + " + varName.substring(1, varName.length() - 1) + "]";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (varName.startsWith("\"") && varName.endsWith("\"")) {
                String string = "\"" + this.codeStyleSettings.FIELD_PREFIX + varName.substring(1, varName.length() - 1) + "\"";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (varName.startsWith("'") && varName.endsWith("'")) {
                String string = "'" + this.codeStyleSettings.FIELD_PREFIX + varName.substring(1, varName.length() - 1) + "'";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.codeStyleSettings.FIELD_PREFIX + varName;
            if (string == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        private void renameVariable(JSNamedElement jsVariable, String varName, String newVarName) {
            PsiElement copy = null;
            if (jsVariable instanceof JSParameter) {
                JSParameterList parameterList = (JSParameterList)jsVariable.getParent().copy();
                for (JSParameter element2 : parameterList.getParameterVariables()) {
                    if (!varName.equals(element2.getName())) continue;
                    copy = element2;
                    break;
                }
            } else if (jsVariable instanceof JSVariable) {
                JSVarStatement statementCopy = (JSVarStatement)jsVariable.getParent().copy();
                char quote = JSCodeStyleSettings.getQuoteChar((PsiElement)jsVariable);
                for (JSVariable variable : statementCopy.getVariables()) {
                    String name = variable.getName();
                    if (name == null || !varName.equals(JSSymbolUtil.quoteIfSpecialPropertyName((String)name, (boolean)JSUtils.isPrivateSharpItem((PsiElement)variable), (char)quote))) continue;
                    copy = variable;
                    break;
                }
            } else {
                copy = jsVariable.copy();
            }
            if (copy == null) {
                return;
            }
            ((JSNamedElement)copy).setName(newVarName);
            for (PsiReference ref2 : ReferencesSearch.search((PsiElement)jsVariable, (SearchScope)new LocalSearchScope(this.myJsClass)).findAll()) {
                if (JSResolveUtil.isSelfReference((PsiElement)ref2.getElement()) || !JSDefaultRenameProcessor.isStrictEnoughReference(ref2)) continue;
                ref2.handleElementRename(newVarName);
            }
            jsVariable.setName(newVarName);
        }

        @Override
        protected String buildName(JSNamedElement fun) {
            String accessorName = (String)fun.getUserData(ACCESSOR_NAME);
            if (accessorName != null) {
                return accessorName;
            }
            return JSFormatterUtil.transformVarNameToAccessorName((String)super.buildName(fun), (JSCodeStyleSettings)this.codeStyleSettings);
        }

        @Override
        protected String buildParameterList(JSParameterList parameterList, JSNamedElement fun, MultiMap<String, String> types2) {
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                String stringType = null;
                if (fun instanceof JSVariable) {
                    JSType type2 = ((JSVariable)fun).getJSType();
                    stringType = DialectDetector.isTypeScript((PsiElement)fun) ? MyBaseCreateMethodsFix.getProcessedType(type2, this.myJsClass, (PsiElement)fun) : JSTypeEvaluateManager.getBaseArrayType((String)this.getTypeString(type2, fun, types2));
                }
                return "(value" + (String)(stringType != null ? ":" + stringType : "") + ")";
            }
            return parameterList != null ? parameterList.getText() : "()";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copy";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewFieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateConstructorPropertyBindVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renameInnerPropUsages";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "renameInIndexAccessExpression";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "rebindUsages";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

