/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.validation.ES6AnalysisHandlersFactory;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.inspections.VueExprAnalysisHandlersFactoriesKt;
import org.jetbrains.vuejs.inspections.VueExprFunctionSignatureChecker;
import org.jetbrains.vuejs.lang.expr.parser.VueJSEmbeddedExpressionContentElementType;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterArgumentsList;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterExpression;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J \u0010\u000e\u001a\u00020\t\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\rH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/inspections/VueJSAnalysisHandlersFactory;", "Lcom/intellij/lang/ecmascript6/validation/ES6AnalysisHandlersFactory;", "<init>", "()V", "getFunctionSignatureChecker", "Lcom/intellij/lang/javascript/validation/JSFunctionSignatureChecker;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "typeChecker", "Lcom/intellij/lang/javascript/validation/JSTypeChecker;", "getReferenceChecker", "Lcom/intellij/lang/javascript/validation/JSReferenceChecker;", "reporter", "Lcom/intellij/lang/javascript/validation/JSProblemReporter;", "getTypeChecker", "T", "", "problemReporter", "intellij.vuejs.backend"})
public final class VueJSAnalysisHandlersFactory
extends ES6AnalysisHandlersFactory {
    @NotNull
    public JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull ProblemsHolder holder, @NotNull JSTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)typeChecker, (String)"typeChecker");
        return (JSFunctionSignatureChecker)new VueExprFunctionSignatureChecker(typeChecker, holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super($typeChecker);
            }

            protected boolean checkParameterLength(JSCallExpression node, JSFunctionItem function, JSExpression[] expressions, List<LocalQuickFix> fixes, Trinity<Integer, Integer, Boolean> minMaxParameters, int actualParameterLength) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)expressions, (String)"expressions");
                Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
                Intrinsics.checkNotNullParameter(minMaxParameters, (String)"minMaxParameters");
                if (node instanceof VueJSFilterExpression) {
                    return VueExprAnalysisHandlersFactoriesKt.access$checkFilterParameterLength(this, minMaxParameters, (VueJSFilterExpression)node, expressions, function, fixes);
                }
                return super.checkParameterLength(node, function, expressions, fixes, minMaxParameters, actualParameterLength);
            }

            protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
                VueJSFilterArgumentsList vueJSFilterArgumentsList;
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                VueJSFilterExpression vueJSFilterExpression = callExpression instanceof VueJSFilterExpression ? (VueJSFilterExpression)callExpression : null;
                PsiElement psiElement = vueJSFilterExpression != null && (vueJSFilterArgumentsList = vueJSFilterExpression.getFilterArgumentsList()) != null ? (PsiElement)vueJSFilterArgumentsList : ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, null);
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement place = psiElement;
                this.$holder.registerProblem(place, message, Arrays.copyOf(fixes, fixes.length));
            }

            public void registerProblem(JSCallExpression callExpression, String message, List<? extends LocalQuickFix> fixes) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.registerProblem(callExpression, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        };
    }

    @NotNull
    public JSReferenceChecker getReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        return new JSReferenceChecker(reporter){

            protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<? super LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
                Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
                return inTypeContext;
            }

            protected void addCreateFromUsageFixesForCall(JSReferenceExpression referenceExpression, boolean isNewExpression, ResolveResult[] resolveResults, List<? super LocalQuickFix> quickFixes) {
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
                Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
                if (referenceExpression instanceof VueJSFilterReferenceExpression) {
                    return;
                }
                LocalQuickFix localQuickFix = JSFixFactory.getInstance().renameReferenceFix();
                Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"renameReferenceFix(...)");
                quickFixes.add((LocalQuickFix)localQuickFix);
            }

            protected String createUnresolvedCallReferenceMessage(JSReferenceExpression methodExpression, boolean isNewExpression) {
                String string;
                Intrinsics.checkNotNullParameter((Object)methodExpression, (String)"methodExpression");
                if (methodExpression instanceof VueJSFilterReferenceExpression) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)((VueJSFilterReferenceExpression)methodExpression).getReferenceName());
                    string = VueBundle.message((String)"vue.inspection.message.unresolved.filter", (Object[])objectArray);
                } else {
                    String string2 = super.createUnresolvedCallReferenceMessage(methodExpression, isNewExpression);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createUnresolvedCallReferenceMessage(...)");
                }
                return string;
            }
        };
    }

    @NotNull
    public <T> JSTypeChecker getTypeChecker(@NotNull JSProblemReporter<T> problemReporter) {
        Intrinsics.checkNotNullParameter(problemReporter, (String)"problemReporter");
        return new JSTypeChecker(problemReporter){

            /*
             * WARNING - void declaration
             */
            protected JSType getExpressionType(JSExpression expr) {
                JSType jSType;
                JSType jSType2 = super.getExpressionType(expr);
                if (jSType2 != null) {
                    JSType jSType3 = jSType2;
                    JSExpression jSExpression = expr;
                    boolean condition$iv = (jSExpression != null && (jSExpression = jSExpression.getParent()) != null ? PsiTreeUtilKt.getElementType((PsiElement)jSExpression) : null) instanceof VueJSEmbeddedExpressionContentElementType;
                    boolean $i$f$applyIf = false;
                    if (condition$iv) {
                        void $this$applyIf$iv;
                        void $this$getExpressionType_u24lambda_u240 = $this$applyIf$iv;
                        boolean bl = false;
                        JSType jSType4 = $this$getExpressionType_u24lambda_u240.copyWithStrict(true);
                        jSType = jSType4;
                        Intrinsics.checkNotNullExpressionValue((Object)jSType4, (String)"copyWithStrict(...)");
                    } else {
                        jSType = jSType3;
                    }
                } else {
                    jSType = null;
                }
                return jSType;
            }
        };
    }
}

