/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.PermissionsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.FilePermissionsKt;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import com.intellij.platform.ide.core.permissions.impl.IdePermission;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessLevelMarkerKt;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.actions.ActionFilterProvider;
import com.jetbrains.rd.actions.BackendPermission;
import com.jetbrains.rd.ide.model.PermissionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a2\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e*\u00020\u000fH\u0002\"\u0016\u0010\u0010\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0016\u0010\u0013\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"toModel", "Lcom/jetbrains/rd/ide/model/PermissionModel;", "Lcom/intellij/platform/ide/core/permissions/Permission;", "fromModel", "getPermissions", "", "Lcom/intellij/openapi/actionSystem/Presentation;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionId", "", "getOldPermissionsOrFullAccess", "", "Lcom/jetbrains/rd/actions/AccessRequirements;", "terminalViewAccess", "getTerminalViewAccess", "()Lcom/intellij/platform/ide/core/permissions/Permission;", "fullTerminalAccess", "getFullTerminalAccess", "allIdePermissions", "getAllIdePermissions", "()Ljava/util/List;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\npermissionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 permissionUtils.kt\ncom/jetbrains/rd/actions/PermissionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n774#2:109\n865#2,2:110\n1#3:112\n*S KotlinDebug\n*F\n+ 1 permissionUtils.kt\ncom/jetbrains/rd/actions/PermissionUtilsKt\n*L\n50#1:109\n50#1:110,2\n*E\n"})
public final class PermissionUtilsKt {
    @ApiStatus.Internal
    @NotNull
    private static final Permission terminalViewAccess = (Permission)new IdePermission("ide.access.terminal");
    @ApiStatus.Internal
    @NotNull
    private static final Permission fullTerminalAccess = (Permission)new IdePermission("ide.access.terminal");
    @ApiStatus.Internal
    @NotNull
    private static final List<Permission> allIdePermissions;

    @NotNull
    public static final PermissionModel toModel(@NotNull Permission $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new PermissionModel($this$toModel.getId());
    }

    @NotNull
    public static final Permission fromModel(@NotNull PermissionModel $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        return new BackendPermission($this$fromModel.getId());
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public static final Collection<Permission> getPermissions(@NotNull Presentation $this$getPermissions, @NotNull ClientAppSession session, @Nullable AnAction action, @Nullable String actionId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getPermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!Registry.Companion.is("ide.permissions.api.enabled")) {
            return null;
        }
        List unsatisfiedPermissions = (List)$this$getPermissions.getClientProperty(ActionUtil.UNSATISFIED_PERMISSIONS);
        if (unsatisfiedPermissions != null || action == null) {
            return unsatisfiedPermissions;
        }
        if (!$this$getPermissions.isEnabled()) {
            return null;
        }
        if (action instanceof RequiresPermissions) {
            list = null;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PermissionUtilsKt.getOldPermissionsOrFullAccess(action, session, actionId);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Permission it = (Permission)element$iv$iv;
                boolean bl = false;
                if (!(!it.isGranted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = UtilKt.nullize((List)((List)destination$iv$iv));
        }
        List actionPermissions = list;
        return actionPermissions;
    }

    public static /* synthetic */ Collection getPermissions$default(Presentation presentation, ClientAppSession clientAppSession, AnAction anAction, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return PermissionUtilsKt.getPermissions(presentation, clientAppSession, anAction, string);
    }

    private static final Collection<Permission> getOldPermissionsOrFullAccess(AnAction $this$getOldPermissionsOrFullAccess, ClientAppSession session, String actionId) {
        String actionId2;
        String string = actionId;
        if (string == null) {
            string = ActionManager.getInstance().getId($this$getOldPermissionsOrFullAccess);
        }
        List<Permission> actionPermissions = (actionId2 = string) != null ? PermissionUtilsKt.getPermissions(ActionFilterProvider.Companion.getAccessRequirements(session, actionId2, $this$getOldPermissionsOrFullAccess)) : allIdePermissions;
        return actionPermissions;
    }

    private static final List<Permission> getPermissions(AccessRequirements $this$getPermissions) {
        Object v0;
        block8: {
            if (!($this$getPermissions instanceof AccessRequirements.Listed)) {
                return CollectionsKt.listOf((Object)PermissionsKt.getOwner());
            }
            if (((AccessRequirements.Listed)$this$getPermissions).getLevels().size() != 1) {
                return allIdePermissions;
            }
            Iterable iterable = ((AccessRequirements.Listed)$this$getPermissions).getLevels();
            for (Object t : iterable) {
                AccessLevelMarker it = (AccessLevelMarker)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)AccessLevelMarkerKt.getTypeName(it), (Object)"FileAccessLevel")) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        AccessLevelMarker accessLevelMarker = v0;
        if (accessLevelMarker == null) {
            return allIdePermissions;
        }
        AccessLevelMarker fileLevel = accessLevelMarker;
        return switch (fileLevel.getOrdinal()) {
            case 0 -> CollectionsKt.listOf((Object)FilePermissionsKt.getProjectFilesRead());
            case 1 -> CollectionsKt.listOf((Object)FilePermissionsKt.getProjectFilesWrite());
            default -> allIdePermissions;
        };
    }

    @NotNull
    public static final Permission getTerminalViewAccess() {
        return terminalViewAccess;
    }

    @NotNull
    public static final Permission getFullTerminalAccess() {
        return fullTerminalAccess;
    }

    @NotNull
    public static final List<Permission> getAllIdePermissions() {
        return allIdePermissions;
    }

    static {
        Object[] objectArray = new Permission[]{FilePermissionsKt.getProjectFilesRead(), com.intellij.execution.PermissionsKt.getRunViewAccess(), FilePermissionsKt.getProjectFilesWrite(), terminalViewAccess, fullTerminalAccess, com.intellij.execution.PermissionsKt.getFullRunAccess(), com.intellij.openapi.wm.PermissionsKt.getToolWindowViewAccess(), com.intellij.openapi.wm.PermissionsKt.getFullToolWindowAccess()};
        allIdePermissions = CollectionsKt.listOf((Object[])objectArray);
    }
}

