/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.ide.PbCompositeModificationTracker;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.annotation.PbAnnotator;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbExtensionRange;
import com.intellij.protobuf.lang.psi.PbExtensionsStatement;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbReservedRange;
import com.intellij.protobuf.lang.psi.PbReservedStatement;
import com.intellij.protobuf.lang.psi.PbStringValue;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoLiteral;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class MessageFieldTracker {
    private final Multimap<PbElement, ProblemAnnotation> queuedAnnotations = ArrayListMultimap.create();

    MessageFieldTracker() {
    }

    static void annotateField(PbField field, AnnotationHolder holder) {
        MessageFieldTracker.annotateElement(field, holder);
    }

    static void annotateReservedStatement(PbReservedStatement reservedStatement, AnnotationHolder holder) {
        MessageFieldTracker.annotateElement(reservedStatement, holder);
    }

    static void annotateExtensionsStatement(PbExtensionsStatement extensionsStatement, AnnotationHolder holder) {
        MessageFieldTracker.annotateElement(extensionsStatement, holder);
    }

    private static void annotateElement(PbElement element, AnnotationHolder holder) {
        PbMessageType messageType = (PbMessageType)PsiTreeUtil.getParentOfType((PsiElement)element, PbMessageType.class);
        if (messageType == null) {
            return;
        }
        MessageFieldTracker tracker = MessageFieldTracker.getTracker(messageType);
        Collection problems = tracker.queuedAnnotations.get((Object)element);
        for (ProblemAnnotation problem : problems) {
            holder.newAnnotation(HighlightSeverity.ERROR, problem.message).range(problem.annotationElement).create();
        }
    }

    private static MessageFieldTracker getTracker(PbMessageType messageType) {
        return (MessageFieldTracker)CachedValuesManager.getCachedValue((PsiElement)messageType, () -> {
            MessageFieldTracker tracker = new MessageFieldTracker();
            tracker.trackProblems(messageType);
            return CachedValueProvider.Result.create((Object)tracker, (Object[])new Object[]{PbCompositeModificationTracker.byElement(messageType)});
        });
    }

    private void trackProblems(PbMessageType messageType) {
        new ProblemsVisitor().visit(messageType);
    }

    private void queueError(PbElement element, PsiElement annotationElement, @InspectionMessage String message) {
        this.queuedAnnotations.put((Object)element, (Object)new ProblemAnnotation(annotationElement, message));
    }

    private static class ProblemAnnotation {
        final PsiElement annotationElement;
        final @InspectionMessage String message;

        ProblemAnnotation(PsiElement annotationElement, @InspectionMessage String message) {
            this.annotationElement = annotationElement;
            this.message = message;
        }
    }

    private final class ProblemsVisitor {
        private final RangeSet<Long> reservedFieldNumbers = TreeRangeSet.create();
        private final RangeSet<Long> extensionFieldNumbers = TreeRangeSet.create();
        private final Set<String> reservedNames = new HashSet<String>();
        private final Map<Long, String> fieldNumberToField = new HashMap<Long, String>();

        private ProblemsVisitor() {
        }

        void visit(PbMessageType messageType) {
            this.visitReserved(messageType);
            this.visitExtensions(messageType);
            this.visitFields(messageType);
        }

        private void visitReserved(PbMessageType messageType) {
            for (PbReservedStatement reservedStatement : messageType.getBody().getReservedStatementList()) {
                for (PbReservedRange pbReservedRange : reservedStatement.getReservedRangeList()) {
                    this.visitReservedRange(reservedStatement, pbReservedRange);
                }
                for (PbIdentifierValue pbIdentifierValue : reservedStatement.getIdentifierValueList()) {
                    if (messageType.getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition) {
                        this.visitReservedName(reservedStatement, pbIdentifierValue);
                        continue;
                    }
                    MessageFieldTracker.this.queueError(reservedStatement, pbIdentifierValue, PbLangBundle.message("editions.field.reserved.identifier", new Object[0]));
                }
                for (PbStringValue pbStringValue : reservedStatement.getStringValueList()) {
                    if (!(messageType.getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition)) {
                        this.visitReservedName(reservedStatement, pbStringValue);
                        continue;
                    }
                    MessageFieldTracker.this.queueError(reservedStatement, pbStringValue, PbLangBundle.message("editions.field.reserved.string", new Object[0]));
                }
            }
        }

        private void visitExtensions(PbMessageType messageType) {
            for (PbExtensionsStatement extensionsStatement : messageType.getBody().getExtensionsStatementList()) {
                for (PbExtensionRange extensionRange : extensionsStatement.getExtensionRangeList()) {
                    this.visitExtensionRange(extensionsStatement, extensionRange);
                }
            }
        }

        private void visitFields(PbMessageType messageType) {
            for (PbSymbol symbol : messageType.getSymbols()) {
                PbNumberValue fieldNumberValue;
                if (!(symbol instanceof PbField)) continue;
                PbField field = (PbField)symbol;
                String fieldName = field.getName();
                if (fieldName != null) {
                    this.visitFieldName(field, fieldName);
                }
                if ((fieldNumberValue = field.getFieldNumber()) == null) continue;
                this.visitFieldNumber(field, fieldName, fieldNumberValue);
            }
        }

        private void visitReservedRange(PbReservedStatement reservedStatement, PbReservedRange reservedRange) {
            Long from = reservedRange.getFrom();
            if (from == null) {
                return;
            }
            Long to = reservedRange.getTo();
            if (to == null) {
                to = from;
            }
            if (from <= 0L || to <= 0L) {
                MessageFieldTracker.this.queueError(reservedStatement, reservedRange, PbLangBundle.message("reserved.number.must.be.positive", new Object[0]));
                return;
            }
            if (to < from) {
                return;
            }
            Range newRange = Range.closed((Comparable)from, (Comparable)to);
            Optional<Range<Long>> overlappingRange = this.findPreviousOverlappingReservedRange((Range<Long>)newRange);
            if (overlappingRange.isPresent()) {
                MessageFieldTracker.this.queueError(reservedStatement, reservedRange, PbLangBundle.message("reserved.range.overlaps.existing", newRange.lowerEndpoint(), newRange.upperEndpoint(), overlappingRange.get().lowerEndpoint(), overlappingRange.get().upperEndpoint()));
                return;
            }
            this.reservedFieldNumbers.add(newRange);
        }

        private Optional<Range<Long>> findPreviousOverlappingReservedRange(Range<Long> newRange) {
            return ProblemsVisitor.findPreviousOverlappingRange(this.reservedFieldNumbers, newRange);
        }

        private Optional<Range<Long>> findPreviousOverlappingExtensionRange(Range<Long> newRange) {
            return ProblemsVisitor.findPreviousOverlappingRange(this.extensionFieldNumbers, newRange);
        }

        private static Optional<Range<Long>> findPreviousOverlappingRange(RangeSet<Long> ranges, Range<Long> newRange) {
            RangeSet intersection = ranges.subRangeSet(newRange);
            if (intersection.isEmpty()) {
                return Optional.empty();
            }
            return ranges.asRanges().stream().filter(range -> range.isConnected(newRange)).findFirst();
        }

        private void visitReservedName(PbReservedStatement reservedStatement, ProtoLiteral reservedName) {
            String name = reservedName.getAsString();
            if (!this.reservedNames.add(name)) {
                MessageFieldTracker.this.queueError(reservedStatement, reservedName, PbLangBundle.message("reserved.name.multiple.times", name));
            }
        }

        private void visitExtensionRange(PbExtensionsStatement extensionsStatement, PbExtensionRange extensionRange) {
            Long to;
            Long from = extensionRange.getFrom();
            if (from == null) {
                return;
            }
            Long declaredTo = extensionRange.getTo();
            Long l = to = declaredTo == null ? from : declaredTo;
            if (from <= 0L || to <= 0L) {
                MessageFieldTracker.this.queueError(extensionsStatement, extensionRange, PbLangBundle.message("extension.number.must.be.positive", new Object[0]));
                return;
            }
            if (declaredTo != null && to < from) {
                MessageFieldTracker.this.queueError(extensionsStatement, extensionRange, PbLangBundle.message("extension.end.greater.than.start", new Object[0]));
                return;
            }
            long max = extensionRange.getMaxValue();
            if (from > max || to > max) {
                MessageFieldTracker.this.queueError(extensionsStatement, extensionRange, PbLangBundle.message("extension.number.greater.than.max", max));
                return;
            }
            Range newRange = Range.closed((Comparable)from, (Comparable)to);
            Optional<Range<Long>> overlappingExtensionRange = this.findPreviousOverlappingExtensionRange((Range<Long>)newRange);
            if (overlappingExtensionRange.isPresent()) {
                MessageFieldTracker.this.queueError(extensionsStatement, extensionRange, PbLangBundle.message("extension.range.overlaps.existing", newRange.lowerEndpoint(), newRange.upperEndpoint(), overlappingExtensionRange.get().lowerEndpoint(), overlappingExtensionRange.get().upperEndpoint()));
                return;
            }
            Optional<Range<Long>> overlappingReservedRange = this.findPreviousOverlappingReservedRange((Range<Long>)newRange);
            if (overlappingReservedRange.isPresent()) {
                MessageFieldTracker.this.queueError(extensionsStatement, extensionRange, PbLangBundle.message("extension.range.overlaps.reserved.range", newRange.lowerEndpoint(), newRange.upperEndpoint(), overlappingReservedRange.get().lowerEndpoint(), overlappingReservedRange.get().upperEndpoint()));
                return;
            }
            this.extensionFieldNumbers.add(newRange);
        }

        private void visitFieldNumber(PbField field, String fieldName, PbNumberValue fieldNumberValue) {
            if (!fieldNumberValue.isValidInt32()) {
                MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("integer.value.out.of.range", new Object[0]));
                return;
            }
            long fieldNumber = (Long)Preconditions.checkNotNull((Object)fieldNumberValue.getLongValue());
            long maxFieldNumber = ProblemsVisitor.getMaxFieldNumber(field);
            if (fieldNumber <= 0L) {
                MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.number.must.be.positive", new Object[0]));
            } else if (PbField.NUMBERS_RESERVED_BY_PROTO.contains((Comparable)Long.valueOf(fieldNumber))) {
                MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.number.in.proto.reserved.range", PbField.NUMBERS_RESERVED_BY_PROTO.lowerEndpoint(), PbField.NUMBERS_RESERVED_BY_PROTO.upperEndpoint()));
            } else if (fieldNumber > maxFieldNumber) {
                MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.number.greater.than.max", 0x1FFFFFFFL));
            } else if (!field.isExtension()) {
                if (this.fieldNumberToField.containsKey(fieldNumber)) {
                    String earlierField = this.fieldNumberToField.get(fieldNumber);
                    MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.number.already.used", fieldNumber, earlierField));
                } else if (this.reservedFieldNumbers.contains((Comparable)Long.valueOf(fieldNumber))) {
                    MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.uses.reserved.number", fieldName, fieldNumber));
                } else if (this.extensionFieldNumbers.contains((Comparable)Long.valueOf(fieldNumber))) {
                    MessageFieldTracker.this.queueError(field, fieldNumberValue, PbLangBundle.message("field.uses.extension.number", fieldName, fieldNumber));
                }
            }
            if (!field.isExtension()) {
                this.fieldNumberToField.putIfAbsent(fieldNumber, fieldName);
            }
        }

        private void visitFieldName(PbField field, String fieldName) {
            if (field.getExtendee() != null) {
                return;
            }
            if (this.reservedNames.contains(fieldName)) {
                PsiElement annotationElement = PbAnnotator.getSymbolNameAnnotationElement(field);
                MessageFieldTracker.this.queueError(field, annotationElement, PbLangBundle.message("field.uses.reserved.name", fieldName));
            }
        }

        private static long getMaxFieldNumber(PbField field) {
            PbTypeName extendee = field.getExtendee();
            PbMessageType parent = extendee != null ? PbPsiUtil.resolveRefToType(extendee.getEffectiveReference(), PbMessageType.class) : (PbMessageType)PsiTreeUtil.getParentOfType((PsiElement)field, PbMessageType.class);
            if (parent != null && parent.isMessageSet()) {
                return 0x7FFFFFFEL;
            }
            return 0x1FFFFFFFL;
        }
    }
}

