/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\tH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"WSL_PREFIX", "", "getWSL_PREFIX", "()Ljava/lang/String;", "winPath2WslPath", "path", "isWindowsPath", "", "isWindowsDrive", "", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nwslUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 wslUtils.kt\ncom/intellij/docker/agent/util/WslUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n774#2:63\n865#2,2:64\n*S KotlinDebug\n*F\n+ 1 wslUtils.kt\ncom/intellij/docker/agent/util/WslUtilsKt\n*L\n11#1:63\n11#1:64,2\n*E\n"})
public final class WslUtilsKt {
    @NotNull
    private static final String WSL_PREFIX = Platform.INSTANCE.isWindows() && Platform.INSTANCE.isOsVersionAtLeast("11.0") ? "\\\\wsl.localhost\\" : "\\\\wsl$\\";

    @NotNull
    public static final String getWSL_PREFIX() {
        return WSL_PREFIX;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String winPath2WslPath(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String normalizedPath = InternalUtilsKt.toSystemIndependentName(path);
        if (WslUtilsKt.isWindowsPath(StringsKt.removePrefix((String)normalizedPath, (CharSequence)"/"))) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)normalizedPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List parts = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            String string = ((String)parts.remove(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String prefix = StringsKt.removeSuffix((String)string, (CharSequence)":") + "/";
            object = "/mnt/" + prefix + CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        } else {
            object = path;
        }
        return object;
    }

    private static final boolean isWindowsPath(String path) {
        boolean bl;
        if (path.length() >= 2 && path.charAt(1) == ':' && (path.length() == 2 || path.charAt(2) == '/') && WslUtilsKt.isWindowsDrive(path.charAt(0))) {
            return true;
        }
        if (Platform.INSTANCE.isWindows()) {
            if (path.length() >= 2 && path.charAt(1) == '/' && WslUtilsKt.isWindowsDrive(path.charAt(0))) {
                char c = path.charAt(0);
                String string = ":";
                String string2 = c + string;
                char c2 = path.charAt(1);
                String string3 = path.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return new File(string2 + c2 + string3).exists();
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWindowsDrive(char $this$isWindowsDrive) {
        boolean bl;
        if ('a' <= $this$isWindowsDrive) {
            if ($this$isWindowsDrive < '{') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('A' > $this$isWindowsDrive) return false;
        if ($this$isWindowsDrive >= '[') return false;
        return true;
    }
}

