/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.configurations;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemManager;
import com.intellij.platform.execution.frontend.split.configurations.DispatcherHolder;
import com.intellij.platform.execution.frontend.split.configurations.RunConfigurationOverProtocol;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationFactory;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationStubs;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationType;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientContextExecutionTargetHolder;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExecutionTargetProvider;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExternalRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.codeWithMe.model.CodeWithMeConfigurationFactoryModel;
import com.jetbrains.codeWithMe.model.CodeWithMeConfigurationTypeModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.ExecutionTargetModel;
import com.jetbrains.codeWithMe.model.StartHistoryStateModel;
import com.jetbrains.rd.framework.base.RdReactiveBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.services.IdeBackend;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010!\u001a\u00020 *\u0006\u0012\u0002\b\u00030\"H\u0082@\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "modelKeyToUniqueId", "Ljava/util/concurrent/ConcurrentHashMap;", "", "bindWithModel", "", "model", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationsModel;", "syncExecutionTargets", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "syncSelectedConfiguration", "syncRunConfigurations", "syncConfigurationTypes", "syncRunHistoryAndPinned", "adviseOnCurrentConfiguration", "getKeysByValue", "", "value", "getRemoteUniqueId", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isRunningOnHost", "", "isLocalChangeSafe", "Lcom/jetbrains/rd/util/reactive/IViewable;", "(Lcom/jetbrains/rd/util/reactive/IViewable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Listener", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,326:1\n536#2:327\n521#2,6:328\n126#3:334\n153#3,3:335\n13#4:338\n13#5:339\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost\n*L\n287#1:327\n287#1:328,6\n287#1:334\n287#1:335,3\n324#1:338\n324#1:339\n*E\n"})
public final class ThinClientRunConfigurationsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final ConcurrentHashMap<String, String> modelKeyToUniqueId;
    @NotNull
    private static final Logger logger;

    public ThinClientRunConfigurationsHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dispatcher = DispatcherHolder.Companion.getInstance().getDispatcher();
        this.modelKeyToUniqueId = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void bindWithModel(CodeWithMeRunConfigurationsModel model) {
        this.syncConfigurationTypes(model);
        this.syncRunConfigurations(model);
        this.adviseOnCurrentConfiguration(model);
        MessageBusConnection connection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null));
        this.syncSelectedConfiguration(connection, model);
        this.syncRunHistoryAndPinned(model, connection);
        this.syncExecutionTargets(connection, model);
    }

    private final void syncExecutionTargets(MessageBusConnection connection, CodeWithMeRunConfigurationsModel model) {
        Topic topic = ExecutionTargetManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> ThinClientRunConfigurationsHost.syncExecutionTargets$lambda$0(model, arg_0));
        CoroutineHelpersKt.adviseSuspend((ISource)((ISource)model.getActiveExecutionTarget()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<ExecutionTargetModel, Continuation<? super Unit>, Object>(this, model, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ExecutionTargetModel)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = activeTarget;
                        this.label = 1;
                        v0 = ThinClientRunConfigurationsHost.access$isLocalChangeSafe(this.this$0, (IViewable)this.$model.getActiveExecutionTarget(), (Continuation)this);
                        if (v0 == var12_3) {
                            return var12_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        v1 = ExecutionTargetManager.getInstance((Project)this.this$0.getProject());
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                        targetManager = v1;
                        target = ThinClientExecutionTargetProvider.Companion.convertModelToTarget((ExecutionTargetModel)activeTarget);
                        $this$service$iv = (ComponentManager)this.this$0.getProject();
                        $i$f$service = false;
                        serviceClass$iv = ThinClientContextExecutionTargetHolder.class;
                        v2 = $this$service$iv.getService(serviceClass$iv);
                        if (v2 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        contextHolder = (ThinClientContextExecutionTargetHolder)v2;
                        $this$service$iv = (KMutableProperty0)new MutablePropertyReference0Impl(contextHolder){

                            public Object get() {
                                return ((ThinClientContextExecutionTargetHolder)this.receiver).getCurrentTarget();
                            }

                            public void set(Object value) {
                                ((ThinClientContextExecutionTargetHolder)this.receiver).setCurrentTarget((ExecutionTarget)value);
                            }
                        };
                        value$iv = target;
                        $i$f$usingValue = false;
                        old$iv = $this$usingValue$iv.get();
                        try {
                            $this$usingValue$iv.set((Object)value$iv);
                            $i$a$-usingValue-ThinClientRunConfigurationsHost$syncExecutionTargets$2$2 = false;
                            targetManager.setActiveTarget(target);
                            var11_14 = Unit.INSTANCE;
                        }
                        finally {
                            $this$usingValue$iv.set(old$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ExecutionTargetModel p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)model.getExecutingConfigurations()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<IViewableMap.Event<String, ? extends Integer>, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ((Runnable)this.this$0.getProject().getMessageBus().syncPublisher(RunToolbarPopupKt.getVOID_EXECUTION_TOPIC())).run();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(IViewableMap.Event<String, Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
    }

    private final void syncSelectedConfiguration(MessageBusConnection connection, CodeWithMeRunConfigurationsModel model) {
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new RunManagerListener(this, model){
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
            }

            /*
             * WARNING - void declaration
             */
            public void runConfigurationSelected(RunnerAndConfigurationSettings settings) {
                String hostUniqueID;
                String uniqueID;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object object = RunManager.Companion.getInstanceIfCreated(this.this$0.getProject());
                RunManagerImpl runManagerImpl = object instanceof RunManagerImpl ? (RunManagerImpl)object : null;
                if (runManagerImpl == null) {
                    return;
                }
                RunManagerImpl runManager = runManagerImpl;
                object = runManager.getAllSettings();
                boolean $i$f$filter = false;
                String string = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                    boolean bl = false;
                    if (!(it != settings && ThinClientConfigurationStubs.INSTANCE.getStubOriginalId(it) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List otherStubs = (List)destination$iv$iv;
                runManager.removeConfigurations((Collection)otherStubs);
                if (ThinClientConfigurationStubs.INSTANCE.getStubOriginalId(settings) != null) {
                    return;
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
                String string2 = uniqueID = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getUniqueID() : null;
                if (string2 != null) {
                    string = string2;
                    ThinClientRunConfigurationsHost thinClientRunConfigurationsHost = this.this$0;
                    String it = string;
                    boolean bl = false;
                    v3 = (String)CollectionsKt.singleOrNull((List)ThinClientRunConfigurationsHost.access$getKeysByValue(thinClientRunConfigurationsHost, ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(thinClientRunConfigurationsHost), it));
                } else {
                    v3 = hostUniqueID = null;
                }
                if (settings != null && hostUniqueID == null) {
                    ThinClientRunConfigurationsHost.access$getLogger$cp().error("Failed to get a unique id from a run configuration, uniqueID = '" + uniqueID + "', hostUniqueID = '" + hostUniqueID + "'");
                }
                this.$model.getClientCurrentConfiguration().set(hostUniqueID);
            }

            public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                RunConfiguration runConfiguration = settings.getConfiguration();
                RunConfigurationOverProtocol runConfigurationOverProtocol = runConfiguration instanceof RunConfigurationOverProtocol ? (RunConfigurationOverProtocol)runConfiguration : null;
                if (runConfigurationOverProtocol == null || (runConfigurationOverProtocol = runConfigurationOverProtocol.getModel()) == null) {
                    return;
                }
                RunConfigurationOverProtocol configurationModel = runConfigurationOverProtocol;
                configurationModel.getRemove().fire((Object)Unit.INSTANCE);
            }
        });
    }

    private final void syncRunConfigurations(CodeWithMeRunConfigurationsModel model) {
        model.getRunConfigurations().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientRunConfigurationsHost.syncRunConfigurations$lambda$0(this, model, arg_0, arg_1, arg_2));
    }

    private final void syncConfigurationTypes(CodeWithMeRunConfigurationsModel model) {
        model.getConfigurationTypes().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientRunConfigurationsHost.syncConfigurationTypes$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final void syncRunHistoryAndPinned(CodeWithMeRunConfigurationsModel model, MessageBusConnection connection) {
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)model.getStartHistoryState()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<StartHistoryStateModel, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                StartHistoryStateModel startHistoryStateModel = (StartHistoryStateModel)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String it;
                        Collection collection;
                        Iterable $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        void stateModel;
                        RunConfigurationStartHistory.State state;
                        ResultKt.throwOnFailure((Object)$result);
                        RunConfigurationStartHistory.State $this$invokeSuspend_u24lambda_u240 = state = new RunConfigurationStartHistory.State();
                        boolean bl = false;
                        Iterable iterable = stateModel.getHistory();
                        RunConfigurationStartHistory.State state2 = $this$invokeSuspend_u24lambda_u240;
                        boolean $i$f$map = false;
                        void var10_9 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            String string = (String)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(new RunConfigurationStartHistory.Element(it));
                        }
                        state2.setHistory(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
                        $this$map$iv = stateModel.getPinned();
                        state2 = $this$invokeSuspend_u24lambda_u240;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (String)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(new RunConfigurationStartHistory.Element(it));
                        }
                        state2.setPinned(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
                        RunConfigurationStartHistory.State state3 = state;
                        RunConfigurationStartHistory.Companion.getInstance(this.this$0.getProject()).loadState(state3);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(StartHistoryStateModel p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
        Ref.BooleanRef localStateChange = new Ref.BooleanRef();
        connection.subscribe(RunConfigurationStartHistory.Companion.getTOPIC(), (Object)new RunConfigurationStartHistory.Listener(this, model, localStateChange){
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            final /* synthetic */ Ref.BooleanRef $localStateChange;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                this.$localStateChange = $localStateChange;
            }

            public void togglePin(RunnerAndConfigurationSettings setting) {
                Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
                ThinClientRunConfigurationsHost.access$syncRunHistoryAndPinned$withLocalChange(this.$localStateChange, () -> syncRunHistoryAndPinned.2.togglePin$lambda$0(setting, this.this$0, this.$model));
            }

            private static final Unit togglePin$lambda$0(RunnerAndConfigurationSettings $setting, ThinClientRunConfigurationsHost this$0, CodeWithMeRunConfigurationsModel $model) {
                String string = $setting.getUniqueID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueID(...)");
                String uniqueID = string;
                String hostUniqueID = (String)CollectionsKt.singleOrNull((List)ThinClientRunConfigurationsHost.access$getKeysByValue(this$0, ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this$0), uniqueID));
                if (hostUniqueID == null) {
                    ThinClientRunConfigurationsHost.access$getLogger$cp().error("Failed to get a unique id from a run configuration, uniqueID = '" + uniqueID + "'");
                } else {
                    IAsyncSignal iAsyncSignal = $model.getTogglePin();
                    String string2 = $setting.getUniqueID();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueID(...)");
                    iAsyncSignal.fire((Object)string2);
                }
                return Unit.INSTANCE;
            }
        });
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)model.getTogglePin()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, localStateChange, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ Ref.BooleanRef $localStateChange;
            {
                this.this$0 = $receiver;
                this.$localStateChange = $localStateChange;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                String string = (String)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void hostUniqueId;
                        ResultKt.throwOnFailure((Object)$result);
                        ThinClientRunConfigurationsHost.access$syncRunHistoryAndPinned$withLocalChange(this.$localStateChange, () -> syncRunHistoryAndPinned.3.invokeSuspend$lambda$0(this.this$0, (String)hostUniqueId));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ThinClientRunConfigurationsHost this$0, String $hostUniqueId) {
                Object v1;
                block3: {
                    String string = (String)ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this$0).get($hostUniqueId);
                    if (string == null) {
                        return Unit.INSTANCE;
                    }
                    String uniqueId = string;
                    Iterable iterable = RunManager.Companion.getInstance(this$0.getProject()).getAllSettings();
                    for (T t : iterable) {
                        RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getUniqueID(), (Object)uniqueId)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = v1;
                if (runnerAndConfigurationSettings == null) {
                    return Unit.INSTANCE;
                }
                RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
                RunConfigurationStartHistory.Companion.getInstance(this$0.getProject()).togglePin(settings);
                return Unit.INSTANCE;
            }
        }), (int)4, null);
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)model.getRegisterStartedConfiguration()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (String)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = (String)ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this.this$0).get(hostUniqueId);
                        if (v0 == null) {
                            return Unit.INSTANCE;
                        }
                        uniqueId = v0;
                        var5_4 = RunManager.Companion.getInstance(this.this$0.getProject()).getAllSettings();
                        var6_5 = var5_4.listIterator(var5_4.size());
                        while (var6_5.hasPrevious()) {
                            var7_6 = var6_5.previous();
                            it = (RunnerAndConfigurationSettings)var7_6;
                            $i$a$-findLast-ThinClientRunConfigurationsHost$syncRunHistoryAndPinned$4$settings$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getUniqueID(), (Object)uniqueId)) continue;
                            v1 = var7_6;
                            ** GOTO lbl21
                        }
                        v1 = null;
lbl21:
                        // 2 sources

                        v2 = v1;
                        if (v2 == null) {
                            return Unit.INSTANCE;
                        }
                        settings = v2;
                        RunConfigurationStartHistory.Companion.getInstance(this.this$0.getProject()).register(settings);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
    }

    private final void adviseOnCurrentConfiguration(CodeWithMeRunConfigurationsModel model) {
        if (!Intrinsics.areEqual((Object)RunManager.IS_RUN_MANAGER_INITIALIZED.get((UserDataHolder)this.project), (Object)true)) {
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, model, null){
                int label;
                final /* synthetic */ ThinClientRunConfigurationsHost this$0;
                final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
                {
                    this.this$0 = $receiver;
                    this.$model = $model;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ThinClientRunConfigurationsHost.access$adviseOnCurrentConfiguration(this.this$0, this.$model);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        CoroutineHelpersKt.adviseSuspend((ISource)((ISource)model.getClientCurrentConfiguration()), (Lifetime)this.getServiceLifetime(), (CoroutineContext)((CoroutineContext)this.dispatcher), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, model, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (String)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = modelConfigurationId;
                        this.label = 1;
                        v0 = ThinClientRunConfigurationsHost.access$isLocalChangeSafe(this.this$0, (IViewable)this.$model.getClientCurrentConfiguration(), (Continuation)this);
                        if (v0 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(this.this$0.getProject());
                        if (modelConfigurationId == null) {
                            runManagerImpl.setSelectedConfiguration(null);
                            return Unit.INSTANCE;
                        }
                        realUniqueId = (String)ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this.this$0).get(modelConfigurationId);
                        settings = null;
                        if (realUniqueId != null) {
                            ThinClientRunConfigurationsHost.access$getLogger$cp().info("Settings found for modelConfigurationId='" + (String)modelConfigurationId + "'");
                            settings = runManagerImpl.getConfigurationById(realUniqueId);
                            if (settings == null) {
                                ThinClientRunConfigurationsHost.access$getLogger$cp().error("Can't set new selected configuration: configuration with id = " + realUniqueId + " was not found");
                                return Unit.INSTANCE;
                            }
                        } else {
                            ThinClientRunConfigurationsHost.access$getLogger$cp().info("Settings for modelConfigurationId='" + (String)modelConfigurationId + "' are not found in unique id map, creating stub");
                            settings = ThinClientConfigurationStubs.INSTANCE.createAndAddStubSettings(runManagerImpl, this.this$0.getProject(), (String)modelConfigurationId);
                        }
                        runManagerImpl.setSelectedConfiguration(settings);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getKeysByValue(ConcurrentHashMap<String, String> $this$getKeysByValue, String value) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map $this$filter$iv = $this$getKeysByValue;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)value)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getRemoteUniqueId(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string = settings.getUniqueID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueID(...)");
        List<String> remoteIds = this.getKeysByValue(this.modelKeyToUniqueId, string);
        if (!(remoteIds.size() <= 1)) {
            boolean bl = false;
            String string2 = "More than one remote unique id correspond to " + settings + " (" + settings.getUniqueID() + "): [" + CollectionsKt.joinToString$default((Iterable)remoteIds, null, null, null, (int)0, null, null, (int)63, null) + "]";
            throw new IllegalStateException(string2.toString());
        }
        return (String)CollectionsKt.singleOrNull(remoteIds);
    }

    public final boolean isRunningOnHost(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string = this.getRemoteUniqueId(settings);
        if (string == null) {
            return false;
        }
        String hostId = string;
        CodeWithMeRunConfigurationsModel model = CodeWithMeRunConfigurationsModel_GeneratedKt.getCodeWithMeRunConfigurationsModel((Solution)IdeBackend.Companion.getInstance(this.project).getSolution());
        Integer n = (Integer)model.getExecutingConfigurations().get((Object)hostId);
        if (n == null) {
            return false;
        }
        int runCount = n;
        return runCount > 0;
    }

    /*
     * Unable to fully structure code
     */
    private final Object isLocalChangeSafe(IViewable<?> $this$isLocalChangeSafe, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isLocalChangeSafe.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ThinClientRunConfigurationsHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ThinClientRunConfigurationsHost.access$isLocalChangeSafe(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this$isLocalChangeSafe instanceof RdReactiveBase != false ? (RdReactiveBase)$this$isLocalChangeSafe : null;
                v1 = v0 != null ? v0.isLocalChange() : false;
                if (v1) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$isLocalChangeSafe);
                $continuation.label = 1;
                v2 = YieldKt.yield((Continuation)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                $this$isLocalChangeSafe = (IViewable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl26:
                // 2 sources

                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void syncExecutionTargets$lambda$0(CodeWithMeRunConfigurationsModel $model, ExecutionTarget newTarget) {
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        IOptProperty iOptProperty = $model.getActiveExecutionTarget();
        String string = newTarget.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = newTarget.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        iOptProperty.set((Object)new ExecutionTargetModel(string, string2));
    }

    private static final Unit syncRunConfigurations$lambda$0(ThinClientRunConfigurationsHost this$0, CodeWithMeRunConfigurationsModel $model, Lifetime runConfigurationLifetime, String modelUniqueId, CodeWithMeRunConfigurationModel configurationModel) {
        Intrinsics.checkNotNullParameter((Object)runConfigurationLifetime, (String)"runConfigurationLifetime");
        Intrinsics.checkNotNullParameter((Object)modelUniqueId, (String)"modelUniqueId");
        Intrinsics.checkNotNullParameter((Object)configurationModel, (String)"configurationModel");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)runConfigurationLifetime, (CoroutineContext)((CoroutineContext)this$0.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($model, configurationModel, this$0, runConfigurationLifetime, modelUniqueId, null){
            int label;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            final /* synthetic */ CodeWithMeRunConfigurationModel $configurationModel;
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ Lifetime $runConfigurationLifetime;
            final /* synthetic */ String $modelUniqueId;
            {
                this.$model = $model;
                this.$configurationModel = $configurationModel;
                this.this$0 = $receiver;
                this.$runConfigurationLifetime = $runConfigurationLifetime;
                this.$modelUniqueId = $modelUniqueId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        typeModel = (CodeWithMeConfigurationTypeModel)this.$model.getConfigurationTypes().get((Object)this.$configurationModel.getTypeId());
                        if (typeModel == null) {
                            ThinClientRunConfigurationsHost.access$getLogger$cp().error("ConfigurationType with id = " + this.$configurationModel.getTypeId() + " was not found (run configuration: " + this.$configurationModel.getName() + ", factory: " + this.$configurationModel.getFactoryId() + ")");
                            return Unit.INSTANCE;
                        }
                        v0 = factoryModels = (List)this.$model.getConfigurationFactories().get((Object)this.$configurationModel.getTypeId());
                        if (v0 == null) ** GOTO lbl24
                        var5_4 = v0;
                        var6_5 = this.$configurationModel;
                        var7_6 = var5_4;
                        for (T var9_8 : var7_6) {
                            it = (CodeWithMeConfigurationFactoryModel)var9_8;
                            $i$a$-find-ThinClientRunConfigurationsHost$syncRunConfigurations$1$1$factoryModel$1 = false;
                            if (!Intrinsics.areEqual((Object)var6_5.getFactoryId(), (Object)it.getId())) continue;
                            v1 = var9_8;
                            ** GOTO lbl22
                        }
                        v1 = null;
lbl22:
                        // 2 sources

                        v2 = v1;
                        ** GOTO lbl25
lbl24:
                        // 1 sources

                        v2 = factoryModel = null;
lbl25:
                        // 2 sources

                        if (factoryModel == null) {
                            ThinClientRunConfigurationsHost.access$getLogger$cp().error("ConfigurationFactory with id = " + this.$configurationModel.getFactoryId() + " was not found (run configuration: " + this.$configurationModel.getName() + ", type: " + this.$configurationModel.getTypeId() + ")");
                            return Unit.INSTANCE;
                        }
                        type = new ThinClientConfigurationType(typeModel);
                        factory = new ThinClientConfigurationFactory(type, factoryModel);
                        runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(this.this$0.getProject());
                        configuration /* !! */  = this.$configurationModel.isExternalSystem() != false ? new ThinClientExternalRunConfiguration(this.$runConfigurationLifetime, ThinClientExternalSystemManager.Companion.getSYSTEM_ID(), this.this$0.getProject(), factory, this.$configurationModel.getName(), type.getIcon(), this.$configurationModel) : new ThinClientRunConfiguration(this.$runConfigurationLifetime, this.this$0.getProject(), factory, this.$configurationModel);
                        var10_9 = new RunnerAndConfigurationSettingsImpl(runManagerImpl, (RunConfiguration)configuration /* !! */ , false, null, 12, null);
                        var11_11 = this.$configurationModel;
                        $this$invokeSuspend_u24lambda_u241 = var10_9;
                        $i$a$-apply-ThinClientRunConfigurationsHost$syncRunConfigurations$1$1$settings$1 = false;
                        $this$invokeSuspend_u24lambda_u241.setFolderName(var11_11.getFolderName());
                        $this$invokeSuspend_u24lambda_u241.setActivateToolWindowBeforeRun(var11_11.isActivateToolWindowBeforeRun());
                        $this$invokeSuspend_u24lambda_u241.setFocusToolWindowBeforeRun(var11_11.isFocusToolWindowBeforeRun());
                        settings = var10_9;
                        this.$runConfigurationLifetime.bracketIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost java.lang.String com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl com.intellij.execution.impl.RunManagerImpl ), ()Lkotlin/Unit;)((ThinClientRunConfigurationsHost)this.this$0, (String)this.$modelUniqueId, (RunnerAndConfigurationSettingsImpl)settings, (RunManagerImpl)runManagerImpl), (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost java.lang.String com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel com.intellij.execution.impl.RunManagerImpl com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl ), ()Lkotlin/Unit;)((ThinClientRunConfigurationsHost)this.this$0, (String)this.$modelUniqueId, (CodeWithMeRunConfigurationsModel)this.$model, (RunManagerImpl)runManagerImpl, (RunnerAndConfigurationSettingsImpl)settings));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$2(ThinClientRunConfigurationsHost this$0, String $modelUniqueId, RunnerAndConfigurationSettingsImpl $settings, RunManagerImpl $runManagerImpl) {
                ((Map)ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this$0)).put($modelUniqueId, $settings.getUniqueID());
                $runManagerImpl.addConfiguration((RunnerAndConfigurationSettings)$settings);
                String selectedStubId = ThinClientConfigurationStubs.INSTANCE.getStubOriginalId($runManagerImpl.getSelectedConfiguration());
                if (selectedStubId != null) {
                    $runManagerImpl.setSelectedConfiguration((RunnerAndConfigurationSettings)$settings);
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$3(ThinClientRunConfigurationsHost this$0, String $modelUniqueId, CodeWithMeRunConfigurationsModel $model, RunManagerImpl $runManagerImpl, RunnerAndConfigurationSettingsImpl $settings) {
                LifetimeCoroutineUtilKt.launch$default((Lifetime)ThinClientRunConfigurationsHost.access$getServiceLifetime(this$0), (CoroutineContext)((CoroutineContext)ThinClientRunConfigurationsHost.access$getDispatcher$p(this$0)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $modelUniqueId, $model, $runManagerImpl, $settings, null){
                    int label;
                    final /* synthetic */ ThinClientRunConfigurationsHost this$0;
                    final /* synthetic */ String $modelUniqueId;
                    final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
                    final /* synthetic */ RunManagerImpl $runManagerImpl;
                    final /* synthetic */ RunnerAndConfigurationSettingsImpl $settings;
                    {
                        this.this$0 = $receiver;
                        this.$modelUniqueId = $modelUniqueId;
                        this.$model = $model;
                        this.$runManagerImpl = $runManagerImpl;
                        this.$settings = $settings;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this.this$0).remove(this.$modelUniqueId);
                                if (Intrinsics.areEqual((Object)this.$model.getConfigurationIsChanging().getValueOrNull(), (Object)Boxing.boxBoolean((boolean)true))) {
                                    this.$runManagerImpl.setSelectedConfiguration(ThinClientConfigurationStubs.INSTANCE.createAndAddStubSettings(this.$runManagerImpl, this.this$0.getProject(), this.$modelUniqueId));
                                }
                                this.$runManagerImpl.removeConfiguration((RunnerAndConfigurationSettings)this.$settings);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return Unit.INSTANCE;
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit syncConfigurationTypes$lambda$0(ThinClientRunConfigurationsHost this$0, Lifetime configurationTypeLifetime, String string, CodeWithMeConfigurationTypeModel configurationTypeModel) {
        Intrinsics.checkNotNullParameter((Object)configurationTypeLifetime, (String)"configurationTypeLifetime");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)configurationTypeModel, (String)"configurationTypeModel");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)configurationTypeLifetime, (CoroutineContext)((CoroutineContext)this$0.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(configurationTypeLifetime, configurationTypeModel, null){
            int label;
            final /* synthetic */ Lifetime $configurationTypeLifetime;
            final /* synthetic */ CodeWithMeConfigurationTypeModel $configurationTypeModel;
            {
                this.$configurationTypeLifetime = $configurationTypeLifetime;
                this.$configurationTypeModel = $configurationTypeModel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        point = ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
                        v0 = point.getExtensionList();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getExtensionList(...)");
                        var3_3 = v0;
                        var4_4 = this.$configurationTypeModel;
                        var5_5 = var3_3;
                        for (T var7_7 : var5_5) {
                            it = (ConfigurationType)var7_7;
                            $i$a$-find-ThinClientRunConfigurationsHost$syncConfigurationTypes$1$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)var4_4.getId())) continue;
                            v1 = var7_7;
                            ** GOTO lbl19
                        }
                        v1 = null;
lbl19:
                        // 2 sources

                        if (v1 != null) {
                            return Unit.INSTANCE;
                        }
                        this.$configurationTypeLifetime.executeIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.openapi.extensions.ExtensionPoint com.jetbrains.codeWithMe.model.CodeWithMeConfigurationTypeModel com.jetbrains.rd.util.lifetime.Lifetime ), ()Lkotlin/Unit;)((ExtensionPoint)point, (CodeWithMeConfigurationTypeModel)this.$configurationTypeModel, (Lifetime)this.$configurationTypeLifetime));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$1(ExtensionPoint $point, CodeWithMeConfigurationTypeModel $configurationTypeModel, Lifetime $configurationTypeLifetime) {
                $point.registerExtension((Object)new ThinClientConfigurationType($configurationTypeModel), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)$configurationTypeLifetime, null, (int)1, null));
                return Unit.INSTANCE;
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void syncRunHistoryAndPinned$withLocalChange(Ref.BooleanRef localStateChange, Function0<Unit> block) {
        if (localStateChange.element) {
            return;
        }
        try {
            localStateChange.element = true;
            block.invoke();
        }
        finally {
            localStateChange.element = false;
        }
    }

    public static final /* synthetic */ Object access$isLocalChangeSafe(ThinClientRunConfigurationsHost $this, IViewable $receiver, Continuation $completion) {
        return $this.isLocalChangeSafe($receiver, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ List access$getKeysByValue(ThinClientRunConfigurationsHost $this, ConcurrentHashMap $receiver, String value) {
        return $this.getKeysByValue($receiver, value);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getModelKeyToUniqueId$p(ThinClientRunConfigurationsHost $this) {
        return $this.modelKeyToUniqueId;
    }

    public static final /* synthetic */ void access$syncRunHistoryAndPinned$withLocalChange(Ref.BooleanRef localStateChange, Function0 block) {
        ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$withLocalChange(localStateChange, (Function0<Unit>)block);
    }

    public static final /* synthetic */ void access$adviseOnCurrentConfiguration(ThinClientRunConfigurationsHost $this, CodeWithMeRunConfigurationsModel model) {
        $this.adviseOnCurrentConfiguration(model);
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(ThinClientRunConfigurationsHost $this) {
        return $this.getServiceLifetime();
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDispatcher$p(ThinClientRunConfigurationsHost $this) {
        return $this.dispatcher;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientRunConfigurationsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientRunConfigurationsHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,326:1\n30#2,2:327\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion\n*L\n322#1:327,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThinClientRunConfigurationsHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ThinClientRunConfigurationsHost> serviceClass$iv = ThinClientRunConfigurationsHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ThinClientRunConfigurationsHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,326:1\n30#2,2:327\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener\n*L\n55#1:327,2\n*E\n"})
    public static final class Listener
    implements SolutionExtListener<CodeWithMeRunConfigurationsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull CodeWithMeRunConfigurationsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ComponentManager $this$service$iv = (ComponentManager)session2.getProject();
            boolean $i$f$service = false;
            Class<ThinClientRunConfigurationsHost> serviceClass$iv = ThinClientRunConfigurationsHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ThinClientRunConfigurationsHost)((Object)object)).bindWithModel(model);
        }
    }
}

