/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.actions.JavaTimeYamlConstructor;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceEditorAction;
import com.intellij.kubernetes.view.vfs.ResourceContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a0\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0081@\u00a2\u0006\u0002\u0010\r\u001a+\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\b*\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0003\u00a2\u0006\u0002\u0010\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findResourceMapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "calculateResourceContext", "Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "Lio/kubernetes/client/common/KubernetesObject;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lorg/jetbrains/yaml/psi/YAMLFile;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unmarshal", "T", "resourceClass", "Lkotlin/reflect/KClass;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/reflect/KClass;)Lio/kubernetes/client/common/KubernetesObject;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceEditorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceEditorAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesResourceEditorActionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n13#2:186\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceEditorAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesResourceEditorActionKt\n*L\n41#1:186\n*E\n"})
public final class KubernetesResourceEditorActionKt {
    @NotNull
    private static final Logger LOG;

    @RequiresBackgroundThread
    @RequiresReadLock
    @Nullable
    public static final KubernetesResourceMapper<?, ?> findResourceMapper(@NotNull YAMLFile yamlFile) {
        YAMLDocument yAMLDocument;
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        List list = yamlFile.getDocuments();
        YAMLValue yAMLValue = list != null && (yAMLDocument = (YAMLDocument)CollectionsKt.singleOrNull((List)list)) != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping yamlMapping = yAMLMapping;
        if (YamlUtilKt.get((YAMLMapping)yamlMapping, (String)"apiVersion") == null) {
            return null;
        }
        if (YamlUtilKt.get((YAMLMapping)yamlMapping, (String)"metadata") == null) {
            return null;
        }
        Object object = YamlUtilKt.get((YAMLMapping)yamlMapping, (String)"kind");
        if (object == null || (object = YamlUtilKt.getEffectiveText((YAMLValue)object)) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            return null;
        }
        Object kind = object;
        return KubernetesResourceMapper.Companion.find(arg_0 -> KubernetesResourceEditorActionKt.findResourceMapper$lambda$0((String)kind, arg_0));
    }

    @RequiresBackgroundThread
    @Nullable
    public static final Object calculateResourceContext(@NotNull KubernetesApiModelInterface apiModel2, @NotNull YAMLFile yamlFile, @NotNull VirtualFile virtualFile, @NotNull Continuation<? super ResourceContext<KubernetesObject, ?>> $completion) {
        return CoroutinesKt.readAction(() -> KubernetesResourceEditorActionKt.calculateResourceContext$lambda$0(yamlFile, virtualFile, apiModel2), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @RequiresReadLock
    private static final <T extends KubernetesObject> T unmarshal(VirtualFile $this$unmarshal, KClass<T> resourceClass) {
        KubernetesObject kubernetesObject;
        try {
            Iterable iterable;
            Representer representer = new Representer(new DumperOptions());
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml((BaseConstructor)new JavaTimeYamlConstructor<T>(resourceClass), representer);
            Closeable closeable = $this$unmarshal.getInputStream();
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                iterable = yaml.loadAll((InputStream)new BufferedInputStream(inputStream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable resources = iterable;
            Intrinsics.checkNotNull((Object)resources);
            kubernetesObject = (KubernetesObject)KClasses.safeCast(resourceClass, (Object)CollectionsKt.singleOrNull((Iterable)resources));
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            kubernetesObject = null;
        }
        return (T)kubernetesObject;
    }

    private static final boolean findResourceMapper$lambda$0(String $kind, KubernetesEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$kind);
    }

    private static final ResourceContext calculateResourceContext$lambda$0(YAMLFile $yamlFile, VirtualFile $virtualFile, KubernetesApiModelInterface $apiModel) {
        KubernetesResourceMapper<?, ?> kubernetesResourceMapper = KubernetesResourceEditorActionKt.findResourceMapper($yamlFile);
        Intrinsics.checkNotNull(kubernetesResourceMapper);
        KubernetesResourceMapper<?, ?> mapper = kubernetesResourceMapper;
        KClass resourceClass = mapper.getResourceClass();
        Object t = KubernetesResourceEditorActionKt.unmarshal($virtualFile, resourceClass);
        if (t == null) {
            throw new RuntimeException("resource of type '" + resourceClass + "' not found");
        }
        Object resource = t;
        V1ObjectMeta v1ObjectMeta = resource.getMetadata();
        if (v1ObjectMeta == null) {
            throw new RuntimeException("metadata not found");
        }
        V1ObjectMeta metadata = v1ObjectMeta;
        if (metadata.getNamespace() == null) {
            metadata.setNamespace($apiModel.getNamespaceForRequest());
        }
        return new ResourceContext(resource, mapper, false, 4, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesResourceEditorAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

