/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/config/MnParametrizedConfigKey;", "", "prefix", "", "suffix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "getSuffix", "prefixSeparatorsCount", "", "getParameterRange", "Lcom/intellij/openapi/util/TextRange;", "configKeyText", "Companion", "intellij.micronaut"})
public final class MnParametrizedConfigKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    private final int prefixSeparatorsCount;
    public static final char CONFIG_KEY_SEPARATOR = '.';
    @NotNull
    public static final String CONFIG_KEY_PARAMETER_PART = ".*.";

    private MnParametrizedConfigKey(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.prefixSeparatorsCount = StringUtil.countChars((CharSequence)this.prefix, (char)'.');
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @Nullable
    public final TextRange getParameterRange(@NotNull String configKeyText) {
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        int configKeyTextPrefixIndex = -1;
        int n = this.prefixSeparatorsCount + 1;
        for (int i = 0; i < n; ++i) {
            if ((configKeyTextPrefixIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(configKeyTextPrefixIndex + 1))) >= 0) continue;
            return null;
        }
        int parameterEndIndex = StringUtil.indexOf((CharSequence)configKeyText, (char)'.', (int)(configKeyTextPrefixIndex + 1));
        if (parameterEndIndex < 0) {
            parameterEndIndex = configKeyText.length();
        }
        return TextRange.create((int)(configKeyTextPrefixIndex + 1), (int)parameterEndIndex);
    }

    public /* synthetic */ MnParametrizedConfigKey(String prefix, String suffix, DefaultConstructorMarker $constructor_marker) {
        this(prefix, suffix);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/config/MnParametrizedConfigKey$Companion;", "", "<init>", "()V", "CONFIG_KEY_SEPARATOR", "", "CONFIG_KEY_PARAMETER_PART", "", "getParametrizedConfigKey", "Lcom/intellij/micronaut/config/MnParametrizedConfigKey;", "configKeyName", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MnParametrizedConfigKey getParametrizedConfigKey(@NotNull String configKeyName) {
            Intrinsics.checkNotNullParameter((Object)configKeyName, (String)"configKeyName");
            int parameterPartIndex = StringsKt.indexOf$default((CharSequence)configKeyName, (String)MnParametrizedConfigKey.CONFIG_KEY_PARAMETER_PART, (int)0, (boolean)false, (int)6, null);
            if (parameterPartIndex <= 0) {
                return null;
            }
            String string = configKeyName.substring(0, parameterPartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = configKeyName.substring(parameterPartIndex + 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return new MnParametrizedConfigKey(string, string2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

