/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/SqlUpdateAddedFileProcessor;", "Lcom/intellij/psi/impl/file/UpdateAddedFileProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "update", "", "originalElement", "intellij.database.sql.impl"})
public final class SqlUpdateAddedFileProcessor
extends UpdateAddedFileProcessor {
    public boolean canProcessElement(@NotNull PsiFile element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof SqlFile;
    }

    public void update(@Nullable PsiFile element, @Nullable PsiFile originalElement) {
        SqlFile sqlFile = element instanceof SqlFile ? (SqlFile)element : null;
        if (sqlFile == null) {
            return;
        }
        SqlFile sqlFile2 = sqlFile;
        SqlFile sqlFile3 = originalElement instanceof SqlFile ? (SqlFile)originalElement : null;
        if (sqlFile3 == null) {
            return;
        }
        SqlFile sqlOriginalFile = sqlFile3;
        VirtualFile virtualFile = sqlOriginalFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile originalVirtualFile = virtualFile;
        Project project = sqlOriginalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project originalProject = project;
        Project project2 = sqlFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        JdbcConsole console = JdbcConsoleProvider.getConsole((Project)originalProject, (VirtualFile)originalVirtualFile);
        SqlLanguageDialect sqlLanguageDialect = console == null ? SqlDialectMappings.getInstance((Project)originalProject).getMapping(originalVirtualFile) : DbSqlUtilCore.getSqlDialect((LocalDataSource)console.getDataSource());
        Intrinsics.checkNotNull((Object)sqlLanguageDialect);
        SqlLanguageDialect originalFileDialect = sqlLanguageDialect;
        SqlDialectMappings.getInstance((Project)project3).setMapping(sqlFile2.getVirtualFile(), (Object)originalFileDialect);
    }
}

