/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverRegistry;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

public abstract class ViewResolverFactory {
    public static final ExtensionPointName<ViewResolverFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.mvc.viewResolverFactory");

    @NotNull
    public Set<ViewResolver> createResolvers(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass, @NotNull CommonSpringModel model) {
        if (beanClass == null) {
            ViewResolverFactory.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ViewResolverFactory.$$$reportNull$$$0(1);
        }
        Set<ViewResolver> set = this.isMine(bean, beanClass) ? this.createViewResolvers(bean, model) : Collections.emptySet();
        if (set == null) {
            ViewResolverFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<ViewResolver> handleResolversRegistry(String methodName, UCallExpression methodCallExpression, CommonSpringModel servletModel) {
        Set<ViewResolver> set = Collections.emptySet();
        if (set == null) {
            ViewResolverFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        String baseClassName;
        if (beanClass == null) {
            ViewResolverFactory.$$$reportNull$$$0(4);
        }
        return (baseClassName = this.getBeanClass()) != null && (Boolean)ReadAction.compute(() -> InheritanceUtil.isInheritor((PsiClass)beanClass, (String)baseClassName)) != false;
    }

    @Nullable
    public abstract String getBeanClass();

    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Set<ViewResolver> set = Collections.emptySet();
        if (set == null) {
            ViewResolverFactory.$$$reportNull$$$0(5);
        }
        return set;
    }

    public static void findResolversByClass(@NotNull PsiClass psiClass, CommonSpringBean viewResolvers, @NotNull CommonSpringModel model, @NotNull List<? super ViewResolver> result, @NotNull Predicate<? super ViewResolverFactory> predicate) {
        if (psiClass == null) {
            ViewResolverFactory.$$$reportNull$$$0(6);
        }
        if (model == null) {
            ViewResolverFactory.$$$reportNull$$$0(7);
        }
        if (result == null) {
            ViewResolverFactory.$$$reportNull$$$0(8);
        }
        if (predicate == null) {
            ViewResolverFactory.$$$reportNull$$$0(9);
        }
        for (ViewResolverFactory factory : EP_NAME.getExtensionList()) {
            if (!predicate.test(factory) || !factory.isMine(viewResolvers, psiClass)) continue;
            result.addAll(factory.createResolvers(viewResolvers, psiClass, model));
            break;
        }
    }

    public static boolean processAllMineFactories(@Nullable CommonSpringBean bean, @NotNull PsiClass viewResolverClass, @NotNull Processor<? super ViewResolverFactory> processor) {
        if (viewResolverClass == null) {
            ViewResolverFactory.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            ViewResolverFactory.$$$reportNull$$$0(11);
        }
        for (ViewResolverFactory factory : ViewResolverRegistry.getInstance().getAllFactories()) {
            if (!factory.isMine(bean, viewResolverClass) || processor.process((Object)factory)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/ViewResolverFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewResolverClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/ViewResolverFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolvers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "handleResolversRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResolvers";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResolversByClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllMineFactories";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

