/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class CeilNode
extends MathOperation {
    public CeilNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int ceilInt(int a) {
        return a;
    }

    @Specialization
    protected static SafeInteger ceilSafeInt(SafeInteger a) {
        return a;
    }

    @Specialization
    protected final Object ceilDouble(double d, @Cached @Cached.Shared(value="isZero") InlinedConditionProfile isZero, @Cached @Cached.Shared(value="requiresNegativeZero") InlinedConditionProfile requiresNegativeZero, @Cached @Cached.Shared(value="fitsInt") InlinedConditionProfile fitsInt, @Cached @Cached.Shared(value="fitsSafeLong") InlinedConditionProfile fitsSafeLong) {
        if (isZero.profile(this, d == 0.0)) {
            return d;
        }
        if (fitsInt.profile(this, d >= -2.147483648E9 && d <= 2.147483647E9)) {
            int i = (int)d;
            int result = d > (double)i ? i + 1 : i;
            if (requiresNegativeZero.profile(this, result == 0 && d < 0.0)) {
                return -0.0;
            }
            return result;
        }
        if (fitsSafeLong.profile(this, JSRuntime.isSafeInteger(d))) {
            long i = (long)d;
            long result = d > (double)i ? i + 1L : i;
            if (requiresNegativeZero.profile(this, result == 0L && d < 0.0)) {
                return -0.0;
            }
            return SafeInteger.valueOf(result);
        }
        return Math.ceil(d);
    }

    @Specialization(replaces={"ceilDouble"})
    protected final Object ceilToDouble(Object a, @Cached @Cached.Shared(value="isZero") InlinedConditionProfile isZero, @Cached @Cached.Shared(value="requiresNegativeZero") InlinedConditionProfile requiresNegativeZero, @Cached @Cached.Shared(value="fitsInt") InlinedConditionProfile fitsInt, @Cached @Cached.Shared(value="fitsSafeLong") InlinedConditionProfile fitsSafeLong) {
        double d = this.toDouble(a);
        return this.ceilDouble(d, isZero, requiresNegativeZero, fitsInt, fitsSafeLong);
    }
}

