/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.impl;

import com.intellij.javaee.el.ELCallExpression;
import com.intellij.javaee.el.ELTokenType;
import com.intellij.javaee.el.impl.ELLanguage;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELLambdaExpression;
import com.intellij.javaee.el.psi.ELLambdaParameters;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELParameterList;
import com.intellij.javaee.el.psi.ELSelectExpression;
import com.intellij.javaee.el.psi.ELUnaryExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.psi.impl.ELFunctionCallExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELLambdaExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELListConstructionExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELLiteralExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELMapConstructionExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELMethodCallExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELSetConstructionExpressionImpl;
import com.intellij.javaee.el.psi.impl.ELVariableImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELParserUtil {
    public static final Key<Object> KEY = Key.create((String)"inside conditional");

    public static boolean push(PsiBuilder builder_, int i, int i1) {
        builder_.putUserData(KEY, (Object)i1);
        return true;
    }

    public static boolean pop(PsiBuilder builder_, int i) {
        builder_.putUserData(KEY, null);
        return true;
    }

    public static boolean peek(PsiBuilder builder_, int i, int i1) {
        return builder_.getUserData(KEY) != null;
    }

    @Nullable
    public static ELVariable getField(ELSelectExpression expression) {
        List<ELExpression> list = expression.getELExpressionList();
        if (list.size() < 2) {
            return null;
        }
        ELExpression elExpression = list.get(1);
        return elExpression instanceof ELVariable ? (ELVariable)elExpression : null;
    }

    public static ELExpression[] getParameters(ELParameterList list) {
        List<ELExpression> expressions = list.getELExpressionList();
        return expressions.toArray(new ELExpression[0]);
    }

    public static String getFunctionName(ELCallExpression expression) {
        ELVariable method = expression.getMethod();
        return method == null ? null : method.getText();
    }

    public static ELParameterList getParameterList(ELFunctionCallExpressionImpl expression) {
        return expression.getELParameterList();
    }

    public static ELParameterList getParameterList(ELMethodCallExpressionImpl expression) {
        return expression.getELParameterList();
    }

    public static IElementType getOperationSign(ELUnaryExpression expression) {
        ASTNode[] nodes = expression.getNode().getChildren(ELTokenType.EL_UNARY_OPERATIONS);
        return nodes.length == 1 ? nodes[0].getElementType() : null;
    }

    public static ELExpression getQualifier(ELMethodCallExpression expression) {
        ELExpression select = expression.getELExpression();
        if (select instanceof ELSelectExpression) {
            return ((ELSelectExpression)select).getFrom();
        }
        return select == expression.getMethod() ? null : select;
    }

    @Nullable
    public static ELVariable getMethod(ELMethodCallExpression expression) {
        PsiElement sibling = expression.getELParameterList().getPrevSibling();
        if (sibling instanceof ELSelectExpression) {
            return ((ELSelectExpression)sibling).getField();
        }
        if (sibling instanceof ELVariable) {
            return (ELVariable)sibling;
        }
        return null;
    }

    public static List<ELVariable> getVariables(ELLambdaExpressionImpl expression) {
        PsiElement child = expression.getFirstChild();
        if (child instanceof ELLambdaParameters) {
            return ((ELLambdaParameters)child).getELVariableList();
        }
        return Collections.singletonList((ELVariable)child);
    }

    @NotNull
    public static PsiNamedElement setName(@NotNull ELVariableImpl variable, @NotNull String name) throws IncorrectOperationException {
        ELVariable newElement;
        if (variable == null) {
            ELParserUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ELParserUtil.$$$reportNull$$$0(1);
        }
        if ((newElement = ELParserUtil.createVariable(name, variable.getProject())) == null) {
            throw new IncorrectOperationException("Cannot create variable with name '" + name + "'");
        }
        variable.replace((PsiElement)newElement);
        ELVariable eLVariable = newElement;
        if (eLVariable == null) {
            ELParserUtil.$$$reportNull$$$0(2);
        }
        return eLVariable;
    }

    @NotNull
    public static String getName(@NotNull ELVariableImpl variable) {
        if (variable == null) {
            ELParserUtil.$$$reportNull$$$0(3);
        }
        String string = variable.getText();
        if (string == null) {
            ELParserUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static ELVariable createVariable(String name, Project project) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(ELLanguage.INSTANCE, (CharSequence)("${" + name + "}"));
        return (ELVariable)file.getFirstChild().getChildren()[0];
    }

    @NotNull
    public static SearchScope getUseScope(ELVariableImpl variable) {
        ELLambdaExpression lambdaExpression = (ELLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)variable, ELLambdaExpression.class);
        return new LocalSearchScope((PsiElement)(lambdaExpression == null ? variable.getContainingFile() : lambdaExpression));
    }

    public static Class getTypeClass(ELListConstructionExpressionImpl expression) {
        return List.class;
    }

    public static Class getTypeClass(ELLiteralExpressionImpl expression) {
        IElementType type = expression.getNode().getFirstChildNode().getElementType();
        if (type == ELTokenType.EL_STRING_LITERAL || type == ELTokenType.EL_ESCAPED_STRING_LITERAL) {
            return String.class;
        }
        if (type == ELTokenType.EL_INTEGER_LITERAL) {
            return Integer.class;
        }
        if (type == ELTokenType.EL_FLOATING_POINT_LITERAL) {
            return Float.class;
        }
        if (type == ELTokenType.EL_TRUE || type == ELTokenType.EL_FALSE) {
            return Boolean.class;
        }
        return Object.class;
    }

    public static Class getTypeClass(ELMapConstructionExpressionImpl expression) {
        return Map.class;
    }

    public static Class getTypeClass(ELSetConstructionExpressionImpl expression) {
        return Set.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/el/impl/ELParserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/el/impl/ELParserUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

