/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospectorKt;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospectorHelper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableColumnIt;
import com.intellij.database.dialects.exasol.introspector.ExaIntroQueries;
import com.intellij.database.dialects.exasol.introspector.ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$;
import com.intellij.database.dialects.exasol.introspector.ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$;
import com.intellij.database.dialects.exasol.model.ExaConnection;
import com.intellij.database.dialects.exasol.model.ExaConstraint;
import com.intellij.database.dialects.exasol.model.ExaDatabase;
import com.intellij.database.dialects.exasol.model.ExaForeignKey;
import com.intellij.database.dialects.exasol.model.ExaIndex;
import com.intellij.database.dialects.exasol.model.ExaKey;
import com.intellij.database.dialects.exasol.model.ExaLikeSchema;
import com.intellij.database.dialects.exasol.model.ExaLikeTable;
import com.intellij.database.dialects.exasol.model.ExaRole;
import com.intellij.database.dialects.exasol.model.ExaRoot;
import com.intellij.database.dialects.exasol.model.ExaRoutine;
import com.intellij.database.dialects.exasol.model.ExaSchema;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaTable;
import com.intellij.database.dialects.exasol.model.ExaTableColumn;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaView;
import com.intellij.database.dialects.exasol.model.ExaViewColumn;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.dialects.exasol.model.properties.ExaScriptType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DatabaseFragmentIntrospectionTask;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 R2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0006QRSTUVB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001dH\u0014J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0014J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020+H\u0014J\u0018\u0010,\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0013H\u0014J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0015H\u0014J(\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\f2\b\u00103\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\rH\u0002J!\u00107\u001a\u00020\u00192\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001309\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010:J\u001e\u0010;\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020?H\u0014J4\u0010@\u001a\u001e\u0012\u0004\u0012\u00020\u00030AR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0014J&\u0010B\u001a\u00180CR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J4\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u00030ER\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0003H\u0014J6\u0010F\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040GR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u0004H\u0014J8\u0010H\u001a\u00020\u00192\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u0002052\u0018\u0010M\u001a\u0014\u0012\u0004\u0012\u00020K\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r090NH\u0016R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/exasol/model/ExaRoot;", "Lcom/intellij/database/dialects/exasol/model/ExaDatabase;", "Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "privileges", "", "", "getPrivileges", "()Ljava/util/List;", "setPrivileges", "(Ljava/util/List;)V", "reifyDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "databaseName", "findDatabase", "introspectDatabase", "", "task", "Lcom/intellij/database/introspection/DatabaseIntrospectionTask;", "introspectSchemas", "Lcom/intellij/database/introspection/SchemasIntrospectionTask;", "introspectAutomatically", "tran", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectRootObjects", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "introspectPrivileges", "introspectConnections", "introspectUsers", "introspectRoles", "introspectNamespaces", "Lcom/intellij/database/introspection/IntrospectionTask;", "retrieveSchemasOfDatabase", "database", "introspectNamespacesInTran", "applySchemas", "db", "schemas", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$SchemaInfo;", "opened", "isSystemSchema", "", "name", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectSchemasAuto", "introspectOneSchema", "schema", "introspectDatabaseFragments", "Lcom/intellij/database/introspection/DatabaseFragmentIntrospectionTask;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractServerObjectsRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "introspectNativeDefinitions", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "result", "", "SURROGATE_PATTERN", "Lkotlin/text/Regex;", "Factory", "Companion", "ExaVSchemaRetriever", "ExaSchemaRetriever", "ExaSchemaRetrieverBase", "ExaSysSchemaRetriever", "intellij.database.dialects.exasol"})
@SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,506:1\n865#2,2:507\n865#2,2:509\n196#3,13:511\n179#3,7:524\n179#3,7:531\n179#3,7:538\n179#3,7:545\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector\n*L\n104#1:507,2\n105#1:509,2\n193#1:511,13\n127#1:524,7\n142#1:531,7\n156#1:538,7\n182#1:545,7\n*E\n"})
public final class ExaIntrospector
extends BaseNativeIntrospector<ExaRoot, ExaDatabase, ExaLikeSchema> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> privileges;
    @NotNull
    private final Regex SURROGATE_PATTERN;

    public ExaIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = Companion;
        Dbms dbms = Dbms.EXASOL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"EXASOL");
        super(context, nature, dbms, modelFactory);
        this.privileges = CollectionsKt.emptyList();
        this.SURROGATE_PATTERN = new Regex("SYS_\\d+");
    }

    @NotNull
    public final List<String> getPrivileges() {
        return this.privileges;
    }

    public final void setPrivileges(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.privileges = list;
    }

    @Nullable
    protected BasicDatabase reifyDatabase(@NotNull DBTransaction transaction, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        BasicDatabase database = this.findDatabase(databaseName);
        if (database == null) {
            this.introspectNamespacesInTran(transaction);
            database = this.findDatabase(databaseName);
        }
        return database;
    }

    @Nullable
    protected BasicDatabase findDatabase(@NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        return Intrinsics.areEqual((Object)databaseName, (Object)"@") ? ((ExaRoot)this.getRoot()).getCurrentDatabase() : (BasicDatabase)((ExaRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    protected void introspectDatabase(@NotNull DBTransaction transaction, @NotNull DatabaseIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase((IntrospectionTask)task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this), (String)("Cannot find database with name '" + task.getDatabaseName() + "'."), null, (int)2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        this.introspectAutoInTran(transaction, SetsKt.setOf((Object)database));
    }

    protected void introspectSchemas(@NotNull DBTransaction transaction, @NotNull SchemasIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = this.getDatabase((IntrospectionTask)task);
        if (basicDatabase == null) {
            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this), (String)("Cannot find database with name '" + task.getDatabaseName() + "'."), null, (int)2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        NamingFamily namingFamily = database.getSchemas();
        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
        List schemas = ModelFun.elementsByNames((Family)((Family)namingFamily), (Set)task.getSchemaNames());
        this.introspectAutoInTran(transaction, schemas);
    }

    protected void introspectAutomatically(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        Iterable<Object> iterable;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Iterable<Object> iterable2 = namespaces;
        if (iterable2 == null || iterable2.isEmpty()) {
            this.introspectNamespacesInTran(tran);
            iterable2 = ((ExaRoot)this.getRoot()).getNamespaces();
            Intrinsics.checkNotNull(iterable2);
            iterable = iterable2;
        } else {
            iterable = namespaces;
        }
        Iterable<Object> toProcess = iterable;
        List schemas = new ArrayList();
        for (BasicNamespace basicNamespace : toProcess) {
            boolean bl;
            ExaLikeSchema it;
            Iterable $this$filterTo$iv;
            if (basicNamespace instanceof ExaLikeSchema) {
                schemas.add(basicNamespace);
                continue;
            }
            if (!(basicNamespace instanceof ExaDatabase)) continue;
            ModNamingIdentifyingFamily<? extends ExaSchema> modNamingIdentifyingFamily = ((ExaDatabase)basicNamespace).getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSchemas(...)");
            Iterable iterable3 = (Iterable)modNamingIdentifyingFamily;
            Collection destination$iv = schemas;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (ExaSchema)element$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.inIntrospectionScope((BasicNamespace)it)) continue;
                destination$iv.add(element$iv);
            }
            ModNamingIdentifyingFamily<? extends ExaVirtualSchema> modNamingIdentifyingFamily2 = ((ExaDatabase)basicNamespace).getVirtualSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getVirtualSchemas(...)");
            $this$filterTo$iv = (Iterable)modNamingIdentifyingFamily2;
            destination$iv = schemas;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (ExaVirtualSchema)element$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.inIntrospectionScope((BasicNamespace)it)) continue;
                destination$iv.add(element$iv);
            }
        }
        this.introspectRootObjects(tran);
        this.introspectSchemasAuto(tran, schemas);
    }

    private final void introspectRootObjects(DBTransaction tran) {
        this.introspectPrivileges(tran);
        this.introspectConnections(tran);
        this.introspectUsers(tran);
        this.introspectRoles(tran);
    }

    @NotNull
    public TreePattern getDefaultScope() {
        return BaseMultiDatabaseIntrospectorKt.getMULTI_DB_SCOPE();
    }

    private final void introspectPrivileges(DBTransaction tran) {
        this.privileges = ExaIntroQueries.INSTANCE.retrievePrivileges(tran);
    }

    private final void introspectConnections(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectConnections$lambda$0(tran, this, arg_0));
    }

    private final void introspectUsers(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectUsers$lambda$0(tran, arg_0));
    }

    private final void introspectRoles(DBTransaction tran) {
        this.inModel(arg_0 -> ExaIntrospector.introspectRoles$lambda$0(tran, arg_0));
    }

    protected void introspectNamespaces(@NotNull DBTransaction transaction, @NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectNamespacesInTran(transaction);
    }

    protected void retrieveSchemasOfDatabase(@NotNull DBTransaction transaction, @NotNull BasicDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.introspectNamespacesInTran(transaction);
    }

    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        BasicRoot basicRoot = this.getModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        List<ExaIntroQueries.SchemaInfo> schemas = ExaIntroQueries.INSTANCE.retrieveAllSchemas(tran, basicRoot);
        boolean wasEmpty = this.getModel().getModelRoots().isEmpty();
        String opened = wasEmpty ? ExaIntroQueries.INSTANCE.retrieveOpenedSchema(tran) : null;
        this.inModel(arg_0 -> ExaIntrospector.introspectNamespacesInTran$lambda$0(this, schemas, opened, arg_0));
    }

    private final void applySchemas(ExaDatabase db, List<ExaIntroQueries.SchemaInfo> schemas, String opened) {
        boolean wasEmpty = db.getSchemas().isEmpty() && db.getVirtualSchemas().isEmpty();
        ModFamily[] modFamilyArray = new ModFamily[2];
        Intrinsics.checkNotNullExpressionValue(db.getSchemas(), (String)"getSchemas(...)");
        Intrinsics.checkNotNullExpressionValue(db.getVirtualSchemas(), (String)"getVirtualSchemas(...)");
        ModFamily[] families$iv = modFamilyArray;
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyFamiliesAndCleanup = false;
        for (ModFamily f$iv : families$iv) {
            f$iv.markChildrenAsSyncPending();
        }
        boolean bl = false;
        for (ExaIntroQueries.SchemaInfo info : schemas) {
            long id = info.id == 0L && this.isSystemSchema(info.name) ? Long.MIN_VALUE : info.id;
            BasicModNamedElement basicModNamedElement = (info.is_virtual ? db.getVirtualSchemas() : db.getSchemas()).renew(id, info.name);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
            ExaLikeSchema schema = (ExaLikeSchema)basicModNamedElement;
            schema.setComment(info.comment);
            schema.setOwnerRef((BasicReference)BasicNameReference.create((String)info.owner));
            if (!wasEmpty) continue;
            schema.setCurrent(Intrinsics.areEqual((Object)schema.getName(), (Object)opened));
        }
        for (ModFamily f$iv : families$iv) {
            f$iv.removeSyncPendingChildren();
            f$iv.sort();
        }
    }

    private final boolean isSystemSchema(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)"SYS") || Intrinsics.areEqual((Object)name2, (Object)"EXA_STATISTICS");
    }

    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        this.introspectNamespaces();
    }

    private final void introspectSchemasAuto(DBTransaction tran, List<? extends ExaLikeSchema> schemas) {
        for (ExaLikeSchema exaLikeSchema : schemas) {
            this.introspectOneSchema(tran, exaLikeSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, ExaLikeSchema schema) {
        this.handleErrors("Introspect schema " + schema.getName(), () -> ExaIntrospector.introspectOneSchema$lambda$0(this, tran, schema));
    }

    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull DatabaseFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<ExaDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull ExaDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new BaseNativeIntrospector.AbstractServerObjectsRetriever(this, transaction){};
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractNativeRetriever<ExaDatabase> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull ExaDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends ExaLikeSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull ExaLikeSchema schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever abstractSchemaRetriever;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (schema instanceof ExaSchema) {
            String string = ((ExaSchema)schema).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            abstractSchemaRetriever = this.isSystemSchema(string) ? (ExaSchemaRetrieverBase)new ExaSysSchemaRetriever(transaction, (ExaSchema)schema) : (ExaSchemaRetrieverBase)new ExaSchemaRetriever(transaction, (ExaSchema)schema);
        } else {
            abstractSchemaRetriever = new ExaVSchemaRetriever(transaction, (ExaVirtualSchema)schema);
        }
        return abstractSchemaRetriever;
    }

    public void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    private static final Unit introspectConnections$lambda$0(DBTransaction $tran, ExaIntrospector this$0, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getConnections();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily connections = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processConnections($tran, this$0.privileges.contains("SELECT ANY DICTIONARY"), (Function1<? super ExaIntroQueries.ConnectionInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectConnections$lambda$0$0$0(connections, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectConnections$lambda$0$0$0(ModNamingFamily $connections, ExaIntroQueries.ConnectionInfo connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        BasicModNamedElement basicModNamedElement = $connections.createOrGet(connection.name);
        ExaConnection $this$introspectConnections_u24lambda_u240_u240_u240_u240 = (ExaConnection)basicModNamedElement;
        boolean bl = false;
        $this$introspectConnections_u24lambda_u240_u240_u240_u240.setComment(connection.comment);
        $this$introspectConnections_u24lambda_u240_u240_u240_u240.setConnectionString(connection.connection_string);
        $this$introspectConnections_u24lambda_u240_u240_u240_u240.setUser(connection.user_name);
        $this$introspectConnections_u24lambda_u240_u240_u240_u240.setPassword(null);
        return Unit.INSTANCE;
    }

    private static final Unit introspectUsers$lambda$0(DBTransaction $tran, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getUsers();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processUsers($tran, (Function1<? super ExaIntroQueries.UserInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectUsers$lambda$0$0$0(users, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectUsers$lambda$0$0$0(ModNamingFamily $users, ExaIntroQueries.UserInfo user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        BasicModNamedElement basicModNamedElement = $users.createOrGet(user.name);
        ExaUser $this$introspectUsers_u24lambda_u240_u240_u240_u240 = (ExaUser)basicModNamedElement;
        boolean bl = false;
        $this$introspectUsers_u24lambda_u240_u240_u240_u240.setComment(user.comment);
        $this$introspectUsers_u24lambda_u240_u240_u240_u240.setSystem(user.is_system);
        $this$introspectUsers_u24lambda_u240_u240_u240_u240.setPassword(null);
        return Unit.INSTANCE;
    }

    private static final Unit introspectRoles$lambda$0(DBTransaction $tran, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily roles = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        ExaIntroQueries.INSTANCE.processRoles($tran, (Function1<? super ExaIntroQueries.RoleInfo, Unit>)((Function1)arg_0 -> ExaIntrospector.introspectRoles$lambda$0$0$0(roles, arg_0)));
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit introspectRoles$lambda$0$0$0(ModNamingFamily $roles, ExaIntroQueries.RoleInfo role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        BasicModNamedElement basicModNamedElement = $roles.createOrGet(role.name);
        ExaRole $this$introspectRoles_u24lambda_u240_u240_u240_u240 = (ExaRole)basicModNamedElement;
        boolean bl = false;
        $this$introspectRoles_u24lambda_u240_u240_u240_u240.setComment(role.comment);
        $this$introspectRoles_u24lambda_u240_u240_u240_u240.setSystem(role.is_system);
        return Unit.INSTANCE;
    }

    private static final Unit introspectNamespacesInTran$lambda$0(ExaIntrospector this$0, List $schemas, String $opened, ExaRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getDatabases();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily databases = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        BasicModNamedElement basicModNamedElement = databases.createOrGet("EXA_DB");
        ExaDatabase $this$introspectNamespacesInTran_u24lambda_u240_u240_u240 = (ExaDatabase)basicModNamedElement;
        boolean bl2 = false;
        $this$introspectNamespacesInTran_u24lambda_u240_u240_u240.setCurrent(true);
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        BasicElement basicElement = root.getDatabases().first();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"first(...)");
        this$0.applySchemas((ExaDatabase)basicElement, $schemas, $opened);
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$0(ExaIntrospector this$0, DBTransaction $tran, ExaLikeSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<? extends ExaLikeSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ExaRoot access$getRoot(ExaIntrospector $this) {
        return (ExaRoot)$this.getRoot();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportLevelByLevelIntrospection", "getSupportLevelByLevelIntrospection", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "intellij.database.dialects.exasol"})
    private static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        public boolean getSupportServerObjects() {
            return false;
        }

        public boolean getSupportLevelByLevelIntrospection() {
            return false;
        }

        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J \u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaSchema;)V", "process", "", "retrieveScriptSources", "retrieveViewSources", "retrieveFunctionSources", "refineFunctionArgumentsFromSource", "func", "Lcom/intellij/database/model/basic/BasicModRoutine;", "src", "", "parseRoutine", "Lcom/intellij/database/model/DasRoutine;", "retrieveIndices", "parseIndexColumns", "", "info", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$IndexInfo;", "retrieveConstraints", "setUpConstraint", "con", "Lcom/intellij/database/dialects/exasol/model/ExaConstraint;", "cols", "", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConstraintColumnInfo;", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 7 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 8 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,506:1\n1563#2:507\n1634#2,3:508\n1563#2:554\n1634#2,3:555\n1878#2,3:588\n1563#2:602\n1634#2,3:603\n1869#2,2:625\n1563#2:633\n1634#2,3:634\n1563#2:637\n1634#2,3:638\n1563#2:641\n1634#2,3:642\n337#3,3:511\n340#3:516\n198#3,5:517\n204#3,5:535\n341#3:540\n337#3,3:558\n340#3:563\n198#3,5:564\n204#3,5:582\n341#3:587\n337#3,3:606\n340#3:611\n198#3,11:612\n341#3:623\n355#3:624\n358#3,6:627\n37#4,2:514\n37#4,2:561\n37#4,2:609\n400#5:522\n401#5,2:528\n400#5:541\n401#5,2:547\n400#5:569\n401#5,2:575\n140#5,2:591\n143#5,8:594\n1134#6:523\n1229#6,2:524\n1135#6,2:526\n1139#6:530\n1234#6,2:531\n1140#6,2:533\n1134#6:542\n1229#6,2:543\n1135#6,2:545\n1139#6:549\n1234#6,2:550\n1140#6,2:552\n1134#6:570\n1229#6,2:571\n1135#6,2:573\n1139#6:577\n1234#6,2:578\n1140#6,2:580\n28#7:593\n442#8,6:645\n442#8,6:651\n445#8,3:657\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetriever\n*L\n295#1:507\n295#1:508,3\n324#1:554\n324#1:555,3\n339#1:588,3\n354#1:602\n354#1:603,3\n373#1:625,2\n401#1:633\n401#1:634,3\n409#1:637\n409#1:638,3\n410#1:641\n410#1:642,3\n295#1:511,3\n295#1:516\n295#1:517,5\n295#1:535,5\n295#1:540\n324#1:558,3\n324#1:563\n324#1:564,5\n324#1:582,5\n324#1:587\n354#1:606,3\n354#1:611\n354#1:612,11\n354#1:623\n373#1:624\n373#1:627,6\n295#1:514,2\n324#1:561,2\n354#1:609,2\n296#1:522\n296#1:528,2\n314#1:541\n314#1:547,2\n325#1:569\n325#1:575,2\n351#1:591,2\n351#1:594,8\n296#1:523\n296#1:524,2\n296#1:526,2\n296#1:530\n296#1:531,2\n296#1:533,2\n314#1:542\n314#1:543,2\n314#1:545,2\n314#1:549\n314#1:550,2\n314#1:552,2\n325#1:570\n325#1:571,2\n325#1:573,2\n325#1:577\n325#1:578,2\n325#1:580,2\n351#1:593\n357#1:645,6\n378#1:651,6\n383#1:657,3\n*E\n"})
    private final class ExaSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaSchema> {
        public ExaSchemaRetriever(@NotNull DBTransaction transaction, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        public void process() {
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$1(this, arg_0));
            this.inSchema(arg_0 -> ExaSchemaRetriever.process$lambda$2(this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void retrieveScriptSources(@NotNull ExaSchema schema) {
            void families$iv$iv;
            block6: {
                void this_$iv$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv;
                void $this$iv$iv$iv;
                void this_$iv$iv;
                void families$iv;
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                ModNamingIdentifyingFamily<? extends ExaScript> modNamingIdentifyingFamily = schema.getScripts();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getScripts(...)");
                Iterable $this$map$iv = (Iterable)modNamingIdentifyingFamily;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : iterable) {
                    void it;
                    ExaScript exaScript = (ExaScript)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getArguments());
                }
                $this$map$iv = (List)destination$iv$iv;
                ExaIntrospector exaIntrospector = ExaIntrospector.this;
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                ModFamily[] $this$toTypedArray$iv$iv = families$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
                $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                boolean removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl = false;
                BaseNativeIntrospector this_$iv = exaIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                void var19_25 = this_$iv$iv;
                String name$iv$iv$iv = name$iv$iv;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv.getModel().writeSources(new Runnable(this, schema){
                        final /* synthetic */ ExaSchemaRetriever this$0;
                        final /* synthetic */ ExaSchema $schema$inlined;
                        {
                            this.this$0 = exaSchemaRetriever;
                            this.$schema$inlined = exaSchema;
                        }

                        public final void run() {
                            boolean bl = false;
                            ExaIntroQueries.INSTANCE.processScripts(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.ScriptInfo, Unit>)((Function1)new Function1<ExaIntroQueries.ScriptInfo, Unit>(this.$schema$inlined, this.this$0){
                                final /* synthetic */ ExaSchema $schema;
                                final /* synthetic */ ExaSchemaRetriever this$0;
                                {
                                    this.$schema = $schema;
                                    this.this$0 = $receiver;
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final void invoke(ExaIntroQueries.ScriptInfo info) {
                                    block15: {
                                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                        v0 = (ExaScript)this.$schema.getScripts().get(info.name);
                                        if (v0 == null) break block15;
                                        var2_2 = v0;
                                        var3_3 = this.this$0;
                                        $this$invoke_u24lambda_u240 = var2_2;
                                        $i$a$-apply-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1 = false;
                                        var6_6 = info.type;
                                        if (var6_6 == null) ** GOTO lbl-1000
                                        tmp = -1;
                                        switch (var6_6.hashCode()) {
                                            case 83863: {
                                                if (var6_6.equals("UDF")) {
                                                    tmp = 1;
                                                }
                                                break;
                                            }
                                            case -432525521: {
                                                if (var6_6.equals("ADAPTER")) {
                                                    tmp = 2;
                                                }
                                                break;
                                            }
                                            case -1258414313: {
                                                if (var6_6.equals("SCRIPTING")) {
                                                    tmp = 3;
                                                }
                                                break;
                                            }
                                        }
                                        switch (tmp) {
                                            case 1: {
                                                v1 = ExaScriptType.UDF;
                                                break;
                                            }
                                            case 3: {
                                                v1 = ExaScriptType.SCRIPTING;
                                                break;
                                            }
                                            case 2: {
                                                v1 = ExaScriptType.ADAPTER;
                                                break;
                                            }
                                            default: lbl-1000:
                                            // 2 sources

                                            {
                                                v1 = ExaScriptType.SCRIPTING;
                                            }
                                        }
                                        $this$invoke_u24lambda_u240.setScriptType(v1);
                                        v2 = $this$invoke_u24lambda_u240;
                                        v3 = info.text;
                                        if (v3 != null) {
                                            var7_7 = v3;
                                            var8_8 = v2;
                                            $i$a$-let-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1$1 = false;
                                            v4 = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                            v2 = var8_8;
                                        } else {
                                            v4 = null;
                                        }
                                        v2.setSourceText((CompositeText)v4);
                                        v5 = info.text;
                                        if (v5 == null) break block15;
                                        it = v5;
                                        $i$a$-let-ExaIntrospector$ExaSchemaRetriever$retrieveScriptSources$2$1$1$1$2 = false;
                                        var3_3.refineFunctionArgumentsFromSource($this$invoke_u24lambda_u240, it);
                                    }
                                }
                            }));
                        }
                    });
                    $this$iv$iv$iv = this_$iv$iv;
                    sectionReference$iv$iv$iv = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv == null) break block6;
                }
                catch (Throwable throwable) {
                    void this_$iv$iv$iv2;
                    sectionReference$iv$iv$iv = this_$iv$iv;
                    DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv2 == null) throw throwable;
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                    if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                    throw throwable;
                }
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                if (dataSourceDiagnosticRecorder3 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
                }
            }
            int n = 0;
            int n2 = ((void)families$iv$iv).length;
            while (n < n2) {
                void f$iv$iv;
                f$iv$iv = families$iv$iv[n];
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void retrieveViewSources(@NotNull ExaSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = ExaIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var7_7 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, schema){
                    final /* synthetic */ ExaSchemaRetriever this$0;
                    final /* synthetic */ ExaSchema $schema$inlined;
                    {
                        this.this$0 = exaSchemaRetriever;
                        this.$schema$inlined = exaSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        ExaIntroQueries.INSTANCE.processViews(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.ViewInfo, Unit>)((Function1)new Function1<ExaIntroQueries.ViewInfo, Unit>(this.$schema$inlined){
                            final /* synthetic */ ExaSchema $schema;
                            {
                                this.$schema = $schema;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(ExaIntroQueries.ViewInfo info) {
                                block2: {
                                    SimpleCompositeText simpleCompositeText;
                                    ExaView exaView;
                                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                    ExaView exaView2 = (ExaView)this.$schema.getViews().get(info.name);
                                    if (exaView2 == null) break block2;
                                    ExaView $this$invoke_u24lambda_u240 = exaView = exaView2;
                                    boolean bl = false;
                                    ExaView exaView3 = $this$invoke_u24lambda_u240;
                                    String string = info.text;
                                    if (string != null) {
                                        void it;
                                        String string2 = string;
                                        ExaView exaView4 = exaView3;
                                        boolean bl2 = false;
                                        simpleCompositeText = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                        exaView3 = exaView4;
                                    } else {
                                        simpleCompositeText = null;
                                    }
                                    exaView3.setSourceText((CompositeText)simpleCompositeText);
                                }
                            }
                        }));
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void retrieveFunctionSources(@NotNull ExaSchema schema) {
            void families$iv$iv;
            block6: {
                void this_$iv$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv;
                void $this$iv$iv$iv;
                void this_$iv$iv;
                void families$iv;
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                ModNamingIdentifyingFamily<? extends ExaRoutine> modNamingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getRoutines(...)");
                Iterable $this$map$iv = (Iterable)modNamingIdentifyingFamily;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : iterable) {
                    void it;
                    ExaRoutine exaRoutine = (ExaRoutine)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getArguments());
                }
                $this$map$iv = (List)destination$iv$iv;
                ExaIntrospector exaIntrospector = ExaIntrospector.this;
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                ModFamily[] $this$toTypedArray$iv$iv = families$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
                $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                boolean removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl = false;
                BaseNativeIntrospector this_$iv = exaIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                void var19_25 = this_$iv$iv;
                String name$iv$iv$iv = name$iv$iv;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv.getModel().writeSources(new Runnable(this, schema){
                        final /* synthetic */ ExaSchemaRetriever this$0;
                        final /* synthetic */ ExaSchema $schema$inlined;
                        {
                            this.this$0 = exaSchemaRetriever;
                            this.$schema$inlined = exaSchema;
                        }

                        public final void run() {
                            boolean bl = false;
                            ExaIntroQueries.INSTANCE.processFunctions(ExaSchemaRetriever.access$getTransaction(this.this$0), this.$schema$inlined, (Function1<? super ExaIntroQueries.FunctionInfo, Unit>)((Function1)new Function1<ExaIntroQueries.FunctionInfo, Unit>(this.$schema$inlined, this.this$0){
                                final /* synthetic */ ExaSchema $schema;
                                final /* synthetic */ ExaSchemaRetriever this$0;
                                {
                                    this.$schema = $schema;
                                    this.this$0 = $receiver;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(ExaIntroQueries.FunctionInfo info) {
                                    block3: {
                                        SimpleCompositeText simpleCompositeText;
                                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                        ExaRoutine exaRoutine = (ExaRoutine)this.$schema.getRoutines().get(info.name);
                                        if (exaRoutine == null) break block3;
                                        ExaRoutine exaRoutine2 = exaRoutine;
                                        ExaSchemaRetriever exaSchemaRetriever = this.this$0;
                                        ExaRoutine $this$invoke_u24lambda_u240 = exaRoutine2;
                                        boolean bl = false;
                                        ExaRoutine exaRoutine3 = $this$invoke_u24lambda_u240;
                                        String string = info.text;
                                        if (string != null) {
                                            void it;
                                            String string2 = string;
                                            ExaRoutine exaRoutine4 = exaRoutine3;
                                            boolean bl2 = false;
                                            simpleCompositeText = new SimpleCompositeText((CharSequence)it, CompositeText.Kind.ORIGINAL_TEXT);
                                            exaRoutine3 = exaRoutine4;
                                        } else {
                                            simpleCompositeText = null;
                                        }
                                        exaRoutine3.setSourceText((CompositeText)simpleCompositeText);
                                        if (info.text != null) {
                                            exaSchemaRetriever.refineFunctionArgumentsFromSource($this$invoke_u24lambda_u240, "create " + info.text);
                                        }
                                    }
                                }
                            }));
                        }
                    });
                    $this$iv$iv$iv = this_$iv$iv;
                    sectionReference$iv$iv$iv = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv == null) break block6;
                }
                catch (Throwable throwable) {
                    void this_$iv$iv$iv2;
                    sectionReference$iv$iv$iv = this_$iv$iv;
                    DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (sectionReference$iv$iv$iv2 == null) throw throwable;
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                    if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                    throw throwable;
                }
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                if (dataSourceDiagnosticRecorder3 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
                }
            }
            int n = 0;
            int n2 = ((void)families$iv$iv).length;
            while (n < n2) {
                void f$iv$iv;
                f$iv$iv = families$iv$iv[n];
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
                ++n;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void refineFunctionArgumentsFromSource(@NotNull BasicModRoutine func, @NotNull String src) {
            void $this$forEachIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            DasRoutine dasRoutine = this.parseRoutine(src);
            if (dasRoutine == null) {
                return;
            }
            DasRoutine psiFunc = dasRoutine;
            ExaIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)func, (DasObject)psiFunc, (SqlObjectBuilder.Context)ExaIntrospector.this.getSqlHelper().getBuilderContext());
            Iterable iterable = psiFunc.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArguments(...)");
            Iterable iterable2 = iterable;
            ExaIntrospector exaIntrospector = ExaIntrospector.this;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void psiArg;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DasArgument dasArgument = (DasArgument)item$iv;
                int i = n;
                boolean bl = false;
                exaIntrospector.getSqlHelper().getBuilder().build((BasicModElement)func.getArguments().renewAt((short)(i + 1), psiArg.getName()), (DasObject)psiArg, (SqlObjectBuilder.Context)exaIntrospector.getSqlHelper().getBuilderContext());
            }
            DasArgument ret = psiFunc.getReturnArgument();
            if (func.getRoutineKind() == DasRoutine.Kind.PROCEDURE || ret == null) {
                BasicModArgument basicModArgument = (BasicModArgument)func.getReturnArgument();
                if (basicModArgument != null) {
                    basicModArgument.drop();
                }
            } else {
                ExaIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)func.createOrGetReturnArgument(), (DasObject)ret, (SqlObjectBuilder.Context)ExaIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final DasRoutine parseRoutine(String src) {
            Object object;
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = ExaIntrospector.this;
            String src$iv = src;
            boolean $i$f$parseStatement = false;
            try {
                void this_$iv$iv;
                object = BaseNativeIntrospector.access$getSqlHelper((BaseNativeIntrospector)this_$iv);
                String src$iv$iv = src$iv;
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src$iv$iv, DasRoutine.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw pce$iv;
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            return (DasRoutine)object;
        }

        /*
         * WARNING - void declaration
         */
        public final void retrieveIndices(@NotNull ExaSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExaTable exaTable = (ExaTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndices());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModIdentifyingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            NameCache tableCache = new NameCache();
            ExaIntroQueries.INSTANCE.processIndices(this.getTransaction(), schema, (Function1<? super ExaIntroQueries.IndexInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetriever.retrieveIndices$lambda$1$0(tableCache, schema, this, arg_0)));
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final List<String> parseIndexColumns(ExaIntroQueries.IndexInfo info) {
            int start;
            String remarks;
            String string = remarks = info.remarks;
            int n = start = string != null ? StringsKt.indexOf$default((CharSequence)string, (char)'(', (int)0, (boolean)false, (int)6, null) : -1;
            if (start == -1 || remarks == null || start >= remarks.length() - 1) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = new String[]{","};
            return StringsKt.split$default((CharSequence)((CharSequence)new CharSequenceSubSequence((CharSequence)remarks, start + 1, remarks.length() - 1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }

        private final void retrieveConstraints(ExaSchema schema) {
            boolean bl;
            ExaTable s;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = ExaSchemaRetriever$retrieveConstraints$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl2 = false;
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                s = (ExaTable)element$iv;
                bl = false;
                ModNamingFamily<? extends ExaKey> modNamingFamily = s.getKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getKeys(...)");
                it.invoke(modNamingFamily);
                ModNamingFamily<? extends ExaForeignKey> modNamingFamily2 = s.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getForeignKeys(...)");
                it.invoke(modNamingFamily2);
            }
            boolean bl3 = false;
            NameCache tableCache = new NameCache();
            NameCache conCache = new NameCache();
            List conCols = new ArrayList();
            ExaIntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema, (Function1<? super ExaIntroQueries.ConstraintColumnInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetriever.retrieveConstraints$lambda$1$0(tableCache, conCache, conCols, this, schema, arg_0)));
            this.setUpConstraint((ExaConstraint)conCache.getV(), conCols);
            it = ExaSchemaRetriever$retrieveConstraints$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$1 = false;
            ModNamingIdentifyingFamily<? extends ExaTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                s = (ExaTable)element$iv;
                bl = false;
                ModNamingFamily<? extends ExaKey> modNamingFamily = s.getKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getKeys(...)");
                it.invoke(modNamingFamily);
                ModNamingFamily<? extends ExaForeignKey> modNamingFamily3 = s.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getForeignKeys(...)");
                it.invoke(modNamingFamily3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void setUpConstraint(ExaConstraint con, List<ExaIntroQueries.ConstraintColumnInfo> cols) {
            boolean bl;
            ExaIntroQueries.ConstraintColumnInfo f = (ExaIntroQueries.ConstraintColumnInfo)CollectionsKt.firstOrNull(cols);
            Object object = f;
            if (object != null && (object = ((ExaIntroQueries.ConstraintColumnInfo)object).name) != null) {
                CharSequence charSequence = (CharSequence)object;
                bl = ExaIntrospector.this.SURROGATE_PATTERN.matches(charSequence);
            } else {
                bl = true;
            }
            boolean surrogate = bl;
            ExaConstraint exaConstraint = con;
            if (exaConstraint instanceof ExaKey) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ExaConstraint exaConstraint2 = con;
                ExaKey $this$setUpConstraint_u24lambda_u240 = (ExaKey)exaConstraint2;
                boolean bl2 = false;
                $this$setUpConstraint_u24lambda_u240.setNameSurrogate(surrogate);
                $this$setUpConstraint_u24lambda_u240.setPrimary(true);
                Iterable iterable = cols;
                ExaKey exaKey = $this$setUpConstraint_u24lambda_u240;
                boolean $i$f$map = false;
                void var12_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.column_name);
                }
                exaKey.setColNames((List)destination$iv$iv);
            } else if (exaConstraint instanceof ExaForeignKey) {
                Collection collection;
                ExaIntroQueries.ConstraintColumnInfo it;
                ExaConstraint exaConstraint3 = con;
                ExaForeignKey $this$setUpConstraint_u24lambda_u241 = (ExaForeignKey)exaConstraint3;
                boolean bl4 = false;
                $this$setUpConstraint_u24lambda_u241.setNameSurrogate(surrogate);
                ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo = f;
                ExaIntroQueries.ConstraintColumnInfo constraintColumnInfo2 = f;
                $this$setUpConstraint_u24lambda_u241.setRefTableRef(BasicParentReference.create((String)(constraintColumnInfo != null ? constraintColumnInfo.ref_schema : null), (BasicReference)((BasicReference)BasicNameReference.create((String)(constraintColumnInfo2 != null ? constraintColumnInfo2.ref_table : null)))));
                Iterable $this$map$iv = cols;
                ExaForeignKey exaForeignKey = $this$setUpConstraint_u24lambda_u241;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(it.ref_column);
                }
                exaForeignKey.setRefColNames((List)destination$iv$iv);
                $this$map$iv = cols;
                exaForeignKey = $this$setUpConstraint_u24lambda_u241;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ExaIntroQueries.ConstraintColumnInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(it.column_name);
                }
                exaForeignKey.setColNames((List)destination$iv$iv);
            }
            cols.clear();
        }

        private static final Unit process$lambda$0(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns((ExaLikeSchema)schema);
            this$0.retrieveConstraints(schema);
            this$0.retrieveIndices(schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$2(ExaSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveViewSources(schema);
            this$0.retrieveFunctionSources(schema);
            this$0.retrieveScriptSources(schema);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndices$lambda$1$0(NameCache $tableCache, ExaSchema $schema, ExaSchemaRetriever this$0, ExaIntroQueries.IndexInfo info) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_4 = $tableCache;
                name$iv = info.table_name;
                $i$f$get = false;
                var7_8 = this_$iv;
                var8_9 = name$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull((Object)v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var11_13 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var12_14 = this_$iv$iv;
                    var14_15 = this_$iv$iv;
                    $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveIndices$2$1$1 = false;
                    v2 = $schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                    var14_15.setV((BasicModNamedElement)((ExaTable)it.invoke(v2)));
                    v1 = this_$iv$iv.getV();
                }
                if ((v3 = (ModIdentifyingFamily<? extends ExaIndex>)v1) == null || (v3 = v3.getIndices()) == null || (v3 = (ExaIndex)v3.createOrGet(info.id)) == null) break block2;
                $this$retrieveIndices_u24lambda_u241_u240_u241 = var6_7 = v3;
                $i$a$-apply-ExaIntrospector$ExaSchemaRetriever$retrieveIndices$2$1$2 = false;
                $this$retrieveIndices_u24lambda_u241_u240_u241.setGlobal(info.is_global);
                $this$retrieveIndices_u24lambda_u241_u240_u241.setColNames(this$0.parseIndexColumns(info));
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveConstraints$lambda$1$0(NameCache $tableCache, NameCache $conCache, List $conCols, ExaSchemaRetriever this$0, ExaSchema $schema, ExaIntroQueries.ConstraintColumnInfo c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            var8_6 = $tableCache;
            name$iv = c.table_name;
            $i$f$get = false;
            var11_10 = this_$iv;
            var12_11 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var15_14 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var16_15 = this_$iv$iv;
                var18_16 = this_$iv$iv;
                $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$2$1$table$1 = false;
                ExaSchemaRetriever.access$setUpConstraint(this$0, (ExaConstraint)$conCache.getV(), $conCols);
                $conCache.setV(null);
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var18_16.setV((BasicModNamedElement)((ExaTable)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (ExaTable)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var7_19 = $conCache;
            this_$iv = c.name;
            create$iv = true;
            $i$f$get = false;
            if (this_$iv.getV() == null) ** GOTO lbl-1000
            v4 = this_$iv.getV();
            Intrinsics.checkNotNull((Object)v4);
            if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv)) {
                v5 = this_$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                this_$iv$iv = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv, (String)name$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                name$iv$iv = this_$iv;
                var18_16 = this_$iv;
                $i$a$-get-ExaIntrospector$ExaSchemaRetriever$retrieveConstraints$2$1$1 = false;
                ExaSchemaRetriever.access$setUpConstraint(this$0, (ExaConstraint)$this$retrieveConstraints_u24lambda_u241_u240_u241.getV(), $conCols);
                if (c.is_pk) {
                    v6 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue(v6, (String)"getKeys(...)");
                    v7 = (ExaConstraint)it.invoke(v6);
                } else {
                    v8 = table.getForeignKeys();
                    Intrinsics.checkNotNullExpressionValue(v8, (String)"getForeignKeys(...)");
                    v7 = (ExaConstraint)it.invoke(v8);
                }
                var18_16.setV((BasicModNamedElement)v7);
                v5 = this_$iv.getV();
            }
            $conCols.add(c);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ DBTransaction access$getTransaction(ExaSchemaRetriever $this) {
            return $this.getTransaction();
        }

        public static final /* synthetic */ void access$setUpConstraint(ExaSchemaRetriever $this, ExaConstraint con, List cols) {
            $this.setUpConstraint(con, cols);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0092\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0004B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00132\u0006\u0010\t\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0016\u001a\u00020\u00132\u0006\u0010\t\u001a\u00028\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u0018H\u0014\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "S", "Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/exasol/model/ExaRoot;", "Lcom/intellij/database/dialects/exasol/model/ExaDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "level", "Lcom/intellij/database/model/properties/Level;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;Lcom/intellij/database/model/properties/Level;)Z", "retrieveColumns", "", "(Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;)V", "retrieveAllObjects", "processAllObjects", "it", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "(Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;Lkotlin/jvm/functions/Function1;)V", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,506:1\n355#2:507\n358#2,6:510\n196#2,13:517\n1869#3,2:508\n1#4:516\n442#5,6:530\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase\n*L\n423#1:507\n423#1:510,6\n445#1:517,13\n423#1:508,2\n426#1:530,6\n*E\n"})
    private static class ExaSchemaRetrieverBase<S extends ExaLikeSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        final /* synthetic */ ExaIntrospector this$0;

        public ExaSchemaRetrieverBase(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModSchema)schema);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return false;
        }

        protected final void retrieveColumns(@NotNull S schema) {
            block5: {
                boolean bl;
                boolean bl2;
                ExaLikeTable s;
                Intrinsics.checkNotNullParameter(schema, (String)"schema");
                ExaSchema exaSchema = schema instanceof ExaSchema ? (ExaSchema)schema : null;
                ModNamingIdentifyingFamily<? extends ExaView> views = exaSchema != null ? exaSchema.getViews() : null;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                Function1 it = ExaSchemaRetrieverBase$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
                boolean bl3 = false;
                ModNamingIdentifyingFamily<? extends ExaLikeTable> modNamingIdentifyingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaLikeTable)element$iv;
                    bl2 = false;
                    ModPositioningNamingFamily modPositioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)modPositioningNamingFamily, (String)"getColumns(...)");
                    it.invoke((Object)modPositioningNamingFamily);
                }
                ModNamingIdentifyingFamily<? extends ExaView> modNamingIdentifyingFamily2 = views;
                if (modNamingIdentifyingFamily2 != null) {
                    $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        s = (ExaView)element$iv;
                        bl = false;
                        ModPositioningNamingFamily<? extends ExaViewColumn> modPositioningNamingFamily = s.getColumns();
                        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                        it.invoke(modPositioningNamingFamily);
                    }
                }
                boolean bl4 = false;
                NameCache tableCache = new NameCache();
                ExaIntroQueries.INSTANCE.processColumns(this.getTransaction(), (ExaLikeSchema)schema, (Function1<? super ExaIntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetrieverBase.retrieveColumns$lambda$1$0(tableCache, schema, views, arg_0)));
                it = ExaSchemaRetrieverBase$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
                $i$a$-modifyFamiliesAndCleanup-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$1 = false;
                ModNamingIdentifyingFamily<? extends ExaLikeTable> modNamingIdentifyingFamily3 = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
                $this$forEach$iv = (Iterable)modNamingIdentifyingFamily3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaLikeTable)element$iv;
                    bl2 = false;
                    ModPositioningNamingFamily modPositioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)modPositioningNamingFamily, (String)"getColumns(...)");
                    it.invoke((Object)modPositioningNamingFamily);
                }
                ModNamingIdentifyingFamily<? extends ExaView> modNamingIdentifyingFamily4 = views;
                if (modNamingIdentifyingFamily4 == null) break block5;
                $this$forEach$iv = (Iterable)modNamingIdentifyingFamily4;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    s = (ExaView)element$iv;
                    bl = false;
                    ModPositioningNamingFamily<? extends ExaViewColumn> modPositioningNamingFamily = s.getColumns();
                    Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                    it.invoke(modPositioningNamingFamily);
                }
            }
        }

        protected final void retrieveAllObjects(@NotNull S schema) {
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray;
            ExaSchema s;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            ExaSchema exaSchema = s = schema instanceof ExaSchema ? (ExaSchema)schema : null;
            if (exaSchema != null) {
                ExaSchema $this$retrieveAllObjects_u24lambda_u240 = exaSchema;
                boolean bl = false;
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray2 = new ModNamingIdentifyingFamily[4];
                Intrinsics.checkNotNullExpressionValue($this$retrieveAllObjects_u24lambda_u240.getTables(), (String)"getTables(...)");
                Intrinsics.checkNotNullExpressionValue($this$retrieveAllObjects_u24lambda_u240.getViews(), (String)"getViews(...)");
                Intrinsics.checkNotNullExpressionValue($this$retrieveAllObjects_u24lambda_u240.getRoutines(), (String)"getRoutines(...)");
                Intrinsics.checkNotNullExpressionValue($this$retrieveAllObjects_u24lambda_u240.getScripts(), (String)"getScripts(...)");
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray2;
            } else {
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray3 = new ModNamingIdentifyingFamily[]{schema.getTables()};
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray3;
            }
            ModNamingIdentifyingFamily[] families = modNamingIdentifyingFamilyArray;
            ModFamily[] families$iv = (ModFamily[])Arrays.copyOf(families, families.length);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (ModFamily f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            this.processAllObjects(schema, (Function1<ExaIntroQueries.ObjectInfo, Unit>)((Function1)arg_0 -> ExaSchemaRetrieverBase.retrieveAllObjects$lambda$1$0(schema, s, arg_0)));
            for (ModFamily f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        protected void processAllObjects(@NotNull S schema, @NotNull Function1<? super ExaIntroQueries.ObjectInfo, Unit> it) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter(it, (String)"it");
            ExaIntroQueries.INSTANCE.processAllObjects(this.getTransaction(), (ExaLikeSchema)schema, it);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveColumns$lambda$1$0(NameCache $tableCache, ExaLikeSchema $schema, ModNamingIdentifyingFamily $views, ExaIntroQueries.ColumnInfo info) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_4 = $tableCache;
                name$iv = info.table_name;
                $i$f$get = false;
                var7_7 = this_$iv;
                var8_8 = name$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull((Object)v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var11_12 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var12_13 = this_$iv$iv;
                    var14_14 = this_$iv$iv;
                    $i$a$-get-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$1 = false;
                    v2 = info.is_table != false ? $schema.getTables() : $views;
                    var14_14.setV((BasicModNamedElement)(v2 != null ? (ExaLikeTable)it.invoke(v2) : null));
                    v1 = this_$iv$iv.getV();
                }
                v3 = (ExaLikeTable)v1;
                if (v3 == null) break block5;
                t = v3;
                $i$a$-let-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2 = false;
                var7_7 = t.getColumns().renewAt(info.pos, info.name);
                $this$retrieveColumns_u24lambda_u241_u240_u241_u240 = (BasicModTableOrViewColumn)var7_7;
                $i$a$-apply-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2$1 = false;
                $this$retrieveColumns_u24lambda_u241_u240_u241_u240.setComment(info.comment);
                v4 = DataTypeFactory.of((String)info.type);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"of(...)");
                $this$retrieveColumns_u24lambda_u241_u240_u241_u240.setStoredType(DasUnresolvedTypeReference.Companion.of(v4));
                $this$retrieveColumns_u24lambda_u241_u240_u241_u240.setNotNull(Intrinsics.areEqual((Object)info.is_nullable, (Object)false));
                if ($this$retrieveColumns_u24lambda_u241_u240_u241_u240 instanceof ExaTableColumn) {
                    v5 = (ExaTableColumn)$this$retrieveColumns_u24lambda_u241_u240_u241_u240;
                    v6 = info.ident;
                    if (v6 != null) {
                        $i$f$get = ((Number)v6).longValue();
                        var12_13 = v5;
                        $i$a$-let-ExaIntrospector$ExaSchemaRetrieverBase$retrieveColumns$2$1$2$1$1 = false;
                        v7 = SequenceIdentity.of(null, (Long)((long)it), null, null);
                        v5 = var12_13;
                    } else {
                        v7 = null;
                    }
                    v5.setSequenceIdentity(v7);
                    ((ExaTableColumn)$this$retrieveColumns_u24lambda_u241_u240_u241_u240).setDefaultExpression(info.def);
                    ((ExaTableColumn)$this$retrieveColumns_u24lambda_u241_u240_u241_u240).setDistKey(info.is_dist_key);
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveAllObjects$lambda$1$0(ExaLikeSchema $schema, ExaSchema $s, ExaIntroQueries.ObjectInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var5_3 = info.type;
            if (var5_3 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var5_3.hashCode()) {
                case 79578030: {
                    if (var5_3.equals("TABLE")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1854356277: {
                    if (var5_3.equals("SCRIPT")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2634405: {
                    if (var5_3.equals("VIEW")) {
                        tmp = 3;
                    }
                    break;
                }
                case -2131401768: {
                    if (var5_3.equals("FUNCTION")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v0 /* !! */  = $schema.getTables();
                    break;
                }
                case 3: {
                    v1 = $s;
                    if (v1 != null) {
                        v0 /* !! */  = v1.getViews();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                case 4: {
                    v2 = $s;
                    if (v2 != null) {
                        v0 /* !! */  = v2.getRoutines();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                case 2: {
                    v3 = $s;
                    if (v3 != null) {
                        v0 /* !! */  = v3.getScripts();
                        break;
                    }
                    v0 /* !! */  = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 /* !! */  = null;
                }
            }
            if (v0 /* !! */  == null) {
                return Unit.INSTANCE;
            }
            family = v0 /* !! */ ;
            v4 = family.renew(info.id == -1L ? -9223372036854775808L : info.id, info.name);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"renew(...)");
            obj = (BasicModElement)v4;
            ((BasicModNamedElement)obj).setComment(info.comment);
            if (obj instanceof ExaRoutine) {
                ((ExaRoutine)obj).setRoutineKind(DasRoutine.Kind.FUNCTION);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J$\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaSchema;)V", "process", "", "retrieveSysColumns", "processAllObjects", "it", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,506:1\n32#2:507\n32#2,2:508\n33#2:510\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSysSchemaRetriever\n*L\n478#1:507\n480#1:508,2\n478#1:510\n*E\n"})
    private final class ExaSysSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaSchema> {
        public ExaSysSchemaRetriever(@NotNull DBTransaction transaction, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        public void process() {
            this.inSchema(arg_0 -> ExaSysSchemaRetriever.process$lambda$0(this, arg_0));
            this.inSchema(arg_0 -> ExaSysSchemaRetriever.process$lambda$1(this, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveSysColumns(ExaSchema schema) {
            DatabaseConnectionCore databaseConnectionCore = ExaIntrospector.this.getDbConnection();
            Intrinsics.checkNotNull((Object)databaseConnectionCore);
            RemoteDatabaseMetaData remoteDatabaseMetaData = databaseConnectionCore.getRemoteMetaData();
            Intrinsics.checkNotNull((Object)remoteDatabaseMetaData);
            RemoteDatabaseMetaData metaData = remoteDatabaseMetaData;
            String string = schema.getName();
            ExaDatabase exaDatabase = schema.getDatabase();
            Intrinsics.checkNotNull((Object)exaDatabase);
            DatabaseMetaDataWrapper.Schema sc = new DatabaseMetaDataWrapper.Schema(string, exaDatabase.getName());
            ExaDatabase exaDatabase2 = schema.getDatabase();
            Intrinsics.checkNotNull((Object)exaDatabase2);
            RemoteResultSet rset = metaData.getColumns(exaDatabase2.getName(), schema.getName(), null, null);
            Closeable closeable = (Closeable)new TableColumnIt.Grouping((ClosableIt)new TableColumnIt(rset, Dbms.EXASOL, sc));
            Throwable throwable = null;
            try {
                TableColumnIt.Grouping gIt = (TableColumnIt.Grouping)closeable;
                boolean bl = false;
                Iterator $this$forEach$iv = (Iterator)gIt;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    ModPositioningNamingFamily columns;
                    Object element$iv = iterator.next();
                    DatabaseMetaDataWrapper.Table it = (DatabaseMetaDataWrapper.Table)element$iv;
                    boolean bl2 = false;
                    BasicModTableOrView basicModTableOrView = (BasicModTableOrView)schema.getTableOrView(it.name);
                    Object object = basicModTableOrView != null ? basicModTableOrView.getColumns() : null;
                    if ((object instanceof ModPositioningNamingFamily ? object : null) == null) continue;
                    columns = columns;
                    JBIterator jBIterator = gIt.groupIt();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterator, (String)"groupIt(...)");
                    Iterator $this$forEach$iv2 = (Iterator)jBIterator;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2;
                    while (iterator2.hasNext()) {
                        DasType dasType;
                        Object element$iv2 = iterator2.next();
                        DatabaseMetaDataWrapper.TableColumn col = (DatabaseMetaDataWrapper.TableColumn)element$iv2;
                        boolean bl3 = false;
                        String string2 = col.name;
                        if (string2 == null) {
                            string2 = "";
                        }
                        BasicModNamedElement basicModNamedElement = columns.createOrGet(string2);
                        Intrinsics.checkNotNull((Object)basicModNamedElement, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTableOrViewColumn");
                        BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)basicModNamedElement;
                        String string3 = col.typeName;
                        if (string3 == null) {
                            string3 = "";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)JdbcIntrospectorHelper.makeDasType((String)string3, (int)col.length, (int)col.scale, null, (int)col.type, (BasicModElement)((BasicModElement)column)), (String)"makeDasType(...)");
                        column.setPosition((short)col.position);
                        column.setStoredType(dasType);
                        column.setNotNull(!col.nullable);
                        column.setDefaultExpression(col.def);
                        column.setComment(StringKt.nullize$default((String)col.comment, (boolean)false, (int)1, null));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Override
        protected void processAllObjects(@NotNull ExaSchema schema, @NotNull Function1<? super ExaIntroQueries.ObjectInfo, Unit> it) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter(it, (String)"it");
            ExaIntroQueries.INSTANCE.processAllSysObjects(this.getTransaction(), schema, it);
        }

        private static final Unit process$lambda$0(ExaSysSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaSysSchemaRetriever this$0, ExaSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveSysColumns(schema);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaSchemaRetrieverBase;", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;)V", "process", "", "retrieveSchemaProps", "retrieveSchemaExtProps", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.exasol"})
    @SourceDebugExtension(value={"SMAP\nExaIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,506:1\n1563#2:507\n1634#2,3:508\n*S KotlinDebug\n*F\n+ 1 ExaIntrospector.kt\ncom/intellij/database/dialects/exasol/introspector/ExaIntrospector$ExaVSchemaRetriever\n*L\n260#1:507\n260#1:508,3\n*E\n"})
    private final class ExaVSchemaRetriever
    extends ExaSchemaRetrieverBase<ExaVirtualSchema> {
        public ExaVSchemaRetriever(@NotNull DBTransaction transaction, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(ExaIntrospector.this, transaction, (ExaLikeSchema)schema);
        }

        public void process() {
            this.inSchema(arg_0 -> ExaVSchemaRetriever.process$lambda$0(this, ExaIntrospector.this, arg_0));
            this.inSchema(arg_0 -> ExaVSchemaRetriever.process$lambda$1(this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSchemaProps(ExaVirtualSchema schema) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ExaIntroQueries.INSTANCE.retrieveVSchemaProps(this.getTransaction(), schema);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                ExaIntroQueries.VSchemaProperty vSchemaProperty = (ExaIntroQueries.VSchemaProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.prop_name;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = it.prop_value) == null) {
                    string = "";
                }
                collection.add(new NameValue(string2, string));
            }
            List props = (List)destination$iv$iv;
            schema.setProperties(props);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSchemaExtProps(Version version, ExaVirtualSchema schema) {
            BasicReference basicReference;
            List list;
            String[] stringArray;
            ExaIntroQueries.VSchemaExtInfo info = ExaIntroQueries.INSTANCE.retrieveVSchemaExtInfo(this.getTransaction(), version, schema);
            Object object = info;
            if (object != null && (object = ((ExaIntroQueries.VSchemaExtInfo)object).adapter_script) != null) {
                stringArray = new String[]{"."};
                list = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = null;
            }
            List name2 = list;
            ExaVirtualSchema exaVirtualSchema = schema;
            List list2 = name2;
            if (list2 != null) {
                void it;
                stringArray = list2;
                ExaVirtualSchema exaVirtualSchema2 = exaVirtualSchema;
                boolean bl = false;
                basicReference = BasicParentReference.create((String)((String)CollectionsKt.getOrNull((List)it, (int)0)), (BasicReference)((BasicReference)BasicNameReference.create((String)((String)CollectionsKt.getOrNull((List)it, (int)1)))));
                exaVirtualSchema = exaVirtualSchema2;
            } else {
                basicReference = null;
            }
            exaVirtualSchema.setAdapterRef(basicReference);
            ExaIntroQueries.VSchemaExtInfo vSchemaExtInfo = info;
            schema.setLastRefresh(vSchemaExtInfo != null ? vSchemaExtInfo.last_refreshed : null);
            ExaIntroQueries.VSchemaExtInfo vSchemaExtInfo2 = info;
            schema.setLastRefreshBy(vSchemaExtInfo2 != null ? vSchemaExtInfo2.last_refreshed_by : null);
        }

        private static final Unit process$lambda$0(ExaVSchemaRetriever this$0, ExaIntrospector this$1, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Version version = ExaIntrospector.access$getRoot(this$1).getServerVersion();
            if (version == null) {
                version = Version.ZERO;
            }
            Version version2 = version;
            Intrinsics.checkNotNull((Object)version2);
            this$0.retrieveSchemaExtProps(version2, schema);
            this$0.retrieveSchemaProps(schema);
            this$0.retrieveAllObjects((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$1(ExaVSchemaRetriever this$0, ExaVirtualSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns((ExaLikeSchema)schema);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.exasol"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{5};
            return version.isOrGreater(nArray);
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new ExaIntrospector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.exasol"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

