/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentSymbol;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.lsp.api.customization.LspSymbolKindCustomizer;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/lsp/impl/documentSymbol/LspCrumb;", "Lcom/intellij/ui/components/breadcrumbs/Crumb$Impl;", "Lcom/intellij/xml/breadcrumbs/NavigatableCrumb;", "project", "Lcom/intellij/openapi/project/Project;", "customizer", "Lcom/intellij/platform/lsp/api/customization/LspSymbolKindCustomizer;", "document", "Lcom/intellij/openapi/editor/Document;", "symbol", "Lorg/eclipse/lsp4j/DocumentSymbol;", "LspCrumb", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/lsp/api/customization/LspSymbolKindCustomizer;Lcom/intellij/openapi/editor/Document;Lorg/eclipse/lsp4j/DocumentSymbol;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getAnchorOffset", "", "navigate", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "withSelection", "", "intellij.platform.lsp.impl"})
public final class LspCrumb
extends Crumb.Impl
implements NavigatableCrumb {
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final DocumentSymbol symbol;

    public LspCrumb(@NotNull Project project, @NotNull LspSymbolKindCustomizer customizer, @NotNull Document document, @NotNull DocumentSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        SymbolKind symbolKind = symbol.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)symbolKind, (String)"getKind(...)");
        super(customizer.getIcon(symbolKind), symbol.getName(), null, new Action[0]);
        this.project = project;
        this.document = document;
        this.symbol = symbol;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public TextRange getHighlightRange() {
        Range range = this.symbol.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
        return Lsp4jUtilKt.getRangeInDocument(this.document, range);
    }

    public int getAnchorOffset() {
        Position position = this.symbol.getSelectionRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Integer n10 = Lsp4jUtilKt.getOffsetInDocument(this.document, position);
        return n10 != null ? n10 : -1;
    }

    public void navigate(@NotNull Editor editor, boolean withSelection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int n10 = this.getAnchorOffset();
        if (n10 != -1) {
            Crumb.Impl.moveEditorCaretTo((Editor)editor, (int)n10);
        }
        if (withSelection) {
            TextRange textRange = this.getHighlightRange();
            Crumb.Impl.select((Editor)editor, (TextRange)textRange);
        }
    }
}

