/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.base.view;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.MoveAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ResizeToActualSizeAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ResizeToFitContentAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ToggleCollapseGraphAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ZoomInAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ZoomOutAction;
import com.intellij.xdebugger.impl.parallelStacks.base.actions.ZoomToActiveFrameAction;
import com.intellij.xdebugger.impl.parallelStacks.base.view.GraphUtilsKt;
import com.intellij.xdebugger.impl.parallelStacks.base.view.InvisibleNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksColors;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksEdgeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksEditMode;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksGraphRenderer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksViewPanel;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import s.A.AZ;
import s.A.DH;
import s.A.De;
import s.A.XK;
import s.A.bh;
import s.A.bv;
import s.R.B;
import s.R.P;
import s.R.c;
import s.R.k;
import s.R.l;
import s.R.m;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000 [*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0001[B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H&J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0015\u0010(\u001a\u00020&2\u0006\u0010\u001a\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001eJ\u0006\u0010+\u001a\u00020\u001eJ\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020&J\u0016\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J\u0006\u00102\u001a\u00020&J\u0006\u00103\u001a\u00020\u001eJ\u0006\u00104\u001a\u00020&J\u0006\u00105\u001a\u00020&J\u0006\u00106\u001a\u00020&J\u0006\u00107\u001a\u00020&J\u0006\u00108\u001a\u00020&J\u000e\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u001eJ\b\u0010;\u001a\u00020&H\u0004J\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020&2\u0006\u0010@\u001a\u00020AH\u0014J/\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020\u001e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00018\u00002\f\u0010E\u001a\b\u0012\u0004\u0012\u00020&0FH\u0004\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u00020IH\u0017J\n\u0010J\u001a\u0004\u0018\u00010KH$J\u0010\u0010L\u001a\u00020&2\u0006\u0010:\u001a\u00020\u001eH$J\b\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020KH\u0004J\b\u0010Q\u001a\u00020KH\u0002J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020W2\u0006\u0010T\u001a\u00020UH\u0002J\u0012\u0010X\u001a\u0004\u0018\u00010Y2\u0006\u0010Z\u001a\u00020IH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u0004\u0018\u00018\u00002\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000@BX\u0084\u000e\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\"\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006\\"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksView;", "TSelection", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable$Default;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "ParallelStacksView", "(Lcom/intellij/xdebugger/XDebugSession;)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "graph", "Ls/A/bv;", "getGraph", "()Ls/A/bv;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "getGraphView", "()Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "mainPanel", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksViewPanel;", "lastPauseMillis", "", "getHoveredStacks", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "value", "selection", "getSelection", "()Ljava/lang/Object;", "Ljava/lang/Object;", "", "isGraphCollapsed", "()Z", "isStopped", "mainComponent", "getMainComponent", "()Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksViewPanel;", "zoomIn", "", "zoomOut", "changeSelection", "(Ljava/lang/Object;)V", "canBeZoomedIn", "canBeZoomedOut", "isDefaultZoom", "setDefaultZoom", "moveTo", "deltaX", "", "deltaY", "resizeToFitContent", "isReady", "expandGraph", "collapseGraph", "zoomToActiveFrame", "pause", "stop", "layoutGraph", "keepPosition", "initialize", "n", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createEditMode", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksEditMode;", "graph2DView", "Ls/A/AZ;", "customizeGraphView", "resume", "forceKeepPosition", "graphBuilder", "Lkotlin/Function0;", "(ZLjava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "getEmptyText", "", "getActiveFrameRealizer", "Ls/A/bh;", "doLayout", "n", "Ljava/awt/geom/Rectangle2D;", "zoomToRealizer", "realizer", "n", "n", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "n", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "getData", "", "dataId", "Companion", "intellij.platform.debugger.parallelStacks"})
@SourceDebugExtension(value={"SMAP\nParallelStacksView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelStacksView.kt\ncom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksView\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1321#2,2:317\n1321#2,2:319\n1#3:321\n*S KotlinDebug\n*F\n+ 1 ParallelStacksView.kt\ncom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksView\n*L\n65#1:317,2\n70#1:319,2\n*E\n"})
public abstract class ParallelStacksView<TSelection>
implements DataProvider,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final bv graph;
    @NotNull
    private final UpdatableGraph2DView graphView;
    @NotNull
    private final ParallelStacksViewPanel mainPanel;
    private long lastPauseMillis;
    @Nullable
    private TSelection selection;
    private boolean isGraphCollapsed;
    private boolean isStopped;
    @NotNull
    private static final DataKey<ParallelStacksView<?>> PARALLEL_STACKS_VIEW = DataKey.Companion.create("PARALLEL_STACKS_VIEW");

    public ParallelStacksView(@NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.graph = new bv();
        this.graphView = new UpdatableGraph2DView(this.graph, this);
        this.mainPanel = new ParallelStacksViewPanel();
        this.isGraphCollapsed = true;
        this.isStopped = true;
    }

    @NotNull
    protected final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    protected final bv getGraph() {
        return this.graph;
    }

    @NotNull
    protected final UpdatableGraph2DView getGraphView() {
        return this.graphView;
    }

    @Nullable
    public abstract List<XExecutionStack> getHoveredStacks();

    @Nullable
    protected final TSelection getSelection() {
        return this.selection;
    }

    public final boolean isGraphCollapsed() {
        return this.isGraphCollapsed;
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    @NotNull
    public final ParallelStacksViewPanel getMainComponent() {
        return this.mainPanel;
    }

    public final void zoomIn() {
        if (!this.canBeZoomedIn()) {
            return;
        }
        this.graphView.zoomIn();
    }

    public final void zoomOut() {
        if (!this.canBeZoomedOut()) {
            return;
        }
        this.graphView.zoomOut();
    }

    protected final void changeSelection(TSelection selection) {
        Object object;
        boolean bl2;
        P p2;
        this.selection = selection;
        l l2 = this.graph.n();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"nodes(...)");
        Object object2 = GraphUtilsKt.asSequence((B)l2);
        boolean bl3 = false;
        for (Object e2 : object2) {
            p2 = (m)e2;
            bl2 = false;
            if (GraphUtilsKt.getParallelStacksRealizerOf(this.graph, p2) == null) continue;
            ((ParallelStacksNodeRealizer)object).updateActivity(selection);
        }
        l l3 = this.graph.n();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"edges(...)");
        object2 = GraphUtilsKt.asSequence((c)l3);
        bl3 = false;
        for (Object e2 : object2) {
            p2 = (k)e2;
            bl2 = false;
            if (GraphUtilsKt.getParallelStacksRealizer(this.graph, (k)p2) == null) continue;
            ((ParallelStacksEdgeRealizer)object).updateActivity();
        }
        this.mainPanel.repaint();
    }

    public final boolean canBeZoomedIn() {
        return this.isReady() && this.graphView.canBeZoomedIn();
    }

    public final boolean canBeZoomedOut() {
        return this.isReady() && this.graphView.canBeZoomedOut();
    }

    public final boolean isDefaultZoom() {
        return this.graphView.isDefaultZoom();
    }

    public final void setDefaultZoom() {
        this.graphView.setDefaultZoom();
    }

    public final void moveTo(int deltaX, int deltaY) {
        this.graphView.moveTo(deltaX, deltaY);
    }

    public final void resizeToFitContent() {
        this.graphView.resizeToFitContent();
    }

    public final boolean isReady() {
        return this.session.isSuspended() && !this.isStopped && !this.graph.n();
    }

    public final void expandGraph() {
        if (!this.isGraphCollapsed) {
            return;
        }
        this.isGraphCollapsed = false;
        this.layoutGraph(true);
    }

    public final void collapseGraph() {
        if (this.isGraphCollapsed) {
            return;
        }
        this.isGraphCollapsed = true;
        this.layoutGraph(true);
    }

    public final void zoomToActiveFrame() {
        this.zoomToRealizer(this.n());
        this.graphView.n();
    }

    public final void pause() {
        this.lastPauseMillis = System.currentTimeMillis();
        this.mainPanel.repaint();
    }

    public final void stop() {
        this.isStopped = true;
        this.graphView.getGraph().X();
        this.graphView.n();
    }

    public final void layoutGraph(boolean keepPosition) {
        if (this.graph.n()) {
            return;
        }
        this.doLayout(keepPosition);
        this.graphView.setBounds(this.n());
        if (keepPosition) {
            UpdatableGraph2DView.setBoundedViewPoint2D$default(this.graphView, this.graphView.n().getX(), this.graphView.n().getY(), 0, 0, 12, null);
        } else {
            bh bh2 = this.n();
            boolean bl2 = false;
            this.zoomToRealizer(bh2);
            this.graphView.setActivePoint(new Point2D.Double(bh2.X(), bh2.A()));
        }
        ActivityTracker.getInstance().inc();
    }

    protected final void initialize() {
        Object object;
        Object object2 = object = this.graphView;
        boolean bl2 = false;
        this.customizeGraphView((AZ)object2);
        Object object3 = object2 = this.createEditMode(this.graphView);
        boolean bl3 = false;
        ((DH)object3).R(false);
        ((DH)object3).u(false);
        ((DH)object3).x(false);
        ((DH)object3).X(false);
        ((DH)object3).A(false);
        ((DH)object3).i(false);
        ((DH)object3).I(false);
        ((DH)object3).b(false);
        ((DH)object3).T(false);
        ((DH)object3).L(false);
        ((DH)object3).e(false);
        object = object2;
        this.graphView.n((De)object);
        ((DH)object).activate(true);
        object2 = this.n();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup[]{object2};
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup((AnAction[])defaultActionGroup);
        boolean bl4 = false;
        DefaultActionGroup defaultActionGroup3 = new DefaultActionGroup[]{ActionManager.getInstance().getAction("XDebugger.ParallelStacks.ToolBar.Extra")};
        defaultActionGroup2.addAll((AnAction[])defaultActionGroup3);
        object3 = defaultActionGroup;
        defaultActionGroup = this.n((ActionGroup)object3);
        DefaultActionGroup defaultActionGroup4 = new DefaultActionGroup[]{object2};
        defaultActionGroup3 = defaultActionGroup4 = new DefaultActionGroup((AnAction[])defaultActionGroup4);
        boolean bl5 = false;
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.ParallelStacks.Popup.FreezeThreadGroup")};
        defaultActionGroup3.addAll(anActionArray);
        anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.ParallelStacks.Popup.Extra")};
        defaultActionGroup3.addAll(anActionArray);
        defaultActionGroup2 = defaultActionGroup4;
        defaultActionGroup4 = this.n((ActionGroup)defaultActionGroup2);
        this.graphView.setComponentPopupMenu(defaultActionGroup4.getComponent());
        this.mainPanel.addGraph(this.graphView);
        this.mainPanel.addToolbar((ActionToolbar)defaultActionGroup);
        DataManager.registerDataProvider((JComponent)((JComponent)((Object)this.mainPanel)), (DataProvider)this);
    }

    private final DefaultActionGroup n() {
        ZoomInAction zoomInAction = new ZoomInAction();
        ZoomOutAction zoomOutAction = new ZoomOutAction();
        ResizeToActualSizeAction resizeToActualSizeAction = new ResizeToActualSizeAction();
        ResizeToFitContentAction resizeToFitContentAction = new ResizeToFitContentAction();
        ToggleCollapseGraphAction toggleCollapseGraphAction = new ToggleCollapseGraphAction();
        ZoomToActiveFrameAction zoomToActiveFrameAction = new ZoomToActiveFrameAction();
        MoveAction moveAction = new MoveAction(1, 0);
        MoveAction moveAction2 = new MoveAction(-1, 0);
        MoveAction moveAction3 = new MoveAction(0, 1);
        MoveAction moveAction4 = new MoveAction(0, -1);
        Shortcut[] shortcutArray = new DefaultActionGroup[]{KeyboardShortcut.fromString((String)"control ADD"), KeyboardShortcut.fromString((String)"control EQUALS")};
        zoomInAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"control SUBTRACT"), KeyboardShortcut.fromString((String)"control MINUS")};
        zoomOutAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"control DIVIDE"), KeyboardShortcut.fromString((String)"control SLASH")};
        resizeToActualSizeAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"control 0"), KeyboardShortcut.fromString((String)"control NUMPAD0")};
        resizeToFitContentAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"control alt MULTIPLY"), KeyboardShortcut.fromString((String)"control alt 8")};
        toggleCollapseGraphAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"control SPACE")};
        zoomToActiveFrameAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.mainPanel));
        moveAction.registerCustomShortcutSet(39, 0, (JComponent)((Object)this.mainPanel));
        moveAction2.registerCustomShortcutSet(37, 0, (JComponent)((Object)this.mainPanel));
        moveAction3.registerCustomShortcutSet(40, 0, (JComponent)((Object)this.mainPanel));
        moveAction4.registerCustomShortcutSet(38, 0, (JComponent)((Object)this.mainPanel));
        AnAction[] anActionArray = new AnAction[]{zoomInAction, zoomOutAction, resizeToActualSizeAction, resizeToFitContentAction, zoomToActiveFrameAction, new Separator(), toggleCollapseGraphAction, moveAction, moveAction2, moveAction3, moveAction4};
        shortcutArray = new DefaultActionGroup(anActionArray);
        if (!ExperimentalUI.Companion.isNewUI() && !Registry.Companion.is("debugger.new.tool.window.layout")) {
            anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")};
            shortcutArray.addAll(anActionArray);
        }
        return shortcutArray;
    }

    @NotNull
    protected ParallelStacksEditMode createEditMode(@NotNull AZ graph2DView) {
        Intrinsics.checkNotNullParameter((Object)graph2DView, (String)"graph2DView");
        return new ParallelStacksEditMode(this.graphView);
    }

    protected void customizeGraphView(@NotNull AZ graph2DView) {
        XK xK;
        AZ aZ;
        Intrinsics.checkNotNullParameter((Object)graph2DView, (String)"graph2DView");
        AZ aZ2 = aZ = graph2DView;
        boolean bl2 = false;
        aZ2.r(true);
        XK xK2 = xK = new XK(aZ2);
        AZ aZ3 = aZ2;
        boolean bl3 = false;
        xK2.n((Color)ParallelStacksColors.INSTANCE.getPARALLEL_STACKS_BACKGROUND_COLOR());
        aZ3.n(xK);
        aZ2.n(new ParallelStacksGraphRenderer());
    }

    protected final void resume(boolean forceKeepPosition, @Nullable TSelection selection, @NotNull Function0<Unit> graphBuilder) {
        Intrinsics.checkNotNullParameter(graphBuilder, (String)"graphBuilder");
        long l2 = System.currentTimeMillis();
        boolean bl2 = forceKeepPosition || l2 - this.lastPauseMillis < 2000L;
        this.graph.X();
        graphBuilder.invoke();
        this.layoutGraph(bl2);
        this.isStopped = false;
        TSelection TSelection = selection;
        if (TSelection != null) {
            TSelection TSelection2 = TSelection;
            boolean bl3 = false;
            this.changeSelection(TSelection2);
        }
        this.graphView.revalidate();
        this.graphView.repaint();
    }

    public static /* synthetic */ void resume$default(ParallelStacksView parallelStacksView, boolean bl2, Object object, Function0 function0, int n10, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resume");
        }
        if ((n10 & 2) != 0) {
            object = null;
        }
        parallelStacksView.resume(bl2, object, (Function0<Unit>)function0);
    }

    @Nls
    @NotNull
    public String getEmptyText() {
        return "";
    }

    @Nullable
    protected abstract bh getActiveFrameRealizer();

    protected abstract void doLayout(boolean var1);

    private final Rectangle2D n() {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        l l2 = this.graph.n();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"nodes(...)");
        for (m m2 : GraphUtilsKt.asSequence((B)l2)) {
            bh bh2 = this.graph.n(m2);
            if (bh2 instanceof InvisibleNodeRealizer) continue;
            d2 = Math.min(d2, bh2.s());
            d3 = Math.min(d3, bh2.D());
            d4 = Math.max(d4, bh2.s() + bh2.r());
            d5 = Math.max(d5, bh2.D() + bh2.n());
        }
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    protected final void zoomToRealizer(@NotNull bh realizer) {
        Intrinsics.checkNotNullParameter((Object)realizer, (String)"realizer");
        this.graphView.zoomToRealizer(realizer);
    }

    private final bh n() {
        bh bh2 = this.getActiveFrameRealizer();
        if (bh2 == null) {
            bh bh3 = this.graph.n(this.graph.n().n());
            bh2 = bh3;
            Intrinsics.checkNotNullExpressionValue((Object)bh3, (String)"getRealizer(...)");
        }
        return bh2;
    }

    private final ActionToolbar n(ActionGroup actionGroup) {
        ActionToolbar actionToolbar;
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("toolbar", actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar3 = actionToolbar = actionToolbar2;
        boolean bl2 = false;
        actionToolbar3.setTargetComponent((JComponent)((Object)this.mainPanel));
        return actionToolbar;
    }

    private final ActionPopupMenu n(ActionGroup actionGroup) {
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ParallelStacksPopup", actionGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        return actionPopupMenu;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (PARALLEL_STACKS_VIEW.is(dataId)) {
            return this;
        }
        if (XExecutionStack.SELECTED_STACKS.is(dataId)) {
            return this.getHoveredStacks();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksView$Companion;", "", "ParallelStacksView$Companion", "()V", "PARALLEL_STACKS_VIEW", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksView;", "getPARALLEL_STACKS_VIEW", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.debugger.parallelStacks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<ParallelStacksView<?>> getPARALLEL_STACKS_VIEW() {
            return PARALLEL_STACKS_VIEW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

