/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionType {
    public static final int TYPES_NUMBER_LIMIT = 5;
    private final boolean myAnyType;

    JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, _types);
        this.myAnyType = ContainerUtil.exists(this.getTypes(), el -> el instanceof JSAnyType);
    }

    JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(3);
        }
        super(source, inputStream);
        this.myAnyType = ContainerUtil.exists(this.getTypes(), el -> el instanceof JSAnyType);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(5);
        }
        return JSCompositeTypeImpl.isDirectlyAssignableTypeImpl(this, elementType, processingContext);
    }

    public static boolean isDirectlyAssignableTypeImpl(@NotNull JSUnionType thisType, @NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (thisType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(6);
        }
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(8);
        }
        if (thisType.isAnyType()) {
            return true;
        }
        if (TypeScriptTypeRelations.isBooleanUnionType(thisType) && elementType instanceof JSBooleanType) {
            return true;
        }
        boolean processingInProgress = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        JSType jSType = elementType = processingInProgress ? elementType : TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType);
        if (JSCompositeTypeImpl.anyNestedTypeEqualsTo(thisType, elementType, processingContext)) {
            return true;
        }
        JSUnionType unionType = JSCompositeTypeImpl.getPossibleUnionType(elementType);
        if (unionType != null) {
            boolean checkAll = thisType.isTypeScript() && thisType.isSourceStrict() && elementType.isSourceStrict() || processingInProgress;
            return JSTypeCastUtil.checkAssignableComposite(thisType, unionType, processingContext, checkAll);
        }
        if (elementType instanceof JSTemplateLiteralType) {
            JSType substituted = TypeScriptTypeRelations.getTemplateLiteralConstraintType((JSTemplateLiteralType)elementType);
            if (substituted instanceof JSUnionType) {
                return JSTypeCastUtil.checkAssignableComposite(thisType, (JSUnionType)substituted, processingContext, true);
            }
            return JSCompositeTypeImpl.anyNestedTypeIsAssignableTo(thisType, substituted, processingContext);
        }
        return JSCompositeTypeImpl.anyNestedTypeIsAssignableTo(thisType, elementType, processingContext);
    }

    @Nullable
    private static JSUnionType getPossibleUnionType(@NotNull JSType type) {
        JSType constraintType;
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(9);
        }
        if (type instanceof JSUnionType) {
            return (JSUnionType)type;
        }
        if (type instanceof JSGenericParameterType && (constraintType = ((JSGenericParameterType)type).getConstraintType()) instanceof JSUnionType) {
            return (JSUnionType)constraintType;
        }
        return null;
    }

    private static boolean anyNestedTypeIsAssignableTo(@NotNull JSUnionType thisType, @NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (thisType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(10);
        }
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(11);
        }
        boolean hasAssignable = false;
        boolean isProcessingGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        for (JSType t : thisType.getTypes()) {
            if (JSCompositeTypeImpl.isEmptyType(t) || JSTypeUtils.isNullOrUndefinedType(t) || isProcessingGenerics && hasAssignable && JSCompositeTypeImpl.getNotMappedGenerics(t, processingContext).isEmpty() || !t.isDirectlyAssignableType(elementType, processingContext)) continue;
            hasAssignable = true;
            if (isProcessingGenerics) continue;
            return true;
        }
        if (isProcessingGenerics && hasAssignable) {
            JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
            for (JSType t : thisType.getTypes()) {
                mappings.getMappingsPossiblyNever().addAll(JSCompositeTypeImpl.getNotMappedGenerics(t, processingContext));
            }
        }
        return hasAssignable;
    }

    private static Set<JSTypeGenericId> getNotMappedGenerics(@NotNull JSType originalType, @NotNull ProcessingContext context) {
        if (originalType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(13);
        }
        final HashSet<JSTypeGenericId> allIDs = new HashSet<JSTypeGenericId>();
        originalType.accept(new JSRecursiveTypeVisitor(false){

            @Override
            public void visitJSType(@NotNull JSType tt) {
                if (tt == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (tt instanceof JSGenericParameterImpl && ((JSGenericParameterImpl)tt).isApplying()) {
                    allIDs.add(((JSGenericParameterImpl)tt).getGenericId());
                }
                super.visitJSType(tt);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tt", "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl$1", "visitJSType"));
            }
        });
        JSGenericMappings mappings = (JSGenericMappings)context.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        Set allInferredKeys = mappings.getMapping().keySet();
        allIDs.removeAll(allInferredKeys);
        return allIDs;
    }

    private static boolean anyNestedTypeEqualsTo(@NotNull JSUnionType thisType, @NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (thisType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(14);
        }
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        JSType regularLiteralType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(elementType);
        return ContainerUtil.exists(thisType.getTypes(), type -> type != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(type).isEquivalentTo(regularLiteralType, processingContext));
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean isSimpleTransformer) {
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(16);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(17);
        }
        if (isSimpleTransformer) {
            return new JSCompositeTypeImpl(newSource, Collections.unmodifiableList(transformedTypes));
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(newSource, transformedTypes);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @Override
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType result;
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(19);
        }
        if ((result = JSCompositeTypeImpl.getSimpleCompositeTypeResult(this)) != null) {
            return result;
        }
        return TypeScriptTypeRelations.expandUnionOrIntersectionType(this, context);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSType rawTypeToProcess = JSCompositeTypeFactory.optimizeTypeForSubstitute(this, JSTypeEvaluationLocationProvider.getTypeEvaluationLocation());
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSRecordType jSRecordType = rawTypeToProcess.asRecordType();
            if (jSRecordType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(20);
            }
            return jSRecordType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        for (JSType type1 : typeToProcess.getTypes()) {
            if (!JSCompositeTypeImpl.hasNoRecordType(type1)) continue;
            return new JSNotARecordType(this.getSource());
        }
        for (JSType type1 : typeToProcess.getTypes()) {
            JSRecordType rec;
            if (!(type1 instanceof JSRecordType) || (rec = (JSRecordType)type1).hasMembers()) continue;
            return new JSRecordTypeImpl(this.getSource(), Collections.emptyList());
        }
        ArrayList<JSRecordType> resolvedTypes = new ArrayList<JSRecordType>(JSCompositeTypeImpl.getNestedTypesAsRecordType(typeToProcess));
        if (resolvedTypes.isEmpty()) {
            return new JSRecordTypeImpl(this.getSource(), ContainerUtil.emptyList());
        }
        JSRecordType forProperties = JSCompositeTypeImpl.findWithMinimalMemberCount(resolvedTypes);
        ArrayList<JSRecordType.TypeMember> resultMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSRecordType.TypeMember member : forProperties.getTypeMembers()) {
            ProgressManager.checkCanceled();
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            this.addCommonPropertyMember(resolvedTypes, resultMembers, (JSRecordType.PropertySignature)member);
        }
        JSRecordType first = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        this.addCommonCallSignatureMembers(resolvedTypes, resultMembers, first.getCallSignatures());
        return new JSRecordTypeImpl(this.getSource(), resultMembers);
    }

    @ApiStatus.Internal
    public static boolean hasNoRecordType(@NotNull JSType type) {
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(21);
        }
        return type instanceof JSUnknownType || type instanceof JSUndefinedType || type instanceof TypeScriptNeverType || type instanceof JSNullType;
    }

    @NotNull
    private static JSRecordType findWithMinimalMemberCount(@NotNull Collection<JSRecordType> resolvedTypes) {
        if (resolvedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(22);
        }
        JSRecordType candidate = null;
        for (JSRecordType type : resolvedTypes) {
            List<JSRecordType.TypeMember> members = type.getTypeMembers();
            if (type.hasIndexers()) continue;
            int size = members.size();
            if (size == 0) {
                JSRecordType jSRecordType = type;
                if (jSRecordType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(23);
                }
                return jSRecordType;
            }
            if (candidate != null && candidate.getTypeMembers().size() <= size) continue;
            candidate = type;
        }
        JSRecordType jSRecordType = (JSRecordType)ObjectUtils.coalesce(candidate, (Object)((JSRecordType)ContainerUtil.getFirstItem(resolvedTypes)));
        if (jSRecordType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(24);
        }
        return jSRecordType;
    }

    private void addCommonCallSignatureMembers(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        JSRecordType functionTypeMembers;
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(25);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(26);
        }
        if (callSignatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(27);
        }
        if (callSignatures.isEmpty()) {
            return;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element == null || !element.isValid()) {
            return;
        }
        ProgressManager.checkCanceled();
        SmartList toProcessNewSignatures = new SmartList();
        SmartList toProcessCallSignatures = new SmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            (signature.hasNew() ? toProcessNewSignatures : toProcessCallSignatures).add(signature);
        }
        boolean collectNew = !toProcessNewSignatures.isEmpty();
        boolean collectCall = !toProcessCallSignatures.isEmpty();
        List<List<JSRecordType.CallSignature>> newTable = collectNew ? JSCompositeTypeImpl.createTable((List<JSRecordType.CallSignature>)toProcessNewSignatures) : ContainerUtil.emptyList();
        List<List<JSRecordType.CallSignature>> callTable = collectCall ? JSCompositeTypeImpl.createTable((List<JSRecordType.CallSignature>)toProcessCallSignatures) : ContainerUtil.emptyList();
        for (JSRecordType type : typesToMerge) {
            List<JSRecordType.CallSignature> signatures = type.getCallSignatures();
            if (collectCall) {
                collectCall = JSCompositeTypeImpl.addToTable(callTable, signatures, false);
            }
            if (!collectNew) continue;
            collectNew = JSCompositeTypeImpl.addToTable(newTable, signatures, true);
        }
        int before = resultMembers.size();
        if (collectCall) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(callTable, element));
        }
        if (collectNew) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(newTable, element));
        }
        if ((collectCall || collectNew) && before == resultMembers.size() && (functionTypeMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement())) != null) {
            resultMembers.addAll(functionTypeMembers.getTypeMembers());
        }
    }

    private static boolean addToTable(@NotNull List<List<JSRecordType.CallSignature>> callTable, @NotNull List<JSRecordType.CallSignature> signatures, boolean b) {
        if (callTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(28);
        }
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(29);
        }
        List<JSRecordType.CallSignature> collected = JSCompositeTypeImpl.getSignaturesWithKind(signatures, b);
        callTable.add(collected);
        return !collected.isEmpty();
    }

    private static @Unmodifiable @NotNull List<JSRecordType.CallSignature> getSignaturesWithKind(@NotNull List<JSRecordType.CallSignature> signatures, boolean hasNew) {
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.filter(signatures, el -> el.hasNew() == hasNew);
        if (list == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static List<List<JSRecordType.CallSignature>> createTable(@NotNull List<JSRecordType.CallSignature> value) {
        if (value == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(32);
        }
        ArrayList<List<JSRecordType.CallSignature>> result = new ArrayList<List<JSRecordType.CallSignature>>();
        result.add(value);
        return result;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> getUnionSignatures(@NotNull List<? extends List<JSRecordType.CallSignature>> signatureTable, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (signatureTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(33);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(34);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(35);
            }
            return list;
        }
        ArrayList<JSRecordType.CallSignature> result = new ArrayList<JSRecordType.CallSignature>();
        ArrayList<JSRecordType.CallSignature> postponed = new ArrayList<JSRecordType.CallSignature>();
        for (int i = 0; i < signatureTable.size(); ++i) {
            List<JSRecordType.CallSignature> signatures = signatureTable.get(i);
            for (JSRecordType.CallSignature signature : signatures) {
                JSFunctionType type;
                JSRecordType.CallSignature callSignature;
                if (!result.isEmpty() && TypeScriptSignatureChooser.findMatchedSignature(result, signature, false, true) != null) continue;
                List<JSRecordType.CallSignature> matchingSignatures = TypeScriptSignatureChooser.findMatchingSignatures(signatureTable, signature, i);
                if (matchingSignatures.size() > 1) {
                    callSignature = matchingSignatures.get(0);
                    type = callSignature.getFunctionType();
                    boolean postponedAdd = false;
                    for (JSRecordType.CallSignature matchingSignature : matchingSignatures) {
                        JSFunctionType candidate = matchingSignature.getFunctionType();
                        if (type != candidate) {
                            JSFunctionType commonFunctionType = JSCompositeTypeImpl.getCommonFunctionType(type, candidate, holder);
                            if (commonFunctionType != null) {
                                type = commonFunctionType;
                            } else if (candidate.hasGenericArguments()) {
                                postponedAdd = true;
                                break;
                            }
                        }
                        if (!candidate.hasGenericArguments()) continue;
                        postponed.add(matchingSignature);
                        postponedAdd = true;
                        break;
                    }
                    if (postponedAdd) continue;
                    result.add(new CallSignatureImpl(callSignature.hasNew(), type));
                    continue;
                }
                if (matchingSignatures.size() != 1) continue;
                callSignature = matchingSignatures.get(0);
                type = callSignature.getFunctionType();
                if (type.hasGenericArguments()) {
                    postponed.add(callSignature);
                    continue;
                }
                result.add(callSignature);
            }
        }
        result.addAll(postponed);
        ArrayList<JSRecordType.CallSignature> arrayList = result;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Nullable
    private static JSFunctionType getCommonFunctionType(@NotNull JSFunctionType lType, @NotNull JSFunctionType rType, @NotNull DialectOptionHolder holder) {
        if (lType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(37);
        }
        if (rType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(38);
        }
        if (holder == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(39);
        }
        if (rType.isEquivalentTo(lType, null)) {
            return lType;
        }
        int count = JSCompositeTypeImpl.getIntersectionParameters(lType, rType);
        if (count == -1) {
            return null;
        }
        List<JSParameterTypeDecorator> lParameters = lType.getParameters();
        List<JSParameterTypeDecorator> rParameters = rType.getParameters();
        ArrayList<JSParameterTypeDecoratorImpl> resultParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        int lLength = lParameters.size();
        int rLength = rParameters.size();
        for (int i = 0; i < count; ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = lLength > i ? lParameters.get(i) : null;
            JSParameterTypeDecorator rDecorator = rLength > i ? rParameters.get(i) : null;
            JSType lParameterType = lDecorator == null || lDecorator.isRest() && rDecorator != null && !rDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(lParameters) : lDecorator.getSimpleType();
            JSType jSType = rParameterType = rDecorator == null || rDecorator.isRest() && lDecorator != null && !lDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(rParameters) : rDecorator.getSimpleType();
            if (lDecorator == null) {
                lDecorator = rDecorator;
            }
            if (rDecorator == null) {
                rDecorator = lDecorator;
            }
            if (rDecorator == null) {
                Logger.getInstance(JSCompositeTypeImpl.class).error("Incorrect state in signature merging \nltype: " + lType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "\nrtype: " + rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                return null;
            }
            JSType parameterType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lParameterType, rParameterType);
            boolean isOptional = lDecorator.isOptional() && rDecorator.isOptional();
            boolean explicit = rDecorator.isExplicitlyDeclared() && lDecorator.isExplicitlyDeclared();
            boolean isRest = lDecorator.isRest() && rDecorator.isRest();
            resultParameters.add(new JSParameterTypeDecoratorImpl(parameterType, isOptional, isRest, explicit));
        }
        JSType lReturnType = lType.getReturnType();
        JSType rReturnType = rType.getReturnType();
        JSType resultReturn = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lReturnType, rReturnType);
        return new JSFunctionTypeImpl(lType.getSource(), resultParameters, resultReturn);
    }

    private static int getIntersectionParameters(JSFunctionType commonCurrent, JSFunctionType type) {
        int min2;
        List<JSParameterTypeDecorator> commonCurrentParameters = commonCurrent.getParameters();
        List<JSParameterTypeDecorator> typeParameters = type.getParameters();
        int max1 = TypeScriptSignatureChooser.getMaxArgumentCount(commonCurrentParameters);
        int max2 = TypeScriptSignatureChooser.getMaxArgumentCount(typeParameters);
        int commonMaxLength = Math.min(max1, max2);
        int min1 = TypeScriptSignatureChooser.getMinArgumentCount(commonCurrentParameters);
        int commonMinLength = Math.max(min1, min2 = TypeScriptSignatureChooser.getMinArgumentCount(typeParameters));
        if (commonMinLength > commonMaxLength) {
            return -1;
        }
        if (commonMaxLength == commonMinLength) {
            return commonMaxLength;
        }
        return commonMaxLength == Integer.MAX_VALUE ? Math.min(commonCurrentParameters.size(), typeParameters.size()) : commonMaxLength;
    }

    @Nullable
    private static JSType getRestComponentType(@NotNull List<JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(40);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getSimpleType() != null ? JSTypeUtils.getIndexableComponentType(last.getSimpleType()) : null;
    }

    @Nullable
    private static JSType getCommonTypeWithDialect(@Nullable DialectOptionHolder holder, @Nullable JSType lType, @Nullable JSType rType) {
        JSType parameterType = null;
        if (lType != null && rType != null) {
            parameterType = JSTypeUtils.getCommonType(lType, rType, holder, true);
        }
        return parameterType != null ? parameterType : (lType == null ? rType : lType);
    }

    private void addCommonPropertyMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.PropertySignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(41);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(42);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(43);
        }
        ProgressManager.checkCanceled();
        LinkedHashSet<JSType> commonTypes = new LinkedHashSet<JSType>();
        JSType startType = currentProperty.getJSType();
        ContainerUtil.addIfNotNull(commonTypes, (Object)startType);
        String memberName = currentProperty.getMemberName();
        JSRecordType.MemberSource source = currentProperty.getMemberSource();
        ArrayList<PsiElement> allProps = new ArrayList<PsiElement>(source.getAllSourceElements());
        boolean isOptional = currentProperty.isOptional();
        boolean isReadonly = currentProperty.isConst();
        JSAnyType anyType = startType instanceof JSAnyType ? (JSAnyType)startType : null;
        for (JSRecordType resolvedType : typesToMerge) {
            ProgressManager.checkCanceled();
            JSRecordType.PropertySignature signature = resolvedType.findPropertySignature(memberName);
            if (signature == null) {
                JSRecordType.IndexSignature indexer = resolvedType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
                if (indexer != null) {
                    commonTypes.add(indexer.getMemberType());
                    continue;
                }
                return;
            }
            if (currentProperty == signature) continue;
            if (signature.isOptional()) {
                isOptional = true;
            }
            if (signature.isConst()) {
                isReadonly = true;
            }
            JSType type = signature.getJSType();
            if (anyType == null) {
                if (type instanceof JSAnyType) {
                    anyType = (JSAnyType)type;
                } else {
                    ContainerUtil.addIfNotNull(commonTypes, (Object)type);
                }
            }
            allProps.addAll(signature.getMemberSource().getAllSourceElements());
        }
        JSAnyType commonType = anyType != null ? anyType : JSCompositeTypeFactory.getCommonType(commonTypes, this.getSource(), true);
        String name = currentProperty.getMemberName();
        JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(allProps, JSRecordType.MemberSourceKind.Union, true);
        resultMembers.add(new PropertySignatureImpl(name, (JSType)commonType, isOptional, isReadonly, memberSource));
    }

    @Override
    public boolean isAnyType() {
        return this.myAnyType;
    }

    @Deprecated
    @NotNull
    public List<JSType> getPresentableTypes(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(44);
        }
        List<JSType> list = JSCompositeTypeImpl.getPresentableTypes(this, format);
        if (list == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(45);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 20, 23, 24, 31, 35, 36, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 13: 
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 31: 
            case 35: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedTypes";
                break;
            }
            case 25: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMerge";
                break;
            }
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultMembers";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTable";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureTable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProperty";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findWithMinimalMemberCount";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesWithKind";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionSignatures";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleUnionType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeIsAssignableTo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNotMappedGenerics";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeEqualsTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 31: 
            case 35: 
            case 36: 
            case 45: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasNoRecordType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findWithMinimalMemberCount";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addCommonCallSignatureMembers";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addToTable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesWithKind";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUnionSignatures";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFunctionType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addCommonPropertyMember";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 20, 23, 24, 31, 35, 36, 45 -> new IllegalStateException(string);
        };
    }
}

