"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageHelpers = void 0;
var openapi_sampler_1 = require("openapi-sampler");
var MessageHelpers = (function () {
    function MessageHelpers() {
    }
    MessageHelpers.generateExample = function (schema, options) {
        if (options === void 0) { options = {}; }
        try {
            return this.sanitizeExample((0, openapi_sampler_1.sample)(schema, options)) || '';
        }
        catch (e) {
            return '';
        }
    };
    MessageHelpers.sanitizeExample = function (schema) {
        var _this = this;
        if (typeof schema === 'object' && schema && !Array.isArray(schema)) {
            return Object.entries(schema).reduce(function (obj, _a) {
                var propertyName = _a[0], property = _a[1];
                if (!propertyName.startsWith('x-parser-') &&
                    !propertyName.startsWith('x-schema-private-')) {
                    obj[propertyName] = _this.sanitizeExample(property);
                }
                return obj;
            }, {});
        }
        return schema;
    };
    MessageHelpers.getPayloadExamples = function (msg) {
        var _a;
        var examples = msg.examples().all();
        if (examples.some(function (e) { return e.hasPayload(); })) {
            var messageExamples = examples
                .flatMap(function (e) {
                if (!e.payload()) {
                    return;
                }
                return {
                    name: e.name(),
                    summary: e.summary(),
                    example: e.payload(),
                };
            })
                .filter(Boolean);
            if (messageExamples.length > 0) {
                return messageExamples;
            }
        }
        var payload = msg.payload();
        if (payload === null || payload === void 0 ? void 0 : payload.examples()) {
            return (_a = payload.examples()) === null || _a === void 0 ? void 0 : _a.map(function (example) { return ({ example: example }); });
        }
        return undefined;
    };
    MessageHelpers.getHeadersExamples = function (msg) {
        var _a;
        var examples = msg.examples().all();
        if (examples.some(function (e) { return e.hasHeaders(); })) {
            var messageExamples = examples
                .flatMap(function (e) {
                if (!e.hasHeaders()) {
                    return;
                }
                return {
                    name: e.name(),
                    summary: e.summary(),
                    example: e.headers(),
                };
            })
                .filter(Boolean);
            if (messageExamples.length > 0) {
                return messageExamples;
            }
        }
        var headers = msg.headers();
        if (headers === null || headers === void 0 ? void 0 : headers.examples()) {
            return (_a = headers.examples()) === null || _a === void 0 ? void 0 : _a.map(function (example) { return ({ example: example }); });
        }
        return undefined;
    };
    return MessageHelpers;
}());
exports.MessageHelpers = MessageHelpers;
//# sourceMappingURL=message.js.map