var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { Component } from 'react';
import { SpecificationHelpers } from '../../helpers';
import { defaultConfig } from '../../config';
import AsyncApiLayout from './Layout';
import { Error } from '../Error/Error';
var AsyncApiComponent = (function (_super) {
    __extends(AsyncApiComponent, _super);
    function AsyncApiComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            asyncapi: undefined,
            error: undefined,
        };
        var parsedSpec = SpecificationHelpers.retrieveParsedSpec(props.schema);
        if (parsedSpec) {
            _this.state = { asyncapi: parsedSpec };
        }
        return _this;
    }
    AsyncApiComponent.prototype.componentDidMount = function () {
        if (!this.state.asyncapi) {
            this.updateState(this.props.schema);
        }
    };
    AsyncApiComponent.prototype.componentDidUpdate = function (prevProps) {
        var oldSchema = prevProps.schema;
        var newSchema = this.props.schema;
        if (oldSchema !== newSchema) {
            this.updateState(newSchema);
        }
    };
    AsyncApiComponent.prototype.render = function () {
        var _a;
        var _b = this.props, config = _b.config, propError = _b.error;
        var _c = this.state, asyncapi = _c.asyncapi, stateError = _c.error;
        var error = propError !== null && propError !== void 0 ? propError : stateError;
        var concatenatedConfig = __assign(__assign(__assign({}, defaultConfig), config), { show: __assign(__assign({}, defaultConfig.show), (!!config && config.show)), expand: __assign(__assign({}, defaultConfig.expand), (!!config && config.expand)), sidebar: __assign(__assign({}, defaultConfig.sidebar), (!!config && config.sidebar)), extensions: __assign(__assign({}, defaultConfig.extensions), (!!config && config.extensions)) });
        if (!asyncapi) {
            if (!error) {
                return null;
            }
            return (((_a = concatenatedConfig.show) === null || _a === void 0 ? void 0 : _a.errors) && (React.createElement("section", { className: "aui-root" },
                React.createElement(Error, { error: error }))));
        }
        return React.createElement(AsyncApiLayout, { asyncapi: asyncapi, config: concatenatedConfig });
    };
    AsyncApiComponent.prototype.updateState = function (schema) {
        var parsedSpec = SpecificationHelpers.retrieveParsedSpec(schema);
        if (!parsedSpec) {
            this.setState({ asyncapi: undefined });
            return;
        }
        this.setState({ asyncapi: parsedSpec });
    };
    return AsyncApiComponent;
}(Component));
export default AsyncApiComponent;
//# sourceMappingURL=Standalone.js.map