<!-- Autogenerated by weave; DO NOT EDIT -->
# MCP SDK prototype

[![PkgGoDev](https://pkg.go.dev/badge/golang.org/x/tools)](https://pkg.go.dev/golang.org/x/tools/internal/mcp)

# Contents

1. [Installation](#installation)
1. [Quickstart](#quickstart)
1. [Design](#design)
1. [Testing](#testing)
1. [Code of Conduct](#code-of-conduct)
1. [License](#license)

The mcp package provides a software development kit (SDK) for writing clients
and servers of the [model context
protocol](https://modelcontextprotocol.io/introduction). It is unstable, and
will change in breaking ways in the future. As of writing, it is a prototype to
explore the design space of client/server transport and binding.

# Installation

The mcp package is currently internal and cannot be imported using `go get`.

# Quickstart

Here's an example that creates a client that talks to an MCP server running
as a sidecar process:

```go
package main

import (
	"context"
	"log"
	"os/exec"

	"golang.org/x/tools/internal/mcp"
)

func main() {
	ctx := context.Background()
	// Create a new client, with no features.
	client := mcp.NewClient("mcp-client", "v1.0.0", nil)
	// Connect to a server over stdin/stdout
	transport := mcp.NewCommandTransport(exec.Command("myserver"))
	session, err := client.Connect(ctx, transport)
	if err != nil {
		log.Fatal(err)
	}
	defer session.Close()
	// Call a tool on the server.
	params := &mcp.CallToolParams[map[string]any]{
		Name:      "greet",
		Arguments: map[string]any{"name": "you"},
	}
	if res, err := mcp.CallTool(ctx, session, params); err != nil {
		log.Printf("CallTool failed: %v", err)
	} else {
		if res.IsError {
			log.Print("tool failed")
		}
		for _, c := range res.Content {
			log.Print(c.Text)
		}
	}
}
```

Here is an example of the corresponding server, connected over stdin/stdout:

```go
package main

import (
	"context"

	"golang.org/x/tools/internal/mcp"
)

type HiParams struct {
	Name string `json:"name"`
}

func SayHi(ctx context.Context, cc *mcp.ServerSession, params *mcp.CallToolParams[HiParams]) (*mcp.CallToolResult, error) {
	return &mcp.CallToolResult{
		Content: []*mcp.Content{mcp.NewTextContent("Hi " + params.Name)},
	}, nil
}

func main() {
	// Create a server with a single tool.
	server := mcp.NewServer("greeter", "v1.0.0", nil)
	server.AddTools(mcp.NewTool("greet", "say hi", SayHi))
	// Run the server over stdin/stdout, until the client disconnects
	_ = server.Run(context.Background(), mcp.NewStdIOTransport())
}
```

# Design

See [design.md](./design/design.md) for the SDK design. That document is
canonical: given any divergence between the design doc and this prototype, the
doc reflects the latest design.

# Testing

To test your client or server using stdio transport, you can use an in-memory
transport. See [example](server_example_test.go).

To test your client or server using sse transport, you can use the [httptest](https://pkg.go.dev/net/http/httptest)
package. See [example](sse_example_test.go).

# Code of Conduct

This project follows the [Go Community Code of Conduct](https://go.dev/conduct).
If you encounter a conduct-related issue, please mail conduct@golang.org.

# License

Unless otherwise noted, the Go source files are distributed under the BSD-style
license found in the [LICENSE](../../LICENSE) file.

Upon a potential move to the
[modelcontextprotocol](https://github.com/modelcontextprotocol) organization,
the license will be updated to the MIT License, and the license header will
reflect the Go MCP SDK Authors.
