// DO NOT EDIT! This file is autogenerated from gen-unicode.
use common::*;

#[test]
fn unicode_escape_property_script_adlam() {
    test_with_configs(unicode_escape_property_script_adlam_tc)
}

fn unicode_escape_property_script_adlam_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [125184..=125259, 125264..=125273, 125278..=125279];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Adlam}+$",
        "^\\p{sc=Adlam}+$",
        "^\\p{Script=Adlm}+$",
        "^\\p{sc=Adlm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_caucasian_albanian() {
    test_with_configs(unicode_escape_property_script_caucasian_albanian_tc)
}

fn unicode_escape_property_script_caucasian_albanian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66864..=66915, 66927..=66927];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Caucasian_Albanian}+$",
        "^\\p{sc=Caucasian_Albanian}+$",
        "^\\p{Script=Aghb}+$",
        "^\\p{sc=Aghb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_ahom() {
    test_with_configs(unicode_escape_property_script_ahom_tc)
}

fn unicode_escape_property_script_ahom_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [71424..=71450, 71453..=71467, 71472..=71494];
    const REGEXES: [&str; 2] = ["^\\p{Script=Ahom}+$", "^\\p{sc=Ahom}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_arabic() {
    test_with_configs(unicode_escape_property_script_arabic_tc)
}

fn unicode_escape_property_script_arabic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 58] = [
        1536..=1540,
        1542..=1547,
        1549..=1562,
        1564..=1566,
        1568..=1599,
        1601..=1610,
        1622..=1647,
        1649..=1756,
        1758..=1791,
        1872..=1919,
        2160..=2190,
        2192..=2193,
        2200..=2273,
        2275..=2303,
        64336..=64450,
        64467..=64829,
        64832..=64911,
        64914..=64967,
        64975..=64975,
        65008..=65023,
        65136..=65140,
        65142..=65276,
        69216..=69246,
        69373..=69375,
        126464..=126467,
        126469..=126495,
        126497..=126498,
        126500..=126500,
        126503..=126503,
        126505..=126514,
        126516..=126519,
        126521..=126521,
        126523..=126523,
        126530..=126530,
        126535..=126535,
        126537..=126537,
        126539..=126539,
        126541..=126543,
        126545..=126546,
        126548..=126548,
        126551..=126551,
        126553..=126553,
        126555..=126555,
        126557..=126557,
        126559..=126559,
        126561..=126562,
        126564..=126564,
        126567..=126570,
        126572..=126578,
        126580..=126583,
        126585..=126588,
        126590..=126590,
        126592..=126601,
        126603..=126619,
        126625..=126627,
        126629..=126633,
        126635..=126651,
        126704..=126705,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Arabic}+$",
        "^\\p{sc=Arabic}+$",
        "^\\p{Script=Arab}+$",
        "^\\p{sc=Arab}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_imperial_aramaic() {
    test_with_configs(unicode_escape_property_script_imperial_aramaic_tc)
}

fn unicode_escape_property_script_imperial_aramaic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [67648..=67669, 67671..=67679];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Imperial_Aramaic}+$",
        "^\\p{sc=Imperial_Aramaic}+$",
        "^\\p{Script=Armi}+$",
        "^\\p{sc=Armi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_armenian() {
    test_with_configs(unicode_escape_property_script_armenian_tc)
}

fn unicode_escape_property_script_armenian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [1329..=1366, 1369..=1418, 1421..=1423, 64275..=64279];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Armenian}+$",
        "^\\p{sc=Armenian}+$",
        "^\\p{Script=Armn}+$",
        "^\\p{sc=Armn}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_avestan() {
    test_with_configs(unicode_escape_property_script_avestan_tc)
}

fn unicode_escape_property_script_avestan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [68352..=68405, 68409..=68415];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Avestan}+$",
        "^\\p{sc=Avestan}+$",
        "^\\p{Script=Avst}+$",
        "^\\p{sc=Avst}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_balinese() {
    test_with_configs(unicode_escape_property_script_balinese_tc)
}

fn unicode_escape_property_script_balinese_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [6912..=6988, 6992..=7038];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Balinese}+$",
        "^\\p{sc=Balinese}+$",
        "^\\p{Script=Bali}+$",
        "^\\p{sc=Bali}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_bamum() {
    test_with_configs(unicode_escape_property_script_bamum_tc)
}

fn unicode_escape_property_script_bamum_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [42656..=42743, 92160..=92728];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Bamum}+$",
        "^\\p{sc=Bamum}+$",
        "^\\p{Script=Bamu}+$",
        "^\\p{sc=Bamu}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_bassa_vah() {
    test_with_configs(unicode_escape_property_script_bassa_vah_tc)
}

fn unicode_escape_property_script_bassa_vah_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [92880..=92909, 92912..=92917];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Bassa_Vah}+$",
        "^\\p{sc=Bassa_Vah}+$",
        "^\\p{Script=Bass}+$",
        "^\\p{sc=Bass}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_batak() {
    test_with_configs(unicode_escape_property_script_batak_tc)
}

fn unicode_escape_property_script_batak_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [7104..=7155, 7164..=7167];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Batak}+$",
        "^\\p{sc=Batak}+$",
        "^\\p{Script=Batk}+$",
        "^\\p{sc=Batk}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_bengali() {
    test_with_configs(unicode_escape_property_script_bengali_tc)
}

fn unicode_escape_property_script_bengali_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 14] = [
        2432..=2435,
        2437..=2444,
        2447..=2448,
        2451..=2472,
        2474..=2480,
        2482..=2482,
        2486..=2489,
        2492..=2500,
        2503..=2504,
        2507..=2510,
        2519..=2519,
        2524..=2525,
        2527..=2531,
        2534..=2558,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Bengali}+$",
        "^\\p{sc=Bengali}+$",
        "^\\p{Script=Beng}+$",
        "^\\p{sc=Beng}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_bhaiksuki() {
    test_with_configs(unicode_escape_property_script_bhaiksuki_tc)
}

fn unicode_escape_property_script_bhaiksuki_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [72704..=72712, 72714..=72758, 72760..=72773, 72784..=72812];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Bhaiksuki}+$",
        "^\\p{sc=Bhaiksuki}+$",
        "^\\p{Script=Bhks}+$",
        "^\\p{sc=Bhks}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_bopomofo() {
    test_with_configs(unicode_escape_property_script_bopomofo_tc)
}

fn unicode_escape_property_script_bopomofo_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [746..=747, 12549..=12591, 12704..=12735];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Bopomofo}+$",
        "^\\p{sc=Bopomofo}+$",
        "^\\p{Script=Bopo}+$",
        "^\\p{sc=Bopo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_brahmi() {
    test_with_configs(unicode_escape_property_script_brahmi_tc)
}

fn unicode_escape_property_script_brahmi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [69632..=69709, 69714..=69749, 69759..=69759];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Brahmi}+$",
        "^\\p{sc=Brahmi}+$",
        "^\\p{Script=Brah}+$",
        "^\\p{sc=Brah}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_braille() {
    test_with_configs(unicode_escape_property_script_braille_tc)
}

fn unicode_escape_property_script_braille_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [10240..=10495];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Braille}+$",
        "^\\p{sc=Braille}+$",
        "^\\p{Script=Brai}+$",
        "^\\p{sc=Brai}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_buginese() {
    test_with_configs(unicode_escape_property_script_buginese_tc)
}

fn unicode_escape_property_script_buginese_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [6656..=6683, 6686..=6687];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Buginese}+$",
        "^\\p{sc=Buginese}+$",
        "^\\p{Script=Bugi}+$",
        "^\\p{sc=Bugi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_buhid() {
    test_with_configs(unicode_escape_property_script_buhid_tc)
}

fn unicode_escape_property_script_buhid_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [5952..=5971];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Buhid}+$",
        "^\\p{sc=Buhid}+$",
        "^\\p{Script=Buhd}+$",
        "^\\p{sc=Buhd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_chakma() {
    test_with_configs(unicode_escape_property_script_chakma_tc)
}

fn unicode_escape_property_script_chakma_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [69888..=69940, 69942..=69959];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Chakma}+$",
        "^\\p{sc=Chakma}+$",
        "^\\p{Script=Cakm}+$",
        "^\\p{sc=Cakm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_canadian_aboriginal() {
    test_with_configs(unicode_escape_property_script_canadian_aboriginal_tc)
}

fn unicode_escape_property_script_canadian_aboriginal_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [5120..=5759, 6320..=6389, 72368..=72383];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Canadian_Aboriginal}+$",
        "^\\p{sc=Canadian_Aboriginal}+$",
        "^\\p{Script=Cans}+$",
        "^\\p{sc=Cans}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_carian() {
    test_with_configs(unicode_escape_property_script_carian_tc)
}

fn unicode_escape_property_script_carian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66208..=66256];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Carian}+$",
        "^\\p{sc=Carian}+$",
        "^\\p{Script=Cari}+$",
        "^\\p{sc=Cari}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cham() {
    test_with_configs(unicode_escape_property_script_cham_tc)
}

fn unicode_escape_property_script_cham_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [43520..=43574, 43584..=43597, 43600..=43609, 43612..=43615];
    const REGEXES: [&str; 2] = ["^\\p{Script=Cham}+$", "^\\p{sc=Cham}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cherokee() {
    test_with_configs(unicode_escape_property_script_cherokee_tc)
}

fn unicode_escape_property_script_cherokee_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [5024..=5109, 5112..=5117, 43888..=43967];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Cherokee}+$",
        "^\\p{sc=Cherokee}+$",
        "^\\p{Script=Cher}+$",
        "^\\p{sc=Cher}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_chorasmian() {
    test_with_configs(unicode_escape_property_script_chorasmian_tc)
}

fn unicode_escape_property_script_chorasmian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69552..=69579];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Chorasmian}+$",
        "^\\p{sc=Chorasmian}+$",
        "^\\p{Script=Chrs}+$",
        "^\\p{sc=Chrs}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_coptic() {
    test_with_configs(unicode_escape_property_script_coptic_tc)
}

fn unicode_escape_property_script_coptic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [994..=1007, 11392..=11507, 11513..=11519];
    const REGEXES: [&str; 6] = [
        "^\\p{Script=Coptic}+$",
        "^\\p{sc=Coptic}+$",
        "^\\p{Script=Copt}+$",
        "^\\p{sc=Copt}+$",
        "^\\p{Script=Qaac}+$",
        "^\\p{sc=Qaac}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cypro_minoan() {
    test_with_configs(unicode_escape_property_script_cypro_minoan_tc)
}

fn unicode_escape_property_script_cypro_minoan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [77712..=77810];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Cypro_Minoan}+$",
        "^\\p{sc=Cypro_Minoan}+$",
        "^\\p{Script=Cpmn}+$",
        "^\\p{sc=Cpmn}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cypriot() {
    test_with_configs(unicode_escape_property_script_cypriot_tc)
}

fn unicode_escape_property_script_cypriot_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 6] = [
        67584..=67589,
        67592..=67592,
        67594..=67637,
        67639..=67640,
        67644..=67644,
        67647..=67647,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Cypriot}+$",
        "^\\p{sc=Cypriot}+$",
        "^\\p{Script=Cprt}+$",
        "^\\p{sc=Cprt}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cyrillic() {
    test_with_configs(unicode_escape_property_script_cyrillic_tc)
}

fn unicode_escape_property_script_cyrillic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 10] = [
        1024..=1156,
        1159..=1327,
        7296..=7304,
        7467..=7467,
        7544..=7544,
        11744..=11775,
        42560..=42655,
        65070..=65071,
        122928..=122989,
        123023..=123023,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Cyrillic}+$",
        "^\\p{sc=Cyrillic}+$",
        "^\\p{Script=Cyrl}+$",
        "^\\p{sc=Cyrl}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_devanagari() {
    test_with_configs(unicode_escape_property_script_devanagari_tc)
}

fn unicode_escape_property_script_devanagari_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        2304..=2384,
        2389..=2403,
        2406..=2431,
        43232..=43263,
        72448..=72457,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Devanagari}+$",
        "^\\p{sc=Devanagari}+$",
        "^\\p{Script=Deva}+$",
        "^\\p{sc=Deva}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_dives_akuru() {
    test_with_configs(unicode_escape_property_script_dives_akuru_tc)
}

fn unicode_escape_property_script_dives_akuru_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 8] = [
        71936..=71942,
        71945..=71945,
        71948..=71955,
        71957..=71958,
        71960..=71989,
        71991..=71992,
        71995..=72006,
        72016..=72025,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Dives_Akuru}+$",
        "^\\p{sc=Dives_Akuru}+$",
        "^\\p{Script=Diak}+$",
        "^\\p{sc=Diak}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_dogra() {
    test_with_configs(unicode_escape_property_script_dogra_tc)
}

fn unicode_escape_property_script_dogra_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [71680..=71739];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Dogra}+$",
        "^\\p{sc=Dogra}+$",
        "^\\p{Script=Dogr}+$",
        "^\\p{sc=Dogr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_deseret() {
    test_with_configs(unicode_escape_property_script_deseret_tc)
}

fn unicode_escape_property_script_deseret_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66560..=66639];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Deseret}+$",
        "^\\p{sc=Deseret}+$",
        "^\\p{Script=Dsrt}+$",
        "^\\p{sc=Dsrt}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_duployan() {
    test_with_configs(unicode_escape_property_script_duployan_tc)
}

fn unicode_escape_property_script_duployan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        113664..=113770,
        113776..=113788,
        113792..=113800,
        113808..=113817,
        113820..=113823,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Duployan}+$",
        "^\\p{sc=Duployan}+$",
        "^\\p{Script=Dupl}+$",
        "^\\p{sc=Dupl}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_egyptian_hieroglyphs() {
    test_with_configs(unicode_escape_property_script_egyptian_hieroglyphs_tc)
}

fn unicode_escape_property_script_egyptian_hieroglyphs_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [77824..=78933];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Egyptian_Hieroglyphs}+$",
        "^\\p{sc=Egyptian_Hieroglyphs}+$",
        "^\\p{Script=Egyp}+$",
        "^\\p{sc=Egyp}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_elbasan() {
    test_with_configs(unicode_escape_property_script_elbasan_tc)
}

fn unicode_escape_property_script_elbasan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66816..=66855];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Elbasan}+$",
        "^\\p{sc=Elbasan}+$",
        "^\\p{Script=Elba}+$",
        "^\\p{sc=Elba}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_elymaic() {
    test_with_configs(unicode_escape_property_script_elymaic_tc)
}

fn unicode_escape_property_script_elymaic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69600..=69622];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Elymaic}+$",
        "^\\p{sc=Elymaic}+$",
        "^\\p{Script=Elym}+$",
        "^\\p{sc=Elym}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_ethiopic() {
    test_with_configs(unicode_escape_property_script_ethiopic_tc)
}

fn unicode_escape_property_script_ethiopic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 36] = [
        4608..=4680,
        4682..=4685,
        4688..=4694,
        4696..=4696,
        4698..=4701,
        4704..=4744,
        4746..=4749,
        4752..=4784,
        4786..=4789,
        4792..=4798,
        4800..=4800,
        4802..=4805,
        4808..=4822,
        4824..=4880,
        4882..=4885,
        4888..=4954,
        4957..=4988,
        4992..=5017,
        11648..=11670,
        11680..=11686,
        11688..=11694,
        11696..=11702,
        11704..=11710,
        11712..=11718,
        11720..=11726,
        11728..=11734,
        11736..=11742,
        43777..=43782,
        43785..=43790,
        43793..=43798,
        43808..=43814,
        43816..=43822,
        124896..=124902,
        124904..=124907,
        124909..=124910,
        124912..=124926,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Ethiopic}+$",
        "^\\p{sc=Ethiopic}+$",
        "^\\p{Script=Ethi}+$",
        "^\\p{sc=Ethi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_georgian() {
    test_with_configs(unicode_escape_property_script_georgian_tc)
}

fn unicode_escape_property_script_georgian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 10] = [
        4256..=4293,
        4295..=4295,
        4301..=4301,
        4304..=4346,
        4348..=4351,
        7312..=7354,
        7357..=7359,
        11520..=11557,
        11559..=11559,
        11565..=11565,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Georgian}+$",
        "^\\p{sc=Georgian}+$",
        "^\\p{Script=Geor}+$",
        "^\\p{sc=Geor}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_glagolitic() {
    test_with_configs(unicode_escape_property_script_glagolitic_tc)
}

fn unicode_escape_property_script_glagolitic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 6] = [
        11264..=11359,
        122880..=122886,
        122888..=122904,
        122907..=122913,
        122915..=122916,
        122918..=122922,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Glagolitic}+$",
        "^\\p{sc=Glagolitic}+$",
        "^\\p{Script=Glag}+$",
        "^\\p{sc=Glag}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_gunjala_gondi() {
    test_with_configs(unicode_escape_property_script_gunjala_gondi_tc)
}

fn unicode_escape_property_script_gunjala_gondi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 6] = [
        73056..=73061,
        73063..=73064,
        73066..=73102,
        73104..=73105,
        73107..=73112,
        73120..=73129,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Gunjala_Gondi}+$",
        "^\\p{sc=Gunjala_Gondi}+$",
        "^\\p{Script=Gong}+$",
        "^\\p{sc=Gong}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_masaram_gondi() {
    test_with_configs(unicode_escape_property_script_masaram_gondi_tc)
}

fn unicode_escape_property_script_masaram_gondi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 7] = [
        72960..=72966,
        72968..=72969,
        72971..=73014,
        73018..=73018,
        73020..=73021,
        73023..=73031,
        73040..=73049,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Masaram_Gondi}+$",
        "^\\p{sc=Masaram_Gondi}+$",
        "^\\p{Script=Gonm}+$",
        "^\\p{sc=Gonm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_gothic() {
    test_with_configs(unicode_escape_property_script_gothic_tc)
}

fn unicode_escape_property_script_gothic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66352..=66378];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Gothic}+$",
        "^\\p{sc=Gothic}+$",
        "^\\p{Script=Goth}+$",
        "^\\p{sc=Goth}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_grantha() {
    test_with_configs(unicode_escape_property_script_grantha_tc)
}

fn unicode_escape_property_script_grantha_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 15] = [
        70400..=70403,
        70405..=70412,
        70415..=70416,
        70419..=70440,
        70442..=70448,
        70450..=70451,
        70453..=70457,
        70460..=70468,
        70471..=70472,
        70475..=70477,
        70480..=70480,
        70487..=70487,
        70493..=70499,
        70502..=70508,
        70512..=70516,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Grantha}+$",
        "^\\p{sc=Grantha}+$",
        "^\\p{Script=Gran}+$",
        "^\\p{sc=Gran}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_greek() {
    test_with_configs(unicode_escape_property_script_greek_tc)
}

fn unicode_escape_property_script_greek_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 36] = [
        880..=883,
        885..=887,
        890..=893,
        895..=895,
        900..=900,
        902..=902,
        904..=906,
        908..=908,
        910..=929,
        931..=993,
        1008..=1023,
        7462..=7466,
        7517..=7521,
        7526..=7530,
        7615..=7615,
        7936..=7957,
        7960..=7965,
        7968..=8005,
        8008..=8013,
        8016..=8023,
        8025..=8025,
        8027..=8027,
        8029..=8029,
        8031..=8061,
        8064..=8116,
        8118..=8132,
        8134..=8147,
        8150..=8155,
        8157..=8175,
        8178..=8180,
        8182..=8190,
        8486..=8486,
        43877..=43877,
        65856..=65934,
        65952..=65952,
        119296..=119365,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Greek}+$",
        "^\\p{sc=Greek}+$",
        "^\\p{Script=Grek}+$",
        "^\\p{sc=Grek}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_gujarati() {
    test_with_configs(unicode_escape_property_script_gujarati_tc)
}

fn unicode_escape_property_script_gujarati_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 14] = [
        2689..=2691,
        2693..=2701,
        2703..=2705,
        2707..=2728,
        2730..=2736,
        2738..=2739,
        2741..=2745,
        2748..=2757,
        2759..=2761,
        2763..=2765,
        2768..=2768,
        2784..=2787,
        2790..=2801,
        2809..=2815,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Gujarati}+$",
        "^\\p{sc=Gujarati}+$",
        "^\\p{Script=Gujr}+$",
        "^\\p{sc=Gujr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_gurmukhi() {
    test_with_configs(unicode_escape_property_script_gurmukhi_tc)
}

fn unicode_escape_property_script_gurmukhi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 16] = [
        2561..=2563,
        2565..=2570,
        2575..=2576,
        2579..=2600,
        2602..=2608,
        2610..=2611,
        2613..=2614,
        2616..=2617,
        2620..=2620,
        2622..=2626,
        2631..=2632,
        2635..=2637,
        2641..=2641,
        2649..=2652,
        2654..=2654,
        2662..=2678,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Gurmukhi}+$",
        "^\\p{sc=Gurmukhi}+$",
        "^\\p{Script=Guru}+$",
        "^\\p{sc=Guru}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hangul() {
    test_with_configs(unicode_escape_property_script_hangul_tc)
}

fn unicode_escape_property_script_hangul_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 14] = [
        4352..=4607,
        12334..=12335,
        12593..=12686,
        12800..=12830,
        12896..=12926,
        43360..=43388,
        44032..=55203,
        55216..=55238,
        55243..=55291,
        65440..=65470,
        65474..=65479,
        65482..=65487,
        65490..=65495,
        65498..=65500,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hangul}+$",
        "^\\p{sc=Hangul}+$",
        "^\\p{Script=Hang}+$",
        "^\\p{sc=Hang}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_han() {
    test_with_configs(unicode_escape_property_script_han_tc)
}

fn unicode_escape_property_script_han_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 22] = [
        11904..=11929,
        11931..=12019,
        12032..=12245,
        12293..=12293,
        12295..=12295,
        12321..=12329,
        12344..=12347,
        13312..=19903,
        19968..=40959,
        63744..=64109,
        64112..=64217,
        94178..=94179,
        94192..=94193,
        131072..=173791,
        173824..=177977,
        177984..=178205,
        178208..=183969,
        183984..=191456,
        191472..=192093,
        194560..=195101,
        196608..=201546,
        201552..=205743,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Han}+$",
        "^\\p{sc=Han}+$",
        "^\\p{Script=Hani}+$",
        "^\\p{sc=Hani}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hanunoo() {
    test_with_configs(unicode_escape_property_script_hanunoo_tc)
}

fn unicode_escape_property_script_hanunoo_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [5920..=5940];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hanunoo}+$",
        "^\\p{sc=Hanunoo}+$",
        "^\\p{Script=Hano}+$",
        "^\\p{sc=Hano}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hatran() {
    test_with_configs(unicode_escape_property_script_hatran_tc)
}

fn unicode_escape_property_script_hatran_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [67808..=67826, 67828..=67829, 67835..=67839];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hatran}+$",
        "^\\p{sc=Hatran}+$",
        "^\\p{Script=Hatr}+$",
        "^\\p{sc=Hatr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hebrew() {
    test_with_configs(unicode_escape_property_script_hebrew_tc)
}

fn unicode_escape_property_script_hebrew_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 9] = [
        1425..=1479,
        1488..=1514,
        1519..=1524,
        64285..=64310,
        64312..=64316,
        64318..=64318,
        64320..=64321,
        64323..=64324,
        64326..=64335,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hebrew}+$",
        "^\\p{sc=Hebrew}+$",
        "^\\p{Script=Hebr}+$",
        "^\\p{sc=Hebr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hiragana() {
    test_with_configs(unicode_escape_property_script_hiragana_tc)
}

fn unicode_escape_property_script_hiragana_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 6] = [
        12353..=12438,
        12445..=12447,
        110593..=110879,
        110898..=110898,
        110928..=110930,
        127488..=127488,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hiragana}+$",
        "^\\p{sc=Hiragana}+$",
        "^\\p{Script=Hira}+$",
        "^\\p{sc=Hira}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_anatolian_hieroglyphs() {
    test_with_configs(unicode_escape_property_script_anatolian_hieroglyphs_tc)
}

fn unicode_escape_property_script_anatolian_hieroglyphs_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [82944..=83526];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Anatolian_Hieroglyphs}+$",
        "^\\p{sc=Anatolian_Hieroglyphs}+$",
        "^\\p{Script=Hluw}+$",
        "^\\p{sc=Hluw}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_pahawh_hmong() {
    test_with_configs(unicode_escape_property_script_pahawh_hmong_tc)
}

fn unicode_escape_property_script_pahawh_hmong_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        92928..=92997,
        93008..=93017,
        93019..=93025,
        93027..=93047,
        93053..=93071,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Pahawh_Hmong}+$",
        "^\\p{sc=Pahawh_Hmong}+$",
        "^\\p{Script=Hmng}+$",
        "^\\p{sc=Hmng}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nyiakeng_puachue_hmong() {
    test_with_configs(unicode_escape_property_script_nyiakeng_puachue_hmong_tc)
}

fn unicode_escape_property_script_nyiakeng_puachue_hmong_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] = [
        123136..=123180,
        123184..=123197,
        123200..=123209,
        123214..=123215,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nyiakeng_Puachue_Hmong}+$",
        "^\\p{sc=Nyiakeng_Puachue_Hmong}+$",
        "^\\p{Script=Hmnp}+$",
        "^\\p{sc=Hmnp}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_hungarian() {
    test_with_configs(unicode_escape_property_script_old_hungarian_tc)
}

fn unicode_escape_property_script_old_hungarian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [68736..=68786, 68800..=68850, 68858..=68863];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Hungarian}+$",
        "^\\p{sc=Old_Hungarian}+$",
        "^\\p{Script=Hung}+$",
        "^\\p{sc=Hung}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_italic() {
    test_with_configs(unicode_escape_property_script_old_italic_tc)
}

fn unicode_escape_property_script_old_italic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66304..=66339, 66349..=66351];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Italic}+$",
        "^\\p{sc=Old_Italic}+$",
        "^\\p{Script=Ital}+$",
        "^\\p{sc=Ital}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_javanese() {
    test_with_configs(unicode_escape_property_script_javanese_tc)
}

fn unicode_escape_property_script_javanese_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [43392..=43469, 43472..=43481, 43486..=43487];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Javanese}+$",
        "^\\p{sc=Javanese}+$",
        "^\\p{Script=Java}+$",
        "^\\p{sc=Java}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_kayah_li() {
    test_with_configs(unicode_escape_property_script_kayah_li_tc)
}

fn unicode_escape_property_script_kayah_li_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [43264..=43309, 43311..=43311];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Kayah_Li}+$",
        "^\\p{sc=Kayah_Li}+$",
        "^\\p{Script=Kali}+$",
        "^\\p{sc=Kali}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_katakana() {
    test_with_configs(unicode_escape_property_script_katakana_tc)
}

fn unicode_escape_property_script_katakana_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 14] = [
        12449..=12538,
        12541..=12543,
        12784..=12799,
        13008..=13054,
        13056..=13143,
        65382..=65391,
        65393..=65437,
        110576..=110579,
        110581..=110587,
        110589..=110590,
        110592..=110592,
        110880..=110882,
        110933..=110933,
        110948..=110951,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Katakana}+$",
        "^\\p{sc=Katakana}+$",
        "^\\p{Script=Kana}+$",
        "^\\p{sc=Kana}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_kawi() {
    test_with_configs(unicode_escape_property_script_kawi_tc)
}

fn unicode_escape_property_script_kawi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [73472..=73488, 73490..=73530, 73534..=73561];
    const REGEXES: [&str; 2] = ["^\\p{Script=Kawi}+$", "^\\p{sc=Kawi}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_kharoshthi() {
    test_with_configs(unicode_escape_property_script_kharoshthi_tc)
}

fn unicode_escape_property_script_kharoshthi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 8] = [
        68096..=68099,
        68101..=68102,
        68108..=68115,
        68117..=68119,
        68121..=68149,
        68152..=68154,
        68159..=68168,
        68176..=68184,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Kharoshthi}+$",
        "^\\p{sc=Kharoshthi}+$",
        "^\\p{Script=Khar}+$",
        "^\\p{sc=Khar}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_khmer() {
    test_with_configs(unicode_escape_property_script_khmer_tc)
}

fn unicode_escape_property_script_khmer_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [6016..=6109, 6112..=6121, 6128..=6137, 6624..=6655];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Khmer}+$",
        "^\\p{sc=Khmer}+$",
        "^\\p{Script=Khmr}+$",
        "^\\p{sc=Khmr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_khojki() {
    test_with_configs(unicode_escape_property_script_khojki_tc)
}

fn unicode_escape_property_script_khojki_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [70144..=70161, 70163..=70209];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Khojki}+$",
        "^\\p{sc=Khojki}+$",
        "^\\p{Script=Khoj}+$",
        "^\\p{sc=Khoj}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_khitan_small_script() {
    test_with_configs(unicode_escape_property_script_khitan_small_script_tc)
}

fn unicode_escape_property_script_khitan_small_script_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [94180..=94180, 101120..=101589];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Khitan_Small_Script}+$",
        "^\\p{sc=Khitan_Small_Script}+$",
        "^\\p{Script=Kits}+$",
        "^\\p{sc=Kits}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_kannada() {
    test_with_configs(unicode_escape_property_script_kannada_tc)
}

fn unicode_escape_property_script_kannada_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 13] = [
        3200..=3212,
        3214..=3216,
        3218..=3240,
        3242..=3251,
        3253..=3257,
        3260..=3268,
        3270..=3272,
        3274..=3277,
        3285..=3286,
        3293..=3294,
        3296..=3299,
        3302..=3311,
        3313..=3315,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Kannada}+$",
        "^\\p{sc=Kannada}+$",
        "^\\p{Script=Knda}+$",
        "^\\p{sc=Knda}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_kaithi() {
    test_with_configs(unicode_escape_property_script_kaithi_tc)
}

fn unicode_escape_property_script_kaithi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [69760..=69826, 69837..=69837];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Kaithi}+$",
        "^\\p{sc=Kaithi}+$",
        "^\\p{Script=Kthi}+$",
        "^\\p{sc=Kthi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tai_tham() {
    test_with_configs(unicode_escape_property_script_tai_tham_tc)
}

fn unicode_escape_property_script_tai_tham_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        6688..=6750,
        6752..=6780,
        6783..=6793,
        6800..=6809,
        6816..=6829,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tai_Tham}+$",
        "^\\p{sc=Tai_Tham}+$",
        "^\\p{Script=Lana}+$",
        "^\\p{sc=Lana}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_lao() {
    test_with_configs(unicode_escape_property_script_lao_tc)
}

fn unicode_escape_property_script_lao_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 11] = [
        3713..=3714,
        3716..=3716,
        3718..=3722,
        3724..=3747,
        3749..=3749,
        3751..=3773,
        3776..=3780,
        3782..=3782,
        3784..=3790,
        3792..=3801,
        3804..=3807,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Lao}+$",
        "^\\p{sc=Lao}+$",
        "^\\p{Script=Laoo}+$",
        "^\\p{sc=Laoo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_latin() {
    test_with_configs(unicode_escape_property_script_latin_tc)
}

fn unicode_escape_property_script_latin_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 39] = [
        65..=90,
        97..=122,
        170..=170,
        186..=186,
        192..=214,
        216..=246,
        248..=696,
        736..=740,
        7424..=7461,
        7468..=7516,
        7522..=7525,
        7531..=7543,
        7545..=7614,
        7680..=7935,
        8305..=8305,
        8319..=8319,
        8336..=8348,
        8490..=8491,
        8498..=8498,
        8526..=8526,
        8544..=8584,
        11360..=11391,
        42786..=42887,
        42891..=42954,
        42960..=42961,
        42963..=42963,
        42965..=42969,
        42994..=43007,
        43824..=43866,
        43868..=43876,
        43878..=43881,
        64256..=64262,
        65313..=65338,
        65345..=65370,
        67456..=67461,
        67463..=67504,
        67506..=67514,
        122624..=122654,
        122661..=122666,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Latin}+$",
        "^\\p{sc=Latin}+$",
        "^\\p{Script=Latn}+$",
        "^\\p{sc=Latn}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_lepcha() {
    test_with_configs(unicode_escape_property_script_lepcha_tc)
}

fn unicode_escape_property_script_lepcha_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] = [7168..=7223, 7227..=7241, 7245..=7247];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Lepcha}+$",
        "^\\p{sc=Lepcha}+$",
        "^\\p{Script=Lepc}+$",
        "^\\p{sc=Lepc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_limbu() {
    test_with_configs(unicode_escape_property_script_limbu_tc)
}

fn unicode_escape_property_script_limbu_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        6400..=6430,
        6432..=6443,
        6448..=6459,
        6464..=6464,
        6468..=6479,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Limbu}+$",
        "^\\p{sc=Limbu}+$",
        "^\\p{Script=Limb}+$",
        "^\\p{sc=Limb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_linear_a() {
    test_with_configs(unicode_escape_property_script_linear_a_tc)
}

fn unicode_escape_property_script_linear_a_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [67072..=67382, 67392..=67413, 67424..=67431];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Linear_A}+$",
        "^\\p{sc=Linear_A}+$",
        "^\\p{Script=Lina}+$",
        "^\\p{sc=Lina}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_linear_b() {
    test_with_configs(unicode_escape_property_script_linear_b_tc)
}

fn unicode_escape_property_script_linear_b_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 7] = [
        65536..=65547,
        65549..=65574,
        65576..=65594,
        65596..=65597,
        65599..=65613,
        65616..=65629,
        65664..=65786,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Linear_B}+$",
        "^\\p{sc=Linear_B}+$",
        "^\\p{Script=Linb}+$",
        "^\\p{sc=Linb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_lisu() {
    test_with_configs(unicode_escape_property_script_lisu_tc)
}

fn unicode_escape_property_script_lisu_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [42192..=42239, 73648..=73648];
    const REGEXES: [&str; 2] = ["^\\p{Script=Lisu}+$", "^\\p{sc=Lisu}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_lycian() {
    test_with_configs(unicode_escape_property_script_lycian_tc)
}

fn unicode_escape_property_script_lycian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66176..=66204];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Lycian}+$",
        "^\\p{sc=Lycian}+$",
        "^\\p{Script=Lyci}+$",
        "^\\p{sc=Lyci}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_lydian() {
    test_with_configs(unicode_escape_property_script_lydian_tc)
}

fn unicode_escape_property_script_lydian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [67872..=67897, 67903..=67903];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Lydian}+$",
        "^\\p{sc=Lydian}+$",
        "^\\p{Script=Lydi}+$",
        "^\\p{sc=Lydi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_mahajani() {
    test_with_configs(unicode_escape_property_script_mahajani_tc)
}

fn unicode_escape_property_script_mahajani_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69968..=70006];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Mahajani}+$",
        "^\\p{sc=Mahajani}+$",
        "^\\p{Script=Mahj}+$",
        "^\\p{sc=Mahj}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_makasar() {
    test_with_configs(unicode_escape_property_script_makasar_tc)
}

fn unicode_escape_property_script_makasar_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [73440..=73464];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Makasar}+$",
        "^\\p{sc=Makasar}+$",
        "^\\p{Script=Maka}+$",
        "^\\p{sc=Maka}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_mandaic() {
    test_with_configs(unicode_escape_property_script_mandaic_tc)
}

fn unicode_escape_property_script_mandaic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [2112..=2139, 2142..=2142];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Mandaic}+$",
        "^\\p{sc=Mandaic}+$",
        "^\\p{Script=Mand}+$",
        "^\\p{sc=Mand}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_manichaean() {
    test_with_configs(unicode_escape_property_script_manichaean_tc)
}

fn unicode_escape_property_script_manichaean_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [68288..=68326, 68331..=68342];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Manichaean}+$",
        "^\\p{sc=Manichaean}+$",
        "^\\p{Script=Mani}+$",
        "^\\p{sc=Mani}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_marchen() {
    test_with_configs(unicode_escape_property_script_marchen_tc)
}

fn unicode_escape_property_script_marchen_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [72816..=72847, 72850..=72871, 72873..=72886];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Marchen}+$",
        "^\\p{sc=Marchen}+$",
        "^\\p{Script=Marc}+$",
        "^\\p{sc=Marc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_medefaidrin() {
    test_with_configs(unicode_escape_property_script_medefaidrin_tc)
}

fn unicode_escape_property_script_medefaidrin_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [93760..=93850];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Medefaidrin}+$",
        "^\\p{sc=Medefaidrin}+$",
        "^\\p{Script=Medf}+$",
        "^\\p{sc=Medf}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_mende_kikakui() {
    test_with_configs(unicode_escape_property_script_mende_kikakui_tc)
}

fn unicode_escape_property_script_mende_kikakui_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [124928..=125124, 125127..=125142];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Mende_Kikakui}+$",
        "^\\p{sc=Mende_Kikakui}+$",
        "^\\p{Script=Mend}+$",
        "^\\p{sc=Mend}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_meroitic_cursive() {
    test_with_configs(unicode_escape_property_script_meroitic_cursive_tc)
}

fn unicode_escape_property_script_meroitic_cursive_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [68000..=68023, 68028..=68047, 68050..=68095];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Meroitic_Cursive}+$",
        "^\\p{sc=Meroitic_Cursive}+$",
        "^\\p{Script=Merc}+$",
        "^\\p{sc=Merc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_meroitic_hieroglyphs() {
    test_with_configs(unicode_escape_property_script_meroitic_hieroglyphs_tc)
}

fn unicode_escape_property_script_meroitic_hieroglyphs_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [67968..=67999];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Meroitic_Hieroglyphs}+$",
        "^\\p{sc=Meroitic_Hieroglyphs}+$",
        "^\\p{Script=Mero}+$",
        "^\\p{sc=Mero}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_malayalam() {
    test_with_configs(unicode_escape_property_script_malayalam_tc)
}

fn unicode_escape_property_script_malayalam_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 7] = [
        3328..=3340,
        3342..=3344,
        3346..=3396,
        3398..=3400,
        3402..=3407,
        3412..=3427,
        3430..=3455,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Malayalam}+$",
        "^\\p{sc=Malayalam}+$",
        "^\\p{Script=Mlym}+$",
        "^\\p{sc=Mlym}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_modi() {
    test_with_configs(unicode_escape_property_script_modi_tc)
}

fn unicode_escape_property_script_modi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [71168..=71236, 71248..=71257];
    const REGEXES: [&str; 2] = ["^\\p{Script=Modi}+$", "^\\p{sc=Modi}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_mongolian() {
    test_with_configs(unicode_escape_property_script_mongolian_tc)
}

fn unicode_escape_property_script_mongolian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 6] = [
        6144..=6145,
        6148..=6148,
        6150..=6169,
        6176..=6264,
        6272..=6314,
        71264..=71276,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Mongolian}+$",
        "^\\p{sc=Mongolian}+$",
        "^\\p{Script=Mong}+$",
        "^\\p{sc=Mong}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_mro() {
    test_with_configs(unicode_escape_property_script_mro_tc)
}

fn unicode_escape_property_script_mro_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [92736..=92766, 92768..=92777, 92782..=92783];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Mro}+$",
        "^\\p{sc=Mro}+$",
        "^\\p{Script=Mroo}+$",
        "^\\p{sc=Mroo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_meetei_mayek() {
    test_with_configs(unicode_escape_property_script_meetei_mayek_tc)
}

fn unicode_escape_property_script_meetei_mayek_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [43744..=43766, 43968..=44013, 44016..=44025];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Meetei_Mayek}+$",
        "^\\p{sc=Meetei_Mayek}+$",
        "^\\p{Script=Mtei}+$",
        "^\\p{sc=Mtei}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_multani() {
    test_with_configs(unicode_escape_property_script_multani_tc)
}

fn unicode_escape_property_script_multani_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 5] = [
        70272..=70278,
        70280..=70280,
        70282..=70285,
        70287..=70301,
        70303..=70313,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Multani}+$",
        "^\\p{sc=Multani}+$",
        "^\\p{Script=Mult}+$",
        "^\\p{sc=Mult}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_myanmar() {
    test_with_configs(unicode_escape_property_script_myanmar_tc)
}

fn unicode_escape_property_script_myanmar_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [4096..=4255, 43488..=43518, 43616..=43647];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Myanmar}+$",
        "^\\p{sc=Myanmar}+$",
        "^\\p{Script=Mymr}+$",
        "^\\p{sc=Mymr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nag_mundari() {
    test_with_configs(unicode_escape_property_script_nag_mundari_tc)
}

fn unicode_escape_property_script_nag_mundari_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [124112..=124153];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nag_Mundari}+$",
        "^\\p{sc=Nag_Mundari}+$",
        "^\\p{Script=Nagm}+$",
        "^\\p{sc=Nagm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nandinagari() {
    test_with_configs(unicode_escape_property_script_nandinagari_tc)
}

fn unicode_escape_property_script_nandinagari_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [72096..=72103, 72106..=72151, 72154..=72164];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nandinagari}+$",
        "^\\p{sc=Nandinagari}+$",
        "^\\p{Script=Nand}+$",
        "^\\p{sc=Nand}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_north_arabian() {
    test_with_configs(unicode_escape_property_script_old_north_arabian_tc)
}

fn unicode_escape_property_script_old_north_arabian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [68224..=68255];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_North_Arabian}+$",
        "^\\p{sc=Old_North_Arabian}+$",
        "^\\p{Script=Narb}+$",
        "^\\p{sc=Narb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nabataean() {
    test_with_configs(unicode_escape_property_script_nabataean_tc)
}

fn unicode_escape_property_script_nabataean_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [67712..=67742, 67751..=67759];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nabataean}+$",
        "^\\p{sc=Nabataean}+$",
        "^\\p{Script=Nbat}+$",
        "^\\p{sc=Nbat}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_newa() {
    test_with_configs(unicode_escape_property_script_newa_tc)
}

fn unicode_escape_property_script_newa_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [70656..=70747, 70749..=70753];
    const REGEXES: [&str; 2] = ["^\\p{Script=Newa}+$", "^\\p{sc=Newa}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nko() {
    test_with_configs(unicode_escape_property_script_nko_tc)
}

fn unicode_escape_property_script_nko_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [1984..=2042, 2045..=2047];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nko}+$",
        "^\\p{sc=Nko}+$",
        "^\\p{Script=Nkoo}+$",
        "^\\p{sc=Nkoo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_nushu() {
    test_with_configs(unicode_escape_property_script_nushu_tc)
}

fn unicode_escape_property_script_nushu_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [94177..=94177, 110960..=111355];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Nushu}+$",
        "^\\p{sc=Nushu}+$",
        "^\\p{Script=Nshu}+$",
        "^\\p{sc=Nshu}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_ogham() {
    test_with_configs(unicode_escape_property_script_ogham_tc)
}

fn unicode_escape_property_script_ogham_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [5760..=5788];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Ogham}+$",
        "^\\p{sc=Ogham}+$",
        "^\\p{Script=Ogam}+$",
        "^\\p{sc=Ogam}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_ol_chiki() {
    test_with_configs(unicode_escape_property_script_ol_chiki_tc)
}

fn unicode_escape_property_script_ol_chiki_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [7248..=7295];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Ol_Chiki}+$",
        "^\\p{sc=Ol_Chiki}+$",
        "^\\p{Script=Olck}+$",
        "^\\p{sc=Olck}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_turkic() {
    test_with_configs(unicode_escape_property_script_old_turkic_tc)
}

fn unicode_escape_property_script_old_turkic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [68608..=68680];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Turkic}+$",
        "^\\p{sc=Old_Turkic}+$",
        "^\\p{Script=Orkh}+$",
        "^\\p{sc=Orkh}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_oriya() {
    test_with_configs(unicode_escape_property_script_oriya_tc)
}

fn unicode_escape_property_script_oriya_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 14] = [
        2817..=2819,
        2821..=2828,
        2831..=2832,
        2835..=2856,
        2858..=2864,
        2866..=2867,
        2869..=2873,
        2876..=2884,
        2887..=2888,
        2891..=2893,
        2901..=2903,
        2908..=2909,
        2911..=2915,
        2918..=2935,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Oriya}+$",
        "^\\p{sc=Oriya}+$",
        "^\\p{Script=Orya}+$",
        "^\\p{sc=Orya}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_osage() {
    test_with_configs(unicode_escape_property_script_osage_tc)
}

fn unicode_escape_property_script_osage_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66736..=66771, 66776..=66811];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Osage}+$",
        "^\\p{sc=Osage}+$",
        "^\\p{Script=Osge}+$",
        "^\\p{sc=Osge}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_osmanya() {
    test_with_configs(unicode_escape_property_script_osmanya_tc)
}

fn unicode_escape_property_script_osmanya_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66688..=66717, 66720..=66729];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Osmanya}+$",
        "^\\p{sc=Osmanya}+$",
        "^\\p{Script=Osma}+$",
        "^\\p{sc=Osma}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_uyghur() {
    test_with_configs(unicode_escape_property_script_old_uyghur_tc)
}

fn unicode_escape_property_script_old_uyghur_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69488..=69513];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Uyghur}+$",
        "^\\p{sc=Old_Uyghur}+$",
        "^\\p{Script=Ougr}+$",
        "^\\p{sc=Ougr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_palmyrene() {
    test_with_configs(unicode_escape_property_script_palmyrene_tc)
}

fn unicode_escape_property_script_palmyrene_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [67680..=67711];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Palmyrene}+$",
        "^\\p{sc=Palmyrene}+$",
        "^\\p{Script=Palm}+$",
        "^\\p{sc=Palm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_pau_cin_hau() {
    test_with_configs(unicode_escape_property_script_pau_cin_hau_tc)
}

fn unicode_escape_property_script_pau_cin_hau_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [72384..=72440];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Pau_Cin_Hau}+$",
        "^\\p{sc=Pau_Cin_Hau}+$",
        "^\\p{Script=Pauc}+$",
        "^\\p{sc=Pauc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_permic() {
    test_with_configs(unicode_escape_property_script_old_permic_tc)
}

fn unicode_escape_property_script_old_permic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66384..=66426];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Permic}+$",
        "^\\p{sc=Old_Permic}+$",
        "^\\p{Script=Perm}+$",
        "^\\p{sc=Perm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_phags_pa() {
    test_with_configs(unicode_escape_property_script_phags_pa_tc)
}

fn unicode_escape_property_script_phags_pa_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [43072..=43127];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Phags_Pa}+$",
        "^\\p{sc=Phags_Pa}+$",
        "^\\p{Script=Phag}+$",
        "^\\p{sc=Phag}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_inscriptional_pahlavi() {
    test_with_configs(unicode_escape_property_script_inscriptional_pahlavi_tc)
}

fn unicode_escape_property_script_inscriptional_pahlavi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [68448..=68466, 68472..=68479];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Inscriptional_Pahlavi}+$",
        "^\\p{sc=Inscriptional_Pahlavi}+$",
        "^\\p{Script=Phli}+$",
        "^\\p{sc=Phli}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_psalter_pahlavi() {
    test_with_configs(unicode_escape_property_script_psalter_pahlavi_tc)
}

fn unicode_escape_property_script_psalter_pahlavi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [68480..=68497, 68505..=68508, 68521..=68527];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Psalter_Pahlavi}+$",
        "^\\p{sc=Psalter_Pahlavi}+$",
        "^\\p{Script=Phlp}+$",
        "^\\p{sc=Phlp}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_phoenician() {
    test_with_configs(unicode_escape_property_script_phoenician_tc)
}

fn unicode_escape_property_script_phoenician_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [67840..=67867, 67871..=67871];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Phoenician}+$",
        "^\\p{sc=Phoenician}+$",
        "^\\p{Script=Phnx}+$",
        "^\\p{sc=Phnx}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_miao() {
    test_with_configs(unicode_escape_property_script_miao_tc)
}

fn unicode_escape_property_script_miao_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [93952..=94026, 94031..=94087, 94095..=94111];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Miao}+$",
        "^\\p{sc=Miao}+$",
        "^\\p{Script=Plrd}+$",
        "^\\p{sc=Plrd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_inscriptional_parthian() {
    test_with_configs(unicode_escape_property_script_inscriptional_parthian_tc)
}

fn unicode_escape_property_script_inscriptional_parthian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [68416..=68437, 68440..=68447];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Inscriptional_Parthian}+$",
        "^\\p{sc=Inscriptional_Parthian}+$",
        "^\\p{Script=Prti}+$",
        "^\\p{sc=Prti}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_rejang() {
    test_with_configs(unicode_escape_property_script_rejang_tc)
}

fn unicode_escape_property_script_rejang_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [43312..=43347, 43359..=43359];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Rejang}+$",
        "^\\p{sc=Rejang}+$",
        "^\\p{Script=Rjng}+$",
        "^\\p{sc=Rjng}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_hanifi_rohingya() {
    test_with_configs(unicode_escape_property_script_hanifi_rohingya_tc)
}

fn unicode_escape_property_script_hanifi_rohingya_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [68864..=68903, 68912..=68921];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Hanifi_Rohingya}+$",
        "^\\p{sc=Hanifi_Rohingya}+$",
        "^\\p{Script=Rohg}+$",
        "^\\p{sc=Rohg}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_runic() {
    test_with_configs(unicode_escape_property_script_runic_tc)
}

fn unicode_escape_property_script_runic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [5792..=5866, 5870..=5880];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Runic}+$",
        "^\\p{sc=Runic}+$",
        "^\\p{Script=Runr}+$",
        "^\\p{sc=Runr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_samaritan() {
    test_with_configs(unicode_escape_property_script_samaritan_tc)
}

fn unicode_escape_property_script_samaritan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [2048..=2093, 2096..=2110];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Samaritan}+$",
        "^\\p{sc=Samaritan}+$",
        "^\\p{Script=Samr}+$",
        "^\\p{sc=Samr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_south_arabian() {
    test_with_configs(unicode_escape_property_script_old_south_arabian_tc)
}

fn unicode_escape_property_script_old_south_arabian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [68192..=68223];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_South_Arabian}+$",
        "^\\p{sc=Old_South_Arabian}+$",
        "^\\p{Script=Sarb}+$",
        "^\\p{sc=Sarb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_saurashtra() {
    test_with_configs(unicode_escape_property_script_saurashtra_tc)
}

fn unicode_escape_property_script_saurashtra_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [43136..=43205, 43214..=43225];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Saurashtra}+$",
        "^\\p{sc=Saurashtra}+$",
        "^\\p{Script=Saur}+$",
        "^\\p{sc=Saur}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_signwriting() {
    test_with_configs(unicode_escape_property_script_signwriting_tc)
}

fn unicode_escape_property_script_signwriting_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [120832..=121483, 121499..=121503, 121505..=121519];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=SignWriting}+$",
        "^\\p{sc=SignWriting}+$",
        "^\\p{Script=Sgnw}+$",
        "^\\p{sc=Sgnw}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_shavian() {
    test_with_configs(unicode_escape_property_script_shavian_tc)
}

fn unicode_escape_property_script_shavian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [66640..=66687];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Shavian}+$",
        "^\\p{sc=Shavian}+$",
        "^\\p{Script=Shaw}+$",
        "^\\p{sc=Shaw}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_sharada() {
    test_with_configs(unicode_escape_property_script_sharada_tc)
}

fn unicode_escape_property_script_sharada_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [70016..=70111];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Sharada}+$",
        "^\\p{sc=Sharada}+$",
        "^\\p{Script=Shrd}+$",
        "^\\p{sc=Shrd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_siddham() {
    test_with_configs(unicode_escape_property_script_siddham_tc)
}

fn unicode_escape_property_script_siddham_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [71040..=71093, 71096..=71133];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Siddham}+$",
        "^\\p{sc=Siddham}+$",
        "^\\p{Script=Sidd}+$",
        "^\\p{sc=Sidd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_khudawadi() {
    test_with_configs(unicode_escape_property_script_khudawadi_tc)
}

fn unicode_escape_property_script_khudawadi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [70320..=70378, 70384..=70393];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Khudawadi}+$",
        "^\\p{sc=Khudawadi}+$",
        "^\\p{Script=Sind}+$",
        "^\\p{sc=Sind}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_sinhala() {
    test_with_configs(unicode_escape_property_script_sinhala_tc)
}

fn unicode_escape_property_script_sinhala_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 13] = [
        3457..=3459,
        3461..=3478,
        3482..=3505,
        3507..=3515,
        3517..=3517,
        3520..=3526,
        3530..=3530,
        3535..=3540,
        3542..=3542,
        3544..=3551,
        3558..=3567,
        3570..=3572,
        70113..=70132,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Sinhala}+$",
        "^\\p{sc=Sinhala}+$",
        "^\\p{Script=Sinh}+$",
        "^\\p{sc=Sinh}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_sogdian() {
    test_with_configs(unicode_escape_property_script_sogdian_tc)
}

fn unicode_escape_property_script_sogdian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69424..=69465];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Sogdian}+$",
        "^\\p{sc=Sogdian}+$",
        "^\\p{Script=Sogd}+$",
        "^\\p{sc=Sogd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_sogdian() {
    test_with_configs(unicode_escape_property_script_old_sogdian_tc)
}

fn unicode_escape_property_script_old_sogdian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [69376..=69415];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Sogdian}+$",
        "^\\p{sc=Old_Sogdian}+$",
        "^\\p{Script=Sogo}+$",
        "^\\p{sc=Sogo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_sora_sompeng() {
    test_with_configs(unicode_escape_property_script_sora_sompeng_tc)
}

fn unicode_escape_property_script_sora_sompeng_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [69840..=69864, 69872..=69881];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Sora_Sompeng}+$",
        "^\\p{sc=Sora_Sompeng}+$",
        "^\\p{Script=Sora}+$",
        "^\\p{sc=Sora}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_soyombo() {
    test_with_configs(unicode_escape_property_script_soyombo_tc)
}

fn unicode_escape_property_script_soyombo_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [72272..=72354];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Soyombo}+$",
        "^\\p{sc=Soyombo}+$",
        "^\\p{Script=Soyo}+$",
        "^\\p{sc=Soyo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_sundanese() {
    test_with_configs(unicode_escape_property_script_sundanese_tc)
}

fn unicode_escape_property_script_sundanese_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [7040..=7103, 7360..=7367];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Sundanese}+$",
        "^\\p{sc=Sundanese}+$",
        "^\\p{Script=Sund}+$",
        "^\\p{sc=Sund}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_syloti_nagri() {
    test_with_configs(unicode_escape_property_script_syloti_nagri_tc)
}

fn unicode_escape_property_script_syloti_nagri_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [43008..=43052];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Syloti_Nagri}+$",
        "^\\p{sc=Syloti_Nagri}+$",
        "^\\p{Script=Sylo}+$",
        "^\\p{sc=Sylo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_syriac() {
    test_with_configs(unicode_escape_property_script_syriac_tc)
}

fn unicode_escape_property_script_syriac_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [1792..=1805, 1807..=1866, 1869..=1871, 2144..=2154];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Syriac}+$",
        "^\\p{sc=Syriac}+$",
        "^\\p{Script=Syrc}+$",
        "^\\p{sc=Syrc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tagbanwa() {
    test_with_configs(unicode_escape_property_script_tagbanwa_tc)
}

fn unicode_escape_property_script_tagbanwa_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] = [5984..=5996, 5998..=6000, 6002..=6003];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tagbanwa}+$",
        "^\\p{sc=Tagbanwa}+$",
        "^\\p{Script=Tagb}+$",
        "^\\p{sc=Tagb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_takri() {
    test_with_configs(unicode_escape_property_script_takri_tc)
}

fn unicode_escape_property_script_takri_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [71296..=71353, 71360..=71369];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Takri}+$",
        "^\\p{sc=Takri}+$",
        "^\\p{Script=Takr}+$",
        "^\\p{sc=Takr}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tai_le() {
    test_with_configs(unicode_escape_property_script_tai_le_tc)
}

fn unicode_escape_property_script_tai_le_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [6480..=6509, 6512..=6516];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tai_Le}+$",
        "^\\p{sc=Tai_Le}+$",
        "^\\p{Script=Tale}+$",
        "^\\p{sc=Tale}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_new_tai_lue() {
    test_with_configs(unicode_escape_property_script_new_tai_lue_tc)
}

fn unicode_escape_property_script_new_tai_lue_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [6528..=6571, 6576..=6601, 6608..=6618, 6622..=6623];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=New_Tai_Lue}+$",
        "^\\p{sc=New_Tai_Lue}+$",
        "^\\p{Script=Talu}+$",
        "^\\p{sc=Talu}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tamil() {
    test_with_configs(unicode_escape_property_script_tamil_tc)
}

fn unicode_escape_property_script_tamil_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 18] = [
        2946..=2947,
        2949..=2954,
        2958..=2960,
        2962..=2965,
        2969..=2970,
        2972..=2972,
        2974..=2975,
        2979..=2980,
        2984..=2986,
        2990..=3001,
        3006..=3010,
        3014..=3016,
        3018..=3021,
        3024..=3024,
        3031..=3031,
        3046..=3066,
        73664..=73713,
        73727..=73727,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tamil}+$",
        "^\\p{sc=Tamil}+$",
        "^\\p{Script=Taml}+$",
        "^\\p{sc=Taml}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tangut() {
    test_with_configs(unicode_escape_property_script_tangut_tc)
}

fn unicode_escape_property_script_tangut_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] = [
        94176..=94176,
        94208..=100343,
        100352..=101119,
        101632..=101640,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tangut}+$",
        "^\\p{sc=Tangut}+$",
        "^\\p{Script=Tang}+$",
        "^\\p{sc=Tang}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tai_viet() {
    test_with_configs(unicode_escape_property_script_tai_viet_tc)
}

fn unicode_escape_property_script_tai_viet_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [43648..=43714, 43739..=43743];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tai_Viet}+$",
        "^\\p{sc=Tai_Viet}+$",
        "^\\p{Script=Tavt}+$",
        "^\\p{sc=Tavt}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_telugu() {
    test_with_configs(unicode_escape_property_script_telugu_tc)
}

fn unicode_escape_property_script_telugu_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 13] = [
        3072..=3084,
        3086..=3088,
        3090..=3112,
        3114..=3129,
        3132..=3140,
        3142..=3144,
        3146..=3149,
        3157..=3158,
        3160..=3162,
        3165..=3165,
        3168..=3171,
        3174..=3183,
        3191..=3199,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Telugu}+$",
        "^\\p{sc=Telugu}+$",
        "^\\p{Script=Telu}+$",
        "^\\p{sc=Telu}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tifinagh() {
    test_with_configs(unicode_escape_property_script_tifinagh_tc)
}

fn unicode_escape_property_script_tifinagh_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [11568..=11623, 11631..=11632, 11647..=11647];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tifinagh}+$",
        "^\\p{sc=Tifinagh}+$",
        "^\\p{Script=Tfng}+$",
        "^\\p{sc=Tfng}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tagalog() {
    test_with_configs(unicode_escape_property_script_tagalog_tc)
}

fn unicode_escape_property_script_tagalog_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [5888..=5909, 5919..=5919];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tagalog}+$",
        "^\\p{sc=Tagalog}+$",
        "^\\p{Script=Tglg}+$",
        "^\\p{sc=Tglg}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_thaana() {
    test_with_configs(unicode_escape_property_script_thaana_tc)
}

fn unicode_escape_property_script_thaana_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [1920..=1969];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Thaana}+$",
        "^\\p{sc=Thaana}+$",
        "^\\p{Script=Thaa}+$",
        "^\\p{sc=Thaa}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_thai() {
    test_with_configs(unicode_escape_property_script_thai_tc)
}

fn unicode_escape_property_script_thai_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [3585..=3642, 3648..=3675];
    const REGEXES: [&str; 2] = ["^\\p{Script=Thai}+$", "^\\p{sc=Thai}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tibetan() {
    test_with_configs(unicode_escape_property_script_tibetan_tc)
}

fn unicode_escape_property_script_tibetan_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 7] = [
        3840..=3911,
        3913..=3948,
        3953..=3991,
        3993..=4028,
        4030..=4044,
        4046..=4052,
        4057..=4058,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tibetan}+$",
        "^\\p{sc=Tibetan}+$",
        "^\\p{Script=Tibt}+$",
        "^\\p{sc=Tibt}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tirhuta() {
    test_with_configs(unicode_escape_property_script_tirhuta_tc)
}

fn unicode_escape_property_script_tirhuta_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [70784..=70855, 70864..=70873];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tirhuta}+$",
        "^\\p{sc=Tirhuta}+$",
        "^\\p{Script=Tirh}+$",
        "^\\p{sc=Tirh}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_tangsa() {
    test_with_configs(unicode_escape_property_script_tangsa_tc)
}

fn unicode_escape_property_script_tangsa_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [92784..=92862, 92864..=92873];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Tangsa}+$",
        "^\\p{sc=Tangsa}+$",
        "^\\p{Script=Tnsa}+$",
        "^\\p{sc=Tnsa}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_toto() {
    test_with_configs(unicode_escape_property_script_toto_tc)
}

fn unicode_escape_property_script_toto_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [123536..=123566];
    const REGEXES: [&str; 2] = ["^\\p{Script=Toto}+$", "^\\p{sc=Toto}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_ugaritic() {
    test_with_configs(unicode_escape_property_script_ugaritic_tc)
}

fn unicode_escape_property_script_ugaritic_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66432..=66461, 66463..=66463];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Ugaritic}+$",
        "^\\p{sc=Ugaritic}+$",
        "^\\p{Script=Ugar}+$",
        "^\\p{sc=Ugar}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_vai() {
    test_with_configs(unicode_escape_property_script_vai_tc)
}

fn unicode_escape_property_script_vai_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [42240..=42539];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Vai}+$",
        "^\\p{sc=Vai}+$",
        "^\\p{Script=Vaii}+$",
        "^\\p{sc=Vaii}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_vithkuqi() {
    test_with_configs(unicode_escape_property_script_vithkuqi_tc)
}

fn unicode_escape_property_script_vithkuqi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 8] = [
        66928..=66938,
        66940..=66954,
        66956..=66962,
        66964..=66965,
        66967..=66977,
        66979..=66993,
        66995..=67001,
        67003..=67004,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Vithkuqi}+$",
        "^\\p{sc=Vithkuqi}+$",
        "^\\p{Script=Vith}+$",
        "^\\p{sc=Vith}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_warang_citi() {
    test_with_configs(unicode_escape_property_script_warang_citi_tc)
}

fn unicode_escape_property_script_warang_citi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [71840..=71922, 71935..=71935];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Warang_Citi}+$",
        "^\\p{sc=Warang_Citi}+$",
        "^\\p{Script=Wara}+$",
        "^\\p{sc=Wara}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_wancho() {
    test_with_configs(unicode_escape_property_script_wancho_tc)
}

fn unicode_escape_property_script_wancho_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [123584..=123641, 123647..=123647];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Wancho}+$",
        "^\\p{sc=Wancho}+$",
        "^\\p{Script=Wcho}+$",
        "^\\p{sc=Wcho}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_old_persian() {
    test_with_configs(unicode_escape_property_script_old_persian_tc)
}

fn unicode_escape_property_script_old_persian_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [66464..=66499, 66504..=66517];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Old_Persian}+$",
        "^\\p{sc=Old_Persian}+$",
        "^\\p{Script=Xpeo}+$",
        "^\\p{sc=Xpeo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_cuneiform() {
    test_with_configs(unicode_escape_property_script_cuneiform_tc)
}

fn unicode_escape_property_script_cuneiform_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 4] =
        [73728..=74649, 74752..=74862, 74864..=74868, 74880..=75075];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Cuneiform}+$",
        "^\\p{sc=Cuneiform}+$",
        "^\\p{Script=Xsux}+$",
        "^\\p{sc=Xsux}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_yezidi() {
    test_with_configs(unicode_escape_property_script_yezidi_tc)
}

fn unicode_escape_property_script_yezidi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 3] =
        [69248..=69289, 69291..=69293, 69296..=69297];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Yezidi}+$",
        "^\\p{sc=Yezidi}+$",
        "^\\p{Script=Yezi}+$",
        "^\\p{sc=Yezi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_yi() {
    test_with_configs(unicode_escape_property_script_yi_tc)
}

fn unicode_escape_property_script_yi_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 2] = [40960..=42124, 42128..=42182];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Yi}+$",
        "^\\p{sc=Yi}+$",
        "^\\p{Script=Yiii}+$",
        "^\\p{sc=Yiii}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_zanabazar_square() {
    test_with_configs(unicode_escape_property_script_zanabazar_square_tc)
}

fn unicode_escape_property_script_zanabazar_square_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 1] = [72192..=72263];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Zanabazar_Square}+$",
        "^\\p{sc=Zanabazar_Square}+$",
        "^\\p{Script=Zanb}+$",
        "^\\p{sc=Zanb}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_inherited() {
    test_with_configs(unicode_escape_property_script_inherited_tc)
}

fn unicode_escape_property_script_inherited_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 29] = [
        768..=879,
        1157..=1158,
        1611..=1621,
        1648..=1648,
        2385..=2388,
        6832..=6862,
        7376..=7378,
        7380..=7392,
        7394..=7400,
        7405..=7405,
        7412..=7412,
        7416..=7417,
        7616..=7679,
        8204..=8205,
        8400..=8432,
        12330..=12333,
        12441..=12442,
        65024..=65039,
        65056..=65069,
        66045..=66045,
        66272..=66272,
        70459..=70459,
        118528..=118573,
        118576..=118598,
        119143..=119145,
        119163..=119170,
        119173..=119179,
        119210..=119213,
        917760..=917999,
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{Script=Inherited}+$",
        "^\\p{sc=Inherited}+$",
        "^\\p{Script=Zinh}+$",
        "^\\p{sc=Zinh}+$",
        "^\\p{Script=Qaai}+$",
        "^\\p{sc=Qaai}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

#[test]
fn unicode_escape_property_script_common() {
    test_with_configs(unicode_escape_property_script_common_tc)
}

fn unicode_escape_property_script_common_tc(tc: TestConfig) {
    const CODE_POINTS: [std::ops::RangeInclusive<u32>; 173] = [
        0..=64,
        91..=96,
        123..=169,
        171..=185,
        187..=191,
        215..=215,
        247..=247,
        697..=735,
        741..=745,
        748..=767,
        884..=884,
        894..=894,
        901..=901,
        903..=903,
        1541..=1541,
        1548..=1548,
        1563..=1563,
        1567..=1567,
        1600..=1600,
        1757..=1757,
        2274..=2274,
        2404..=2405,
        3647..=3647,
        4053..=4056,
        4347..=4347,
        5867..=5869,
        5941..=5942,
        6146..=6147,
        6149..=6149,
        7379..=7379,
        7393..=7393,
        7401..=7404,
        7406..=7411,
        7413..=7415,
        7418..=7418,
        8192..=8203,
        8206..=8292,
        8294..=8304,
        8308..=8318,
        8320..=8334,
        8352..=8384,
        8448..=8485,
        8487..=8489,
        8492..=8497,
        8499..=8525,
        8527..=8543,
        8585..=8587,
        8592..=9254,
        9280..=9290,
        9312..=10239,
        10496..=11123,
        11126..=11157,
        11159..=11263,
        11776..=11869,
        12272..=12292,
        12294..=12294,
        12296..=12320,
        12336..=12343,
        12348..=12351,
        12443..=12444,
        12448..=12448,
        12539..=12540,
        12688..=12703,
        12736..=12771,
        12783..=12783,
        12832..=12895,
        12927..=13007,
        13055..=13055,
        13144..=13311,
        19904..=19967,
        42752..=42785,
        42888..=42890,
        43056..=43065,
        43310..=43310,
        43471..=43471,
        43867..=43867,
        43882..=43883,
        64830..=64831,
        65040..=65049,
        65072..=65106,
        65108..=65126,
        65128..=65131,
        65279..=65279,
        65281..=65312,
        65339..=65344,
        65371..=65381,
        65392..=65392,
        65438..=65439,
        65504..=65510,
        65512..=65518,
        65529..=65533,
        65792..=65794,
        65799..=65843,
        65847..=65855,
        65936..=65948,
        66000..=66044,
        66273..=66299,
        113824..=113827,
        118608..=118723,
        118784..=119029,
        119040..=119078,
        119081..=119142,
        119146..=119162,
        119171..=119172,
        119180..=119209,
        119214..=119274,
        119488..=119507,
        119520..=119539,
        119552..=119638,
        119648..=119672,
        119808..=119892,
        119894..=119964,
        119966..=119967,
        119970..=119970,
        119973..=119974,
        119977..=119980,
        119982..=119993,
        119995..=119995,
        119997..=120003,
        120005..=120069,
        120071..=120074,
        120077..=120084,
        120086..=120092,
        120094..=120121,
        120123..=120126,
        120128..=120132,
        120134..=120134,
        120138..=120144,
        120146..=120485,
        120488..=120779,
        120782..=120831,
        126065..=126132,
        126209..=126269,
        126976..=127019,
        127024..=127123,
        127136..=127150,
        127153..=127167,
        127169..=127183,
        127185..=127221,
        127232..=127405,
        127462..=127487,
        127489..=127490,
        127504..=127547,
        127552..=127560,
        127568..=127569,
        127584..=127589,
        127744..=128727,
        128732..=128748,
        128752..=128764,
        128768..=128886,
        128891..=128985,
        128992..=129003,
        129008..=129008,
        129024..=129035,
        129040..=129095,
        129104..=129113,
        129120..=129159,
        129168..=129197,
        129200..=129201,
        129280..=129619,
        129632..=129645,
        129648..=129660,
        129664..=129672,
        129680..=129725,
        129727..=129733,
        129742..=129755,
        129760..=129768,
        129776..=129784,
        129792..=129938,
        129940..=129994,
        130032..=130041,
        917505..=917505,
        917536..=917631,
    ];
    const REGEXES: [&str; 4] = [
        "^\\p{Script=Common}+$",
        "^\\p{sc=Common}+$",
        "^\\p{Script=Zyyy}+$",
        "^\\p{sc=Zyyy}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for range in CODE_POINTS {
            for cp in range {
                regex.test_succeeds(&char::from_u32(cp).unwrap().to_string());
            }
        }
    }
}

pub mod common;

#[test]
fn unicode_escape_property_binary_alphabetic() {
    test_with_configs(unicode_escape_property_binary_alphabetic_tc)
}

fn unicode_escape_property_binary_alphabetic_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1141] = [
        "\u{41}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{345}",
        "\u{370}",
        "\u{374}",
        "\u{376}",
        "\u{37a}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{560}",
        "\u{5b0}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{610}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{64b}",
        "\u{659}",
        "\u{66e}",
        "\u{670}",
        "\u{671}",
        "\u{6d5}",
        "\u{6d6}",
        "\u{6e1}",
        "\u{6e5}",
        "\u{6e7}",
        "\u{6ed}",
        "\u{6ee}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{711}",
        "\u{712}",
        "\u{730}",
        "\u{74d}",
        "\u{7a6}",
        "\u{7b1}",
        "\u{7ca}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{800}",
        "\u{816}",
        "\u{81a}",
        "\u{81b}",
        "\u{824}",
        "\u{825}",
        "\u{828}",
        "\u{829}",
        "\u{840}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{8d4}",
        "\u{8e3}",
        "\u{8f0}",
        "\u{903}",
        "\u{904}",
        "\u{93a}",
        "\u{93b}",
        "\u{93d}",
        "\u{93e}",
        "\u{941}",
        "\u{949}",
        "\u{94e}",
        "\u{950}",
        "\u{955}",
        "\u{958}",
        "\u{962}",
        "\u{971}",
        "\u{972}",
        "\u{981}",
        "\u{982}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9be}",
        "\u{9c1}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9ce}",
        "\u{9d7}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9e2}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{a01}",
        "\u{a03}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a3e}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a70}",
        "\u{a72}",
        "\u{a75}",
        "\u{a81}",
        "\u{a83}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{abe}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{ac9}",
        "\u{acb}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{ae2}",
        "\u{af9}",
        "\u{afa}",
        "\u{b01}",
        "\u{b02}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b3e}",
        "\u{b3f}",
        "\u{b40}",
        "\u{b41}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b56}",
        "\u{b57}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b62}",
        "\u{b71}",
        "\u{b82}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bbe}",
        "\u{bc0}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bd0}",
        "\u{bd7}",
        "\u{c00}",
        "\u{c01}",
        "\u{c04}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c3e}",
        "\u{c41}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c62}",
        "\u{c80}",
        "\u{c81}",
        "\u{c82}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cbe}",
        "\u{cbf}",
        "\u{cc0}",
        "\u{cc6}",
        "\u{cc7}",
        "\u{cca}",
        "\u{ccc}",
        "\u{cd5}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{ce2}",
        "\u{cf1}",
        "\u{cf3}",
        "\u{d00}",
        "\u{d02}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d3e}",
        "\u{d41}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d57}",
        "\u{d5f}",
        "\u{d62}",
        "\u{d7a}",
        "\u{d81}",
        "\u{d82}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{dcf}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{dd8}",
        "\u{df2}",
        "\u{e01}",
        "\u{e31}",
        "\u{e32}",
        "\u{e34}",
        "\u{e40}",
        "\u{e46}",
        "\u{e4d}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb1}",
        "\u{eb2}",
        "\u{eb4}",
        "\u{ebb}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{ecd}",
        "\u{edc}",
        "\u{f00}",
        "\u{f40}",
        "\u{f49}",
        "\u{f71}",
        "\u{f7f}",
        "\u{f80}",
        "\u{f88}",
        "\u{f8d}",
        "\u{f99}",
        "\u{1000}",
        "\u{102b}",
        "\u{102d}",
        "\u{1031}",
        "\u{1032}",
        "\u{1038}",
        "\u{103b}",
        "\u{103d}",
        "\u{103f}",
        "\u{1050}",
        "\u{1056}",
        "\u{1058}",
        "\u{105a}",
        "\u{105e}",
        "\u{1061}",
        "\u{1062}",
        "\u{1065}",
        "\u{1067}",
        "\u{106e}",
        "\u{1071}",
        "\u{1075}",
        "\u{1082}",
        "\u{1083}",
        "\u{1085}",
        "\u{1087}",
        "\u{108d}",
        "\u{108e}",
        "\u{108f}",
        "\u{109a}",
        "\u{109d}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1380}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{1712}",
        "\u{171f}",
        "\u{1732}",
        "\u{1740}",
        "\u{1752}",
        "\u{1760}",
        "\u{176e}",
        "\u{1772}",
        "\u{1780}",
        "\u{17b6}",
        "\u{17b7}",
        "\u{17be}",
        "\u{17c6}",
        "\u{17c7}",
        "\u{17d7}",
        "\u{17dc}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1885}",
        "\u{1887}",
        "\u{18a9}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1920}",
        "\u{1923}",
        "\u{1927}",
        "\u{1929}",
        "\u{1930}",
        "\u{1932}",
        "\u{1933}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{1a00}",
        "\u{1a17}",
        "\u{1a19}",
        "\u{1a1b}",
        "\u{1a20}",
        "\u{1a55}",
        "\u{1a56}",
        "\u{1a57}",
        "\u{1a58}",
        "\u{1a61}",
        "\u{1a62}",
        "\u{1a63}",
        "\u{1a65}",
        "\u{1a6d}",
        "\u{1a73}",
        "\u{1aa7}",
        "\u{1abf}",
        "\u{1acc}",
        "\u{1b00}",
        "\u{1b04}",
        "\u{1b05}",
        "\u{1b35}",
        "\u{1b36}",
        "\u{1b3b}",
        "\u{1b3c}",
        "\u{1b3d}",
        "\u{1b42}",
        "\u{1b43}",
        "\u{1b45}",
        "\u{1b80}",
        "\u{1b82}",
        "\u{1b83}",
        "\u{1ba1}",
        "\u{1ba2}",
        "\u{1ba6}",
        "\u{1ba8}",
        "\u{1bac}",
        "\u{1bae}",
        "\u{1bba}",
        "\u{1be7}",
        "\u{1be8}",
        "\u{1bea}",
        "\u{1bed}",
        "\u{1bee}",
        "\u{1bef}",
        "\u{1c00}",
        "\u{1c24}",
        "\u{1c2c}",
        "\u{1c34}",
        "\u{1c36}",
        "\u{1c4d}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1de7}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{2de0}",
        "\u{2e2f}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{3031}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{3041}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a610}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a674}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a69e}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a717}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a802}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80b}",
        "\u{a80c}",
        "\u{a823}",
        "\u{a825}",
        "\u{a827}",
        "\u{a840}",
        "\u{a880}",
        "\u{a882}",
        "\u{a8b4}",
        "\u{a8c5}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a8ff}",
        "\u{a90a}",
        "\u{a926}",
        "\u{a930}",
        "\u{a947}",
        "\u{a952}",
        "\u{a960}",
        "\u{a980}",
        "\u{a983}",
        "\u{a984}",
        "\u{a9b4}",
        "\u{a9b6}",
        "\u{a9ba}",
        "\u{a9bc}",
        "\u{a9be}",
        "\u{a9cf}",
        "\u{a9e0}",
        "\u{a9e5}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa29}",
        "\u{aa2f}",
        "\u{aa31}",
        "\u{aa33}",
        "\u{aa35}",
        "\u{aa40}",
        "\u{aa43}",
        "\u{aa44}",
        "\u{aa4c}",
        "\u{aa4d}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7b}",
        "\u{aa7c}",
        "\u{aa7d}",
        "\u{aa7e}",
        "\u{aab0}",
        "\u{aab1}",
        "\u{aab2}",
        "\u{aab5}",
        "\u{aab7}",
        "\u{aab9}",
        "\u{aabe}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aae0}",
        "\u{aaeb}",
        "\u{aaec}",
        "\u{aaee}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{aaf5}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{abe3}",
        "\u{abe5}",
        "\u{abe6}",
        "\u{abe8}",
        "\u{abe9}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1e}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff21}",
        "\u{ff41}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ff9e}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10140}",
        "\u{10280}",
        "\u{102a0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10376}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10d00}",
        "\u{10d24}",
        "\u{10e80}",
        "\u{10eab}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f70}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11000}",
        "\u{11001}",
        "\u{11002}",
        "\u{11003}",
        "\u{11038}",
        "\u{11071}",
        "\u{11073}",
        "\u{11075}",
        "\u{11080}",
        "\u{11082}",
        "\u{11083}",
        "\u{110b0}",
        "\u{110b3}",
        "\u{110b7}",
        "\u{110c2}",
        "\u{110d0}",
        "\u{11100}",
        "\u{11103}",
        "\u{11127}",
        "\u{1112c}",
        "\u{1112d}",
        "\u{11144}",
        "\u{11145}",
        "\u{11147}",
        "\u{11150}",
        "\u{11176}",
        "\u{11180}",
        "\u{11182}",
        "\u{11183}",
        "\u{111b3}",
        "\u{111b6}",
        "\u{111bf}",
        "\u{111c1}",
        "\u{111ce}",
        "\u{111cf}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1122c}",
        "\u{1122f}",
        "\u{11232}",
        "\u{11234}",
        "\u{11237}",
        "\u{1123e}",
        "\u{1123f}",
        "\u{11241}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{112df}",
        "\u{112e0}",
        "\u{112e3}",
        "\u{11300}",
        "\u{11302}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{1133e}",
        "\u{11340}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11350}",
        "\u{11357}",
        "\u{1135d}",
        "\u{11362}",
        "\u{11400}",
        "\u{11435}",
        "\u{11438}",
        "\u{11440}",
        "\u{11443}",
        "\u{11445}",
        "\u{11447}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114b0}",
        "\u{114b3}",
        "\u{114b9}",
        "\u{114ba}",
        "\u{114bb}",
        "\u{114bf}",
        "\u{114c1}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{11580}",
        "\u{115af}",
        "\u{115b2}",
        "\u{115b8}",
        "\u{115bc}",
        "\u{115be}",
        "\u{115d8}",
        "\u{115dc}",
        "\u{11600}",
        "\u{11630}",
        "\u{11633}",
        "\u{1163b}",
        "\u{1163d}",
        "\u{1163e}",
        "\u{11640}",
        "\u{11644}",
        "\u{11680}",
        "\u{116ab}",
        "\u{116ac}",
        "\u{116ad}",
        "\u{116ae}",
        "\u{116b0}",
        "\u{116b8}",
        "\u{11700}",
        "\u{1171d}",
        "\u{11720}",
        "\u{11722}",
        "\u{11726}",
        "\u{11727}",
        "\u{11740}",
        "\u{11800}",
        "\u{1182c}",
        "\u{1182f}",
        "\u{11838}",
        "\u{118a0}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{11930}",
        "\u{11937}",
        "\u{1193b}",
        "\u{1193f}",
        "\u{11940}",
        "\u{11941}",
        "\u{11942}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119d1}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119dc}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{119e4}",
        "\u{11a00}",
        "\u{11a01}",
        "\u{11a0b}",
        "\u{11a35}",
        "\u{11a39}",
        "\u{11a3a}",
        "\u{11a3b}",
        "\u{11a50}",
        "\u{11a51}",
        "\u{11a57}",
        "\u{11a59}",
        "\u{11a5c}",
        "\u{11a8a}",
        "\u{11a97}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c2f}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3e}",
        "\u{11c40}",
        "\u{11c72}",
        "\u{11c92}",
        "\u{11ca9}",
        "\u{11caa}",
        "\u{11cb1}",
        "\u{11cb2}",
        "\u{11cb4}",
        "\u{11cb5}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d43}",
        "\u{11d46}",
        "\u{11d47}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d8a}",
        "\u{11d90}",
        "\u{11d93}",
        "\u{11d95}",
        "\u{11d96}",
        "\u{11d98}",
        "\u{11ee0}",
        "\u{11ef3}",
        "\u{11ef5}",
        "\u{11f00}",
        "\u{11f02}",
        "\u{11f03}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11f34}",
        "\u{11f36}",
        "\u{11f3e}",
        "\u{11f40}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12400}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a70}",
        "\u{16ad0}",
        "\u{16b00}",
        "\u{16b40}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16f00}",
        "\u{16f4f}",
        "\u{16f50}",
        "\u{16f51}",
        "\u{16f8f}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{16ff0}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1bc9e}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e030}",
        "\u{1e08f}",
        "\u{1e100}",
        "\u{1e137}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e900}",
        "\u{1e947}",
        "\u{1e94b}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1f130}",
        "\u{1f150}",
        "\u{1f170}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Alphabetic}+$", "^\\p{Alpha}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_caseignorable() {
    test_with_configs(unicode_escape_property_binary_caseignorable_tc)
}

fn unicode_escape_property_binary_caseignorable_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 491] = [
        "\u{27}",
        "\u{2e}",
        "\u{3a}",
        "\u{5e}",
        "\u{60}",
        "\u{a8}",
        "\u{ad}",
        "\u{af}",
        "\u{b4}",
        "\u{b7}",
        "\u{b8}",
        "\u{2b0}",
        "\u{2c2}",
        "\u{2c6}",
        "\u{2d2}",
        "\u{2e0}",
        "\u{2e5}",
        "\u{2ec}",
        "\u{2ed}",
        "\u{2ee}",
        "\u{2ef}",
        "\u{300}",
        "\u{374}",
        "\u{375}",
        "\u{37a}",
        "\u{384}",
        "\u{387}",
        "\u{483}",
        "\u{488}",
        "\u{559}",
        "\u{55f}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{5f4}",
        "\u{600}",
        "\u{610}",
        "\u{61c}",
        "\u{640}",
        "\u{64b}",
        "\u{670}",
        "\u{6d6}",
        "\u{6dd}",
        "\u{6df}",
        "\u{6e5}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{70f}",
        "\u{711}",
        "\u{730}",
        "\u{7a6}",
        "\u{7eb}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{7fd}",
        "\u{816}",
        "\u{81a}",
        "\u{81b}",
        "\u{824}",
        "\u{825}",
        "\u{828}",
        "\u{829}",
        "\u{859}",
        "\u{888}",
        "\u{890}",
        "\u{898}",
        "\u{8c9}",
        "\u{8ca}",
        "\u{8e2}",
        "\u{8e3}",
        "\u{93a}",
        "\u{93c}",
        "\u{941}",
        "\u{94d}",
        "\u{951}",
        "\u{962}",
        "\u{971}",
        "\u{981}",
        "\u{9bc}",
        "\u{9c1}",
        "\u{9cd}",
        "\u{9e2}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a3c}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a70}",
        "\u{a75}",
        "\u{a81}",
        "\u{abc}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{acd}",
        "\u{ae2}",
        "\u{afa}",
        "\u{b01}",
        "\u{b3c}",
        "\u{b3f}",
        "\u{b41}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b62}",
        "\u{b82}",
        "\u{bc0}",
        "\u{bcd}",
        "\u{c00}",
        "\u{c04}",
        "\u{c3c}",
        "\u{c3e}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c62}",
        "\u{c81}",
        "\u{cbc}",
        "\u{cbf}",
        "\u{cc6}",
        "\u{ccc}",
        "\u{ce2}",
        "\u{d00}",
        "\u{d3b}",
        "\u{d41}",
        "\u{d4d}",
        "\u{d62}",
        "\u{d81}",
        "\u{dca}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{e31}",
        "\u{e34}",
        "\u{e46}",
        "\u{e47}",
        "\u{eb1}",
        "\u{eb4}",
        "\u{ec6}",
        "\u{ec8}",
        "\u{f18}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f71}",
        "\u{f80}",
        "\u{f86}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{102d}",
        "\u{1032}",
        "\u{1039}",
        "\u{103d}",
        "\u{1058}",
        "\u{105e}",
        "\u{1071}",
        "\u{1082}",
        "\u{1085}",
        "\u{108d}",
        "\u{109d}",
        "\u{10fc}",
        "\u{135d}",
        "\u{1712}",
        "\u{1732}",
        "\u{1752}",
        "\u{1772}",
        "\u{17b4}",
        "\u{17b7}",
        "\u{17c6}",
        "\u{17c9}",
        "\u{17d7}",
        "\u{17dd}",
        "\u{180b}",
        "\u{180e}",
        "\u{180f}",
        "\u{1843}",
        "\u{1885}",
        "\u{18a9}",
        "\u{1920}",
        "\u{1927}",
        "\u{1932}",
        "\u{1939}",
        "\u{1a17}",
        "\u{1a1b}",
        "\u{1a56}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a62}",
        "\u{1a65}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1aa7}",
        "\u{1ab0}",
        "\u{1abe}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b34}",
        "\u{1b36}",
        "\u{1b3c}",
        "\u{1b42}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1ba2}",
        "\u{1ba8}",
        "\u{1bab}",
        "\u{1be6}",
        "\u{1be8}",
        "\u{1bed}",
        "\u{1bef}",
        "\u{1c2c}",
        "\u{1c36}",
        "\u{1c78}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce2}",
        "\u{1ced}",
        "\u{1cf4}",
        "\u{1cf8}",
        "\u{1d2c}",
        "\u{1d78}",
        "\u{1d9b}",
        "\u{1dc0}",
        "\u{1fbd}",
        "\u{1fbf}",
        "\u{1fcd}",
        "\u{1fdd}",
        "\u{1fed}",
        "\u{1ffd}",
        "\u{200b}",
        "\u{2018}",
        "\u{2019}",
        "\u{2024}",
        "\u{2027}",
        "\u{202a}",
        "\u{2060}",
        "\u{2066}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{20d0}",
        "\u{20dd}",
        "\u{20e1}",
        "\u{20e2}",
        "\u{20e5}",
        "\u{2c7c}",
        "\u{2cef}",
        "\u{2d6f}",
        "\u{2d7f}",
        "\u{2de0}",
        "\u{2e2f}",
        "\u{3005}",
        "\u{302a}",
        "\u{3031}",
        "\u{303b}",
        "\u{3099}",
        "\u{309b}",
        "\u{309d}",
        "\u{30fc}",
        "\u{a015}",
        "\u{a4f8}",
        "\u{a60c}",
        "\u{a66f}",
        "\u{a670}",
        "\u{a674}",
        "\u{a67f}",
        "\u{a69c}",
        "\u{a69e}",
        "\u{a6f0}",
        "\u{a700}",
        "\u{a717}",
        "\u{a720}",
        "\u{a770}",
        "\u{a788}",
        "\u{a789}",
        "\u{a7f2}",
        "\u{a7f8}",
        "\u{a802}",
        "\u{a806}",
        "\u{a80b}",
        "\u{a825}",
        "\u{a82c}",
        "\u{a8c4}",
        "\u{a8e0}",
        "\u{a8ff}",
        "\u{a926}",
        "\u{a947}",
        "\u{a980}",
        "\u{a9b3}",
        "\u{a9b6}",
        "\u{a9bc}",
        "\u{a9cf}",
        "\u{a9e5}",
        "\u{a9e6}",
        "\u{aa29}",
        "\u{aa31}",
        "\u{aa35}",
        "\u{aa43}",
        "\u{aa4c}",
        "\u{aa70}",
        "\u{aa7c}",
        "\u{aab0}",
        "\u{aab2}",
        "\u{aab7}",
        "\u{aabe}",
        "\u{aac1}",
        "\u{aadd}",
        "\u{aaec}",
        "\u{aaf3}",
        "\u{aaf6}",
        "\u{ab5b}",
        "\u{ab5c}",
        "\u{ab69}",
        "\u{ab6a}",
        "\u{abe5}",
        "\u{abe8}",
        "\u{abed}",
        "\u{fb1e}",
        "\u{fbb2}",
        "\u{fe00}",
        "\u{fe13}",
        "\u{fe20}",
        "\u{fe52}",
        "\u{fe55}",
        "\u{feff}",
        "\u{ff07}",
        "\u{ff0e}",
        "\u{ff1a}",
        "\u{ff3e}",
        "\u{ff40}",
        "\u{ff70}",
        "\u{ff9e}",
        "\u{ffe3}",
        "\u{fff9}",
        "\u{101fd}",
        "\u{102e0}",
        "\u{10376}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10ae5}",
        "\u{10d24}",
        "\u{10eab}",
        "\u{10efd}",
        "\u{10f46}",
        "\u{10f82}",
        "\u{11001}",
        "\u{11038}",
        "\u{11070}",
        "\u{11073}",
        "\u{1107f}",
        "\u{110b3}",
        "\u{110b9}",
        "\u{110bd}",
        "\u{110c2}",
        "\u{110cd}",
        "\u{11100}",
        "\u{11127}",
        "\u{1112d}",
        "\u{11173}",
        "\u{11180}",
        "\u{111b6}",
        "\u{111c9}",
        "\u{111cf}",
        "\u{1122f}",
        "\u{11234}",
        "\u{11236}",
        "\u{1123e}",
        "\u{11241}",
        "\u{112df}",
        "\u{112e3}",
        "\u{11300}",
        "\u{1133b}",
        "\u{11340}",
        "\u{11366}",
        "\u{11370}",
        "\u{11438}",
        "\u{11442}",
        "\u{11446}",
        "\u{1145e}",
        "\u{114b3}",
        "\u{114ba}",
        "\u{114bf}",
        "\u{114c2}",
        "\u{115b2}",
        "\u{115bc}",
        "\u{115bf}",
        "\u{115dc}",
        "\u{11633}",
        "\u{1163d}",
        "\u{1163f}",
        "\u{116ab}",
        "\u{116ad}",
        "\u{116b0}",
        "\u{116b7}",
        "\u{1171d}",
        "\u{11722}",
        "\u{11727}",
        "\u{1182f}",
        "\u{11839}",
        "\u{1193b}",
        "\u{1193e}",
        "\u{11943}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119e0}",
        "\u{11a01}",
        "\u{11a33}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a51}",
        "\u{11a59}",
        "\u{11a8a}",
        "\u{11a98}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3f}",
        "\u{11c92}",
        "\u{11caa}",
        "\u{11cb2}",
        "\u{11cb5}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d47}",
        "\u{11d90}",
        "\u{11d95}",
        "\u{11d97}",
        "\u{11ef3}",
        "\u{11f00}",
        "\u{11f36}",
        "\u{11f40}",
        "\u{11f42}",
        "\u{13430}",
        "\u{13440}",
        "\u{13447}",
        "\u{16af0}",
        "\u{16b30}",
        "\u{16b40}",
        "\u{16f4f}",
        "\u{16f8f}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{16fe4}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1bc9d}",
        "\u{1bca0}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d167}",
        "\u{1d173}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e030}",
        "\u{1e08f}",
        "\u{1e130}",
        "\u{1e137}",
        "\u{1e2ae}",
        "\u{1e2ec}",
        "\u{1e4eb}",
        "\u{1e4ec}",
        "\u{1e8d0}",
        "\u{1e944}",
        "\u{1e94b}",
        "\u{1f3fb}",
        "\u{e0001}",
        "\u{e0020}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Case_Ignorable}+$", "^\\p{CI}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_cased() {
    test_with_configs(unicode_escape_property_binary_cased_tc)
}

fn unicode_escape_property_binary_cased_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 174] = [
        "\u{41}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c0}",
        "\u{2e0}",
        "\u{345}",
        "\u{370}",
        "\u{376}",
        "\u{37a}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{48a}",
        "\u{531}",
        "\u{560}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212f}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a640}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a78b}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff21}",
        "\u{ff41}",
        "\u{10400}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10780}",
        "\u{10783}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1df00}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e030}",
        "\u{1e900}",
        "\u{1f130}",
        "\u{1f150}",
        "\u{1f170}",
    ];
    const REGEXES: [&str; 1] = ["^\\p{Cased}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhencasefolded() {
    test_with_configs(unicode_escape_property_binary_changeswhencasefolded_tc)
}

fn unicode_escape_property_binary_changeswhencasefolded_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 622] = [
        "\u{41}",
        "\u{b5}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{149}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{17f}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{345}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3c2}",
        "\u{3cf}",
        "\u{3d5}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f0}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{587}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9a}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1f80}",
        "\u{1fb2}",
        "\u{1fb7}",
        "\u{1fc2}",
        "\u{1fc7}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff2}",
        "\u{1ff7}",
        "\u{2126}",
        "\u{212a}",
        "\u{2132}",
        "\u{2160}",
        "\u{2183}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_Casefolded}+$", "^\\p{CWCF}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhencasemapped() {
    test_with_configs(unicode_escape_property_binary_changeswhencasemapped_tc)
}

fn unicode_escape_property_binary_changeswhencasemapped_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 131] = [
        "\u{41}",
        "\u{61}",
        "\u{b5}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{139}",
        "\u{18e}",
        "\u{19c}",
        "\u{1ac}",
        "\u{1bc}",
        "\u{1bf}",
        "\u{1c4}",
        "\u{222}",
        "\u{23a}",
        "\u{256}",
        "\u{259}",
        "\u{25b}",
        "\u{260}",
        "\u{263}",
        "\u{265}",
        "\u{268}",
        "\u{26f}",
        "\u{271}",
        "\u{275}",
        "\u{27d}",
        "\u{280}",
        "\u{282}",
        "\u{287}",
        "\u{292}",
        "\u{29d}",
        "\u{345}",
        "\u{370}",
        "\u{376}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3d5}",
        "\u{3f7}",
        "\u{3fd}",
        "\u{48a}",
        "\u{531}",
        "\u{561}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fd}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1d79}",
        "\u{1d7d}",
        "\u{1d8e}",
        "\u{1e00}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2126}",
        "\u{212a}",
        "\u{2132}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a640}",
        "\u{a680}",
        "\u{a722}",
        "\u{a732}",
        "\u{a779}",
        "\u{a78b}",
        "\u{a790}",
        "\u{a796}",
        "\u{a7b0}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7f5}",
        "\u{ab53}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff21}",
        "\u{ff41}",
        "\u{10400}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_Casemapped}+$", "^\\p{CWCM}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhenlowercased() {
    test_with_configs(unicode_escape_property_binary_changeswhenlowercased_tc)
}

fn unicode_escape_property_binary_changeswhenlowercased_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 609] = [
        "\u{41}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{14a}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3cf}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13a0}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1f88}",
        "\u{1f98}",
        "\u{1fa8}",
        "\u{1fb8}",
        "\u{1fc8}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff8}",
        "\u{2126}",
        "\u{212a}",
        "\u{2132}",
        "\u{2160}",
        "\u{2183}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_Lowercased}+$", "^\\p{CWL}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhentitlecased() {
    test_with_configs(unicode_escape_property_binary_changeswhentitlecased_tc)
}

fn unicode_escape_property_binary_changeswhentitlecased_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 626] = [
        "\u{61}",
        "\u{b5}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1bf}",
        "\u{1c4}",
        "\u{1c6}",
        "\u{1c9}",
        "\u{1cc}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f3}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{256}",
        "\u{259}",
        "\u{25b}",
        "\u{260}",
        "\u{263}",
        "\u{265}",
        "\u{268}",
        "\u{26f}",
        "\u{271}",
        "\u{275}",
        "\u{27d}",
        "\u{280}",
        "\u{282}",
        "\u{287}",
        "\u{292}",
        "\u{29d}",
        "\u{345}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{561}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d79}",
        "\u{1d7d}",
        "\u{1d8e}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1f90}",
        "\u{1fa0}",
        "\u{1fb0}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{214e}",
        "\u{2170}",
        "\u{2184}",
        "\u{24d0}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f6}",
        "\u{ab53}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1e922}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_Titlecased}+$", "^\\p{CWT}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhenuppercased() {
    test_with_configs(unicode_escape_property_binary_changeswhenuppercased_tc)
}

fn unicode_escape_property_binary_changeswhenuppercased_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 627] = [
        "\u{61}",
        "\u{b5}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1bf}",
        "\u{1c5}",
        "\u{1c8}",
        "\u{1cb}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f2}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{256}",
        "\u{259}",
        "\u{25b}",
        "\u{260}",
        "\u{263}",
        "\u{265}",
        "\u{268}",
        "\u{26f}",
        "\u{271}",
        "\u{275}",
        "\u{27d}",
        "\u{280}",
        "\u{282}",
        "\u{287}",
        "\u{292}",
        "\u{29d}",
        "\u{345}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{561}",
        "\u{10d0}",
        "\u{10fd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d79}",
        "\u{1d7d}",
        "\u{1d8e}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbc}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fcc}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{1ffc}",
        "\u{214e}",
        "\u{2170}",
        "\u{2184}",
        "\u{24d0}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f6}",
        "\u{ab53}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1e922}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_Uppercased}+$", "^\\p{CWU}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_defaultignorablecodepoint() {
    test_with_configs(unicode_escape_property_binary_defaultignorablecodepoint_tc)
}

fn unicode_escape_property_binary_defaultignorablecodepoint_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 27] = [
        "\u{ad}",
        "\u{34f}",
        "\u{61c}",
        "\u{115f}",
        "\u{17b4}",
        "\u{180b}",
        "\u{180e}",
        "\u{180f}",
        "\u{200b}",
        "\u{202a}",
        "\u{2060}",
        "\u{2065}",
        "\u{2066}",
        "\u{3164}",
        "\u{fe00}",
        "\u{feff}",
        "\u{ffa0}",
        "\u{fff0}",
        "\u{1bca0}",
        "\u{1d173}",
        "\u{e0000}",
        "\u{e0001}",
        "\u{e0002}",
        "\u{e0020}",
        "\u{e0080}",
        "\u{e0100}",
        "\u{e01f0}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Default_Ignorable_Code_Point}+$", "^\\p{DI}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_graphemebase() {
    test_with_configs(unicode_escape_property_binary_graphemebase_tc)
}

fn unicode_escape_property_binary_graphemebase_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1743] = [
        "\u{20}",
        "\u{21}",
        "\u{24}",
        "\u{25}",
        "\u{28}",
        "\u{29}",
        "\u{2a}",
        "\u{2b}",
        "\u{2c}",
        "\u{2d}",
        "\u{2e}",
        "\u{30}",
        "\u{3a}",
        "\u{3c}",
        "\u{3f}",
        "\u{41}",
        "\u{5b}",
        "\u{5c}",
        "\u{5d}",
        "\u{5e}",
        "\u{5f}",
        "\u{60}",
        "\u{61}",
        "\u{7b}",
        "\u{7c}",
        "\u{7d}",
        "\u{7e}",
        "\u{a0}",
        "\u{a1}",
        "\u{a2}",
        "\u{a6}",
        "\u{a7}",
        "\u{a8}",
        "\u{a9}",
        "\u{aa}",
        "\u{ab}",
        "\u{ac}",
        "\u{ae}",
        "\u{af}",
        "\u{b0}",
        "\u{b1}",
        "\u{b2}",
        "\u{b4}",
        "\u{b5}",
        "\u{b6}",
        "\u{b8}",
        "\u{b9}",
        "\u{ba}",
        "\u{bb}",
        "\u{bc}",
        "\u{bf}",
        "\u{c0}",
        "\u{d7}",
        "\u{d8}",
        "\u{f7}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c2}",
        "\u{2c6}",
        "\u{2d2}",
        "\u{2e0}",
        "\u{2e5}",
        "\u{2ec}",
        "\u{2ed}",
        "\u{2ee}",
        "\u{2ef}",
        "\u{370}",
        "\u{374}",
        "\u{375}",
        "\u{376}",
        "\u{37a}",
        "\u{37b}",
        "\u{37e}",
        "\u{37f}",
        "\u{384}",
        "\u{386}",
        "\u{387}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f6}",
        "\u{3f7}",
        "\u{482}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{55a}",
        "\u{560}",
        "\u{589}",
        "\u{58a}",
        "\u{58d}",
        "\u{58f}",
        "\u{5be}",
        "\u{5c0}",
        "\u{5c3}",
        "\u{5c6}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{5f3}",
        "\u{606}",
        "\u{609}",
        "\u{60b}",
        "\u{60c}",
        "\u{60e}",
        "\u{61b}",
        "\u{61d}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{660}",
        "\u{66a}",
        "\u{66e}",
        "\u{671}",
        "\u{6d4}",
        "\u{6d5}",
        "\u{6de}",
        "\u{6e5}",
        "\u{6e9}",
        "\u{6ee}",
        "\u{6f0}",
        "\u{6fa}",
        "\u{6fd}",
        "\u{6ff}",
        "\u{700}",
        "\u{710}",
        "\u{712}",
        "\u{74d}",
        "\u{7b1}",
        "\u{7c0}",
        "\u{7ca}",
        "\u{7f4}",
        "\u{7f6}",
        "\u{7f7}",
        "\u{7fa}",
        "\u{7fe}",
        "\u{800}",
        "\u{81a}",
        "\u{824}",
        "\u{828}",
        "\u{830}",
        "\u{840}",
        "\u{85e}",
        "\u{860}",
        "\u{870}",
        "\u{888}",
        "\u{889}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{903}",
        "\u{904}",
        "\u{93b}",
        "\u{93d}",
        "\u{93e}",
        "\u{949}",
        "\u{94e}",
        "\u{950}",
        "\u{958}",
        "\u{964}",
        "\u{966}",
        "\u{970}",
        "\u{971}",
        "\u{972}",
        "\u{982}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9bf}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9ce}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9e6}",
        "\u{9f0}",
        "\u{9f2}",
        "\u{9f4}",
        "\u{9fa}",
        "\u{9fb}",
        "\u{9fc}",
        "\u{9fd}",
        "\u{a03}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a3e}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a66}",
        "\u{a72}",
        "\u{a76}",
        "\u{a83}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{abe}",
        "\u{ac9}",
        "\u{acb}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{ae6}",
        "\u{af0}",
        "\u{af1}",
        "\u{af9}",
        "\u{b02}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b40}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b66}",
        "\u{b70}",
        "\u{b71}",
        "\u{b72}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bbf}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bd0}",
        "\u{be6}",
        "\u{bf0}",
        "\u{bf3}",
        "\u{bf9}",
        "\u{bfa}",
        "\u{c01}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c41}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c66}",
        "\u{c77}",
        "\u{c78}",
        "\u{c7f}",
        "\u{c80}",
        "\u{c82}",
        "\u{c84}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cbe}",
        "\u{cc0}",
        "\u{cc3}",
        "\u{cc7}",
        "\u{cca}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{ce6}",
        "\u{cf1}",
        "\u{cf3}",
        "\u{d02}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d3f}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d4e}",
        "\u{d4f}",
        "\u{d54}",
        "\u{d58}",
        "\u{d5f}",
        "\u{d66}",
        "\u{d70}",
        "\u{d79}",
        "\u{d7a}",
        "\u{d82}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{dd0}",
        "\u{dd8}",
        "\u{de6}",
        "\u{df2}",
        "\u{df4}",
        "\u{e01}",
        "\u{e32}",
        "\u{e3f}",
        "\u{e40}",
        "\u{e46}",
        "\u{e4f}",
        "\u{e50}",
        "\u{e5a}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb2}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{ed0}",
        "\u{edc}",
        "\u{f00}",
        "\u{f01}",
        "\u{f04}",
        "\u{f13}",
        "\u{f14}",
        "\u{f15}",
        "\u{f1a}",
        "\u{f20}",
        "\u{f2a}",
        "\u{f34}",
        "\u{f36}",
        "\u{f38}",
        "\u{f3a}",
        "\u{f3b}",
        "\u{f3c}",
        "\u{f3d}",
        "\u{f3e}",
        "\u{f40}",
        "\u{f49}",
        "\u{f7f}",
        "\u{f85}",
        "\u{f88}",
        "\u{fbe}",
        "\u{fc7}",
        "\u{fce}",
        "\u{fd0}",
        "\u{fd5}",
        "\u{fd9}",
        "\u{1000}",
        "\u{102b}",
        "\u{1031}",
        "\u{1038}",
        "\u{103b}",
        "\u{103f}",
        "\u{1040}",
        "\u{104a}",
        "\u{1050}",
        "\u{1056}",
        "\u{105a}",
        "\u{1061}",
        "\u{1062}",
        "\u{1065}",
        "\u{1067}",
        "\u{106e}",
        "\u{1075}",
        "\u{1083}",
        "\u{1087}",
        "\u{108e}",
        "\u{108f}",
        "\u{1090}",
        "\u{109a}",
        "\u{109e}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fb}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1360}",
        "\u{1369}",
        "\u{1380}",
        "\u{1390}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1400}",
        "\u{1401}",
        "\u{166d}",
        "\u{166e}",
        "\u{166f}",
        "\u{1680}",
        "\u{1681}",
        "\u{169b}",
        "\u{169c}",
        "\u{16a0}",
        "\u{16eb}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{1715}",
        "\u{171f}",
        "\u{1734}",
        "\u{1735}",
        "\u{1740}",
        "\u{1760}",
        "\u{176e}",
        "\u{1780}",
        "\u{17b6}",
        "\u{17be}",
        "\u{17c7}",
        "\u{17d4}",
        "\u{17d7}",
        "\u{17d8}",
        "\u{17db}",
        "\u{17dc}",
        "\u{17e0}",
        "\u{17f0}",
        "\u{1800}",
        "\u{1806}",
        "\u{1807}",
        "\u{1810}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1887}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1923}",
        "\u{1929}",
        "\u{1930}",
        "\u{1933}",
        "\u{1940}",
        "\u{1944}",
        "\u{1946}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{19d0}",
        "\u{19da}",
        "\u{19de}",
        "\u{1a00}",
        "\u{1a19}",
        "\u{1a1e}",
        "\u{1a20}",
        "\u{1a55}",
        "\u{1a57}",
        "\u{1a61}",
        "\u{1a63}",
        "\u{1a6d}",
        "\u{1a80}",
        "\u{1a90}",
        "\u{1aa0}",
        "\u{1aa7}",
        "\u{1aa8}",
        "\u{1b04}",
        "\u{1b05}",
        "\u{1b3b}",
        "\u{1b3d}",
        "\u{1b43}",
        "\u{1b45}",
        "\u{1b50}",
        "\u{1b5a}",
        "\u{1b61}",
        "\u{1b74}",
        "\u{1b7d}",
        "\u{1b82}",
        "\u{1b83}",
        "\u{1ba1}",
        "\u{1ba6}",
        "\u{1baa}",
        "\u{1bae}",
        "\u{1bb0}",
        "\u{1bba}",
        "\u{1be7}",
        "\u{1bea}",
        "\u{1bee}",
        "\u{1bf2}",
        "\u{1bfc}",
        "\u{1c00}",
        "\u{1c24}",
        "\u{1c34}",
        "\u{1c3b}",
        "\u{1c40}",
        "\u{1c4d}",
        "\u{1c50}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c7e}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1cc0}",
        "\u{1cd3}",
        "\u{1ce1}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cf7}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbd}",
        "\u{1fbe}",
        "\u{1fbf}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fcd}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fdd}",
        "\u{1fe0}",
        "\u{1fed}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{1ffd}",
        "\u{2000}",
        "\u{2010}",
        "\u{2016}",
        "\u{2018}",
        "\u{2019}",
        "\u{201a}",
        "\u{201b}",
        "\u{201d}",
        "\u{201e}",
        "\u{201f}",
        "\u{2020}",
        "\u{202f}",
        "\u{2030}",
        "\u{2039}",
        "\u{203a}",
        "\u{203b}",
        "\u{203f}",
        "\u{2041}",
        "\u{2044}",
        "\u{2045}",
        "\u{2046}",
        "\u{2047}",
        "\u{2052}",
        "\u{2053}",
        "\u{2054}",
        "\u{2055}",
        "\u{205f}",
        "\u{2070}",
        "\u{2071}",
        "\u{2074}",
        "\u{207a}",
        "\u{207d}",
        "\u{207e}",
        "\u{207f}",
        "\u{2080}",
        "\u{208a}",
        "\u{208d}",
        "\u{208e}",
        "\u{2090}",
        "\u{20a0}",
        "\u{2100}",
        "\u{2102}",
        "\u{2103}",
        "\u{2107}",
        "\u{2108}",
        "\u{210a}",
        "\u{2114}",
        "\u{2115}",
        "\u{2116}",
        "\u{2118}",
        "\u{2119}",
        "\u{211e}",
        "\u{2124}",
        "\u{2125}",
        "\u{2126}",
        "\u{2127}",
        "\u{2128}",
        "\u{2129}",
        "\u{212a}",
        "\u{212e}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213a}",
        "\u{213c}",
        "\u{2140}",
        "\u{2145}",
        "\u{214a}",
        "\u{214b}",
        "\u{214c}",
        "\u{214e}",
        "\u{214f}",
        "\u{2150}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{2189}",
        "\u{218a}",
        "\u{2190}",
        "\u{2195}",
        "\u{219a}",
        "\u{219c}",
        "\u{21a0}",
        "\u{21a1}",
        "\u{21a3}",
        "\u{21a4}",
        "\u{21a6}",
        "\u{21a7}",
        "\u{21ae}",
        "\u{21af}",
        "\u{21ce}",
        "\u{21d0}",
        "\u{21d2}",
        "\u{21d3}",
        "\u{21d4}",
        "\u{21d5}",
        "\u{21f4}",
        "\u{2300}",
        "\u{2308}",
        "\u{2309}",
        "\u{230a}",
        "\u{230b}",
        "\u{230c}",
        "\u{2320}",
        "\u{2322}",
        "\u{2329}",
        "\u{232a}",
        "\u{232b}",
        "\u{237c}",
        "\u{237d}",
        "\u{239b}",
        "\u{23b4}",
        "\u{23dc}",
        "\u{23e2}",
        "\u{2440}",
        "\u{2460}",
        "\u{249c}",
        "\u{24ea}",
        "\u{2500}",
        "\u{25b7}",
        "\u{25b8}",
        "\u{25c1}",
        "\u{25c2}",
        "\u{25f8}",
        "\u{2600}",
        "\u{266f}",
        "\u{2670}",
        "\u{2768}",
        "\u{2769}",
        "\u{276a}",
        "\u{276b}",
        "\u{276c}",
        "\u{276d}",
        "\u{276e}",
        "\u{276f}",
        "\u{2770}",
        "\u{2771}",
        "\u{2772}",
        "\u{2773}",
        "\u{2774}",
        "\u{2775}",
        "\u{2776}",
        "\u{2794}",
        "\u{27c0}",
        "\u{27c5}",
        "\u{27c6}",
        "\u{27c7}",
        "\u{27e6}",
        "\u{27e7}",
        "\u{27e8}",
        "\u{27e9}",
        "\u{27ea}",
        "\u{27eb}",
        "\u{27ec}",
        "\u{27ed}",
        "\u{27ee}",
        "\u{27ef}",
        "\u{27f0}",
        "\u{2800}",
        "\u{2900}",
        "\u{2983}",
        "\u{2984}",
        "\u{2985}",
        "\u{2986}",
        "\u{2987}",
        "\u{2988}",
        "\u{2989}",
        "\u{298a}",
        "\u{298b}",
        "\u{298c}",
        "\u{298d}",
        "\u{298e}",
        "\u{298f}",
        "\u{2990}",
        "\u{2991}",
        "\u{2992}",
        "\u{2993}",
        "\u{2994}",
        "\u{2995}",
        "\u{2996}",
        "\u{2997}",
        "\u{2998}",
        "\u{2999}",
        "\u{29d8}",
        "\u{29d9}",
        "\u{29da}",
        "\u{29db}",
        "\u{29dc}",
        "\u{29fc}",
        "\u{29fd}",
        "\u{29fe}",
        "\u{2b00}",
        "\u{2b30}",
        "\u{2b45}",
        "\u{2b47}",
        "\u{2b4d}",
        "\u{2b76}",
        "\u{2b97}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ce5}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2cf9}",
        "\u{2cfd}",
        "\u{2cfe}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d70}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{2e00}",
        "\u{2e02}",
        "\u{2e03}",
        "\u{2e04}",
        "\u{2e05}",
        "\u{2e06}",
        "\u{2e09}",
        "\u{2e0a}",
        "\u{2e0b}",
        "\u{2e0c}",
        "\u{2e0d}",
        "\u{2e0e}",
        "\u{2e17}",
        "\u{2e18}",
        "\u{2e1a}",
        "\u{2e1b}",
        "\u{2e1c}",
        "\u{2e1d}",
        "\u{2e1e}",
        "\u{2e20}",
        "\u{2e21}",
        "\u{2e22}",
        "\u{2e23}",
        "\u{2e24}",
        "\u{2e25}",
        "\u{2e26}",
        "\u{2e27}",
        "\u{2e28}",
        "\u{2e29}",
        "\u{2e2a}",
        "\u{2e2f}",
        "\u{2e30}",
        "\u{2e3a}",
        "\u{2e3c}",
        "\u{2e40}",
        "\u{2e41}",
        "\u{2e42}",
        "\u{2e43}",
        "\u{2e50}",
        "\u{2e52}",
        "\u{2e55}",
        "\u{2e56}",
        "\u{2e57}",
        "\u{2e58}",
        "\u{2e59}",
        "\u{2e5a}",
        "\u{2e5b}",
        "\u{2e5c}",
        "\u{2e5d}",
        "\u{2e80}",
        "\u{2e9b}",
        "\u{2f00}",
        "\u{2ff0}",
        "\u{3000}",
        "\u{3001}",
        "\u{3004}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3008}",
        "\u{3009}",
        "\u{300a}",
        "\u{300b}",
        "\u{300c}",
        "\u{300d}",
        "\u{300e}",
        "\u{300f}",
        "\u{3010}",
        "\u{3011}",
        "\u{3012}",
        "\u{3014}",
        "\u{3015}",
        "\u{3016}",
        "\u{3017}",
        "\u{3018}",
        "\u{3019}",
        "\u{301a}",
        "\u{301b}",
        "\u{301c}",
        "\u{301d}",
        "\u{301e}",
        "\u{3020}",
        "\u{3021}",
        "\u{3030}",
        "\u{3031}",
        "\u{3036}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{303d}",
        "\u{303e}",
        "\u{3041}",
        "\u{309b}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a0}",
        "\u{30a1}",
        "\u{30fb}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{3190}",
        "\u{3192}",
        "\u{3196}",
        "\u{31a0}",
        "\u{31c0}",
        "\u{31ef}",
        "\u{31f0}",
        "\u{3200}",
        "\u{3220}",
        "\u{322a}",
        "\u{3248}",
        "\u{3250}",
        "\u{3251}",
        "\u{3260}",
        "\u{3280}",
        "\u{328a}",
        "\u{32b1}",
        "\u{32c0}",
        "\u{3400}",
        "\u{4dc0}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a490}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a4fe}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a60d}",
        "\u{a610}",
        "\u{a620}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a673}",
        "\u{a67e}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a6f2}",
        "\u{a700}",
        "\u{a717}",
        "\u{a720}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a789}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80c}",
        "\u{a823}",
        "\u{a827}",
        "\u{a828}",
        "\u{a830}",
        "\u{a836}",
        "\u{a838}",
        "\u{a839}",
        "\u{a840}",
        "\u{a874}",
        "\u{a880}",
        "\u{a882}",
        "\u{a8b4}",
        "\u{a8ce}",
        "\u{a8d0}",
        "\u{a8f2}",
        "\u{a8f8}",
        "\u{a8fb}",
        "\u{a8fc}",
        "\u{a8fd}",
        "\u{a900}",
        "\u{a90a}",
        "\u{a92e}",
        "\u{a930}",
        "\u{a952}",
        "\u{a95f}",
        "\u{a960}",
        "\u{a983}",
        "\u{a984}",
        "\u{a9b4}",
        "\u{a9ba}",
        "\u{a9be}",
        "\u{a9c1}",
        "\u{a9cf}",
        "\u{a9d0}",
        "\u{a9de}",
        "\u{a9e0}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9f0}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa2f}",
        "\u{aa33}",
        "\u{aa40}",
        "\u{aa44}",
        "\u{aa4d}",
        "\u{aa50}",
        "\u{aa5c}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa77}",
        "\u{aa7a}",
        "\u{aa7b}",
        "\u{aa7d}",
        "\u{aa7e}",
        "\u{aab1}",
        "\u{aab5}",
        "\u{aab9}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aade}",
        "\u{aae0}",
        "\u{aaeb}",
        "\u{aaee}",
        "\u{aaf0}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{aaf5}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5b}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab6a}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{abe3}",
        "\u{abe6}",
        "\u{abe9}",
        "\u{abeb}",
        "\u{abec}",
        "\u{abf0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb29}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbb2}",
        "\u{fbd3}",
        "\u{fd3e}",
        "\u{fd3f}",
        "\u{fd40}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdcf}",
        "\u{fdf0}",
        "\u{fdfc}",
        "\u{fdfd}",
        "\u{fe10}",
        "\u{fe17}",
        "\u{fe18}",
        "\u{fe19}",
        "\u{fe30}",
        "\u{fe31}",
        "\u{fe33}",
        "\u{fe35}",
        "\u{fe36}",
        "\u{fe37}",
        "\u{fe38}",
        "\u{fe39}",
        "\u{fe3a}",
        "\u{fe3b}",
        "\u{fe3c}",
        "\u{fe3d}",
        "\u{fe3e}",
        "\u{fe3f}",
        "\u{fe40}",
        "\u{fe41}",
        "\u{fe42}",
        "\u{fe43}",
        "\u{fe44}",
        "\u{fe45}",
        "\u{fe47}",
        "\u{fe48}",
        "\u{fe49}",
        "\u{fe4d}",
        "\u{fe50}",
        "\u{fe54}",
        "\u{fe58}",
        "\u{fe59}",
        "\u{fe5a}",
        "\u{fe5b}",
        "\u{fe5c}",
        "\u{fe5d}",
        "\u{fe5e}",
        "\u{fe5f}",
        "\u{fe62}",
        "\u{fe63}",
        "\u{fe64}",
        "\u{fe68}",
        "\u{fe69}",
        "\u{fe6a}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff01}",
        "\u{ff04}",
        "\u{ff05}",
        "\u{ff08}",
        "\u{ff09}",
        "\u{ff0a}",
        "\u{ff0b}",
        "\u{ff0c}",
        "\u{ff0d}",
        "\u{ff0e}",
        "\u{ff10}",
        "\u{ff1a}",
        "\u{ff1c}",
        "\u{ff1f}",
        "\u{ff21}",
        "\u{ff3b}",
        "\u{ff3c}",
        "\u{ff3d}",
        "\u{ff3e}",
        "\u{ff3f}",
        "\u{ff40}",
        "\u{ff41}",
        "\u{ff5b}",
        "\u{ff5c}",
        "\u{ff5d}",
        "\u{ff5e}",
        "\u{ff5f}",
        "\u{ff60}",
        "\u{ff61}",
        "\u{ff62}",
        "\u{ff63}",
        "\u{ff64}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{ffe0}",
        "\u{ffe2}",
        "\u{ffe3}",
        "\u{ffe4}",
        "\u{ffe5}",
        "\u{ffe8}",
        "\u{ffe9}",
        "\u{ffed}",
        "\u{fffc}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10100}",
        "\u{10107}",
        "\u{10137}",
        "\u{10140}",
        "\u{10175}",
        "\u{10179}",
        "\u{1018a}",
        "\u{1018c}",
        "\u{10190}",
        "\u{101a0}",
        "\u{101d0}",
        "\u{10280}",
        "\u{102a0}",
        "\u{102e1}",
        "\u{10300}",
        "\u{10320}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10380}",
        "\u{1039f}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d0}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104a0}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{1056f}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10857}",
        "\u{10858}",
        "\u{10860}",
        "\u{10877}",
        "\u{10879}",
        "\u{10880}",
        "\u{108a7}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{108fb}",
        "\u{10900}",
        "\u{10916}",
        "\u{1091f}",
        "\u{10920}",
        "\u{1093f}",
        "\u{10980}",
        "\u{109bc}",
        "\u{109be}",
        "\u{109c0}",
        "\u{109d2}",
        "\u{10a00}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a40}",
        "\u{10a50}",
        "\u{10a60}",
        "\u{10a7d}",
        "\u{10a7f}",
        "\u{10a80}",
        "\u{10a9d}",
        "\u{10ac0}",
        "\u{10ac8}",
        "\u{10ac9}",
        "\u{10aeb}",
        "\u{10af0}",
        "\u{10b00}",
        "\u{10b39}",
        "\u{10b40}",
        "\u{10b58}",
        "\u{10b60}",
        "\u{10b78}",
        "\u{10b80}",
        "\u{10b99}",
        "\u{10ba9}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10cfa}",
        "\u{10d00}",
        "\u{10d30}",
        "\u{10e60}",
        "\u{10e80}",
        "\u{10ead}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f1d}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f51}",
        "\u{10f55}",
        "\u{10f70}",
        "\u{10f86}",
        "\u{10fb0}",
        "\u{10fc5}",
        "\u{10fe0}",
        "\u{11000}",
        "\u{11002}",
        "\u{11003}",
        "\u{11047}",
        "\u{11052}",
        "\u{11066}",
        "\u{11071}",
        "\u{11075}",
        "\u{11082}",
        "\u{11083}",
        "\u{110b0}",
        "\u{110b7}",
        "\u{110bb}",
        "\u{110be}",
        "\u{110d0}",
        "\u{110f0}",
        "\u{11103}",
        "\u{1112c}",
        "\u{11136}",
        "\u{11140}",
        "\u{11144}",
        "\u{11145}",
        "\u{11147}",
        "\u{11150}",
        "\u{11174}",
        "\u{11176}",
        "\u{11182}",
        "\u{11183}",
        "\u{111b3}",
        "\u{111bf}",
        "\u{111c1}",
        "\u{111c5}",
        "\u{111cd}",
        "\u{111ce}",
        "\u{111d0}",
        "\u{111da}",
        "\u{111db}",
        "\u{111dc}",
        "\u{111dd}",
        "\u{111e1}",
        "\u{11200}",
        "\u{11213}",
        "\u{1122c}",
        "\u{11232}",
        "\u{11235}",
        "\u{11238}",
        "\u{1123f}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112a9}",
        "\u{112b0}",
        "\u{112e0}",
        "\u{112f0}",
        "\u{11302}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{1133f}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11350}",
        "\u{1135d}",
        "\u{11362}",
        "\u{11400}",
        "\u{11435}",
        "\u{11440}",
        "\u{11445}",
        "\u{11447}",
        "\u{1144b}",
        "\u{11450}",
        "\u{1145a}",
        "\u{1145d}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114b1}",
        "\u{114b9}",
        "\u{114bb}",
        "\u{114be}",
        "\u{114c1}",
        "\u{114c4}",
        "\u{114c6}",
        "\u{114c7}",
        "\u{114d0}",
        "\u{11580}",
        "\u{115b0}",
        "\u{115b8}",
        "\u{115be}",
        "\u{115c1}",
        "\u{115d8}",
        "\u{11600}",
        "\u{11630}",
        "\u{1163b}",
        "\u{1163e}",
        "\u{11641}",
        "\u{11644}",
        "\u{11650}",
        "\u{11660}",
        "\u{11680}",
        "\u{116ac}",
        "\u{116ae}",
        "\u{116b6}",
        "\u{116b8}",
        "\u{116b9}",
        "\u{116c0}",
        "\u{11700}",
        "\u{11720}",
        "\u{11726}",
        "\u{11730}",
        "\u{1173a}",
        "\u{1173c}",
        "\u{1173f}",
        "\u{11740}",
        "\u{11800}",
        "\u{1182c}",
        "\u{11838}",
        "\u{1183b}",
        "\u{118a0}",
        "\u{118e0}",
        "\u{118ea}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{11931}",
        "\u{11937}",
        "\u{1193d}",
        "\u{1193f}",
        "\u{11940}",
        "\u{11941}",
        "\u{11942}",
        "\u{11944}",
        "\u{11950}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119d1}",
        "\u{119dc}",
        "\u{119e1}",
        "\u{119e2}",
        "\u{119e3}",
        "\u{119e4}",
        "\u{11a00}",
        "\u{11a0b}",
        "\u{11a39}",
        "\u{11a3a}",
        "\u{11a3f}",
        "\u{11a50}",
        "\u{11a57}",
        "\u{11a5c}",
        "\u{11a97}",
        "\u{11a9a}",
        "\u{11a9d}",
        "\u{11a9e}",
        "\u{11ab0}",
        "\u{11b00}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c2f}",
        "\u{11c3e}",
        "\u{11c40}",
        "\u{11c41}",
        "\u{11c50}",
        "\u{11c5a}",
        "\u{11c70}",
        "\u{11c72}",
        "\u{11ca9}",
        "\u{11cb1}",
        "\u{11cb4}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d46}",
        "\u{11d50}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d8a}",
        "\u{11d93}",
        "\u{11d96}",
        "\u{11d98}",
        "\u{11da0}",
        "\u{11ee0}",
        "\u{11ef5}",
        "\u{11ef7}",
        "\u{11f02}",
        "\u{11f03}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11f34}",
        "\u{11f3e}",
        "\u{11f41}",
        "\u{11f43}",
        "\u{11f50}",
        "\u{11fb0}",
        "\u{11fc0}",
        "\u{11fd5}",
        "\u{11fdd}",
        "\u{11fe1}",
        "\u{11fff}",
        "\u{12000}",
        "\u{12400}",
        "\u{12470}",
        "\u{12480}",
        "\u{12f90}",
        "\u{12ff1}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a60}",
        "\u{16a6e}",
        "\u{16a70}",
        "\u{16ac0}",
        "\u{16ad0}",
        "\u{16af5}",
        "\u{16b00}",
        "\u{16b37}",
        "\u{16b3c}",
        "\u{16b40}",
        "\u{16b44}",
        "\u{16b45}",
        "\u{16b50}",
        "\u{16b5b}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16e80}",
        "\u{16e97}",
        "\u{16f00}",
        "\u{16f50}",
        "\u{16f51}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe2}",
        "\u{16fe3}",
        "\u{16ff0}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1bc9c}",
        "\u{1bc9f}",
        "\u{1cf50}",
        "\u{1d000}",
        "\u{1d100}",
        "\u{1d129}",
        "\u{1d166}",
        "\u{1d16a}",
        "\u{1d16d}",
        "\u{1d183}",
        "\u{1d18c}",
        "\u{1d1ae}",
        "\u{1d200}",
        "\u{1d245}",
        "\u{1d2c0}",
        "\u{1d2e0}",
        "\u{1d300}",
        "\u{1d360}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c1}",
        "\u{1d6c2}",
        "\u{1d6db}",
        "\u{1d6dc}",
        "\u{1d6fb}",
        "\u{1d6fc}",
        "\u{1d715}",
        "\u{1d716}",
        "\u{1d735}",
        "\u{1d736}",
        "\u{1d74f}",
        "\u{1d750}",
        "\u{1d76f}",
        "\u{1d770}",
        "\u{1d789}",
        "\u{1d78a}",
        "\u{1d7a9}",
        "\u{1d7aa}",
        "\u{1d7c3}",
        "\u{1d7c4}",
        "\u{1d7ce}",
        "\u{1d800}",
        "\u{1da37}",
        "\u{1da6d}",
        "\u{1da76}",
        "\u{1da85}",
        "\u{1da87}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e030}",
        "\u{1e100}",
        "\u{1e137}",
        "\u{1e140}",
        "\u{1e14e}",
        "\u{1e14f}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e2f0}",
        "\u{1e2ff}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e4f0}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e8c7}",
        "\u{1e900}",
        "\u{1e94b}",
        "\u{1e950}",
        "\u{1e95e}",
        "\u{1ec71}",
        "\u{1ecac}",
        "\u{1ecad}",
        "\u{1ecb0}",
        "\u{1ecb1}",
        "\u{1ed01}",
        "\u{1ed2e}",
        "\u{1ed2f}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1eef0}",
        "\u{1f000}",
        "\u{1f030}",
        "\u{1f0a0}",
        "\u{1f0b1}",
        "\u{1f0c1}",
        "\u{1f0d1}",
        "\u{1f100}",
        "\u{1f10d}",
        "\u{1f1e6}",
        "\u{1f210}",
        "\u{1f240}",
        "\u{1f250}",
        "\u{1f260}",
        "\u{1f300}",
        "\u{1f3fb}",
        "\u{1f400}",
        "\u{1f6dc}",
        "\u{1f6f0}",
        "\u{1f700}",
        "\u{1f77b}",
        "\u{1f7e0}",
        "\u{1f7f0}",
        "\u{1f800}",
        "\u{1f810}",
        "\u{1f850}",
        "\u{1f860}",
        "\u{1f890}",
        "\u{1f8b0}",
        "\u{1f900}",
        "\u{1fa60}",
        "\u{1fa70}",
        "\u{1fa80}",
        "\u{1fa90}",
        "\u{1fabf}",
        "\u{1face}",
        "\u{1fae0}",
        "\u{1faf0}",
        "\u{1fb00}",
        "\u{1fb94}",
        "\u{1fbf0}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Grapheme_Base}+$", "^\\p{Gr_Base}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_graphemeextend() {
    test_with_configs(unicode_escape_property_binary_graphemeextend_tc)
}

fn unicode_escape_property_binary_graphemeextend_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 376] = [
        "\u{300}",
        "\u{483}",
        "\u{488}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{610}",
        "\u{64b}",
        "\u{670}",
        "\u{6d6}",
        "\u{6df}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{711}",
        "\u{730}",
        "\u{7a6}",
        "\u{7eb}",
        "\u{7fd}",
        "\u{816}",
        "\u{81b}",
        "\u{825}",
        "\u{829}",
        "\u{859}",
        "\u{898}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{93a}",
        "\u{93c}",
        "\u{941}",
        "\u{94d}",
        "\u{951}",
        "\u{962}",
        "\u{981}",
        "\u{9bc}",
        "\u{9be}",
        "\u{9c1}",
        "\u{9cd}",
        "\u{9d7}",
        "\u{9e2}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a3c}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a70}",
        "\u{a75}",
        "\u{a81}",
        "\u{abc}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{acd}",
        "\u{ae2}",
        "\u{afa}",
        "\u{b01}",
        "\u{b3c}",
        "\u{b3e}",
        "\u{b3f}",
        "\u{b41}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b57}",
        "\u{b62}",
        "\u{b82}",
        "\u{bbe}",
        "\u{bc0}",
        "\u{bcd}",
        "\u{bd7}",
        "\u{c00}",
        "\u{c04}",
        "\u{c3c}",
        "\u{c3e}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c62}",
        "\u{c81}",
        "\u{cbc}",
        "\u{cbf}",
        "\u{cc2}",
        "\u{cc6}",
        "\u{ccc}",
        "\u{cd5}",
        "\u{ce2}",
        "\u{d00}",
        "\u{d3b}",
        "\u{d3e}",
        "\u{d41}",
        "\u{d4d}",
        "\u{d57}",
        "\u{d62}",
        "\u{d81}",
        "\u{dca}",
        "\u{dcf}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{ddf}",
        "\u{e31}",
        "\u{e34}",
        "\u{e47}",
        "\u{eb1}",
        "\u{eb4}",
        "\u{ec8}",
        "\u{f18}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f71}",
        "\u{f80}",
        "\u{f86}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{102d}",
        "\u{1032}",
        "\u{1039}",
        "\u{103d}",
        "\u{1058}",
        "\u{105e}",
        "\u{1071}",
        "\u{1082}",
        "\u{1085}",
        "\u{108d}",
        "\u{109d}",
        "\u{135d}",
        "\u{1712}",
        "\u{1732}",
        "\u{1752}",
        "\u{1772}",
        "\u{17b4}",
        "\u{17b7}",
        "\u{17c6}",
        "\u{17c9}",
        "\u{17dd}",
        "\u{180b}",
        "\u{180f}",
        "\u{1885}",
        "\u{18a9}",
        "\u{1920}",
        "\u{1927}",
        "\u{1932}",
        "\u{1939}",
        "\u{1a17}",
        "\u{1a1b}",
        "\u{1a56}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a62}",
        "\u{1a65}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1ab0}",
        "\u{1abe}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b34}",
        "\u{1b35}",
        "\u{1b36}",
        "\u{1b3c}",
        "\u{1b42}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1ba2}",
        "\u{1ba8}",
        "\u{1bab}",
        "\u{1be6}",
        "\u{1be8}",
        "\u{1bed}",
        "\u{1bef}",
        "\u{1c2c}",
        "\u{1c36}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce2}",
        "\u{1ced}",
        "\u{1cf4}",
        "\u{1cf8}",
        "\u{1dc0}",
        "\u{200c}",
        "\u{20d0}",
        "\u{20dd}",
        "\u{20e1}",
        "\u{20e2}",
        "\u{20e5}",
        "\u{2cef}",
        "\u{2d7f}",
        "\u{2de0}",
        "\u{302a}",
        "\u{302e}",
        "\u{3099}",
        "\u{a66f}",
        "\u{a670}",
        "\u{a674}",
        "\u{a69e}",
        "\u{a6f0}",
        "\u{a802}",
        "\u{a806}",
        "\u{a80b}",
        "\u{a825}",
        "\u{a82c}",
        "\u{a8c4}",
        "\u{a8e0}",
        "\u{a8ff}",
        "\u{a926}",
        "\u{a947}",
        "\u{a980}",
        "\u{a9b3}",
        "\u{a9b6}",
        "\u{a9bc}",
        "\u{a9e5}",
        "\u{aa29}",
        "\u{aa31}",
        "\u{aa35}",
        "\u{aa43}",
        "\u{aa4c}",
        "\u{aa7c}",
        "\u{aab0}",
        "\u{aab2}",
        "\u{aab7}",
        "\u{aabe}",
        "\u{aac1}",
        "\u{aaec}",
        "\u{aaf6}",
        "\u{abe5}",
        "\u{abe8}",
        "\u{abed}",
        "\u{fb1e}",
        "\u{fe00}",
        "\u{fe20}",
        "\u{ff9e}",
        "\u{101fd}",
        "\u{102e0}",
        "\u{10376}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10ae5}",
        "\u{10d24}",
        "\u{10eab}",
        "\u{10efd}",
        "\u{10f46}",
        "\u{10f82}",
        "\u{11001}",
        "\u{11038}",
        "\u{11070}",
        "\u{11073}",
        "\u{1107f}",
        "\u{110b3}",
        "\u{110b9}",
        "\u{110c2}",
        "\u{11100}",
        "\u{11127}",
        "\u{1112d}",
        "\u{11173}",
        "\u{11180}",
        "\u{111b6}",
        "\u{111c9}",
        "\u{111cf}",
        "\u{1122f}",
        "\u{11234}",
        "\u{11236}",
        "\u{1123e}",
        "\u{11241}",
        "\u{112df}",
        "\u{112e3}",
        "\u{11300}",
        "\u{1133b}",
        "\u{1133e}",
        "\u{11340}",
        "\u{11357}",
        "\u{11366}",
        "\u{11370}",
        "\u{11438}",
        "\u{11442}",
        "\u{11446}",
        "\u{1145e}",
        "\u{114b0}",
        "\u{114b3}",
        "\u{114ba}",
        "\u{114bd}",
        "\u{114bf}",
        "\u{114c2}",
        "\u{115af}",
        "\u{115b2}",
        "\u{115bc}",
        "\u{115bf}",
        "\u{115dc}",
        "\u{11633}",
        "\u{1163d}",
        "\u{1163f}",
        "\u{116ab}",
        "\u{116ad}",
        "\u{116b0}",
        "\u{116b7}",
        "\u{1171d}",
        "\u{11722}",
        "\u{11727}",
        "\u{1182f}",
        "\u{11839}",
        "\u{11930}",
        "\u{1193b}",
        "\u{1193e}",
        "\u{11943}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119e0}",
        "\u{11a01}",
        "\u{11a33}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a51}",
        "\u{11a59}",
        "\u{11a8a}",
        "\u{11a98}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3f}",
        "\u{11c92}",
        "\u{11caa}",
        "\u{11cb2}",
        "\u{11cb5}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d47}",
        "\u{11d90}",
        "\u{11d95}",
        "\u{11d97}",
        "\u{11ef3}",
        "\u{11f00}",
        "\u{11f36}",
        "\u{11f40}",
        "\u{11f42}",
        "\u{13440}",
        "\u{13447}",
        "\u{16af0}",
        "\u{16b30}",
        "\u{16f4f}",
        "\u{16f8f}",
        "\u{16fe4}",
        "\u{1bc9d}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d165}",
        "\u{1d167}",
        "\u{1d16e}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e08f}",
        "\u{1e130}",
        "\u{1e2ae}",
        "\u{1e2ec}",
        "\u{1e4ec}",
        "\u{1e8d0}",
        "\u{1e944}",
        "\u{e0020}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Grapheme_Extend}+$", "^\\p{Gr_Ext}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_idcontinue() {
    test_with_configs(unicode_escape_property_binary_idcontinue_tc)
}

fn unicode_escape_property_binary_idcontinue_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1344] = [
        "\u{30}",
        "\u{41}",
        "\u{5f}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{b7}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{300}",
        "\u{370}",
        "\u{374}",
        "\u{376}",
        "\u{37a}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{387}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{483}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{560}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{610}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{64b}",
        "\u{660}",
        "\u{66e}",
        "\u{670}",
        "\u{671}",
        "\u{6d5}",
        "\u{6d6}",
        "\u{6df}",
        "\u{6e5}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{6ee}",
        "\u{6f0}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{711}",
        "\u{712}",
        "\u{730}",
        "\u{74d}",
        "\u{7a6}",
        "\u{7b1}",
        "\u{7c0}",
        "\u{7ca}",
        "\u{7eb}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{7fd}",
        "\u{800}",
        "\u{816}",
        "\u{81a}",
        "\u{81b}",
        "\u{824}",
        "\u{825}",
        "\u{828}",
        "\u{829}",
        "\u{840}",
        "\u{859}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{898}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{903}",
        "\u{904}",
        "\u{93a}",
        "\u{93b}",
        "\u{93c}",
        "\u{93d}",
        "\u{93e}",
        "\u{941}",
        "\u{949}",
        "\u{94d}",
        "\u{94e}",
        "\u{950}",
        "\u{951}",
        "\u{958}",
        "\u{962}",
        "\u{966}",
        "\u{971}",
        "\u{972}",
        "\u{981}",
        "\u{982}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bc}",
        "\u{9bd}",
        "\u{9be}",
        "\u{9c1}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9cd}",
        "\u{9ce}",
        "\u{9d7}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9e2}",
        "\u{9e6}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a03}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a3c}",
        "\u{a3e}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a66}",
        "\u{a70}",
        "\u{a72}",
        "\u{a75}",
        "\u{a81}",
        "\u{a83}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abc}",
        "\u{abd}",
        "\u{abe}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{ac9}",
        "\u{acb}",
        "\u{acd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{ae2}",
        "\u{ae6}",
        "\u{af9}",
        "\u{afa}",
        "\u{b01}",
        "\u{b02}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3c}",
        "\u{b3d}",
        "\u{b3e}",
        "\u{b3f}",
        "\u{b40}",
        "\u{b41}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b57}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b62}",
        "\u{b66}",
        "\u{b71}",
        "\u{b82}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bbe}",
        "\u{bc0}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bcd}",
        "\u{bd0}",
        "\u{bd7}",
        "\u{be6}",
        "\u{c00}",
        "\u{c01}",
        "\u{c04}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3c}",
        "\u{c3d}",
        "\u{c3e}",
        "\u{c41}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c62}",
        "\u{c66}",
        "\u{c80}",
        "\u{c81}",
        "\u{c82}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbc}",
        "\u{cbd}",
        "\u{cbe}",
        "\u{cbf}",
        "\u{cc0}",
        "\u{cc6}",
        "\u{cc7}",
        "\u{cca}",
        "\u{ccc}",
        "\u{cd5}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{ce2}",
        "\u{ce6}",
        "\u{cf1}",
        "\u{cf3}",
        "\u{d00}",
        "\u{d02}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3b}",
        "\u{d3d}",
        "\u{d3e}",
        "\u{d41}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d4d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d57}",
        "\u{d5f}",
        "\u{d62}",
        "\u{d66}",
        "\u{d7a}",
        "\u{d81}",
        "\u{d82}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{dca}",
        "\u{dcf}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{dd8}",
        "\u{de6}",
        "\u{df2}",
        "\u{e01}",
        "\u{e31}",
        "\u{e32}",
        "\u{e34}",
        "\u{e40}",
        "\u{e46}",
        "\u{e47}",
        "\u{e50}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb1}",
        "\u{eb2}",
        "\u{eb4}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{ec8}",
        "\u{ed0}",
        "\u{edc}",
        "\u{f00}",
        "\u{f18}",
        "\u{f20}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f3e}",
        "\u{f40}",
        "\u{f49}",
        "\u{f71}",
        "\u{f7f}",
        "\u{f80}",
        "\u{f86}",
        "\u{f88}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{1000}",
        "\u{102b}",
        "\u{102d}",
        "\u{1031}",
        "\u{1032}",
        "\u{1038}",
        "\u{1039}",
        "\u{103b}",
        "\u{103d}",
        "\u{103f}",
        "\u{1040}",
        "\u{1050}",
        "\u{1056}",
        "\u{1058}",
        "\u{105a}",
        "\u{105e}",
        "\u{1061}",
        "\u{1062}",
        "\u{1065}",
        "\u{1067}",
        "\u{106e}",
        "\u{1071}",
        "\u{1075}",
        "\u{1082}",
        "\u{1083}",
        "\u{1085}",
        "\u{1087}",
        "\u{108d}",
        "\u{108e}",
        "\u{108f}",
        "\u{1090}",
        "\u{109a}",
        "\u{109d}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{135d}",
        "\u{1369}",
        "\u{1380}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{1712}",
        "\u{1715}",
        "\u{171f}",
        "\u{1732}",
        "\u{1734}",
        "\u{1740}",
        "\u{1752}",
        "\u{1760}",
        "\u{176e}",
        "\u{1772}",
        "\u{1780}",
        "\u{17b4}",
        "\u{17b6}",
        "\u{17b7}",
        "\u{17be}",
        "\u{17c6}",
        "\u{17c7}",
        "\u{17c9}",
        "\u{17d7}",
        "\u{17dc}",
        "\u{17dd}",
        "\u{17e0}",
        "\u{180b}",
        "\u{180f}",
        "\u{1810}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1885}",
        "\u{1887}",
        "\u{18a9}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1920}",
        "\u{1923}",
        "\u{1927}",
        "\u{1929}",
        "\u{1930}",
        "\u{1932}",
        "\u{1933}",
        "\u{1939}",
        "\u{1946}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{19d0}",
        "\u{19da}",
        "\u{1a00}",
        "\u{1a17}",
        "\u{1a19}",
        "\u{1a1b}",
        "\u{1a20}",
        "\u{1a55}",
        "\u{1a56}",
        "\u{1a57}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a61}",
        "\u{1a62}",
        "\u{1a63}",
        "\u{1a65}",
        "\u{1a6d}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1a80}",
        "\u{1a90}",
        "\u{1aa7}",
        "\u{1ab0}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b04}",
        "\u{1b05}",
        "\u{1b34}",
        "\u{1b35}",
        "\u{1b36}",
        "\u{1b3b}",
        "\u{1b3c}",
        "\u{1b3d}",
        "\u{1b42}",
        "\u{1b43}",
        "\u{1b45}",
        "\u{1b50}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1b82}",
        "\u{1b83}",
        "\u{1ba1}",
        "\u{1ba2}",
        "\u{1ba6}",
        "\u{1ba8}",
        "\u{1baa}",
        "\u{1bab}",
        "\u{1bae}",
        "\u{1bb0}",
        "\u{1bba}",
        "\u{1be6}",
        "\u{1be7}",
        "\u{1be8}",
        "\u{1bea}",
        "\u{1bed}",
        "\u{1bee}",
        "\u{1bef}",
        "\u{1bf2}",
        "\u{1c00}",
        "\u{1c24}",
        "\u{1c2c}",
        "\u{1c34}",
        "\u{1c36}",
        "\u{1c40}",
        "\u{1c4d}",
        "\u{1c50}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce1}",
        "\u{1ce2}",
        "\u{1ce9}",
        "\u{1ced}",
        "\u{1cee}",
        "\u{1cf4}",
        "\u{1cf5}",
        "\u{1cf7}",
        "\u{1cf8}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1dc0}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{200c}",
        "\u{203f}",
        "\u{2054}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{20d0}",
        "\u{20e1}",
        "\u{20e5}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2118}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212e}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cef}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d7f}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{2de0}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{302a}",
        "\u{302e}",
        "\u{3031}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{3041}",
        "\u{3099}",
        "\u{309b}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30fb}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a610}",
        "\u{a620}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a66f}",
        "\u{a674}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a69e}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a6f0}",
        "\u{a717}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a802}",
        "\u{a803}",
        "\u{a806}",
        "\u{a807}",
        "\u{a80b}",
        "\u{a80c}",
        "\u{a823}",
        "\u{a825}",
        "\u{a827}",
        "\u{a82c}",
        "\u{a840}",
        "\u{a880}",
        "\u{a882}",
        "\u{a8b4}",
        "\u{a8c4}",
        "\u{a8d0}",
        "\u{a8e0}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a8ff}",
        "\u{a900}",
        "\u{a90a}",
        "\u{a926}",
        "\u{a930}",
        "\u{a947}",
        "\u{a952}",
        "\u{a960}",
        "\u{a980}",
        "\u{a983}",
        "\u{a984}",
        "\u{a9b3}",
        "\u{a9b4}",
        "\u{a9b6}",
        "\u{a9ba}",
        "\u{a9bc}",
        "\u{a9be}",
        "\u{a9cf}",
        "\u{a9d0}",
        "\u{a9e0}",
        "\u{a9e5}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9f0}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa29}",
        "\u{aa2f}",
        "\u{aa31}",
        "\u{aa33}",
        "\u{aa35}",
        "\u{aa40}",
        "\u{aa43}",
        "\u{aa44}",
        "\u{aa4c}",
        "\u{aa4d}",
        "\u{aa50}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7b}",
        "\u{aa7c}",
        "\u{aa7d}",
        "\u{aa7e}",
        "\u{aab0}",
        "\u{aab1}",
        "\u{aab2}",
        "\u{aab5}",
        "\u{aab7}",
        "\u{aab9}",
        "\u{aabe}",
        "\u{aac0}",
        "\u{aac1}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aae0}",
        "\u{aaeb}",
        "\u{aaec}",
        "\u{aaee}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{aaf5}",
        "\u{aaf6}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{abe3}",
        "\u{abe5}",
        "\u{abe6}",
        "\u{abe8}",
        "\u{abe9}",
        "\u{abec}",
        "\u{abed}",
        "\u{abf0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1e}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe00}",
        "\u{fe20}",
        "\u{fe33}",
        "\u{fe4d}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff10}",
        "\u{ff21}",
        "\u{ff3f}",
        "\u{ff41}",
        "\u{ff65}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ff9e}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10140}",
        "\u{101fd}",
        "\u{10280}",
        "\u{102a0}",
        "\u{102e0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10376}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104a0}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10ae5}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10d00}",
        "\u{10d24}",
        "\u{10d30}",
        "\u{10e80}",
        "\u{10eab}",
        "\u{10eb0}",
        "\u{10efd}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f46}",
        "\u{10f70}",
        "\u{10f82}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11000}",
        "\u{11001}",
        "\u{11002}",
        "\u{11003}",
        "\u{11038}",
        "\u{11066}",
        "\u{11070}",
        "\u{11071}",
        "\u{11073}",
        "\u{11075}",
        "\u{1107f}",
        "\u{11082}",
        "\u{11083}",
        "\u{110b0}",
        "\u{110b3}",
        "\u{110b7}",
        "\u{110b9}",
        "\u{110c2}",
        "\u{110d0}",
        "\u{110f0}",
        "\u{11100}",
        "\u{11103}",
        "\u{11127}",
        "\u{1112c}",
        "\u{1112d}",
        "\u{11136}",
        "\u{11144}",
        "\u{11145}",
        "\u{11147}",
        "\u{11150}",
        "\u{11173}",
        "\u{11176}",
        "\u{11180}",
        "\u{11182}",
        "\u{11183}",
        "\u{111b3}",
        "\u{111b6}",
        "\u{111bf}",
        "\u{111c1}",
        "\u{111c9}",
        "\u{111ce}",
        "\u{111cf}",
        "\u{111d0}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1122c}",
        "\u{1122f}",
        "\u{11232}",
        "\u{11234}",
        "\u{11235}",
        "\u{11236}",
        "\u{1123e}",
        "\u{1123f}",
        "\u{11241}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{112df}",
        "\u{112e0}",
        "\u{112e3}",
        "\u{112f0}",
        "\u{11300}",
        "\u{11302}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133b}",
        "\u{1133d}",
        "\u{1133e}",
        "\u{11340}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11350}",
        "\u{11357}",
        "\u{1135d}",
        "\u{11362}",
        "\u{11366}",
        "\u{11370}",
        "\u{11400}",
        "\u{11435}",
        "\u{11438}",
        "\u{11440}",
        "\u{11442}",
        "\u{11445}",
        "\u{11446}",
        "\u{11447}",
        "\u{11450}",
        "\u{1145e}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114b0}",
        "\u{114b3}",
        "\u{114b9}",
        "\u{114ba}",
        "\u{114bb}",
        "\u{114bf}",
        "\u{114c1}",
        "\u{114c2}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{114d0}",
        "\u{11580}",
        "\u{115af}",
        "\u{115b2}",
        "\u{115b8}",
        "\u{115bc}",
        "\u{115be}",
        "\u{115bf}",
        "\u{115d8}",
        "\u{115dc}",
        "\u{11600}",
        "\u{11630}",
        "\u{11633}",
        "\u{1163b}",
        "\u{1163d}",
        "\u{1163e}",
        "\u{1163f}",
        "\u{11644}",
        "\u{11650}",
        "\u{11680}",
        "\u{116ab}",
        "\u{116ac}",
        "\u{116ad}",
        "\u{116ae}",
        "\u{116b0}",
        "\u{116b6}",
        "\u{116b7}",
        "\u{116b8}",
        "\u{116c0}",
        "\u{11700}",
        "\u{1171d}",
        "\u{11720}",
        "\u{11722}",
        "\u{11726}",
        "\u{11727}",
        "\u{11730}",
        "\u{11740}",
        "\u{11800}",
        "\u{1182c}",
        "\u{1182f}",
        "\u{11838}",
        "\u{11839}",
        "\u{118a0}",
        "\u{118e0}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{11930}",
        "\u{11937}",
        "\u{1193b}",
        "\u{1193d}",
        "\u{1193e}",
        "\u{1193f}",
        "\u{11940}",
        "\u{11941}",
        "\u{11942}",
        "\u{11943}",
        "\u{11950}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119d1}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119dc}",
        "\u{119e0}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{119e4}",
        "\u{11a00}",
        "\u{11a01}",
        "\u{11a0b}",
        "\u{11a33}",
        "\u{11a39}",
        "\u{11a3a}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a50}",
        "\u{11a51}",
        "\u{11a57}",
        "\u{11a59}",
        "\u{11a5c}",
        "\u{11a8a}",
        "\u{11a97}",
        "\u{11a98}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c2f}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3e}",
        "\u{11c3f}",
        "\u{11c40}",
        "\u{11c50}",
        "\u{11c72}",
        "\u{11c92}",
        "\u{11ca9}",
        "\u{11caa}",
        "\u{11cb1}",
        "\u{11cb2}",
        "\u{11cb4}",
        "\u{11cb5}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d46}",
        "\u{11d47}",
        "\u{11d50}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d8a}",
        "\u{11d90}",
        "\u{11d93}",
        "\u{11d95}",
        "\u{11d96}",
        "\u{11d97}",
        "\u{11d98}",
        "\u{11da0}",
        "\u{11ee0}",
        "\u{11ef3}",
        "\u{11ef5}",
        "\u{11f00}",
        "\u{11f02}",
        "\u{11f03}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11f34}",
        "\u{11f36}",
        "\u{11f3e}",
        "\u{11f40}",
        "\u{11f41}",
        "\u{11f42}",
        "\u{11f50}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12400}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13440}",
        "\u{13441}",
        "\u{13447}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a60}",
        "\u{16a70}",
        "\u{16ac0}",
        "\u{16ad0}",
        "\u{16af0}",
        "\u{16b00}",
        "\u{16b30}",
        "\u{16b40}",
        "\u{16b50}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16f00}",
        "\u{16f4f}",
        "\u{16f50}",
        "\u{16f51}",
        "\u{16f8f}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{16fe4}",
        "\u{16ff0}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1bc9d}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d165}",
        "\u{1d167}",
        "\u{1d16d}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7ce}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e030}",
        "\u{1e08f}",
        "\u{1e100}",
        "\u{1e130}",
        "\u{1e137}",
        "\u{1e140}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2ae}",
        "\u{1e2c0}",
        "\u{1e2ec}",
        "\u{1e2f0}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e4ec}",
        "\u{1e4f0}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e8d0}",
        "\u{1e900}",
        "\u{1e944}",
        "\u{1e94b}",
        "\u{1e950}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1fbf0}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{ID_Continue}+$", "^\\p{IDC}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_idstart() {
    test_with_configs(unicode_escape_property_binary_idstart_tc)
}

fn unicode_escape_property_binary_idstart_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 740] = [
        "\u{41}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{370}",
        "\u{374}",
        "\u{376}",
        "\u{37a}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{560}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{66e}",
        "\u{671}",
        "\u{6d5}",
        "\u{6e5}",
        "\u{6ee}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{712}",
        "\u{74d}",
        "\u{7b1}",
        "\u{7ca}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{800}",
        "\u{81a}",
        "\u{824}",
        "\u{828}",
        "\u{840}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{904}",
        "\u{93d}",
        "\u{950}",
        "\u{958}",
        "\u{971}",
        "\u{972}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9ce}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a72}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{af9}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b71}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bd0}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c80}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{cf1}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d5f}",
        "\u{d7a}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{e01}",
        "\u{e32}",
        "\u{e40}",
        "\u{e46}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb2}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{edc}",
        "\u{f00}",
        "\u{f40}",
        "\u{f49}",
        "\u{f88}",
        "\u{1000}",
        "\u{103f}",
        "\u{1050}",
        "\u{105a}",
        "\u{1061}",
        "\u{1065}",
        "\u{106e}",
        "\u{1075}",
        "\u{108e}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1380}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{171f}",
        "\u{1740}",
        "\u{1760}",
        "\u{176e}",
        "\u{1780}",
        "\u{17d7}",
        "\u{17dc}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1885}",
        "\u{1887}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{1a00}",
        "\u{1a20}",
        "\u{1aa7}",
        "\u{1b05}",
        "\u{1b45}",
        "\u{1b83}",
        "\u{1bae}",
        "\u{1bba}",
        "\u{1c00}",
        "\u{1c4d}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2118}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212e}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{3031}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{3041}",
        "\u{309b}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a610}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a717}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80c}",
        "\u{a840}",
        "\u{a882}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a90a}",
        "\u{a930}",
        "\u{a960}",
        "\u{a984}",
        "\u{a9cf}",
        "\u{a9e0}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa40}",
        "\u{aa44}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7e}",
        "\u{aab1}",
        "\u{aab5}",
        "\u{aab9}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aae0}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff21}",
        "\u{ff41}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ff9e}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10140}",
        "\u{10280}",
        "\u{102a0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10d00}",
        "\u{10e80}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f70}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11003}",
        "\u{11071}",
        "\u{11075}",
        "\u{11083}",
        "\u{110d0}",
        "\u{11103}",
        "\u{11144}",
        "\u{11147}",
        "\u{11150}",
        "\u{11176}",
        "\u{11183}",
        "\u{111c1}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1123f}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{11350}",
        "\u{1135d}",
        "\u{11400}",
        "\u{11447}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{11580}",
        "\u{115d8}",
        "\u{11600}",
        "\u{11644}",
        "\u{11680}",
        "\u{116b8}",
        "\u{11700}",
        "\u{11740}",
        "\u{11800}",
        "\u{118a0}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{1193f}",
        "\u{11941}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{11a00}",
        "\u{11a0b}",
        "\u{11a3a}",
        "\u{11a50}",
        "\u{11a5c}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c40}",
        "\u{11c72}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d46}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d98}",
        "\u{11ee0}",
        "\u{11f02}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12400}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a70}",
        "\u{16ad0}",
        "\u{16b00}",
        "\u{16b40}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16f00}",
        "\u{16f50}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e030}",
        "\u{1e100}",
        "\u{1e137}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e900}",
        "\u{1e94b}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{ID_Start}+$", "^\\p{IDS}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_math() {
    test_with_configs(unicode_escape_property_binary_math_tc)
}

fn unicode_escape_property_binary_math_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 240] = [
        "\u{2b}",
        "\u{3c}",
        "\u{5e}",
        "\u{7c}",
        "\u{7e}",
        "\u{ac}",
        "\u{b1}",
        "\u{d7}",
        "\u{f7}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3f0}",
        "\u{3f4}",
        "\u{3f6}",
        "\u{606}",
        "\u{2016}",
        "\u{2032}",
        "\u{2040}",
        "\u{2044}",
        "\u{2052}",
        "\u{2061}",
        "\u{207a}",
        "\u{207d}",
        "\u{207e}",
        "\u{208a}",
        "\u{208d}",
        "\u{208e}",
        "\u{20d0}",
        "\u{20e1}",
        "\u{20e5}",
        "\u{20eb}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2118}",
        "\u{2119}",
        "\u{2124}",
        "\u{2128}",
        "\u{2129}",
        "\u{212c}",
        "\u{212f}",
        "\u{2133}",
        "\u{2135}",
        "\u{213c}",
        "\u{2140}",
        "\u{2145}",
        "\u{214b}",
        "\u{2190}",
        "\u{2195}",
        "\u{219a}",
        "\u{219c}",
        "\u{21a0}",
        "\u{21a1}",
        "\u{21a3}",
        "\u{21a4}",
        "\u{21a6}",
        "\u{21a7}",
        "\u{21a9}",
        "\u{21ae}",
        "\u{21b0}",
        "\u{21b6}",
        "\u{21bc}",
        "\u{21ce}",
        "\u{21d0}",
        "\u{21d2}",
        "\u{21d3}",
        "\u{21d4}",
        "\u{21d5}",
        "\u{21dd}",
        "\u{21e4}",
        "\u{21f4}",
        "\u{2308}",
        "\u{2309}",
        "\u{230a}",
        "\u{230b}",
        "\u{2320}",
        "\u{237c}",
        "\u{239b}",
        "\u{23b4}",
        "\u{23b7}",
        "\u{23d0}",
        "\u{23dc}",
        "\u{23e2}",
        "\u{25a0}",
        "\u{25ae}",
        "\u{25b7}",
        "\u{25bc}",
        "\u{25c1}",
        "\u{25c6}",
        "\u{25ca}",
        "\u{25cf}",
        "\u{25e2}",
        "\u{25e4}",
        "\u{25e7}",
        "\u{25f8}",
        "\u{2605}",
        "\u{2640}",
        "\u{2642}",
        "\u{2660}",
        "\u{266d}",
        "\u{266f}",
        "\u{27c0}",
        "\u{27c5}",
        "\u{27c6}",
        "\u{27c7}",
        "\u{27e6}",
        "\u{27e7}",
        "\u{27e8}",
        "\u{27e9}",
        "\u{27ea}",
        "\u{27eb}",
        "\u{27ec}",
        "\u{27ed}",
        "\u{27ee}",
        "\u{27ef}",
        "\u{27f0}",
        "\u{2900}",
        "\u{2983}",
        "\u{2984}",
        "\u{2985}",
        "\u{2986}",
        "\u{2987}",
        "\u{2988}",
        "\u{2989}",
        "\u{298a}",
        "\u{298b}",
        "\u{298c}",
        "\u{298d}",
        "\u{298e}",
        "\u{298f}",
        "\u{2990}",
        "\u{2991}",
        "\u{2992}",
        "\u{2993}",
        "\u{2994}",
        "\u{2995}",
        "\u{2996}",
        "\u{2997}",
        "\u{2998}",
        "\u{2999}",
        "\u{29d8}",
        "\u{29d9}",
        "\u{29da}",
        "\u{29db}",
        "\u{29dc}",
        "\u{29fc}",
        "\u{29fd}",
        "\u{29fe}",
        "\u{2b30}",
        "\u{2b47}",
        "\u{fb29}",
        "\u{fe61}",
        "\u{fe62}",
        "\u{fe63}",
        "\u{fe64}",
        "\u{fe68}",
        "\u{ff0b}",
        "\u{ff1c}",
        "\u{ff3c}",
        "\u{ff3e}",
        "\u{ff5c}",
        "\u{ff5e}",
        "\u{ffe2}",
        "\u{ffe9}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c1}",
        "\u{1d6c2}",
        "\u{1d6db}",
        "\u{1d6dc}",
        "\u{1d6fb}",
        "\u{1d6fc}",
        "\u{1d715}",
        "\u{1d716}",
        "\u{1d735}",
        "\u{1d736}",
        "\u{1d74f}",
        "\u{1d750}",
        "\u{1d76f}",
        "\u{1d770}",
        "\u{1d789}",
        "\u{1d78a}",
        "\u{1d7a9}",
        "\u{1d7aa}",
        "\u{1d7c3}",
        "\u{1d7c4}",
        "\u{1d7ce}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1eef0}",
    ];
    const REGEXES: [&str; 1] = ["^\\p{Math}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_xidcontinue() {
    test_with_configs(unicode_escape_property_binary_xidcontinue_tc)
}

fn unicode_escape_property_binary_xidcontinue_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1348] = [
        "\u{30}",
        "\u{41}",
        "\u{5f}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{b7}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{300}",
        "\u{370}",
        "\u{374}",
        "\u{376}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{387}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{483}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{560}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{610}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{64b}",
        "\u{660}",
        "\u{66e}",
        "\u{670}",
        "\u{671}",
        "\u{6d5}",
        "\u{6d6}",
        "\u{6df}",
        "\u{6e5}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{6ee}",
        "\u{6f0}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{711}",
        "\u{712}",
        "\u{730}",
        "\u{74d}",
        "\u{7a6}",
        "\u{7b1}",
        "\u{7c0}",
        "\u{7ca}",
        "\u{7eb}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{7fd}",
        "\u{800}",
        "\u{816}",
        "\u{81a}",
        "\u{81b}",
        "\u{824}",
        "\u{825}",
        "\u{828}",
        "\u{829}",
        "\u{840}",
        "\u{859}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{898}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{903}",
        "\u{904}",
        "\u{93a}",
        "\u{93b}",
        "\u{93c}",
        "\u{93d}",
        "\u{93e}",
        "\u{941}",
        "\u{949}",
        "\u{94d}",
        "\u{94e}",
        "\u{950}",
        "\u{951}",
        "\u{958}",
        "\u{962}",
        "\u{966}",
        "\u{971}",
        "\u{972}",
        "\u{981}",
        "\u{982}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bc}",
        "\u{9bd}",
        "\u{9be}",
        "\u{9c1}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9cd}",
        "\u{9ce}",
        "\u{9d7}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9e2}",
        "\u{9e6}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a03}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a3c}",
        "\u{a3e}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a66}",
        "\u{a70}",
        "\u{a72}",
        "\u{a75}",
        "\u{a81}",
        "\u{a83}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abc}",
        "\u{abd}",
        "\u{abe}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{ac9}",
        "\u{acb}",
        "\u{acd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{ae2}",
        "\u{ae6}",
        "\u{af9}",
        "\u{afa}",
        "\u{b01}",
        "\u{b02}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3c}",
        "\u{b3d}",
        "\u{b3e}",
        "\u{b3f}",
        "\u{b40}",
        "\u{b41}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b57}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b62}",
        "\u{b66}",
        "\u{b71}",
        "\u{b82}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bbe}",
        "\u{bc0}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bcd}",
        "\u{bd0}",
        "\u{bd7}",
        "\u{be6}",
        "\u{c00}",
        "\u{c01}",
        "\u{c04}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3c}",
        "\u{c3d}",
        "\u{c3e}",
        "\u{c41}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c62}",
        "\u{c66}",
        "\u{c80}",
        "\u{c81}",
        "\u{c82}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbc}",
        "\u{cbd}",
        "\u{cbe}",
        "\u{cbf}",
        "\u{cc0}",
        "\u{cc6}",
        "\u{cc7}",
        "\u{cca}",
        "\u{ccc}",
        "\u{cd5}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{ce2}",
        "\u{ce6}",
        "\u{cf1}",
        "\u{cf3}",
        "\u{d00}",
        "\u{d02}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3b}",
        "\u{d3d}",
        "\u{d3e}",
        "\u{d41}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d4d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d57}",
        "\u{d5f}",
        "\u{d62}",
        "\u{d66}",
        "\u{d7a}",
        "\u{d81}",
        "\u{d82}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{dca}",
        "\u{dcf}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{dd8}",
        "\u{de6}",
        "\u{df2}",
        "\u{e01}",
        "\u{e31}",
        "\u{e32}",
        "\u{e34}",
        "\u{e40}",
        "\u{e46}",
        "\u{e47}",
        "\u{e50}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb1}",
        "\u{eb2}",
        "\u{eb4}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{ec8}",
        "\u{ed0}",
        "\u{edc}",
        "\u{f00}",
        "\u{f18}",
        "\u{f20}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f3e}",
        "\u{f40}",
        "\u{f49}",
        "\u{f71}",
        "\u{f7f}",
        "\u{f80}",
        "\u{f86}",
        "\u{f88}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{1000}",
        "\u{102b}",
        "\u{102d}",
        "\u{1031}",
        "\u{1032}",
        "\u{1038}",
        "\u{1039}",
        "\u{103b}",
        "\u{103d}",
        "\u{103f}",
        "\u{1040}",
        "\u{1050}",
        "\u{1056}",
        "\u{1058}",
        "\u{105a}",
        "\u{105e}",
        "\u{1061}",
        "\u{1062}",
        "\u{1065}",
        "\u{1067}",
        "\u{106e}",
        "\u{1071}",
        "\u{1075}",
        "\u{1082}",
        "\u{1083}",
        "\u{1085}",
        "\u{1087}",
        "\u{108d}",
        "\u{108e}",
        "\u{108f}",
        "\u{1090}",
        "\u{109a}",
        "\u{109d}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{135d}",
        "\u{1369}",
        "\u{1380}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{1712}",
        "\u{1715}",
        "\u{171f}",
        "\u{1732}",
        "\u{1734}",
        "\u{1740}",
        "\u{1752}",
        "\u{1760}",
        "\u{176e}",
        "\u{1772}",
        "\u{1780}",
        "\u{17b4}",
        "\u{17b6}",
        "\u{17b7}",
        "\u{17be}",
        "\u{17c6}",
        "\u{17c7}",
        "\u{17c9}",
        "\u{17d7}",
        "\u{17dc}",
        "\u{17dd}",
        "\u{17e0}",
        "\u{180b}",
        "\u{180f}",
        "\u{1810}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1885}",
        "\u{1887}",
        "\u{18a9}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1920}",
        "\u{1923}",
        "\u{1927}",
        "\u{1929}",
        "\u{1930}",
        "\u{1932}",
        "\u{1933}",
        "\u{1939}",
        "\u{1946}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{19d0}",
        "\u{19da}",
        "\u{1a00}",
        "\u{1a17}",
        "\u{1a19}",
        "\u{1a1b}",
        "\u{1a20}",
        "\u{1a55}",
        "\u{1a56}",
        "\u{1a57}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a61}",
        "\u{1a62}",
        "\u{1a63}",
        "\u{1a65}",
        "\u{1a6d}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1a80}",
        "\u{1a90}",
        "\u{1aa7}",
        "\u{1ab0}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b04}",
        "\u{1b05}",
        "\u{1b34}",
        "\u{1b35}",
        "\u{1b36}",
        "\u{1b3b}",
        "\u{1b3c}",
        "\u{1b3d}",
        "\u{1b42}",
        "\u{1b43}",
        "\u{1b45}",
        "\u{1b50}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1b82}",
        "\u{1b83}",
        "\u{1ba1}",
        "\u{1ba2}",
        "\u{1ba6}",
        "\u{1ba8}",
        "\u{1baa}",
        "\u{1bab}",
        "\u{1bae}",
        "\u{1bb0}",
        "\u{1bba}",
        "\u{1be6}",
        "\u{1be7}",
        "\u{1be8}",
        "\u{1bea}",
        "\u{1bed}",
        "\u{1bee}",
        "\u{1bef}",
        "\u{1bf2}",
        "\u{1c00}",
        "\u{1c24}",
        "\u{1c2c}",
        "\u{1c34}",
        "\u{1c36}",
        "\u{1c40}",
        "\u{1c4d}",
        "\u{1c50}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce1}",
        "\u{1ce2}",
        "\u{1ce9}",
        "\u{1ced}",
        "\u{1cee}",
        "\u{1cf4}",
        "\u{1cf5}",
        "\u{1cf7}",
        "\u{1cf8}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1dc0}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{200c}",
        "\u{203f}",
        "\u{2054}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{20d0}",
        "\u{20e1}",
        "\u{20e5}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2118}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212e}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cef}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d7f}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{2de0}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{302a}",
        "\u{302e}",
        "\u{3031}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{3041}",
        "\u{3099}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30fb}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a610}",
        "\u{a620}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a66f}",
        "\u{a674}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a69e}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a6f0}",
        "\u{a717}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a802}",
        "\u{a803}",
        "\u{a806}",
        "\u{a807}",
        "\u{a80b}",
        "\u{a80c}",
        "\u{a823}",
        "\u{a825}",
        "\u{a827}",
        "\u{a82c}",
        "\u{a840}",
        "\u{a880}",
        "\u{a882}",
        "\u{a8b4}",
        "\u{a8c4}",
        "\u{a8d0}",
        "\u{a8e0}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a8ff}",
        "\u{a900}",
        "\u{a90a}",
        "\u{a926}",
        "\u{a930}",
        "\u{a947}",
        "\u{a952}",
        "\u{a960}",
        "\u{a980}",
        "\u{a983}",
        "\u{a984}",
        "\u{a9b3}",
        "\u{a9b4}",
        "\u{a9b6}",
        "\u{a9ba}",
        "\u{a9bc}",
        "\u{a9be}",
        "\u{a9cf}",
        "\u{a9d0}",
        "\u{a9e0}",
        "\u{a9e5}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9f0}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa29}",
        "\u{aa2f}",
        "\u{aa31}",
        "\u{aa33}",
        "\u{aa35}",
        "\u{aa40}",
        "\u{aa43}",
        "\u{aa44}",
        "\u{aa4c}",
        "\u{aa4d}",
        "\u{aa50}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7b}",
        "\u{aa7c}",
        "\u{aa7d}",
        "\u{aa7e}",
        "\u{aab0}",
        "\u{aab1}",
        "\u{aab2}",
        "\u{aab5}",
        "\u{aab7}",
        "\u{aab9}",
        "\u{aabe}",
        "\u{aac0}",
        "\u{aac1}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aae0}",
        "\u{aaeb}",
        "\u{aaec}",
        "\u{aaee}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{aaf5}",
        "\u{aaf6}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{abe3}",
        "\u{abe5}",
        "\u{abe6}",
        "\u{abe8}",
        "\u{abe9}",
        "\u{abec}",
        "\u{abed}",
        "\u{abf0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1e}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fc64}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe00}",
        "\u{fe20}",
        "\u{fe33}",
        "\u{fe4d}",
        "\u{fe71}",
        "\u{fe73}",
        "\u{fe77}",
        "\u{fe79}",
        "\u{fe7b}",
        "\u{fe7d}",
        "\u{fe7f}",
        "\u{ff10}",
        "\u{ff21}",
        "\u{ff3f}",
        "\u{ff41}",
        "\u{ff65}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ff9e}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10140}",
        "\u{101fd}",
        "\u{10280}",
        "\u{102a0}",
        "\u{102e0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10376}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104a0}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10ae5}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10d00}",
        "\u{10d24}",
        "\u{10d30}",
        "\u{10e80}",
        "\u{10eab}",
        "\u{10eb0}",
        "\u{10efd}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f46}",
        "\u{10f70}",
        "\u{10f82}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11000}",
        "\u{11001}",
        "\u{11002}",
        "\u{11003}",
        "\u{11038}",
        "\u{11066}",
        "\u{11070}",
        "\u{11071}",
        "\u{11073}",
        "\u{11075}",
        "\u{1107f}",
        "\u{11082}",
        "\u{11083}",
        "\u{110b0}",
        "\u{110b3}",
        "\u{110b7}",
        "\u{110b9}",
        "\u{110c2}",
        "\u{110d0}",
        "\u{110f0}",
        "\u{11100}",
        "\u{11103}",
        "\u{11127}",
        "\u{1112c}",
        "\u{1112d}",
        "\u{11136}",
        "\u{11144}",
        "\u{11145}",
        "\u{11147}",
        "\u{11150}",
        "\u{11173}",
        "\u{11176}",
        "\u{11180}",
        "\u{11182}",
        "\u{11183}",
        "\u{111b3}",
        "\u{111b6}",
        "\u{111bf}",
        "\u{111c1}",
        "\u{111c9}",
        "\u{111ce}",
        "\u{111cf}",
        "\u{111d0}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1122c}",
        "\u{1122f}",
        "\u{11232}",
        "\u{11234}",
        "\u{11235}",
        "\u{11236}",
        "\u{1123e}",
        "\u{1123f}",
        "\u{11241}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{112df}",
        "\u{112e0}",
        "\u{112e3}",
        "\u{112f0}",
        "\u{11300}",
        "\u{11302}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133b}",
        "\u{1133d}",
        "\u{1133e}",
        "\u{11340}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11350}",
        "\u{11357}",
        "\u{1135d}",
        "\u{11362}",
        "\u{11366}",
        "\u{11370}",
        "\u{11400}",
        "\u{11435}",
        "\u{11438}",
        "\u{11440}",
        "\u{11442}",
        "\u{11445}",
        "\u{11446}",
        "\u{11447}",
        "\u{11450}",
        "\u{1145e}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114b0}",
        "\u{114b3}",
        "\u{114b9}",
        "\u{114ba}",
        "\u{114bb}",
        "\u{114bf}",
        "\u{114c1}",
        "\u{114c2}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{114d0}",
        "\u{11580}",
        "\u{115af}",
        "\u{115b2}",
        "\u{115b8}",
        "\u{115bc}",
        "\u{115be}",
        "\u{115bf}",
        "\u{115d8}",
        "\u{115dc}",
        "\u{11600}",
        "\u{11630}",
        "\u{11633}",
        "\u{1163b}",
        "\u{1163d}",
        "\u{1163e}",
        "\u{1163f}",
        "\u{11644}",
        "\u{11650}",
        "\u{11680}",
        "\u{116ab}",
        "\u{116ac}",
        "\u{116ad}",
        "\u{116ae}",
        "\u{116b0}",
        "\u{116b6}",
        "\u{116b7}",
        "\u{116b8}",
        "\u{116c0}",
        "\u{11700}",
        "\u{1171d}",
        "\u{11720}",
        "\u{11722}",
        "\u{11726}",
        "\u{11727}",
        "\u{11730}",
        "\u{11740}",
        "\u{11800}",
        "\u{1182c}",
        "\u{1182f}",
        "\u{11838}",
        "\u{11839}",
        "\u{118a0}",
        "\u{118e0}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{11930}",
        "\u{11937}",
        "\u{1193b}",
        "\u{1193d}",
        "\u{1193e}",
        "\u{1193f}",
        "\u{11940}",
        "\u{11941}",
        "\u{11942}",
        "\u{11943}",
        "\u{11950}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119d1}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119dc}",
        "\u{119e0}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{119e4}",
        "\u{11a00}",
        "\u{11a01}",
        "\u{11a0b}",
        "\u{11a33}",
        "\u{11a39}",
        "\u{11a3a}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a50}",
        "\u{11a51}",
        "\u{11a57}",
        "\u{11a59}",
        "\u{11a5c}",
        "\u{11a8a}",
        "\u{11a97}",
        "\u{11a98}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c2f}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3e}",
        "\u{11c3f}",
        "\u{11c40}",
        "\u{11c50}",
        "\u{11c72}",
        "\u{11c92}",
        "\u{11ca9}",
        "\u{11caa}",
        "\u{11cb1}",
        "\u{11cb2}",
        "\u{11cb4}",
        "\u{11cb5}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d46}",
        "\u{11d47}",
        "\u{11d50}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d8a}",
        "\u{11d90}",
        "\u{11d93}",
        "\u{11d95}",
        "\u{11d96}",
        "\u{11d97}",
        "\u{11d98}",
        "\u{11da0}",
        "\u{11ee0}",
        "\u{11ef3}",
        "\u{11ef5}",
        "\u{11f00}",
        "\u{11f02}",
        "\u{11f03}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11f34}",
        "\u{11f36}",
        "\u{11f3e}",
        "\u{11f40}",
        "\u{11f41}",
        "\u{11f42}",
        "\u{11f50}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12400}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13440}",
        "\u{13441}",
        "\u{13447}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a60}",
        "\u{16a70}",
        "\u{16ac0}",
        "\u{16ad0}",
        "\u{16af0}",
        "\u{16b00}",
        "\u{16b30}",
        "\u{16b40}",
        "\u{16b50}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16f00}",
        "\u{16f4f}",
        "\u{16f50}",
        "\u{16f51}",
        "\u{16f8f}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{16fe4}",
        "\u{16ff0}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1bc9d}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d165}",
        "\u{1d167}",
        "\u{1d16d}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7ce}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e030}",
        "\u{1e08f}",
        "\u{1e100}",
        "\u{1e130}",
        "\u{1e137}",
        "\u{1e140}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2ae}",
        "\u{1e2c0}",
        "\u{1e2ec}",
        "\u{1e2f0}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e4ec}",
        "\u{1e4f0}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e8d0}",
        "\u{1e900}",
        "\u{1e944}",
        "\u{1e94b}",
        "\u{1e950}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1fbf0}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{XID_Continue}+$", "^\\p{XIDC}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_xidstart() {
    test_with_configs(unicode_escape_property_binary_xidstart_tc)
}

fn unicode_escape_property_binary_xidstart_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 743] = [
        "\u{41}",
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{ba}",
        "\u{c0}",
        "\u{d8}",
        "\u{f8}",
        "\u{1bb}",
        "\u{1bc}",
        "\u{1c0}",
        "\u{1c4}",
        "\u{294}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{370}",
        "\u{374}",
        "\u{376}",
        "\u{37b}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{3a3}",
        "\u{3f7}",
        "\u{48a}",
        "\u{531}",
        "\u{559}",
        "\u{560}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{620}",
        "\u{640}",
        "\u{641}",
        "\u{66e}",
        "\u{671}",
        "\u{6d5}",
        "\u{6e5}",
        "\u{6ee}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{712}",
        "\u{74d}",
        "\u{7b1}",
        "\u{7ca}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{800}",
        "\u{81a}",
        "\u{824}",
        "\u{828}",
        "\u{840}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{8a0}",
        "\u{8c9}",
        "\u{904}",
        "\u{93d}",
        "\u{950}",
        "\u{958}",
        "\u{971}",
        "\u{972}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9ce}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a72}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{af9}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b71}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bd0}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c80}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{cf1}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d5f}",
        "\u{d7a}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{e01}",
        "\u{e32}",
        "\u{e40}",
        "\u{e46}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb2}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{ec6}",
        "\u{edc}",
        "\u{f00}",
        "\u{f40}",
        "\u{f49}",
        "\u{f88}",
        "\u{1000}",
        "\u{103f}",
        "\u{1050}",
        "\u{105a}",
        "\u{1061}",
        "\u{1065}",
        "\u{106e}",
        "\u{1075}",
        "\u{108e}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1380}",
        "\u{13a0}",
        "\u{13f8}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16ee}",
        "\u{16f1}",
        "\u{1700}",
        "\u{171f}",
        "\u{1740}",
        "\u{1760}",
        "\u{176e}",
        "\u{1780}",
        "\u{17d7}",
        "\u{17dc}",
        "\u{1820}",
        "\u{1843}",
        "\u{1844}",
        "\u{1880}",
        "\u{1885}",
        "\u{1887}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{1a00}",
        "\u{1a20}",
        "\u{1aa7}",
        "\u{1b05}",
        "\u{1b45}",
        "\u{1b83}",
        "\u{1bae}",
        "\u{1bba}",
        "\u{1c00}",
        "\u{1c4d}",
        "\u{1c5a}",
        "\u{1c78}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cfa}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1e00}",
        "\u{1f18}",
        "\u{1f20}",
        "\u{1f48}",
        "\u{1f50}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f80}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2102}",
        "\u{2107}",
        "\u{210a}",
        "\u{2115}",
        "\u{2118}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212e}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213c}",
        "\u{2145}",
        "\u{214e}",
        "\u{2160}",
        "\u{2183}",
        "\u{2185}",
        "\u{2c00}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2ceb}",
        "\u{2cf2}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{2d30}",
        "\u{2d6f}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{3005}",
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{3031}",
        "\u{3038}",
        "\u{303b}",
        "\u{303c}",
        "\u{3041}",
        "\u{309d}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30fc}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a015}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a4f8}",
        "\u{a500}",
        "\u{a60c}",
        "\u{a610}",
        "\u{a62a}",
        "\u{a640}",
        "\u{a66e}",
        "\u{a67f}",
        "\u{a680}",
        "\u{a69c}",
        "\u{a6a0}",
        "\u{a6e6}",
        "\u{a717}",
        "\u{a722}",
        "\u{a770}",
        "\u{a771}",
        "\u{a788}",
        "\u{a78b}",
        "\u{a78f}",
        "\u{a790}",
        "\u{a7d0}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f7}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{a7fb}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80c}",
        "\u{a840}",
        "\u{a882}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a90a}",
        "\u{a930}",
        "\u{a960}",
        "\u{a984}",
        "\u{a9cf}",
        "\u{a9e0}",
        "\u{a9e6}",
        "\u{a9e7}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa40}",
        "\u{aa44}",
        "\u{aa60}",
        "\u{aa70}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7e}",
        "\u{aab1}",
        "\u{aab5}",
        "\u{aab9}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aadd}",
        "\u{aae0}",
        "\u{aaf2}",
        "\u{aaf3}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{abc0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fc64}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe71}",
        "\u{fe73}",
        "\u{fe77}",
        "\u{fe79}",
        "\u{fe7b}",
        "\u{fe7d}",
        "\u{fe7f}",
        "\u{ff21}",
        "\u{ff41}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10140}",
        "\u{10280}",
        "\u{102a0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10341}",
        "\u{10342}",
        "\u{1034a}",
        "\u{10350}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{103d1}",
        "\u{10400}",
        "\u{10450}",
        "\u{104b0}",
        "\u{104d8}",
        "\u{10500}",
        "\u{10530}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10c80}",
        "\u{10cc0}",
        "\u{10d00}",
        "\u{10e80}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f70}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11003}",
        "\u{11071}",
        "\u{11075}",
        "\u{11083}",
        "\u{110d0}",
        "\u{11103}",
        "\u{11144}",
        "\u{11147}",
        "\u{11150}",
        "\u{11176}",
        "\u{11183}",
        "\u{111c1}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1123f}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{11350}",
        "\u{1135d}",
        "\u{11400}",
        "\u{11447}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{11580}",
        "\u{115d8}",
        "\u{11600}",
        "\u{11644}",
        "\u{11680}",
        "\u{116b8}",
        "\u{11700}",
        "\u{11740}",
        "\u{11800}",
        "\u{118a0}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{1193f}",
        "\u{11941}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{11a00}",
        "\u{11a0b}",
        "\u{11a3a}",
        "\u{11a50}",
        "\u{11a5c}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c40}",
        "\u{11c72}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d46}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d98}",
        "\u{11ee0}",
        "\u{11f02}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12400}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a70}",
        "\u{16ad0}",
        "\u{16b00}",
        "\u{16b40}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16e40}",
        "\u{16f00}",
        "\u{16f50}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1df00}",
        "\u{1df0a}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e030}",
        "\u{1e100}",
        "\u{1e137}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e4d0}",
        "\u{1e4eb}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1e900}",
        "\u{1e94b}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{XID_Start}+$", "^\\p{XIDS}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_asciihexdigit() {
    test_with_configs(unicode_escape_property_binary_asciihexdigit_tc)
}

fn unicode_escape_property_binary_asciihexdigit_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 3] = ["\u{30}", "\u{41}", "\u{61}"];
    const REGEXES: [&str; 2] = ["^\\p{ASCII_Hex_Digit}+$", "^\\p{AHex}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_bidicontrol() {
    test_with_configs(unicode_escape_property_binary_bidicontrol_tc)
}

fn unicode_escape_property_binary_bidicontrol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 4] = ["\u{61c}", "\u{200e}", "\u{202a}", "\u{2066}"];
    const REGEXES: [&str; 2] = ["^\\p{Bidi_Control}+$", "^\\p{Bidi_C}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_dash() {
    test_with_configs(unicode_escape_property_binary_dash_tc)
}

fn unicode_escape_property_binary_dash_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 23] = [
        "\u{2d}",
        "\u{58a}",
        "\u{5be}",
        "\u{1400}",
        "\u{1806}",
        "\u{2010}",
        "\u{2053}",
        "\u{207b}",
        "\u{208b}",
        "\u{2212}",
        "\u{2e17}",
        "\u{2e1a}",
        "\u{2e3a}",
        "\u{2e40}",
        "\u{2e5d}",
        "\u{301c}",
        "\u{3030}",
        "\u{30a0}",
        "\u{fe31}",
        "\u{fe58}",
        "\u{fe63}",
        "\u{ff0d}",
        "\u{10ead}",
    ];
    const REGEXES: [&str; 1] = ["^\\p{Dash}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_deprecated() {
    test_with_configs(unicode_escape_property_binary_deprecated_tc)
}

fn unicode_escape_property_binary_deprecated_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 9] = [
        "\u{149}",
        "\u{673}",
        "\u{f77}",
        "\u{f79}",
        "\u{17a3}",
        "\u{206a}",
        "\u{2329}",
        "\u{232a}",
        "\u{e0001}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Deprecated}+$", "^\\p{Dep}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_diacritic() {
    test_with_configs(unicode_escape_property_binary_diacritic_tc)
}

fn unicode_escape_property_binary_diacritic_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 237] = [
        "\u{5e}",
        "\u{60}",
        "\u{a8}",
        "\u{af}",
        "\u{b4}",
        "\u{b7}",
        "\u{b8}",
        "\u{2b0}",
        "\u{2c2}",
        "\u{2c6}",
        "\u{2d2}",
        "\u{2e0}",
        "\u{2e5}",
        "\u{2ec}",
        "\u{2ed}",
        "\u{2ee}",
        "\u{2ef}",
        "\u{300}",
        "\u{350}",
        "\u{35d}",
        "\u{374}",
        "\u{375}",
        "\u{37a}",
        "\u{384}",
        "\u{483}",
        "\u{559}",
        "\u{591}",
        "\u{5a3}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{64b}",
        "\u{657}",
        "\u{6df}",
        "\u{6e5}",
        "\u{6ea}",
        "\u{730}",
        "\u{7a6}",
        "\u{7eb}",
        "\u{7f4}",
        "\u{818}",
        "\u{898}",
        "\u{8c9}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{93c}",
        "\u{94d}",
        "\u{951}",
        "\u{971}",
        "\u{9bc}",
        "\u{9cd}",
        "\u{a3c}",
        "\u{a4d}",
        "\u{abc}",
        "\u{acd}",
        "\u{afd}",
        "\u{b3c}",
        "\u{b4d}",
        "\u{b55}",
        "\u{bcd}",
        "\u{c3c}",
        "\u{c4d}",
        "\u{cbc}",
        "\u{ccd}",
        "\u{d3b}",
        "\u{d4d}",
        "\u{dca}",
        "\u{e47}",
        "\u{e4e}",
        "\u{eba}",
        "\u{ec8}",
        "\u{f18}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f3e}",
        "\u{f82}",
        "\u{f86}",
        "\u{fc6}",
        "\u{1037}",
        "\u{1039}",
        "\u{1063}",
        "\u{1069}",
        "\u{1087}",
        "\u{108d}",
        "\u{108f}",
        "\u{109a}",
        "\u{135d}",
        "\u{1714}",
        "\u{1715}",
        "\u{17c9}",
        "\u{17dd}",
        "\u{1939}",
        "\u{1a75}",
        "\u{1a7f}",
        "\u{1ab0}",
        "\u{1abe}",
        "\u{1ac1}",
        "\u{1b34}",
        "\u{1b44}",
        "\u{1b6b}",
        "\u{1baa}",
        "\u{1bab}",
        "\u{1c36}",
        "\u{1c78}",
        "\u{1cd0}",
        "\u{1cd3}",
        "\u{1cd4}",
        "\u{1ce1}",
        "\u{1ce2}",
        "\u{1ced}",
        "\u{1cf4}",
        "\u{1cf7}",
        "\u{1cf8}",
        "\u{1d2c}",
        "\u{1dc4}",
        "\u{1df5}",
        "\u{1fbd}",
        "\u{1fbf}",
        "\u{1fcd}",
        "\u{1fdd}",
        "\u{1fed}",
        "\u{1ffd}",
        "\u{2cef}",
        "\u{2e2f}",
        "\u{302a}",
        "\u{302e}",
        "\u{3099}",
        "\u{309b}",
        "\u{30fc}",
        "\u{a66f}",
        "\u{a67c}",
        "\u{a67f}",
        "\u{a69c}",
        "\u{a6f0}",
        "\u{a700}",
        "\u{a717}",
        "\u{a720}",
        "\u{a788}",
        "\u{a789}",
        "\u{a7f8}",
        "\u{a8c4}",
        "\u{a8e0}",
        "\u{a92b}",
        "\u{a92e}",
        "\u{a953}",
        "\u{a9b3}",
        "\u{a9c0}",
        "\u{a9e5}",
        "\u{aa7b}",
        "\u{aa7c}",
        "\u{aa7d}",
        "\u{aabf}",
        "\u{aac0}",
        "\u{aac1}",
        "\u{aac2}",
        "\u{aaf6}",
        "\u{ab5b}",
        "\u{ab5c}",
        "\u{ab69}",
        "\u{ab6a}",
        "\u{abec}",
        "\u{abed}",
        "\u{fb1e}",
        "\u{fe20}",
        "\u{ff3e}",
        "\u{ff40}",
        "\u{ff70}",
        "\u{ff9e}",
        "\u{ffe3}",
        "\u{102e0}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10ae5}",
        "\u{10d22}",
        "\u{10d24}",
        "\u{10efd}",
        "\u{10f46}",
        "\u{10f82}",
        "\u{11046}",
        "\u{11070}",
        "\u{110b9}",
        "\u{11133}",
        "\u{11173}",
        "\u{111c0}",
        "\u{111ca}",
        "\u{11235}",
        "\u{11236}",
        "\u{112e9}",
        "\u{1133c}",
        "\u{1134d}",
        "\u{11366}",
        "\u{11370}",
        "\u{11442}",
        "\u{11446}",
        "\u{114c2}",
        "\u{115bf}",
        "\u{1163f}",
        "\u{116b6}",
        "\u{116b7}",
        "\u{1172b}",
        "\u{11839}",
        "\u{1193d}",
        "\u{1193e}",
        "\u{11943}",
        "\u{119e0}",
        "\u{11a34}",
        "\u{11a47}",
        "\u{11a99}",
        "\u{11c3f}",
        "\u{11d42}",
        "\u{11d44}",
        "\u{11d97}",
        "\u{13447}",
        "\u{16af0}",
        "\u{16b30}",
        "\u{16f8f}",
        "\u{16f93}",
        "\u{16ff0}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d167}",
        "\u{1d16d}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1e030}",
        "\u{1e130}",
        "\u{1e2ae}",
        "\u{1e2ec}",
        "\u{1e8d0}",
        "\u{1e944}",
        "\u{1e948}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Diacritic}+$", "^\\p{Dia}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_extender() {
    test_with_configs(unicode_escape_property_binary_extender_tc)
}

fn unicode_escape_property_binary_extender_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 33] = [
        "\u{b7}",
        "\u{2d0}",
        "\u{640}",
        "\u{7fa}",
        "\u{b55}",
        "\u{e46}",
        "\u{ec6}",
        "\u{180a}",
        "\u{1843}",
        "\u{1aa7}",
        "\u{1c36}",
        "\u{1c7b}",
        "\u{3005}",
        "\u{3031}",
        "\u{309d}",
        "\u{30fc}",
        "\u{a015}",
        "\u{a60c}",
        "\u{a9cf}",
        "\u{a9e6}",
        "\u{aa70}",
        "\u{aadd}",
        "\u{aaf3}",
        "\u{ff70}",
        "\u{10781}",
        "\u{1135d}",
        "\u{115c6}",
        "\u{11a98}",
        "\u{16b42}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{1e13c}",
        "\u{1e944}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Extender}+$", "^\\p{Ext}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_hexdigit() {
    test_with_configs(unicode_escape_property_binary_hexdigit_tc)
}

fn unicode_escape_property_binary_hexdigit_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 6] = [
        "\u{30}", "\u{41}", "\u{61}", "\u{ff10}", "\u{ff21}", "\u{ff41}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Hex_Digit}+$", "^\\p{Hex}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_idsbinaryoperator() {
    test_with_configs(unicode_escape_property_binary_idsbinaryoperator_tc)
}

fn unicode_escape_property_binary_idsbinaryoperator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 3] = ["\u{2ff0}", "\u{2ff4}", "\u{31ef}"];
    const REGEXES: [&str; 2] = ["^\\p{IDS_Binary_Operator}+$", "^\\p{IDSB}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_idstrinaryoperator() {
    test_with_configs(unicode_escape_property_binary_idstrinaryoperator_tc)
}

fn unicode_escape_property_binary_idstrinaryoperator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{2ff2}"];
    const REGEXES: [&str; 2] = ["^\\p{IDS_Trinary_Operator}+$", "^\\p{IDST}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_ideographic() {
    test_with_configs(unicode_escape_property_binary_ideographic_tc)
}

fn unicode_escape_property_binary_ideographic_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 22] = [
        "\u{3006}",
        "\u{3007}",
        "\u{3021}",
        "\u{3038}",
        "\u{3400}",
        "\u{4e00}",
        "\u{f900}",
        "\u{fa70}",
        "\u{16fe4}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1b170}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Ideographic}+$", "^\\p{Ideo}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_joincontrol() {
    test_with_configs(unicode_escape_property_binary_joincontrol_tc)
}

fn unicode_escape_property_binary_joincontrol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{200c}"];
    const REGEXES: [&str; 2] = ["^\\p{Join_Control}+$", "^\\p{Join_C}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_logicalorderexception() {
    test_with_configs(unicode_escape_property_binary_logicalorderexception_tc)
}

fn unicode_escape_property_binary_logicalorderexception_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 7] = [
        "\u{e40}", "\u{ec0}", "\u{19b5}", "\u{19ba}", "\u{aab5}", "\u{aab9}", "\u{aabb}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Logical_Order_Exception}+$", "^\\p{LOE}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_lowercase() {
    test_with_configs(unicode_escape_property_binary_lowercase_tc)
}

fn unicode_escape_property_binary_lowercase_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 686] = [
        "\u{61}",
        "\u{aa}",
        "\u{b5}",
        "\u{ba}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1aa}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1c6}",
        "\u{1c9}",
        "\u{1cc}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f3}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{221}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{295}",
        "\u{2b0}",
        "\u{2c0}",
        "\u{2e0}",
        "\u{345}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37a}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{560}",
        "\u{10d0}",
        "\u{10fc}",
        "\u{10fd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d00}",
        "\u{1d2c}",
        "\u{1d6b}",
        "\u{1d78}",
        "\u{1d79}",
        "\u{1d9b}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1e9f}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1f90}",
        "\u{1fa0}",
        "\u{1fb0}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{210a}",
        "\u{210e}",
        "\u{2113}",
        "\u{212f}",
        "\u{2134}",
        "\u{2139}",
        "\u{213c}",
        "\u{2146}",
        "\u{214e}",
        "\u{2170}",
        "\u{2184}",
        "\u{24d0}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c71}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c7c}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a69c}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a770}",
        "\u{a771}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a78e}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7af}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f2}",
        "\u{a7f6}",
        "\u{a7f8}",
        "\u{a7fa}",
        "\u{ab30}",
        "\u{ab5c}",
        "\u{ab60}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10780}",
        "\u{10783}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1d41a}",
        "\u{1d44e}",
        "\u{1d456}",
        "\u{1d482}",
        "\u{1d4b6}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d4ea}",
        "\u{1d51e}",
        "\u{1d552}",
        "\u{1d586}",
        "\u{1d5ba}",
        "\u{1d5ee}",
        "\u{1d622}",
        "\u{1d656}",
        "\u{1d68a}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7cb}",
        "\u{1df00}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e030}",
        "\u{1e922}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Lowercase}+$", "^\\p{Lower}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_noncharactercodepoint() {
    test_with_configs(unicode_escape_property_binary_noncharactercodepoint_tc)
}

fn unicode_escape_property_binary_noncharactercodepoint_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 18] = [
        "\u{fdd0}",
        "\u{fffe}",
        "\u{1fffe}",
        "\u{2fffe}",
        "\u{3fffe}",
        "\u{4fffe}",
        "\u{5fffe}",
        "\u{6fffe}",
        "\u{7fffe}",
        "\u{8fffe}",
        "\u{9fffe}",
        "\u{afffe}",
        "\u{bfffe}",
        "\u{cfffe}",
        "\u{dfffe}",
        "\u{efffe}",
        "\u{ffffe}",
        "\u{10fffe}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Noncharacter_Code_Point}+$", "^\\p{NChar}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_patternsyntax() {
    test_with_configs(unicode_escape_property_binary_patternsyntax_tc)
}

fn unicode_escape_property_binary_patternsyntax_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 257] = [
        "\u{21}", "\u{24}", "\u{25}", "\u{28}", "\u{29}", "\u{2a}", "\u{2b}", "\u{2c}", "\u{2d}",
        "\u{2e}", "\u{3a}", "\u{3c}", "\u{3f}", "\u{5b}", "\u{5c}", "\u{5d}", "\u{5e}", "\u{60}",
        "\u{7b}", "\u{7c}", "\u{7d}", "\u{7e}", "\u{a1}", "\u{a2}", "\u{a6}", "\u{a7}", "\u{a9}",
        "\u{ab}", "\u{ac}", "\u{ae}", "\u{b0}", "\u{b1}", "\u{b6}", "\u{bb}", "\u{bf}", "\u{d7}",
        "\u{f7}", "\u{2010}", "\u{2016}", "\u{2018}", "\u{2019}", "\u{201a}", "\u{201b}",
        "\u{201d}", "\u{201e}", "\u{201f}", "\u{2020}", "\u{2030}", "\u{2039}", "\u{203a}",
        "\u{203b}", "\u{2041}", "\u{2044}", "\u{2045}", "\u{2046}", "\u{2047}", "\u{2052}",
        "\u{2053}", "\u{2055}", "\u{2190}", "\u{2195}", "\u{219a}", "\u{219c}", "\u{21a0}",
        "\u{21a1}", "\u{21a3}", "\u{21a4}", "\u{21a6}", "\u{21a7}", "\u{21ae}", "\u{21af}",
        "\u{21ce}", "\u{21d0}", "\u{21d2}", "\u{21d3}", "\u{21d4}", "\u{21d5}", "\u{21f4}",
        "\u{2300}", "\u{2308}", "\u{2309}", "\u{230a}", "\u{230b}", "\u{230c}", "\u{2320}",
        "\u{2322}", "\u{2329}", "\u{232a}", "\u{232b}", "\u{237c}", "\u{237d}", "\u{239b}",
        "\u{23b4}", "\u{23dc}", "\u{23e2}", "\u{2427}", "\u{2440}", "\u{244b}", "\u{2500}",
        "\u{25b7}", "\u{25b8}", "\u{25c1}", "\u{25c2}", "\u{25f8}", "\u{2600}", "\u{266f}",
        "\u{2670}", "\u{2768}", "\u{2769}", "\u{276a}", "\u{276b}", "\u{276c}", "\u{276d}",
        "\u{276e}", "\u{276f}", "\u{2770}", "\u{2771}", "\u{2772}", "\u{2773}", "\u{2774}",
        "\u{2775}", "\u{2794}", "\u{27c0}", "\u{27c5}", "\u{27c6}", "\u{27c7}", "\u{27e6}",
        "\u{27e7}", "\u{27e8}", "\u{27e9}", "\u{27ea}", "\u{27eb}", "\u{27ec}", "\u{27ed}",
        "\u{27ee}", "\u{27ef}", "\u{27f0}", "\u{2800}", "\u{2900}", "\u{2983}", "\u{2984}",
        "\u{2985}", "\u{2986}", "\u{2987}", "\u{2988}", "\u{2989}", "\u{298a}", "\u{298b}",
        "\u{298c}", "\u{298d}", "\u{298e}", "\u{298f}", "\u{2990}", "\u{2991}", "\u{2992}",
        "\u{2993}", "\u{2994}", "\u{2995}", "\u{2996}", "\u{2997}", "\u{2998}", "\u{2999}",
        "\u{29d8}", "\u{29d9}", "\u{29da}", "\u{29db}", "\u{29dc}", "\u{29fc}", "\u{29fd}",
        "\u{29fe}", "\u{2b00}", "\u{2b30}", "\u{2b45}", "\u{2b47}", "\u{2b4d}", "\u{2b74}",
        "\u{2b76}", "\u{2b96}", "\u{2b97}", "\u{2e00}", "\u{2e02}", "\u{2e03}", "\u{2e04}",
        "\u{2e05}", "\u{2e06}", "\u{2e09}", "\u{2e0a}", "\u{2e0b}", "\u{2e0c}", "\u{2e0d}",
        "\u{2e0e}", "\u{2e17}", "\u{2e18}", "\u{2e1a}", "\u{2e1b}", "\u{2e1c}", "\u{2e1d}",
        "\u{2e1e}", "\u{2e20}", "\u{2e21}", "\u{2e22}", "\u{2e23}", "\u{2e24}", "\u{2e25}",
        "\u{2e26}", "\u{2e27}", "\u{2e28}", "\u{2e29}", "\u{2e2a}", "\u{2e2f}", "\u{2e30}",
        "\u{2e3a}", "\u{2e3c}", "\u{2e40}", "\u{2e41}", "\u{2e42}", "\u{2e43}", "\u{2e50}",
        "\u{2e52}", "\u{2e55}", "\u{2e56}", "\u{2e57}", "\u{2e58}", "\u{2e59}", "\u{2e5a}",
        "\u{2e5b}", "\u{2e5c}", "\u{2e5d}", "\u{2e5e}", "\u{3001}", "\u{3008}", "\u{3009}",
        "\u{300a}", "\u{300b}", "\u{300c}", "\u{300d}", "\u{300e}", "\u{300f}", "\u{3010}",
        "\u{3011}", "\u{3012}", "\u{3014}", "\u{3015}", "\u{3016}", "\u{3017}", "\u{3018}",
        "\u{3019}", "\u{301a}", "\u{301b}", "\u{301c}", "\u{301d}", "\u{301e}", "\u{3020}",
        "\u{3030}", "\u{fd3e}", "\u{fd3f}", "\u{fe45}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Pattern_Syntax}+$", "^\\p{Pat_Syn}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_patternwhitespace() {
    test_with_configs(unicode_escape_property_binary_patternwhitespace_tc)
}

fn unicode_escape_property_binary_patternwhitespace_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 6] = [
        "\u{9}", "\u{20}", "\u{85}", "\u{200e}", "\u{2028}", "\u{2029}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Pattern_White_Space}+$", "^\\p{Pat_WS}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_quotationmark() {
    test_with_configs(unicode_escape_property_binary_quotationmark_tc)
}

fn unicode_escape_property_binary_quotationmark_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 28] = [
        "\u{22}", "\u{27}", "\u{ab}", "\u{bb}", "\u{2018}", "\u{2019}", "\u{201a}", "\u{201b}",
        "\u{201d}", "\u{201e}", "\u{201f}", "\u{2039}", "\u{203a}", "\u{2e42}", "\u{300c}",
        "\u{300d}", "\u{300e}", "\u{300f}", "\u{301d}", "\u{301e}", "\u{fe41}", "\u{fe42}",
        "\u{fe43}", "\u{fe44}", "\u{ff02}", "\u{ff07}", "\u{ff62}", "\u{ff63}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Quotation_Mark}+$", "^\\p{QMark}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_radical() {
    test_with_configs(unicode_escape_property_binary_radical_tc)
}

fn unicode_escape_property_binary_radical_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 3] = ["\u{2e80}", "\u{2e9b}", "\u{2f00}"];
    const REGEXES: [&str; 1] = ["^\\p{Radical}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_regionalindicator() {
    test_with_configs(unicode_escape_property_binary_regionalindicator_tc)
}

fn unicode_escape_property_binary_regionalindicator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{1f1e6}"];
    const REGEXES: [&str; 2] = ["^\\p{Regional_Indicator}+$", "^\\p{RI}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_sentenceterminal() {
    test_with_configs(unicode_escape_property_binary_sentenceterminal_tc)
}

fn unicode_escape_property_binary_sentenceterminal_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 81] = [
        "\u{21}",
        "\u{2e}",
        "\u{3f}",
        "\u{589}",
        "\u{61d}",
        "\u{6d4}",
        "\u{700}",
        "\u{7f9}",
        "\u{837}",
        "\u{839}",
        "\u{83d}",
        "\u{964}",
        "\u{104a}",
        "\u{1362}",
        "\u{1367}",
        "\u{166e}",
        "\u{1735}",
        "\u{17d4}",
        "\u{1803}",
        "\u{1809}",
        "\u{1944}",
        "\u{1aa8}",
        "\u{1b5a}",
        "\u{1b5e}",
        "\u{1b7d}",
        "\u{1c3b}",
        "\u{1c7e}",
        "\u{203c}",
        "\u{2047}",
        "\u{2e2e}",
        "\u{2e3c}",
        "\u{2e53}",
        "\u{3002}",
        "\u{a4ff}",
        "\u{a60e}",
        "\u{a6f3}",
        "\u{a6f7}",
        "\u{a876}",
        "\u{a8ce}",
        "\u{a92f}",
        "\u{a9c8}",
        "\u{aa5d}",
        "\u{aaf0}",
        "\u{abeb}",
        "\u{fe52}",
        "\u{fe56}",
        "\u{ff01}",
        "\u{ff0e}",
        "\u{ff1f}",
        "\u{ff61}",
        "\u{10a56}",
        "\u{10f55}",
        "\u{10f86}",
        "\u{11047}",
        "\u{110be}",
        "\u{11141}",
        "\u{111c5}",
        "\u{111cd}",
        "\u{111de}",
        "\u{11238}",
        "\u{1123b}",
        "\u{112a9}",
        "\u{1144b}",
        "\u{115c2}",
        "\u{115c9}",
        "\u{11641}",
        "\u{1173c}",
        "\u{11944}",
        "\u{11946}",
        "\u{11a42}",
        "\u{11a9b}",
        "\u{11c41}",
        "\u{11ef7}",
        "\u{11f43}",
        "\u{16a6e}",
        "\u{16af5}",
        "\u{16b37}",
        "\u{16b44}",
        "\u{16e98}",
        "\u{1bc9f}",
        "\u{1da88}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Sentence_Terminal}+$", "^\\p{STerm}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_softdotted() {
    test_with_configs(unicode_escape_property_binary_softdotted_tc)
}

fn unicode_escape_property_binary_softdotted_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 34] = [
        "\u{69}",
        "\u{12f}",
        "\u{249}",
        "\u{268}",
        "\u{29d}",
        "\u{2b2}",
        "\u{3f3}",
        "\u{456}",
        "\u{458}",
        "\u{1d62}",
        "\u{1d96}",
        "\u{1da4}",
        "\u{1da8}",
        "\u{1e2d}",
        "\u{1ecb}",
        "\u{2071}",
        "\u{2148}",
        "\u{2c7c}",
        "\u{1d422}",
        "\u{1d456}",
        "\u{1d48a}",
        "\u{1d4be}",
        "\u{1d4f2}",
        "\u{1d526}",
        "\u{1d55a}",
        "\u{1d58e}",
        "\u{1d5c2}",
        "\u{1d5f6}",
        "\u{1d62a}",
        "\u{1d65e}",
        "\u{1d692}",
        "\u{1df1a}",
        "\u{1e04c}",
        "\u{1e068}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Soft_Dotted}+$", "^\\p{SD}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_terminalpunctuation() {
    test_with_configs(unicode_escape_property_binary_terminalpunctuation_tc)
}

fn unicode_escape_property_binary_terminalpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 108] = [
        "\u{21}",
        "\u{2c}",
        "\u{2e}",
        "\u{3a}",
        "\u{3f}",
        "\u{37e}",
        "\u{387}",
        "\u{589}",
        "\u{5c3}",
        "\u{60c}",
        "\u{61b}",
        "\u{61d}",
        "\u{6d4}",
        "\u{700}",
        "\u{70c}",
        "\u{7f8}",
        "\u{830}",
        "\u{85e}",
        "\u{964}",
        "\u{e5a}",
        "\u{f08}",
        "\u{f0d}",
        "\u{104a}",
        "\u{1361}",
        "\u{166e}",
        "\u{16eb}",
        "\u{1735}",
        "\u{17d4}",
        "\u{17da}",
        "\u{1802}",
        "\u{1808}",
        "\u{1944}",
        "\u{1aa8}",
        "\u{1b5a}",
        "\u{1b5d}",
        "\u{1b7d}",
        "\u{1c3b}",
        "\u{1c7e}",
        "\u{203c}",
        "\u{2047}",
        "\u{2e2e}",
        "\u{2e3c}",
        "\u{2e41}",
        "\u{2e4c}",
        "\u{2e4e}",
        "\u{2e53}",
        "\u{3001}",
        "\u{a4fe}",
        "\u{a60d}",
        "\u{a6f3}",
        "\u{a876}",
        "\u{a8ce}",
        "\u{a92f}",
        "\u{a9c7}",
        "\u{aa5d}",
        "\u{aadf}",
        "\u{aaf0}",
        "\u{abeb}",
        "\u{fe50}",
        "\u{fe54}",
        "\u{ff01}",
        "\u{ff0c}",
        "\u{ff0e}",
        "\u{ff1a}",
        "\u{ff1f}",
        "\u{ff61}",
        "\u{ff64}",
        "\u{1039f}",
        "\u{103d0}",
        "\u{10857}",
        "\u{1091f}",
        "\u{10a56}",
        "\u{10af0}",
        "\u{10b3a}",
        "\u{10b99}",
        "\u{10f55}",
        "\u{10f86}",
        "\u{11047}",
        "\u{110be}",
        "\u{11141}",
        "\u{111c5}",
        "\u{111cd}",
        "\u{111de}",
        "\u{11238}",
        "\u{112a9}",
        "\u{1144b}",
        "\u{1145a}",
        "\u{115c2}",
        "\u{115c9}",
        "\u{11641}",
        "\u{1173c}",
        "\u{11944}",
        "\u{11946}",
        "\u{11a42}",
        "\u{11a9b}",
        "\u{11aa1}",
        "\u{11c41}",
        "\u{11c71}",
        "\u{11ef7}",
        "\u{11f43}",
        "\u{12470}",
        "\u{16a6e}",
        "\u{16af5}",
        "\u{16b37}",
        "\u{16b44}",
        "\u{16e97}",
        "\u{1bc9f}",
        "\u{1da87}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Terminal_Punctuation}+$", "^\\p{Term}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_unifiedideograph() {
    test_with_configs(unicode_escape_property_binary_unifiedideograph_tc)
}

fn unicode_escape_property_binary_unifiedideograph_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 17] = [
        "\u{3400}",
        "\u{4e00}",
        "\u{fa0e}",
        "\u{fa11}",
        "\u{fa13}",
        "\u{fa1f}",
        "\u{fa21}",
        "\u{fa23}",
        "\u{fa27}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Unified_Ideograph}+$", "^\\p{UIdeo}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_uppercase() {
    test_with_configs(unicode_escape_property_binary_uppercase_tc)
}

fn unicode_escape_property_binary_uppercase_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 651] = [
        "\u{41}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{14a}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3cf}",
        "\u{3d2}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13a0}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1fb8}",
        "\u{1fc8}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff8}",
        "\u{2102}",
        "\u{2107}",
        "\u{210b}",
        "\u{2110}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{2130}",
        "\u{213e}",
        "\u{2145}",
        "\u{2160}",
        "\u{2183}",
        "\u{24b6}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1d400}",
        "\u{1d434}",
        "\u{1d468}",
        "\u{1d49c}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4d0}",
        "\u{1d504}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d538}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d56c}",
        "\u{1d5a0}",
        "\u{1d5d4}",
        "\u{1d608}",
        "\u{1d63c}",
        "\u{1d670}",
        "\u{1d6a8}",
        "\u{1d6e2}",
        "\u{1d71c}",
        "\u{1d756}",
        "\u{1d790}",
        "\u{1d7ca}",
        "\u{1e900}",
        "\u{1f130}",
        "\u{1f150}",
        "\u{1f170}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Uppercase}+$", "^\\p{Upper}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_variationselector() {
    test_with_configs(unicode_escape_property_binary_variationselector_tc)
}

fn unicode_escape_property_binary_variationselector_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 4] = ["\u{180b}", "\u{180f}", "\u{fe00}", "\u{e0100}"];
    const REGEXES: [&str; 2] = ["^\\p{Variation_Selector}+$", "^\\p{VS}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_whitespace() {
    test_with_configs(unicode_escape_property_binary_whitespace_tc)
}

fn unicode_escape_property_binary_whitespace_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 11] = [
        "\u{9}", "\u{20}", "\u{85}", "\u{a0}", "\u{1680}", "\u{2000}", "\u{2028}", "\u{2029}",
        "\u{202f}", "\u{205f}", "\u{3000}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{White_Space}+$", "^\\p{space}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_emoji() {
    test_with_configs(unicode_escape_property_binary_emoji_tc)
}

fn unicode_escape_property_binary_emoji_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 404] = [
        "\u{23}",
        "\u{2a}",
        "\u{30}",
        "\u{a9}",
        "\u{ae}",
        "\u{203c}",
        "\u{2049}",
        "\u{2122}",
        "\u{2139}",
        "\u{2194}",
        "\u{21a9}",
        "\u{231a}",
        "\u{2328}",
        "\u{23cf}",
        "\u{23e9}",
        "\u{23ed}",
        "\u{23ef}",
        "\u{23f0}",
        "\u{23f1}",
        "\u{23f3}",
        "\u{23f8}",
        "\u{24c2}",
        "\u{25aa}",
        "\u{25b6}",
        "\u{25c0}",
        "\u{25fb}",
        "\u{2600}",
        "\u{2602}",
        "\u{2604}",
        "\u{260e}",
        "\u{2611}",
        "\u{2614}",
        "\u{2618}",
        "\u{261d}",
        "\u{2620}",
        "\u{2622}",
        "\u{2626}",
        "\u{262a}",
        "\u{262e}",
        "\u{262f}",
        "\u{2638}",
        "\u{263a}",
        "\u{2640}",
        "\u{2642}",
        "\u{2648}",
        "\u{265f}",
        "\u{2660}",
        "\u{2663}",
        "\u{2665}",
        "\u{2668}",
        "\u{267b}",
        "\u{267e}",
        "\u{267f}",
        "\u{2692}",
        "\u{2693}",
        "\u{2694}",
        "\u{2695}",
        "\u{2696}",
        "\u{2699}",
        "\u{269b}",
        "\u{26a0}",
        "\u{26a7}",
        "\u{26aa}",
        "\u{26b0}",
        "\u{26bd}",
        "\u{26c4}",
        "\u{26c8}",
        "\u{26ce}",
        "\u{26cf}",
        "\u{26d1}",
        "\u{26d3}",
        "\u{26d4}",
        "\u{26e9}",
        "\u{26ea}",
        "\u{26f0}",
        "\u{26f2}",
        "\u{26f4}",
        "\u{26f5}",
        "\u{26f7}",
        "\u{26fa}",
        "\u{26fd}",
        "\u{2702}",
        "\u{2705}",
        "\u{2708}",
        "\u{270d}",
        "\u{270f}",
        "\u{2712}",
        "\u{2714}",
        "\u{2716}",
        "\u{271d}",
        "\u{2721}",
        "\u{2728}",
        "\u{2733}",
        "\u{2744}",
        "\u{2747}",
        "\u{274c}",
        "\u{274e}",
        "\u{2753}",
        "\u{2757}",
        "\u{2763}",
        "\u{2764}",
        "\u{2795}",
        "\u{27a1}",
        "\u{27b0}",
        "\u{27bf}",
        "\u{2934}",
        "\u{2b05}",
        "\u{2b1b}",
        "\u{2b50}",
        "\u{2b55}",
        "\u{3030}",
        "\u{303d}",
        "\u{3297}",
        "\u{3299}",
        "\u{1f004}",
        "\u{1f0cf}",
        "\u{1f170}",
        "\u{1f17e}",
        "\u{1f18e}",
        "\u{1f191}",
        "\u{1f1e6}",
        "\u{1f201}",
        "\u{1f21a}",
        "\u{1f22f}",
        "\u{1f232}",
        "\u{1f250}",
        "\u{1f300}",
        "\u{1f30d}",
        "\u{1f30f}",
        "\u{1f310}",
        "\u{1f311}",
        "\u{1f312}",
        "\u{1f313}",
        "\u{1f316}",
        "\u{1f319}",
        "\u{1f31a}",
        "\u{1f31b}",
        "\u{1f31c}",
        "\u{1f31d}",
        "\u{1f31f}",
        "\u{1f321}",
        "\u{1f324}",
        "\u{1f32d}",
        "\u{1f330}",
        "\u{1f332}",
        "\u{1f334}",
        "\u{1f336}",
        "\u{1f337}",
        "\u{1f34b}",
        "\u{1f34c}",
        "\u{1f350}",
        "\u{1f351}",
        "\u{1f37c}",
        "\u{1f37d}",
        "\u{1f37e}",
        "\u{1f380}",
        "\u{1f396}",
        "\u{1f399}",
        "\u{1f39e}",
        "\u{1f3a0}",
        "\u{1f3c5}",
        "\u{1f3c6}",
        "\u{1f3c7}",
        "\u{1f3c8}",
        "\u{1f3c9}",
        "\u{1f3ca}",
        "\u{1f3cb}",
        "\u{1f3cf}",
        "\u{1f3d4}",
        "\u{1f3e0}",
        "\u{1f3e4}",
        "\u{1f3e5}",
        "\u{1f3f3}",
        "\u{1f3f4}",
        "\u{1f3f5}",
        "\u{1f3f7}",
        "\u{1f3f8}",
        "\u{1f408}",
        "\u{1f409}",
        "\u{1f40c}",
        "\u{1f40f}",
        "\u{1f411}",
        "\u{1f413}",
        "\u{1f414}",
        "\u{1f415}",
        "\u{1f416}",
        "\u{1f417}",
        "\u{1f42a}",
        "\u{1f42b}",
        "\u{1f43f}",
        "\u{1f440}",
        "\u{1f441}",
        "\u{1f442}",
        "\u{1f465}",
        "\u{1f466}",
        "\u{1f46c}",
        "\u{1f46e}",
        "\u{1f4ad}",
        "\u{1f4ae}",
        "\u{1f4b6}",
        "\u{1f4b8}",
        "\u{1f4ec}",
        "\u{1f4ee}",
        "\u{1f4ef}",
        "\u{1f4f0}",
        "\u{1f4f5}",
        "\u{1f4f6}",
        "\u{1f4f8}",
        "\u{1f4f9}",
        "\u{1f4fd}",
        "\u{1f4ff}",
        "\u{1f503}",
        "\u{1f504}",
        "\u{1f508}",
        "\u{1f509}",
        "\u{1f50a}",
        "\u{1f515}",
        "\u{1f516}",
        "\u{1f52c}",
        "\u{1f52e}",
        "\u{1f549}",
        "\u{1f54b}",
        "\u{1f550}",
        "\u{1f55c}",
        "\u{1f56f}",
        "\u{1f573}",
        "\u{1f57a}",
        "\u{1f587}",
        "\u{1f58a}",
        "\u{1f590}",
        "\u{1f595}",
        "\u{1f5a4}",
        "\u{1f5a5}",
        "\u{1f5a8}",
        "\u{1f5b1}",
        "\u{1f5bc}",
        "\u{1f5c2}",
        "\u{1f5d1}",
        "\u{1f5dc}",
        "\u{1f5e1}",
        "\u{1f5e3}",
        "\u{1f5e8}",
        "\u{1f5ef}",
        "\u{1f5f3}",
        "\u{1f5fa}",
        "\u{1f5fb}",
        "\u{1f600}",
        "\u{1f601}",
        "\u{1f607}",
        "\u{1f609}",
        "\u{1f60e}",
        "\u{1f60f}",
        "\u{1f610}",
        "\u{1f611}",
        "\u{1f612}",
        "\u{1f615}",
        "\u{1f616}",
        "\u{1f617}",
        "\u{1f618}",
        "\u{1f619}",
        "\u{1f61a}",
        "\u{1f61b}",
        "\u{1f61c}",
        "\u{1f61f}",
        "\u{1f620}",
        "\u{1f626}",
        "\u{1f628}",
        "\u{1f62c}",
        "\u{1f62d}",
        "\u{1f62e}",
        "\u{1f630}",
        "\u{1f634}",
        "\u{1f635}",
        "\u{1f636}",
        "\u{1f637}",
        "\u{1f641}",
        "\u{1f645}",
        "\u{1f680}",
        "\u{1f681}",
        "\u{1f683}",
        "\u{1f686}",
        "\u{1f687}",
        "\u{1f688}",
        "\u{1f689}",
        "\u{1f68a}",
        "\u{1f68c}",
        "\u{1f68d}",
        "\u{1f68e}",
        "\u{1f68f}",
        "\u{1f690}",
        "\u{1f691}",
        "\u{1f694}",
        "\u{1f695}",
        "\u{1f696}",
        "\u{1f697}",
        "\u{1f698}",
        "\u{1f699}",
        "\u{1f69b}",
        "\u{1f6a2}",
        "\u{1f6a3}",
        "\u{1f6a4}",
        "\u{1f6a6}",
        "\u{1f6a7}",
        "\u{1f6ae}",
        "\u{1f6b2}",
        "\u{1f6b3}",
        "\u{1f6b6}",
        "\u{1f6b7}",
        "\u{1f6b9}",
        "\u{1f6bf}",
        "\u{1f6c0}",
        "\u{1f6c1}",
        "\u{1f6cb}",
        "\u{1f6cc}",
        "\u{1f6cd}",
        "\u{1f6d0}",
        "\u{1f6d1}",
        "\u{1f6d5}",
        "\u{1f6d6}",
        "\u{1f6dc}",
        "\u{1f6dd}",
        "\u{1f6e0}",
        "\u{1f6e9}",
        "\u{1f6eb}",
        "\u{1f6f0}",
        "\u{1f6f3}",
        "\u{1f6f4}",
        "\u{1f6f7}",
        "\u{1f6f9}",
        "\u{1f6fa}",
        "\u{1f6fb}",
        "\u{1f7e0}",
        "\u{1f7f0}",
        "\u{1f90c}",
        "\u{1f90d}",
        "\u{1f910}",
        "\u{1f919}",
        "\u{1f91f}",
        "\u{1f920}",
        "\u{1f928}",
        "\u{1f930}",
        "\u{1f931}",
        "\u{1f933}",
        "\u{1f93c}",
        "\u{1f93f}",
        "\u{1f940}",
        "\u{1f947}",
        "\u{1f94c}",
        "\u{1f94d}",
        "\u{1f950}",
        "\u{1f95f}",
        "\u{1f96c}",
        "\u{1f971}",
        "\u{1f972}",
        "\u{1f973}",
        "\u{1f977}",
        "\u{1f979}",
        "\u{1f97a}",
        "\u{1f97b}",
        "\u{1f97c}",
        "\u{1f980}",
        "\u{1f985}",
        "\u{1f992}",
        "\u{1f998}",
        "\u{1f9a3}",
        "\u{1f9a5}",
        "\u{1f9ab}",
        "\u{1f9ae}",
        "\u{1f9b0}",
        "\u{1f9ba}",
        "\u{1f9c0}",
        "\u{1f9c1}",
        "\u{1f9c3}",
        "\u{1f9cb}",
        "\u{1f9cc}",
        "\u{1f9cd}",
        "\u{1f9d0}",
        "\u{1f9e7}",
        "\u{1fa70}",
        "\u{1fa74}",
        "\u{1fa75}",
        "\u{1fa78}",
        "\u{1fa7b}",
        "\u{1fa80}",
        "\u{1fa83}",
        "\u{1fa87}",
        "\u{1fa90}",
        "\u{1fa96}",
        "\u{1faa9}",
        "\u{1faad}",
        "\u{1fab0}",
        "\u{1fab7}",
        "\u{1fabb}",
        "\u{1fabf}",
        "\u{1fac0}",
        "\u{1fac3}",
        "\u{1face}",
        "\u{1fad0}",
        "\u{1fad7}",
        "\u{1fada}",
        "\u{1fae0}",
        "\u{1fae8}",
        "\u{1faf0}",
        "\u{1faf7}",
    ];
    const REGEXES: [&str; 1] = ["^\\p{Emoji}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_emojicomponent() {
    test_with_configs(unicode_escape_property_binary_emojicomponent_tc)
}

fn unicode_escape_property_binary_emojicomponent_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 10] = [
        "\u{23}",
        "\u{2a}",
        "\u{30}",
        "\u{200d}",
        "\u{20e3}",
        "\u{fe0f}",
        "\u{1f1e6}",
        "\u{1f3fb}",
        "\u{1f9b0}",
        "\u{e0020}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Emoji_Component}+$", "^\\p{EComp}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_emojimodifier() {
    test_with_configs(unicode_escape_property_binary_emojimodifier_tc)
}

fn unicode_escape_property_binary_emojimodifier_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{1f3fb}"];
    const REGEXES: [&str; 2] = ["^\\p{Emoji_Modifier}+$", "^\\p{EMod}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_emojimodifierbase() {
    test_with_configs(unicode_escape_property_binary_emojimodifierbase_tc)
}

fn unicode_escape_property_binary_emojimodifierbase_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 50] = [
        "\u{261d}",
        "\u{26f9}",
        "\u{270a}",
        "\u{270d}",
        "\u{1f385}",
        "\u{1f3c2}",
        "\u{1f3c7}",
        "\u{1f3ca}",
        "\u{1f3cb}",
        "\u{1f442}",
        "\u{1f446}",
        "\u{1f466}",
        "\u{1f46c}",
        "\u{1f46e}",
        "\u{1f47c}",
        "\u{1f481}",
        "\u{1f485}",
        "\u{1f48f}",
        "\u{1f491}",
        "\u{1f4aa}",
        "\u{1f574}",
        "\u{1f57a}",
        "\u{1f590}",
        "\u{1f595}",
        "\u{1f645}",
        "\u{1f64b}",
        "\u{1f6a3}",
        "\u{1f6b4}",
        "\u{1f6b6}",
        "\u{1f6c0}",
        "\u{1f6cc}",
        "\u{1f90c}",
        "\u{1f90f}",
        "\u{1f918}",
        "\u{1f919}",
        "\u{1f91f}",
        "\u{1f926}",
        "\u{1f930}",
        "\u{1f931}",
        "\u{1f933}",
        "\u{1f93c}",
        "\u{1f977}",
        "\u{1f9b5}",
        "\u{1f9b8}",
        "\u{1f9bb}",
        "\u{1f9cd}",
        "\u{1f9d1}",
        "\u{1fac3}",
        "\u{1faf0}",
        "\u{1faf7}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Emoji_Modifier_Base}+$", "^\\p{EBase}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_emojipresentation() {
    test_with_configs(unicode_escape_property_binary_emojipresentation_tc)
}

fn unicode_escape_property_binary_emojipresentation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 282] = [
        "\u{231a}",
        "\u{23e9}",
        "\u{23f0}",
        "\u{23f3}",
        "\u{25fd}",
        "\u{2614}",
        "\u{2648}",
        "\u{267f}",
        "\u{2693}",
        "\u{26a1}",
        "\u{26aa}",
        "\u{26bd}",
        "\u{26c4}",
        "\u{26ce}",
        "\u{26d4}",
        "\u{26ea}",
        "\u{26f2}",
        "\u{26f5}",
        "\u{26fa}",
        "\u{26fd}",
        "\u{2705}",
        "\u{270a}",
        "\u{2728}",
        "\u{274c}",
        "\u{274e}",
        "\u{2753}",
        "\u{2757}",
        "\u{2795}",
        "\u{27b0}",
        "\u{27bf}",
        "\u{2b1b}",
        "\u{2b50}",
        "\u{2b55}",
        "\u{1f004}",
        "\u{1f0cf}",
        "\u{1f18e}",
        "\u{1f191}",
        "\u{1f1e6}",
        "\u{1f201}",
        "\u{1f21a}",
        "\u{1f22f}",
        "\u{1f232}",
        "\u{1f238}",
        "\u{1f250}",
        "\u{1f300}",
        "\u{1f30d}",
        "\u{1f30f}",
        "\u{1f310}",
        "\u{1f311}",
        "\u{1f312}",
        "\u{1f313}",
        "\u{1f316}",
        "\u{1f319}",
        "\u{1f31a}",
        "\u{1f31b}",
        "\u{1f31c}",
        "\u{1f31d}",
        "\u{1f31f}",
        "\u{1f32d}",
        "\u{1f330}",
        "\u{1f332}",
        "\u{1f334}",
        "\u{1f337}",
        "\u{1f34b}",
        "\u{1f34c}",
        "\u{1f350}",
        "\u{1f351}",
        "\u{1f37c}",
        "\u{1f37e}",
        "\u{1f380}",
        "\u{1f3a0}",
        "\u{1f3c5}",
        "\u{1f3c6}",
        "\u{1f3c7}",
        "\u{1f3c8}",
        "\u{1f3c9}",
        "\u{1f3ca}",
        "\u{1f3cf}",
        "\u{1f3e0}",
        "\u{1f3e4}",
        "\u{1f3e5}",
        "\u{1f3f4}",
        "\u{1f3f8}",
        "\u{1f408}",
        "\u{1f409}",
        "\u{1f40c}",
        "\u{1f40f}",
        "\u{1f411}",
        "\u{1f413}",
        "\u{1f414}",
        "\u{1f415}",
        "\u{1f416}",
        "\u{1f417}",
        "\u{1f42a}",
        "\u{1f42b}",
        "\u{1f440}",
        "\u{1f442}",
        "\u{1f465}",
        "\u{1f466}",
        "\u{1f46c}",
        "\u{1f46e}",
        "\u{1f4ad}",
        "\u{1f4ae}",
        "\u{1f4b6}",
        "\u{1f4b8}",
        "\u{1f4ec}",
        "\u{1f4ee}",
        "\u{1f4ef}",
        "\u{1f4f0}",
        "\u{1f4f5}",
        "\u{1f4f6}",
        "\u{1f4f8}",
        "\u{1f4f9}",
        "\u{1f4ff}",
        "\u{1f503}",
        "\u{1f504}",
        "\u{1f508}",
        "\u{1f509}",
        "\u{1f50a}",
        "\u{1f515}",
        "\u{1f516}",
        "\u{1f52c}",
        "\u{1f52e}",
        "\u{1f54b}",
        "\u{1f550}",
        "\u{1f55c}",
        "\u{1f57a}",
        "\u{1f595}",
        "\u{1f5a4}",
        "\u{1f5fb}",
        "\u{1f600}",
        "\u{1f601}",
        "\u{1f607}",
        "\u{1f609}",
        "\u{1f60e}",
        "\u{1f60f}",
        "\u{1f610}",
        "\u{1f611}",
        "\u{1f612}",
        "\u{1f615}",
        "\u{1f616}",
        "\u{1f617}",
        "\u{1f618}",
        "\u{1f619}",
        "\u{1f61a}",
        "\u{1f61b}",
        "\u{1f61c}",
        "\u{1f61f}",
        "\u{1f620}",
        "\u{1f626}",
        "\u{1f628}",
        "\u{1f62c}",
        "\u{1f62d}",
        "\u{1f62e}",
        "\u{1f630}",
        "\u{1f634}",
        "\u{1f635}",
        "\u{1f636}",
        "\u{1f637}",
        "\u{1f641}",
        "\u{1f645}",
        "\u{1f680}",
        "\u{1f681}",
        "\u{1f683}",
        "\u{1f686}",
        "\u{1f687}",
        "\u{1f688}",
        "\u{1f689}",
        "\u{1f68a}",
        "\u{1f68c}",
        "\u{1f68d}",
        "\u{1f68e}",
        "\u{1f68f}",
        "\u{1f690}",
        "\u{1f691}",
        "\u{1f694}",
        "\u{1f695}",
        "\u{1f696}",
        "\u{1f697}",
        "\u{1f698}",
        "\u{1f699}",
        "\u{1f69b}",
        "\u{1f6a2}",
        "\u{1f6a3}",
        "\u{1f6a4}",
        "\u{1f6a6}",
        "\u{1f6a7}",
        "\u{1f6ae}",
        "\u{1f6b2}",
        "\u{1f6b3}",
        "\u{1f6b6}",
        "\u{1f6b7}",
        "\u{1f6b9}",
        "\u{1f6bf}",
        "\u{1f6c0}",
        "\u{1f6c1}",
        "\u{1f6cc}",
        "\u{1f6d0}",
        "\u{1f6d1}",
        "\u{1f6d5}",
        "\u{1f6d6}",
        "\u{1f6dc}",
        "\u{1f6dd}",
        "\u{1f6eb}",
        "\u{1f6f4}",
        "\u{1f6f7}",
        "\u{1f6f9}",
        "\u{1f6fa}",
        "\u{1f6fb}",
        "\u{1f7e0}",
        "\u{1f7f0}",
        "\u{1f90c}",
        "\u{1f90d}",
        "\u{1f910}",
        "\u{1f919}",
        "\u{1f91f}",
        "\u{1f920}",
        "\u{1f928}",
        "\u{1f930}",
        "\u{1f931}",
        "\u{1f933}",
        "\u{1f93c}",
        "\u{1f93f}",
        "\u{1f940}",
        "\u{1f947}",
        "\u{1f94c}",
        "\u{1f94d}",
        "\u{1f950}",
        "\u{1f95f}",
        "\u{1f96c}",
        "\u{1f971}",
        "\u{1f972}",
        "\u{1f973}",
        "\u{1f977}",
        "\u{1f979}",
        "\u{1f97a}",
        "\u{1f97b}",
        "\u{1f97c}",
        "\u{1f980}",
        "\u{1f985}",
        "\u{1f992}",
        "\u{1f998}",
        "\u{1f9a3}",
        "\u{1f9a5}",
        "\u{1f9ab}",
        "\u{1f9ae}",
        "\u{1f9b0}",
        "\u{1f9ba}",
        "\u{1f9c0}",
        "\u{1f9c1}",
        "\u{1f9c3}",
        "\u{1f9cb}",
        "\u{1f9cc}",
        "\u{1f9cd}",
        "\u{1f9d0}",
        "\u{1f9e7}",
        "\u{1fa70}",
        "\u{1fa74}",
        "\u{1fa75}",
        "\u{1fa78}",
        "\u{1fa7b}",
        "\u{1fa80}",
        "\u{1fa83}",
        "\u{1fa87}",
        "\u{1fa90}",
        "\u{1fa96}",
        "\u{1faa9}",
        "\u{1faad}",
        "\u{1fab0}",
        "\u{1fab7}",
        "\u{1fabb}",
        "\u{1fabf}",
        "\u{1fac0}",
        "\u{1fac3}",
        "\u{1face}",
        "\u{1fad0}",
        "\u{1fad7}",
        "\u{1fada}",
        "\u{1fae0}",
        "\u{1fae8}",
        "\u{1faf0}",
        "\u{1faf7}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Emoji_Presentation}+$", "^\\p{EPres}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_extendedpictographic() {
    test_with_configs(unicode_escape_property_binary_extendedpictographic_tc)
}

fn unicode_escape_property_binary_extendedpictographic_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 511] = [
        "\u{a9}",
        "\u{ae}",
        "\u{203c}",
        "\u{2049}",
        "\u{2122}",
        "\u{2139}",
        "\u{2194}",
        "\u{21a9}",
        "\u{231a}",
        "\u{2328}",
        "\u{2388}",
        "\u{23cf}",
        "\u{23e9}",
        "\u{23ed}",
        "\u{23ef}",
        "\u{23f0}",
        "\u{23f1}",
        "\u{23f3}",
        "\u{23f8}",
        "\u{24c2}",
        "\u{25aa}",
        "\u{25b6}",
        "\u{25c0}",
        "\u{25fb}",
        "\u{2600}",
        "\u{2602}",
        "\u{2604}",
        "\u{2605}",
        "\u{2607}",
        "\u{260e}",
        "\u{260f}",
        "\u{2611}",
        "\u{2612}",
        "\u{2614}",
        "\u{2616}",
        "\u{2618}",
        "\u{2619}",
        "\u{261d}",
        "\u{261e}",
        "\u{2620}",
        "\u{2621}",
        "\u{2622}",
        "\u{2624}",
        "\u{2626}",
        "\u{2627}",
        "\u{262a}",
        "\u{262b}",
        "\u{262e}",
        "\u{262f}",
        "\u{2630}",
        "\u{2638}",
        "\u{263a}",
        "\u{263b}",
        "\u{2640}",
        "\u{2641}",
        "\u{2642}",
        "\u{2643}",
        "\u{2648}",
        "\u{2654}",
        "\u{265f}",
        "\u{2660}",
        "\u{2661}",
        "\u{2663}",
        "\u{2664}",
        "\u{2665}",
        "\u{2667}",
        "\u{2668}",
        "\u{2669}",
        "\u{267b}",
        "\u{267c}",
        "\u{267e}",
        "\u{267f}",
        "\u{2680}",
        "\u{2690}",
        "\u{2692}",
        "\u{2693}",
        "\u{2694}",
        "\u{2695}",
        "\u{2696}",
        "\u{2698}",
        "\u{2699}",
        "\u{269a}",
        "\u{269b}",
        "\u{269d}",
        "\u{26a0}",
        "\u{26a2}",
        "\u{26a7}",
        "\u{26a8}",
        "\u{26aa}",
        "\u{26ac}",
        "\u{26b0}",
        "\u{26b2}",
        "\u{26bd}",
        "\u{26bf}",
        "\u{26c4}",
        "\u{26c6}",
        "\u{26c8}",
        "\u{26c9}",
        "\u{26ce}",
        "\u{26cf}",
        "\u{26d0}",
        "\u{26d1}",
        "\u{26d2}",
        "\u{26d3}",
        "\u{26d4}",
        "\u{26d5}",
        "\u{26e9}",
        "\u{26ea}",
        "\u{26eb}",
        "\u{26f0}",
        "\u{26f2}",
        "\u{26f4}",
        "\u{26f5}",
        "\u{26f6}",
        "\u{26f7}",
        "\u{26fa}",
        "\u{26fb}",
        "\u{26fd}",
        "\u{26fe}",
        "\u{2702}",
        "\u{2703}",
        "\u{2705}",
        "\u{2708}",
        "\u{270d}",
        "\u{270e}",
        "\u{270f}",
        "\u{2710}",
        "\u{2712}",
        "\u{2714}",
        "\u{2716}",
        "\u{271d}",
        "\u{2721}",
        "\u{2728}",
        "\u{2733}",
        "\u{2744}",
        "\u{2747}",
        "\u{274c}",
        "\u{274e}",
        "\u{2753}",
        "\u{2757}",
        "\u{2763}",
        "\u{2764}",
        "\u{2765}",
        "\u{2795}",
        "\u{27a1}",
        "\u{27b0}",
        "\u{27bf}",
        "\u{2934}",
        "\u{2b05}",
        "\u{2b1b}",
        "\u{2b50}",
        "\u{2b55}",
        "\u{3030}",
        "\u{303d}",
        "\u{3297}",
        "\u{3299}",
        "\u{1f000}",
        "\u{1f004}",
        "\u{1f005}",
        "\u{1f0cf}",
        "\u{1f0d0}",
        "\u{1f10d}",
        "\u{1f12f}",
        "\u{1f16c}",
        "\u{1f170}",
        "\u{1f17e}",
        "\u{1f18e}",
        "\u{1f191}",
        "\u{1f1ad}",
        "\u{1f201}",
        "\u{1f203}",
        "\u{1f21a}",
        "\u{1f22f}",
        "\u{1f232}",
        "\u{1f23c}",
        "\u{1f249}",
        "\u{1f250}",
        "\u{1f252}",
        "\u{1f300}",
        "\u{1f30d}",
        "\u{1f30f}",
        "\u{1f310}",
        "\u{1f311}",
        "\u{1f312}",
        "\u{1f313}",
        "\u{1f316}",
        "\u{1f319}",
        "\u{1f31a}",
        "\u{1f31b}",
        "\u{1f31c}",
        "\u{1f31d}",
        "\u{1f31f}",
        "\u{1f321}",
        "\u{1f322}",
        "\u{1f324}",
        "\u{1f32d}",
        "\u{1f330}",
        "\u{1f332}",
        "\u{1f334}",
        "\u{1f336}",
        "\u{1f337}",
        "\u{1f34b}",
        "\u{1f34c}",
        "\u{1f350}",
        "\u{1f351}",
        "\u{1f37c}",
        "\u{1f37d}",
        "\u{1f37e}",
        "\u{1f380}",
        "\u{1f394}",
        "\u{1f396}",
        "\u{1f398}",
        "\u{1f399}",
        "\u{1f39c}",
        "\u{1f39e}",
        "\u{1f3a0}",
        "\u{1f3c5}",
        "\u{1f3c6}",
        "\u{1f3c7}",
        "\u{1f3c8}",
        "\u{1f3c9}",
        "\u{1f3ca}",
        "\u{1f3cb}",
        "\u{1f3cf}",
        "\u{1f3d4}",
        "\u{1f3e0}",
        "\u{1f3e4}",
        "\u{1f3e5}",
        "\u{1f3f1}",
        "\u{1f3f3}",
        "\u{1f3f4}",
        "\u{1f3f5}",
        "\u{1f3f6}",
        "\u{1f3f7}",
        "\u{1f3f8}",
        "\u{1f400}",
        "\u{1f408}",
        "\u{1f409}",
        "\u{1f40c}",
        "\u{1f40f}",
        "\u{1f411}",
        "\u{1f413}",
        "\u{1f414}",
        "\u{1f415}",
        "\u{1f416}",
        "\u{1f417}",
        "\u{1f42a}",
        "\u{1f42b}",
        "\u{1f43f}",
        "\u{1f440}",
        "\u{1f441}",
        "\u{1f442}",
        "\u{1f465}",
        "\u{1f466}",
        "\u{1f46c}",
        "\u{1f46e}",
        "\u{1f4ad}",
        "\u{1f4ae}",
        "\u{1f4b6}",
        "\u{1f4b8}",
        "\u{1f4ec}",
        "\u{1f4ee}",
        "\u{1f4ef}",
        "\u{1f4f0}",
        "\u{1f4f5}",
        "\u{1f4f6}",
        "\u{1f4f8}",
        "\u{1f4f9}",
        "\u{1f4fd}",
        "\u{1f4fe}",
        "\u{1f4ff}",
        "\u{1f503}",
        "\u{1f504}",
        "\u{1f508}",
        "\u{1f509}",
        "\u{1f50a}",
        "\u{1f515}",
        "\u{1f516}",
        "\u{1f52c}",
        "\u{1f52e}",
        "\u{1f546}",
        "\u{1f549}",
        "\u{1f54b}",
        "\u{1f54f}",
        "\u{1f550}",
        "\u{1f55c}",
        "\u{1f568}",
        "\u{1f56f}",
        "\u{1f571}",
        "\u{1f573}",
        "\u{1f57a}",
        "\u{1f57b}",
        "\u{1f587}",
        "\u{1f588}",
        "\u{1f58a}",
        "\u{1f58e}",
        "\u{1f590}",
        "\u{1f591}",
        "\u{1f595}",
        "\u{1f597}",
        "\u{1f5a4}",
        "\u{1f5a5}",
        "\u{1f5a6}",
        "\u{1f5a8}",
        "\u{1f5a9}",
        "\u{1f5b1}",
        "\u{1f5b3}",
        "\u{1f5bc}",
        "\u{1f5bd}",
        "\u{1f5c2}",
        "\u{1f5c5}",
        "\u{1f5d1}",
        "\u{1f5d4}",
        "\u{1f5dc}",
        "\u{1f5df}",
        "\u{1f5e1}",
        "\u{1f5e2}",
        "\u{1f5e3}",
        "\u{1f5e4}",
        "\u{1f5e8}",
        "\u{1f5e9}",
        "\u{1f5ef}",
        "\u{1f5f0}",
        "\u{1f5f3}",
        "\u{1f5f4}",
        "\u{1f5fa}",
        "\u{1f5fb}",
        "\u{1f600}",
        "\u{1f601}",
        "\u{1f607}",
        "\u{1f609}",
        "\u{1f60e}",
        "\u{1f60f}",
        "\u{1f610}",
        "\u{1f611}",
        "\u{1f612}",
        "\u{1f615}",
        "\u{1f616}",
        "\u{1f617}",
        "\u{1f618}",
        "\u{1f619}",
        "\u{1f61a}",
        "\u{1f61b}",
        "\u{1f61c}",
        "\u{1f61f}",
        "\u{1f620}",
        "\u{1f626}",
        "\u{1f628}",
        "\u{1f62c}",
        "\u{1f62d}",
        "\u{1f62e}",
        "\u{1f630}",
        "\u{1f634}",
        "\u{1f635}",
        "\u{1f636}",
        "\u{1f637}",
        "\u{1f641}",
        "\u{1f645}",
        "\u{1f680}",
        "\u{1f681}",
        "\u{1f683}",
        "\u{1f686}",
        "\u{1f687}",
        "\u{1f688}",
        "\u{1f689}",
        "\u{1f68a}",
        "\u{1f68c}",
        "\u{1f68d}",
        "\u{1f68e}",
        "\u{1f68f}",
        "\u{1f690}",
        "\u{1f691}",
        "\u{1f694}",
        "\u{1f695}",
        "\u{1f696}",
        "\u{1f697}",
        "\u{1f698}",
        "\u{1f699}",
        "\u{1f69b}",
        "\u{1f6a2}",
        "\u{1f6a3}",
        "\u{1f6a4}",
        "\u{1f6a6}",
        "\u{1f6a7}",
        "\u{1f6ae}",
        "\u{1f6b2}",
        "\u{1f6b3}",
        "\u{1f6b6}",
        "\u{1f6b7}",
        "\u{1f6b9}",
        "\u{1f6bf}",
        "\u{1f6c0}",
        "\u{1f6c1}",
        "\u{1f6c6}",
        "\u{1f6cb}",
        "\u{1f6cc}",
        "\u{1f6cd}",
        "\u{1f6d0}",
        "\u{1f6d1}",
        "\u{1f6d3}",
        "\u{1f6d5}",
        "\u{1f6d6}",
        "\u{1f6d8}",
        "\u{1f6dc}",
        "\u{1f6dd}",
        "\u{1f6e0}",
        "\u{1f6e6}",
        "\u{1f6e9}",
        "\u{1f6ea}",
        "\u{1f6eb}",
        "\u{1f6ed}",
        "\u{1f6f0}",
        "\u{1f6f1}",
        "\u{1f6f3}",
        "\u{1f6f4}",
        "\u{1f6f7}",
        "\u{1f6f9}",
        "\u{1f6fa}",
        "\u{1f6fb}",
        "\u{1f6fd}",
        "\u{1f774}",
        "\u{1f7d5}",
        "\u{1f7e0}",
        "\u{1f7ec}",
        "\u{1f7f0}",
        "\u{1f7f1}",
        "\u{1f80c}",
        "\u{1f848}",
        "\u{1f85a}",
        "\u{1f888}",
        "\u{1f8ae}",
        "\u{1f90c}",
        "\u{1f90d}",
        "\u{1f910}",
        "\u{1f919}",
        "\u{1f91f}",
        "\u{1f920}",
        "\u{1f928}",
        "\u{1f930}",
        "\u{1f931}",
        "\u{1f933}",
        "\u{1f93c}",
        "\u{1f93f}",
        "\u{1f940}",
        "\u{1f947}",
        "\u{1f94c}",
        "\u{1f94d}",
        "\u{1f950}",
        "\u{1f95f}",
        "\u{1f96c}",
        "\u{1f971}",
        "\u{1f972}",
        "\u{1f973}",
        "\u{1f977}",
        "\u{1f979}",
        "\u{1f97a}",
        "\u{1f97b}",
        "\u{1f97c}",
        "\u{1f980}",
        "\u{1f985}",
        "\u{1f992}",
        "\u{1f998}",
        "\u{1f9a3}",
        "\u{1f9a5}",
        "\u{1f9ab}",
        "\u{1f9ae}",
        "\u{1f9b0}",
        "\u{1f9ba}",
        "\u{1f9c0}",
        "\u{1f9c1}",
        "\u{1f9c3}",
        "\u{1f9cb}",
        "\u{1f9cc}",
        "\u{1f9cd}",
        "\u{1f9d0}",
        "\u{1f9e7}",
        "\u{1fa00}",
        "\u{1fa70}",
        "\u{1fa74}",
        "\u{1fa75}",
        "\u{1fa78}",
        "\u{1fa7b}",
        "\u{1fa7d}",
        "\u{1fa80}",
        "\u{1fa83}",
        "\u{1fa87}",
        "\u{1fa89}",
        "\u{1fa90}",
        "\u{1fa96}",
        "\u{1faa9}",
        "\u{1faad}",
        "\u{1fab0}",
        "\u{1fab7}",
        "\u{1fabb}",
        "\u{1fabe}",
        "\u{1fabf}",
        "\u{1fac0}",
        "\u{1fac3}",
        "\u{1fac6}",
        "\u{1face}",
        "\u{1fad0}",
        "\u{1fad7}",
        "\u{1fada}",
        "\u{1fadc}",
        "\u{1fae0}",
        "\u{1fae8}",
        "\u{1fae9}",
        "\u{1faf0}",
        "\u{1faf7}",
        "\u{1faf9}",
        "\u{1fc00}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Extended_Pictographic}+$", "^\\p{ExtPict}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_changeswhennfkccasefolded() {
    test_with_configs(unicode_escape_property_binary_changeswhennfkccasefolded_tc)
}

fn unicode_escape_property_binary_changeswhennfkccasefolded_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1003] = [
        "\u{41}",
        "\u{a0}",
        "\u{a8}",
        "\u{aa}",
        "\u{ad}",
        "\u{af}",
        "\u{b2}",
        "\u{b4}",
        "\u{b5}",
        "\u{b8}",
        "\u{b9}",
        "\u{ba}",
        "\u{bc}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{149}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{17f}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{2b0}",
        "\u{2d8}",
        "\u{2e0}",
        "\u{340}",
        "\u{343}",
        "\u{34f}",
        "\u{370}",
        "\u{372}",
        "\u{374}",
        "\u{376}",
        "\u{37a}",
        "\u{37e}",
        "\u{37f}",
        "\u{384}",
        "\u{386}",
        "\u{387}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3c2}",
        "\u{3cf}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f0}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{587}",
        "\u{61c}",
        "\u{675}",
        "\u{958}",
        "\u{9dc}",
        "\u{9df}",
        "\u{a33}",
        "\u{a36}",
        "\u{a59}",
        "\u{a5e}",
        "\u{b5c}",
        "\u{e33}",
        "\u{eb3}",
        "\u{edc}",
        "\u{f0c}",
        "\u{f43}",
        "\u{f4d}",
        "\u{f52}",
        "\u{f57}",
        "\u{f5c}",
        "\u{f69}",
        "\u{f73}",
        "\u{f75}",
        "\u{f81}",
        "\u{f93}",
        "\u{f9d}",
        "\u{fa2}",
        "\u{fa7}",
        "\u{fac}",
        "\u{fb9}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{10fc}",
        "\u{115f}",
        "\u{13f8}",
        "\u{17b4}",
        "\u{180b}",
        "\u{180e}",
        "\u{180f}",
        "\u{1c80}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1d2c}",
        "\u{1d30}",
        "\u{1d3c}",
        "\u{1d4f}",
        "\u{1d78}",
        "\u{1d9b}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9a}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1f71}",
        "\u{1f73}",
        "\u{1f75}",
        "\u{1f77}",
        "\u{1f79}",
        "\u{1f7b}",
        "\u{1f7d}",
        "\u{1f80}",
        "\u{1fb2}",
        "\u{1fb7}",
        "\u{1fbd}",
        "\u{1fbe}",
        "\u{1fbf}",
        "\u{1fc2}",
        "\u{1fc7}",
        "\u{1fcd}",
        "\u{1fd3}",
        "\u{1fd8}",
        "\u{1fdd}",
        "\u{1fe3}",
        "\u{1fe8}",
        "\u{1fed}",
        "\u{1ff2}",
        "\u{1ff7}",
        "\u{1ffd}",
        "\u{2000}",
        "\u{200b}",
        "\u{2011}",
        "\u{2017}",
        "\u{2024}",
        "\u{202a}",
        "\u{202f}",
        "\u{2033}",
        "\u{2036}",
        "\u{203c}",
        "\u{203e}",
        "\u{2047}",
        "\u{2057}",
        "\u{205f}",
        "\u{2060}",
        "\u{2065}",
        "\u{2066}",
        "\u{2070}",
        "\u{2071}",
        "\u{2074}",
        "\u{207a}",
        "\u{207d}",
        "\u{207e}",
        "\u{207f}",
        "\u{2080}",
        "\u{208a}",
        "\u{208d}",
        "\u{208e}",
        "\u{2090}",
        "\u{20a8}",
        "\u{2100}",
        "\u{2102}",
        "\u{2103}",
        "\u{2105}",
        "\u{2107}",
        "\u{2109}",
        "\u{210a}",
        "\u{2115}",
        "\u{2116}",
        "\u{2119}",
        "\u{2120}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{212f}",
        "\u{2135}",
        "\u{2139}",
        "\u{213b}",
        "\u{213c}",
        "\u{2140}",
        "\u{2145}",
        "\u{2150}",
        "\u{2160}",
        "\u{2183}",
        "\u{2189}",
        "\u{222c}",
        "\u{222f}",
        "\u{2329}",
        "\u{232a}",
        "\u{2460}",
        "\u{249c}",
        "\u{24ea}",
        "\u{2a0c}",
        "\u{2a74}",
        "\u{2adc}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7c}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{2d6f}",
        "\u{2e9f}",
        "\u{2ef3}",
        "\u{2f00}",
        "\u{3000}",
        "\u{3036}",
        "\u{3038}",
        "\u{309b}",
        "\u{309f}",
        "\u{30ff}",
        "\u{3131}",
        "\u{3192}",
        "\u{3196}",
        "\u{3200}",
        "\u{3220}",
        "\u{322a}",
        "\u{3250}",
        "\u{3251}",
        "\u{3260}",
        "\u{3280}",
        "\u{328a}",
        "\u{32b1}",
        "\u{32c0}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a69c}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a770}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f2}",
        "\u{a7f5}",
        "\u{a7f8}",
        "\u{ab5c}",
        "\u{ab69}",
        "\u{ab70}",
        "\u{f900}",
        "\u{fa10}",
        "\u{fa12}",
        "\u{fa15}",
        "\u{fa20}",
        "\u{fa22}",
        "\u{fa25}",
        "\u{fa2a}",
        "\u{fa70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb29}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fdfc}",
        "\u{fe00}",
        "\u{fe10}",
        "\u{fe17}",
        "\u{fe18}",
        "\u{fe19}",
        "\u{fe30}",
        "\u{fe31}",
        "\u{fe33}",
        "\u{fe35}",
        "\u{fe36}",
        "\u{fe37}",
        "\u{fe38}",
        "\u{fe39}",
        "\u{fe3a}",
        "\u{fe3b}",
        "\u{fe3c}",
        "\u{fe3d}",
        "\u{fe3e}",
        "\u{fe3f}",
        "\u{fe40}",
        "\u{fe41}",
        "\u{fe42}",
        "\u{fe43}",
        "\u{fe44}",
        "\u{fe47}",
        "\u{fe48}",
        "\u{fe49}",
        "\u{fe4d}",
        "\u{fe50}",
        "\u{fe54}",
        "\u{fe58}",
        "\u{fe59}",
        "\u{fe5a}",
        "\u{fe5b}",
        "\u{fe5c}",
        "\u{fe5d}",
        "\u{fe5e}",
        "\u{fe5f}",
        "\u{fe62}",
        "\u{fe63}",
        "\u{fe64}",
        "\u{fe68}",
        "\u{fe69}",
        "\u{fe6a}",
        "\u{fe70}",
        "\u{fe74}",
        "\u{fe76}",
        "\u{feff}",
        "\u{ff01}",
        "\u{ff04}",
        "\u{ff05}",
        "\u{ff08}",
        "\u{ff09}",
        "\u{ff0a}",
        "\u{ff0b}",
        "\u{ff0c}",
        "\u{ff0d}",
        "\u{ff0e}",
        "\u{ff10}",
        "\u{ff1a}",
        "\u{ff1c}",
        "\u{ff1f}",
        "\u{ff21}",
        "\u{ff3b}",
        "\u{ff3c}",
        "\u{ff3d}",
        "\u{ff3e}",
        "\u{ff3f}",
        "\u{ff40}",
        "\u{ff41}",
        "\u{ff5b}",
        "\u{ff5c}",
        "\u{ff5d}",
        "\u{ff5e}",
        "\u{ff5f}",
        "\u{ff60}",
        "\u{ff61}",
        "\u{ff62}",
        "\u{ff63}",
        "\u{ff64}",
        "\u{ff66}",
        "\u{ff70}",
        "\u{ff71}",
        "\u{ff9e}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{ffe0}",
        "\u{ffe2}",
        "\u{ffe3}",
        "\u{ffe4}",
        "\u{ffe5}",
        "\u{ffe8}",
        "\u{ffe9}",
        "\u{ffed}",
        "\u{fff0}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10781}",
        "\u{10787}",
        "\u{107b2}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1bca0}",
        "\u{1d15e}",
        "\u{1d173}",
        "\u{1d1bb}",
        "\u{1d400}",
        "\u{1d456}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d51e}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d552}",
        "\u{1d6a8}",
        "\u{1d6c1}",
        "\u{1d6c2}",
        "\u{1d6db}",
        "\u{1d6dc}",
        "\u{1d6fb}",
        "\u{1d6fc}",
        "\u{1d715}",
        "\u{1d716}",
        "\u{1d735}",
        "\u{1d736}",
        "\u{1d74f}",
        "\u{1d750}",
        "\u{1d76f}",
        "\u{1d770}",
        "\u{1d789}",
        "\u{1d78a}",
        "\u{1d7a9}",
        "\u{1d7aa}",
        "\u{1d7c3}",
        "\u{1d7c4}",
        "\u{1d7ce}",
        "\u{1e030}",
        "\u{1e900}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{1f100}",
        "\u{1f110}",
        "\u{1f130}",
        "\u{1f16a}",
        "\u{1f190}",
        "\u{1f200}",
        "\u{1f210}",
        "\u{1f240}",
        "\u{1f250}",
        "\u{1fbf0}",
        "\u{2f800}",
        "\u{e0000}",
        "\u{e0001}",
        "\u{e0002}",
        "\u{e0020}",
        "\u{e0080}",
        "\u{e0100}",
        "\u{e01f0}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Changes_When_NFKC_Casefolded}+$", "^\\p{CWKCF}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_binary_bidimirrored() {
    test_with_configs(unicode_escape_property_binary_bidimirrored_tc)
}

fn unicode_escape_property_binary_bidimirrored_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 224] = [
        "\u{28}",
        "\u{29}",
        "\u{3c}",
        "\u{3e}",
        "\u{5b}",
        "\u{5d}",
        "\u{7b}",
        "\u{7d}",
        "\u{ab}",
        "\u{bb}",
        "\u{f3a}",
        "\u{f3b}",
        "\u{f3c}",
        "\u{f3d}",
        "\u{169b}",
        "\u{169c}",
        "\u{2039}",
        "\u{203a}",
        "\u{2045}",
        "\u{2046}",
        "\u{207d}",
        "\u{207e}",
        "\u{208d}",
        "\u{208e}",
        "\u{2140}",
        "\u{2201}",
        "\u{2208}",
        "\u{2211}",
        "\u{2215}",
        "\u{221a}",
        "\u{221f}",
        "\u{2224}",
        "\u{2226}",
        "\u{222b}",
        "\u{2239}",
        "\u{223b}",
        "\u{2252}",
        "\u{225f}",
        "\u{2262}",
        "\u{2264}",
        "\u{226e}",
        "\u{228f}",
        "\u{2298}",
        "\u{22a2}",
        "\u{22a6}",
        "\u{22be}",
        "\u{22c9}",
        "\u{22d0}",
        "\u{22d6}",
        "\u{22f0}",
        "\u{2308}",
        "\u{2309}",
        "\u{230a}",
        "\u{230b}",
        "\u{2320}",
        "\u{2329}",
        "\u{232a}",
        "\u{2768}",
        "\u{2769}",
        "\u{276a}",
        "\u{276b}",
        "\u{276c}",
        "\u{276d}",
        "\u{276e}",
        "\u{276f}",
        "\u{2770}",
        "\u{2771}",
        "\u{2772}",
        "\u{2773}",
        "\u{2774}",
        "\u{2775}",
        "\u{27c0}",
        "\u{27c3}",
        "\u{27c5}",
        "\u{27c6}",
        "\u{27c8}",
        "\u{27cb}",
        "\u{27d3}",
        "\u{27dc}",
        "\u{27e2}",
        "\u{27e6}",
        "\u{27e7}",
        "\u{27e8}",
        "\u{27e9}",
        "\u{27ea}",
        "\u{27eb}",
        "\u{27ec}",
        "\u{27ed}",
        "\u{27ee}",
        "\u{27ef}",
        "\u{2983}",
        "\u{2984}",
        "\u{2985}",
        "\u{2986}",
        "\u{2987}",
        "\u{2988}",
        "\u{2989}",
        "\u{298a}",
        "\u{298b}",
        "\u{298c}",
        "\u{298d}",
        "\u{298e}",
        "\u{298f}",
        "\u{2990}",
        "\u{2991}",
        "\u{2992}",
        "\u{2993}",
        "\u{2994}",
        "\u{2995}",
        "\u{2996}",
        "\u{2997}",
        "\u{2998}",
        "\u{299b}",
        "\u{29a2}",
        "\u{29b8}",
        "\u{29c0}",
        "\u{29c9}",
        "\u{29ce}",
        "\u{29d4}",
        "\u{29d8}",
        "\u{29d9}",
        "\u{29da}",
        "\u{29db}",
        "\u{29dc}",
        "\u{29e1}",
        "\u{29e3}",
        "\u{29e8}",
        "\u{29f4}",
        "\u{29fc}",
        "\u{29fd}",
        "\u{2a0a}",
        "\u{2a1e}",
        "\u{2a24}",
        "\u{2a26}",
        "\u{2a29}",
        "\u{2a2b}",
        "\u{2a34}",
        "\u{2a3c}",
        "\u{2a57}",
        "\u{2a64}",
        "\u{2a6a}",
        "\u{2a6f}",
        "\u{2a73}",
        "\u{2a79}",
        "\u{2aa6}",
        "\u{2aaf}",
        "\u{2adc}",
        "\u{2ade}",
        "\u{2ae2}",
        "\u{2aec}",
        "\u{2af3}",
        "\u{2af7}",
        "\u{2afd}",
        "\u{2bfe}",
        "\u{2e02}",
        "\u{2e03}",
        "\u{2e04}",
        "\u{2e05}",
        "\u{2e09}",
        "\u{2e0a}",
        "\u{2e0c}",
        "\u{2e0d}",
        "\u{2e1c}",
        "\u{2e1d}",
        "\u{2e20}",
        "\u{2e21}",
        "\u{2e22}",
        "\u{2e23}",
        "\u{2e24}",
        "\u{2e25}",
        "\u{2e26}",
        "\u{2e27}",
        "\u{2e28}",
        "\u{2e29}",
        "\u{2e55}",
        "\u{2e56}",
        "\u{2e57}",
        "\u{2e58}",
        "\u{2e59}",
        "\u{2e5a}",
        "\u{2e5b}",
        "\u{2e5c}",
        "\u{3008}",
        "\u{3009}",
        "\u{300a}",
        "\u{300b}",
        "\u{300c}",
        "\u{300d}",
        "\u{300e}",
        "\u{300f}",
        "\u{3010}",
        "\u{3011}",
        "\u{3014}",
        "\u{3015}",
        "\u{3016}",
        "\u{3017}",
        "\u{3018}",
        "\u{3019}",
        "\u{301a}",
        "\u{301b}",
        "\u{fe59}",
        "\u{fe5a}",
        "\u{fe5b}",
        "\u{fe5c}",
        "\u{fe5d}",
        "\u{fe5e}",
        "\u{fe64}",
        "\u{ff08}",
        "\u{ff09}",
        "\u{ff1c}",
        "\u{ff1e}",
        "\u{ff3b}",
        "\u{ff3d}",
        "\u{ff5b}",
        "\u{ff5d}",
        "\u{ff5f}",
        "\u{ff60}",
        "\u{ff62}",
        "\u{ff63}",
        "\u{1d6db}",
        "\u{1d715}",
        "\u{1d74f}",
        "\u{1d789}",
        "\u{1d7c3}",
    ];
    const REGEXES: [&str; 2] = ["^\\p{Bidi_Mirrored}+$", "^\\p{Bidi_M}+$"];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_closepunctuation() {
    test_with_configs(unicode_escape_property_gc_closepunctuation_tc)
}

fn unicode_escape_property_gc_closepunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 76] = [
        "\u{29}", "\u{5d}", "\u{7d}", "\u{f3b}", "\u{f3d}", "\u{169c}", "\u{2046}", "\u{207e}",
        "\u{208e}", "\u{2309}", "\u{230b}", "\u{232a}", "\u{2769}", "\u{276b}", "\u{276d}",
        "\u{276f}", "\u{2771}", "\u{2773}", "\u{2775}", "\u{27c6}", "\u{27e7}", "\u{27e9}",
        "\u{27eb}", "\u{27ed}", "\u{27ef}", "\u{2984}", "\u{2986}", "\u{2988}", "\u{298a}",
        "\u{298c}", "\u{298e}", "\u{2990}", "\u{2992}", "\u{2994}", "\u{2996}", "\u{2998}",
        "\u{29d9}", "\u{29db}", "\u{29fd}", "\u{2e23}", "\u{2e25}", "\u{2e27}", "\u{2e29}",
        "\u{2e56}", "\u{2e58}", "\u{2e5a}", "\u{2e5c}", "\u{3009}", "\u{300b}", "\u{300d}",
        "\u{300f}", "\u{3011}", "\u{3015}", "\u{3017}", "\u{3019}", "\u{301b}", "\u{301e}",
        "\u{fd3e}", "\u{fe18}", "\u{fe36}", "\u{fe38}", "\u{fe3a}", "\u{fe3c}", "\u{fe3e}",
        "\u{fe40}", "\u{fe42}", "\u{fe44}", "\u{fe48}", "\u{fe5a}", "\u{fe5c}", "\u{fe5e}",
        "\u{ff09}", "\u{ff3d}", "\u{ff5d}", "\u{ff60}", "\u{ff63}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Close_Punctuation}+$",
        "^\\p{gc=Close_Punctuation}+$",
        "^\\p{Close_Punctuation}+$",
        "^\\p{General_Category=Pe}+$",
        "^\\p{gc=Pe}+$",
        "^\\p{Pe}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_connectorpunctuation() {
    test_with_configs(unicode_escape_property_gc_connectorpunctuation_tc)
}

fn unicode_escape_property_gc_connectorpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 6] = [
        "\u{5f}", "\u{203f}", "\u{2054}", "\u{fe33}", "\u{fe4d}", "\u{ff3f}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Connector_Punctuation}+$",
        "^\\p{gc=Connector_Punctuation}+$",
        "^\\p{Connector_Punctuation}+$",
        "^\\p{General_Category=Pc}+$",
        "^\\p{gc=Pc}+$",
        "^\\p{Pc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_control() {
    test_with_configs(unicode_escape_property_gc_control_tc)
}

fn unicode_escape_property_gc_control_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 2] = ["\u{0}", "\u{7f}"];
    const REGEXES: [&str; 9] = [
        "^\\p{General_Category=Control}+$",
        "^\\p{gc=Control}+$",
        "^\\p{Control}+$",
        "^\\p{General_Category=cntrl}+$",
        "^\\p{gc=cntrl}+$",
        "^\\p{cntrl}+$",
        "^\\p{General_Category=Cc}+$",
        "^\\p{gc=Cc}+$",
        "^\\p{Cc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_currencysymbol() {
    test_with_configs(unicode_escape_property_gc_currencysymbol_tc)
}

fn unicode_escape_property_gc_currencysymbol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 21] = [
        "\u{24}",
        "\u{a2}",
        "\u{58f}",
        "\u{60b}",
        "\u{7fe}",
        "\u{9f2}",
        "\u{9fb}",
        "\u{af1}",
        "\u{bf9}",
        "\u{e3f}",
        "\u{17db}",
        "\u{20a0}",
        "\u{a838}",
        "\u{fdfc}",
        "\u{fe69}",
        "\u{ff04}",
        "\u{ffe0}",
        "\u{ffe5}",
        "\u{11fdd}",
        "\u{1e2ff}",
        "\u{1ecb0}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Currency_Symbol}+$",
        "^\\p{gc=Currency_Symbol}+$",
        "^\\p{Currency_Symbol}+$",
        "^\\p{General_Category=Sc}+$",
        "^\\p{gc=Sc}+$",
        "^\\p{Sc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_dashpunctuation() {
    test_with_configs(unicode_escape_property_gc_dashpunctuation_tc)
}

fn unicode_escape_property_gc_dashpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 19] = [
        "\u{2d}",
        "\u{58a}",
        "\u{5be}",
        "\u{1400}",
        "\u{1806}",
        "\u{2010}",
        "\u{2e17}",
        "\u{2e1a}",
        "\u{2e3a}",
        "\u{2e40}",
        "\u{2e5d}",
        "\u{301c}",
        "\u{3030}",
        "\u{30a0}",
        "\u{fe31}",
        "\u{fe58}",
        "\u{fe63}",
        "\u{ff0d}",
        "\u{10ead}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Dash_Punctuation}+$",
        "^\\p{gc=Dash_Punctuation}+$",
        "^\\p{Dash_Punctuation}+$",
        "^\\p{General_Category=Pd}+$",
        "^\\p{gc=Pd}+$",
        "^\\p{Pd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_decimalnumber() {
    test_with_configs(unicode_escape_property_gc_decimalnumber_tc)
}

fn unicode_escape_property_gc_decimalnumber_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 64] = [
        "\u{30}",
        "\u{660}",
        "\u{6f0}",
        "\u{7c0}",
        "\u{966}",
        "\u{9e6}",
        "\u{a66}",
        "\u{ae6}",
        "\u{b66}",
        "\u{be6}",
        "\u{c66}",
        "\u{ce6}",
        "\u{d66}",
        "\u{de6}",
        "\u{e50}",
        "\u{ed0}",
        "\u{f20}",
        "\u{1040}",
        "\u{1090}",
        "\u{17e0}",
        "\u{1810}",
        "\u{1946}",
        "\u{19d0}",
        "\u{1a80}",
        "\u{1a90}",
        "\u{1b50}",
        "\u{1bb0}",
        "\u{1c40}",
        "\u{1c50}",
        "\u{a620}",
        "\u{a8d0}",
        "\u{a900}",
        "\u{a9d0}",
        "\u{a9f0}",
        "\u{aa50}",
        "\u{abf0}",
        "\u{ff10}",
        "\u{104a0}",
        "\u{10d30}",
        "\u{11066}",
        "\u{110f0}",
        "\u{11136}",
        "\u{111d0}",
        "\u{112f0}",
        "\u{11450}",
        "\u{114d0}",
        "\u{11650}",
        "\u{116c0}",
        "\u{11730}",
        "\u{118e0}",
        "\u{11950}",
        "\u{11c50}",
        "\u{11d50}",
        "\u{11da0}",
        "\u{11f50}",
        "\u{16a60}",
        "\u{16ac0}",
        "\u{16b50}",
        "\u{1d7ce}",
        "\u{1e140}",
        "\u{1e2f0}",
        "\u{1e4f0}",
        "\u{1e950}",
        "\u{1fbf0}",
    ];
    const REGEXES: [&str; 9] = [
        "^\\p{General_Category=Decimal_Number}+$",
        "^\\p{gc=Decimal_Number}+$",
        "^\\p{Decimal_Number}+$",
        "^\\p{General_Category=digit}+$",
        "^\\p{gc=digit}+$",
        "^\\p{digit}+$",
        "^\\p{General_Category=Nd}+$",
        "^\\p{gc=Nd}+$",
        "^\\p{Nd}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_enclosingmark() {
    test_with_configs(unicode_escape_property_gc_enclosingmark_tc)
}

fn unicode_escape_property_gc_enclosingmark_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 5] = ["\u{488}", "\u{1abe}", "\u{20dd}", "\u{20e2}", "\u{a670}"];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Enclosing_Mark}+$",
        "^\\p{gc=Enclosing_Mark}+$",
        "^\\p{Enclosing_Mark}+$",
        "^\\p{General_Category=Me}+$",
        "^\\p{gc=Me}+$",
        "^\\p{Me}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_finalpunctuation() {
    test_with_configs(unicode_escape_property_gc_finalpunctuation_tc)
}

fn unicode_escape_property_gc_finalpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 10] = [
        "\u{bb}", "\u{2019}", "\u{201d}", "\u{203a}", "\u{2e03}", "\u{2e05}", "\u{2e0a}",
        "\u{2e0d}", "\u{2e1d}", "\u{2e21}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Final_Punctuation}+$",
        "^\\p{gc=Final_Punctuation}+$",
        "^\\p{Final_Punctuation}+$",
        "^\\p{General_Category=Pf}+$",
        "^\\p{gc=Pf}+$",
        "^\\p{Pf}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_format() {
    test_with_configs(unicode_escape_property_gc_format_tc)
}

fn unicode_escape_property_gc_format_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 21] = [
        "\u{ad}",
        "\u{600}",
        "\u{61c}",
        "\u{6dd}",
        "\u{70f}",
        "\u{890}",
        "\u{8e2}",
        "\u{180e}",
        "\u{200b}",
        "\u{202a}",
        "\u{2060}",
        "\u{2066}",
        "\u{feff}",
        "\u{fff9}",
        "\u{110bd}",
        "\u{110cd}",
        "\u{13430}",
        "\u{1bca0}",
        "\u{1d173}",
        "\u{e0001}",
        "\u{e0020}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Format}+$",
        "^\\p{gc=Format}+$",
        "^\\p{Format}+$",
        "^\\p{General_Category=Cf}+$",
        "^\\p{gc=Cf}+$",
        "^\\p{Cf}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_initialpunctuation() {
    test_with_configs(unicode_escape_property_gc_initialpunctuation_tc)
}

fn unicode_escape_property_gc_initialpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 11] = [
        "\u{ab}", "\u{2018}", "\u{201b}", "\u{201f}", "\u{2039}", "\u{2e02}", "\u{2e04}",
        "\u{2e09}", "\u{2e0c}", "\u{2e1c}", "\u{2e20}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Initial_Punctuation}+$",
        "^\\p{gc=Initial_Punctuation}+$",
        "^\\p{Initial_Punctuation}+$",
        "^\\p{General_Category=Pi}+$",
        "^\\p{gc=Pi}+$",
        "^\\p{Pi}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_letternumber() {
    test_with_configs(unicode_escape_property_gc_letternumber_tc)
}

fn unicode_escape_property_gc_letternumber_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 12] = [
        "\u{16ee}",
        "\u{2160}",
        "\u{2185}",
        "\u{3007}",
        "\u{3021}",
        "\u{3038}",
        "\u{a6e6}",
        "\u{10140}",
        "\u{10341}",
        "\u{1034a}",
        "\u{103d1}",
        "\u{12400}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Letter_Number}+$",
        "^\\p{gc=Letter_Number}+$",
        "^\\p{Letter_Number}+$",
        "^\\p{General_Category=Nl}+$",
        "^\\p{gc=Nl}+$",
        "^\\p{Nl}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_lineseparator() {
    test_with_configs(unicode_escape_property_gc_lineseparator_tc)
}

fn unicode_escape_property_gc_lineseparator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{2028}"];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Line_Separator}+$",
        "^\\p{gc=Line_Separator}+$",
        "^\\p{Line_Separator}+$",
        "^\\p{General_Category=Zl}+$",
        "^\\p{gc=Zl}+$",
        "^\\p{Zl}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_lowercaseletter() {
    test_with_configs(unicode_escape_property_gc_lowercaseletter_tc)
}

fn unicode_escape_property_gc_lowercaseletter_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 658] = [
        "\u{61}",
        "\u{b5}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1aa}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1c6}",
        "\u{1c9}",
        "\u{1cc}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f3}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{221}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{295}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{560}",
        "\u{10d0}",
        "\u{10fd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d00}",
        "\u{1d6b}",
        "\u{1d79}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1e9f}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1f90}",
        "\u{1fa0}",
        "\u{1fb0}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{210a}",
        "\u{210e}",
        "\u{2113}",
        "\u{212f}",
        "\u{2134}",
        "\u{2139}",
        "\u{213c}",
        "\u{2146}",
        "\u{214e}",
        "\u{2184}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c71}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a771}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a78e}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7af}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f6}",
        "\u{a7fa}",
        "\u{ab30}",
        "\u{ab60}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1d41a}",
        "\u{1d44e}",
        "\u{1d456}",
        "\u{1d482}",
        "\u{1d4b6}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d4ea}",
        "\u{1d51e}",
        "\u{1d552}",
        "\u{1d586}",
        "\u{1d5ba}",
        "\u{1d5ee}",
        "\u{1d622}",
        "\u{1d656}",
        "\u{1d68a}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7cb}",
        "\u{1df00}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e922}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Lowercase_Letter}+$",
        "^\\p{gc=Lowercase_Letter}+$",
        "^\\p{Lowercase_Letter}+$",
        "^\\p{General_Category=Ll}+$",
        "^\\p{gc=Ll}+$",
        "^\\p{Ll}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_mathsymbol() {
    test_with_configs(unicode_escape_property_gc_mathsymbol_tc)
}

fn unicode_escape_property_gc_mathsymbol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 64] = [
        "\u{2b}",
        "\u{3c}",
        "\u{7c}",
        "\u{7e}",
        "\u{ac}",
        "\u{b1}",
        "\u{d7}",
        "\u{f7}",
        "\u{3f6}",
        "\u{606}",
        "\u{2044}",
        "\u{2052}",
        "\u{207a}",
        "\u{208a}",
        "\u{2118}",
        "\u{2140}",
        "\u{214b}",
        "\u{2190}",
        "\u{219a}",
        "\u{21a0}",
        "\u{21a3}",
        "\u{21a6}",
        "\u{21ae}",
        "\u{21ce}",
        "\u{21d2}",
        "\u{21d4}",
        "\u{21f4}",
        "\u{2320}",
        "\u{237c}",
        "\u{239b}",
        "\u{23dc}",
        "\u{25b7}",
        "\u{25c1}",
        "\u{25f8}",
        "\u{266f}",
        "\u{27c0}",
        "\u{27c7}",
        "\u{27f0}",
        "\u{2900}",
        "\u{2999}",
        "\u{29dc}",
        "\u{29fe}",
        "\u{2b30}",
        "\u{2b47}",
        "\u{fb29}",
        "\u{fe62}",
        "\u{fe64}",
        "\u{ff0b}",
        "\u{ff1c}",
        "\u{ff5c}",
        "\u{ff5e}",
        "\u{ffe2}",
        "\u{ffe9}",
        "\u{1d6c1}",
        "\u{1d6db}",
        "\u{1d6fb}",
        "\u{1d715}",
        "\u{1d735}",
        "\u{1d74f}",
        "\u{1d76f}",
        "\u{1d789}",
        "\u{1d7a9}",
        "\u{1d7c3}",
        "\u{1eef0}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Math_Symbol}+$",
        "^\\p{gc=Math_Symbol}+$",
        "^\\p{Math_Symbol}+$",
        "^\\p{General_Category=Sm}+$",
        "^\\p{gc=Sm}+$",
        "^\\p{Sm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_modifierletter() {
    test_with_configs(unicode_escape_property_gc_modifierletter_tc)
}

fn unicode_escape_property_gc_modifierletter_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 71] = [
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{374}",
        "\u{37a}",
        "\u{559}",
        "\u{640}",
        "\u{6e5}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{81a}",
        "\u{824}",
        "\u{828}",
        "\u{8c9}",
        "\u{971}",
        "\u{e46}",
        "\u{ec6}",
        "\u{10fc}",
        "\u{17d7}",
        "\u{1843}",
        "\u{1aa7}",
        "\u{1c78}",
        "\u{1d2c}",
        "\u{1d78}",
        "\u{1d9b}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2c7c}",
        "\u{2d6f}",
        "\u{2e2f}",
        "\u{3005}",
        "\u{3031}",
        "\u{303b}",
        "\u{309d}",
        "\u{30fc}",
        "\u{a015}",
        "\u{a4f8}",
        "\u{a60c}",
        "\u{a67f}",
        "\u{a69c}",
        "\u{a717}",
        "\u{a770}",
        "\u{a788}",
        "\u{a7f2}",
        "\u{a7f8}",
        "\u{a9cf}",
        "\u{a9e6}",
        "\u{aa70}",
        "\u{aadd}",
        "\u{aaf3}",
        "\u{ab5c}",
        "\u{ab69}",
        "\u{ff70}",
        "\u{ff9e}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{16b40}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1e030}",
        "\u{1e137}",
        "\u{1e4eb}",
        "\u{1e94b}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Modifier_Letter}+$",
        "^\\p{gc=Modifier_Letter}+$",
        "^\\p{Modifier_Letter}+$",
        "^\\p{General_Category=Lm}+$",
        "^\\p{gc=Lm}+$",
        "^\\p{Lm}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_modifiersymbol() {
    test_with_configs(unicode_escape_property_gc_modifiersymbol_tc)
}

fn unicode_escape_property_gc_modifiersymbol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 31] = [
        "\u{5e}",
        "\u{60}",
        "\u{a8}",
        "\u{af}",
        "\u{b4}",
        "\u{b8}",
        "\u{2c2}",
        "\u{2d2}",
        "\u{2e5}",
        "\u{2ed}",
        "\u{2ef}",
        "\u{375}",
        "\u{384}",
        "\u{888}",
        "\u{1fbd}",
        "\u{1fbf}",
        "\u{1fcd}",
        "\u{1fdd}",
        "\u{1fed}",
        "\u{1ffd}",
        "\u{309b}",
        "\u{a700}",
        "\u{a720}",
        "\u{a789}",
        "\u{ab5b}",
        "\u{ab6a}",
        "\u{fbb2}",
        "\u{ff3e}",
        "\u{ff40}",
        "\u{ffe3}",
        "\u{1f3fb}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Modifier_Symbol}+$",
        "^\\p{gc=Modifier_Symbol}+$",
        "^\\p{Modifier_Symbol}+$",
        "^\\p{General_Category=Sk}+$",
        "^\\p{gc=Sk}+$",
        "^\\p{Sk}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_nonspacingmark() {
    test_with_configs(unicode_escape_property_gc_nonspacingmark_tc)
}

fn unicode_escape_property_gc_nonspacingmark_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 346] = [
        "\u{300}",
        "\u{483}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{610}",
        "\u{64b}",
        "\u{670}",
        "\u{6d6}",
        "\u{6df}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{711}",
        "\u{730}",
        "\u{7a6}",
        "\u{7eb}",
        "\u{7fd}",
        "\u{816}",
        "\u{81b}",
        "\u{825}",
        "\u{829}",
        "\u{859}",
        "\u{898}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{93a}",
        "\u{93c}",
        "\u{941}",
        "\u{94d}",
        "\u{951}",
        "\u{962}",
        "\u{981}",
        "\u{9bc}",
        "\u{9c1}",
        "\u{9cd}",
        "\u{9e2}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a3c}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a70}",
        "\u{a75}",
        "\u{a81}",
        "\u{abc}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{acd}",
        "\u{ae2}",
        "\u{afa}",
        "\u{b01}",
        "\u{b3c}",
        "\u{b3f}",
        "\u{b41}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b62}",
        "\u{b82}",
        "\u{bc0}",
        "\u{bcd}",
        "\u{c00}",
        "\u{c04}",
        "\u{c3c}",
        "\u{c3e}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c62}",
        "\u{c81}",
        "\u{cbc}",
        "\u{cbf}",
        "\u{cc6}",
        "\u{ccc}",
        "\u{ce2}",
        "\u{d00}",
        "\u{d3b}",
        "\u{d41}",
        "\u{d4d}",
        "\u{d62}",
        "\u{d81}",
        "\u{dca}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{e31}",
        "\u{e34}",
        "\u{e47}",
        "\u{eb1}",
        "\u{eb4}",
        "\u{ec8}",
        "\u{f18}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f71}",
        "\u{f80}",
        "\u{f86}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{102d}",
        "\u{1032}",
        "\u{1039}",
        "\u{103d}",
        "\u{1058}",
        "\u{105e}",
        "\u{1071}",
        "\u{1082}",
        "\u{1085}",
        "\u{108d}",
        "\u{109d}",
        "\u{135d}",
        "\u{1712}",
        "\u{1732}",
        "\u{1752}",
        "\u{1772}",
        "\u{17b4}",
        "\u{17b7}",
        "\u{17c6}",
        "\u{17c9}",
        "\u{17dd}",
        "\u{180b}",
        "\u{180f}",
        "\u{1885}",
        "\u{18a9}",
        "\u{1920}",
        "\u{1927}",
        "\u{1932}",
        "\u{1939}",
        "\u{1a17}",
        "\u{1a1b}",
        "\u{1a56}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a62}",
        "\u{1a65}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1ab0}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b34}",
        "\u{1b36}",
        "\u{1b3c}",
        "\u{1b42}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1ba2}",
        "\u{1ba8}",
        "\u{1bab}",
        "\u{1be6}",
        "\u{1be8}",
        "\u{1bed}",
        "\u{1bef}",
        "\u{1c2c}",
        "\u{1c36}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce2}",
        "\u{1ced}",
        "\u{1cf4}",
        "\u{1cf8}",
        "\u{1dc0}",
        "\u{20d0}",
        "\u{20e1}",
        "\u{20e5}",
        "\u{2cef}",
        "\u{2d7f}",
        "\u{2de0}",
        "\u{302a}",
        "\u{3099}",
        "\u{a66f}",
        "\u{a674}",
        "\u{a69e}",
        "\u{a6f0}",
        "\u{a802}",
        "\u{a806}",
        "\u{a80b}",
        "\u{a825}",
        "\u{a82c}",
        "\u{a8c4}",
        "\u{a8e0}",
        "\u{a8ff}",
        "\u{a926}",
        "\u{a947}",
        "\u{a980}",
        "\u{a9b3}",
        "\u{a9b6}",
        "\u{a9bc}",
        "\u{a9e5}",
        "\u{aa29}",
        "\u{aa31}",
        "\u{aa35}",
        "\u{aa43}",
        "\u{aa4c}",
        "\u{aa7c}",
        "\u{aab0}",
        "\u{aab2}",
        "\u{aab7}",
        "\u{aabe}",
        "\u{aac1}",
        "\u{aaec}",
        "\u{aaf6}",
        "\u{abe5}",
        "\u{abe8}",
        "\u{abed}",
        "\u{fb1e}",
        "\u{fe00}",
        "\u{fe20}",
        "\u{101fd}",
        "\u{102e0}",
        "\u{10376}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10ae5}",
        "\u{10d24}",
        "\u{10eab}",
        "\u{10efd}",
        "\u{10f46}",
        "\u{10f82}",
        "\u{11001}",
        "\u{11038}",
        "\u{11070}",
        "\u{11073}",
        "\u{1107f}",
        "\u{110b3}",
        "\u{110b9}",
        "\u{110c2}",
        "\u{11100}",
        "\u{11127}",
        "\u{1112d}",
        "\u{11173}",
        "\u{11180}",
        "\u{111b6}",
        "\u{111c9}",
        "\u{111cf}",
        "\u{1122f}",
        "\u{11234}",
        "\u{11236}",
        "\u{1123e}",
        "\u{11241}",
        "\u{112df}",
        "\u{112e3}",
        "\u{11300}",
        "\u{1133b}",
        "\u{11340}",
        "\u{11366}",
        "\u{11370}",
        "\u{11438}",
        "\u{11442}",
        "\u{11446}",
        "\u{1145e}",
        "\u{114b3}",
        "\u{114ba}",
        "\u{114bf}",
        "\u{114c2}",
        "\u{115b2}",
        "\u{115bc}",
        "\u{115bf}",
        "\u{115dc}",
        "\u{11633}",
        "\u{1163d}",
        "\u{1163f}",
        "\u{116ab}",
        "\u{116ad}",
        "\u{116b0}",
        "\u{116b7}",
        "\u{1171d}",
        "\u{11722}",
        "\u{11727}",
        "\u{1182f}",
        "\u{11839}",
        "\u{1193b}",
        "\u{1193e}",
        "\u{11943}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119e0}",
        "\u{11a01}",
        "\u{11a33}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a51}",
        "\u{11a59}",
        "\u{11a8a}",
        "\u{11a98}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3f}",
        "\u{11c92}",
        "\u{11caa}",
        "\u{11cb2}",
        "\u{11cb5}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d47}",
        "\u{11d90}",
        "\u{11d95}",
        "\u{11d97}",
        "\u{11ef3}",
        "\u{11f00}",
        "\u{11f36}",
        "\u{11f40}",
        "\u{11f42}",
        "\u{13440}",
        "\u{13447}",
        "\u{16af0}",
        "\u{16b30}",
        "\u{16f4f}",
        "\u{16f8f}",
        "\u{16fe4}",
        "\u{1bc9d}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d167}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e08f}",
        "\u{1e130}",
        "\u{1e2ae}",
        "\u{1e2ec}",
        "\u{1e4ec}",
        "\u{1e8d0}",
        "\u{1e944}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Nonspacing_Mark}+$",
        "^\\p{gc=Nonspacing_Mark}+$",
        "^\\p{Nonspacing_Mark}+$",
        "^\\p{General_Category=Mn}+$",
        "^\\p{gc=Mn}+$",
        "^\\p{Mn}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_openpunctuation() {
    test_with_configs(unicode_escape_property_gc_openpunctuation_tc)
}

fn unicode_escape_property_gc_openpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 79] = [
        "\u{28}", "\u{5b}", "\u{7b}", "\u{f3a}", "\u{f3c}", "\u{169b}", "\u{201a}", "\u{201e}",
        "\u{2045}", "\u{207d}", "\u{208d}", "\u{2308}", "\u{230a}", "\u{2329}", "\u{2768}",
        "\u{276a}", "\u{276c}", "\u{276e}", "\u{2770}", "\u{2772}", "\u{2774}", "\u{27c5}",
        "\u{27e6}", "\u{27e8}", "\u{27ea}", "\u{27ec}", "\u{27ee}", "\u{2983}", "\u{2985}",
        "\u{2987}", "\u{2989}", "\u{298b}", "\u{298d}", "\u{298f}", "\u{2991}", "\u{2993}",
        "\u{2995}", "\u{2997}", "\u{29d8}", "\u{29da}", "\u{29fc}", "\u{2e22}", "\u{2e24}",
        "\u{2e26}", "\u{2e28}", "\u{2e42}", "\u{2e55}", "\u{2e57}", "\u{2e59}", "\u{2e5b}",
        "\u{3008}", "\u{300a}", "\u{300c}", "\u{300e}", "\u{3010}", "\u{3014}", "\u{3016}",
        "\u{3018}", "\u{301a}", "\u{301d}", "\u{fd3f}", "\u{fe17}", "\u{fe35}", "\u{fe37}",
        "\u{fe39}", "\u{fe3b}", "\u{fe3d}", "\u{fe3f}", "\u{fe41}", "\u{fe43}", "\u{fe47}",
        "\u{fe59}", "\u{fe5b}", "\u{fe5d}", "\u{ff08}", "\u{ff3b}", "\u{ff5b}", "\u{ff5f}",
        "\u{ff62}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Open_Punctuation}+$",
        "^\\p{gc=Open_Punctuation}+$",
        "^\\p{Open_Punctuation}+$",
        "^\\p{General_Category=Ps}+$",
        "^\\p{gc=Ps}+$",
        "^\\p{Ps}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_otherletter() {
    test_with_configs(unicode_escape_property_gc_otherletter_tc)
}

fn unicode_escape_property_gc_otherletter_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 511] = [
        "\u{aa}",
        "\u{ba}",
        "\u{1bb}",
        "\u{1c0}",
        "\u{294}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{620}",
        "\u{641}",
        "\u{66e}",
        "\u{671}",
        "\u{6d5}",
        "\u{6ee}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{712}",
        "\u{74d}",
        "\u{7b1}",
        "\u{7ca}",
        "\u{800}",
        "\u{840}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{8a0}",
        "\u{904}",
        "\u{93d}",
        "\u{950}",
        "\u{958}",
        "\u{972}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9ce}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a72}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{af9}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b71}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bd0}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c80}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{cf1}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d5f}",
        "\u{d7a}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{e01}",
        "\u{e32}",
        "\u{e40}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb2}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{edc}",
        "\u{f00}",
        "\u{f40}",
        "\u{f49}",
        "\u{f88}",
        "\u{1000}",
        "\u{103f}",
        "\u{1050}",
        "\u{105a}",
        "\u{1061}",
        "\u{1065}",
        "\u{106e}",
        "\u{1075}",
        "\u{108e}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1380}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16f1}",
        "\u{1700}",
        "\u{171f}",
        "\u{1740}",
        "\u{1760}",
        "\u{176e}",
        "\u{1780}",
        "\u{17dc}",
        "\u{1820}",
        "\u{1844}",
        "\u{1880}",
        "\u{1887}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{1a00}",
        "\u{1a20}",
        "\u{1b05}",
        "\u{1b45}",
        "\u{1b83}",
        "\u{1bae}",
        "\u{1bba}",
        "\u{1c00}",
        "\u{1c4d}",
        "\u{1c5a}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cfa}",
        "\u{2135}",
        "\u{2d30}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{3006}",
        "\u{303c}",
        "\u{3041}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a500}",
        "\u{a610}",
        "\u{a62a}",
        "\u{a66e}",
        "\u{a6a0}",
        "\u{a78f}",
        "\u{a7f7}",
        "\u{a7fb}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80c}",
        "\u{a840}",
        "\u{a882}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a90a}",
        "\u{a930}",
        "\u{a960}",
        "\u{a984}",
        "\u{a9e0}",
        "\u{a9e7}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa40}",
        "\u{aa44}",
        "\u{aa60}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7e}",
        "\u{aab1}",
        "\u{aab5}",
        "\u{aab9}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aae0}",
        "\u{aaf2}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{abc0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff66}",
        "\u{ff71}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10280}",
        "\u{102a0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10342}",
        "\u{10350}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{10450}",
        "\u{10500}",
        "\u{10530}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10d00}",
        "\u{10e80}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f70}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11003}",
        "\u{11071}",
        "\u{11075}",
        "\u{11083}",
        "\u{110d0}",
        "\u{11103}",
        "\u{11144}",
        "\u{11147}",
        "\u{11150}",
        "\u{11176}",
        "\u{11183}",
        "\u{111c1}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1123f}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{11350}",
        "\u{1135d}",
        "\u{11400}",
        "\u{11447}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{11580}",
        "\u{115d8}",
        "\u{11600}",
        "\u{11644}",
        "\u{11680}",
        "\u{116b8}",
        "\u{11700}",
        "\u{11740}",
        "\u{11800}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{1193f}",
        "\u{11941}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{11a00}",
        "\u{11a0b}",
        "\u{11a3a}",
        "\u{11a50}",
        "\u{11a5c}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c40}",
        "\u{11c72}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d46}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d98}",
        "\u{11ee0}",
        "\u{11f02}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a70}",
        "\u{16ad0}",
        "\u{16b00}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16f00}",
        "\u{16f50}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1df0a}",
        "\u{1e100}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e4d0}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Other_Letter}+$",
        "^\\p{gc=Other_Letter}+$",
        "^\\p{Other_Letter}+$",
        "^\\p{General_Category=Lo}+$",
        "^\\p{gc=Lo}+$",
        "^\\p{Lo}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_othernumber() {
    test_with_configs(unicode_escape_property_gc_othernumber_tc)
}

fn unicode_escape_property_gc_othernumber_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 72] = [
        "\u{b2}",
        "\u{b9}",
        "\u{bc}",
        "\u{9f4}",
        "\u{b72}",
        "\u{bf0}",
        "\u{c78}",
        "\u{d58}",
        "\u{d70}",
        "\u{f2a}",
        "\u{1369}",
        "\u{17f0}",
        "\u{19da}",
        "\u{2070}",
        "\u{2074}",
        "\u{2080}",
        "\u{2150}",
        "\u{2189}",
        "\u{2460}",
        "\u{24ea}",
        "\u{2776}",
        "\u{2cfd}",
        "\u{3192}",
        "\u{3220}",
        "\u{3248}",
        "\u{3251}",
        "\u{3280}",
        "\u{32b1}",
        "\u{a830}",
        "\u{10107}",
        "\u{10175}",
        "\u{1018a}",
        "\u{102e1}",
        "\u{10320}",
        "\u{10858}",
        "\u{10879}",
        "\u{108a7}",
        "\u{108fb}",
        "\u{10916}",
        "\u{109bc}",
        "\u{109c0}",
        "\u{109d2}",
        "\u{10a40}",
        "\u{10a7d}",
        "\u{10a9d}",
        "\u{10aeb}",
        "\u{10b58}",
        "\u{10b78}",
        "\u{10ba9}",
        "\u{10cfa}",
        "\u{10e60}",
        "\u{10f1d}",
        "\u{10f51}",
        "\u{10fc5}",
        "\u{11052}",
        "\u{111e1}",
        "\u{1173a}",
        "\u{118ea}",
        "\u{11c5a}",
        "\u{11fc0}",
        "\u{16b5b}",
        "\u{16e80}",
        "\u{1d2c0}",
        "\u{1d2e0}",
        "\u{1d360}",
        "\u{1e8c7}",
        "\u{1ec71}",
        "\u{1ecad}",
        "\u{1ecb1}",
        "\u{1ed01}",
        "\u{1ed2f}",
        "\u{1f100}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Other_Number}+$",
        "^\\p{gc=Other_Number}+$",
        "^\\p{Other_Number}+$",
        "^\\p{General_Category=No}+$",
        "^\\p{gc=No}+$",
        "^\\p{No}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_otherpunctuation() {
    test_with_configs(unicode_escape_property_gc_otherpunctuation_tc)
}

fn unicode_escape_property_gc_otherpunctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 187] = [
        "\u{21}",
        "\u{25}",
        "\u{2a}",
        "\u{2c}",
        "\u{2e}",
        "\u{3a}",
        "\u{3f}",
        "\u{5c}",
        "\u{a1}",
        "\u{a7}",
        "\u{b6}",
        "\u{bf}",
        "\u{37e}",
        "\u{387}",
        "\u{55a}",
        "\u{589}",
        "\u{5c0}",
        "\u{5c3}",
        "\u{5c6}",
        "\u{5f3}",
        "\u{609}",
        "\u{60c}",
        "\u{61b}",
        "\u{61d}",
        "\u{66a}",
        "\u{6d4}",
        "\u{700}",
        "\u{7f7}",
        "\u{830}",
        "\u{85e}",
        "\u{964}",
        "\u{970}",
        "\u{9fd}",
        "\u{a76}",
        "\u{af0}",
        "\u{c77}",
        "\u{c84}",
        "\u{df4}",
        "\u{e4f}",
        "\u{e5a}",
        "\u{f04}",
        "\u{f14}",
        "\u{f85}",
        "\u{fd0}",
        "\u{fd9}",
        "\u{104a}",
        "\u{10fb}",
        "\u{1360}",
        "\u{166e}",
        "\u{16eb}",
        "\u{1735}",
        "\u{17d4}",
        "\u{17d8}",
        "\u{1800}",
        "\u{1807}",
        "\u{1944}",
        "\u{1a1e}",
        "\u{1aa0}",
        "\u{1aa8}",
        "\u{1b5a}",
        "\u{1b7d}",
        "\u{1bfc}",
        "\u{1c3b}",
        "\u{1c7e}",
        "\u{1cc0}",
        "\u{1cd3}",
        "\u{2016}",
        "\u{2020}",
        "\u{2030}",
        "\u{203b}",
        "\u{2041}",
        "\u{2047}",
        "\u{2053}",
        "\u{2055}",
        "\u{2cf9}",
        "\u{2cfe}",
        "\u{2d70}",
        "\u{2e00}",
        "\u{2e06}",
        "\u{2e0b}",
        "\u{2e0e}",
        "\u{2e18}",
        "\u{2e1b}",
        "\u{2e1e}",
        "\u{2e2a}",
        "\u{2e30}",
        "\u{2e3c}",
        "\u{2e41}",
        "\u{2e43}",
        "\u{2e52}",
        "\u{3001}",
        "\u{303d}",
        "\u{30fb}",
        "\u{a4fe}",
        "\u{a60d}",
        "\u{a673}",
        "\u{a67e}",
        "\u{a6f2}",
        "\u{a874}",
        "\u{a8ce}",
        "\u{a8f8}",
        "\u{a8fc}",
        "\u{a92e}",
        "\u{a95f}",
        "\u{a9c1}",
        "\u{a9de}",
        "\u{aa5c}",
        "\u{aade}",
        "\u{aaf0}",
        "\u{abeb}",
        "\u{fe10}",
        "\u{fe19}",
        "\u{fe30}",
        "\u{fe45}",
        "\u{fe49}",
        "\u{fe50}",
        "\u{fe54}",
        "\u{fe5f}",
        "\u{fe68}",
        "\u{fe6a}",
        "\u{ff01}",
        "\u{ff05}",
        "\u{ff0a}",
        "\u{ff0c}",
        "\u{ff0e}",
        "\u{ff1a}",
        "\u{ff1f}",
        "\u{ff3c}",
        "\u{ff61}",
        "\u{ff64}",
        "\u{10100}",
        "\u{1039f}",
        "\u{103d0}",
        "\u{1056f}",
        "\u{10857}",
        "\u{1091f}",
        "\u{1093f}",
        "\u{10a50}",
        "\u{10a7f}",
        "\u{10af0}",
        "\u{10b39}",
        "\u{10b99}",
        "\u{10f55}",
        "\u{10f86}",
        "\u{11047}",
        "\u{110bb}",
        "\u{110be}",
        "\u{11140}",
        "\u{11174}",
        "\u{111c5}",
        "\u{111cd}",
        "\u{111db}",
        "\u{111dd}",
        "\u{11238}",
        "\u{112a9}",
        "\u{1144b}",
        "\u{1145a}",
        "\u{1145d}",
        "\u{114c6}",
        "\u{115c1}",
        "\u{11641}",
        "\u{11660}",
        "\u{116b9}",
        "\u{1173c}",
        "\u{1183b}",
        "\u{11944}",
        "\u{119e2}",
        "\u{11a3f}",
        "\u{11a9a}",
        "\u{11a9e}",
        "\u{11b00}",
        "\u{11c41}",
        "\u{11c70}",
        "\u{11ef7}",
        "\u{11f43}",
        "\u{11fff}",
        "\u{12470}",
        "\u{12ff1}",
        "\u{16a6e}",
        "\u{16af5}",
        "\u{16b37}",
        "\u{16b44}",
        "\u{16e97}",
        "\u{16fe2}",
        "\u{1bc9f}",
        "\u{1da87}",
        "\u{1e95e}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Other_Punctuation}+$",
        "^\\p{gc=Other_Punctuation}+$",
        "^\\p{Other_Punctuation}+$",
        "^\\p{General_Category=Po}+$",
        "^\\p{gc=Po}+$",
        "^\\p{Po}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_othersymbol() {
    test_with_configs(unicode_escape_property_gc_othersymbol_tc)
}

fn unicode_escape_property_gc_othersymbol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 185] = [
        "\u{a6}",
        "\u{a9}",
        "\u{ae}",
        "\u{b0}",
        "\u{482}",
        "\u{58d}",
        "\u{60e}",
        "\u{6de}",
        "\u{6e9}",
        "\u{6fd}",
        "\u{7f6}",
        "\u{9fa}",
        "\u{b70}",
        "\u{bf3}",
        "\u{bfa}",
        "\u{c7f}",
        "\u{d4f}",
        "\u{d79}",
        "\u{f01}",
        "\u{f13}",
        "\u{f15}",
        "\u{f1a}",
        "\u{f34}",
        "\u{f36}",
        "\u{f38}",
        "\u{fbe}",
        "\u{fc7}",
        "\u{fce}",
        "\u{fd5}",
        "\u{109e}",
        "\u{1390}",
        "\u{166d}",
        "\u{1940}",
        "\u{19de}",
        "\u{1b61}",
        "\u{1b74}",
        "\u{2100}",
        "\u{2103}",
        "\u{2108}",
        "\u{2114}",
        "\u{2116}",
        "\u{211e}",
        "\u{2125}",
        "\u{2127}",
        "\u{2129}",
        "\u{212e}",
        "\u{213a}",
        "\u{214a}",
        "\u{214c}",
        "\u{214f}",
        "\u{218a}",
        "\u{2195}",
        "\u{219c}",
        "\u{21a1}",
        "\u{21a4}",
        "\u{21a7}",
        "\u{21af}",
        "\u{21d0}",
        "\u{21d3}",
        "\u{21d5}",
        "\u{2300}",
        "\u{230c}",
        "\u{2322}",
        "\u{232b}",
        "\u{237d}",
        "\u{23b4}",
        "\u{23e2}",
        "\u{2440}",
        "\u{249c}",
        "\u{2500}",
        "\u{25b8}",
        "\u{25c2}",
        "\u{2600}",
        "\u{2670}",
        "\u{2794}",
        "\u{2800}",
        "\u{2b00}",
        "\u{2b45}",
        "\u{2b4d}",
        "\u{2b76}",
        "\u{2b97}",
        "\u{2ce5}",
        "\u{2e50}",
        "\u{2e80}",
        "\u{2e9b}",
        "\u{2f00}",
        "\u{2ff0}",
        "\u{3004}",
        "\u{3012}",
        "\u{3020}",
        "\u{3036}",
        "\u{303e}",
        "\u{3190}",
        "\u{3196}",
        "\u{31c0}",
        "\u{31ef}",
        "\u{3200}",
        "\u{322a}",
        "\u{3250}",
        "\u{3260}",
        "\u{328a}",
        "\u{32c0}",
        "\u{4dc0}",
        "\u{a490}",
        "\u{a828}",
        "\u{a836}",
        "\u{a839}",
        "\u{aa77}",
        "\u{fd40}",
        "\u{fdcf}",
        "\u{fdfd}",
        "\u{ffe4}",
        "\u{ffe8}",
        "\u{ffed}",
        "\u{fffc}",
        "\u{10137}",
        "\u{10179}",
        "\u{1018c}",
        "\u{10190}",
        "\u{101a0}",
        "\u{101d0}",
        "\u{10877}",
        "\u{10ac8}",
        "\u{1173f}",
        "\u{11fd5}",
        "\u{11fe1}",
        "\u{16b3c}",
        "\u{16b45}",
        "\u{1bc9c}",
        "\u{1cf50}",
        "\u{1d000}",
        "\u{1d100}",
        "\u{1d129}",
        "\u{1d16a}",
        "\u{1d183}",
        "\u{1d18c}",
        "\u{1d1ae}",
        "\u{1d200}",
        "\u{1d245}",
        "\u{1d300}",
        "\u{1d800}",
        "\u{1da37}",
        "\u{1da6d}",
        "\u{1da76}",
        "\u{1da85}",
        "\u{1e14f}",
        "\u{1ecac}",
        "\u{1ed2e}",
        "\u{1f000}",
        "\u{1f030}",
        "\u{1f0a0}",
        "\u{1f0b1}",
        "\u{1f0c1}",
        "\u{1f0d1}",
        "\u{1f10d}",
        "\u{1f1e6}",
        "\u{1f210}",
        "\u{1f240}",
        "\u{1f250}",
        "\u{1f260}",
        "\u{1f300}",
        "\u{1f400}",
        "\u{1f6dc}",
        "\u{1f6f0}",
        "\u{1f700}",
        "\u{1f77b}",
        "\u{1f7e0}",
        "\u{1f7f0}",
        "\u{1f800}",
        "\u{1f810}",
        "\u{1f850}",
        "\u{1f860}",
        "\u{1f890}",
        "\u{1f8b0}",
        "\u{1f900}",
        "\u{1fa60}",
        "\u{1fa70}",
        "\u{1fa80}",
        "\u{1fa90}",
        "\u{1fabf}",
        "\u{1face}",
        "\u{1fae0}",
        "\u{1faf0}",
        "\u{1fb00}",
        "\u{1fb94}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Other_Symbol}+$",
        "^\\p{gc=Other_Symbol}+$",
        "^\\p{Other_Symbol}+$",
        "^\\p{General_Category=So}+$",
        "^\\p{gc=So}+$",
        "^\\p{So}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_paragraphseparator() {
    test_with_configs(unicode_escape_property_gc_paragraphseparator_tc)
}

fn unicode_escape_property_gc_paragraphseparator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 1] = ["\u{2029}"];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Paragraph_Separator}+$",
        "^\\p{gc=Paragraph_Separator}+$",
        "^\\p{Paragraph_Separator}+$",
        "^\\p{General_Category=Zp}+$",
        "^\\p{gc=Zp}+$",
        "^\\p{Zp}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_privateuse() {
    test_with_configs(unicode_escape_property_gc_privateuse_tc)
}

fn unicode_escape_property_gc_privateuse_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 3] = ["\u{e000}", "\u{f0000}", "\u{100000}"];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Private_Use}+$",
        "^\\p{gc=Private_Use}+$",
        "^\\p{Private_Use}+$",
        "^\\p{General_Category=Co}+$",
        "^\\p{gc=Co}+$",
        "^\\p{Co}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_spaceseparator() {
    test_with_configs(unicode_escape_property_gc_spaceseparator_tc)
}

fn unicode_escape_property_gc_spaceseparator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 7] = [
        "\u{20}", "\u{a0}", "\u{1680}", "\u{2000}", "\u{202f}", "\u{205f}", "\u{3000}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Space_Separator}+$",
        "^\\p{gc=Space_Separator}+$",
        "^\\p{Space_Separator}+$",
        "^\\p{General_Category=Zs}+$",
        "^\\p{gc=Zs}+$",
        "^\\p{Zs}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_spacingmark() {
    test_with_configs(unicode_escape_property_gc_spacingmark_tc)
}

fn unicode_escape_property_gc_spacingmark_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 182] = [
        "\u{903}",
        "\u{93b}",
        "\u{93e}",
        "\u{949}",
        "\u{94e}",
        "\u{982}",
        "\u{9be}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9d7}",
        "\u{a03}",
        "\u{a3e}",
        "\u{a83}",
        "\u{abe}",
        "\u{ac9}",
        "\u{acb}",
        "\u{b02}",
        "\u{b3e}",
        "\u{b40}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b57}",
        "\u{bbe}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bd7}",
        "\u{c01}",
        "\u{c41}",
        "\u{c82}",
        "\u{cbe}",
        "\u{cc0}",
        "\u{cc7}",
        "\u{cca}",
        "\u{cd5}",
        "\u{cf3}",
        "\u{d02}",
        "\u{d3e}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d57}",
        "\u{d82}",
        "\u{dcf}",
        "\u{dd8}",
        "\u{df2}",
        "\u{f3e}",
        "\u{f7f}",
        "\u{102b}",
        "\u{1031}",
        "\u{1038}",
        "\u{103b}",
        "\u{1056}",
        "\u{1062}",
        "\u{1067}",
        "\u{1083}",
        "\u{1087}",
        "\u{108f}",
        "\u{109a}",
        "\u{1715}",
        "\u{1734}",
        "\u{17b6}",
        "\u{17be}",
        "\u{17c7}",
        "\u{1923}",
        "\u{1929}",
        "\u{1930}",
        "\u{1933}",
        "\u{1a19}",
        "\u{1a55}",
        "\u{1a57}",
        "\u{1a61}",
        "\u{1a63}",
        "\u{1a6d}",
        "\u{1b04}",
        "\u{1b35}",
        "\u{1b3b}",
        "\u{1b3d}",
        "\u{1b43}",
        "\u{1b82}",
        "\u{1ba1}",
        "\u{1ba6}",
        "\u{1baa}",
        "\u{1be7}",
        "\u{1bea}",
        "\u{1bee}",
        "\u{1bf2}",
        "\u{1c24}",
        "\u{1c34}",
        "\u{1ce1}",
        "\u{1cf7}",
        "\u{302e}",
        "\u{a823}",
        "\u{a827}",
        "\u{a880}",
        "\u{a8b4}",
        "\u{a952}",
        "\u{a983}",
        "\u{a9b4}",
        "\u{a9ba}",
        "\u{a9be}",
        "\u{aa2f}",
        "\u{aa33}",
        "\u{aa4d}",
        "\u{aa7b}",
        "\u{aa7d}",
        "\u{aaeb}",
        "\u{aaee}",
        "\u{aaf5}",
        "\u{abe3}",
        "\u{abe6}",
        "\u{abe9}",
        "\u{abec}",
        "\u{11000}",
        "\u{11002}",
        "\u{11082}",
        "\u{110b0}",
        "\u{110b7}",
        "\u{1112c}",
        "\u{11145}",
        "\u{11182}",
        "\u{111b3}",
        "\u{111bf}",
        "\u{111ce}",
        "\u{1122c}",
        "\u{11232}",
        "\u{11235}",
        "\u{112e0}",
        "\u{11302}",
        "\u{1133e}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11357}",
        "\u{11362}",
        "\u{11435}",
        "\u{11440}",
        "\u{11445}",
        "\u{114b0}",
        "\u{114b9}",
        "\u{114bb}",
        "\u{114c1}",
        "\u{115af}",
        "\u{115b8}",
        "\u{115be}",
        "\u{11630}",
        "\u{1163b}",
        "\u{1163e}",
        "\u{116ac}",
        "\u{116ae}",
        "\u{116b6}",
        "\u{11720}",
        "\u{11726}",
        "\u{1182c}",
        "\u{11838}",
        "\u{11930}",
        "\u{11937}",
        "\u{1193d}",
        "\u{11940}",
        "\u{11942}",
        "\u{119d1}",
        "\u{119dc}",
        "\u{119e4}",
        "\u{11a39}",
        "\u{11a57}",
        "\u{11a97}",
        "\u{11c2f}",
        "\u{11c3e}",
        "\u{11ca9}",
        "\u{11cb1}",
        "\u{11cb4}",
        "\u{11d8a}",
        "\u{11d93}",
        "\u{11d96}",
        "\u{11ef5}",
        "\u{11f03}",
        "\u{11f34}",
        "\u{11f3e}",
        "\u{11f41}",
        "\u{16f51}",
        "\u{16ff0}",
        "\u{1d165}",
        "\u{1d16d}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Spacing_Mark}+$",
        "^\\p{gc=Spacing_Mark}+$",
        "^\\p{Spacing_Mark}+$",
        "^\\p{General_Category=Mc}+$",
        "^\\p{gc=Mc}+$",
        "^\\p{Mc}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_titlecaseletter() {
    test_with_configs(unicode_escape_property_gc_titlecaseletter_tc)
}

fn unicode_escape_property_gc_titlecaseletter_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 10] = [
        "\u{1c5}", "\u{1c8}", "\u{1cb}", "\u{1f2}", "\u{1f88}", "\u{1f98}", "\u{1fa8}", "\u{1fbc}",
        "\u{1fcc}", "\u{1ffc}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Titlecase_Letter}+$",
        "^\\p{gc=Titlecase_Letter}+$",
        "^\\p{Titlecase_Letter}+$",
        "^\\p{General_Category=Lt}+$",
        "^\\p{gc=Lt}+$",
        "^\\p{Lt}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_unassigned() {
    test_with_configs(unicode_escape_property_gc_unassigned_tc)
}

fn unicode_escape_property_gc_unassigned_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 707] = [
        "\u{378}",
        "\u{380}",
        "\u{38b}",
        "\u{38d}",
        "\u{3a2}",
        "\u{530}",
        "\u{557}",
        "\u{58b}",
        "\u{590}",
        "\u{5c8}",
        "\u{5eb}",
        "\u{5f5}",
        "\u{70e}",
        "\u{74b}",
        "\u{7b2}",
        "\u{7fb}",
        "\u{82e}",
        "\u{83f}",
        "\u{85c}",
        "\u{85f}",
        "\u{86b}",
        "\u{88f}",
        "\u{892}",
        "\u{984}",
        "\u{98d}",
        "\u{991}",
        "\u{9a9}",
        "\u{9b1}",
        "\u{9b3}",
        "\u{9ba}",
        "\u{9c5}",
        "\u{9c9}",
        "\u{9cf}",
        "\u{9d8}",
        "\u{9de}",
        "\u{9e4}",
        "\u{9ff}",
        "\u{a04}",
        "\u{a0b}",
        "\u{a11}",
        "\u{a29}",
        "\u{a31}",
        "\u{a34}",
        "\u{a37}",
        "\u{a3a}",
        "\u{a3d}",
        "\u{a43}",
        "\u{a49}",
        "\u{a4e}",
        "\u{a52}",
        "\u{a5d}",
        "\u{a5f}",
        "\u{a77}",
        "\u{a84}",
        "\u{a8e}",
        "\u{a92}",
        "\u{aa9}",
        "\u{ab1}",
        "\u{ab4}",
        "\u{aba}",
        "\u{ac6}",
        "\u{aca}",
        "\u{ace}",
        "\u{ad1}",
        "\u{ae4}",
        "\u{af2}",
        "\u{b00}",
        "\u{b04}",
        "\u{b0d}",
        "\u{b11}",
        "\u{b29}",
        "\u{b31}",
        "\u{b34}",
        "\u{b3a}",
        "\u{b45}",
        "\u{b49}",
        "\u{b4e}",
        "\u{b58}",
        "\u{b5e}",
        "\u{b64}",
        "\u{b78}",
        "\u{b84}",
        "\u{b8b}",
        "\u{b91}",
        "\u{b96}",
        "\u{b9b}",
        "\u{b9d}",
        "\u{ba0}",
        "\u{ba5}",
        "\u{bab}",
        "\u{bba}",
        "\u{bc3}",
        "\u{bc9}",
        "\u{bce}",
        "\u{bd1}",
        "\u{bd8}",
        "\u{bfb}",
        "\u{c0d}",
        "\u{c11}",
        "\u{c29}",
        "\u{c3a}",
        "\u{c45}",
        "\u{c49}",
        "\u{c4e}",
        "\u{c57}",
        "\u{c5b}",
        "\u{c5e}",
        "\u{c64}",
        "\u{c70}",
        "\u{c8d}",
        "\u{c91}",
        "\u{ca9}",
        "\u{cb4}",
        "\u{cba}",
        "\u{cc5}",
        "\u{cc9}",
        "\u{cce}",
        "\u{cd7}",
        "\u{cdf}",
        "\u{ce4}",
        "\u{cf0}",
        "\u{cf4}",
        "\u{d0d}",
        "\u{d11}",
        "\u{d45}",
        "\u{d49}",
        "\u{d50}",
        "\u{d64}",
        "\u{d80}",
        "\u{d84}",
        "\u{d97}",
        "\u{db2}",
        "\u{dbc}",
        "\u{dbe}",
        "\u{dc7}",
        "\u{dcb}",
        "\u{dd5}",
        "\u{dd7}",
        "\u{de0}",
        "\u{df0}",
        "\u{df5}",
        "\u{e3b}",
        "\u{e5c}",
        "\u{e83}",
        "\u{e85}",
        "\u{e8b}",
        "\u{ea4}",
        "\u{ea6}",
        "\u{ebe}",
        "\u{ec5}",
        "\u{ec7}",
        "\u{ecf}",
        "\u{eda}",
        "\u{ee0}",
        "\u{f48}",
        "\u{f6d}",
        "\u{f98}",
        "\u{fbd}",
        "\u{fcd}",
        "\u{fdb}",
        "\u{10c6}",
        "\u{10c8}",
        "\u{10ce}",
        "\u{1249}",
        "\u{124e}",
        "\u{1257}",
        "\u{1259}",
        "\u{125e}",
        "\u{1289}",
        "\u{128e}",
        "\u{12b1}",
        "\u{12b6}",
        "\u{12bf}",
        "\u{12c1}",
        "\u{12c6}",
        "\u{12d7}",
        "\u{1311}",
        "\u{1316}",
        "\u{135b}",
        "\u{137d}",
        "\u{139a}",
        "\u{13f6}",
        "\u{13fe}",
        "\u{169d}",
        "\u{16f9}",
        "\u{1716}",
        "\u{1737}",
        "\u{1754}",
        "\u{176d}",
        "\u{1771}",
        "\u{1774}",
        "\u{17de}",
        "\u{17ea}",
        "\u{17fa}",
        "\u{181a}",
        "\u{1879}",
        "\u{18ab}",
        "\u{18f6}",
        "\u{191f}",
        "\u{192c}",
        "\u{193c}",
        "\u{1941}",
        "\u{196e}",
        "\u{1975}",
        "\u{19ac}",
        "\u{19ca}",
        "\u{19db}",
        "\u{1a1c}",
        "\u{1a5f}",
        "\u{1a7d}",
        "\u{1a8a}",
        "\u{1a9a}",
        "\u{1aae}",
        "\u{1acf}",
        "\u{1b4d}",
        "\u{1b7f}",
        "\u{1bf4}",
        "\u{1c38}",
        "\u{1c4a}",
        "\u{1c89}",
        "\u{1cbb}",
        "\u{1cc8}",
        "\u{1cfb}",
        "\u{1f16}",
        "\u{1f1e}",
        "\u{1f46}",
        "\u{1f4e}",
        "\u{1f58}",
        "\u{1f5a}",
        "\u{1f5c}",
        "\u{1f5e}",
        "\u{1f7e}",
        "\u{1fb5}",
        "\u{1fc5}",
        "\u{1fd4}",
        "\u{1fdc}",
        "\u{1ff0}",
        "\u{1ff5}",
        "\u{1fff}",
        "\u{2065}",
        "\u{2072}",
        "\u{208f}",
        "\u{209d}",
        "\u{20c1}",
        "\u{20f1}",
        "\u{218c}",
        "\u{2427}",
        "\u{244b}",
        "\u{2b74}",
        "\u{2b96}",
        "\u{2cf4}",
        "\u{2d26}",
        "\u{2d28}",
        "\u{2d2e}",
        "\u{2d68}",
        "\u{2d71}",
        "\u{2d97}",
        "\u{2da7}",
        "\u{2daf}",
        "\u{2db7}",
        "\u{2dbf}",
        "\u{2dc7}",
        "\u{2dcf}",
        "\u{2dd7}",
        "\u{2ddf}",
        "\u{2e5e}",
        "\u{2e9a}",
        "\u{2ef4}",
        "\u{2fd6}",
        "\u{3040}",
        "\u{3097}",
        "\u{3100}",
        "\u{3130}",
        "\u{318f}",
        "\u{31e4}",
        "\u{321f}",
        "\u{a48d}",
        "\u{a4c7}",
        "\u{a62c}",
        "\u{a6f8}",
        "\u{a7cb}",
        "\u{a7d2}",
        "\u{a7d4}",
        "\u{a7da}",
        "\u{a82d}",
        "\u{a83a}",
        "\u{a878}",
        "\u{a8c6}",
        "\u{a8da}",
        "\u{a954}",
        "\u{a97d}",
        "\u{a9ce}",
        "\u{a9da}",
        "\u{a9ff}",
        "\u{aa37}",
        "\u{aa4e}",
        "\u{aa5a}",
        "\u{aac3}",
        "\u{aaf7}",
        "\u{ab07}",
        "\u{ab0f}",
        "\u{ab17}",
        "\u{ab27}",
        "\u{ab2f}",
        "\u{ab6c}",
        "\u{abee}",
        "\u{abfa}",
        "\u{d7a4}",
        "\u{d7c7}",
        "\u{d7fc}",
        "\u{fa6e}",
        "\u{fada}",
        "\u{fb07}",
        "\u{fb18}",
        "\u{fb37}",
        "\u{fb3d}",
        "\u{fb3f}",
        "\u{fb42}",
        "\u{fb45}",
        "\u{fbc3}",
        "\u{fd90}",
        "\u{fdc8}",
        "\u{fdd0}",
        "\u{fe1a}",
        "\u{fe53}",
        "\u{fe67}",
        "\u{fe6c}",
        "\u{fe75}",
        "\u{fefd}",
        "\u{ff00}",
        "\u{ffbf}",
        "\u{ffc8}",
        "\u{ffd0}",
        "\u{ffd8}",
        "\u{ffdd}",
        "\u{ffe7}",
        "\u{ffef}",
        "\u{fffe}",
        "\u{1000c}",
        "\u{10027}",
        "\u{1003b}",
        "\u{1003e}",
        "\u{1004e}",
        "\u{1005e}",
        "\u{100fb}",
        "\u{10103}",
        "\u{10134}",
        "\u{1018f}",
        "\u{1019d}",
        "\u{101a1}",
        "\u{101fe}",
        "\u{1029d}",
        "\u{102d1}",
        "\u{102fc}",
        "\u{10324}",
        "\u{1034b}",
        "\u{1037b}",
        "\u{1039e}",
        "\u{103c4}",
        "\u{103d6}",
        "\u{1049e}",
        "\u{104aa}",
        "\u{104d4}",
        "\u{104fc}",
        "\u{10528}",
        "\u{10564}",
        "\u{1057b}",
        "\u{1058b}",
        "\u{10593}",
        "\u{10596}",
        "\u{105a2}",
        "\u{105b2}",
        "\u{105ba}",
        "\u{105bd}",
        "\u{10737}",
        "\u{10756}",
        "\u{10768}",
        "\u{10786}",
        "\u{107b1}",
        "\u{107bb}",
        "\u{10806}",
        "\u{10809}",
        "\u{10836}",
        "\u{10839}",
        "\u{1083d}",
        "\u{10856}",
        "\u{1089f}",
        "\u{108b0}",
        "\u{108f3}",
        "\u{108f6}",
        "\u{1091c}",
        "\u{1093a}",
        "\u{10940}",
        "\u{109b8}",
        "\u{109d0}",
        "\u{10a04}",
        "\u{10a07}",
        "\u{10a14}",
        "\u{10a18}",
        "\u{10a36}",
        "\u{10a3b}",
        "\u{10a49}",
        "\u{10a59}",
        "\u{10aa0}",
        "\u{10ae7}",
        "\u{10af7}",
        "\u{10b36}",
        "\u{10b56}",
        "\u{10b73}",
        "\u{10b92}",
        "\u{10b9d}",
        "\u{10bb0}",
        "\u{10c49}",
        "\u{10cb3}",
        "\u{10cf3}",
        "\u{10d28}",
        "\u{10d3a}",
        "\u{10e7f}",
        "\u{10eaa}",
        "\u{10eae}",
        "\u{10eb2}",
        "\u{10f28}",
        "\u{10f5a}",
        "\u{10f8a}",
        "\u{10fcc}",
        "\u{10ff7}",
        "\u{1104e}",
        "\u{11076}",
        "\u{110c3}",
        "\u{110ce}",
        "\u{110e9}",
        "\u{110fa}",
        "\u{11135}",
        "\u{11148}",
        "\u{11177}",
        "\u{111e0}",
        "\u{111f5}",
        "\u{11212}",
        "\u{11242}",
        "\u{11287}",
        "\u{11289}",
        "\u{1128e}",
        "\u{1129e}",
        "\u{112aa}",
        "\u{112eb}",
        "\u{112fa}",
        "\u{11304}",
        "\u{1130d}",
        "\u{11311}",
        "\u{11329}",
        "\u{11331}",
        "\u{11334}",
        "\u{1133a}",
        "\u{11345}",
        "\u{11349}",
        "\u{1134e}",
        "\u{11351}",
        "\u{11358}",
        "\u{11364}",
        "\u{1136d}",
        "\u{11375}",
        "\u{1145c}",
        "\u{11462}",
        "\u{114c8}",
        "\u{114da}",
        "\u{115b6}",
        "\u{115de}",
        "\u{11645}",
        "\u{1165a}",
        "\u{1166d}",
        "\u{116ba}",
        "\u{116ca}",
        "\u{1171b}",
        "\u{1172c}",
        "\u{11747}",
        "\u{1183c}",
        "\u{118f3}",
        "\u{11907}",
        "\u{1190a}",
        "\u{11914}",
        "\u{11917}",
        "\u{11936}",
        "\u{11939}",
        "\u{11947}",
        "\u{1195a}",
        "\u{119a8}",
        "\u{119d8}",
        "\u{119e5}",
        "\u{11a48}",
        "\u{11aa3}",
        "\u{11af9}",
        "\u{11b0a}",
        "\u{11c09}",
        "\u{11c37}",
        "\u{11c46}",
        "\u{11c6d}",
        "\u{11c90}",
        "\u{11ca8}",
        "\u{11cb7}",
        "\u{11d07}",
        "\u{11d0a}",
        "\u{11d37}",
        "\u{11d3b}",
        "\u{11d3e}",
        "\u{11d48}",
        "\u{11d5a}",
        "\u{11d66}",
        "\u{11d69}",
        "\u{11d8f}",
        "\u{11d92}",
        "\u{11d99}",
        "\u{11daa}",
        "\u{11ef9}",
        "\u{11f11}",
        "\u{11f3b}",
        "\u{11f5a}",
        "\u{11fb1}",
        "\u{11ff2}",
        "\u{1239a}",
        "\u{1246f}",
        "\u{12475}",
        "\u{12544}",
        "\u{12ff3}",
        "\u{13456}",
        "\u{14647}",
        "\u{16a39}",
        "\u{16a5f}",
        "\u{16a6a}",
        "\u{16abf}",
        "\u{16aca}",
        "\u{16aee}",
        "\u{16af6}",
        "\u{16b46}",
        "\u{16b5a}",
        "\u{16b62}",
        "\u{16b78}",
        "\u{16b90}",
        "\u{16e9b}",
        "\u{16f4b}",
        "\u{16f88}",
        "\u{16fa0}",
        "\u{16fe5}",
        "\u{16ff2}",
        "\u{187f8}",
        "\u{18cd6}",
        "\u{18d09}",
        "\u{1aff4}",
        "\u{1affc}",
        "\u{1afff}",
        "\u{1b123}",
        "\u{1b133}",
        "\u{1b153}",
        "\u{1b156}",
        "\u{1b168}",
        "\u{1b2fc}",
        "\u{1bc6b}",
        "\u{1bc7d}",
        "\u{1bc89}",
        "\u{1bc9a}",
        "\u{1bca4}",
        "\u{1cf2e}",
        "\u{1cf47}",
        "\u{1cfc4}",
        "\u{1d0f6}",
        "\u{1d127}",
        "\u{1d1eb}",
        "\u{1d246}",
        "\u{1d2d4}",
        "\u{1d2f4}",
        "\u{1d357}",
        "\u{1d379}",
        "\u{1d455}",
        "\u{1d49d}",
        "\u{1d4a0}",
        "\u{1d4a3}",
        "\u{1d4a7}",
        "\u{1d4ad}",
        "\u{1d4ba}",
        "\u{1d4bc}",
        "\u{1d4c4}",
        "\u{1d506}",
        "\u{1d50b}",
        "\u{1d515}",
        "\u{1d51d}",
        "\u{1d53a}",
        "\u{1d53f}",
        "\u{1d545}",
        "\u{1d547}",
        "\u{1d551}",
        "\u{1d6a6}",
        "\u{1d7cc}",
        "\u{1da8c}",
        "\u{1daa0}",
        "\u{1dab0}",
        "\u{1df1f}",
        "\u{1df2b}",
        "\u{1e007}",
        "\u{1e019}",
        "\u{1e022}",
        "\u{1e025}",
        "\u{1e02b}",
        "\u{1e06e}",
        "\u{1e090}",
        "\u{1e12d}",
        "\u{1e13e}",
        "\u{1e14a}",
        "\u{1e150}",
        "\u{1e2af}",
        "\u{1e2fa}",
        "\u{1e300}",
        "\u{1e4fa}",
        "\u{1e7e7}",
        "\u{1e7ec}",
        "\u{1e7ef}",
        "\u{1e7ff}",
        "\u{1e8c5}",
        "\u{1e8d7}",
        "\u{1e94c}",
        "\u{1e95a}",
        "\u{1e960}",
        "\u{1ecb5}",
        "\u{1ed3e}",
        "\u{1ee04}",
        "\u{1ee20}",
        "\u{1ee23}",
        "\u{1ee25}",
        "\u{1ee28}",
        "\u{1ee33}",
        "\u{1ee38}",
        "\u{1ee3a}",
        "\u{1ee3c}",
        "\u{1ee43}",
        "\u{1ee48}",
        "\u{1ee4a}",
        "\u{1ee4c}",
        "\u{1ee50}",
        "\u{1ee53}",
        "\u{1ee55}",
        "\u{1ee58}",
        "\u{1ee5a}",
        "\u{1ee5c}",
        "\u{1ee5e}",
        "\u{1ee60}",
        "\u{1ee63}",
        "\u{1ee65}",
        "\u{1ee6b}",
        "\u{1ee73}",
        "\u{1ee78}",
        "\u{1ee7d}",
        "\u{1ee7f}",
        "\u{1ee8a}",
        "\u{1ee9c}",
        "\u{1eea4}",
        "\u{1eeaa}",
        "\u{1eebc}",
        "\u{1eef2}",
        "\u{1f02c}",
        "\u{1f094}",
        "\u{1f0af}",
        "\u{1f0c0}",
        "\u{1f0d0}",
        "\u{1f0f6}",
        "\u{1f1ae}",
        "\u{1f203}",
        "\u{1f23c}",
        "\u{1f249}",
        "\u{1f252}",
        "\u{1f266}",
        "\u{1f6d8}",
        "\u{1f6ed}",
        "\u{1f6fd}",
        "\u{1f777}",
        "\u{1f7da}",
        "\u{1f7ec}",
        "\u{1f7f1}",
        "\u{1f80c}",
        "\u{1f848}",
        "\u{1f85a}",
        "\u{1f888}",
        "\u{1f8ae}",
        "\u{1f8b2}",
        "\u{1fa54}",
        "\u{1fa6e}",
        "\u{1fa7d}",
        "\u{1fa89}",
        "\u{1fabe}",
        "\u{1fac6}",
        "\u{1fadc}",
        "\u{1fae9}",
        "\u{1faf9}",
        "\u{1fb93}",
        "\u{1fbcb}",
        "\u{1fbfa}",
        "\u{2a6e0}",
        "\u{2b73a}",
        "\u{2b81e}",
        "\u{2cea2}",
        "\u{2ebe1}",
        "\u{2ee5e}",
        "\u{2fa1e}",
        "\u{3134b}",
        "\u{323b0}",
        "\u{e0002}",
        "\u{e0080}",
        "\u{e01f0}",
        "\u{ffffe}",
        "\u{10fffe}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Unassigned}+$",
        "^\\p{gc=Unassigned}+$",
        "^\\p{Unassigned}+$",
        "^\\p{General_Category=Cn}+$",
        "^\\p{gc=Cn}+$",
        "^\\p{Cn}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_uppercaseletter() {
    test_with_configs(unicode_escape_property_gc_uppercaseletter_tc)
}

fn unicode_escape_property_gc_uppercaseletter_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 646] = [
        "\u{41}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{14a}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3cf}",
        "\u{3d2}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13a0}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1fb8}",
        "\u{1fc8}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff8}",
        "\u{2102}",
        "\u{2107}",
        "\u{210b}",
        "\u{2110}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{2130}",
        "\u{213e}",
        "\u{2145}",
        "\u{2183}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1d400}",
        "\u{1d434}",
        "\u{1d468}",
        "\u{1d49c}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4d0}",
        "\u{1d504}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d538}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d56c}",
        "\u{1d5a0}",
        "\u{1d5d4}",
        "\u{1d608}",
        "\u{1d63c}",
        "\u{1d670}",
        "\u{1d6a8}",
        "\u{1d6e2}",
        "\u{1d71c}",
        "\u{1d756}",
        "\u{1d790}",
        "\u{1d7ca}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Uppercase_Letter}+$",
        "^\\p{gc=Uppercase_Letter}+$",
        "^\\p{Uppercase_Letter}+$",
        "^\\p{General_Category=Lu}+$",
        "^\\p{gc=Lu}+$",
        "^\\p{Lu}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_casedletter() {
    test_with_configs(unicode_escape_property_gc_casedletter_tc)
}

fn unicode_escape_property_gc_casedletter_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1314] = [
        "\u{61}",
        "\u{b5}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1aa}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1c6}",
        "\u{1c9}",
        "\u{1cc}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f3}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{221}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{295}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{560}",
        "\u{10d0}",
        "\u{10fd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d00}",
        "\u{1d6b}",
        "\u{1d79}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1e9f}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1f90}",
        "\u{1fa0}",
        "\u{1fb0}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{210a}",
        "\u{210e}",
        "\u{2113}",
        "\u{212f}",
        "\u{2134}",
        "\u{2139}",
        "\u{213c}",
        "\u{2146}",
        "\u{214e}",
        "\u{2184}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c71}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a771}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a78e}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7af}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f6}",
        "\u{a7fa}",
        "\u{ab30}",
        "\u{ab60}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1d41a}",
        "\u{1d44e}",
        "\u{1d456}",
        "\u{1d482}",
        "\u{1d4b6}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d4ea}",
        "\u{1d51e}",
        "\u{1d552}",
        "\u{1d586}",
        "\u{1d5ba}",
        "\u{1d5ee}",
        "\u{1d622}",
        "\u{1d656}",
        "\u{1d68a}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7cb}",
        "\u{1df00}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e922}",
        "\u{1c5}",
        "\u{1c8}",
        "\u{1cb}",
        "\u{1f2}",
        "\u{1f88}",
        "\u{1f98}",
        "\u{1fa8}",
        "\u{1fbc}",
        "\u{1fcc}",
        "\u{1ffc}",
        "\u{41}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{14a}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3cf}",
        "\u{3d2}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13a0}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1fb8}",
        "\u{1fc8}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff8}",
        "\u{2102}",
        "\u{2107}",
        "\u{210b}",
        "\u{2110}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{2130}",
        "\u{213e}",
        "\u{2145}",
        "\u{2183}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1d400}",
        "\u{1d434}",
        "\u{1d468}",
        "\u{1d49c}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4d0}",
        "\u{1d504}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d538}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d56c}",
        "\u{1d5a0}",
        "\u{1d5d4}",
        "\u{1d608}",
        "\u{1d63c}",
        "\u{1d670}",
        "\u{1d6a8}",
        "\u{1d6e2}",
        "\u{1d71c}",
        "\u{1d756}",
        "\u{1d790}",
        "\u{1d7ca}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Cased_Letter}+$",
        "^\\p{gc=Cased_Letter}+$",
        "^\\p{Cased_Letter}+$",
        "^\\p{General_Category=LC}+$",
        "^\\p{gc=LC}+$",
        "^\\p{LC}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_other() {
    test_with_configs(unicode_escape_property_gc_other_tc)
}

fn unicode_escape_property_gc_other_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 733] = [
        "\u{0}",
        "\u{7f}",
        "\u{ad}",
        "\u{600}",
        "\u{61c}",
        "\u{6dd}",
        "\u{70f}",
        "\u{890}",
        "\u{8e2}",
        "\u{180e}",
        "\u{200b}",
        "\u{202a}",
        "\u{2060}",
        "\u{2066}",
        "\u{feff}",
        "\u{fff9}",
        "\u{110bd}",
        "\u{110cd}",
        "\u{13430}",
        "\u{1bca0}",
        "\u{1d173}",
        "\u{e0001}",
        "\u{e0020}",
        "\u{378}",
        "\u{380}",
        "\u{38b}",
        "\u{38d}",
        "\u{3a2}",
        "\u{530}",
        "\u{557}",
        "\u{58b}",
        "\u{590}",
        "\u{5c8}",
        "\u{5eb}",
        "\u{5f5}",
        "\u{70e}",
        "\u{74b}",
        "\u{7b2}",
        "\u{7fb}",
        "\u{82e}",
        "\u{83f}",
        "\u{85c}",
        "\u{85f}",
        "\u{86b}",
        "\u{88f}",
        "\u{892}",
        "\u{984}",
        "\u{98d}",
        "\u{991}",
        "\u{9a9}",
        "\u{9b1}",
        "\u{9b3}",
        "\u{9ba}",
        "\u{9c5}",
        "\u{9c9}",
        "\u{9cf}",
        "\u{9d8}",
        "\u{9de}",
        "\u{9e4}",
        "\u{9ff}",
        "\u{a04}",
        "\u{a0b}",
        "\u{a11}",
        "\u{a29}",
        "\u{a31}",
        "\u{a34}",
        "\u{a37}",
        "\u{a3a}",
        "\u{a3d}",
        "\u{a43}",
        "\u{a49}",
        "\u{a4e}",
        "\u{a52}",
        "\u{a5d}",
        "\u{a5f}",
        "\u{a77}",
        "\u{a84}",
        "\u{a8e}",
        "\u{a92}",
        "\u{aa9}",
        "\u{ab1}",
        "\u{ab4}",
        "\u{aba}",
        "\u{ac6}",
        "\u{aca}",
        "\u{ace}",
        "\u{ad1}",
        "\u{ae4}",
        "\u{af2}",
        "\u{b00}",
        "\u{b04}",
        "\u{b0d}",
        "\u{b11}",
        "\u{b29}",
        "\u{b31}",
        "\u{b34}",
        "\u{b3a}",
        "\u{b45}",
        "\u{b49}",
        "\u{b4e}",
        "\u{b58}",
        "\u{b5e}",
        "\u{b64}",
        "\u{b78}",
        "\u{b84}",
        "\u{b8b}",
        "\u{b91}",
        "\u{b96}",
        "\u{b9b}",
        "\u{b9d}",
        "\u{ba0}",
        "\u{ba5}",
        "\u{bab}",
        "\u{bba}",
        "\u{bc3}",
        "\u{bc9}",
        "\u{bce}",
        "\u{bd1}",
        "\u{bd8}",
        "\u{bfb}",
        "\u{c0d}",
        "\u{c11}",
        "\u{c29}",
        "\u{c3a}",
        "\u{c45}",
        "\u{c49}",
        "\u{c4e}",
        "\u{c57}",
        "\u{c5b}",
        "\u{c5e}",
        "\u{c64}",
        "\u{c70}",
        "\u{c8d}",
        "\u{c91}",
        "\u{ca9}",
        "\u{cb4}",
        "\u{cba}",
        "\u{cc5}",
        "\u{cc9}",
        "\u{cce}",
        "\u{cd7}",
        "\u{cdf}",
        "\u{ce4}",
        "\u{cf0}",
        "\u{cf4}",
        "\u{d0d}",
        "\u{d11}",
        "\u{d45}",
        "\u{d49}",
        "\u{d50}",
        "\u{d64}",
        "\u{d80}",
        "\u{d84}",
        "\u{d97}",
        "\u{db2}",
        "\u{dbc}",
        "\u{dbe}",
        "\u{dc7}",
        "\u{dcb}",
        "\u{dd5}",
        "\u{dd7}",
        "\u{de0}",
        "\u{df0}",
        "\u{df5}",
        "\u{e3b}",
        "\u{e5c}",
        "\u{e83}",
        "\u{e85}",
        "\u{e8b}",
        "\u{ea4}",
        "\u{ea6}",
        "\u{ebe}",
        "\u{ec5}",
        "\u{ec7}",
        "\u{ecf}",
        "\u{eda}",
        "\u{ee0}",
        "\u{f48}",
        "\u{f6d}",
        "\u{f98}",
        "\u{fbd}",
        "\u{fcd}",
        "\u{fdb}",
        "\u{10c6}",
        "\u{10c8}",
        "\u{10ce}",
        "\u{1249}",
        "\u{124e}",
        "\u{1257}",
        "\u{1259}",
        "\u{125e}",
        "\u{1289}",
        "\u{128e}",
        "\u{12b1}",
        "\u{12b6}",
        "\u{12bf}",
        "\u{12c1}",
        "\u{12c6}",
        "\u{12d7}",
        "\u{1311}",
        "\u{1316}",
        "\u{135b}",
        "\u{137d}",
        "\u{139a}",
        "\u{13f6}",
        "\u{13fe}",
        "\u{169d}",
        "\u{16f9}",
        "\u{1716}",
        "\u{1737}",
        "\u{1754}",
        "\u{176d}",
        "\u{1771}",
        "\u{1774}",
        "\u{17de}",
        "\u{17ea}",
        "\u{17fa}",
        "\u{181a}",
        "\u{1879}",
        "\u{18ab}",
        "\u{18f6}",
        "\u{191f}",
        "\u{192c}",
        "\u{193c}",
        "\u{1941}",
        "\u{196e}",
        "\u{1975}",
        "\u{19ac}",
        "\u{19ca}",
        "\u{19db}",
        "\u{1a1c}",
        "\u{1a5f}",
        "\u{1a7d}",
        "\u{1a8a}",
        "\u{1a9a}",
        "\u{1aae}",
        "\u{1acf}",
        "\u{1b4d}",
        "\u{1b7f}",
        "\u{1bf4}",
        "\u{1c38}",
        "\u{1c4a}",
        "\u{1c89}",
        "\u{1cbb}",
        "\u{1cc8}",
        "\u{1cfb}",
        "\u{1f16}",
        "\u{1f1e}",
        "\u{1f46}",
        "\u{1f4e}",
        "\u{1f58}",
        "\u{1f5a}",
        "\u{1f5c}",
        "\u{1f5e}",
        "\u{1f7e}",
        "\u{1fb5}",
        "\u{1fc5}",
        "\u{1fd4}",
        "\u{1fdc}",
        "\u{1ff0}",
        "\u{1ff5}",
        "\u{1fff}",
        "\u{2065}",
        "\u{2072}",
        "\u{208f}",
        "\u{209d}",
        "\u{20c1}",
        "\u{20f1}",
        "\u{218c}",
        "\u{2427}",
        "\u{244b}",
        "\u{2b74}",
        "\u{2b96}",
        "\u{2cf4}",
        "\u{2d26}",
        "\u{2d28}",
        "\u{2d2e}",
        "\u{2d68}",
        "\u{2d71}",
        "\u{2d97}",
        "\u{2da7}",
        "\u{2daf}",
        "\u{2db7}",
        "\u{2dbf}",
        "\u{2dc7}",
        "\u{2dcf}",
        "\u{2dd7}",
        "\u{2ddf}",
        "\u{2e5e}",
        "\u{2e9a}",
        "\u{2ef4}",
        "\u{2fd6}",
        "\u{3040}",
        "\u{3097}",
        "\u{3100}",
        "\u{3130}",
        "\u{318f}",
        "\u{31e4}",
        "\u{321f}",
        "\u{a48d}",
        "\u{a4c7}",
        "\u{a62c}",
        "\u{a6f8}",
        "\u{a7cb}",
        "\u{a7d2}",
        "\u{a7d4}",
        "\u{a7da}",
        "\u{a82d}",
        "\u{a83a}",
        "\u{a878}",
        "\u{a8c6}",
        "\u{a8da}",
        "\u{a954}",
        "\u{a97d}",
        "\u{a9ce}",
        "\u{a9da}",
        "\u{a9ff}",
        "\u{aa37}",
        "\u{aa4e}",
        "\u{aa5a}",
        "\u{aac3}",
        "\u{aaf7}",
        "\u{ab07}",
        "\u{ab0f}",
        "\u{ab17}",
        "\u{ab27}",
        "\u{ab2f}",
        "\u{ab6c}",
        "\u{abee}",
        "\u{abfa}",
        "\u{d7a4}",
        "\u{d7c7}",
        "\u{d7fc}",
        "\u{fa6e}",
        "\u{fada}",
        "\u{fb07}",
        "\u{fb18}",
        "\u{fb37}",
        "\u{fb3d}",
        "\u{fb3f}",
        "\u{fb42}",
        "\u{fb45}",
        "\u{fbc3}",
        "\u{fd90}",
        "\u{fdc8}",
        "\u{fdd0}",
        "\u{fe1a}",
        "\u{fe53}",
        "\u{fe67}",
        "\u{fe6c}",
        "\u{fe75}",
        "\u{fefd}",
        "\u{ff00}",
        "\u{ffbf}",
        "\u{ffc8}",
        "\u{ffd0}",
        "\u{ffd8}",
        "\u{ffdd}",
        "\u{ffe7}",
        "\u{ffef}",
        "\u{fffe}",
        "\u{1000c}",
        "\u{10027}",
        "\u{1003b}",
        "\u{1003e}",
        "\u{1004e}",
        "\u{1005e}",
        "\u{100fb}",
        "\u{10103}",
        "\u{10134}",
        "\u{1018f}",
        "\u{1019d}",
        "\u{101a1}",
        "\u{101fe}",
        "\u{1029d}",
        "\u{102d1}",
        "\u{102fc}",
        "\u{10324}",
        "\u{1034b}",
        "\u{1037b}",
        "\u{1039e}",
        "\u{103c4}",
        "\u{103d6}",
        "\u{1049e}",
        "\u{104aa}",
        "\u{104d4}",
        "\u{104fc}",
        "\u{10528}",
        "\u{10564}",
        "\u{1057b}",
        "\u{1058b}",
        "\u{10593}",
        "\u{10596}",
        "\u{105a2}",
        "\u{105b2}",
        "\u{105ba}",
        "\u{105bd}",
        "\u{10737}",
        "\u{10756}",
        "\u{10768}",
        "\u{10786}",
        "\u{107b1}",
        "\u{107bb}",
        "\u{10806}",
        "\u{10809}",
        "\u{10836}",
        "\u{10839}",
        "\u{1083d}",
        "\u{10856}",
        "\u{1089f}",
        "\u{108b0}",
        "\u{108f3}",
        "\u{108f6}",
        "\u{1091c}",
        "\u{1093a}",
        "\u{10940}",
        "\u{109b8}",
        "\u{109d0}",
        "\u{10a04}",
        "\u{10a07}",
        "\u{10a14}",
        "\u{10a18}",
        "\u{10a36}",
        "\u{10a3b}",
        "\u{10a49}",
        "\u{10a59}",
        "\u{10aa0}",
        "\u{10ae7}",
        "\u{10af7}",
        "\u{10b36}",
        "\u{10b56}",
        "\u{10b73}",
        "\u{10b92}",
        "\u{10b9d}",
        "\u{10bb0}",
        "\u{10c49}",
        "\u{10cb3}",
        "\u{10cf3}",
        "\u{10d28}",
        "\u{10d3a}",
        "\u{10e7f}",
        "\u{10eaa}",
        "\u{10eae}",
        "\u{10eb2}",
        "\u{10f28}",
        "\u{10f5a}",
        "\u{10f8a}",
        "\u{10fcc}",
        "\u{10ff7}",
        "\u{1104e}",
        "\u{11076}",
        "\u{110c3}",
        "\u{110ce}",
        "\u{110e9}",
        "\u{110fa}",
        "\u{11135}",
        "\u{11148}",
        "\u{11177}",
        "\u{111e0}",
        "\u{111f5}",
        "\u{11212}",
        "\u{11242}",
        "\u{11287}",
        "\u{11289}",
        "\u{1128e}",
        "\u{1129e}",
        "\u{112aa}",
        "\u{112eb}",
        "\u{112fa}",
        "\u{11304}",
        "\u{1130d}",
        "\u{11311}",
        "\u{11329}",
        "\u{11331}",
        "\u{11334}",
        "\u{1133a}",
        "\u{11345}",
        "\u{11349}",
        "\u{1134e}",
        "\u{11351}",
        "\u{11358}",
        "\u{11364}",
        "\u{1136d}",
        "\u{11375}",
        "\u{1145c}",
        "\u{11462}",
        "\u{114c8}",
        "\u{114da}",
        "\u{115b6}",
        "\u{115de}",
        "\u{11645}",
        "\u{1165a}",
        "\u{1166d}",
        "\u{116ba}",
        "\u{116ca}",
        "\u{1171b}",
        "\u{1172c}",
        "\u{11747}",
        "\u{1183c}",
        "\u{118f3}",
        "\u{11907}",
        "\u{1190a}",
        "\u{11914}",
        "\u{11917}",
        "\u{11936}",
        "\u{11939}",
        "\u{11947}",
        "\u{1195a}",
        "\u{119a8}",
        "\u{119d8}",
        "\u{119e5}",
        "\u{11a48}",
        "\u{11aa3}",
        "\u{11af9}",
        "\u{11b0a}",
        "\u{11c09}",
        "\u{11c37}",
        "\u{11c46}",
        "\u{11c6d}",
        "\u{11c90}",
        "\u{11ca8}",
        "\u{11cb7}",
        "\u{11d07}",
        "\u{11d0a}",
        "\u{11d37}",
        "\u{11d3b}",
        "\u{11d3e}",
        "\u{11d48}",
        "\u{11d5a}",
        "\u{11d66}",
        "\u{11d69}",
        "\u{11d8f}",
        "\u{11d92}",
        "\u{11d99}",
        "\u{11daa}",
        "\u{11ef9}",
        "\u{11f11}",
        "\u{11f3b}",
        "\u{11f5a}",
        "\u{11fb1}",
        "\u{11ff2}",
        "\u{1239a}",
        "\u{1246f}",
        "\u{12475}",
        "\u{12544}",
        "\u{12ff3}",
        "\u{13456}",
        "\u{14647}",
        "\u{16a39}",
        "\u{16a5f}",
        "\u{16a6a}",
        "\u{16abf}",
        "\u{16aca}",
        "\u{16aee}",
        "\u{16af6}",
        "\u{16b46}",
        "\u{16b5a}",
        "\u{16b62}",
        "\u{16b78}",
        "\u{16b90}",
        "\u{16e9b}",
        "\u{16f4b}",
        "\u{16f88}",
        "\u{16fa0}",
        "\u{16fe5}",
        "\u{16ff2}",
        "\u{187f8}",
        "\u{18cd6}",
        "\u{18d09}",
        "\u{1aff4}",
        "\u{1affc}",
        "\u{1afff}",
        "\u{1b123}",
        "\u{1b133}",
        "\u{1b153}",
        "\u{1b156}",
        "\u{1b168}",
        "\u{1b2fc}",
        "\u{1bc6b}",
        "\u{1bc7d}",
        "\u{1bc89}",
        "\u{1bc9a}",
        "\u{1bca4}",
        "\u{1cf2e}",
        "\u{1cf47}",
        "\u{1cfc4}",
        "\u{1d0f6}",
        "\u{1d127}",
        "\u{1d1eb}",
        "\u{1d246}",
        "\u{1d2d4}",
        "\u{1d2f4}",
        "\u{1d357}",
        "\u{1d379}",
        "\u{1d455}",
        "\u{1d49d}",
        "\u{1d4a0}",
        "\u{1d4a3}",
        "\u{1d4a7}",
        "\u{1d4ad}",
        "\u{1d4ba}",
        "\u{1d4bc}",
        "\u{1d4c4}",
        "\u{1d506}",
        "\u{1d50b}",
        "\u{1d515}",
        "\u{1d51d}",
        "\u{1d53a}",
        "\u{1d53f}",
        "\u{1d545}",
        "\u{1d547}",
        "\u{1d551}",
        "\u{1d6a6}",
        "\u{1d7cc}",
        "\u{1da8c}",
        "\u{1daa0}",
        "\u{1dab0}",
        "\u{1df1f}",
        "\u{1df2b}",
        "\u{1e007}",
        "\u{1e019}",
        "\u{1e022}",
        "\u{1e025}",
        "\u{1e02b}",
        "\u{1e06e}",
        "\u{1e090}",
        "\u{1e12d}",
        "\u{1e13e}",
        "\u{1e14a}",
        "\u{1e150}",
        "\u{1e2af}",
        "\u{1e2fa}",
        "\u{1e300}",
        "\u{1e4fa}",
        "\u{1e7e7}",
        "\u{1e7ec}",
        "\u{1e7ef}",
        "\u{1e7ff}",
        "\u{1e8c5}",
        "\u{1e8d7}",
        "\u{1e94c}",
        "\u{1e95a}",
        "\u{1e960}",
        "\u{1ecb5}",
        "\u{1ed3e}",
        "\u{1ee04}",
        "\u{1ee20}",
        "\u{1ee23}",
        "\u{1ee25}",
        "\u{1ee28}",
        "\u{1ee33}",
        "\u{1ee38}",
        "\u{1ee3a}",
        "\u{1ee3c}",
        "\u{1ee43}",
        "\u{1ee48}",
        "\u{1ee4a}",
        "\u{1ee4c}",
        "\u{1ee50}",
        "\u{1ee53}",
        "\u{1ee55}",
        "\u{1ee58}",
        "\u{1ee5a}",
        "\u{1ee5c}",
        "\u{1ee5e}",
        "\u{1ee60}",
        "\u{1ee63}",
        "\u{1ee65}",
        "\u{1ee6b}",
        "\u{1ee73}",
        "\u{1ee78}",
        "\u{1ee7d}",
        "\u{1ee7f}",
        "\u{1ee8a}",
        "\u{1ee9c}",
        "\u{1eea4}",
        "\u{1eeaa}",
        "\u{1eebc}",
        "\u{1eef2}",
        "\u{1f02c}",
        "\u{1f094}",
        "\u{1f0af}",
        "\u{1f0c0}",
        "\u{1f0d0}",
        "\u{1f0f6}",
        "\u{1f1ae}",
        "\u{1f203}",
        "\u{1f23c}",
        "\u{1f249}",
        "\u{1f252}",
        "\u{1f266}",
        "\u{1f6d8}",
        "\u{1f6ed}",
        "\u{1f6fd}",
        "\u{1f777}",
        "\u{1f7da}",
        "\u{1f7ec}",
        "\u{1f7f1}",
        "\u{1f80c}",
        "\u{1f848}",
        "\u{1f85a}",
        "\u{1f888}",
        "\u{1f8ae}",
        "\u{1f8b2}",
        "\u{1fa54}",
        "\u{1fa6e}",
        "\u{1fa7d}",
        "\u{1fa89}",
        "\u{1fabe}",
        "\u{1fac6}",
        "\u{1fadc}",
        "\u{1fae9}",
        "\u{1faf9}",
        "\u{1fb93}",
        "\u{1fbcb}",
        "\u{1fbfa}",
        "\u{2a6e0}",
        "\u{2b73a}",
        "\u{2b81e}",
        "\u{2cea2}",
        "\u{2ebe1}",
        "\u{2ee5e}",
        "\u{2fa1e}",
        "\u{3134b}",
        "\u{323b0}",
        "\u{e0002}",
        "\u{e0080}",
        "\u{e01f0}",
        "\u{ffffe}",
        "\u{10fffe}",
        "\u{e000}",
        "\u{f0000}",
        "\u{100000}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Other}+$",
        "^\\p{gc=Other}+$",
        "^\\p{Other}+$",
        "^\\p{General_Category=C}+$",
        "^\\p{gc=C}+$",
        "^\\p{C}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_letter() {
    test_with_configs(unicode_escape_property_gc_letter_tc)
}

fn unicode_escape_property_gc_letter_tc(tc: TestConfig) {
    static CODE_POINTS: [&str; 1896] = [
        "\u{61}",
        "\u{b5}",
        "\u{df}",
        "\u{f8}",
        "\u{101}",
        "\u{103}",
        "\u{105}",
        "\u{107}",
        "\u{109}",
        "\u{10b}",
        "\u{10d}",
        "\u{10f}",
        "\u{111}",
        "\u{113}",
        "\u{115}",
        "\u{117}",
        "\u{119}",
        "\u{11b}",
        "\u{11d}",
        "\u{11f}",
        "\u{121}",
        "\u{123}",
        "\u{125}",
        "\u{127}",
        "\u{129}",
        "\u{12b}",
        "\u{12d}",
        "\u{12f}",
        "\u{131}",
        "\u{133}",
        "\u{135}",
        "\u{137}",
        "\u{13a}",
        "\u{13c}",
        "\u{13e}",
        "\u{140}",
        "\u{142}",
        "\u{144}",
        "\u{146}",
        "\u{148}",
        "\u{14b}",
        "\u{14d}",
        "\u{14f}",
        "\u{151}",
        "\u{153}",
        "\u{155}",
        "\u{157}",
        "\u{159}",
        "\u{15b}",
        "\u{15d}",
        "\u{15f}",
        "\u{161}",
        "\u{163}",
        "\u{165}",
        "\u{167}",
        "\u{169}",
        "\u{16b}",
        "\u{16d}",
        "\u{16f}",
        "\u{171}",
        "\u{173}",
        "\u{175}",
        "\u{177}",
        "\u{17a}",
        "\u{17c}",
        "\u{17e}",
        "\u{183}",
        "\u{185}",
        "\u{188}",
        "\u{18c}",
        "\u{192}",
        "\u{195}",
        "\u{199}",
        "\u{19e}",
        "\u{1a1}",
        "\u{1a3}",
        "\u{1a5}",
        "\u{1a8}",
        "\u{1aa}",
        "\u{1ad}",
        "\u{1b0}",
        "\u{1b4}",
        "\u{1b6}",
        "\u{1b9}",
        "\u{1bd}",
        "\u{1c6}",
        "\u{1c9}",
        "\u{1cc}",
        "\u{1ce}",
        "\u{1d0}",
        "\u{1d2}",
        "\u{1d4}",
        "\u{1d6}",
        "\u{1d8}",
        "\u{1da}",
        "\u{1dc}",
        "\u{1df}",
        "\u{1e1}",
        "\u{1e3}",
        "\u{1e5}",
        "\u{1e7}",
        "\u{1e9}",
        "\u{1eb}",
        "\u{1ed}",
        "\u{1ef}",
        "\u{1f3}",
        "\u{1f5}",
        "\u{1f9}",
        "\u{1fb}",
        "\u{1fd}",
        "\u{1ff}",
        "\u{201}",
        "\u{203}",
        "\u{205}",
        "\u{207}",
        "\u{209}",
        "\u{20b}",
        "\u{20d}",
        "\u{20f}",
        "\u{211}",
        "\u{213}",
        "\u{215}",
        "\u{217}",
        "\u{219}",
        "\u{21b}",
        "\u{21d}",
        "\u{21f}",
        "\u{221}",
        "\u{223}",
        "\u{225}",
        "\u{227}",
        "\u{229}",
        "\u{22b}",
        "\u{22d}",
        "\u{22f}",
        "\u{231}",
        "\u{233}",
        "\u{23c}",
        "\u{23f}",
        "\u{242}",
        "\u{247}",
        "\u{249}",
        "\u{24b}",
        "\u{24d}",
        "\u{24f}",
        "\u{295}",
        "\u{371}",
        "\u{373}",
        "\u{377}",
        "\u{37b}",
        "\u{390}",
        "\u{3ac}",
        "\u{3d0}",
        "\u{3d5}",
        "\u{3d9}",
        "\u{3db}",
        "\u{3dd}",
        "\u{3df}",
        "\u{3e1}",
        "\u{3e3}",
        "\u{3e5}",
        "\u{3e7}",
        "\u{3e9}",
        "\u{3eb}",
        "\u{3ed}",
        "\u{3ef}",
        "\u{3f5}",
        "\u{3f8}",
        "\u{3fb}",
        "\u{430}",
        "\u{461}",
        "\u{463}",
        "\u{465}",
        "\u{467}",
        "\u{469}",
        "\u{46b}",
        "\u{46d}",
        "\u{46f}",
        "\u{471}",
        "\u{473}",
        "\u{475}",
        "\u{477}",
        "\u{479}",
        "\u{47b}",
        "\u{47d}",
        "\u{47f}",
        "\u{481}",
        "\u{48b}",
        "\u{48d}",
        "\u{48f}",
        "\u{491}",
        "\u{493}",
        "\u{495}",
        "\u{497}",
        "\u{499}",
        "\u{49b}",
        "\u{49d}",
        "\u{49f}",
        "\u{4a1}",
        "\u{4a3}",
        "\u{4a5}",
        "\u{4a7}",
        "\u{4a9}",
        "\u{4ab}",
        "\u{4ad}",
        "\u{4af}",
        "\u{4b1}",
        "\u{4b3}",
        "\u{4b5}",
        "\u{4b7}",
        "\u{4b9}",
        "\u{4bb}",
        "\u{4bd}",
        "\u{4bf}",
        "\u{4c2}",
        "\u{4c4}",
        "\u{4c6}",
        "\u{4c8}",
        "\u{4ca}",
        "\u{4cc}",
        "\u{4ce}",
        "\u{4d1}",
        "\u{4d3}",
        "\u{4d5}",
        "\u{4d7}",
        "\u{4d9}",
        "\u{4db}",
        "\u{4dd}",
        "\u{4df}",
        "\u{4e1}",
        "\u{4e3}",
        "\u{4e5}",
        "\u{4e7}",
        "\u{4e9}",
        "\u{4eb}",
        "\u{4ed}",
        "\u{4ef}",
        "\u{4f1}",
        "\u{4f3}",
        "\u{4f5}",
        "\u{4f7}",
        "\u{4f9}",
        "\u{4fb}",
        "\u{4fd}",
        "\u{4ff}",
        "\u{501}",
        "\u{503}",
        "\u{505}",
        "\u{507}",
        "\u{509}",
        "\u{50b}",
        "\u{50d}",
        "\u{50f}",
        "\u{511}",
        "\u{513}",
        "\u{515}",
        "\u{517}",
        "\u{519}",
        "\u{51b}",
        "\u{51d}",
        "\u{51f}",
        "\u{521}",
        "\u{523}",
        "\u{525}",
        "\u{527}",
        "\u{529}",
        "\u{52b}",
        "\u{52d}",
        "\u{52f}",
        "\u{560}",
        "\u{10d0}",
        "\u{10fd}",
        "\u{13f8}",
        "\u{1c80}",
        "\u{1d00}",
        "\u{1d6b}",
        "\u{1d79}",
        "\u{1e01}",
        "\u{1e03}",
        "\u{1e05}",
        "\u{1e07}",
        "\u{1e09}",
        "\u{1e0b}",
        "\u{1e0d}",
        "\u{1e0f}",
        "\u{1e11}",
        "\u{1e13}",
        "\u{1e15}",
        "\u{1e17}",
        "\u{1e19}",
        "\u{1e1b}",
        "\u{1e1d}",
        "\u{1e1f}",
        "\u{1e21}",
        "\u{1e23}",
        "\u{1e25}",
        "\u{1e27}",
        "\u{1e29}",
        "\u{1e2b}",
        "\u{1e2d}",
        "\u{1e2f}",
        "\u{1e31}",
        "\u{1e33}",
        "\u{1e35}",
        "\u{1e37}",
        "\u{1e39}",
        "\u{1e3b}",
        "\u{1e3d}",
        "\u{1e3f}",
        "\u{1e41}",
        "\u{1e43}",
        "\u{1e45}",
        "\u{1e47}",
        "\u{1e49}",
        "\u{1e4b}",
        "\u{1e4d}",
        "\u{1e4f}",
        "\u{1e51}",
        "\u{1e53}",
        "\u{1e55}",
        "\u{1e57}",
        "\u{1e59}",
        "\u{1e5b}",
        "\u{1e5d}",
        "\u{1e5f}",
        "\u{1e61}",
        "\u{1e63}",
        "\u{1e65}",
        "\u{1e67}",
        "\u{1e69}",
        "\u{1e6b}",
        "\u{1e6d}",
        "\u{1e6f}",
        "\u{1e71}",
        "\u{1e73}",
        "\u{1e75}",
        "\u{1e77}",
        "\u{1e79}",
        "\u{1e7b}",
        "\u{1e7d}",
        "\u{1e7f}",
        "\u{1e81}",
        "\u{1e83}",
        "\u{1e85}",
        "\u{1e87}",
        "\u{1e89}",
        "\u{1e8b}",
        "\u{1e8d}",
        "\u{1e8f}",
        "\u{1e91}",
        "\u{1e93}",
        "\u{1e95}",
        "\u{1e9f}",
        "\u{1ea1}",
        "\u{1ea3}",
        "\u{1ea5}",
        "\u{1ea7}",
        "\u{1ea9}",
        "\u{1eab}",
        "\u{1ead}",
        "\u{1eaf}",
        "\u{1eb1}",
        "\u{1eb3}",
        "\u{1eb5}",
        "\u{1eb7}",
        "\u{1eb9}",
        "\u{1ebb}",
        "\u{1ebd}",
        "\u{1ebf}",
        "\u{1ec1}",
        "\u{1ec3}",
        "\u{1ec5}",
        "\u{1ec7}",
        "\u{1ec9}",
        "\u{1ecb}",
        "\u{1ecd}",
        "\u{1ecf}",
        "\u{1ed1}",
        "\u{1ed3}",
        "\u{1ed5}",
        "\u{1ed7}",
        "\u{1ed9}",
        "\u{1edb}",
        "\u{1edd}",
        "\u{1edf}",
        "\u{1ee1}",
        "\u{1ee3}",
        "\u{1ee5}",
        "\u{1ee7}",
        "\u{1ee9}",
        "\u{1eeb}",
        "\u{1eed}",
        "\u{1eef}",
        "\u{1ef1}",
        "\u{1ef3}",
        "\u{1ef5}",
        "\u{1ef7}",
        "\u{1ef9}",
        "\u{1efb}",
        "\u{1efd}",
        "\u{1eff}",
        "\u{1f10}",
        "\u{1f20}",
        "\u{1f30}",
        "\u{1f40}",
        "\u{1f50}",
        "\u{1f60}",
        "\u{1f70}",
        "\u{1f80}",
        "\u{1f90}",
        "\u{1fa0}",
        "\u{1fb0}",
        "\u{1fb6}",
        "\u{1fbe}",
        "\u{1fc2}",
        "\u{1fc6}",
        "\u{1fd0}",
        "\u{1fd6}",
        "\u{1fe0}",
        "\u{1ff2}",
        "\u{1ff6}",
        "\u{210a}",
        "\u{210e}",
        "\u{2113}",
        "\u{212f}",
        "\u{2134}",
        "\u{2139}",
        "\u{213c}",
        "\u{2146}",
        "\u{214e}",
        "\u{2184}",
        "\u{2c30}",
        "\u{2c61}",
        "\u{2c65}",
        "\u{2c68}",
        "\u{2c6a}",
        "\u{2c6c}",
        "\u{2c71}",
        "\u{2c73}",
        "\u{2c76}",
        "\u{2c81}",
        "\u{2c83}",
        "\u{2c85}",
        "\u{2c87}",
        "\u{2c89}",
        "\u{2c8b}",
        "\u{2c8d}",
        "\u{2c8f}",
        "\u{2c91}",
        "\u{2c93}",
        "\u{2c95}",
        "\u{2c97}",
        "\u{2c99}",
        "\u{2c9b}",
        "\u{2c9d}",
        "\u{2c9f}",
        "\u{2ca1}",
        "\u{2ca3}",
        "\u{2ca5}",
        "\u{2ca7}",
        "\u{2ca9}",
        "\u{2cab}",
        "\u{2cad}",
        "\u{2caf}",
        "\u{2cb1}",
        "\u{2cb3}",
        "\u{2cb5}",
        "\u{2cb7}",
        "\u{2cb9}",
        "\u{2cbb}",
        "\u{2cbd}",
        "\u{2cbf}",
        "\u{2cc1}",
        "\u{2cc3}",
        "\u{2cc5}",
        "\u{2cc7}",
        "\u{2cc9}",
        "\u{2ccb}",
        "\u{2ccd}",
        "\u{2ccf}",
        "\u{2cd1}",
        "\u{2cd3}",
        "\u{2cd5}",
        "\u{2cd7}",
        "\u{2cd9}",
        "\u{2cdb}",
        "\u{2cdd}",
        "\u{2cdf}",
        "\u{2ce1}",
        "\u{2ce3}",
        "\u{2cec}",
        "\u{2cee}",
        "\u{2cf3}",
        "\u{2d00}",
        "\u{2d27}",
        "\u{2d2d}",
        "\u{a641}",
        "\u{a643}",
        "\u{a645}",
        "\u{a647}",
        "\u{a649}",
        "\u{a64b}",
        "\u{a64d}",
        "\u{a64f}",
        "\u{a651}",
        "\u{a653}",
        "\u{a655}",
        "\u{a657}",
        "\u{a659}",
        "\u{a65b}",
        "\u{a65d}",
        "\u{a65f}",
        "\u{a661}",
        "\u{a663}",
        "\u{a665}",
        "\u{a667}",
        "\u{a669}",
        "\u{a66b}",
        "\u{a66d}",
        "\u{a681}",
        "\u{a683}",
        "\u{a685}",
        "\u{a687}",
        "\u{a689}",
        "\u{a68b}",
        "\u{a68d}",
        "\u{a68f}",
        "\u{a691}",
        "\u{a693}",
        "\u{a695}",
        "\u{a697}",
        "\u{a699}",
        "\u{a69b}",
        "\u{a723}",
        "\u{a725}",
        "\u{a727}",
        "\u{a729}",
        "\u{a72b}",
        "\u{a72d}",
        "\u{a72f}",
        "\u{a733}",
        "\u{a735}",
        "\u{a737}",
        "\u{a739}",
        "\u{a73b}",
        "\u{a73d}",
        "\u{a73f}",
        "\u{a741}",
        "\u{a743}",
        "\u{a745}",
        "\u{a747}",
        "\u{a749}",
        "\u{a74b}",
        "\u{a74d}",
        "\u{a74f}",
        "\u{a751}",
        "\u{a753}",
        "\u{a755}",
        "\u{a757}",
        "\u{a759}",
        "\u{a75b}",
        "\u{a75d}",
        "\u{a75f}",
        "\u{a761}",
        "\u{a763}",
        "\u{a765}",
        "\u{a767}",
        "\u{a769}",
        "\u{a76b}",
        "\u{a76d}",
        "\u{a76f}",
        "\u{a771}",
        "\u{a77a}",
        "\u{a77c}",
        "\u{a77f}",
        "\u{a781}",
        "\u{a783}",
        "\u{a785}",
        "\u{a787}",
        "\u{a78c}",
        "\u{a78e}",
        "\u{a791}",
        "\u{a793}",
        "\u{a797}",
        "\u{a799}",
        "\u{a79b}",
        "\u{a79d}",
        "\u{a79f}",
        "\u{a7a1}",
        "\u{a7a3}",
        "\u{a7a5}",
        "\u{a7a7}",
        "\u{a7a9}",
        "\u{a7af}",
        "\u{a7b5}",
        "\u{a7b7}",
        "\u{a7b9}",
        "\u{a7bb}",
        "\u{a7bd}",
        "\u{a7bf}",
        "\u{a7c1}",
        "\u{a7c3}",
        "\u{a7c8}",
        "\u{a7ca}",
        "\u{a7d1}",
        "\u{a7d3}",
        "\u{a7d5}",
        "\u{a7d7}",
        "\u{a7d9}",
        "\u{a7f6}",
        "\u{a7fa}",
        "\u{ab30}",
        "\u{ab60}",
        "\u{ab70}",
        "\u{fb00}",
        "\u{fb13}",
        "\u{ff41}",
        "\u{10428}",
        "\u{104d8}",
        "\u{10597}",
        "\u{105a3}",
        "\u{105b3}",
        "\u{105bb}",
        "\u{10cc0}",
        "\u{118c0}",
        "\u{16e60}",
        "\u{1d41a}",
        "\u{1d44e}",
        "\u{1d456}",
        "\u{1d482}",
        "\u{1d4b6}",
        "\u{1d4bb}",
        "\u{1d4bd}",
        "\u{1d4c5}",
        "\u{1d4ea}",
        "\u{1d51e}",
        "\u{1d552}",
        "\u{1d586}",
        "\u{1d5ba}",
        "\u{1d5ee}",
        "\u{1d622}",
        "\u{1d656}",
        "\u{1d68a}",
        "\u{1d6c2}",
        "\u{1d6dc}",
        "\u{1d6fc}",
        "\u{1d716}",
        "\u{1d736}",
        "\u{1d750}",
        "\u{1d770}",
        "\u{1d78a}",
        "\u{1d7aa}",
        "\u{1d7c4}",
        "\u{1d7cb}",
        "\u{1df00}",
        "\u{1df0b}",
        "\u{1df25}",
        "\u{1e922}",
        "\u{2b0}",
        "\u{2c6}",
        "\u{2e0}",
        "\u{2ec}",
        "\u{2ee}",
        "\u{374}",
        "\u{37a}",
        "\u{559}",
        "\u{640}",
        "\u{6e5}",
        "\u{7f4}",
        "\u{7fa}",
        "\u{81a}",
        "\u{824}",
        "\u{828}",
        "\u{8c9}",
        "\u{971}",
        "\u{e46}",
        "\u{ec6}",
        "\u{10fc}",
        "\u{17d7}",
        "\u{1843}",
        "\u{1aa7}",
        "\u{1c78}",
        "\u{1d2c}",
        "\u{1d78}",
        "\u{1d9b}",
        "\u{2071}",
        "\u{207f}",
        "\u{2090}",
        "\u{2c7c}",
        "\u{2d6f}",
        "\u{2e2f}",
        "\u{3005}",
        "\u{3031}",
        "\u{303b}",
        "\u{309d}",
        "\u{30fc}",
        "\u{a015}",
        "\u{a4f8}",
        "\u{a60c}",
        "\u{a67f}",
        "\u{a69c}",
        "\u{a717}",
        "\u{a770}",
        "\u{a788}",
        "\u{a7f2}",
        "\u{a7f8}",
        "\u{a9cf}",
        "\u{a9e6}",
        "\u{aa70}",
        "\u{aadd}",
        "\u{aaf3}",
        "\u{ab5c}",
        "\u{ab69}",
        "\u{ff70}",
        "\u{ff9e}",
        "\u{10780}",
        "\u{10787}",
        "\u{107b2}",
        "\u{16b40}",
        "\u{16f93}",
        "\u{16fe0}",
        "\u{16fe3}",
        "\u{1aff0}",
        "\u{1aff5}",
        "\u{1affd}",
        "\u{1e030}",
        "\u{1e137}",
        "\u{1e4eb}",
        "\u{1e94b}",
        "\u{aa}",
        "\u{ba}",
        "\u{1bb}",
        "\u{1c0}",
        "\u{294}",
        "\u{5d0}",
        "\u{5ef}",
        "\u{620}",
        "\u{641}",
        "\u{66e}",
        "\u{671}",
        "\u{6d5}",
        "\u{6ee}",
        "\u{6fa}",
        "\u{6ff}",
        "\u{710}",
        "\u{712}",
        "\u{74d}",
        "\u{7b1}",
        "\u{7ca}",
        "\u{800}",
        "\u{840}",
        "\u{860}",
        "\u{870}",
        "\u{889}",
        "\u{8a0}",
        "\u{904}",
        "\u{93d}",
        "\u{950}",
        "\u{958}",
        "\u{972}",
        "\u{985}",
        "\u{98f}",
        "\u{993}",
        "\u{9aa}",
        "\u{9b2}",
        "\u{9b6}",
        "\u{9bd}",
        "\u{9ce}",
        "\u{9dc}",
        "\u{9df}",
        "\u{9f0}",
        "\u{9fc}",
        "\u{a05}",
        "\u{a0f}",
        "\u{a13}",
        "\u{a2a}",
        "\u{a32}",
        "\u{a35}",
        "\u{a38}",
        "\u{a59}",
        "\u{a5e}",
        "\u{a72}",
        "\u{a85}",
        "\u{a8f}",
        "\u{a93}",
        "\u{aaa}",
        "\u{ab2}",
        "\u{ab5}",
        "\u{abd}",
        "\u{ad0}",
        "\u{ae0}",
        "\u{af9}",
        "\u{b05}",
        "\u{b0f}",
        "\u{b13}",
        "\u{b2a}",
        "\u{b32}",
        "\u{b35}",
        "\u{b3d}",
        "\u{b5c}",
        "\u{b5f}",
        "\u{b71}",
        "\u{b83}",
        "\u{b85}",
        "\u{b8e}",
        "\u{b92}",
        "\u{b99}",
        "\u{b9c}",
        "\u{b9e}",
        "\u{ba3}",
        "\u{ba8}",
        "\u{bae}",
        "\u{bd0}",
        "\u{c05}",
        "\u{c0e}",
        "\u{c12}",
        "\u{c2a}",
        "\u{c3d}",
        "\u{c58}",
        "\u{c5d}",
        "\u{c60}",
        "\u{c80}",
        "\u{c85}",
        "\u{c8e}",
        "\u{c92}",
        "\u{caa}",
        "\u{cb5}",
        "\u{cbd}",
        "\u{cdd}",
        "\u{ce0}",
        "\u{cf1}",
        "\u{d04}",
        "\u{d0e}",
        "\u{d12}",
        "\u{d3d}",
        "\u{d4e}",
        "\u{d54}",
        "\u{d5f}",
        "\u{d7a}",
        "\u{d85}",
        "\u{d9a}",
        "\u{db3}",
        "\u{dbd}",
        "\u{dc0}",
        "\u{e01}",
        "\u{e32}",
        "\u{e40}",
        "\u{e81}",
        "\u{e84}",
        "\u{e86}",
        "\u{e8c}",
        "\u{ea5}",
        "\u{ea7}",
        "\u{eb2}",
        "\u{ebd}",
        "\u{ec0}",
        "\u{edc}",
        "\u{f00}",
        "\u{f40}",
        "\u{f49}",
        "\u{f88}",
        "\u{1000}",
        "\u{103f}",
        "\u{1050}",
        "\u{105a}",
        "\u{1061}",
        "\u{1065}",
        "\u{106e}",
        "\u{1075}",
        "\u{108e}",
        "\u{1100}",
        "\u{124a}",
        "\u{1250}",
        "\u{1258}",
        "\u{125a}",
        "\u{1260}",
        "\u{128a}",
        "\u{1290}",
        "\u{12b2}",
        "\u{12b8}",
        "\u{12c0}",
        "\u{12c2}",
        "\u{12c8}",
        "\u{12d8}",
        "\u{1312}",
        "\u{1318}",
        "\u{1380}",
        "\u{1401}",
        "\u{166f}",
        "\u{1681}",
        "\u{16a0}",
        "\u{16f1}",
        "\u{1700}",
        "\u{171f}",
        "\u{1740}",
        "\u{1760}",
        "\u{176e}",
        "\u{1780}",
        "\u{17dc}",
        "\u{1820}",
        "\u{1844}",
        "\u{1880}",
        "\u{1887}",
        "\u{18aa}",
        "\u{18b0}",
        "\u{1900}",
        "\u{1950}",
        "\u{1970}",
        "\u{1980}",
        "\u{19b0}",
        "\u{1a00}",
        "\u{1a20}",
        "\u{1b05}",
        "\u{1b45}",
        "\u{1b83}",
        "\u{1bae}",
        "\u{1bba}",
        "\u{1c00}",
        "\u{1c4d}",
        "\u{1c5a}",
        "\u{1ce9}",
        "\u{1cee}",
        "\u{1cf5}",
        "\u{1cfa}",
        "\u{2135}",
        "\u{2d30}",
        "\u{2d80}",
        "\u{2da0}",
        "\u{2da8}",
        "\u{2db0}",
        "\u{2db8}",
        "\u{2dc0}",
        "\u{2dc8}",
        "\u{2dd0}",
        "\u{2dd8}",
        "\u{3006}",
        "\u{303c}",
        "\u{3041}",
        "\u{309f}",
        "\u{30a1}",
        "\u{30ff}",
        "\u{3105}",
        "\u{3131}",
        "\u{31a0}",
        "\u{31f0}",
        "\u{3400}",
        "\u{4e00}",
        "\u{a016}",
        "\u{a4d0}",
        "\u{a500}",
        "\u{a610}",
        "\u{a62a}",
        "\u{a66e}",
        "\u{a6a0}",
        "\u{a78f}",
        "\u{a7f7}",
        "\u{a7fb}",
        "\u{a803}",
        "\u{a807}",
        "\u{a80c}",
        "\u{a840}",
        "\u{a882}",
        "\u{a8f2}",
        "\u{a8fb}",
        "\u{a8fd}",
        "\u{a90a}",
        "\u{a930}",
        "\u{a960}",
        "\u{a984}",
        "\u{a9e0}",
        "\u{a9e7}",
        "\u{a9fa}",
        "\u{aa00}",
        "\u{aa40}",
        "\u{aa44}",
        "\u{aa60}",
        "\u{aa71}",
        "\u{aa7a}",
        "\u{aa7e}",
        "\u{aab1}",
        "\u{aab5}",
        "\u{aab9}",
        "\u{aac0}",
        "\u{aac2}",
        "\u{aadb}",
        "\u{aae0}",
        "\u{aaf2}",
        "\u{ab01}",
        "\u{ab09}",
        "\u{ab11}",
        "\u{ab20}",
        "\u{ab28}",
        "\u{abc0}",
        "\u{ac00}",
        "\u{d7b0}",
        "\u{d7cb}",
        "\u{f900}",
        "\u{fa70}",
        "\u{fb1d}",
        "\u{fb1f}",
        "\u{fb2a}",
        "\u{fb38}",
        "\u{fb3e}",
        "\u{fb40}",
        "\u{fb43}",
        "\u{fb46}",
        "\u{fbd3}",
        "\u{fd50}",
        "\u{fd92}",
        "\u{fdf0}",
        "\u{fe70}",
        "\u{fe76}",
        "\u{ff66}",
        "\u{ff71}",
        "\u{ffa0}",
        "\u{ffc2}",
        "\u{ffca}",
        "\u{ffd2}",
        "\u{ffda}",
        "\u{10000}",
        "\u{1000d}",
        "\u{10028}",
        "\u{1003c}",
        "\u{1003f}",
        "\u{10050}",
        "\u{10080}",
        "\u{10280}",
        "\u{102a0}",
        "\u{10300}",
        "\u{1032d}",
        "\u{10342}",
        "\u{10350}",
        "\u{10380}",
        "\u{103a0}",
        "\u{103c8}",
        "\u{10450}",
        "\u{10500}",
        "\u{10530}",
        "\u{10600}",
        "\u{10740}",
        "\u{10760}",
        "\u{10800}",
        "\u{10808}",
        "\u{1080a}",
        "\u{10837}",
        "\u{1083c}",
        "\u{1083f}",
        "\u{10860}",
        "\u{10880}",
        "\u{108e0}",
        "\u{108f4}",
        "\u{10900}",
        "\u{10920}",
        "\u{10980}",
        "\u{109be}",
        "\u{10a00}",
        "\u{10a10}",
        "\u{10a15}",
        "\u{10a19}",
        "\u{10a60}",
        "\u{10a80}",
        "\u{10ac0}",
        "\u{10ac9}",
        "\u{10b00}",
        "\u{10b40}",
        "\u{10b60}",
        "\u{10b80}",
        "\u{10c00}",
        "\u{10d00}",
        "\u{10e80}",
        "\u{10eb0}",
        "\u{10f00}",
        "\u{10f27}",
        "\u{10f30}",
        "\u{10f70}",
        "\u{10fb0}",
        "\u{10fe0}",
        "\u{11003}",
        "\u{11071}",
        "\u{11075}",
        "\u{11083}",
        "\u{110d0}",
        "\u{11103}",
        "\u{11144}",
        "\u{11147}",
        "\u{11150}",
        "\u{11176}",
        "\u{11183}",
        "\u{111c1}",
        "\u{111da}",
        "\u{111dc}",
        "\u{11200}",
        "\u{11213}",
        "\u{1123f}",
        "\u{11280}",
        "\u{11288}",
        "\u{1128a}",
        "\u{1128f}",
        "\u{1129f}",
        "\u{112b0}",
        "\u{11305}",
        "\u{1130f}",
        "\u{11313}",
        "\u{1132a}",
        "\u{11332}",
        "\u{11335}",
        "\u{1133d}",
        "\u{11350}",
        "\u{1135d}",
        "\u{11400}",
        "\u{11447}",
        "\u{1145f}",
        "\u{11480}",
        "\u{114c4}",
        "\u{114c7}",
        "\u{11580}",
        "\u{115d8}",
        "\u{11600}",
        "\u{11644}",
        "\u{11680}",
        "\u{116b8}",
        "\u{11700}",
        "\u{11740}",
        "\u{11800}",
        "\u{118ff}",
        "\u{11909}",
        "\u{1190c}",
        "\u{11915}",
        "\u{11918}",
        "\u{1193f}",
        "\u{11941}",
        "\u{119a0}",
        "\u{119aa}",
        "\u{119e1}",
        "\u{119e3}",
        "\u{11a00}",
        "\u{11a0b}",
        "\u{11a3a}",
        "\u{11a50}",
        "\u{11a5c}",
        "\u{11a9d}",
        "\u{11ab0}",
        "\u{11c00}",
        "\u{11c0a}",
        "\u{11c40}",
        "\u{11c72}",
        "\u{11d00}",
        "\u{11d08}",
        "\u{11d0b}",
        "\u{11d46}",
        "\u{11d60}",
        "\u{11d67}",
        "\u{11d6a}",
        "\u{11d98}",
        "\u{11ee0}",
        "\u{11f02}",
        "\u{11f04}",
        "\u{11f12}",
        "\u{11fb0}",
        "\u{12000}",
        "\u{12480}",
        "\u{12f90}",
        "\u{13000}",
        "\u{13441}",
        "\u{14400}",
        "\u{16800}",
        "\u{16a40}",
        "\u{16a70}",
        "\u{16ad0}",
        "\u{16b00}",
        "\u{16b63}",
        "\u{16b7d}",
        "\u{16f00}",
        "\u{16f50}",
        "\u{17000}",
        "\u{18800}",
        "\u{18d00}",
        "\u{1b000}",
        "\u{1b132}",
        "\u{1b150}",
        "\u{1b155}",
        "\u{1b164}",
        "\u{1b170}",
        "\u{1bc00}",
        "\u{1bc70}",
        "\u{1bc80}",
        "\u{1bc90}",
        "\u{1df0a}",
        "\u{1e100}",
        "\u{1e14e}",
        "\u{1e290}",
        "\u{1e2c0}",
        "\u{1e4d0}",
        "\u{1e7e0}",
        "\u{1e7e8}",
        "\u{1e7ed}",
        "\u{1e7f0}",
        "\u{1e800}",
        "\u{1ee00}",
        "\u{1ee05}",
        "\u{1ee21}",
        "\u{1ee24}",
        "\u{1ee27}",
        "\u{1ee29}",
        "\u{1ee34}",
        "\u{1ee39}",
        "\u{1ee3b}",
        "\u{1ee42}",
        "\u{1ee47}",
        "\u{1ee49}",
        "\u{1ee4b}",
        "\u{1ee4d}",
        "\u{1ee51}",
        "\u{1ee54}",
        "\u{1ee57}",
        "\u{1ee59}",
        "\u{1ee5b}",
        "\u{1ee5d}",
        "\u{1ee5f}",
        "\u{1ee61}",
        "\u{1ee64}",
        "\u{1ee67}",
        "\u{1ee6c}",
        "\u{1ee74}",
        "\u{1ee79}",
        "\u{1ee7e}",
        "\u{1ee80}",
        "\u{1ee8b}",
        "\u{1eea1}",
        "\u{1eea5}",
        "\u{1eeab}",
        "\u{20000}",
        "\u{2a700}",
        "\u{2b740}",
        "\u{2b820}",
        "\u{2ceb0}",
        "\u{2ebf0}",
        "\u{2f800}",
        "\u{30000}",
        "\u{31350}",
        "\u{1c5}",
        "\u{1c8}",
        "\u{1cb}",
        "\u{1f2}",
        "\u{1f88}",
        "\u{1f98}",
        "\u{1fa8}",
        "\u{1fbc}",
        "\u{1fcc}",
        "\u{1ffc}",
        "\u{41}",
        "\u{c0}",
        "\u{d8}",
        "\u{100}",
        "\u{102}",
        "\u{104}",
        "\u{106}",
        "\u{108}",
        "\u{10a}",
        "\u{10c}",
        "\u{10e}",
        "\u{110}",
        "\u{112}",
        "\u{114}",
        "\u{116}",
        "\u{118}",
        "\u{11a}",
        "\u{11c}",
        "\u{11e}",
        "\u{120}",
        "\u{122}",
        "\u{124}",
        "\u{126}",
        "\u{128}",
        "\u{12a}",
        "\u{12c}",
        "\u{12e}",
        "\u{130}",
        "\u{132}",
        "\u{134}",
        "\u{136}",
        "\u{139}",
        "\u{13b}",
        "\u{13d}",
        "\u{13f}",
        "\u{141}",
        "\u{143}",
        "\u{145}",
        "\u{147}",
        "\u{14a}",
        "\u{14c}",
        "\u{14e}",
        "\u{150}",
        "\u{152}",
        "\u{154}",
        "\u{156}",
        "\u{158}",
        "\u{15a}",
        "\u{15c}",
        "\u{15e}",
        "\u{160}",
        "\u{162}",
        "\u{164}",
        "\u{166}",
        "\u{168}",
        "\u{16a}",
        "\u{16c}",
        "\u{16e}",
        "\u{170}",
        "\u{172}",
        "\u{174}",
        "\u{176}",
        "\u{178}",
        "\u{17b}",
        "\u{17d}",
        "\u{181}",
        "\u{184}",
        "\u{186}",
        "\u{189}",
        "\u{18e}",
        "\u{193}",
        "\u{196}",
        "\u{19c}",
        "\u{19f}",
        "\u{1a2}",
        "\u{1a4}",
        "\u{1a6}",
        "\u{1a9}",
        "\u{1ac}",
        "\u{1ae}",
        "\u{1b1}",
        "\u{1b5}",
        "\u{1b7}",
        "\u{1bc}",
        "\u{1c4}",
        "\u{1c7}",
        "\u{1ca}",
        "\u{1cd}",
        "\u{1cf}",
        "\u{1d1}",
        "\u{1d3}",
        "\u{1d5}",
        "\u{1d7}",
        "\u{1d9}",
        "\u{1db}",
        "\u{1de}",
        "\u{1e0}",
        "\u{1e2}",
        "\u{1e4}",
        "\u{1e6}",
        "\u{1e8}",
        "\u{1ea}",
        "\u{1ec}",
        "\u{1ee}",
        "\u{1f1}",
        "\u{1f4}",
        "\u{1f6}",
        "\u{1fa}",
        "\u{1fc}",
        "\u{1fe}",
        "\u{200}",
        "\u{202}",
        "\u{204}",
        "\u{206}",
        "\u{208}",
        "\u{20a}",
        "\u{20c}",
        "\u{20e}",
        "\u{210}",
        "\u{212}",
        "\u{214}",
        "\u{216}",
        "\u{218}",
        "\u{21a}",
        "\u{21c}",
        "\u{21e}",
        "\u{220}",
        "\u{222}",
        "\u{224}",
        "\u{226}",
        "\u{228}",
        "\u{22a}",
        "\u{22c}",
        "\u{22e}",
        "\u{230}",
        "\u{232}",
        "\u{23a}",
        "\u{23d}",
        "\u{241}",
        "\u{243}",
        "\u{248}",
        "\u{24a}",
        "\u{24c}",
        "\u{24e}",
        "\u{370}",
        "\u{372}",
        "\u{376}",
        "\u{37f}",
        "\u{386}",
        "\u{388}",
        "\u{38c}",
        "\u{38e}",
        "\u{391}",
        "\u{3a3}",
        "\u{3cf}",
        "\u{3d2}",
        "\u{3d8}",
        "\u{3da}",
        "\u{3dc}",
        "\u{3de}",
        "\u{3e0}",
        "\u{3e2}",
        "\u{3e4}",
        "\u{3e6}",
        "\u{3e8}",
        "\u{3ea}",
        "\u{3ec}",
        "\u{3ee}",
        "\u{3f4}",
        "\u{3f7}",
        "\u{3f9}",
        "\u{3fd}",
        "\u{460}",
        "\u{462}",
        "\u{464}",
        "\u{466}",
        "\u{468}",
        "\u{46a}",
        "\u{46c}",
        "\u{46e}",
        "\u{470}",
        "\u{472}",
        "\u{474}",
        "\u{476}",
        "\u{478}",
        "\u{47a}",
        "\u{47c}",
        "\u{47e}",
        "\u{480}",
        "\u{48a}",
        "\u{48c}",
        "\u{48e}",
        "\u{490}",
        "\u{492}",
        "\u{494}",
        "\u{496}",
        "\u{498}",
        "\u{49a}",
        "\u{49c}",
        "\u{49e}",
        "\u{4a0}",
        "\u{4a2}",
        "\u{4a4}",
        "\u{4a6}",
        "\u{4a8}",
        "\u{4aa}",
        "\u{4ac}",
        "\u{4ae}",
        "\u{4b0}",
        "\u{4b2}",
        "\u{4b4}",
        "\u{4b6}",
        "\u{4b8}",
        "\u{4ba}",
        "\u{4bc}",
        "\u{4be}",
        "\u{4c0}",
        "\u{4c3}",
        "\u{4c5}",
        "\u{4c7}",
        "\u{4c9}",
        "\u{4cb}",
        "\u{4cd}",
        "\u{4d0}",
        "\u{4d2}",
        "\u{4d4}",
        "\u{4d6}",
        "\u{4d8}",
        "\u{4da}",
        "\u{4dc}",
        "\u{4de}",
        "\u{4e0}",
        "\u{4e2}",
        "\u{4e4}",
        "\u{4e6}",
        "\u{4e8}",
        "\u{4ea}",
        "\u{4ec}",
        "\u{4ee}",
        "\u{4f0}",
        "\u{4f2}",
        "\u{4f4}",
        "\u{4f6}",
        "\u{4f8}",
        "\u{4fa}",
        "\u{4fc}",
        "\u{4fe}",
        "\u{500}",
        "\u{502}",
        "\u{504}",
        "\u{506}",
        "\u{508}",
        "\u{50a}",
        "\u{50c}",
        "\u{50e}",
        "\u{510}",
        "\u{512}",
        "\u{514}",
        "\u{516}",
        "\u{518}",
        "\u{51a}",
        "\u{51c}",
        "\u{51e}",
        "\u{520}",
        "\u{522}",
        "\u{524}",
        "\u{526}",
        "\u{528}",
        "\u{52a}",
        "\u{52c}",
        "\u{52e}",
        "\u{531}",
        "\u{10a0}",
        "\u{10c7}",
        "\u{10cd}",
        "\u{13a0}",
        "\u{1c90}",
        "\u{1cbd}",
        "\u{1e00}",
        "\u{1e02}",
        "\u{1e04}",
        "\u{1e06}",
        "\u{1e08}",
        "\u{1e0a}",
        "\u{1e0c}",
        "\u{1e0e}",
        "\u{1e10}",
        "\u{1e12}",
        "\u{1e14}",
        "\u{1e16}",
        "\u{1e18}",
        "\u{1e1a}",
        "\u{1e1c}",
        "\u{1e1e}",
        "\u{1e20}",
        "\u{1e22}",
        "\u{1e24}",
        "\u{1e26}",
        "\u{1e28}",
        "\u{1e2a}",
        "\u{1e2c}",
        "\u{1e2e}",
        "\u{1e30}",
        "\u{1e32}",
        "\u{1e34}",
        "\u{1e36}",
        "\u{1e38}",
        "\u{1e3a}",
        "\u{1e3c}",
        "\u{1e3e}",
        "\u{1e40}",
        "\u{1e42}",
        "\u{1e44}",
        "\u{1e46}",
        "\u{1e48}",
        "\u{1e4a}",
        "\u{1e4c}",
        "\u{1e4e}",
        "\u{1e50}",
        "\u{1e52}",
        "\u{1e54}",
        "\u{1e56}",
        "\u{1e58}",
        "\u{1e5a}",
        "\u{1e5c}",
        "\u{1e5e}",
        "\u{1e60}",
        "\u{1e62}",
        "\u{1e64}",
        "\u{1e66}",
        "\u{1e68}",
        "\u{1e6a}",
        "\u{1e6c}",
        "\u{1e6e}",
        "\u{1e70}",
        "\u{1e72}",
        "\u{1e74}",
        "\u{1e76}",
        "\u{1e78}",
        "\u{1e7a}",
        "\u{1e7c}",
        "\u{1e7e}",
        "\u{1e80}",
        "\u{1e82}",
        "\u{1e84}",
        "\u{1e86}",
        "\u{1e88}",
        "\u{1e8a}",
        "\u{1e8c}",
        "\u{1e8e}",
        "\u{1e90}",
        "\u{1e92}",
        "\u{1e94}",
        "\u{1e9e}",
        "\u{1ea0}",
        "\u{1ea2}",
        "\u{1ea4}",
        "\u{1ea6}",
        "\u{1ea8}",
        "\u{1eaa}",
        "\u{1eac}",
        "\u{1eae}",
        "\u{1eb0}",
        "\u{1eb2}",
        "\u{1eb4}",
        "\u{1eb6}",
        "\u{1eb8}",
        "\u{1eba}",
        "\u{1ebc}",
        "\u{1ebe}",
        "\u{1ec0}",
        "\u{1ec2}",
        "\u{1ec4}",
        "\u{1ec6}",
        "\u{1ec8}",
        "\u{1eca}",
        "\u{1ecc}",
        "\u{1ece}",
        "\u{1ed0}",
        "\u{1ed2}",
        "\u{1ed4}",
        "\u{1ed6}",
        "\u{1ed8}",
        "\u{1eda}",
        "\u{1edc}",
        "\u{1ede}",
        "\u{1ee0}",
        "\u{1ee2}",
        "\u{1ee4}",
        "\u{1ee6}",
        "\u{1ee8}",
        "\u{1eea}",
        "\u{1eec}",
        "\u{1eee}",
        "\u{1ef0}",
        "\u{1ef2}",
        "\u{1ef4}",
        "\u{1ef6}",
        "\u{1ef8}",
        "\u{1efa}",
        "\u{1efc}",
        "\u{1efe}",
        "\u{1f08}",
        "\u{1f18}",
        "\u{1f28}",
        "\u{1f38}",
        "\u{1f48}",
        "\u{1f59}",
        "\u{1f5b}",
        "\u{1f5d}",
        "\u{1f5f}",
        "\u{1f68}",
        "\u{1fb8}",
        "\u{1fc8}",
        "\u{1fd8}",
        "\u{1fe8}",
        "\u{1ff8}",
        "\u{2102}",
        "\u{2107}",
        "\u{210b}",
        "\u{2110}",
        "\u{2115}",
        "\u{2119}",
        "\u{2124}",
        "\u{2126}",
        "\u{2128}",
        "\u{212a}",
        "\u{2130}",
        "\u{213e}",
        "\u{2145}",
        "\u{2183}",
        "\u{2c00}",
        "\u{2c60}",
        "\u{2c62}",
        "\u{2c67}",
        "\u{2c69}",
        "\u{2c6b}",
        "\u{2c6d}",
        "\u{2c72}",
        "\u{2c75}",
        "\u{2c7e}",
        "\u{2c82}",
        "\u{2c84}",
        "\u{2c86}",
        "\u{2c88}",
        "\u{2c8a}",
        "\u{2c8c}",
        "\u{2c8e}",
        "\u{2c90}",
        "\u{2c92}",
        "\u{2c94}",
        "\u{2c96}",
        "\u{2c98}",
        "\u{2c9a}",
        "\u{2c9c}",
        "\u{2c9e}",
        "\u{2ca0}",
        "\u{2ca2}",
        "\u{2ca4}",
        "\u{2ca6}",
        "\u{2ca8}",
        "\u{2caa}",
        "\u{2cac}",
        "\u{2cae}",
        "\u{2cb0}",
        "\u{2cb2}",
        "\u{2cb4}",
        "\u{2cb6}",
        "\u{2cb8}",
        "\u{2cba}",
        "\u{2cbc}",
        "\u{2cbe}",
        "\u{2cc0}",
        "\u{2cc2}",
        "\u{2cc4}",
        "\u{2cc6}",
        "\u{2cc8}",
        "\u{2cca}",
        "\u{2ccc}",
        "\u{2cce}",
        "\u{2cd0}",
        "\u{2cd2}",
        "\u{2cd4}",
        "\u{2cd6}",
        "\u{2cd8}",
        "\u{2cda}",
        "\u{2cdc}",
        "\u{2cde}",
        "\u{2ce0}",
        "\u{2ce2}",
        "\u{2ceb}",
        "\u{2ced}",
        "\u{2cf2}",
        "\u{a640}",
        "\u{a642}",
        "\u{a644}",
        "\u{a646}",
        "\u{a648}",
        "\u{a64a}",
        "\u{a64c}",
        "\u{a64e}",
        "\u{a650}",
        "\u{a652}",
        "\u{a654}",
        "\u{a656}",
        "\u{a658}",
        "\u{a65a}",
        "\u{a65c}",
        "\u{a65e}",
        "\u{a660}",
        "\u{a662}",
        "\u{a664}",
        "\u{a666}",
        "\u{a668}",
        "\u{a66a}",
        "\u{a66c}",
        "\u{a680}",
        "\u{a682}",
        "\u{a684}",
        "\u{a686}",
        "\u{a688}",
        "\u{a68a}",
        "\u{a68c}",
        "\u{a68e}",
        "\u{a690}",
        "\u{a692}",
        "\u{a694}",
        "\u{a696}",
        "\u{a698}",
        "\u{a69a}",
        "\u{a722}",
        "\u{a724}",
        "\u{a726}",
        "\u{a728}",
        "\u{a72a}",
        "\u{a72c}",
        "\u{a72e}",
        "\u{a732}",
        "\u{a734}",
        "\u{a736}",
        "\u{a738}",
        "\u{a73a}",
        "\u{a73c}",
        "\u{a73e}",
        "\u{a740}",
        "\u{a742}",
        "\u{a744}",
        "\u{a746}",
        "\u{a748}",
        "\u{a74a}",
        "\u{a74c}",
        "\u{a74e}",
        "\u{a750}",
        "\u{a752}",
        "\u{a754}",
        "\u{a756}",
        "\u{a758}",
        "\u{a75a}",
        "\u{a75c}",
        "\u{a75e}",
        "\u{a760}",
        "\u{a762}",
        "\u{a764}",
        "\u{a766}",
        "\u{a768}",
        "\u{a76a}",
        "\u{a76c}",
        "\u{a76e}",
        "\u{a779}",
        "\u{a77b}",
        "\u{a77d}",
        "\u{a780}",
        "\u{a782}",
        "\u{a784}",
        "\u{a786}",
        "\u{a78b}",
        "\u{a78d}",
        "\u{a790}",
        "\u{a792}",
        "\u{a796}",
        "\u{a798}",
        "\u{a79a}",
        "\u{a79c}",
        "\u{a79e}",
        "\u{a7a0}",
        "\u{a7a2}",
        "\u{a7a4}",
        "\u{a7a6}",
        "\u{a7a8}",
        "\u{a7aa}",
        "\u{a7b0}",
        "\u{a7b6}",
        "\u{a7b8}",
        "\u{a7ba}",
        "\u{a7bc}",
        "\u{a7be}",
        "\u{a7c0}",
        "\u{a7c2}",
        "\u{a7c4}",
        "\u{a7c9}",
        "\u{a7d0}",
        "\u{a7d6}",
        "\u{a7d8}",
        "\u{a7f5}",
        "\u{ff21}",
        "\u{10400}",
        "\u{104b0}",
        "\u{10570}",
        "\u{1057c}",
        "\u{1058c}",
        "\u{10594}",
        "\u{10c80}",
        "\u{118a0}",
        "\u{16e40}",
        "\u{1d400}",
        "\u{1d434}",
        "\u{1d468}",
        "\u{1d49c}",
        "\u{1d49e}",
        "\u{1d4a2}",
        "\u{1d4a5}",
        "\u{1d4a9}",
        "\u{1d4ae}",
        "\u{1d4d0}",
        "\u{1d504}",
        "\u{1d507}",
        "\u{1d50d}",
        "\u{1d516}",
        "\u{1d538}",
        "\u{1d53b}",
        "\u{1d540}",
        "\u{1d546}",
        "\u{1d54a}",
        "\u{1d56c}",
        "\u{1d5a0}",
        "\u{1d5d4}",
        "\u{1d608}",
        "\u{1d63c}",
        "\u{1d670}",
        "\u{1d6a8}",
        "\u{1d6e2}",
        "\u{1d71c}",
        "\u{1d756}",
        "\u{1d790}",
        "\u{1d7ca}",
        "\u{1e900}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Letter}+$",
        "^\\p{gc=Letter}+$",
        "^\\p{Letter}+$",
        "^\\p{General_Category=L}+$",
        "^\\p{gc=L}+$",
        "^\\p{L}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_mark() {
    test_with_configs(unicode_escape_property_gc_mark_tc)
}

fn unicode_escape_property_gc_mark_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 533] = [
        "\u{903}",
        "\u{93b}",
        "\u{93e}",
        "\u{949}",
        "\u{94e}",
        "\u{982}",
        "\u{9be}",
        "\u{9c7}",
        "\u{9cb}",
        "\u{9d7}",
        "\u{a03}",
        "\u{a3e}",
        "\u{a83}",
        "\u{abe}",
        "\u{ac9}",
        "\u{acb}",
        "\u{b02}",
        "\u{b3e}",
        "\u{b40}",
        "\u{b47}",
        "\u{b4b}",
        "\u{b57}",
        "\u{bbe}",
        "\u{bc1}",
        "\u{bc6}",
        "\u{bca}",
        "\u{bd7}",
        "\u{c01}",
        "\u{c41}",
        "\u{c82}",
        "\u{cbe}",
        "\u{cc0}",
        "\u{cc7}",
        "\u{cca}",
        "\u{cd5}",
        "\u{cf3}",
        "\u{d02}",
        "\u{d3e}",
        "\u{d46}",
        "\u{d4a}",
        "\u{d57}",
        "\u{d82}",
        "\u{dcf}",
        "\u{dd8}",
        "\u{df2}",
        "\u{f3e}",
        "\u{f7f}",
        "\u{102b}",
        "\u{1031}",
        "\u{1038}",
        "\u{103b}",
        "\u{1056}",
        "\u{1062}",
        "\u{1067}",
        "\u{1083}",
        "\u{1087}",
        "\u{108f}",
        "\u{109a}",
        "\u{1715}",
        "\u{1734}",
        "\u{17b6}",
        "\u{17be}",
        "\u{17c7}",
        "\u{1923}",
        "\u{1929}",
        "\u{1930}",
        "\u{1933}",
        "\u{1a19}",
        "\u{1a55}",
        "\u{1a57}",
        "\u{1a61}",
        "\u{1a63}",
        "\u{1a6d}",
        "\u{1b04}",
        "\u{1b35}",
        "\u{1b3b}",
        "\u{1b3d}",
        "\u{1b43}",
        "\u{1b82}",
        "\u{1ba1}",
        "\u{1ba6}",
        "\u{1baa}",
        "\u{1be7}",
        "\u{1bea}",
        "\u{1bee}",
        "\u{1bf2}",
        "\u{1c24}",
        "\u{1c34}",
        "\u{1ce1}",
        "\u{1cf7}",
        "\u{302e}",
        "\u{a823}",
        "\u{a827}",
        "\u{a880}",
        "\u{a8b4}",
        "\u{a952}",
        "\u{a983}",
        "\u{a9b4}",
        "\u{a9ba}",
        "\u{a9be}",
        "\u{aa2f}",
        "\u{aa33}",
        "\u{aa4d}",
        "\u{aa7b}",
        "\u{aa7d}",
        "\u{aaeb}",
        "\u{aaee}",
        "\u{aaf5}",
        "\u{abe3}",
        "\u{abe6}",
        "\u{abe9}",
        "\u{abec}",
        "\u{11000}",
        "\u{11002}",
        "\u{11082}",
        "\u{110b0}",
        "\u{110b7}",
        "\u{1112c}",
        "\u{11145}",
        "\u{11182}",
        "\u{111b3}",
        "\u{111bf}",
        "\u{111ce}",
        "\u{1122c}",
        "\u{11232}",
        "\u{11235}",
        "\u{112e0}",
        "\u{11302}",
        "\u{1133e}",
        "\u{11341}",
        "\u{11347}",
        "\u{1134b}",
        "\u{11357}",
        "\u{11362}",
        "\u{11435}",
        "\u{11440}",
        "\u{11445}",
        "\u{114b0}",
        "\u{114b9}",
        "\u{114bb}",
        "\u{114c1}",
        "\u{115af}",
        "\u{115b8}",
        "\u{115be}",
        "\u{11630}",
        "\u{1163b}",
        "\u{1163e}",
        "\u{116ac}",
        "\u{116ae}",
        "\u{116b6}",
        "\u{11720}",
        "\u{11726}",
        "\u{1182c}",
        "\u{11838}",
        "\u{11930}",
        "\u{11937}",
        "\u{1193d}",
        "\u{11940}",
        "\u{11942}",
        "\u{119d1}",
        "\u{119dc}",
        "\u{119e4}",
        "\u{11a39}",
        "\u{11a57}",
        "\u{11a97}",
        "\u{11c2f}",
        "\u{11c3e}",
        "\u{11ca9}",
        "\u{11cb1}",
        "\u{11cb4}",
        "\u{11d8a}",
        "\u{11d93}",
        "\u{11d96}",
        "\u{11ef5}",
        "\u{11f03}",
        "\u{11f34}",
        "\u{11f3e}",
        "\u{11f41}",
        "\u{16f51}",
        "\u{16ff0}",
        "\u{1d165}",
        "\u{1d16d}",
        "\u{488}",
        "\u{1abe}",
        "\u{20dd}",
        "\u{20e2}",
        "\u{a670}",
        "\u{300}",
        "\u{483}",
        "\u{591}",
        "\u{5bf}",
        "\u{5c1}",
        "\u{5c4}",
        "\u{5c7}",
        "\u{610}",
        "\u{64b}",
        "\u{670}",
        "\u{6d6}",
        "\u{6df}",
        "\u{6e7}",
        "\u{6ea}",
        "\u{711}",
        "\u{730}",
        "\u{7a6}",
        "\u{7eb}",
        "\u{7fd}",
        "\u{816}",
        "\u{81b}",
        "\u{825}",
        "\u{829}",
        "\u{859}",
        "\u{898}",
        "\u{8ca}",
        "\u{8e3}",
        "\u{93a}",
        "\u{93c}",
        "\u{941}",
        "\u{94d}",
        "\u{951}",
        "\u{962}",
        "\u{981}",
        "\u{9bc}",
        "\u{9c1}",
        "\u{9cd}",
        "\u{9e2}",
        "\u{9fe}",
        "\u{a01}",
        "\u{a3c}",
        "\u{a41}",
        "\u{a47}",
        "\u{a4b}",
        "\u{a51}",
        "\u{a70}",
        "\u{a75}",
        "\u{a81}",
        "\u{abc}",
        "\u{ac1}",
        "\u{ac7}",
        "\u{acd}",
        "\u{ae2}",
        "\u{afa}",
        "\u{b01}",
        "\u{b3c}",
        "\u{b3f}",
        "\u{b41}",
        "\u{b4d}",
        "\u{b55}",
        "\u{b62}",
        "\u{b82}",
        "\u{bc0}",
        "\u{bcd}",
        "\u{c00}",
        "\u{c04}",
        "\u{c3c}",
        "\u{c3e}",
        "\u{c46}",
        "\u{c4a}",
        "\u{c55}",
        "\u{c62}",
        "\u{c81}",
        "\u{cbc}",
        "\u{cbf}",
        "\u{cc6}",
        "\u{ccc}",
        "\u{ce2}",
        "\u{d00}",
        "\u{d3b}",
        "\u{d41}",
        "\u{d4d}",
        "\u{d62}",
        "\u{d81}",
        "\u{dca}",
        "\u{dd2}",
        "\u{dd6}",
        "\u{e31}",
        "\u{e34}",
        "\u{e47}",
        "\u{eb1}",
        "\u{eb4}",
        "\u{ec8}",
        "\u{f18}",
        "\u{f35}",
        "\u{f37}",
        "\u{f39}",
        "\u{f71}",
        "\u{f80}",
        "\u{f86}",
        "\u{f8d}",
        "\u{f99}",
        "\u{fc6}",
        "\u{102d}",
        "\u{1032}",
        "\u{1039}",
        "\u{103d}",
        "\u{1058}",
        "\u{105e}",
        "\u{1071}",
        "\u{1082}",
        "\u{1085}",
        "\u{108d}",
        "\u{109d}",
        "\u{135d}",
        "\u{1712}",
        "\u{1732}",
        "\u{1752}",
        "\u{1772}",
        "\u{17b4}",
        "\u{17b7}",
        "\u{17c6}",
        "\u{17c9}",
        "\u{17dd}",
        "\u{180b}",
        "\u{180f}",
        "\u{1885}",
        "\u{18a9}",
        "\u{1920}",
        "\u{1927}",
        "\u{1932}",
        "\u{1939}",
        "\u{1a17}",
        "\u{1a1b}",
        "\u{1a56}",
        "\u{1a58}",
        "\u{1a60}",
        "\u{1a62}",
        "\u{1a65}",
        "\u{1a73}",
        "\u{1a7f}",
        "\u{1ab0}",
        "\u{1abf}",
        "\u{1b00}",
        "\u{1b34}",
        "\u{1b36}",
        "\u{1b3c}",
        "\u{1b42}",
        "\u{1b6b}",
        "\u{1b80}",
        "\u{1ba2}",
        "\u{1ba8}",
        "\u{1bab}",
        "\u{1be6}",
        "\u{1be8}",
        "\u{1bed}",
        "\u{1bef}",
        "\u{1c2c}",
        "\u{1c36}",
        "\u{1cd0}",
        "\u{1cd4}",
        "\u{1ce2}",
        "\u{1ced}",
        "\u{1cf4}",
        "\u{1cf8}",
        "\u{1dc0}",
        "\u{20d0}",
        "\u{20e1}",
        "\u{20e5}",
        "\u{2cef}",
        "\u{2d7f}",
        "\u{2de0}",
        "\u{302a}",
        "\u{3099}",
        "\u{a66f}",
        "\u{a674}",
        "\u{a69e}",
        "\u{a6f0}",
        "\u{a802}",
        "\u{a806}",
        "\u{a80b}",
        "\u{a825}",
        "\u{a82c}",
        "\u{a8c4}",
        "\u{a8e0}",
        "\u{a8ff}",
        "\u{a926}",
        "\u{a947}",
        "\u{a980}",
        "\u{a9b3}",
        "\u{a9b6}",
        "\u{a9bc}",
        "\u{a9e5}",
        "\u{aa29}",
        "\u{aa31}",
        "\u{aa35}",
        "\u{aa43}",
        "\u{aa4c}",
        "\u{aa7c}",
        "\u{aab0}",
        "\u{aab2}",
        "\u{aab7}",
        "\u{aabe}",
        "\u{aac1}",
        "\u{aaec}",
        "\u{aaf6}",
        "\u{abe5}",
        "\u{abe8}",
        "\u{abed}",
        "\u{fb1e}",
        "\u{fe00}",
        "\u{fe20}",
        "\u{101fd}",
        "\u{102e0}",
        "\u{10376}",
        "\u{10a01}",
        "\u{10a05}",
        "\u{10a0c}",
        "\u{10a38}",
        "\u{10a3f}",
        "\u{10ae5}",
        "\u{10d24}",
        "\u{10eab}",
        "\u{10efd}",
        "\u{10f46}",
        "\u{10f82}",
        "\u{11001}",
        "\u{11038}",
        "\u{11070}",
        "\u{11073}",
        "\u{1107f}",
        "\u{110b3}",
        "\u{110b9}",
        "\u{110c2}",
        "\u{11100}",
        "\u{11127}",
        "\u{1112d}",
        "\u{11173}",
        "\u{11180}",
        "\u{111b6}",
        "\u{111c9}",
        "\u{111cf}",
        "\u{1122f}",
        "\u{11234}",
        "\u{11236}",
        "\u{1123e}",
        "\u{11241}",
        "\u{112df}",
        "\u{112e3}",
        "\u{11300}",
        "\u{1133b}",
        "\u{11340}",
        "\u{11366}",
        "\u{11370}",
        "\u{11438}",
        "\u{11442}",
        "\u{11446}",
        "\u{1145e}",
        "\u{114b3}",
        "\u{114ba}",
        "\u{114bf}",
        "\u{114c2}",
        "\u{115b2}",
        "\u{115bc}",
        "\u{115bf}",
        "\u{115dc}",
        "\u{11633}",
        "\u{1163d}",
        "\u{1163f}",
        "\u{116ab}",
        "\u{116ad}",
        "\u{116b0}",
        "\u{116b7}",
        "\u{1171d}",
        "\u{11722}",
        "\u{11727}",
        "\u{1182f}",
        "\u{11839}",
        "\u{1193b}",
        "\u{1193e}",
        "\u{11943}",
        "\u{119d4}",
        "\u{119da}",
        "\u{119e0}",
        "\u{11a01}",
        "\u{11a33}",
        "\u{11a3b}",
        "\u{11a47}",
        "\u{11a51}",
        "\u{11a59}",
        "\u{11a8a}",
        "\u{11a98}",
        "\u{11c30}",
        "\u{11c38}",
        "\u{11c3f}",
        "\u{11c92}",
        "\u{11caa}",
        "\u{11cb2}",
        "\u{11cb5}",
        "\u{11d31}",
        "\u{11d3a}",
        "\u{11d3c}",
        "\u{11d3f}",
        "\u{11d47}",
        "\u{11d90}",
        "\u{11d95}",
        "\u{11d97}",
        "\u{11ef3}",
        "\u{11f00}",
        "\u{11f36}",
        "\u{11f40}",
        "\u{11f42}",
        "\u{13440}",
        "\u{13447}",
        "\u{16af0}",
        "\u{16b30}",
        "\u{16f4f}",
        "\u{16f8f}",
        "\u{16fe4}",
        "\u{1bc9d}",
        "\u{1cf00}",
        "\u{1cf30}",
        "\u{1d167}",
        "\u{1d17b}",
        "\u{1d185}",
        "\u{1d1aa}",
        "\u{1d242}",
        "\u{1da00}",
        "\u{1da3b}",
        "\u{1da75}",
        "\u{1da84}",
        "\u{1da9b}",
        "\u{1daa1}",
        "\u{1e000}",
        "\u{1e008}",
        "\u{1e01b}",
        "\u{1e023}",
        "\u{1e026}",
        "\u{1e08f}",
        "\u{1e130}",
        "\u{1e2ae}",
        "\u{1e2ec}",
        "\u{1e4ec}",
        "\u{1e8d0}",
        "\u{1e944}",
        "\u{e0100}",
    ];
    const REGEXES: [&str; 9] = [
        "^\\p{General_Category=Mark}+$",
        "^\\p{gc=Mark}+$",
        "^\\p{Mark}+$",
        "^\\p{General_Category=Combining_Mark}+$",
        "^\\p{gc=Combining_Mark}+$",
        "^\\p{Combining_Mark}+$",
        "^\\p{General_Category=M}+$",
        "^\\p{gc=M}+$",
        "^\\p{M}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_number() {
    test_with_configs(unicode_escape_property_gc_number_tc)
}

fn unicode_escape_property_gc_number_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 148] = [
        "\u{30}",
        "\u{660}",
        "\u{6f0}",
        "\u{7c0}",
        "\u{966}",
        "\u{9e6}",
        "\u{a66}",
        "\u{ae6}",
        "\u{b66}",
        "\u{be6}",
        "\u{c66}",
        "\u{ce6}",
        "\u{d66}",
        "\u{de6}",
        "\u{e50}",
        "\u{ed0}",
        "\u{f20}",
        "\u{1040}",
        "\u{1090}",
        "\u{17e0}",
        "\u{1810}",
        "\u{1946}",
        "\u{19d0}",
        "\u{1a80}",
        "\u{1a90}",
        "\u{1b50}",
        "\u{1bb0}",
        "\u{1c40}",
        "\u{1c50}",
        "\u{a620}",
        "\u{a8d0}",
        "\u{a900}",
        "\u{a9d0}",
        "\u{a9f0}",
        "\u{aa50}",
        "\u{abf0}",
        "\u{ff10}",
        "\u{104a0}",
        "\u{10d30}",
        "\u{11066}",
        "\u{110f0}",
        "\u{11136}",
        "\u{111d0}",
        "\u{112f0}",
        "\u{11450}",
        "\u{114d0}",
        "\u{11650}",
        "\u{116c0}",
        "\u{11730}",
        "\u{118e0}",
        "\u{11950}",
        "\u{11c50}",
        "\u{11d50}",
        "\u{11da0}",
        "\u{11f50}",
        "\u{16a60}",
        "\u{16ac0}",
        "\u{16b50}",
        "\u{1d7ce}",
        "\u{1e140}",
        "\u{1e2f0}",
        "\u{1e4f0}",
        "\u{1e950}",
        "\u{1fbf0}",
        "\u{16ee}",
        "\u{2160}",
        "\u{2185}",
        "\u{3007}",
        "\u{3021}",
        "\u{3038}",
        "\u{a6e6}",
        "\u{10140}",
        "\u{10341}",
        "\u{1034a}",
        "\u{103d1}",
        "\u{12400}",
        "\u{b2}",
        "\u{b9}",
        "\u{bc}",
        "\u{9f4}",
        "\u{b72}",
        "\u{bf0}",
        "\u{c78}",
        "\u{d58}",
        "\u{d70}",
        "\u{f2a}",
        "\u{1369}",
        "\u{17f0}",
        "\u{19da}",
        "\u{2070}",
        "\u{2074}",
        "\u{2080}",
        "\u{2150}",
        "\u{2189}",
        "\u{2460}",
        "\u{24ea}",
        "\u{2776}",
        "\u{2cfd}",
        "\u{3192}",
        "\u{3220}",
        "\u{3248}",
        "\u{3251}",
        "\u{3280}",
        "\u{32b1}",
        "\u{a830}",
        "\u{10107}",
        "\u{10175}",
        "\u{1018a}",
        "\u{102e1}",
        "\u{10320}",
        "\u{10858}",
        "\u{10879}",
        "\u{108a7}",
        "\u{108fb}",
        "\u{10916}",
        "\u{109bc}",
        "\u{109c0}",
        "\u{109d2}",
        "\u{10a40}",
        "\u{10a7d}",
        "\u{10a9d}",
        "\u{10aeb}",
        "\u{10b58}",
        "\u{10b78}",
        "\u{10ba9}",
        "\u{10cfa}",
        "\u{10e60}",
        "\u{10f1d}",
        "\u{10f51}",
        "\u{10fc5}",
        "\u{11052}",
        "\u{111e1}",
        "\u{1173a}",
        "\u{118ea}",
        "\u{11c5a}",
        "\u{11fc0}",
        "\u{16b5b}",
        "\u{16e80}",
        "\u{1d2c0}",
        "\u{1d2e0}",
        "\u{1d360}",
        "\u{1e8c7}",
        "\u{1ec71}",
        "\u{1ecad}",
        "\u{1ecb1}",
        "\u{1ed01}",
        "\u{1ed2f}",
        "\u{1f100}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Number}+$",
        "^\\p{gc=Number}+$",
        "^\\p{Number}+$",
        "^\\p{General_Category=N}+$",
        "^\\p{gc=N}+$",
        "^\\p{N}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_punctuation() {
    test_with_configs(unicode_escape_property_gc_punctuation_tc)
}

fn unicode_escape_property_gc_punctuation_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 388] = [
        "\u{5f}",
        "\u{203f}",
        "\u{2054}",
        "\u{fe33}",
        "\u{fe4d}",
        "\u{ff3f}",
        "\u{2d}",
        "\u{58a}",
        "\u{5be}",
        "\u{1400}",
        "\u{1806}",
        "\u{2010}",
        "\u{2e17}",
        "\u{2e1a}",
        "\u{2e3a}",
        "\u{2e40}",
        "\u{2e5d}",
        "\u{301c}",
        "\u{3030}",
        "\u{30a0}",
        "\u{fe31}",
        "\u{fe58}",
        "\u{fe63}",
        "\u{ff0d}",
        "\u{10ead}",
        "\u{29}",
        "\u{5d}",
        "\u{7d}",
        "\u{f3b}",
        "\u{f3d}",
        "\u{169c}",
        "\u{2046}",
        "\u{207e}",
        "\u{208e}",
        "\u{2309}",
        "\u{230b}",
        "\u{232a}",
        "\u{2769}",
        "\u{276b}",
        "\u{276d}",
        "\u{276f}",
        "\u{2771}",
        "\u{2773}",
        "\u{2775}",
        "\u{27c6}",
        "\u{27e7}",
        "\u{27e9}",
        "\u{27eb}",
        "\u{27ed}",
        "\u{27ef}",
        "\u{2984}",
        "\u{2986}",
        "\u{2988}",
        "\u{298a}",
        "\u{298c}",
        "\u{298e}",
        "\u{2990}",
        "\u{2992}",
        "\u{2994}",
        "\u{2996}",
        "\u{2998}",
        "\u{29d9}",
        "\u{29db}",
        "\u{29fd}",
        "\u{2e23}",
        "\u{2e25}",
        "\u{2e27}",
        "\u{2e29}",
        "\u{2e56}",
        "\u{2e58}",
        "\u{2e5a}",
        "\u{2e5c}",
        "\u{3009}",
        "\u{300b}",
        "\u{300d}",
        "\u{300f}",
        "\u{3011}",
        "\u{3015}",
        "\u{3017}",
        "\u{3019}",
        "\u{301b}",
        "\u{301e}",
        "\u{fd3e}",
        "\u{fe18}",
        "\u{fe36}",
        "\u{fe38}",
        "\u{fe3a}",
        "\u{fe3c}",
        "\u{fe3e}",
        "\u{fe40}",
        "\u{fe42}",
        "\u{fe44}",
        "\u{fe48}",
        "\u{fe5a}",
        "\u{fe5c}",
        "\u{fe5e}",
        "\u{ff09}",
        "\u{ff3d}",
        "\u{ff5d}",
        "\u{ff60}",
        "\u{ff63}",
        "\u{bb}",
        "\u{2019}",
        "\u{201d}",
        "\u{203a}",
        "\u{2e03}",
        "\u{2e05}",
        "\u{2e0a}",
        "\u{2e0d}",
        "\u{2e1d}",
        "\u{2e21}",
        "\u{ab}",
        "\u{2018}",
        "\u{201b}",
        "\u{201f}",
        "\u{2039}",
        "\u{2e02}",
        "\u{2e04}",
        "\u{2e09}",
        "\u{2e0c}",
        "\u{2e1c}",
        "\u{2e20}",
        "\u{21}",
        "\u{25}",
        "\u{2a}",
        "\u{2c}",
        "\u{2e}",
        "\u{3a}",
        "\u{3f}",
        "\u{5c}",
        "\u{a1}",
        "\u{a7}",
        "\u{b6}",
        "\u{bf}",
        "\u{37e}",
        "\u{387}",
        "\u{55a}",
        "\u{589}",
        "\u{5c0}",
        "\u{5c3}",
        "\u{5c6}",
        "\u{5f3}",
        "\u{609}",
        "\u{60c}",
        "\u{61b}",
        "\u{61d}",
        "\u{66a}",
        "\u{6d4}",
        "\u{700}",
        "\u{7f7}",
        "\u{830}",
        "\u{85e}",
        "\u{964}",
        "\u{970}",
        "\u{9fd}",
        "\u{a76}",
        "\u{af0}",
        "\u{c77}",
        "\u{c84}",
        "\u{df4}",
        "\u{e4f}",
        "\u{e5a}",
        "\u{f04}",
        "\u{f14}",
        "\u{f85}",
        "\u{fd0}",
        "\u{fd9}",
        "\u{104a}",
        "\u{10fb}",
        "\u{1360}",
        "\u{166e}",
        "\u{16eb}",
        "\u{1735}",
        "\u{17d4}",
        "\u{17d8}",
        "\u{1800}",
        "\u{1807}",
        "\u{1944}",
        "\u{1a1e}",
        "\u{1aa0}",
        "\u{1aa8}",
        "\u{1b5a}",
        "\u{1b7d}",
        "\u{1bfc}",
        "\u{1c3b}",
        "\u{1c7e}",
        "\u{1cc0}",
        "\u{1cd3}",
        "\u{2016}",
        "\u{2020}",
        "\u{2030}",
        "\u{203b}",
        "\u{2041}",
        "\u{2047}",
        "\u{2053}",
        "\u{2055}",
        "\u{2cf9}",
        "\u{2cfe}",
        "\u{2d70}",
        "\u{2e00}",
        "\u{2e06}",
        "\u{2e0b}",
        "\u{2e0e}",
        "\u{2e18}",
        "\u{2e1b}",
        "\u{2e1e}",
        "\u{2e2a}",
        "\u{2e30}",
        "\u{2e3c}",
        "\u{2e41}",
        "\u{2e43}",
        "\u{2e52}",
        "\u{3001}",
        "\u{303d}",
        "\u{30fb}",
        "\u{a4fe}",
        "\u{a60d}",
        "\u{a673}",
        "\u{a67e}",
        "\u{a6f2}",
        "\u{a874}",
        "\u{a8ce}",
        "\u{a8f8}",
        "\u{a8fc}",
        "\u{a92e}",
        "\u{a95f}",
        "\u{a9c1}",
        "\u{a9de}",
        "\u{aa5c}",
        "\u{aade}",
        "\u{aaf0}",
        "\u{abeb}",
        "\u{fe10}",
        "\u{fe19}",
        "\u{fe30}",
        "\u{fe45}",
        "\u{fe49}",
        "\u{fe50}",
        "\u{fe54}",
        "\u{fe5f}",
        "\u{fe68}",
        "\u{fe6a}",
        "\u{ff01}",
        "\u{ff05}",
        "\u{ff0a}",
        "\u{ff0c}",
        "\u{ff0e}",
        "\u{ff1a}",
        "\u{ff1f}",
        "\u{ff3c}",
        "\u{ff61}",
        "\u{ff64}",
        "\u{10100}",
        "\u{1039f}",
        "\u{103d0}",
        "\u{1056f}",
        "\u{10857}",
        "\u{1091f}",
        "\u{1093f}",
        "\u{10a50}",
        "\u{10a7f}",
        "\u{10af0}",
        "\u{10b39}",
        "\u{10b99}",
        "\u{10f55}",
        "\u{10f86}",
        "\u{11047}",
        "\u{110bb}",
        "\u{110be}",
        "\u{11140}",
        "\u{11174}",
        "\u{111c5}",
        "\u{111cd}",
        "\u{111db}",
        "\u{111dd}",
        "\u{11238}",
        "\u{112a9}",
        "\u{1144b}",
        "\u{1145a}",
        "\u{1145d}",
        "\u{114c6}",
        "\u{115c1}",
        "\u{11641}",
        "\u{11660}",
        "\u{116b9}",
        "\u{1173c}",
        "\u{1183b}",
        "\u{11944}",
        "\u{119e2}",
        "\u{11a3f}",
        "\u{11a9a}",
        "\u{11a9e}",
        "\u{11b00}",
        "\u{11c41}",
        "\u{11c70}",
        "\u{11ef7}",
        "\u{11f43}",
        "\u{11fff}",
        "\u{12470}",
        "\u{12ff1}",
        "\u{16a6e}",
        "\u{16af5}",
        "\u{16b37}",
        "\u{16b44}",
        "\u{16e97}",
        "\u{16fe2}",
        "\u{1bc9f}",
        "\u{1da87}",
        "\u{1e95e}",
        "\u{28}",
        "\u{5b}",
        "\u{7b}",
        "\u{f3a}",
        "\u{f3c}",
        "\u{169b}",
        "\u{201a}",
        "\u{201e}",
        "\u{2045}",
        "\u{207d}",
        "\u{208d}",
        "\u{2308}",
        "\u{230a}",
        "\u{2329}",
        "\u{2768}",
        "\u{276a}",
        "\u{276c}",
        "\u{276e}",
        "\u{2770}",
        "\u{2772}",
        "\u{2774}",
        "\u{27c5}",
        "\u{27e6}",
        "\u{27e8}",
        "\u{27ea}",
        "\u{27ec}",
        "\u{27ee}",
        "\u{2983}",
        "\u{2985}",
        "\u{2987}",
        "\u{2989}",
        "\u{298b}",
        "\u{298d}",
        "\u{298f}",
        "\u{2991}",
        "\u{2993}",
        "\u{2995}",
        "\u{2997}",
        "\u{29d8}",
        "\u{29da}",
        "\u{29fc}",
        "\u{2e22}",
        "\u{2e24}",
        "\u{2e26}",
        "\u{2e28}",
        "\u{2e42}",
        "\u{2e55}",
        "\u{2e57}",
        "\u{2e59}",
        "\u{2e5b}",
        "\u{3008}",
        "\u{300a}",
        "\u{300c}",
        "\u{300e}",
        "\u{3010}",
        "\u{3014}",
        "\u{3016}",
        "\u{3018}",
        "\u{301a}",
        "\u{301d}",
        "\u{fd3f}",
        "\u{fe17}",
        "\u{fe35}",
        "\u{fe37}",
        "\u{fe39}",
        "\u{fe3b}",
        "\u{fe3d}",
        "\u{fe3f}",
        "\u{fe41}",
        "\u{fe43}",
        "\u{fe47}",
        "\u{fe59}",
        "\u{fe5b}",
        "\u{fe5d}",
        "\u{ff08}",
        "\u{ff3b}",
        "\u{ff5b}",
        "\u{ff5f}",
        "\u{ff62}",
    ];
    const REGEXES: [&str; 9] = [
        "^\\p{General_Category=Punctuation}+$",
        "^\\p{gc=Punctuation}+$",
        "^\\p{Punctuation}+$",
        "^\\p{General_Category=punct}+$",
        "^\\p{gc=punct}+$",
        "^\\p{punct}+$",
        "^\\p{General_Category=P}+$",
        "^\\p{gc=P}+$",
        "^\\p{P}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_symbol() {
    test_with_configs(unicode_escape_property_gc_symbol_tc)
}

fn unicode_escape_property_gc_symbol_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 301] = [
        "\u{24}",
        "\u{a2}",
        "\u{58f}",
        "\u{60b}",
        "\u{7fe}",
        "\u{9f2}",
        "\u{9fb}",
        "\u{af1}",
        "\u{bf9}",
        "\u{e3f}",
        "\u{17db}",
        "\u{20a0}",
        "\u{a838}",
        "\u{fdfc}",
        "\u{fe69}",
        "\u{ff04}",
        "\u{ffe0}",
        "\u{ffe5}",
        "\u{11fdd}",
        "\u{1e2ff}",
        "\u{1ecb0}",
        "\u{5e}",
        "\u{60}",
        "\u{a8}",
        "\u{af}",
        "\u{b4}",
        "\u{b8}",
        "\u{2c2}",
        "\u{2d2}",
        "\u{2e5}",
        "\u{2ed}",
        "\u{2ef}",
        "\u{375}",
        "\u{384}",
        "\u{888}",
        "\u{1fbd}",
        "\u{1fbf}",
        "\u{1fcd}",
        "\u{1fdd}",
        "\u{1fed}",
        "\u{1ffd}",
        "\u{309b}",
        "\u{a700}",
        "\u{a720}",
        "\u{a789}",
        "\u{ab5b}",
        "\u{ab6a}",
        "\u{fbb2}",
        "\u{ff3e}",
        "\u{ff40}",
        "\u{ffe3}",
        "\u{1f3fb}",
        "\u{2b}",
        "\u{3c}",
        "\u{7c}",
        "\u{7e}",
        "\u{ac}",
        "\u{b1}",
        "\u{d7}",
        "\u{f7}",
        "\u{3f6}",
        "\u{606}",
        "\u{2044}",
        "\u{2052}",
        "\u{207a}",
        "\u{208a}",
        "\u{2118}",
        "\u{2140}",
        "\u{214b}",
        "\u{2190}",
        "\u{219a}",
        "\u{21a0}",
        "\u{21a3}",
        "\u{21a6}",
        "\u{21ae}",
        "\u{21ce}",
        "\u{21d2}",
        "\u{21d4}",
        "\u{21f4}",
        "\u{2320}",
        "\u{237c}",
        "\u{239b}",
        "\u{23dc}",
        "\u{25b7}",
        "\u{25c1}",
        "\u{25f8}",
        "\u{266f}",
        "\u{27c0}",
        "\u{27c7}",
        "\u{27f0}",
        "\u{2900}",
        "\u{2999}",
        "\u{29dc}",
        "\u{29fe}",
        "\u{2b30}",
        "\u{2b47}",
        "\u{fb29}",
        "\u{fe62}",
        "\u{fe64}",
        "\u{ff0b}",
        "\u{ff1c}",
        "\u{ff5c}",
        "\u{ff5e}",
        "\u{ffe2}",
        "\u{ffe9}",
        "\u{1d6c1}",
        "\u{1d6db}",
        "\u{1d6fb}",
        "\u{1d715}",
        "\u{1d735}",
        "\u{1d74f}",
        "\u{1d76f}",
        "\u{1d789}",
        "\u{1d7a9}",
        "\u{1d7c3}",
        "\u{1eef0}",
        "\u{a6}",
        "\u{a9}",
        "\u{ae}",
        "\u{b0}",
        "\u{482}",
        "\u{58d}",
        "\u{60e}",
        "\u{6de}",
        "\u{6e9}",
        "\u{6fd}",
        "\u{7f6}",
        "\u{9fa}",
        "\u{b70}",
        "\u{bf3}",
        "\u{bfa}",
        "\u{c7f}",
        "\u{d4f}",
        "\u{d79}",
        "\u{f01}",
        "\u{f13}",
        "\u{f15}",
        "\u{f1a}",
        "\u{f34}",
        "\u{f36}",
        "\u{f38}",
        "\u{fbe}",
        "\u{fc7}",
        "\u{fce}",
        "\u{fd5}",
        "\u{109e}",
        "\u{1390}",
        "\u{166d}",
        "\u{1940}",
        "\u{19de}",
        "\u{1b61}",
        "\u{1b74}",
        "\u{2100}",
        "\u{2103}",
        "\u{2108}",
        "\u{2114}",
        "\u{2116}",
        "\u{211e}",
        "\u{2125}",
        "\u{2127}",
        "\u{2129}",
        "\u{212e}",
        "\u{213a}",
        "\u{214a}",
        "\u{214c}",
        "\u{214f}",
        "\u{218a}",
        "\u{2195}",
        "\u{219c}",
        "\u{21a1}",
        "\u{21a4}",
        "\u{21a7}",
        "\u{21af}",
        "\u{21d0}",
        "\u{21d3}",
        "\u{21d5}",
        "\u{2300}",
        "\u{230c}",
        "\u{2322}",
        "\u{232b}",
        "\u{237d}",
        "\u{23b4}",
        "\u{23e2}",
        "\u{2440}",
        "\u{249c}",
        "\u{2500}",
        "\u{25b8}",
        "\u{25c2}",
        "\u{2600}",
        "\u{2670}",
        "\u{2794}",
        "\u{2800}",
        "\u{2b00}",
        "\u{2b45}",
        "\u{2b4d}",
        "\u{2b76}",
        "\u{2b97}",
        "\u{2ce5}",
        "\u{2e50}",
        "\u{2e80}",
        "\u{2e9b}",
        "\u{2f00}",
        "\u{2ff0}",
        "\u{3004}",
        "\u{3012}",
        "\u{3020}",
        "\u{3036}",
        "\u{303e}",
        "\u{3190}",
        "\u{3196}",
        "\u{31c0}",
        "\u{31ef}",
        "\u{3200}",
        "\u{322a}",
        "\u{3250}",
        "\u{3260}",
        "\u{328a}",
        "\u{32c0}",
        "\u{4dc0}",
        "\u{a490}",
        "\u{a828}",
        "\u{a836}",
        "\u{a839}",
        "\u{aa77}",
        "\u{fd40}",
        "\u{fdcf}",
        "\u{fdfd}",
        "\u{ffe4}",
        "\u{ffe8}",
        "\u{ffed}",
        "\u{fffc}",
        "\u{10137}",
        "\u{10179}",
        "\u{1018c}",
        "\u{10190}",
        "\u{101a0}",
        "\u{101d0}",
        "\u{10877}",
        "\u{10ac8}",
        "\u{1173f}",
        "\u{11fd5}",
        "\u{11fe1}",
        "\u{16b3c}",
        "\u{16b45}",
        "\u{1bc9c}",
        "\u{1cf50}",
        "\u{1d000}",
        "\u{1d100}",
        "\u{1d129}",
        "\u{1d16a}",
        "\u{1d183}",
        "\u{1d18c}",
        "\u{1d1ae}",
        "\u{1d200}",
        "\u{1d245}",
        "\u{1d300}",
        "\u{1d800}",
        "\u{1da37}",
        "\u{1da6d}",
        "\u{1da76}",
        "\u{1da85}",
        "\u{1e14f}",
        "\u{1ecac}",
        "\u{1ed2e}",
        "\u{1f000}",
        "\u{1f030}",
        "\u{1f0a0}",
        "\u{1f0b1}",
        "\u{1f0c1}",
        "\u{1f0d1}",
        "\u{1f10d}",
        "\u{1f1e6}",
        "\u{1f210}",
        "\u{1f240}",
        "\u{1f250}",
        "\u{1f260}",
        "\u{1f300}",
        "\u{1f400}",
        "\u{1f6dc}",
        "\u{1f6f0}",
        "\u{1f700}",
        "\u{1f77b}",
        "\u{1f7e0}",
        "\u{1f7f0}",
        "\u{1f800}",
        "\u{1f810}",
        "\u{1f850}",
        "\u{1f860}",
        "\u{1f890}",
        "\u{1f8b0}",
        "\u{1f900}",
        "\u{1fa60}",
        "\u{1fa70}",
        "\u{1fa80}",
        "\u{1fa90}",
        "\u{1fabf}",
        "\u{1face}",
        "\u{1fae0}",
        "\u{1faf0}",
        "\u{1fb00}",
        "\u{1fb94}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Symbol}+$",
        "^\\p{gc=Symbol}+$",
        "^\\p{Symbol}+$",
        "^\\p{General_Category=S}+$",
        "^\\p{gc=S}+$",
        "^\\p{S}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}

#[test]
fn unicode_escape_property_gc_separator() {
    test_with_configs(unicode_escape_property_gc_separator_tc)
}

fn unicode_escape_property_gc_separator_tc(tc: TestConfig) {
    const CODE_POINTS: [&str; 9] = [
        "\u{2028}", "\u{2029}", "\u{20}", "\u{a0}", "\u{1680}", "\u{2000}", "\u{202f}", "\u{205f}",
        "\u{3000}",
    ];
    const REGEXES: [&str; 6] = [
        "^\\p{General_Category=Separator}+$",
        "^\\p{gc=Separator}+$",
        "^\\p{Separator}+$",
        "^\\p{General_Category=Z}+$",
        "^\\p{gc=Z}+$",
        "^\\p{Z}+$",
    ];
    for regex in REGEXES {
        let regex = tc.compilef(regex, "u");
        for code_point in CODE_POINTS {
            regex.test_succeeds(code_point);
        }
    }
}
