/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import junit.framework.TestCase;
import org.mvel.PropertyAccessor;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;

public class PropertyAccessUnitTest
extends TestCase {
    Base base = new Base();

    public void testPropertyRead() {
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get("data", this.base));
    }

    public void testDeepPropertyRead() {
        PropertyAccessUnitTest.assertEquals((Object)"dog", (Object)PropertyAccessor.get("foo.bar.name", this.base));
    }

    public void testWrite() {
        PropertyAccessor.set(this.base, "foo.bar.name", "cat");
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get("foo.bar.name", this.base));
        PropertyAccessor.set(this.base, "foo.bar.name", "dog");
    }

    public void testCollectionsAccess() {
        PropertyAccessor.set(this.base, "funMap['foo'].bar.name", "cat");
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get("funMap['foo'].bar.name", this.base));
    }

    public void testMethodInvoke() {
        PropertyAccessUnitTest.assertEquals((Object)"WOOF", (Object)PropertyAccessor.get("foo.toUC('woof')", this.base));
    }

    public void testMethodInvoke2() {
        PropertyAccessUnitTest.assertEquals((Object)"happyBar", (Object)PropertyAccessor.get("foo.happy()", this.base));
    }

    public void testMapDirect() {
        PropertyAccessUnitTest.assertTrue((boolean)(PropertyAccessor.get("funMap['foo']", this.base) instanceof Foo));
    }

    public void testArrayAccess() {
        String[] a = new String[]{"foo", "bar"};
        PropertyAccessUnitTest.assertEquals((Object)"foo", (Object)PropertyAccessor.get("[0]", a));
    }

    public void testArrayAccess2() {
        PropertyAccessUnitTest.assertEquals((Object)"poo", (Object)PropertyAccessor.get("[0][0]", new Object[]{new String[]{"poo"}}));
    }

    public void testStaticMethodAccess() {
        PropertyAccessUnitTest.assertEquals(String.class, (Object)PropertyAccessor.get("forName('java.lang.String')", Class.class));
    }
}

