MusicBrainz Picard Installation
===============================

Dependencies
------------

Before installing Picard from source, you need to check you have the following dependencies installed.

Required:

* [Python 3.10 or newer](https://www.python.org/downloads/)
* [PyQt 6.5 or newer](https://riverbankcomputing.com/software/pyqt/download)
* [Mutagen 1.45 or newer](https://mutagen.readthedocs.io/)
* [PyYAML 5.1 or newer](https://pyyaml.org/)
* [python-dateutil](https://dateutil.readthedocs.io/en/stable/)
* gettext (`msgfmt`):
  * **Windows:** Download and install from [https://github.com/mlocati/gettext-iconv-windows/releases](https://github.com/mlocati/gettext-iconv-windows/releases) (e.g. `gettext0.25.1-iconv1.17-shared-64.exe`) and add `C:\Program Files\gettext-iconv\bin` to your PATH variable.
  * **Linux:** `sudo apt install gettext` (Ubuntu/Debian) or equivalent for your distribution
  * **macOS:** Usually included with Xcode Command Line Tools. If not: `brew install gettext`
* a compiler
  * Windows should work with [Visual Studio Community 2019](https://aka.ms/vs/16/release/vs_community.exe)

Optional but recommended:

* [chromaprint](https://acoustid.org/chromaprint)
  * Required for fingerprinting (scanning) files
* [python-discid](https://python-discid.readthedocs.org/) or [python-libdiscid](https://pypi.org/project/python-libdiscid/)
  * Required for CD lookups.
  * Depends on [libdiscid](https://musicbrainz.org/doc/libdiscid)
   Note: Due to slowdowns in reading the CD TOC, using libdiscid versions
   0.3.0 - 0.4.1 is not recommended.
* [python-markdown](https://python-markdown.github.io/install/)
  * Required for the complete scripting documentation
* [PyJWT 1.7 or newer](https://pyjwt.readthedocs.io/)
  * Required for the add cluster as release / add file as recording functionality
* [charset_normalizer](https://pypi.org/project/charset-normalizer/) or [chardet](https://pypi.org/project/chardet/)
  * Required for character encoding detection in CD ripping log files

We recommend you use [uv](https://docs.astral.sh/uv/) to install the Python dependencies.

**Using uv (recommended, faster):**

    # Install uv first (optional but recommended)
    # macOS/Linux: curl -LsSf https://astral.sh/uv/install.sh | sh
    # Windows: powershell -ExecutionPolicy ByPass -c "irm https://astral.sh/uv/install.ps1 | iex"

    # Installing the dependencies (main, build, and dev)
    uv sync

    # Installing dependencies for your specific platform
    uv pip install -r requirements-macos-11.0.txt
    uv pip install -r requirements-win.txt
    # etc...

**Using pip (traditional method):** [pip](https://pip.pypa.io/en/stable/)

    pip3 install -r requirements.txt

The binaries for Python, GetText (`msgfmt`), `fpcalc` and `discid.dll` have to be
in the `%PATH%` on Windows.


Installation using pip
----------------------

The recommended way to install Picard from source is using pip. After installing
the dependencies, you can install Picard as a pip package by running:

    pip3 install .

To start Picard now you can use:

    picard

To uninstall Picard run:

    pip3 uninstall picard


Note about Qt6 installed via pip
--------------------------------

If you get errors related to `libxcb` on application startup, you may need to install extra libraries on your system.

Typical error looks like:

    qt.qpa.plugin: From 6.5.0, xcb-cursor0 or libxcb-cursor0 is needed to load the Qt xcb platform plugin.
    qt.qpa.plugin: Could not load the Qt platform plugin "xcb" in "" even though it was found.
    This application failed to start because no Qt platform plugin could be initialized. Reinstalling the application may fix this problem.


In this case, you have to install extra packages system-wide, for example, in this case, on Ubuntu:

    sudo apt install libxcb-cursor0


Installation using setup.py
---------------------------

You can also install Picard with `setup.py` by running:

    sudo python3 setup.py install

This will automatically build and install all required Python modules.
On Windows you need to have Administrator rights, but don't put `sudo`
in front of the command.

To start Picard now you can use:

    picard

If you want to be able to easily uninstall Picard again, run `setup.py`
with the `--record installed-files.txt` command line argument. This will record
all files generated during installation into the file `installed-files.txt`.

    sudo python3 setup.py install --record installed-files.txt

To uninstall Picard again simply remove all the files listed in
`installed-files.txt`, e.g. by running:

    rm -vI $(cat installed-files.txt)


Running From the Source Tree
----------------------------

If you want to run Picard from the source directory without installing,
or want to develop, you need to follow those steps.

On Debian-based systems:

    apt install python3-pyqt6 python3-venv python3-dev

For discid support (optional):

    apt install libdiscid0

For embedded multimedia player support (optional):

    apt install python3-pyqt6.qtmultimedia libqt6multimedia6

For other distributions, check your distribution's documentation
on how to install the packages for Qt6, PyQt6, Python3 C headers,
and Python3 venv.

### Using uv (Recommended)

```bash
# Create virtual environment and activate it
uv venv
. ./.venv/bin/activate  # macOS/Linux
# .\.venv\Scripts\activate.bat  # Windows

# Install all dependencies (main, build, and dev)
uv sync

# Build the project
python setup.py build
python setup.py build_ext -i

# Run Picard
python ./tagger.py
```

### Using pip (Traditional)

At top of source directory, create a .venv directory:

    python3 -m venv --system-site-packages .venv

Activate it:

    . .venv/bin/activate

Install requirements (here we also install build & dev requirements):

    pip install -r requirements.txt -r requirements-build.txt -r requirements-dev.txt

You then need to build the C extensions and locales manually.
C extension will require header file `Python.h`.

Then you can build Picard dependencies:

    python3 setup.py build
    python3 setup.py build_ext -i

And to start Picard use:

    python3 tagger.py

Or, to enable debug mode:

    python3 tagger.py -d


Running the Test Suite
----------------------

To run the included tests, follow the instructions for "Running From
the Source Tree". Afterward you can run the tests:

```bash
# Run with uv
uv run pytest -n auto

# With the virtual environment activated, omit the `uv`
pytest -n auto
```


Development Setup
----------------

For development, we recommend using `uv` for faster dependency management and pre-commit hooks for code quality.

### Set Up pre-commit Hooks

We use [pre-commit](https://pre-commit.com/) to manage code quality checks and requirements file generation.

Install the hooks:

    pre-commit install

This ensures all code style checks (`ruff`) and requirements file updates (using `uv`) are run automatically before each commit.

**Do not edit requirements files by hand.** All requirements files are generated from `pyproject.toml` via pre-commit hooks.

To manually update requirements after changing `pyproject.toml`, run:

    pre-commit run pip-compile --all-files


Packaging
---------

Picard supports packaging binaries and uploading them to PyPi.

To submit a package run:

    python3 setup.py sdist
    twine upload dist/*


Code Signatures
---------------

The official software packages of MusicBrainz Picard for macOS and Windows as
well as the official source archives are all digitally signed.

If you are packaging Picard for an operating system (e.g. a Linux distribution)
we recommend that you use the source archives from the
[official file server](https://data.musicbrainz.org/pub/musicbrainz/picard/).
The source archives are named `picard-x.y.z.tar.gz` and there is a corresponding
GPG signature file `picard-x.y.z.tar.gz.asc` signed with the GPG key listed
below.

You can verify the signature with e.g.:

    gpg --verify picard-2.9.tar.gz.asc

Make sure the key fingerprint in the output matches the fingerprint of the
GPG key below.

The signing certificates and keys currently in use are:

| Certificate          | Expiration | Fingerprint                              |
|----------------------|------------|------------------------------------------|
| Windows Code Signing | 2024-10-25 | 4d0c868847e2a5e44ae734e1279a9c7007fd6d4c |
| Apple Code Signing   | 2027-02-01 | deb351206f7dc9361e1cf3d864edce98a8d3302d |
| MBP Developers GPG   | 2026-10-28 | [68990dd0b1edc129b856958167997e14d563da7c](https://keyserver.ubuntu.com/pks/lookup?op=vindex&search=0x67997e14d563da7c) |
