/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableElement;
import com.hivemq.client.internal.util.collections.ImmutableEmptyList;
import com.hivemq.client.internal.util.collections.ImmutableList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableArray<E>
implements ImmutableList<E> {
    @NotNull
    private final @NotNull Object @NotNull [] array;

    @Contract(value="null -> fail")
    @NotNull
    static <E> ImmutableList<E> of(Object ... elements) {
        return ImmutableArray.of(elements, "Immutable list");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    static <E> ImmutableList<E> of(@Nullable @Nullable Object @Nullable [] elements, @NotNull String name) {
        return new ImmutableArray<E>(Checks.elementsNotNull(elements, name));
    }

    ImmutableArray(@NotNull @NotNull Object @NotNull [] array) {
        this.array = array;
        assert (array.length > 1);
    }

    int getFromIndex() {
        return 0;
    }

    int getToIndex() {
        return this.array.length;
    }

    @Override
    public int size() {
        return this.getToIndex() - this.getFromIndex();
    }

    @Override
    @NotNull
    public E get(int index) {
        return (E)this.array[this.getFromIndex() + Checks.index(index, this.size())];
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return Arrays.copyOfRange(this.array, this.getFromIndex(), this.getToIndex());
    }

    @Override
    public <T> T @NotNull [] toArray(@Nullable T @NotNull [] other) {
        Checks.notNull(other, "Array");
        int size = this.size();
        if (other.length < size) {
            other = (Object[])Array.newInstance(other.getClass().getComponentType(), size);
        } else if (other.length > size) {
            other[size] = null;
        }
        System.arraycopy(this.array, this.getFromIndex(), other, 0, size);
        return other;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null) {
            return -1;
        }
        int fromIndex = this.getFromIndex();
        int toIndex = this.getToIndex();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!o.equals(this.array[i])) continue;
            return i - fromIndex;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o == null) {
            return -1;
        }
        int fromIndex = this.getFromIndex();
        int toIndex = this.getToIndex();
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (!o.equals(this.array[i])) continue;
            return i - fromIndex;
        }
        return -1;
    }

    @Override
    @NotNull
    public ImmutableList.ImmutableListIterator<E> listIterator(int index) {
        return new ArrayIterator(this.getFromIndex() + Checks.cursorIndex(index, this.size()));
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, this.getFromIndex(), this.getToIndex(), 1296);
    }

    @Override
    public void forEach(@Nullable Consumer<? super E> consumer) {
        Checks.notNull(consumer, "Consumer");
        int fromIndex = this.getFromIndex();
        int toIndex = this.getToIndex();
        for (int i = fromIndex; i < toIndex; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    @Override
    @NotNull
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        int size = this.size();
        Checks.indexRange(fromIndex, toIndex, size);
        int startIndex = this.getFromIndex();
        int subSize = toIndex - fromIndex;
        switch (subSize) {
            case 0: {
                return ImmutableEmptyList.of();
            }
            case 1: {
                return new ImmutableElement<Object>(this.array[startIndex + fromIndex]);
            }
        }
        return subSize == size ? this : new SubArray(this.array, startIndex + fromIndex, startIndex + toIndex);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        int fromIndex = this.getFromIndex();
        int toIndex = this.getToIndex();
        if (toIndex - fromIndex != that.size()) {
            return false;
        }
        if (that instanceof RandomAccess) {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (this.array[i].equals(that.get(i))) continue;
                return false;
            }
        } else {
            int i = fromIndex;
            for (Object e : that) {
                if (this.array[i++].equals(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int fromIndex = this.getFromIndex();
        int toIndex = this.getToIndex();
        int hashCode = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            hashCode = 31 * hashCode + this.array[i].hashCode();
        }
        return hashCode;
    }

    @NotNull
    public String toString() {
        int i = this.getFromIndex();
        int toIndex = this.getToIndex();
        StringBuilder sb = new StringBuilder().append('[');
        while (true) {
            sb.append(this.array[i++]);
            if (i == toIndex) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    private class ArrayIterator
    implements ImmutableList.ImmutableListIterator<E> {
        private int index;

        ArrayIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < ImmutableArray.this.getToIndex();
        }

        @Override
        @NotNull
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ImmutableArray.this.array[this.index++];
        }

        @Override
        public int nextIndex() {
            return this.index - ImmutableArray.this.getFromIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > ImmutableArray.this.getFromIndex();
        }

        @Override
        @NotNull
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ImmutableArray.this.array[--this.index];
        }

        @Override
        public int previousIndex() {
            return this.index - 1 - ImmutableArray.this.getFromIndex();
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super E> consumer) {
            Checks.notNull(consumer, "Consumer");
            while (this.hasNext()) {
                consumer.accept(this.next());
            }
        }
    }

    private static class SubArray<E>
    extends ImmutableArray<E> {
        private final int fromIndex;
        private final int toIndex;

        SubArray(@NotNull @NotNull Object @NotNull [] array, int fromIndex, int toIndex) {
            super(array);
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            assert (toIndex - fromIndex > 1);
            assert (toIndex - fromIndex < array.length);
        }

        @Override
        public int getFromIndex() {
            return this.fromIndex;
        }

        @Override
        public int getToIndex() {
            return this.toIndex;
        }

        @Override
        @NotNull
        public ImmutableList<E> trim() {
            return new ImmutableArray(this.toArray());
        }
    }
}

