/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import java.util.Arrays;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.OptionDefinition;

public abstract class BaseOptionDefinition
implements OptionDefinition {
    private static final int[] LENGTHS = new int[]{0, 65804};
    private final int number;
    private final String name;
    private final OptionNumberRegistry.OptionFormat format;
    private final boolean singleValue;
    private final int[] lengths;

    protected BaseOptionDefinition(int number, String name, OptionNumberRegistry.OptionFormat format, boolean singleValue, int[] lengths) {
        if (number > 65535 || number < 0) {
            throw new IllegalArgumentException(number + " invalid option number!");
        }
        this.number = number;
        this.name = name;
        this.format = format;
        this.singleValue = singleValue;
        if (lengths == null || lengths.length == 0) {
            this.lengths = LENGTHS;
        } else if (lengths.length == 1) {
            this.lengths = new int[2];
            this.lengths[0] = lengths[0];
            this.lengths[1] = lengths[0];
        } else {
            this.lengths = Arrays.copyOf(lengths, 2);
        }
    }

    @Override
    public OptionNumberRegistry.OptionFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean isSingleValue() {
        return this.singleValue;
    }

    @Override
    public void assertValue(byte[] value) {
        int min = this.lengths[0];
        int max = this.lengths[1];
        int valueLength = value.length;
        if (this.getFormat() == OptionNumberRegistry.OptionFormat.INTEGER) {
            for (byte b : value) {
                if (b != 0) break;
                --valueLength;
            }
        }
        if (valueLength < min || valueLength > max) {
            if (min == max) {
                if (min == 0) {
                    throw new IllegalArgumentException("Option " + this.name + " value of " + valueLength + " bytes must be empty.");
                }
                throw new IllegalArgumentException("Option " + this.name + " value of " + valueLength + " bytes must be " + min + " bytes.");
            }
            throw new IllegalArgumentException("Option " + this.name + " value of " + valueLength + " bytes must be in range of [" + min + "-" + max + "] bytes.");
        }
    }

    @Override
    public String toString() {
        return this.name + "/" + (Object)((Object)this.format);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Option create(byte[] value) {
        return new Option(this, value);
    }

    @Override
    public Option create(String value) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " doesn't support string-values!");
    }

    @Override
    public Option create(long value) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " doesn't support integer-values!");
    }
}

