---
title: Integrations
weight: 3
aliases:
  - /welcome/integrations/
---

## Editor Integration

### GoLand

Starting from version 2025.1, GoLand has built-in support of golangci-lint.
For IntelliJ IDEA with the Go plugin, please install the [plugin](https://plugins.jetbrains.com/plugin/12496-go-linter).

Both v1 and v2 versions are supported.

### Visual Studio Code

Install the [extension](https://marketplace.visualstudio.com/items?itemName=golang.Go).

{{% details title="Recommended settings for those who installed golangci-lint manually" closed="true" %}}

```JSONata
"go.lintTool": "golangci-lint",
"go.lintFlags": [
  "--path-mode=abs",
  "--fast-only"
],
"go.formatTool": "custom",
"go.alternateTools": {
  "customFormatter": "golangci-lint"
},
"go.formatFlags": [
  "fmt",
  "--stdin"
]
```

Using it in an editor without `--fast-only` can freeze your editor.
Golangci-lint automatically discovers the `.golangci.yml` config for the edited file, so you don't need to configure it in VS Code settings.

{{% /details %}}

{{% details title="Recommended settings for those who installed golangci-lint via extension" closed="true" %}}

Install `golangci-lint-v2` via the `Go: Install/Update Tools` command after setting these configs.
This will enable golangci-lint v1 to co-exist with v2.
And use the following settings:

```JSONata
"go.lintTool": "golangci-lint-v2",
"go.lintFlags": [
  "--path-mode=abs",
  "--fast-only"
],
"go.formatTool": "custom",
"go.alternateTools": {
  "customFormatter": "golangci-lint-v2"
},
"go.formatFlags": [
  "fmt",
  "--stdin"
]
```

Using it in an editor without `--fast-only` can freeze your editor.
Golangci-lint automatically discovers the `.golangci.yml` config for the edited file, so you don't need to configure it in VS Code settings.

{{% /details %}}

### GNU Emacs

There are available plugins:

- [Spacemacs](https://github.com/syl20bnr/spacemacs/blob/develop/layers/+lang/go/README.org#linting)
- [Flycheck checker](https://github.com/weijiangan/flycheck-golangci-lint)

### Vim

The following plugins support golangci-lint:

- [vim-go](https://github.com/fatih/vim-go)
- [ALE](https://github.com/w0rp/ale)

### LSP Server

[golangci-lint-langserver](https://github.com/nametake/golangci-lint-langserver) (NeoVim, Vim, Emacs, ...)

### Sublime Text

There is a [plugin](https://github.com/SublimeLinter/SublimeLinter-golangcilint) for SublimeLinter.

## Shell Completion

Golangci-lint can generate Bash, fish, PowerShell, and Zsh completion files.

See the instructions on `golangci-lint completion <YOUR_SHELL> --help` (replace `<YOUR_SHELL>` with your favorite one).

{{% details title="Bash & macOS" closed="true" %}}

There are two versions of `bash-completion`, v1 and v2. V1 is for Bash 3.2 (which is the default on macOS), and v2 is for Bash 4.1+.

The golangci-lint completion script doesn’t work correctly with bash-completion v1 and Bash 3.2. It requires bash-completion v2 and Bash 4.1+.

Thus, to be able to correctly use golangci-lint completion on macOS, you have to install and use Bash 4.1+ ([instructions](https://itnext.io/upgrading-bash-on-macos-7138bd1066ba)).

The following instructions assume that you use Bash 4.1+ (that is, any Bash version of 4.1 or newer).

Install `bash-completion v2`:

```bash
brew install bash-completion@2
echo 'export BASH_COMPLETION_COMPAT_DIR="/usr/local/etc/bash_completion.d"' >>~/.bashrc
echo '[[ -r "/usr/local/etc/profile.d/bash_completion.sh" ]] && . "/usr/local/etc/profile.d/bash_completion.sh"' >>~/.bashrc
exec bash # reload and replace (if it was updated) shell
type _init_completion && echo "completion is OK" # verify that bash-completion v2 is correctly installed
```

Add golangci-lint bash completion:

```bash
echo 'source <(golangci-lint completion bash)' >>~/.bashrc
source ~/.bashrc
```

{{% /details %}}

## CI Integration

Check out our [documentation for CI integrations](/docs/welcome/install#ci-installation).

