/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;

public class NodeSetIntent
extends NodeSetValue {
    private NodeSetExpression expression;
    private NodeSetExtent extent = null;
    private Controller controller;
    private boolean sorted = false;
    private int useCount = 0;

    public NodeSetIntent(NodeSetExpression nodeSetExpression, Controller controller) throws XPathException {
        if (nodeSetExpression.getDependencies() != 0) {
            nodeSetExpression.display(10);
            throw new UnsupportedOperationException("Cannot create intensional node-set with context dependencies: " + nodeSetExpression.getClass() + ":" + nodeSetExpression.getDependencies());
        }
        this.expression = nodeSetExpression;
        this.controller = controller;
    }

    private Context makeContext() {
        Context context = new Context(this.controller);
        context.setStaticContext(this.expression.getStaticContext());
        return context;
    }

    public NodeSetExpression getNodeSetExpression() {
        return this.expression;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public boolean isSorted() throws XPathException {
        return this.sorted || this.expression.enumerate(this.makeContext(), false).isSorted();
    }

    public boolean isContextDocumentNodeSet() {
        return this.expression.isContextDocumentNodeSet();
    }

    public String asString() throws XPathException {
        NodeInfo nodeInfo = this.getFirst();
        return nodeInfo == null ? "" : nodeInfo.getStringValue();
    }

    public boolean asBoolean() throws XPathException {
        return this.enumerate().hasMoreElements();
    }

    public int getCount() throws XPathException {
        if (this.extent == null) {
            NodeEnumeration nodeEnumeration = this.expression.enumerate(this.makeContext(), false);
            if (nodeEnumeration instanceof LastPositionFinder && nodeEnumeration.isSorted()) {
                return ((LastPositionFinder)((Object)nodeEnumeration)).getLastPosition();
            }
            this.extent = new NodeSetExtent(nodeEnumeration, (NodeOrderComparer)this.controller);
        }
        return this.extent.getCount();
    }

    private void fix() throws XPathException {
        if (this.extent == null) {
            NodeEnumeration nodeEnumeration = this.expression.enumerate(this.makeContext(), false);
            this.extent = new NodeSetExtent(nodeEnumeration, (NodeOrderComparer)this.controller);
        }
    }

    public NodeSetValue sort() throws XPathException {
        if (this.sorted) {
            return this;
        }
        this.fix();
        return this.extent.sort();
    }

    public NodeInfo getFirst() throws XPathException {
        if (this.extent != null) {
            return this.extent.getFirst();
        }
        NodeEnumeration nodeEnumeration = this.expression.enumerate(this.makeContext(), false);
        if (this.sorted || nodeEnumeration.isSorted()) {
            this.sorted = true;
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement();
            }
            return null;
        }
        NodeInfo nodeInfo = null;
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
            if (nodeInfo != null && this.controller.compare(nodeInfo2, nodeInfo) >= 0) continue;
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    public NodeInfo selectFirst(Context context) throws XPathException {
        return this.getFirst();
    }

    public NodeEnumeration enumerate() throws XPathException {
        if (this.extent != null) {
            return this.extent.enumerate();
        }
        ++this.useCount;
        if (this.useCount < 3) {
            return this.expression.enumerate(this.makeContext(), false);
        }
        this.fix();
        return this.extent.enumerate();
    }
}

