/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    private LinkedHashMap<K, V> map;

    public LRUCache(final int cacheSize) {
        this.map = new LinkedHashMap<K, V>(cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return cacheSize < super.size();
            }
        };
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }
}

