# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

DESCRIPTION="Use structural criteria to grep and index text, SGML, XML and HTML and filter"
HOMEPAGE="https://www.cs.helsinki.fi/u/jjaakkol/sgrep.html"
SRC_URI="ftp://ftp.cs.helsinki.fi/pub/Software/Local/Sgrep/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~ppc ~x86"

PATCHES=(
	"${FILESDIR}"/${P}-clang16.patch
)

src_prepare() {
	default

	sed -i "s:/usr/lib:${EPREFIX}/etc:g" sgrep.1 || die

	# Clang 16, bug #900533
	eautoreconf
}

src_configure() {
	econf --datadir="${EPREFIX}"/etc
}

src_install() {
	dobin sgrep
	doman sgrep.1
	dodoc AUTHORS ChangeLog NEWS README sample.sgreprc

	insinto /etc
	newins sample.sgreprc sgreprc
}
