# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

RUST_MIN_VER="1.85.0"
CRATES="
	aho-corasick@1.1.4
	anstyle@1.0.13
	anyhow@1.0.100
	assert_cmd@2.1.1
	assert_fs@1.1.3
	autocfg@1.5.0
	bitflags@2.10.0
	bstr@1.12.1
	cc@1.2.51
	cfg-if@1.0.4
	clap@4.5.54
	clap_builder@4.5.54
	clap_lex@0.7.6
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	ctor-proc-macro@0.0.6
	ctor@0.4.3
	difflib@0.4.0
	directories@6.0.0
	dirs-sys@0.5.0
	doc-comment@0.3.4
	downcast@0.11.0
	dtor-proc-macro@0.0.5
	dtor@0.0.6
	encoding_rs@0.8.35
	env_filter@0.1.4
	env_home@0.1.0
	env_logger@0.11.8
	equivalent@1.0.2
	errno@0.3.14
	fastrand@2.3.0
	find-msvc-tools@0.1.6
	float-cmp@0.10.0
	fragile@2.0.1
	getrandom@0.2.16
	getrandom@0.3.4
	globset@0.4.18
	globwalk@0.9.1
	hashbrown@0.16.1
	ignore@0.4.25
	indexmap@2.12.1
	itoa@1.0.17
	jiff-static@0.2.17
	jiff@0.2.17
	libc@0.2.178
	libredox@0.1.12
	libyml@0.0.5
	linux-raw-sys@0.11.0
	log@0.4.29
	memchr@2.7.6
	mockall@0.14.0
	mockall_derive@0.14.0
	normalize-line-endings@0.3.0
	num-traits@0.2.19
	once_cell@1.21.3
	option-ext@0.2.0
	portable-atomic-util@0.2.4
	portable-atomic@1.13.0
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	proc-macro2@1.0.104
	quote@1.0.42
	r-efi@5.3.0
	redox_users@0.5.2
	regex-automata@0.4.13
	regex-syntax@0.8.8
	regex@1.12.2
	rustix@1.1.3
	ryu@1.0.22
	same-file@1.0.6
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.148
	serde_yml@0.0.12
	shell-words@1.1.1
	shlex@1.3.0
	signal-hook-registry@1.4.8
	signal-hook@0.3.18
	strsim@0.11.1
	syn@2.0.112
	tempfile@3.24.0
	termtree@0.5.1
	thiserror-impl@2.0.17
	thiserror@2.0.17
	unicode-ident@1.0.22
	version_check@0.9.5
	wait-timeout@0.2.1
	walkdir@2.5.0
	wasi@0.11.1+wasi-snapshot-preview1
	wasip2@1.0.1+wasi-0.2.4
	which@8.0.0
	winapi-util@0.1.11
	windows-link@0.2.1
	windows-sys@0.61.2
	winsafe@0.0.19
	wit-bindgen@0.46.0
	zmij@1.0.8
"

inherit cargo

DESCRIPTION="Build EAR generates a compilation database for clang tooling"
HOMEPAGE="https://github.com/rizsotto/Bear"
SRC_URI="
	https://github.com/rizsotto/Bear/archive/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/${P^}"

LICENSE="GPL-3+"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT MPL-2.0 Unicode-3.0"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~loong ~ppc64 ~riscv"
IUSE="test"
RESTRICT="!test? ( test )"

QA_FLAGS_IGNORED="
	usr/bin/bear
	usr/libexec/bear/.*/libexec.so
	usr/libexec/bear/wrapper
"

src_prepare() {
	default
	sed -i -e "s#/usr/local/libexec#${EPREFIX}/usr/libexec#" bear/build.rs || die
}

src_test() {
	# The test build needs to be compiled with different features enabled,
	# which makes it incompatible with production
	local args=(
		--target-dir "${PWD}"/tested-target/
		-F allow-integration-tests
	)
	cargo_src_compile "${args[@]}"
	cargo_src_test "${args[@]}"
}

src_install() {
	local DOCS=( *.md )
	default

	dobin target/release/bear

	into /usr/libexec/bear
	dolib.so target/release/libexec.so

	exeinto /usr/libexec/bear
	doexe target/release/wrapper

	doman man/bear.1
}
