#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Galacticare
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250609.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='galacticare'
GAME_NAME='Galacticare'

ARCHIVE_BASE_2_NAME='setup_galacticare_1.2.3.1plus6d76582b76_(82662).exe'
ARCHIVE_BASE_2_MD5='7b070946d0dc45e0df58b073195d48fb'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_PART1_NAME='setup_galacticare_1.2.3.1plus6d76582b76_(82662)-1.bin'
ARCHIVE_BASE_2_PART1_MD5='dd3d876d9b90e018a83e3722d4f89f3f'
ARCHIVE_BASE_2_PART2_NAME='setup_galacticare_1.2.3.1plus6d76582b76_(82662)-2.bin'
ARCHIVE_BASE_2_PART2_MD5='c4bc049c0f14a2cf190d27763513f65e'
ARCHIVE_BASE_2_SIZE='29191051'
ARCHIVE_BASE_2_VERSION='1.2.3.1-gog82662'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/galacticare'

ARCHIVE_BASE_1_NAME='setup_galacticare_1.2.3plus6d76582b76_(82235).exe'
ARCHIVE_BASE_1_MD5='7d95382f9ccd962ed3c571f30c8ca642'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_galacticare_1.2.3plus6d76582b76_(82235)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='54c02d98af9b70b80e6438e12c4c9611'
ARCHIVE_BASE_1_PART2_NAME='setup_galacticare_1.2.3plus6d76582b76_(82235)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='d420139ae4cebdcae18183d5fb77c982'
ARCHIVE_BASE_1_PART3_NAME='setup_galacticare_1.2.3plus6d76582b76_(82235)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='ad4998209a459ccc9fd23c43fa53554f'
ARCHIVE_BASE_1_PART4_NAME='setup_galacticare_1.2.3plus6d76582b76_(82235)-4.bin'
ARCHIVE_BASE_1_PART4_MD5='0c927f423541c464acf3e27d0922f7fe'
ARCHIVE_BASE_1_SIZE='34968590'
ARCHIVE_BASE_1_VERSION='1.2.3-gog82235'

ARCHIVE_BASE_0_NAME='setup_galacticare_1.2.0plus73e3612ea7_(81088).exe'
ARCHIVE_BASE_0_MD5='87f45a1769017c88f4a0ed323d1ca6e5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_galacticare_1.2.0plus73e3612ea7_(81088)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='54c02d98af9b70b80e6438e12c4c9611'
ARCHIVE_BASE_0_PART2_NAME='setup_galacticare_1.2.0plus73e3612ea7_(81088)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='8afab5b704640ef48ea419517feda31f'
ARCHIVE_BASE_0_PART3_NAME='setup_galacticare_1.2.0plus73e3612ea7_(81088)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='9042ba9cb019e5ec52e8ff0560d5470d'
ARCHIVE_BASE_0_PART4_NAME='setup_galacticare_1.2.0plus73e3612ea7_(81088)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='94cc896f1bf5ada6099d75200b666178'
ARCHIVE_BASE_0_SIZE='34948708'
ARCHIVE_BASE_0_VERSION='1.2.0-gog81088'

UNITY3D_NAME='galacticare'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_CHARACTERS_FILES='
galacticare_data/streamingassets/assetbundles/characters-*'
CONTENT_GAME_DATA_ENVIRONMENT_FILES='
galacticare_data/streamingassets/assetbundles/environment-*'
CONTENT_GAME_DATA_ROOMS_FILES='
galacticare_data/streamingassets/assetbundles/rooms-*
galacticare_data/streamingassets/assetbundles/props-*'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Brightrock Games/Galacticare'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_CHARACTERS
PKG_DATA_ENVIRONMENT
PKG_DATA_ROOMS
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_CHARACTERS
PKG_DATA_ENVIRONMENT
PKG_DATA_ROOMS'

PKG_DATA_CHARACTERS_ID="${PKG_DATA_ID}-characters"
PKG_DATA_CHARACTERS_DESCRIPTION="$PKG_DATA_DESCRIPTION - characters"

PKG_DATA_ENVIRONMENT_ID="${PKG_DATA_ID}-environment"
PKG_DATA_ENVIRONMENT_DESCRIPTION="$PKG_DATA_DESCRIPTION - environment"

PKG_DATA_ROOMS_ID="${PKG_DATA_ID}-rooms"
PKG_DATA_ROOMS_DESCRIPTION="$PKG_DATA_DESCRIPTION - rooms and props"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
