#ifndef COIN_SBVEC2US_H
#define COIN_SBVEC2US_H

/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

#include <Inventor/SbBasic.h>
#include <Inventor/system/inttypes.h>
#ifndef NDEBUG
#include <Inventor/errors/SoDebugError.h>
#endif // !NDEBUG

class SbVec2s;
class SbVec2ub;
class SbVec2ui32;

class COIN_DLL_API SbVec2us {
public:
  SbVec2us(void) { }
  SbVec2us(const unsigned short v[2]) { vec[0] = v[0]; vec[1] = v[1]; }
  SbVec2us(unsigned short x, unsigned short y) { vec[0] = x; vec[1] = y; }
  explicit SbVec2us(const SbVec2s & v) { setValue(v); }
  explicit SbVec2us(const SbVec2ub & v) { setValue(v); }
  explicit SbVec2us(const SbVec2ui32 & v) { setValue(v); }

  SbVec2us & setValue(const unsigned short v[2]) { vec[0] = v[0]; vec[1] = v[1]; return *this; }
  SbVec2us & setValue(unsigned short x, unsigned short y) { vec[0] = x; vec[1] = y; return *this; }
  SbVec2us & setValue(const SbVec2s & v);
  SbVec2us & setValue(const SbVec2ub & v);
  SbVec2us & setValue(const SbVec2ui32 & v);

  const unsigned short * getValue(void) const { return vec; }
  void getValue(unsigned short & x, unsigned short & y) const { x = vec[0]; y = vec[1]; }

  unsigned short & operator [] (int i) { return vec[i]; }
  const unsigned short & operator [] (int i) const { return vec[i]; }

  int32_t dot(SbVec2us v) const { return vec[0] * v[0] + vec[1] * v[1]; }
  void negate(void);

  SbVec2us & operator *= (int d) { vec[0] = (unsigned short)(vec[0] * d); vec[1] = (unsigned short)(vec[1] * d); return *this; }
  SbVec2us & operator *= (double d);
  SbVec2us & operator /= (int d) { SbDividerChk("SbVec2us::operator/=(int)", d); vec[0] = (unsigned short)(vec[0] / d); vec[1] = (unsigned short)(vec[1] / d); return *this; }
  SbVec2us & operator /= (double d) { SbDividerChk("SbVec2us::operator/=(double)", d); return operator *= (1.0 / d); }
  SbVec2us & operator += (SbVec2us v) { vec[0] += v[0]; vec[1] += v[1]; return *this; }
  SbVec2us & operator -= (SbVec2us v) { vec[0] -= v[0]; vec[1] -= v[1]; return *this; }
  SbVec2us operator - (void) const { SbVec2us v(*this); v.negate(); return v; }

protected:
  unsigned short vec[2];

}; // SbVec2us

COIN_DLL_API inline SbVec2us operator * (SbVec2us v, int d) {
  SbVec2us val(v); val *= d; return val;
}

COIN_DLL_API inline SbVec2us operator * (SbVec2us v, double d) {
  SbVec2us val(v); val *= d; return val;
}

COIN_DLL_API inline SbVec2us operator * (int d, SbVec2us v) {
  SbVec2us val(v); val *= d; return val;
}

COIN_DLL_API inline SbVec2us operator * (double d, SbVec2us v) {
  SbVec2us val(v); val *= d; return val;
}

COIN_DLL_API inline SbVec2us operator / (SbVec2us v, int d) {
  SbDividerChk("operator/(SbVec2us,int)", d);
  SbVec2us val(v); val /= d; return val;
}

COIN_DLL_API inline SbVec2us operator / (SbVec2us v, double d) {
  SbDividerChk("operator/(SbVec2us,double)", d);
  SbVec2us val(v); val /= d; return val;
}

COIN_DLL_API inline SbVec2us operator + (SbVec2us v1, SbVec2us v2) {
  SbVec2us v(v1); v += v2; return v;
}

COIN_DLL_API inline SbVec2us operator - (SbVec2us v1, SbVec2us v2) {
  SbVec2us v(v1); v -= v2; return v;
}

COIN_DLL_API inline int operator == (SbVec2us v1, SbVec2us v2) {
  return ((v1[0] == v2[0]) && (v1[1] == v2[1]));
}

COIN_DLL_API inline int operator != (SbVec2us v1, SbVec2us v2) {
  return !(v1 == v2);
}

#endif // !COIN_SBVEC2US_H
