## mapDamage

[![install with bioconda](https://img.shields.io/badge/install%20with-bioconda-brightgreen.svg?style=flat)](http://bioconda.github.io/recipes/mapdamage2/README.html) [![Conda](https://img.shields.io/conda/dn/bioconda/mapdamage2.svg)](https://anaconda.org/bioconda/mapdamage2/files)

![Conda](https://anaconda.org/bioconda/mapdamage2/badges/latest_release_date.svg) ![Conda](https://anaconda.org/bioconda/mapdamage2/badges/version.svg) [![Project Status: Inactive – The project has reached a stable, usable state but is no longer being actively developed; support/maintenance will be provided as time allows.](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)

### Installation

mapDamage can be installed via pip:

```bash
pip install mapdamage
```

R and several packages are *post mortem* damage plotting, modeling, and rescaling. Refers to the detailed instructions on the [dedicated page](http://ginolhac.github.io/mapDamage/).

### Introduction

Complete documentation, instructions, examples, screenshots and FAQ are available at [this address](http://ginolhac.github.io/mapDamage/).

[mapDamage2](https://geogenetics.ku.dk/publications/mapdamage2.0/) is a computational framework written in **Python3** and **R**, which tracks and quantifies DNA damage patterns
among ancient DNA sequencing reads generated by Next-Generation Sequencing platforms.

`mapDamage` was developed at the [Centre for GeoGenetics](https://geogenetics.ku.dk/) by the [Orlando Group](https://geogenetics.ku.dk/research_groups/palaeomix_group/).

### Citation

If you use this program, please cite the following publication:
Jónsson H, Ginolhac A, Schubert M, Johnson P, Orlando L.
[mapDamage2.0: fast approximate Bayesian estimates of ancient DNA damage parameters.
*Bioinformatics* 23rd April 2013. doi: 10.1093/bioinformatics/btt193](http://bioinformatics.oxfordjournals.org/content/early/2013/05/17/bioinformatics.btt193)

The original `mapDamage1` was published in the following article:
Ginolhac A, Rasmussen M, Gilbert MT, Willerslev E, Orlando L.
[mapDamage: testing for damage patterns in ancient DNA sequences. *Bioinformatics* 2011 **27**(15):2153-5
http://bioinformatics.oxfordjournals.org/content/27/15/2153](http://bioinformatics.oxfordjournals.org/content/27/15/2153)

### Test the no-stats part and rescaling

you can test `mapDamage` by running:

```bash
cd mapDamage/mapdamage/
python3 mp_test.py
```

should return

```
Started with the command: /usr/local/bin/mapDamage -i tests/test.bam -r tests/fake1.fasta -d tests/results --no-stats
 Reading from 'tests/test.bam'
 Writing results to 'tests/results/'
pdf tests/results/Fragmisincorporation_plot.pdf generated
additional tests/results/Length_plot.pdf generated
Successful run
.
----------------------------------------------------------------------
Ran 2 tests in 3.357s

OK
```

### Contact

Please report bugs and suggest possible improvements on GitHub:
<https://github.com/ginolhac/mapDamage/issues/new>
