# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import ProjectKind

if TYPE_CHECKING:
    from .. import models as _models


class AssignDeploymentResourcesDetails(_Model):
    """Represents the options for assigning Azure resources to a project.

    :ivar resources_metadata: Represents the metadata for the resources to be assigned. Required.
    :vartype resources_metadata: list[~azure.ai.textanalytics.authoring.models.ResourceMetadata]
    """

    resources_metadata: list["_models.ResourceMetadata"] = rest_field(
        name="resourcesMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the metadata for the resources to be assigned. Required."""

    @overload
    def __init__(
        self,
        *,
        resources_metadata: list["_models.ResourceMetadata"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssignedDeploymentResource(_Model):
    """Represents the assigned deployment resource.

    :ivar azure_resource_id: The resource ID. Required.
    :vartype azure_resource_id: str
    :ivar region: The resource region. Required.
    :vartype region: str
    """

    azure_resource_id: str = rest_field(name="azureResourceId", visibility=["read"])
    """The resource ID. Required."""
    region: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource region. Required."""

    @overload
    def __init__(
        self,
        *,
        region: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssignedProjectDeploymentMetadata(_Model):
    """Represents the metadata for an assigned deployment.

    :ivar deployment_name: Represents the deployment name. Required.
    :vartype deployment_name: str
    :ivar last_deployed_on: Represents deployment last deployed time. Required.
    :vartype last_deployed_on: ~datetime.datetime
    :ivar deployment_expires_on: Represents deployment expiration date in the runtime. Required.
    :vartype deployment_expires_on: ~datetime.date
    """

    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """Represents the deployment name. Required."""
    last_deployed_on: datetime.datetime = rest_field(
        name="lastDeployedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents deployment last deployed time. Required."""
    deployment_expires_on: datetime.date = rest_field(
        name="deploymentExpirationDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents deployment expiration date in the runtime. Required."""

    @overload
    def __init__(
        self,
        *,
        deployment_name: str,
        last_deployed_on: datetime.datetime,
        deployment_expires_on: datetime.date,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssignedProjectDeploymentsMetadata(_Model):
    """Represents the metadata for assigned deployments for a project.

    :ivar project_name: Represents the project name. Required.
    :vartype project_name: str
    :ivar deployments_metadata: Represents the resource region. Required.
    :vartype deployments_metadata:
     list[~azure.ai.textanalytics.authoring.models.AssignedProjectDeploymentMetadata]
    """

    project_name: str = rest_field(name="projectName", visibility=["read"])
    """Represents the project name. Required."""
    deployments_metadata: list["_models.AssignedProjectDeploymentMetadata"] = rest_field(
        name="deploymentsMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the resource region. Required."""

    @overload
    def __init__(
        self,
        *,
        deployments_metadata: list["_models.AssignedProjectDeploymentMetadata"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfusionMatrixCell(_Model):
    """Represents a cell in a confusion matrix.

    :ivar normalized_value: Represents normalized value in percentages. Required.
    :vartype normalized_value: float
    :ivar raw_value: Represents raw value. Required.
    :vartype raw_value: float
    """

    normalized_value: float = rest_field(
        name="normalizedValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents normalized value in percentages. Required."""
    raw_value: float = rest_field(name="rawValue", visibility=["read", "create", "update", "delete", "query"])
    """Represents raw value. Required."""

    @overload
    def __init__(
        self,
        *,
        normalized_value: float,
        raw_value: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfusionMatrixRow(_Model):
    """ConfusionMatrixRow."""


class CopyProjectDetails(_Model):
    """Represents the options for copying an existing project to another Azure resource.

    :ivar project_kind: Represents the project kind. Required. Known values are:
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", "CustomEntityRecognition",
     "CustomAbstractiveSummarization", "CustomHealthcare", and "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    :ivar target_project_name: The project name to be copied-into. Required.
    :vartype target_project_name: str
    :ivar access_token: The access token. Required.
    :vartype access_token: str
    :ivar expires_at: The expiration of the access token. Required.
    :vartype expires_at: ~datetime.datetime
    :ivar target_resource_id: Represents the target Azure resource ID. Required.
    :vartype target_resource_id: str
    :ivar target_resource_region: Represents the target Azure resource region. Required.
    :vartype target_resource_region: str
    """

    project_kind: Union[str, "_models.ProjectKind"] = rest_field(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the project kind. Required. Known values are: \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"CustomEntityRecognition\",
     \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and \"CustomTextSentiment\"."""
    target_project_name: str = rest_field(
        name="targetProjectName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The project name to be copied-into. Required."""
    access_token: str = rest_field(name="accessToken", visibility=["read", "create", "update", "delete", "query"])
    """The access token. Required."""
    expires_at: datetime.datetime = rest_field(
        name="expiresAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration of the access token. Required."""
    target_resource_id: str = rest_field(
        name="targetResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the target Azure resource ID. Required."""
    target_resource_region: str = rest_field(
        name="targetResourceRegion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the target Azure resource region. Required."""

    @overload
    def __init__(
        self,
        *,
        project_kind: Union[str, "_models.ProjectKind"],
        target_project_name: str,
        access_token: str,
        expires_at: datetime.datetime,
        target_resource_id: str,
        target_resource_region: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CopyProjectState(_Model):
    """Represents the state of a copy job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CreateDeploymentDetails(_Model):
    """Represents the options for creating or updating a project deployment.

    :ivar trained_model_label: Represents the trained model label. Required.
    :vartype trained_model_label: str
    :ivar assigned_resource_ids: Represents the resource IDs to be assigned to the deployment. If
     provided, the deployment will be rolled out to the resources provided here as well as the
     original resource in which the project is created.
    :vartype assigned_resource_ids: list[str]
    """

    trained_model_label: str = rest_field(
        name="trainedModelLabel", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the trained model label. Required."""
    assigned_resource_ids: Optional[list[str]] = rest_field(
        name="assignedResourceIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the resource IDs to be assigned to the deployment. If provided, the deployment will
     be rolled out to the resources provided here as well as the original resource in which the
     project is created."""

    @overload
    def __init__(
        self,
        *,
        trained_model_label: str,
        assigned_resource_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CreateProjectOptions(_Model):
    """Represents the options used to create or update a project.

    :ivar project_kind: The project kind. Required. Known values are:
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", "CustomEntityRecognition",
     "CustomAbstractiveSummarization", "CustomHealthcare", and "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    :ivar storage_input_container_name: The storage container name. Required.
    :vartype storage_input_container_name: str
    :ivar settings: The project settings.
    :vartype settings: ~azure.ai.textanalytics.authoring.models.ProjectSettings
    :ivar project_name: The new project name. Required.
    :vartype project_name: str
    :ivar multilingual: Whether the project would be used for multiple languages or not.
    :vartype multilingual: bool
    :ivar description: The project description.
    :vartype description: str
    :ivar language: The project language. This is BCP-47 representation of a language. For example,
     use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    """

    project_kind: Union[str, "_models.ProjectKind"] = rest_field(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The project kind. Required. Known values are: \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"CustomEntityRecognition\",
     \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and \"CustomTextSentiment\"."""
    storage_input_container_name: str = rest_field(
        name="storageInputContainerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage container name. Required."""
    settings: Optional["_models.ProjectSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project settings."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """The new project name. Required."""
    multilingual: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the project would be used for multiple languages or not."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The project description."""
    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The project language. This is BCP-47 representation of a language. For example, use \"en\" for
     English, \"en-gb\" for English (UK), \"es\" for Spanish etc. Required."""

    @overload
    def __init__(
        self,
        *,
        project_kind: Union[str, "_models.ProjectKind"],
        storage_input_container_name: str,
        project_name: str,
        language: str,
        settings: Optional["_models.ProjectSettings"] = None,
        multilingual: Optional[bool] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentEvalResult(_Model):
    """Represents the evaluation result of a document.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomEntityRecognitionDocumentEvalResult, CustomHealthcareDocumentEvalResult,
    CustomMultiLabelClassificationDocumentEvalResult,
    CustomSingleLabelClassificationDocumentEvalResult, CustomTextSentimentDocumentEvalResult

    :ivar project_kind: Represents the project kind. Required. Known values are:
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", "CustomEntityRecognition",
     "CustomAbstractiveSummarization", "CustomHealthcare", and "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    """

    __mapping__: dict[str, _Model] = {}
    project_kind: str = rest_discriminator(name="projectKind", visibility=["read"])
    """Represents the project kind. Required. Known values are: \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"CustomEntityRecognition\",
     \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and \"CustomTextSentiment\"."""
    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document path. Required."""
    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc. Required."""

    @overload
    def __init__(
        self,
        *,
        project_kind: str,
        location: str,
        language: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityRecognitionDocumentEvalResult(
    DocumentEvalResult, discriminator="CustomEntityRecognition"
):  # pylint: disable=name-too-long
    """Represents the document evaluation result for a custom entity recognition project.

    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    :ivar custom_entity_recognition_result: Represents the evaluation prediction for entity
     recognition. Required.
    :vartype custom_entity_recognition_result:
     ~azure.ai.textanalytics.authoring.models.DocumentEntityRecognitionEvalResult
    :ivar project_kind: Represents the project kind. Required. For building an extraction model to
     identify your domain categories using your own data.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_ENTITY_RECOGNITION
    """

    custom_entity_recognition_result: "_models.DocumentEntityRecognitionEvalResult" = rest_field(
        name="customEntityRecognitionResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation prediction for entity recognition. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_ENTITY_RECOGNITION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project kind. Required. For building an extraction model to identify your domain
     categories using your own data."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        language: str,
        custom_entity_recognition_result: "_models.DocumentEntityRecognitionEvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_ENTITY_RECOGNITION  # type: ignore


class EvalSummary(_Model):
    """Represents the summary for an evaluation operation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomEntityRecognitionEvalSummary, CustomHealthcareEvalSummary,
    CustomMultiLabelClassificationEvalSummary, CustomSingleLabelClassificationEvalSummary,
    CustomTextSentimentEvalSummary

    :ivar project_kind: Represents the project type that the evaluation ran on. Required. Known
     values are: "CustomSingleLabelClassification", "CustomMultiLabelClassification",
     "CustomEntityRecognition", "CustomAbstractiveSummarization", "CustomHealthcare", and
     "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    """

    __mapping__: dict[str, _Model] = {}
    project_kind: str = rest_discriminator(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the project type that the evaluation ran on. Required. Known values are:
     \"CustomSingleLabelClassification\", \"CustomMultiLabelClassification\",
     \"CustomEntityRecognition\", \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and
     \"CustomTextSentiment\"."""
    evaluation_options: "_models.EvaluationDetails" = rest_field(
        name="evaluationOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the options used running the evaluation. Required."""

    @overload
    def __init__(
        self,
        *,
        project_kind: str,
        evaluation_options: "_models.EvaluationDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityRecognitionEvalSummary(EvalSummary, discriminator="CustomEntityRecognition"):
    """Represents the evaluation summary for a custom entity recognition project.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar custom_entity_recognition_evaluation: Contains the data related to extraction evaluation.
     Required.
    :vartype custom_entity_recognition_evaluation:
     ~azure.ai.textanalytics.authoring.models.EntityRecognitionEvalSummary
    :ivar project_kind: Represents the project type that the evaluation ran on. Required. For
     building an extraction model to identify your domain categories using your own data.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_ENTITY_RECOGNITION
    """

    custom_entity_recognition_evaluation: "_models.EntityRecognitionEvalSummary" = rest_field(
        name="customEntityRecognitionEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the data related to extraction evaluation. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_ENTITY_RECOGNITION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project type that the evaluation ran on. Required. For building an extraction
     model to identify your domain categories using your own data."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        custom_entity_recognition_evaluation: "_models.EntityRecognitionEvalSummary",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_ENTITY_RECOGNITION  # type: ignore


class CustomHealthcareDocumentEvalResult(DocumentEvalResult, discriminator="CustomHealthcare"):
    """Represents the document evaluation result for a custom entity recognition project.

    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    :ivar custom_healthcare_result: Represents the evaluation prediction for entity recognition.
     Required.
    :vartype custom_healthcare_result:
     ~azure.ai.textanalytics.authoring.models.DocumentHealthcareEvalResult
    :ivar project_kind: Represents the project kind. Required. For building an text analytics for
     health model to identify your health domain data.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_HEALTHCARE
    """

    custom_healthcare_result: "_models.DocumentHealthcareEvalResult" = rest_field(
        name="customHealthcareResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation prediction for entity recognition. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_HEALTHCARE] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project kind. Required. For building an text analytics for health model to
     identify your health domain data."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        language: str,
        custom_healthcare_result: "_models.DocumentHealthcareEvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_HEALTHCARE  # type: ignore


class CustomHealthcareEvalSummary(EvalSummary, discriminator="CustomHealthcare"):
    """Represents the evaluation summary for a custom health care project.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar custom_healthcare_evaluation: Contains the data related to health care evaluation.
     Required.
    :vartype custom_healthcare_evaluation:
     ~azure.ai.textanalytics.authoring.models.EntityRecognitionEvalSummary
    :ivar project_kind: Represents the project type that the evaluation ran on. Required. For
     building an text analytics for health model to identify your health domain data.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_HEALTHCARE
    """

    custom_healthcare_evaluation: "_models.EntityRecognitionEvalSummary" = rest_field(
        name="customHealthcareEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the data related to health care evaluation. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_HEALTHCARE] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project type that the evaluation ran on. Required. For building an text
     analytics for health model to identify your health domain data."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        custom_healthcare_evaluation: "_models.EntityRecognitionEvalSummary",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_HEALTHCARE  # type: ignore


class CustomMultiLabelClassificationDocumentEvalResult(
    DocumentEvalResult, discriminator="CustomMultiLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the document evaluation result for a custom multi-label classification project.

    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    :ivar custom_multi_label_classification_result: Represents the evaluation prediction for multi
     label classification. Required.
    :vartype custom_multi_label_classification_result:
     ~azure.ai.textanalytics.authoring.models.DocumentMultiLabelClassificationEvalResult
    :ivar project_kind: Represents the project kind. Required. For building a classification model
     to classify text using your own data. Each file can have one or many labels. For example, file
     1 is classified as A, B, and C and file 2 is classified as B and C.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_MULTI_LABEL_CLASSIFICATION
    """

    custom_multi_label_classification_result: "_models.DocumentMultiLabelClassificationEvalResult" = rest_field(
        name="customMultiLabelClassificationResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation prediction for multi label classification. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project kind. Required. For building a classification model to classify text
     using your own data. Each file can have one or many labels. For example, file 1 is classified
     as A, B, and C and file 2 is classified as B and C."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        language: str,
        custom_multi_label_classification_result: "_models.DocumentMultiLabelClassificationEvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION  # type: ignore


class CustomMultiLabelClassificationEvalSummary(
    EvalSummary, discriminator="CustomMultiLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the evaluation summary for a custom multi-label classification project.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar custom_multi_label_classification_evaluation: Contains the data related to multi label
     classification evaluation. Required.
    :vartype custom_multi_label_classification_evaluation:
     ~azure.ai.textanalytics.authoring.models.MultiLabelClassificationEvalSummary
    :ivar project_kind: Represents the project type that the evaluation ran on. Required. For
     building a classification model to classify text using your own data. Each file can have one or
     many labels. For example, file 1 is classified as A, B, and C and file 2 is classified as B and
     C.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_MULTI_LABEL_CLASSIFICATION
    """

    custom_multi_label_classification_evaluation: "_models.MultiLabelClassificationEvalSummary" = rest_field(
        name="customMultiLabelClassificationEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the data related to multi label classification evaluation. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project type that the evaluation ran on. Required. For building a classification
     model to classify text using your own data. Each file can have one or many labels. For example,
     file 1 is classified as A, B, and C and file 2 is classified as B and C."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        custom_multi_label_classification_evaluation: "_models.MultiLabelClassificationEvalSummary",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION  # type: ignore


class CustomSingleLabelClassificationDocumentEvalResult(
    DocumentEvalResult, discriminator="CustomSingleLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the document evaluation result for a custom single-label classification project.

    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    :ivar custom_single_label_classification_result: Represents the evaluation prediction for
     single label classification. Required.
    :vartype custom_single_label_classification_result:
     ~azure.ai.textanalytics.authoring.models.DocumentSingleLabelClassificationEvalResult
    :ivar project_kind: Represents the project kind. Required. For building a classification model
     to classify text using your own data. Each file will have only one label. For example, file 1
     is classified as A and file 2 is classified as B.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_SINGLE_LABEL_CLASSIFICATION
    """

    custom_single_label_classification_result: "_models.DocumentSingleLabelClassificationEvalResult" = rest_field(
        name="customSingleLabelClassificationResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation prediction for single label classification. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project kind. Required. For building a classification model to classify text
     using your own data. Each file will have only one label. For example, file 1 is classified as A
     and file 2 is classified as B."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        language: str,
        custom_single_label_classification_result: "_models.DocumentSingleLabelClassificationEvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION  # type: ignore


class CustomSingleLabelClassificationEvalSummary(
    EvalSummary, discriminator="CustomSingleLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the evaluation summary for a custom single-label classification project.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar custom_single_label_classification_evaluation: Contains the data related to single label
     classification evaluation. Required.
    :vartype custom_single_label_classification_evaluation:
     ~azure.ai.textanalytics.authoring.models.SingleLabelClassificationEvalSummary
    :ivar project_kind: Represents the project type that the evaluation ran on. Required. For
     building a classification model to classify text using your own data. Each file will have only
     one label. For example, file 1 is classified as A and file 2 is classified as B.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_SINGLE_LABEL_CLASSIFICATION
    """

    custom_single_label_classification_evaluation: "_models.SingleLabelClassificationEvalSummary" = rest_field(
        name="customSingleLabelClassificationEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the data related to single label classification evaluation. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project type that the evaluation ran on. Required. For building a classification
     model to classify text using your own data. Each file will have only one label. For example,
     file 1 is classified as A and file 2 is classified as B."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        custom_single_label_classification_evaluation: "_models.SingleLabelClassificationEvalSummary",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION  # type: ignore


class CustomTextSentimentDocumentEvalResult(DocumentEvalResult, discriminator="CustomTextSentiment"):
    """Represents the document evaluation result for a custom sentiment project.

    :ivar location: Represents the document path. Required.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    :ivar custom_text_sentiment_result: Represents the evaluation prediction for text sentiment.
     Required.
    :vartype custom_text_sentiment_result:
     ~azure.ai.textanalytics.authoring.models.DocumentTextSentimentEvalResult
    :ivar project_kind: Represents the project kind. Required. For building a sentiment models
     which are able to extract sentiment for long documents.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_TEXT_SENTIMENT
    """

    custom_text_sentiment_result: "_models.DocumentTextSentimentEvalResult" = rest_field(
        name="customTextSentimentResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation prediction for text sentiment. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_TEXT_SENTIMENT] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project kind. Required. For building a sentiment models which are able to
     extract sentiment for long documents."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        language: str,
        custom_text_sentiment_result: "_models.DocumentTextSentimentEvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_TEXT_SENTIMENT  # type: ignore


class CustomTextSentimentEvalSummary(EvalSummary, discriminator="CustomTextSentiment"):
    """Represents the evaluation summary for a custom text sentiment project.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar custom_text_sentiment_evaluation: Contains the data related to custom sentiment
     evaluation. Required.
    :vartype custom_text_sentiment_evaluation:
     ~azure.ai.textanalytics.authoring.models.TextSentimentEvalSummary
    :ivar project_kind: Represents the project type that the evaluation ran on. Required. For
     building a sentiment models which are able to extract sentiment for long documents.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_TEXT_SENTIMENT
    """

    custom_text_sentiment_evaluation: "_models.TextSentimentEvalSummary" = rest_field(
        name="customTextSentimentEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the data related to custom sentiment evaluation. Required."""
    project_kind: Literal[ProjectKind.CUSTOM_TEXT_SENTIMENT] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the project type that the evaluation ran on. Required. For building a sentiment
     models which are able to extract sentiment for long documents."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        custom_text_sentiment_evaluation: "_models.TextSentimentEvalSummary",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_TEXT_SENTIMENT  # type: ignore


class ExportedProjectAsset(_Model):
    """Represents the assets of an exported project.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExportedCustomAbstractiveSummarizationProjectAsset,
    ExportedCustomEntityRecognitionProjectAsset, ExportedCustomHealthcareProjectAsset,
    ExportedCustomMultiLabelClassificationProjectAsset,
    ExportedCustomSingleLabelClassificationProjectAsset, CustomTextSentimentProjectAssets

    :ivar project_kind: Required. Known values are: "CustomSingleLabelClassification",
     "CustomMultiLabelClassification", "CustomEntityRecognition", "CustomAbstractiveSummarization",
     "CustomHealthcare", and "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    """

    __mapping__: dict[str, _Model] = {}
    project_kind: str = rest_discriminator(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"CustomEntityRecognition\",
     \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and \"CustomTextSentiment\"."""

    @overload
    def __init__(
        self,
        *,
        project_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomTextSentimentProjectAssets(ExportedProjectAsset, discriminator="CustomTextSentiment"):
    """Represents the exported assets for a custom text sentiment project.

    :ivar documents: The list of documents belonging to the project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomTextSentimentDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building a
     sentiment models which are able to extract sentiment for long documents.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_TEXT_SENTIMENT
    """

    documents: Optional[list["_models.ExportedCustomTextSentimentDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents belonging to the project."""
    project_kind: Literal[ProjectKind.CUSTOM_TEXT_SENTIMENT] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building a sentiment models which
     are able to extract sentiment for long documents."""

    @overload
    def __init__(
        self,
        *,
        documents: Optional[list["_models.ExportedCustomTextSentimentDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_TEXT_SENTIMENT  # type: ignore


class DataGenerationConnectionInfo(_Model):
    """Represents the connection info for the Azure resource to use during data generation as part of
    training a custom model.

    :ivar kind: Connection type for data generation settings. Currently only supports Azure Open
     AI. Required. Default value is "AzureOpenAI".
    :vartype kind: str
    :ivar resource_id: Resource ID for the data generation resource. Looks something like
     "/subscriptions/<SUBSCRIPTION-ID-GUID>/resourceGroups/<RG-NAME>/providers/Microsoft.CognitiveServices/accounts/<AOAI-ACCOUNT-NAME>".
     Required.
    :vartype resource_id: str
    :ivar deployment_name: Deployment name of model to be used for synthetic data generation.
     Required.
    :vartype deployment_name: str
    """

    kind: Literal["AzureOpenAI"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Connection type for data generation settings. Currently only supports Azure Open AI. Required.
     Default value is \"AzureOpenAI\"."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """Resource ID for the data generation resource. Looks something like
     \"/subscriptions/<SUBSCRIPTION-ID-GUID>/resourceGroups/<RG-NAME>/providers/Microsoft.CognitiveServices/accounts/<AOAI-ACCOUNT-NAME>\".
     Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """Deployment name of model to be used for synthetic data generation. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        deployment_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind: Literal["AzureOpenAI"] = "AzureOpenAI"


class DataGenerationSetting(_Model):
    """Represents the settings for using data generation as part of training a custom model.

    :ivar enable_data_generation: If set to true, augment customer provided training data with
     synthetic data to improve model quality. Required.
    :vartype enable_data_generation: bool
    :ivar data_generation_connection_info: Represents the connection info for the Azure resource to
     use during data generation as part of training a custom model. Required.
    :vartype data_generation_connection_info:
     ~azure.ai.textanalytics.authoring.models.DataGenerationConnectionInfo
    """

    enable_data_generation: bool = rest_field(
        name="enableDataGeneration", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set to true, augment customer provided training data with synthetic data to improve model
     quality. Required."""
    data_generation_connection_info: "_models.DataGenerationConnectionInfo" = rest_field(
        name="dataGenerationConnectionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the connection info for the Azure resource to use during data generation as part of
     training a custom model. Required."""

    @overload
    def __init__(
        self,
        *,
        enable_data_generation: bool,
        data_generation_connection_info: "_models.DataGenerationConnectionInfo",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeleteDeploymentDetails(_Model):
    """Represents the options for deleting a project deployment.

    :ivar assigned_resource_ids: Represents the resource IDs to delete the deployment from. If not
     provided, the deployment will be rolled out from all the resources it is deployed to. If
     provided, it will delete the deployment only from the specified assigned resources, and leave
     it for the rest.
    :vartype assigned_resource_ids: list[str]
    """

    assigned_resource_ids: Optional[list[str]] = rest_field(
        name="assignedResourceIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the resource IDs to delete the deployment from. If not provided, the deployment will
     be rolled out from all the resources it is deployed to. If provided, it will delete the
     deployment only from the specified assigned resources, and leave it for the rest."""

    @overload
    def __init__(
        self,
        *,
        assigned_resource_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentDeleteFromResourcesState(_Model):
    """Represents the state of an existing delete deployment from specific resources job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentResource(_Model):
    """Represents an Azure resource assigned to a deployment.

    :ivar resource_id: Represents the Azure resource Id. Required.
    :vartype resource_id: str
    :ivar region: Represents the resource region. Required.
    :vartype region: str
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """Represents the Azure resource Id. Required."""
    region: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the resource region. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        region: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentResourcesState(_Model):
    """Represents the state of a deployment resources job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeploymentState(_Model):
    """Represents the state of a deployment job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentEntityLabelEvalResult(_Model):
    """Represents an evaluation result entity label.

    :ivar category: Represents the entity category. Required.
    :vartype category: str
    :ivar offset: Represents the entity offset index relative to the original text. Required.
    :vartype offset: int
    :ivar length: Represents the entity length. Required.
    :vartype length: int
    """

    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the entity category. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the entity offset index relative to the original text. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the entity length. Required."""

    @overload
    def __init__(
        self,
        *,
        category: str,
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentEntityRecognitionEvalResult(_Model):
    """Represents the entity recognition evaluation result for a document.

    :ivar entities: Represents the document labelled entities. Required.
    :vartype entities:
     list[~azure.ai.textanalytics.authoring.models.DocumentEntityRegionEvalResult]
    """

    entities: list["_models.DocumentEntityRegionEvalResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document labelled entities. Required."""

    @overload
    def __init__(
        self,
        *,
        entities: list["_models.DocumentEntityRegionEvalResult"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentEntityRegionEvalResult(_Model):
    """Represents the evaluation comparison between the expected and predicted entities of a document
    region.

    :ivar expected_entities: Represents the region's expected entity labels. Required.
    :vartype expected_entities:
     list[~azure.ai.textanalytics.authoring.models.DocumentEntityLabelEvalResult]
    :ivar predicted_entities: Represents the region's predicted entity labels. Required.
    :vartype predicted_entities:
     list[~azure.ai.textanalytics.authoring.models.DocumentEntityLabelEvalResult]
    :ivar region_offset: Represents the region offset. Required.
    :vartype region_offset: int
    :ivar region_length: Represents the region length. Required.
    :vartype region_length: int
    """

    expected_entities: list["_models.DocumentEntityLabelEvalResult"] = rest_field(
        name="expectedEntities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the region's expected entity labels. Required."""
    predicted_entities: list["_models.DocumentEntityLabelEvalResult"] = rest_field(
        name="predictedEntities", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the region's predicted entity labels. Required."""
    region_offset: int = rest_field(name="regionOffset", visibility=["read", "create", "update", "delete", "query"])
    """Represents the region offset. Required."""
    region_length: int = rest_field(name="regionLength", visibility=["read", "create", "update", "delete", "query"])
    """Represents the region length. Required."""

    @overload
    def __init__(
        self,
        *,
        expected_entities: list["_models.DocumentEntityLabelEvalResult"],
        predicted_entities: list["_models.DocumentEntityLabelEvalResult"],
        region_offset: int,
        region_length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentHealthcareEvalResult(_Model):
    """Represents the healthcare evaluation result for a document.

    :ivar entities: Represents the document labelled entities. Required.
    :vartype entities:
     list[~azure.ai.textanalytics.authoring.models.DocumentEntityRegionEvalResult]
    """

    entities: list["_models.DocumentEntityRegionEvalResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document labelled entities. Required."""

    @overload
    def __init__(
        self,
        *,
        entities: list["_models.DocumentEntityRegionEvalResult"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentMultiLabelClassificationEvalResult(_Model):  # pylint: disable=name-too-long
    """Represents the comparison between the expected and predicted classes that are result from the
    evaluation operation.

    :ivar expected_classes: Represents the document's expected classes. Required.
    :vartype expected_classes: list[str]
    :ivar predicted_classes: Represents the document's predicted classes. Required.
    :vartype predicted_classes: list[str]
    """

    expected_classes: list[str] = rest_field(
        name="expectedClasses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document's expected classes. Required."""
    predicted_classes: list[str] = rest_field(
        name="predictedClasses", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document's predicted classes. Required."""

    @overload
    def __init__(
        self,
        *,
        expected_classes: list[str],
        predicted_classes: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentSentimentLabelEvalResult(_Model):
    """Represents an evaluation result Sentiment label.

    :ivar category: Represents the sentiment category. Required. Known values are: "positive",
     "negative", and "neutral".
    :vartype category: str or ~azure.ai.textanalytics.authoring.models.Sentiment
    :ivar offset: Represents the sentiment offset index relative to the original text. Required.
    :vartype offset: int
    :ivar length: Represents the sentiment length. Required.
    :vartype length: int
    """

    category: Union[str, "_models.Sentiment"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the sentiment category. Required. Known values are: \"positive\", \"negative\", and
     \"neutral\"."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the sentiment offset index relative to the original text. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the sentiment length. Required."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.Sentiment"],
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentSingleLabelClassificationEvalResult(_Model):  # pylint: disable=name-too-long
    """Represents the comparison between the expected and predicted class that result from an
    evaluation operation.

    :ivar expected_class: Represents the document's expected class. Required.
    :vartype expected_class: str
    :ivar predicted_class: Represents the document's predicted class. Required.
    :vartype predicted_class: str
    """

    expected_class: str = rest_field(name="expectedClass", visibility=["read", "create", "update", "delete", "query"])
    """Represents the document's expected class. Required."""
    predicted_class: str = rest_field(name="predictedClass", visibility=["read", "create", "update", "delete", "query"])
    """Represents the document's predicted class. Required."""

    @overload
    def __init__(
        self,
        *,
        expected_class: str,
        predicted_class: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentTextSentimentEvalResult(_Model):
    """Represents the comparison between the expected and predicted sentiment that result from an
    evaluation operation.

    :ivar expected_sentiment_spans: Represents the document's expected sentiment labels. Required.
    :vartype expected_sentiment_spans:
     list[~azure.ai.textanalytics.authoring.models.DocumentSentimentLabelEvalResult]
    :ivar predicted_sentiment_spans: Represents the document's predicted sentiment labels.
     Required.
    :vartype predicted_sentiment_spans:
     list[~azure.ai.textanalytics.authoring.models.DocumentSentimentLabelEvalResult]
    """

    expected_sentiment_spans: list["_models.DocumentSentimentLabelEvalResult"] = rest_field(
        name="expectedSentimentSpans", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document's expected sentiment labels. Required."""
    predicted_sentiment_spans: list["_models.DocumentSentimentLabelEvalResult"] = rest_field(
        name="predictedSentimentSpans", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the document's predicted sentiment labels. Required."""

    @overload
    def __init__(
        self,
        *,
        expected_sentiment_spans: list["_models.DocumentSentimentLabelEvalResult"],
        predicted_sentiment_spans: list["_models.DocumentSentimentLabelEvalResult"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityEvalSummary(_Model):
    """Represents the evaluation summary for an entity.

    :ivar f1: Represents the model precision. Required.
    :vartype f1: float
    :ivar precision: Represents the model recall. Required.
    :vartype precision: float
    :ivar recall: Represents the model F1 score. Required.
    :vartype recall: float
    :ivar true_positive_count: Represents the count of true positive. Required.
    :vartype true_positive_count: int
    :ivar true_negative_count: Represents the count of true negative. Required.
    :vartype true_negative_count: int
    :ivar false_positive_count: Represents the count of false positive. Required.
    :vartype false_positive_count: int
    :ivar false_negative_count: Represents the count of false negative. Required.
    :vartype false_negative_count: int
    """

    f1: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model precision. Required."""
    precision: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model recall. Required."""
    recall: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model F1 score. Required."""
    true_positive_count: int = rest_field(
        name="truePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true positive. Required."""
    true_negative_count: int = rest_field(
        name="trueNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true negative. Required."""
    false_positive_count: int = rest_field(
        name="falsePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false positive. Required."""
    false_negative_count: int = rest_field(
        name="falseNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false negative. Required."""

    @overload
    def __init__(
        self,
        *,
        f1: float,
        precision: float,
        recall: float,
        true_positive_count: int,
        true_negative_count: int,
        false_positive_count: int,
        false_negative_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityRecognitionEvalSummary(_Model):
    """Represents the evaluation summary for a custom entity recognition project.

    :ivar confusion_matrix: Represents the confusion matrix between two entities (the two entities
     can be the same). The matrix is between the entity that was labelled and the entity that was
     predicted. Required.
    :vartype confusion_matrix: dict[str,
     ~azure.ai.textanalytics.authoring.models.ConfusionMatrixRow]
    :ivar entities: Represents the entities evaluation. Required.
    :vartype entities: dict[str, ~azure.ai.textanalytics.authoring.models.EntityEvalSummary]
    :ivar micro_f1: Represents the micro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype micro_f1: float
    :ivar micro_precision: Represents the micro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype micro_precision: float
    :ivar micro_recall: Represents the micro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype micro_recall: float
    :ivar macro_f1: Represents the macro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype macro_f1: float
    :ivar macro_precision: Represents the macro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype macro_precision: float
    :ivar macro_recall: Represents the macro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype macro_recall: float
    """

    confusion_matrix: dict[str, "_models.ConfusionMatrixRow"] = rest_field(
        name="confusionMatrix", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the confusion matrix between two entities (the two entities can be the same). The
     matrix is between the entity that was labelled and the entity that was predicted. Required."""
    entities: dict[str, "_models.EntityEvalSummary"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the entities evaluation. Required."""
    micro_f1: float = rest_field(name="microF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_precision: float = rest_field(
        name="microPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the micro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_recall: float = rest_field(name="microRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro recall. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_f1: float = rest_field(name="macroF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_precision: float = rest_field(
        name="macroPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the macro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_recall: float = rest_field(name="macroRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro recall. Expected value is a float between 0 and 1 inclusive. Required."""

    @overload
    def __init__(
        self,
        *,
        confusion_matrix: dict[str, "_models.ConfusionMatrixRow"],
        entities: dict[str, "_models.EntityEvalSummary"],
        micro_f1: float,
        micro_precision: float,
        micro_recall: float,
        macro_f1: float,
        macro_precision: float,
        macro_recall: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationDetails(_Model):
    """Represents the options used running the evaluation.

    :ivar kind: Represents the evaluation kind. By default, the evaluation kind is set to
     percentage. Known values are: "percentage" and "manual".
    :vartype kind: str or ~azure.ai.textanalytics.authoring.models.EvaluationKind
    :ivar training_split_percentage: Represents the training dataset split percentage. Only needed
     in case the evaluation kind is percentage.
    :vartype training_split_percentage: int
    :ivar testing_split_percentage: Represents the testing dataset split percentage. Only needed in
     case the evaluation kind is percentage.
    :vartype testing_split_percentage: int
    """

    kind: Optional[Union[str, "_models.EvaluationKind"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation kind. By default, the evaluation kind is set to percentage. Known
     values are: \"percentage\" and \"manual\"."""
    training_split_percentage: Optional[int] = rest_field(
        name="trainingSplitPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the training dataset split percentage. Only needed in case the evaluation kind is
     percentage."""
    testing_split_percentage: Optional[int] = rest_field(
        name="testingSplitPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the testing dataset split percentage. Only needed in case the evaluation kind is
     percentage."""

    @overload
    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.EvaluationKind"]] = None,
        training_split_percentage: Optional[int] = None,
        testing_split_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationJobResult(_Model):
    """EvaluationJobResult.

    :ivar evaluation_options: Represents the options used running the evaluation. Required.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar model_label: Represents trained model label. Required.
    :vartype model_label: str
    :ivar training_config_version: Represents training config version. Required.
    :vartype training_config_version: str
    :ivar percent_complete: Represents progress percentage. Required.
    :vartype percent_complete: int
    """

    evaluation_options: "_models.EvaluationDetails" = rest_field(
        name="evaluationOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the options used running the evaluation. Required."""
    model_label: str = rest_field(name="modelLabel", visibility=["read", "create", "update", "delete", "query"])
    """Represents trained model label. Required."""
    training_config_version: str = rest_field(
        name="trainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents training config version. Required."""
    percent_complete: int = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents progress percentage. Required."""

    @overload
    def __init__(
        self,
        *,
        evaluation_options: "_models.EvaluationDetails",
        model_label: str,
        training_config_version: str,
        percent_complete: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationState(_Model):
    """Represents the state of a evaluation job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    :ivar result: Represents evaluation task detailed result. Required.
    :vartype result: ~azure.ai.textanalytics.authoring.models.EvaluationJobResult
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""
    result: "_models.EvaluationJobResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents evaluation task detailed result. Required."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        result: "_models.EvaluationJobResult",
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedClass(_Model):
    """Represents a class of an exported project.

    :ivar category: The class category.
    :vartype category: str
    """

    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The class category."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCompositeEntity(_Model):
    """Represents an entity in an exported project with composite entities enabled.

    :ivar composition_setting: The behavior to follow when the entity's components overlap with
     each other. Known values are: "separateComponents" and "combineComponents".
    :vartype composition_setting: str or ~azure.ai.textanalytics.authoring.models.CompositionMode
    :ivar list: The list component of the entity.
    :vartype list: ~azure.ai.textanalytics.authoring.models.ExportedEntityList
    :ivar prebuilts: The prebuilt entities components.
    :vartype prebuilts: list[~azure.ai.textanalytics.authoring.models.ExportedPrebuiltEntity]
    :ivar category: The entity category.
    :vartype category: str
    """

    composition_setting: Optional[Union[str, "_models.CompositionMode"]] = rest_field(
        name="compositionSetting", visibility=["read", "create", "update", "delete", "query"]
    )
    """The behavior to follow when the entity's components overlap with each other. Known values are:
     \"separateComponents\" and \"combineComponents\"."""
    entity_list: Optional["_models.ExportedEntityList"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list component of the entity."""
    prebuilts: Optional[list["_models.ExportedPrebuiltEntity"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The prebuilt entities components."""
    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity category."""

    @overload
    def __init__(
        self,
        *,
        composition_setting: Optional[Union[str, "_models.CompositionMode"]] = None,
        list: Optional["_models.ExportedEntityList"] = None,
        prebuilts: Optional[list["_models.ExportedPrebuiltEntity"]] = None,
        category: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomAbstractiveSummarizationDocument(_Model):  # pylint: disable=name-too-long
    """Represents an exported document for a custom abstractive summarization project.

    :ivar summary_location: Represents the summary file location in the blob store container
     associated with the project. Required.
    :vartype summary_location: str
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    summary_location: str = rest_field(
        name="summaryLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the summary file location in the blob store container associated with the project.
     Required."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        summary_location: str,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomAbstractiveSummarizationProjectAsset(
    ExportedProjectAsset, discriminator="CustomAbstractiveSummarization"
):  # pylint: disable=name-too-long
    """Represents the exported assets for an abstractive summarization project.

    :ivar documents: The list of documents belonging to this project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomAbstractiveSummarizationDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building an
     abstractive summarization models which are able to summarize long documents.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_ABSTRACTIVE_SUMMARIZATION
    """

    documents: Optional[list["_models.ExportedCustomAbstractiveSummarizationDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents belonging to this project."""
    project_kind: Literal[ProjectKind.CUSTOM_ABSTRACTIVE_SUMMARIZATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building an abstractive
     summarization models which are able to summarize long documents."""

    @overload
    def __init__(
        self,
        *,
        documents: Optional[list["_models.ExportedCustomAbstractiveSummarizationDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_ABSTRACTIVE_SUMMARIZATION  # type: ignore


class ExportedCustomEntityRecognitionDocument(_Model):
    """Represents an exported document for a custom entity recognition project.

    :ivar entities: The list of entity labels belonging to the document.
    :vartype entities: list[~azure.ai.textanalytics.authoring.models.ExportedDocumentEntityRegion]
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    entities: Optional[list["_models.ExportedDocumentEntityRegion"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of entity labels belonging to the document."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        entities: Optional[list["_models.ExportedDocumentEntityRegion"]] = None,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomEntityRecognitionProjectAsset(
    ExportedProjectAsset, discriminator="CustomEntityRecognition"
):  # pylint: disable=name-too-long
    """Represents the exported assets for a entity recognition project.

    :ivar entities: The list of entities belonging to the project.
    :vartype entities: list[~azure.ai.textanalytics.authoring.models.ExportedEntity]
    :ivar documents: The list of documents belonging to the project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomEntityRecognitionDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building an
     extraction model to identify your domain categories using your own data.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_ENTITY_RECOGNITION
    """

    entities: Optional[list["_models.ExportedEntity"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of entities belonging to the project."""
    documents: Optional[list["_models.ExportedCustomEntityRecognitionDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents belonging to the project."""
    project_kind: Literal[ProjectKind.CUSTOM_ENTITY_RECOGNITION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building an extraction model to
     identify your domain categories using your own data."""

    @overload
    def __init__(
        self,
        *,
        entities: Optional[list["_models.ExportedEntity"]] = None,
        documents: Optional[list["_models.ExportedCustomEntityRecognitionDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_ENTITY_RECOGNITION  # type: ignore


class ExportedCustomHealthcareDocument(_Model):
    """Represents an exported document for a CustomHealthcare project.

    :ivar entities: The list of entity labels belonging to the document.
    :vartype entities: list[~azure.ai.textanalytics.authoring.models.ExportedDocumentEntityRegion]
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    entities: Optional[list["_models.ExportedDocumentEntityRegion"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of entity labels belonging to the document."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        entities: Optional[list["_models.ExportedDocumentEntityRegion"]] = None,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomHealthcareProjectAsset(ExportedProjectAsset, discriminator="CustomHealthcare"):
    """Represents the exported assets for a CustomHealthcare project.

    :ivar entities: The list of entities belonging to the project.
    :vartype entities: list[~azure.ai.textanalytics.authoring.models.ExportedCompositeEntity]
    :ivar documents: The list of documents belonging to the project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomHealthcareDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building an
     text analytics for health model to identify your health domain data.
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.CUSTOM_HEALTHCARE
    """

    entities: Optional[list["_models.ExportedCompositeEntity"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of entities belonging to the project."""
    documents: Optional[list["_models.ExportedCustomHealthcareDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents belonging to the project."""
    project_kind: Literal[ProjectKind.CUSTOM_HEALTHCARE] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building an text analytics for
     health model to identify your health domain data."""

    @overload
    def __init__(
        self,
        *,
        entities: Optional[list["_models.ExportedCompositeEntity"]] = None,
        documents: Optional[list["_models.ExportedCustomHealthcareDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_HEALTHCARE  # type: ignore


class ExportedCustomMultiLabelClassificationDocument(_Model):  # pylint: disable=name-too-long
    """Represents an exported document of a custom multi-label classification project.

    :ivar classes: The document classes.
    :vartype classes: list[~azure.ai.textanalytics.authoring.models.ExportedDocumentClass]
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    classes: Optional[list["_models.ExportedDocumentClass"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The document classes."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        classes: Optional[list["_models.ExportedDocumentClass"]] = None,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomMultiLabelClassificationProjectAsset(
    ExportedProjectAsset, discriminator="CustomMultiLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the exported assets for a custom multi-label classification project.

    :ivar classes: The list of classes in the project.
    :vartype classes: list[~azure.ai.textanalytics.authoring.models.ExportedClass]
    :ivar documents: The list of documents in the project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomMultiLabelClassificationDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building a
     classification model to classify text using your own data. Each file can have one or many
     labels. For example, file 1 is classified as A, B, and C and file 2 is classified as B and C.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_MULTI_LABEL_CLASSIFICATION
    """

    classes: Optional[list["_models.ExportedClass"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of classes in the project."""
    documents: Optional[list["_models.ExportedCustomMultiLabelClassificationDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents in the project."""
    project_kind: Literal[ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building a classification model to
     classify text using your own data. Each file can have one or many labels. For example, file 1
     is classified as A, B, and C and file 2 is classified as B and C."""

    @overload
    def __init__(
        self,
        *,
        classes: Optional[list["_models.ExportedClass"]] = None,
        documents: Optional[list["_models.ExportedCustomMultiLabelClassificationDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_MULTI_LABEL_CLASSIFICATION  # type: ignore


class ExportedCustomSingleLabelClassificationDocument(_Model):  # pylint: disable=name-too-long
    """Represents an exported document for a custom single-label classification project.

    :ivar document_class: The class of the documents.
    :vartype document_class: ~azure.ai.textanalytics.authoring.models.ExportedDocumentClass
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    document_class: Optional["_models.ExportedDocumentClass"] = rest_field(
        name="class", visibility=["read", "create", "update", "delete", "query"]
    )
    """The class of the documents."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        document_class: Optional["_models.ExportedDocumentClass"] = None,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedCustomSingleLabelClassificationProjectAsset(
    ExportedProjectAsset, discriminator="CustomSingleLabelClassification"
):  # pylint: disable=name-too-long
    """Represents the exported assets for a single-label classification project.

    :ivar classes: The list of classes belonging to this project.
    :vartype classes: list[~azure.ai.textanalytics.authoring.models.ExportedClass]
    :ivar documents: The list of documents belonging to this project.
    :vartype documents:
     list[~azure.ai.textanalytics.authoring.models.ExportedCustomSingleLabelClassificationDocument]
    :ivar project_kind: The type of the project the assets belong to. Required. For building a
     classification model to classify text using your own data. Each file will have only one label.
     For example, file 1 is classified as A and file 2 is classified as B.
    :vartype project_kind: str or
     ~azure.ai.textanalytics.authoring.models.CUSTOM_SINGLE_LABEL_CLASSIFICATION
    """

    classes: Optional[list["_models.ExportedClass"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of classes belonging to this project."""
    documents: Optional[list["_models.ExportedCustomSingleLabelClassificationDocument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of documents belonging to this project."""
    project_kind: Literal[ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the project the assets belong to. Required. For building a classification model to
     classify text using your own data. Each file will have only one label. For example, file 1 is
     classified as A and file 2 is classified as B."""

    @overload
    def __init__(
        self,
        *,
        classes: Optional[list["_models.ExportedClass"]] = None,
        documents: Optional[list["_models.ExportedCustomSingleLabelClassificationDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.project_kind = ProjectKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION  # type: ignore


class ExportedCustomTextSentimentDocument(_Model):
    """Represents an exported document for a custom text sentiment project.

    :ivar sentiment_spans:
    :vartype sentiment_spans:
     list[~azure.ai.textanalytics.authoring.models.ExportedDocumentSentimentLabel]
    :ivar location: The location of the document in the storage.
    :vartype location: str
    :ivar language: Represents the document language. This is BCP-47 representation of a language.
     For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar dataset: The dataset for this document. Allowed values are 'Train' and 'Test'.
    :vartype dataset: str
    """

    sentiment_spans: Optional[list["_models.ExportedDocumentSentimentLabel"]] = rest_field(
        name="sentimentSpans", visibility=["read", "create", "update", "delete", "query"]
    )
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the document in the storage."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the document language. This is BCP-47 representation of a language. For example, use
     \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    dataset: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dataset for this document. Allowed values are 'Train' and 'Test'."""

    @overload
    def __init__(
        self,
        *,
        sentiment_spans: Optional[list["_models.ExportedDocumentSentimentLabel"]] = None,
        location: Optional[str] = None,
        language: Optional[str] = None,
        dataset: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedDocumentClass(_Model):
    """Represents a classification label for a document.

    :ivar category:
    :vartype category: str
    """

    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        category: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedDocumentEntityLabel(_Model):
    """Represents an entity label for a document.

    :ivar category: The entity category.
    :vartype category: str
    :ivar offset: Start position for the entity text.
    :vartype offset: int
    :ivar length: Length for the entity text.
    :vartype length: int
    """

    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity category."""
    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[str] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedDocumentEntityRegion(_Model):
    """Represents a region in a document for entity labeling.

    :ivar region_offset: Start position for the region.
    :vartype region_offset: int
    :ivar region_length: Length for the region text.
    :vartype region_length: int
    :ivar labels: The list of entity labels belonging to this region.
    :vartype labels: list[~azure.ai.textanalytics.authoring.models.ExportedDocumentEntityLabel]
    """

    region_offset: Optional[int] = rest_field(
        name="regionOffset", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start position for the region."""
    region_length: Optional[int] = rest_field(
        name="regionLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """Length for the region text."""
    labels: Optional[list["_models.ExportedDocumentEntityLabel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of entity labels belonging to this region."""

    @overload
    def __init__(
        self,
        *,
        region_offset: Optional[int] = None,
        region_length: Optional[int] = None,
        labels: Optional[list["_models.ExportedDocumentEntityLabel"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedDocumentSentimentLabel(_Model):
    """Represents an entity label for a document.

    :ivar category: The sentiment category. Known values are: "positive", "negative", and
     "neutral".
    :vartype category: str or ~azure.ai.textanalytics.authoring.models.Sentiment
    :ivar offset: Start position for the sentiment text.
    :vartype offset: int
    :ivar length: Length for the sentiment text.
    :vartype length: int
    """

    category: Optional[Union[str, "_models.Sentiment"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment category. Known values are: \"positive\", \"negative\", and \"neutral\"."""
    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the sentiment text."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the sentiment text."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.Sentiment"]] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedEntity(_Model):
    """Represents an entity in an exported project.

    :ivar category: The entity category.
    :vartype category: str
    :ivar description: Short description for entity category. Required when enabling synthetic data
     generation.
    :vartype description: str
    """

    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity category."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Short description for entity category. Required when enabling synthetic data generation."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedEntityList(_Model):
    """Represents a list component of an entity.

    :ivar sublists: The sub-lists of the list component.
    :vartype sublists: list[~azure.ai.textanalytics.authoring.models.ExportedEntitySublist]
    """

    sublists: Optional[list["_models.ExportedEntitySublist"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sub-lists of the list component."""

    @overload
    def __init__(
        self,
        *,
        sublists: Optional[list["_models.ExportedEntitySublist"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedEntityListSynonym(_Model):
    """Represents a list of synonyms inside a list component.

    :ivar language: Represents the language of the synonyms. This is BCP-47 representation of a
     language. For example, use "en" for English, "en-gb" for English (UK), "es" for Spanish etc.
    :vartype language: str
    :ivar synonyms: The list of synonyms.
    :vartype synonyms: list[str]
    """

    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the language of the synonyms. This is BCP-47 representation of a language. For
     example, use \"en\" for English, \"en-gb\" for English (UK), \"es\" for Spanish etc."""
    synonyms: Optional[list[str]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of synonyms."""

    @overload
    def __init__(
        self,
        *,
        language: Optional[str] = None,
        synonyms: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedEntitySublist(_Model):
    """Represents a sub-list inside a list component.

    :ivar list_key: The key of the sub-list.
    :vartype list_key: str
    :ivar synonyms: The phrases of that correspond to the sub-list.
    :vartype synonyms: list[~azure.ai.textanalytics.authoring.models.ExportedEntityListSynonym]
    """

    list_key: Optional[str] = rest_field(name="listKey", visibility=["read", "create", "update", "delete", "query"])
    """The key of the sub-list."""
    synonyms: Optional[list["_models.ExportedEntityListSynonym"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The phrases of that correspond to the sub-list."""

    @overload
    def __init__(
        self,
        *,
        list_key: Optional[str] = None,
        synonyms: Optional[list["_models.ExportedEntityListSynonym"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedModelDetails(_Model):
    """Represents the options for creating or replacing an exported model.

    :ivar trained_model_label: The trained model label. Required.
    :vartype trained_model_label: str
    """

    trained_model_label: str = rest_field(
        name="trainedModelLabel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The trained model label. Required."""

    @overload
    def __init__(
        self,
        *,
        trained_model_label: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedModelManifest(_Model):
    """Represents the properties for the exported model manifest.

    :ivar model_files: The model files belonging to this model. Required.
    :vartype model_files: list[~azure.ai.textanalytics.authoring.models.ModelFile]
    """

    model_files: list["_models.ModelFile"] = rest_field(
        name="modelFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model files belonging to this model. Required."""

    @overload
    def __init__(
        self,
        *,
        model_files: list["_models.ModelFile"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedModelState(_Model):
    """Represents the state of a job to create or updated an exported model.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedPrebuiltEntity(_Model):
    """Represents an exported prebuilt entity component.

    :ivar category: The prebuilt entity category. Required.
    :vartype category: str
    """

    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The prebuilt entity category. Required."""

    @overload
    def __init__(
        self,
        *,
        category: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedProject(_Model):
    """Represents an exported project.

    :ivar project_file_version: The version of the exported file. Required.
    :vartype project_file_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets. For additional
     information see `https://aka.ms/text-analytics-offsets
     <https://aka.ms/text-analytics-offsets>`_. Required. "Utf16CodeUnit"
    :vartype string_index_type: str or ~azure.ai.textanalytics.authoring.models.StringIndexType
    :ivar metadata: Represents the project metadata. Required.
    :vartype metadata: ~azure.ai.textanalytics.authoring.models.CreateProjectOptions
    :ivar assets: Represents the project assets.
    :vartype assets: ~azure.ai.textanalytics.authoring.models.ExportedProjectAsset
    """

    project_file_version: str = rest_field(
        name="projectFileVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the exported file. Required."""
    string_index_type: Union[str, "_models.StringIndexType"] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets. For additional information see
     `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Required.
     \"Utf16CodeUnit\""""
    metadata: "_models.CreateProjectOptions" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the project metadata. Required."""
    assets: Optional["_models.ExportedProjectAsset"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the project assets."""

    @overload
    def __init__(
        self,
        *,
        project_file_version: str,
        string_index_type: Union[str, "_models.StringIndexType"],
        metadata: "_models.CreateProjectOptions",
        assets: Optional["_models.ExportedProjectAsset"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportedTrainedModel(_Model):
    """Represents an exported trained model.

    :ivar exported_model_name: The exported model name. Required.
    :vartype exported_model_name: str
    :ivar model_id: The model ID. Required.
    :vartype model_id: str
    :ivar last_trained_on: The last trained date time of the model. Required.
    :vartype last_trained_on: ~datetime.datetime
    :ivar last_exported_model_on: The last exported date time of the model. Required.
    :vartype last_exported_model_on: ~datetime.datetime
    :ivar model_expired_on: The model expiration date. Required.
    :vartype model_expired_on: ~datetime.date
    :ivar model_training_config_version: The model training config version. Required.
    :vartype model_training_config_version: str
    """

    exported_model_name: str = rest_field(name="exportedModelName", visibility=["read"])
    """The exported model name. Required."""
    model_id: str = rest_field(name="modelId", visibility=["read", "create", "update", "delete", "query"])
    """The model ID. Required."""
    last_trained_on: datetime.datetime = rest_field(
        name="lastTrainedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last trained date time of the model. Required."""
    last_exported_model_on: datetime.datetime = rest_field(
        name="lastExportedModelDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last exported date time of the model. Required."""
    model_expired_on: datetime.date = rest_field(
        name="modelExpirationDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model expiration date. Required."""
    model_training_config_version: str = rest_field(
        name="modelTrainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model training config version. Required."""

    @overload
    def __init__(
        self,
        *,
        model_id: str,
        last_trained_on: datetime.datetime,
        last_exported_model_on: datetime.datetime,
        model_expired_on: datetime.date,
        model_training_config_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExportProjectState(_Model):
    """Represents the state of an export job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    :ivar result_url: The URL to use in order to download the exported project.
    :vartype result_url: str
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""
    result_url: Optional[str] = rest_field(name="resultUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL to use in order to download the exported project."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
        result_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImportProjectState(_Model):
    """Represents the state of an import job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LoadSnapshotState(_Model):
    """Represents the state of loading a snapshot job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ModelFile(_Model):
    """Represents the properties for the model file.

    :ivar name: The name of the file. Required.
    :vartype name: str
    :ivar content_uri: The URI to retrieve the content of the file. Required.
    :vartype content_uri: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the file. Required."""
    content_uri: str = rest_field(name="contentUri", visibility=["read", "create", "update", "delete", "query"])
    """The URI to retrieve the content of the file. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        content_uri: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiLabelClassEvalSummary(_Model):
    """Represents the evaluation summary of a class in a multi-label classification project.

    :ivar f1: Represents the model precision. Required.
    :vartype f1: float
    :ivar precision: Represents the model recall. Required.
    :vartype precision: float
    :ivar recall: Represents the model F1 score. Required.
    :vartype recall: float
    :ivar true_positive_count: Represents the count of true positive. Required.
    :vartype true_positive_count: int
    :ivar true_negative_count: Represents the count of true negative. Required.
    :vartype true_negative_count: int
    :ivar false_positive_count: Represents the count of false positive. Required.
    :vartype false_positive_count: int
    :ivar false_negative_count: Represents the count of false negative. Required.
    :vartype false_negative_count: int
    """

    f1: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model precision. Required."""
    precision: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model recall. Required."""
    recall: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model F1 score. Required."""
    true_positive_count: int = rest_field(
        name="truePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true positive. Required."""
    true_negative_count: int = rest_field(
        name="trueNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true negative. Required."""
    false_positive_count: int = rest_field(
        name="falsePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false positive. Required."""
    false_negative_count: int = rest_field(
        name="falseNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false negative. Required."""

    @overload
    def __init__(
        self,
        *,
        f1: float,
        precision: float,
        recall: float,
        true_positive_count: int,
        true_negative_count: int,
        false_positive_count: int,
        false_negative_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiLabelClassificationEvalSummary(_Model):
    """Represents the evaluation summary for a multi-label classification project.

    :ivar classes: Represents the classes evaluation. Required.
    :vartype classes: dict[str,
     ~azure.ai.textanalytics.authoring.models.MultiLabelClassEvalSummary]
    :ivar micro_f1: Represents the micro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype micro_f1: float
    :ivar micro_precision: Represents the micro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype micro_precision: float
    :ivar micro_recall: Represents the micro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype micro_recall: float
    :ivar macro_f1: Represents the macro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype macro_f1: float
    :ivar macro_precision: Represents the macro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype macro_precision: float
    :ivar macro_recall: Represents the macro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype macro_recall: float
    """

    classes: dict[str, "_models.MultiLabelClassEvalSummary"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the classes evaluation. Required."""
    micro_f1: float = rest_field(name="microF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_precision: float = rest_field(
        name="microPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the micro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_recall: float = rest_field(name="microRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro recall. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_f1: float = rest_field(name="macroF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_precision: float = rest_field(
        name="macroPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the macro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_recall: float = rest_field(name="macroRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro recall. Expected value is a float between 0 and 1 inclusive. Required."""

    @overload
    def __init__(
        self,
        *,
        classes: dict[str, "_models.MultiLabelClassEvalSummary"],
        micro_f1: float,
        micro_precision: float,
        micro_recall: float,
        macro_f1: float,
        macro_precision: float,
        macro_recall: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrebuiltEntity(_Model):
    """Represents a supported prebuilt entity.

    :ivar category: The prebuilt entity category. Required.
    :vartype category: str
    :ivar description: The description. Required.
    :vartype description: str
    :ivar examples: English examples for the entity. Required.
    :vartype examples: str
    """

    category: str = rest_field(visibility=["read"])
    """The prebuilt entity category. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description. Required."""
    examples: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """English examples for the entity. Required."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        examples: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectDeletionState(_Model):
    """Represents the state of a project deletion job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectDeployment(_Model):
    """Represents a project deployment.

    :ivar deployment_name: Represents deployment name. Required.
    :vartype deployment_name: str
    :ivar model_id: Represents deployment modelId. Required.
    :vartype model_id: str
    :ivar last_trained_on: Represents deployment last trained time. Required.
    :vartype last_trained_on: ~datetime.datetime
    :ivar last_deployed_on: Represents deployment last deployed time. Required.
    :vartype last_deployed_on: ~datetime.datetime
    :ivar deployment_expired_on: Represents deployment expiration date in the runtime. Required.
    :vartype deployment_expired_on: ~datetime.date
    :ivar model_training_config_version: Represents model training config version. Required.
    :vartype model_training_config_version: str
    :ivar assigned_resources: Represents the metadata of the assigned Azure resources. Required.
    :vartype assigned_resources: list[~azure.ai.textanalytics.authoring.models.DeploymentResource]
    """

    deployment_name: str = rest_field(name="deploymentName", visibility=["read"])
    """Represents deployment name. Required."""
    model_id: str = rest_field(name="modelId", visibility=["read", "create", "update", "delete", "query"])
    """Represents deployment modelId. Required."""
    last_trained_on: datetime.datetime = rest_field(
        name="lastTrainedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents deployment last trained time. Required."""
    last_deployed_on: datetime.datetime = rest_field(
        name="lastDeployedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents deployment last deployed time. Required."""
    deployment_expired_on: datetime.date = rest_field(
        name="deploymentExpirationDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents deployment expiration date in the runtime. Required."""
    model_training_config_version: str = rest_field(
        name="modelTrainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents model training config version. Required."""
    assigned_resources: list["_models.DeploymentResource"] = rest_field(
        name="assignedResources", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the metadata of the assigned Azure resources. Required."""

    @overload
    def __init__(
        self,
        *,
        model_id: str,
        last_trained_on: datetime.datetime,
        last_deployed_on: datetime.datetime,
        deployment_expired_on: datetime.date,
        model_training_config_version: str,
        assigned_resources: list["_models.DeploymentResource"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectDetails(_Model):
    """Represents the metadata of a project.

    :ivar created_on: Represents the project creation datetime. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_modified_on: Represents the project last modification datetime. Required.
    :vartype last_modified_on: ~datetime.datetime
    :ivar last_trained_on: Represents the project last training datetime.
    :vartype last_trained_on: ~datetime.datetime
    :ivar last_deployed_on: Represents the project last deployment datetime.
    :vartype last_deployed_on: ~datetime.datetime
    :ivar project_kind: The project kind. Required. Known values are:
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", "CustomEntityRecognition",
     "CustomAbstractiveSummarization", "CustomHealthcare", and "CustomTextSentiment".
    :vartype project_kind: str or ~azure.ai.textanalytics.authoring.models.ProjectKind
    :ivar storage_input_container_name: The storage container name. Required.
    :vartype storage_input_container_name: str
    :ivar settings: The project settings.
    :vartype settings: ~azure.ai.textanalytics.authoring.models.ProjectSettings
    :ivar project_name: The new project name. Required.
    :vartype project_name: str
    :ivar multilingual: Whether the project would be used for multiple languages or not.
    :vartype multilingual: bool
    :ivar description: The project description.
    :vartype description: str
    :ivar language: The project language. This is BCP-47 representation of a language. For example,
     use "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language: str
    """

    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the project creation datetime. Required."""
    last_modified_on: datetime.datetime = rest_field(
        name="lastModifiedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the project last modification datetime. Required."""
    last_trained_on: Optional[datetime.datetime] = rest_field(
        name="lastTrainedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the project last training datetime."""
    last_deployed_on: Optional[datetime.datetime] = rest_field(
        name="lastDeployedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the project last deployment datetime."""
    project_kind: Union[str, "_models.ProjectKind"] = rest_field(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The project kind. Required. Known values are: \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"CustomEntityRecognition\",
     \"CustomAbstractiveSummarization\", \"CustomHealthcare\", and \"CustomTextSentiment\"."""
    storage_input_container_name: str = rest_field(
        name="storageInputContainerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage container name. Required."""
    settings: Optional["_models.ProjectSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project settings."""
    project_name: str = rest_field(name="projectName", visibility=["read"])
    """The new project name. Required."""
    multilingual: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the project would be used for multiple languages or not."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The project description."""
    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The project language. This is BCP-47 representation of a language. For example, use \"en\" for
     English, \"en-gb\" for English (UK), \"es\" for Spanish etc. Required."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_modified_on: datetime.datetime,
        project_kind: Union[str, "_models.ProjectKind"],
        storage_input_container_name: str,
        language: str,
        last_trained_on: Optional[datetime.datetime] = None,
        last_deployed_on: Optional[datetime.datetime] = None,
        settings: Optional["_models.ProjectSettings"] = None,
        multilingual: Optional[bool] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectSettings(_Model):
    """Represents the settings used to define the project behavior.

    :ivar confidence_threshold: The threshold of the class with the highest confidence, at which
     the prediction will automatically be changed to "None". The value of the threshold should be
     between 0 and 1 inclusive.
    :vartype confidence_threshold: float
    :ivar aml_project_path: The path to the AML connected project.
    :vartype aml_project_path: str
    :ivar is_labeling_locked: Indicates whether the labeling experience can be modified or not.
    :vartype is_labeling_locked: bool
    :ivar run_gpt_predictions: Indicates whether to run GPT predictions or not.
    :vartype run_gpt_predictions: bool
    :ivar gpt_predictive_lookahead: The predictive lookahead for GPT predictions that is specified
     by the user.
    :vartype gpt_predictive_lookahead: int
    """

    confidence_threshold: Optional[float] = rest_field(
        name="confidenceThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The threshold of the class with the highest confidence, at which the prediction will
     automatically be changed to \"None\". The value of the threshold should be between 0 and 1
     inclusive."""
    aml_project_path: Optional[str] = rest_field(
        name="amlProjectPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The path to the AML connected project."""
    is_labeling_locked: Optional[bool] = rest_field(
        name="isLabelingLocked", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the labeling experience can be modified or not."""
    run_gpt_predictions: Optional[bool] = rest_field(
        name="runGptPredictions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether to run GPT predictions or not."""
    gpt_predictive_lookahead: Optional[int] = rest_field(
        name="gptPredictiveLookahead", visibility=["read", "create", "update", "delete", "query"]
    )
    """The predictive lookahead for GPT predictions that is specified by the user."""

    @overload
    def __init__(
        self,
        *,
        confidence_threshold: Optional[float] = None,
        aml_project_path: Optional[str] = None,
        is_labeling_locked: Optional[bool] = None,
        run_gpt_predictions: Optional[bool] = None,
        gpt_predictive_lookahead: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectTrainedModel(_Model):
    """Represents a trained model.

    :ivar label: The trained model label. Required.
    :vartype label: str
    :ivar model_id: The model ID. Required.
    :vartype model_id: str
    :ivar last_trained_on: The last trained date time of the model. Required.
    :vartype last_trained_on: ~datetime.datetime
    :ivar last_training_duration_in_seconds: The duration of the model's last training request in
     seconds. Required.
    :vartype last_training_duration_in_seconds: int
    :ivar model_expired_on: The model expiration date. Required.
    :vartype model_expired_on: ~datetime.date
    :ivar model_training_config_version: The model training config version. Required.
    :vartype model_training_config_version: str
    :ivar has_snapshot: The flag to indicate if the trained model has a snapshot ready. Required.
    :vartype has_snapshot: bool
    """

    label: str = rest_field(visibility=["read"])
    """The trained model label. Required."""
    model_id: str = rest_field(name="modelId", visibility=["read", "create", "update", "delete", "query"])
    """The model ID. Required."""
    last_trained_on: datetime.datetime = rest_field(
        name="lastTrainedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last trained date time of the model. Required."""
    last_training_duration_in_seconds: int = rest_field(
        name="lastTrainingDurationInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The duration of the model's last training request in seconds. Required."""
    model_expired_on: datetime.date = rest_field(
        name="modelExpirationDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model expiration date. Required."""
    model_training_config_version: str = rest_field(
        name="modelTrainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model training config version. Required."""
    has_snapshot: bool = rest_field(name="hasSnapshot", visibility=["read", "create", "update", "delete", "query"])
    """The flag to indicate if the trained model has a snapshot ready. Required."""

    @overload
    def __init__(
        self,
        *,
        model_id: str,
        last_trained_on: datetime.datetime,
        last_training_duration_in_seconds: int,
        model_expired_on: datetime.date,
        model_training_config_version: str,
        has_snapshot: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceMetadata(_Model):
    """Represents metadata for the Azure resource..

    :ivar azure_resource_id: Represents the Azure resource ID. Required.
    :vartype azure_resource_id: str
    :ivar custom_domain: Represents the Azure resource custom domain. Required.
    :vartype custom_domain: str
    :ivar region: Represents the Azure resource region. Required.
    :vartype region: str
    """

    azure_resource_id: str = rest_field(
        name="azureResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the Azure resource ID. Required."""
    custom_domain: str = rest_field(name="customDomain", visibility=["read", "create", "update", "delete", "query"])
    """Represents the Azure resource custom domain. Required."""
    region: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the Azure resource region. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_resource_id: str,
        custom_domain: str,
        region: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentEvalSummary(_Model):
    """Represents the evaluation summary for a sentiment in a custom sentiment project.

    :ivar f1: Represents the model precision. Required.
    :vartype f1: float
    :ivar precision: Represents the model recall. Required.
    :vartype precision: float
    :ivar recall: Represents the model F1 score. Required.
    :vartype recall: float
    :ivar true_positive_count: Represents the count of true positive. Required.
    :vartype true_positive_count: int
    :ivar true_negative_count: Represents the count of true negative. Required.
    :vartype true_negative_count: int
    :ivar false_positive_count: Represents the count of false positive. Required.
    :vartype false_positive_count: int
    :ivar false_negative_count: Represents the count of false negative. Required.
    :vartype false_negative_count: int
    """

    f1: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model precision. Required."""
    precision: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model recall. Required."""
    recall: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model F1 score. Required."""
    true_positive_count: int = rest_field(
        name="truePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true positive. Required."""
    true_negative_count: int = rest_field(
        name="trueNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true negative. Required."""
    false_positive_count: int = rest_field(
        name="falsePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false positive. Required."""
    false_negative_count: int = rest_field(
        name="falseNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false negative. Required."""

    @overload
    def __init__(
        self,
        *,
        f1: float,
        precision: float,
        recall: float,
        true_positive_count: int,
        true_negative_count: int,
        false_positive_count: int,
        false_negative_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingleLabelClassEvalSummary(_Model):
    """Represents the evaluation summary for a class in a single-label classification project.

    :ivar f1: Represents the model precision. Required.
    :vartype f1: float
    :ivar precision: Represents the model recall. Required.
    :vartype precision: float
    :ivar recall: Represents the model F1 score. Required.
    :vartype recall: float
    :ivar true_positive_count: Represents the count of true positive. Required.
    :vartype true_positive_count: int
    :ivar true_negative_count: Represents the count of true negative. Required.
    :vartype true_negative_count: int
    :ivar false_positive_count: Represents the count of false positive. Required.
    :vartype false_positive_count: int
    :ivar false_negative_count: Represents the count of false negative. Required.
    :vartype false_negative_count: int
    """

    f1: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model precision. Required."""
    precision: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model recall. Required."""
    recall: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the model F1 score. Required."""
    true_positive_count: int = rest_field(
        name="truePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true positive. Required."""
    true_negative_count: int = rest_field(
        name="trueNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of true negative. Required."""
    false_positive_count: int = rest_field(
        name="falsePositiveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false positive. Required."""
    false_negative_count: int = rest_field(
        name="falseNegativeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the count of false negative. Required."""

    @overload
    def __init__(
        self,
        *,
        f1: float,
        precision: float,
        recall: float,
        true_positive_count: int,
        true_negative_count: int,
        false_positive_count: int,
        false_negative_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingleLabelClassificationEvalSummary(_Model):
    """Represents the evaluation summary for a custom single-label classification project.

    :ivar confusion_matrix: Represents the confusion matrix between two classes (the two classes
     can be the same). The matrix is between the class that was labelled and the class that was
     predicted. Required.
    :vartype confusion_matrix: dict[str,
     ~azure.ai.textanalytics.authoring.models.ConfusionMatrixRow]
    :ivar classes: Represents the classes evaluation. Required.
    :vartype classes: dict[str,
     ~azure.ai.textanalytics.authoring.models.SingleLabelClassEvalSummary]
    :ivar micro_f1: Represents the micro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype micro_f1: float
    :ivar micro_precision: Represents the micro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype micro_precision: float
    :ivar micro_recall: Represents the micro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype micro_recall: float
    :ivar macro_f1: Represents the macro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype macro_f1: float
    :ivar macro_precision: Represents the macro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype macro_precision: float
    :ivar macro_recall: Represents the macro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype macro_recall: float
    """

    confusion_matrix: dict[str, "_models.ConfusionMatrixRow"] = rest_field(
        name="confusionMatrix", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the confusion matrix between two classes (the two classes can be the same). The
     matrix is between the class that was labelled and the class that was predicted. Required."""
    classes: dict[str, "_models.SingleLabelClassEvalSummary"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the classes evaluation. Required."""
    micro_f1: float = rest_field(name="microF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_precision: float = rest_field(
        name="microPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the micro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_recall: float = rest_field(name="microRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro recall. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_f1: float = rest_field(name="macroF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_precision: float = rest_field(
        name="macroPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the macro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_recall: float = rest_field(name="macroRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro recall. Expected value is a float between 0 and 1 inclusive. Required."""

    @overload
    def __init__(
        self,
        *,
        confusion_matrix: dict[str, "_models.ConfusionMatrixRow"],
        classes: dict[str, "_models.SingleLabelClassEvalSummary"],
        micro_f1: float,
        micro_precision: float,
        micro_recall: float,
        macro_f1: float,
        macro_precision: float,
        macro_recall: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpanSentimentEvalSummary(_Model):
    """Represents the evaluation summary for a custom sentiment project.

    :ivar confusion_matrix: Represents the confusion matrix between two sentiments (the two
     sentiments can be the same). The matrix is between the sentiment that was labelled and the
     sentiment that was predicted. Required.
    :vartype confusion_matrix: dict[str,
     ~azure.ai.textanalytics.authoring.models.ConfusionMatrixRow]
    :ivar sentiments: Represents the sentiment evaluation. Required.
    :vartype sentiments: dict[str, ~azure.ai.textanalytics.authoring.models.SentimentEvalSummary]
    :ivar micro_f1: Represents the micro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype micro_f1: float
    :ivar micro_precision: Represents the micro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype micro_precision: float
    :ivar micro_recall: Represents the micro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype micro_recall: float
    :ivar macro_f1: Represents the macro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype macro_f1: float
    :ivar macro_precision: Represents the macro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype macro_precision: float
    :ivar macro_recall: Represents the macro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype macro_recall: float
    """

    confusion_matrix: dict[str, "_models.ConfusionMatrixRow"] = rest_field(
        name="confusionMatrix", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the confusion matrix between two sentiments (the two sentiments can be the same).
     The matrix is between the sentiment that was labelled and the sentiment that was predicted.
     Required."""
    sentiments: dict[str, "_models.SentimentEvalSummary"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the sentiment evaluation. Required."""
    micro_f1: float = rest_field(name="microF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_precision: float = rest_field(
        name="microPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the micro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_recall: float = rest_field(name="microRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro recall. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_f1: float = rest_field(name="macroF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_precision: float = rest_field(
        name="macroPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the macro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_recall: float = rest_field(name="macroRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro recall. Expected value is a float between 0 and 1 inclusive. Required."""

    @overload
    def __init__(
        self,
        *,
        confusion_matrix: dict[str, "_models.ConfusionMatrixRow"],
        sentiments: dict[str, "_models.SentimentEvalSummary"],
        micro_f1: float,
        micro_precision: float,
        micro_recall: float,
        macro_f1: float,
        macro_precision: float,
        macro_recall: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubTrainingState(_Model):
    """Represents the detailed state of a training sub-operation.

    :ivar percent_complete: Represents progress percentage. Required.
    :vartype percent_complete: int
    :ivar started_on: Represents the start date time.
    :vartype started_on: ~datetime.datetime
    :ivar ended_on: Represents the end date time.
    :vartype ended_on: ~datetime.datetime
    :ivar status: Represents the status of the sub-operation. Required. Known values are:
     "notStarted", "running", "succeeded", "failed", "cancelled", "cancelling", and
     "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    """

    percent_complete: int = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents progress percentage. Required."""
    started_on: Optional[datetime.datetime] = rest_field(
        name="startDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the start date time."""
    ended_on: Optional[datetime.datetime] = rest_field(
        name="endDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the end date time."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the status of the sub-operation. Required. Known values are: \"notStarted\",
     \"running\", \"succeeded\", \"failed\", \"cancelled\", \"cancelling\", and
     \"partiallyCompleted\"."""

    @overload
    def __init__(
        self,
        *,
        percent_complete: int,
        status: Union[str, "_models.OperationStatus"],
        started_on: Optional[datetime.datetime] = None,
        ended_on: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SupportedLanguage(_Model):
    """Represents a supported language.

    :ivar language_name: The language name. Required.
    :vartype language_name: str
    :ivar language_code: The language code. This is BCP-47 representation of a language. For
     example, "en" for English, "en-gb" for English (UK), "es" for Spanish etc. Required.
    :vartype language_code: str
    """

    language_name: str = rest_field(name="languageName", visibility=["read"])
    """The language name. Required."""
    language_code: str = rest_field(name="languageCode", visibility=["read", "create", "update", "delete", "query"])
    """The language code. This is BCP-47 representation of a language. For example, \"en\" for
     English, \"en-gb\" for English (UK), \"es\" for Spanish etc. Required."""

    @overload
    def __init__(
        self,
        *,
        language_code: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SwapDeploymentsDetails(_Model):
    """Represents the options for swapping two deployments together.

    :ivar first_deployment_name: Represents the first deployment name. Required.
    :vartype first_deployment_name: str
    :ivar second_deployment_name: Represents the second deployment name. Required.
    :vartype second_deployment_name: str
    """

    first_deployment_name: str = rest_field(
        name="firstDeploymentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the first deployment name. Required."""
    second_deployment_name: str = rest_field(
        name="secondDeploymentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the second deployment name. Required."""

    @overload
    def __init__(
        self,
        *,
        first_deployment_name: str,
        second_deployment_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SwapDeploymentsState(_Model):
    """Represents the state of a deployment job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextSentimentEvalSummary(_Model):
    """Represents the evaluation summary for a custom text sentiment project.

    :ivar span_sentiments_evaluation: Represents evaluation of span level sentiments. Required.
    :vartype span_sentiments_evaluation:
     ~azure.ai.textanalytics.authoring.models.SpanSentimentEvalSummary
    :ivar micro_f1: Represents the micro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype micro_f1: float
    :ivar micro_precision: Represents the micro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype micro_precision: float
    :ivar micro_recall: Represents the micro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype micro_recall: float
    :ivar macro_f1: Represents the macro F1. Expected value is a float between 0 and 1 inclusive.
     Required.
    :vartype macro_f1: float
    :ivar macro_precision: Represents the macro precision. Expected value is a float between 0 and
     1 inclusive. Required.
    :vartype macro_precision: float
    :ivar macro_recall: Represents the macro recall. Expected value is a float between 0 and 1
     inclusive. Required.
    :vartype macro_recall: float
    """

    span_sentiments_evaluation: "_models.SpanSentimentEvalSummary" = rest_field(
        name="spanSentimentsEvaluation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents evaluation of span level sentiments. Required."""
    micro_f1: float = rest_field(name="microF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_precision: float = rest_field(
        name="microPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the micro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    micro_recall: float = rest_field(name="microRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the micro recall. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_f1: float = rest_field(name="macroF1", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro F1. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_precision: float = rest_field(
        name="macroPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the macro precision. Expected value is a float between 0 and 1 inclusive. Required."""
    macro_recall: float = rest_field(name="macroRecall", visibility=["read", "create", "update", "delete", "query"])
    """Represents the macro recall. Expected value is a float between 0 and 1 inclusive. Required."""

    @overload
    def __init__(
        self,
        *,
        span_sentiments_evaluation: "_models.SpanSentimentEvalSummary",
        micro_f1: float,
        micro_precision: float,
        micro_recall: float,
        macro_f1: float,
        macro_precision: float,
        macro_recall: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrainingConfigVersion(_Model):
    """Represents a training config version.

    :ivar training_config_version: Represents the version of the config. Required.
    :vartype training_config_version: str
    :ivar model_expired_on: Represents the training config version expiration date. Required.
    :vartype model_expired_on: ~datetime.date
    """

    training_config_version: str = rest_field(name="trainingConfigVersion", visibility=["read"])
    """Represents the version of the config. Required."""
    model_expired_on: datetime.date = rest_field(
        name="modelExpirationDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the training config version expiration date. Required."""

    @overload
    def __init__(
        self,
        *,
        model_expired_on: datetime.date,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrainingJobDetails(_Model):
    """Represents the options for starting a new training job.

    :ivar model_label: Represents the output model label. Required.
    :vartype model_label: str
    :ivar training_config_version: Represents training config version. Required.
    :vartype training_config_version: str
    :ivar evaluation_options: Represents the evaluation options. By default, the evaluation kind is
     percentage, with training split percentage as 80, and testing split percentage as 20.
    :vartype evaluation_options: ~azure.ai.textanalytics.authoring.models.EvaluationDetails
    :ivar data_generation_settings: Represents the settings for using data generation as part of
     training a custom model.
    :vartype data_generation_settings:
     ~azure.ai.textanalytics.authoring.models.DataGenerationSetting
    """

    model_label: str = rest_field(name="modelLabel", visibility=["read", "create", "update", "delete", "query"])
    """Represents the output model label. Required."""
    training_config_version: str = rest_field(
        name="trainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents training config version. Required."""
    evaluation_options: Optional["_models.EvaluationDetails"] = rest_field(
        name="evaluationOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the evaluation options. By default, the evaluation kind is percentage, with training
     split percentage as 80, and testing split percentage as 20."""
    data_generation_settings: Optional["_models.DataGenerationSetting"] = rest_field(
        name="dataGenerationSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the settings for using data generation as part of training a custom model."""

    @overload
    def __init__(
        self,
        *,
        model_label: str,
        training_config_version: str,
        evaluation_options: Optional["_models.EvaluationDetails"] = None,
        data_generation_settings: Optional["_models.DataGenerationSetting"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrainingJobResult(_Model):
    """Represents the output of a training job.

    :ivar model_label: Represents trained model label. Required.
    :vartype model_label: str
    :ivar training_config_version: Represents training config version. Required.
    :vartype training_config_version: str
    :ivar training_status: Represents model train status. Required.
    :vartype training_status: ~azure.ai.textanalytics.authoring.models.SubTrainingState
    :ivar evaluation_status: Represents model evaluation status.
    :vartype evaluation_status: ~azure.ai.textanalytics.authoring.models.SubTrainingState
    :ivar estimated_end_on: Represents the estimate end date time for training and evaluation.
    :vartype estimated_end_on: ~datetime.datetime
    """

    model_label: str = rest_field(name="modelLabel", visibility=["read", "create", "update", "delete", "query"])
    """Represents trained model label. Required."""
    training_config_version: str = rest_field(
        name="trainingConfigVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents training config version. Required."""
    training_status: "_models.SubTrainingState" = rest_field(
        name="trainingStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents model train status. Required."""
    evaluation_status: Optional["_models.SubTrainingState"] = rest_field(
        name="evaluationStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents model evaluation status."""
    estimated_end_on: Optional[datetime.datetime] = rest_field(
        name="estimatedEndDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Represents the estimate end date time for training and evaluation."""

    @overload
    def __init__(
        self,
        *,
        model_label: str,
        training_config_version: str,
        training_status: "_models.SubTrainingState",
        evaluation_status: Optional["_models.SubTrainingState"] = None,
        estimated_end_on: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrainingState(_Model):
    """Represents the state of a training job.

    :ivar job_id: The job ID. Required.
    :vartype job_id: str
    :ivar created_on: The creation date time of the job. Required.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The last date time the job was updated. Required.
    :vartype last_updated_on: ~datetime.datetime
    :ivar expires_on: The expiration date time of the job.
    :vartype expires_on: ~datetime.datetime
    :ivar status: The job status. Required. Known values are: "notStarted", "running", "succeeded",
     "failed", "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.authoring.models.OperationStatus
    :ivar warnings: The warnings that were encountered while executing the job.
    :vartype warnings: list[~azure.core.ODataV4Format]
    :ivar errors: The errors encountered while executing the job.
    :vartype errors: list[~azure.core.ODataV4Format]
    :ivar result: Represents training tasks detailed result. Required.
    :vartype result: ~azure.ai.textanalytics.authoring.models.TrainingJobResult
    """

    job_id: str = rest_field(name="jobId", visibility=["read"])
    """The job ID. Required."""
    created_on: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The creation date time of the job. Required."""
    last_updated_on: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last date time the job was updated. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The expiration date time of the job."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The job status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", \"cancelled\", \"cancelling\", and \"partiallyCompleted\"."""
    warnings: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The warnings that were encountered while executing the job."""
    errors: Optional[list[ODataV4Format]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The errors encountered while executing the job."""
    result: "_models.TrainingJobResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents training tasks detailed result. Required."""

    @overload
    def __init__(
        self,
        *,
        created_on: datetime.datetime,
        last_updated_on: datetime.datetime,
        status: Union[str, "_models.OperationStatus"],
        result: "_models.TrainingJobResult",
        expires_on: Optional[datetime.datetime] = None,
        warnings: Optional[list[ODataV4Format]] = None,
        errors: Optional[list[ODataV4Format]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UnassignDeploymentResourcesDetails(_Model):
    """Represents the options to unassign Azure resources from a project.

    :ivar assigned_resource_ids: Represents the assigned resource IDs to be unassigned. Required.
    :vartype assigned_resource_ids: list[str]
    """

    assigned_resource_ids: list[str] = rest_field(
        name="assignedResourceIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the assigned resource IDs to be unassigned. Required."""

    @overload
    def __init__(
        self,
        *,
        assigned_resource_ids: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
