// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use gdk_sys;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use pango;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Justification;
use TextDirection;
use TextIter;
use WrapMode;

glib_wrapper! {
    pub struct TextTag(Object<gtk_sys::GtkTextTag, gtk_sys::GtkTextTagClass, TextTagClass>);

    match fn {
        get_type => || gtk_sys::gtk_text_tag_get_type(),
    }
}

impl TextTag {
    pub fn new(name: Option<&str>) -> TextTag {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(gtk_sys::gtk_text_tag_new(name.to_glib_none().0)) }
    }
}

#[derive(Clone, Default)]
pub struct TextTagBuilder {
    accumulative_margin: Option<bool>,
    background: Option<String>,
    background_full_height: Option<bool>,
    background_full_height_set: Option<bool>,
    background_rgba: Option<gdk::RGBA>,
    background_set: Option<bool>,
    direction: Option<TextDirection>,
    editable: Option<bool>,
    editable_set: Option<bool>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fallback: Option<bool>,
    fallback_set: Option<bool>,
    family: Option<String>,
    family_set: Option<bool>,
    font: Option<String>,
    font_desc: Option<pango::FontDescription>,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    font_features: Option<String>,
    font_features_set: Option<bool>,
    foreground: Option<String>,
    foreground_rgba: Option<gdk::RGBA>,
    foreground_set: Option<bool>,
    indent: Option<i32>,
    indent_set: Option<bool>,
    invisible: Option<bool>,
    invisible_set: Option<bool>,
    justification: Option<Justification>,
    justification_set: Option<bool>,
    language: Option<String>,
    language_set: Option<bool>,
    left_margin: Option<i32>,
    left_margin_set: Option<bool>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    letter_spacing: Option<i32>,
    letter_spacing_set: Option<bool>,
    name: Option<String>,
    paragraph_background: Option<String>,
    paragraph_background_rgba: Option<gdk::RGBA>,
    paragraph_background_set: Option<bool>,
    pixels_above_lines: Option<i32>,
    pixels_above_lines_set: Option<bool>,
    pixels_below_lines: Option<i32>,
    pixels_below_lines_set: Option<bool>,
    pixels_inside_wrap: Option<i32>,
    pixels_inside_wrap_set: Option<bool>,
    right_margin: Option<i32>,
    right_margin_set: Option<bool>,
    rise: Option<i32>,
    rise_set: Option<bool>,
    scale: Option<f64>,
    scale_set: Option<bool>,
    size: Option<i32>,
    size_points: Option<f64>,
    size_set: Option<bool>,
    stretch: Option<pango::Stretch>,
    stretch_set: Option<bool>,
    strikethrough: Option<bool>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    strikethrough_rgba: Option<gdk::RGBA>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    strikethrough_rgba_set: Option<bool>,
    strikethrough_set: Option<bool>,
    style: Option<pango::Style>,
    style_set: Option<bool>,
    tabs: Option<pango::TabArray>,
    tabs_set: Option<bool>,
    underline: Option<pango::Underline>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    underline_rgba: Option<gdk::RGBA>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    underline_rgba_set: Option<bool>,
    underline_set: Option<bool>,
    variant: Option<pango::Variant>,
    variant_set: Option<bool>,
    weight: Option<i32>,
    weight_set: Option<bool>,
    wrap_mode: Option<WrapMode>,
    wrap_mode_set: Option<bool>,
}

impl TextTagBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> TextTag {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref accumulative_margin) = self.accumulative_margin {
            properties.push(("accumulative-margin", accumulative_margin));
        }
        if let Some(ref background) = self.background {
            properties.push(("background", background));
        }
        if let Some(ref background_full_height) = self.background_full_height {
            properties.push(("background-full-height", background_full_height));
        }
        if let Some(ref background_full_height_set) = self.background_full_height_set {
            properties.push(("background-full-height-set", background_full_height_set));
        }
        if let Some(ref background_rgba) = self.background_rgba {
            properties.push(("background-rgba", background_rgba));
        }
        if let Some(ref background_set) = self.background_set {
            properties.push(("background-set", background_set));
        }
        if let Some(ref direction) = self.direction {
            properties.push(("direction", direction));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref editable_set) = self.editable_set {
            properties.push(("editable-set", editable_set));
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref fallback) = self.fallback {
                properties.push(("fallback", fallback));
            }
        }
        if let Some(ref fallback_set) = self.fallback_set {
            properties.push(("fallback-set", fallback_set));
        }
        if let Some(ref family) = self.family {
            properties.push(("family", family));
        }
        if let Some(ref family_set) = self.family_set {
            properties.push(("family-set", family_set));
        }
        if let Some(ref font) = self.font {
            properties.push(("font", font));
        }
        if let Some(ref font_desc) = self.font_desc {
            properties.push(("font-desc", font_desc));
        }
        #[cfg(any(feature = "v3_18", feature = "dox"))]
        {
            if let Some(ref font_features) = self.font_features {
                properties.push(("font-features", font_features));
            }
        }
        if let Some(ref font_features_set) = self.font_features_set {
            properties.push(("font-features-set", font_features_set));
        }
        if let Some(ref foreground) = self.foreground {
            properties.push(("foreground", foreground));
        }
        if let Some(ref foreground_rgba) = self.foreground_rgba {
            properties.push(("foreground-rgba", foreground_rgba));
        }
        if let Some(ref foreground_set) = self.foreground_set {
            properties.push(("foreground-set", foreground_set));
        }
        if let Some(ref indent) = self.indent {
            properties.push(("indent", indent));
        }
        if let Some(ref indent_set) = self.indent_set {
            properties.push(("indent-set", indent_set));
        }
        if let Some(ref invisible) = self.invisible {
            properties.push(("invisible", invisible));
        }
        if let Some(ref invisible_set) = self.invisible_set {
            properties.push(("invisible-set", invisible_set));
        }
        if let Some(ref justification) = self.justification {
            properties.push(("justification", justification));
        }
        if let Some(ref justification_set) = self.justification_set {
            properties.push(("justification-set", justification_set));
        }
        if let Some(ref language) = self.language {
            properties.push(("language", language));
        }
        if let Some(ref language_set) = self.language_set {
            properties.push(("language-set", language_set));
        }
        if let Some(ref left_margin) = self.left_margin {
            properties.push(("left-margin", left_margin));
        }
        if let Some(ref left_margin_set) = self.left_margin_set {
            properties.push(("left-margin-set", left_margin_set));
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref letter_spacing) = self.letter_spacing {
                properties.push(("letter-spacing", letter_spacing));
            }
        }
        if let Some(ref letter_spacing_set) = self.letter_spacing_set {
            properties.push(("letter-spacing-set", letter_spacing_set));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref paragraph_background) = self.paragraph_background {
            properties.push(("paragraph-background", paragraph_background));
        }
        if let Some(ref paragraph_background_rgba) = self.paragraph_background_rgba {
            properties.push(("paragraph-background-rgba", paragraph_background_rgba));
        }
        if let Some(ref paragraph_background_set) = self.paragraph_background_set {
            properties.push(("paragraph-background-set", paragraph_background_set));
        }
        if let Some(ref pixels_above_lines) = self.pixels_above_lines {
            properties.push(("pixels-above-lines", pixels_above_lines));
        }
        if let Some(ref pixels_above_lines_set) = self.pixels_above_lines_set {
            properties.push(("pixels-above-lines-set", pixels_above_lines_set));
        }
        if let Some(ref pixels_below_lines) = self.pixels_below_lines {
            properties.push(("pixels-below-lines", pixels_below_lines));
        }
        if let Some(ref pixels_below_lines_set) = self.pixels_below_lines_set {
            properties.push(("pixels-below-lines-set", pixels_below_lines_set));
        }
        if let Some(ref pixels_inside_wrap) = self.pixels_inside_wrap {
            properties.push(("pixels-inside-wrap", pixels_inside_wrap));
        }
        if let Some(ref pixels_inside_wrap_set) = self.pixels_inside_wrap_set {
            properties.push(("pixels-inside-wrap-set", pixels_inside_wrap_set));
        }
        if let Some(ref right_margin) = self.right_margin {
            properties.push(("right-margin", right_margin));
        }
        if let Some(ref right_margin_set) = self.right_margin_set {
            properties.push(("right-margin-set", right_margin_set));
        }
        if let Some(ref rise) = self.rise {
            properties.push(("rise", rise));
        }
        if let Some(ref rise_set) = self.rise_set {
            properties.push(("rise-set", rise_set));
        }
        if let Some(ref scale) = self.scale {
            properties.push(("scale", scale));
        }
        if let Some(ref scale_set) = self.scale_set {
            properties.push(("scale-set", scale_set));
        }
        if let Some(ref size) = self.size {
            properties.push(("size", size));
        }
        if let Some(ref size_points) = self.size_points {
            properties.push(("size-points", size_points));
        }
        if let Some(ref size_set) = self.size_set {
            properties.push(("size-set", size_set));
        }
        if let Some(ref stretch) = self.stretch {
            properties.push(("stretch", stretch));
        }
        if let Some(ref stretch_set) = self.stretch_set {
            properties.push(("stretch-set", stretch_set));
        }
        if let Some(ref strikethrough) = self.strikethrough {
            properties.push(("strikethrough", strikethrough));
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref strikethrough_rgba) = self.strikethrough_rgba {
                properties.push(("strikethrough-rgba", strikethrough_rgba));
            }
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref strikethrough_rgba_set) = self.strikethrough_rgba_set {
                properties.push(("strikethrough-rgba-set", strikethrough_rgba_set));
            }
        }
        if let Some(ref strikethrough_set) = self.strikethrough_set {
            properties.push(("strikethrough-set", strikethrough_set));
        }
        if let Some(ref style) = self.style {
            properties.push(("style", style));
        }
        if let Some(ref style_set) = self.style_set {
            properties.push(("style-set", style_set));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref tabs_set) = self.tabs_set {
            properties.push(("tabs-set", tabs_set));
        }
        if let Some(ref underline) = self.underline {
            properties.push(("underline", underline));
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref underline_rgba) = self.underline_rgba {
                properties.push(("underline-rgba", underline_rgba));
            }
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref underline_rgba_set) = self.underline_rgba_set {
                properties.push(("underline-rgba-set", underline_rgba_set));
            }
        }
        if let Some(ref underline_set) = self.underline_set {
            properties.push(("underline-set", underline_set));
        }
        if let Some(ref variant) = self.variant {
            properties.push(("variant", variant));
        }
        if let Some(ref variant_set) = self.variant_set {
            properties.push(("variant-set", variant_set));
        }
        if let Some(ref weight) = self.weight {
            properties.push(("weight", weight));
        }
        if let Some(ref weight_set) = self.weight_set {
            properties.push(("weight-set", weight_set));
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref wrap_mode_set) = self.wrap_mode_set {
            properties.push(("wrap-mode-set", wrap_mode_set));
        }
        let ret = glib::Object::new(TextTag::static_type(), &properties)
            .expect("object new")
            .downcast::<TextTag>()
            .expect("downcast");
        ret
    }

    pub fn accumulative_margin(mut self, accumulative_margin: bool) -> Self {
        self.accumulative_margin = Some(accumulative_margin);
        self
    }

    pub fn background(mut self, background: &str) -> Self {
        self.background = Some(background.to_string());
        self
    }

    pub fn background_full_height(mut self, background_full_height: bool) -> Self {
        self.background_full_height = Some(background_full_height);
        self
    }

    pub fn background_full_height_set(mut self, background_full_height_set: bool) -> Self {
        self.background_full_height_set = Some(background_full_height_set);
        self
    }

    pub fn background_rgba(mut self, background_rgba: &gdk::RGBA) -> Self {
        self.background_rgba = Some(background_rgba.clone());
        self
    }

    pub fn background_set(mut self, background_set: bool) -> Self {
        self.background_set = Some(background_set);
        self
    }

    pub fn direction(mut self, direction: TextDirection) -> Self {
        self.direction = Some(direction);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn editable_set(mut self, editable_set: bool) -> Self {
        self.editable_set = Some(editable_set);
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn fallback(mut self, fallback: bool) -> Self {
        self.fallback = Some(fallback);
        self
    }

    pub fn fallback_set(mut self, fallback_set: bool) -> Self {
        self.fallback_set = Some(fallback_set);
        self
    }

    pub fn family(mut self, family: &str) -> Self {
        self.family = Some(family.to_string());
        self
    }

    pub fn family_set(mut self, family_set: bool) -> Self {
        self.family_set = Some(family_set);
        self
    }

    pub fn font(mut self, font: &str) -> Self {
        self.font = Some(font.to_string());
        self
    }

    pub fn font_desc(mut self, font_desc: &pango::FontDescription) -> Self {
        self.font_desc = Some(font_desc.clone());
        self
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    pub fn font_features(mut self, font_features: &str) -> Self {
        self.font_features = Some(font_features.to_string());
        self
    }

    pub fn font_features_set(mut self, font_features_set: bool) -> Self {
        self.font_features_set = Some(font_features_set);
        self
    }

    pub fn foreground(mut self, foreground: &str) -> Self {
        self.foreground = Some(foreground.to_string());
        self
    }

    pub fn foreground_rgba(mut self, foreground_rgba: &gdk::RGBA) -> Self {
        self.foreground_rgba = Some(foreground_rgba.clone());
        self
    }

    pub fn foreground_set(mut self, foreground_set: bool) -> Self {
        self.foreground_set = Some(foreground_set);
        self
    }

    pub fn indent(mut self, indent: i32) -> Self {
        self.indent = Some(indent);
        self
    }

    pub fn indent_set(mut self, indent_set: bool) -> Self {
        self.indent_set = Some(indent_set);
        self
    }

    pub fn invisible(mut self, invisible: bool) -> Self {
        self.invisible = Some(invisible);
        self
    }

    pub fn invisible_set(mut self, invisible_set: bool) -> Self {
        self.invisible_set = Some(invisible_set);
        self
    }

    pub fn justification(mut self, justification: Justification) -> Self {
        self.justification = Some(justification);
        self
    }

    pub fn justification_set(mut self, justification_set: bool) -> Self {
        self.justification_set = Some(justification_set);
        self
    }

    pub fn language(mut self, language: &str) -> Self {
        self.language = Some(language.to_string());
        self
    }

    pub fn language_set(mut self, language_set: bool) -> Self {
        self.language_set = Some(language_set);
        self
    }

    pub fn left_margin(mut self, left_margin: i32) -> Self {
        self.left_margin = Some(left_margin);
        self
    }

    pub fn left_margin_set(mut self, left_margin_set: bool) -> Self {
        self.left_margin_set = Some(left_margin_set);
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn letter_spacing(mut self, letter_spacing: i32) -> Self {
        self.letter_spacing = Some(letter_spacing);
        self
    }

    pub fn letter_spacing_set(mut self, letter_spacing_set: bool) -> Self {
        self.letter_spacing_set = Some(letter_spacing_set);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn paragraph_background(mut self, paragraph_background: &str) -> Self {
        self.paragraph_background = Some(paragraph_background.to_string());
        self
    }

    pub fn paragraph_background_rgba(mut self, paragraph_background_rgba: &gdk::RGBA) -> Self {
        self.paragraph_background_rgba = Some(paragraph_background_rgba.clone());
        self
    }

    pub fn paragraph_background_set(mut self, paragraph_background_set: bool) -> Self {
        self.paragraph_background_set = Some(paragraph_background_set);
        self
    }

    pub fn pixels_above_lines(mut self, pixels_above_lines: i32) -> Self {
        self.pixels_above_lines = Some(pixels_above_lines);
        self
    }

    pub fn pixels_above_lines_set(mut self, pixels_above_lines_set: bool) -> Self {
        self.pixels_above_lines_set = Some(pixels_above_lines_set);
        self
    }

    pub fn pixels_below_lines(mut self, pixels_below_lines: i32) -> Self {
        self.pixels_below_lines = Some(pixels_below_lines);
        self
    }

    pub fn pixels_below_lines_set(mut self, pixels_below_lines_set: bool) -> Self {
        self.pixels_below_lines_set = Some(pixels_below_lines_set);
        self
    }

    pub fn pixels_inside_wrap(mut self, pixels_inside_wrap: i32) -> Self {
        self.pixels_inside_wrap = Some(pixels_inside_wrap);
        self
    }

    pub fn pixels_inside_wrap_set(mut self, pixels_inside_wrap_set: bool) -> Self {
        self.pixels_inside_wrap_set = Some(pixels_inside_wrap_set);
        self
    }

    pub fn right_margin(mut self, right_margin: i32) -> Self {
        self.right_margin = Some(right_margin);
        self
    }

    pub fn right_margin_set(mut self, right_margin_set: bool) -> Self {
        self.right_margin_set = Some(right_margin_set);
        self
    }

    pub fn rise(mut self, rise: i32) -> Self {
        self.rise = Some(rise);
        self
    }

    pub fn rise_set(mut self, rise_set: bool) -> Self {
        self.rise_set = Some(rise_set);
        self
    }

    pub fn scale(mut self, scale: f64) -> Self {
        self.scale = Some(scale);
        self
    }

    pub fn scale_set(mut self, scale_set: bool) -> Self {
        self.scale_set = Some(scale_set);
        self
    }

    pub fn size(mut self, size: i32) -> Self {
        self.size = Some(size);
        self
    }

    pub fn size_points(mut self, size_points: f64) -> Self {
        self.size_points = Some(size_points);
        self
    }

    pub fn size_set(mut self, size_set: bool) -> Self {
        self.size_set = Some(size_set);
        self
    }

    pub fn stretch(mut self, stretch: pango::Stretch) -> Self {
        self.stretch = Some(stretch);
        self
    }

    pub fn stretch_set(mut self, stretch_set: bool) -> Self {
        self.stretch_set = Some(stretch_set);
        self
    }

    pub fn strikethrough(mut self, strikethrough: bool) -> Self {
        self.strikethrough = Some(strikethrough);
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn strikethrough_rgba(mut self, strikethrough_rgba: &gdk::RGBA) -> Self {
        self.strikethrough_rgba = Some(strikethrough_rgba.clone());
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn strikethrough_rgba_set(mut self, strikethrough_rgba_set: bool) -> Self {
        self.strikethrough_rgba_set = Some(strikethrough_rgba_set);
        self
    }

    pub fn strikethrough_set(mut self, strikethrough_set: bool) -> Self {
        self.strikethrough_set = Some(strikethrough_set);
        self
    }

    pub fn style(mut self, style: pango::Style) -> Self {
        self.style = Some(style);
        self
    }

    pub fn style_set(mut self, style_set: bool) -> Self {
        self.style_set = Some(style_set);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn tabs_set(mut self, tabs_set: bool) -> Self {
        self.tabs_set = Some(tabs_set);
        self
    }

    pub fn underline(mut self, underline: pango::Underline) -> Self {
        self.underline = Some(underline);
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn underline_rgba(mut self, underline_rgba: &gdk::RGBA) -> Self {
        self.underline_rgba = Some(underline_rgba.clone());
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn underline_rgba_set(mut self, underline_rgba_set: bool) -> Self {
        self.underline_rgba_set = Some(underline_rgba_set);
        self
    }

    pub fn underline_set(mut self, underline_set: bool) -> Self {
        self.underline_set = Some(underline_set);
        self
    }

    pub fn variant(mut self, variant: pango::Variant) -> Self {
        self.variant = Some(variant);
        self
    }

    pub fn variant_set(mut self, variant_set: bool) -> Self {
        self.variant_set = Some(variant_set);
        self
    }

    pub fn weight(mut self, weight: i32) -> Self {
        self.weight = Some(weight);
        self
    }

    pub fn weight_set(mut self, weight_set: bool) -> Self {
        self.weight_set = Some(weight_set);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn wrap_mode_set(mut self, wrap_mode_set: bool) -> Self {
        self.wrap_mode_set = Some(wrap_mode_set);
        self
    }
}

pub const NONE_TEXT_TAG: Option<&TextTag> = None;

pub trait TextTagExt: 'static {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn changed(&self, size_changed: bool);

    fn event<P: IsA<glib::Object>>(
        &self,
        event_object: &P,
        event: &gdk::Event,
        iter: &TextIter,
    ) -> bool;

    fn get_priority(&self) -> i32;

    fn set_priority(&self, priority: i32);

    fn get_property_accumulative_margin(&self) -> bool;

    fn set_property_accumulative_margin(&self, accumulative_margin: bool);

    fn set_property_background(&self, background: Option<&str>);

    fn get_property_background_full_height(&self) -> bool;

    fn set_property_background_full_height(&self, background_full_height: bool);

    fn get_property_background_full_height_set(&self) -> bool;

    fn set_property_background_full_height_set(&self, background_full_height_set: bool);

    fn get_property_background_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    fn get_property_background_set(&self) -> bool;

    fn set_property_background_set(&self, background_set: bool);

    fn get_property_direction(&self) -> TextDirection;

    fn set_property_direction(&self, direction: TextDirection);

    fn get_property_editable(&self) -> bool;

    fn set_property_editable(&self, editable: bool);

    fn get_property_editable_set(&self) -> bool;

    fn set_property_editable_set(&self, editable_set: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_fallback(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_fallback(&self, fallback: bool);

    fn get_property_fallback_set(&self) -> bool;

    fn set_property_fallback_set(&self, fallback_set: bool);

    fn get_property_family(&self) -> Option<GString>;

    fn set_property_family(&self, family: Option<&str>);

    fn get_property_family_set(&self) -> bool;

    fn set_property_family_set(&self, family_set: bool);

    fn get_property_font(&self) -> Option<GString>;

    fn set_property_font(&self, font: Option<&str>);

    fn get_property_font_desc(&self) -> Option<pango::FontDescription>;

    fn set_property_font_desc(&self, font_desc: Option<&pango::FontDescription>);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_property_font_features(&self) -> Option<GString>;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_property_font_features(&self, font_features: Option<&str>);

    fn get_property_font_features_set(&self) -> bool;

    fn set_property_font_features_set(&self, font_features_set: bool);

    fn set_property_foreground(&self, foreground: Option<&str>);

    fn get_property_foreground_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    fn get_property_foreground_set(&self) -> bool;

    fn set_property_foreground_set(&self, foreground_set: bool);

    fn get_property_indent(&self) -> i32;

    fn set_property_indent(&self, indent: i32);

    fn get_property_indent_set(&self) -> bool;

    fn set_property_indent_set(&self, indent_set: bool);

    fn get_property_invisible(&self) -> bool;

    fn set_property_invisible(&self, invisible: bool);

    fn get_property_invisible_set(&self) -> bool;

    fn set_property_invisible_set(&self, invisible_set: bool);

    fn get_property_justification(&self) -> Justification;

    fn set_property_justification(&self, justification: Justification);

    fn get_property_justification_set(&self) -> bool;

    fn set_property_justification_set(&self, justification_set: bool);

    fn get_property_language(&self) -> Option<GString>;

    fn set_property_language(&self, language: Option<&str>);

    fn get_property_language_set(&self) -> bool;

    fn set_property_language_set(&self, language_set: bool);

    fn get_property_left_margin(&self) -> i32;

    fn set_property_left_margin(&self, left_margin: i32);

    fn get_property_left_margin_set(&self) -> bool;

    fn set_property_left_margin_set(&self, left_margin_set: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_letter_spacing(&self) -> i32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_letter_spacing(&self, letter_spacing: i32);

    fn get_property_letter_spacing_set(&self) -> bool;

    fn set_property_letter_spacing_set(&self, letter_spacing_set: bool);

    fn get_property_name(&self) -> Option<GString>;

    fn set_property_paragraph_background(&self, paragraph_background: Option<&str>);

    fn get_property_paragraph_background_rgba(&self) -> Option<gdk::RGBA>;

    fn set_property_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>);

    fn get_property_paragraph_background_set(&self) -> bool;

    fn set_property_paragraph_background_set(&self, paragraph_background_set: bool);

    fn get_property_pixels_above_lines(&self) -> i32;

    fn set_property_pixels_above_lines(&self, pixels_above_lines: i32);

    fn get_property_pixels_above_lines_set(&self) -> bool;

    fn set_property_pixels_above_lines_set(&self, pixels_above_lines_set: bool);

    fn get_property_pixels_below_lines(&self) -> i32;

    fn set_property_pixels_below_lines(&self, pixels_below_lines: i32);

    fn get_property_pixels_below_lines_set(&self) -> bool;

    fn set_property_pixels_below_lines_set(&self, pixels_below_lines_set: bool);

    fn get_property_pixels_inside_wrap(&self) -> i32;

    fn set_property_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    fn get_property_pixels_inside_wrap_set(&self) -> bool;

    fn set_property_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool);

    fn get_property_right_margin(&self) -> i32;

    fn set_property_right_margin(&self, right_margin: i32);

    fn get_property_right_margin_set(&self) -> bool;

    fn set_property_right_margin_set(&self, right_margin_set: bool);

    fn get_property_rise(&self) -> i32;

    fn set_property_rise(&self, rise: i32);

    fn get_property_rise_set(&self) -> bool;

    fn set_property_rise_set(&self, rise_set: bool);

    fn get_property_scale(&self) -> f64;

    fn set_property_scale(&self, scale: f64);

    fn get_property_scale_set(&self) -> bool;

    fn set_property_scale_set(&self, scale_set: bool);

    fn get_property_size(&self) -> i32;

    fn set_property_size(&self, size: i32);

    fn get_property_size_points(&self) -> f64;

    fn set_property_size_points(&self, size_points: f64);

    fn get_property_size_set(&self) -> bool;

    fn set_property_size_set(&self, size_set: bool);

    fn get_property_stretch(&self) -> pango::Stretch;

    fn set_property_stretch(&self, stretch: pango::Stretch);

    fn get_property_stretch_set(&self) -> bool;

    fn set_property_stretch_set(&self, stretch_set: bool);

    fn get_property_strikethrough(&self) -> bool;

    fn set_property_strikethrough(&self, strikethrough: bool);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba(&self) -> Option<gdk::RGBA>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba_set(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool);

    fn get_property_strikethrough_set(&self) -> bool;

    fn set_property_strikethrough_set(&self, strikethrough_set: bool);

    fn get_property_style(&self) -> pango::Style;

    fn set_property_style(&self, style: pango::Style);

    fn get_property_style_set(&self) -> bool;

    fn set_property_style_set(&self, style_set: bool);

    fn get_property_tabs(&self) -> Option<pango::TabArray>;

    fn set_property_tabs(&self, tabs: Option<&pango::TabArray>);

    fn get_property_tabs_set(&self) -> bool;

    fn set_property_tabs_set(&self, tabs_set: bool);

    fn get_property_underline(&self) -> pango::Underline;

    fn set_property_underline(&self, underline: pango::Underline);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba(&self) -> Option<gdk::RGBA>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba_set(&self) -> bool;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba_set(&self, underline_rgba_set: bool);

    fn get_property_underline_set(&self) -> bool;

    fn set_property_underline_set(&self, underline_set: bool);

    fn get_property_variant(&self) -> pango::Variant;

    fn set_property_variant(&self, variant: pango::Variant);

    fn get_property_variant_set(&self) -> bool;

    fn set_property_variant_set(&self, variant_set: bool);

    fn get_property_weight(&self) -> i32;

    fn set_property_weight(&self, weight: i32);

    fn get_property_weight_set(&self) -> bool;

    fn set_property_weight_set(&self, weight_set: bool);

    fn get_property_wrap_mode(&self) -> WrapMode;

    fn set_property_wrap_mode(&self, wrap_mode: WrapMode);

    fn get_property_wrap_mode_set(&self) -> bool;

    fn set_property_wrap_mode_set(&self, wrap_mode_set: bool);

    fn connect_event<
        F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_accumulative_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_font_features_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_font_features_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_foreground_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_foreground_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_invisible_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_justification_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_left_margin_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_letter_spacing_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_letter_spacing_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_paragraph_background_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_right_margin_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_strikethrough_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_strikethrough_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_underline_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<TextTag>> TextTagExt for O {
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn changed(&self, size_changed: bool) {
        unsafe {
            gtk_sys::gtk_text_tag_changed(self.as_ref().to_glib_none().0, size_changed.to_glib());
        }
    }

    fn event<P: IsA<glib::Object>>(
        &self,
        event_object: &P,
        event: &gdk::Event,
        iter: &TextIter,
    ) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_tag_event(
                self.as_ref().to_glib_none().0,
                event_object.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
                iter.to_glib_none().0,
            ))
        }
    }

    fn get_priority(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_tag_get_priority(self.as_ref().to_glib_none().0) }
    }

    fn set_priority(&self, priority: i32) {
        unsafe {
            gtk_sys::gtk_text_tag_set_priority(self.as_ref().to_glib_none().0, priority);
        }
    }

    fn get_property_accumulative_margin(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"accumulative-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `accumulative-margin` getter")
                .unwrap()
        }
    }

    fn set_property_accumulative_margin(&self, accumulative_margin: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"accumulative-margin\0".as_ptr() as *const _,
                Value::from(&accumulative_margin).to_glib_none().0,
            );
        }
    }

    fn set_property_background(&self, background: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background\0".as_ptr() as *const _,
                Value::from(background).to_glib_none().0,
            );
        }
    }

    fn get_property_background_full_height(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-full-height\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-full-height` getter")
                .unwrap()
        }
    }

    fn set_property_background_full_height(&self, background_full_height: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-full-height\0".as_ptr() as *const _,
                Value::from(&background_full_height).to_glib_none().0,
            );
        }
    }

    fn get_property_background_full_height_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-full-height-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-full-height-set` getter")
                .unwrap()
        }
    }

    fn set_property_background_full_height_set(&self, background_full_height_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-full-height-set\0".as_ptr() as *const _,
                Value::from(&background_full_height_set).to_glib_none().0,
            );
        }
    }

    fn get_property_background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-rgba` getter")
        }
    }

    fn set_property_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-rgba\0".as_ptr() as *const _,
                Value::from(background_rgba).to_glib_none().0,
            );
        }
    }

    fn get_property_background_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `background-set` getter")
                .unwrap()
        }
    }

    fn set_property_background_set(&self, background_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"background-set\0".as_ptr() as *const _,
                Value::from(&background_set).to_glib_none().0,
            );
        }
    }

    fn get_property_direction(&self) -> TextDirection {
        unsafe {
            let mut value = Value::from_type(<TextDirection as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"direction\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `direction` getter")
                .unwrap()
        }
    }

    fn set_property_direction(&self, direction: TextDirection) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"direction\0".as_ptr() as *const _,
                Value::from(&direction).to_glib_none().0,
            );
        }
    }

    fn get_property_editable(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"editable\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `editable` getter")
                .unwrap()
        }
    }

    fn set_property_editable(&self, editable: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"editable\0".as_ptr() as *const _,
                Value::from(&editable).to_glib_none().0,
            );
        }
    }

    fn get_property_editable_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"editable-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `editable-set` getter")
                .unwrap()
        }
    }

    fn set_property_editable_set(&self, editable_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"editable-set\0".as_ptr() as *const _,
                Value::from(&editable_set).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_fallback(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"fallback\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `fallback` getter")
                .unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_fallback(&self, fallback: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"fallback\0".as_ptr() as *const _,
                Value::from(&fallback).to_glib_none().0,
            );
        }
    }

    fn get_property_fallback_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"fallback-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `fallback-set` getter")
                .unwrap()
        }
    }

    fn set_property_fallback_set(&self, fallback_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"fallback-set\0".as_ptr() as *const _,
                Value::from(&fallback_set).to_glib_none().0,
            );
        }
    }

    fn get_property_family(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"family\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `family` getter")
        }
    }

    fn set_property_family(&self, family: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"family\0".as_ptr() as *const _,
                Value::from(family).to_glib_none().0,
            );
        }
    }

    fn get_property_family_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"family-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `family-set` getter")
                .unwrap()
        }
    }

    fn set_property_family_set(&self, family_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"family-set\0".as_ptr() as *const _,
                Value::from(&family_set).to_glib_none().0,
            );
        }
    }

    fn get_property_font(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font` getter")
        }
    }

    fn set_property_font(&self, font: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font\0".as_ptr() as *const _,
                Value::from(font).to_glib_none().0,
            );
        }
    }

    fn get_property_font_desc(&self) -> Option<pango::FontDescription> {
        unsafe {
            let mut value = Value::from_type(<pango::FontDescription as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-desc\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-desc` getter")
        }
    }

    fn set_property_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-desc\0".as_ptr() as *const _,
                Value::from(font_desc).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_property_font_features(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-features\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-features` getter")
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_property_font_features(&self, font_features: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-features\0".as_ptr() as *const _,
                Value::from(font_features).to_glib_none().0,
            );
        }
    }

    fn get_property_font_features_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-features-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `font-features-set` getter")
                .unwrap()
        }
    }

    fn set_property_font_features_set(&self, font_features_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"font-features-set\0".as_ptr() as *const _,
                Value::from(&font_features_set).to_glib_none().0,
            );
        }
    }

    fn set_property_foreground(&self, foreground: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"foreground\0".as_ptr() as *const _,
                Value::from(foreground).to_glib_none().0,
            );
        }
    }

    fn get_property_foreground_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"foreground-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `foreground-rgba` getter")
        }
    }

    fn set_property_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"foreground-rgba\0".as_ptr() as *const _,
                Value::from(foreground_rgba).to_glib_none().0,
            );
        }
    }

    fn get_property_foreground_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"foreground-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `foreground-set` getter")
                .unwrap()
        }
    }

    fn set_property_foreground_set(&self, foreground_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"foreground-set\0".as_ptr() as *const _,
                Value::from(&foreground_set).to_glib_none().0,
            );
        }
    }

    fn get_property_indent(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indent\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `indent` getter")
                .unwrap()
        }
    }

    fn set_property_indent(&self, indent: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indent\0".as_ptr() as *const _,
                Value::from(&indent).to_glib_none().0,
            );
        }
    }

    fn get_property_indent_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indent-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `indent-set` getter")
                .unwrap()
        }
    }

    fn set_property_indent_set(&self, indent_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"indent-set\0".as_ptr() as *const _,
                Value::from(&indent_set).to_glib_none().0,
            );
        }
    }

    fn get_property_invisible(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible` getter")
                .unwrap()
        }
    }

    fn set_property_invisible(&self, invisible: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible\0".as_ptr() as *const _,
                Value::from(&invisible).to_glib_none().0,
            );
        }
    }

    fn get_property_invisible_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `invisible-set` getter")
                .unwrap()
        }
    }

    fn set_property_invisible_set(&self, invisible_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"invisible-set\0".as_ptr() as *const _,
                Value::from(&invisible_set).to_glib_none().0,
            );
        }
    }

    fn get_property_justification(&self) -> Justification {
        unsafe {
            let mut value = Value::from_type(<Justification as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"justification\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `justification` getter")
                .unwrap()
        }
    }

    fn set_property_justification(&self, justification: Justification) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"justification\0".as_ptr() as *const _,
                Value::from(&justification).to_glib_none().0,
            );
        }
    }

    fn get_property_justification_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"justification-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `justification-set` getter")
                .unwrap()
        }
    }

    fn set_property_justification_set(&self, justification_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"justification-set\0".as_ptr() as *const _,
                Value::from(&justification_set).to_glib_none().0,
            );
        }
    }

    fn get_property_language(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"language\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `language` getter")
        }
    }

    fn set_property_language(&self, language: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"language\0".as_ptr() as *const _,
                Value::from(language).to_glib_none().0,
            );
        }
    }

    fn get_property_language_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"language-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `language-set` getter")
                .unwrap()
        }
    }

    fn set_property_language_set(&self, language_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"language-set\0".as_ptr() as *const _,
                Value::from(&language_set).to_glib_none().0,
            );
        }
    }

    fn get_property_left_margin(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"left-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `left-margin` getter")
                .unwrap()
        }
    }

    fn set_property_left_margin(&self, left_margin: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"left-margin\0".as_ptr() as *const _,
                Value::from(&left_margin).to_glib_none().0,
            );
        }
    }

    fn get_property_left_margin_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"left-margin-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `left-margin-set` getter")
                .unwrap()
        }
    }

    fn set_property_left_margin_set(&self, left_margin_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"left-margin-set\0".as_ptr() as *const _,
                Value::from(&left_margin_set).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_letter_spacing(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"letter-spacing\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `letter-spacing` getter")
                .unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_letter_spacing(&self, letter_spacing: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"letter-spacing\0".as_ptr() as *const _,
                Value::from(&letter_spacing).to_glib_none().0,
            );
        }
    }

    fn get_property_letter_spacing_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"letter-spacing-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `letter-spacing-set` getter")
                .unwrap()
        }
    }

    fn set_property_letter_spacing_set(&self, letter_spacing_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"letter-spacing-set\0".as_ptr() as *const _,
                Value::from(&letter_spacing_set).to_glib_none().0,
            );
        }
    }

    fn get_property_name(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `name` getter")
        }
    }

    fn set_property_paragraph_background(&self, paragraph_background: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"paragraph-background\0".as_ptr() as *const _,
                Value::from(paragraph_background).to_glib_none().0,
            );
        }
    }

    fn get_property_paragraph_background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"paragraph-background-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `paragraph-background-rgba` getter")
        }
    }

    fn set_property_paragraph_background_rgba(
        &self,
        paragraph_background_rgba: Option<&gdk::RGBA>,
    ) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"paragraph-background-rgba\0".as_ptr() as *const _,
                Value::from(paragraph_background_rgba).to_glib_none().0,
            );
        }
    }

    fn get_property_paragraph_background_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"paragraph-background-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `paragraph-background-set` getter")
                .unwrap()
        }
    }

    fn set_property_paragraph_background_set(&self, paragraph_background_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"paragraph-background-set\0".as_ptr() as *const _,
                Value::from(&paragraph_background_set).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_above_lines(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-above-lines\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-above-lines` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-above-lines\0".as_ptr() as *const _,
                Value::from(&pixels_above_lines).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_above_lines_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-above-lines-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-above-lines-set` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_above_lines_set(&self, pixels_above_lines_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-above-lines-set\0".as_ptr() as *const _,
                Value::from(&pixels_above_lines_set).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_below_lines(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-below-lines\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-below-lines` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-below-lines\0".as_ptr() as *const _,
                Value::from(&pixels_below_lines).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_below_lines_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-below-lines-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-below-lines-set` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_below_lines_set(&self, pixels_below_lines_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-below-lines-set\0".as_ptr() as *const _,
                Value::from(&pixels_below_lines_set).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_inside_wrap(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-inside-wrap\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-inside-wrap` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-inside-wrap\0".as_ptr() as *const _,
                Value::from(&pixels_inside_wrap).to_glib_none().0,
            );
        }
    }

    fn get_property_pixels_inside_wrap_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-inside-wrap-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `pixels-inside-wrap-set` getter")
                .unwrap()
        }
    }

    fn set_property_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"pixels-inside-wrap-set\0".as_ptr() as *const _,
                Value::from(&pixels_inside_wrap_set).to_glib_none().0,
            );
        }
    }

    fn get_property_right_margin(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"right-margin\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `right-margin` getter")
                .unwrap()
        }
    }

    fn set_property_right_margin(&self, right_margin: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"right-margin\0".as_ptr() as *const _,
                Value::from(&right_margin).to_glib_none().0,
            );
        }
    }

    fn get_property_right_margin_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"right-margin-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `right-margin-set` getter")
                .unwrap()
        }
    }

    fn set_property_right_margin_set(&self, right_margin_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"right-margin-set\0".as_ptr() as *const _,
                Value::from(&right_margin_set).to_glib_none().0,
            );
        }
    }

    fn get_property_rise(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"rise\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `rise` getter")
                .unwrap()
        }
    }

    fn set_property_rise(&self, rise: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"rise\0".as_ptr() as *const _,
                Value::from(&rise).to_glib_none().0,
            );
        }
    }

    fn get_property_rise_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"rise-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `rise-set` getter")
                .unwrap()
        }
    }

    fn set_property_rise_set(&self, rise_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"rise-set\0".as_ptr() as *const _,
                Value::from(&rise_set).to_glib_none().0,
            );
        }
    }

    fn get_property_scale(&self) -> f64 {
        unsafe {
            let mut value = Value::from_type(<f64 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"scale\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scale` getter")
                .unwrap()
        }
    }

    fn set_property_scale(&self, scale: f64) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"scale\0".as_ptr() as *const _,
                Value::from(&scale).to_glib_none().0,
            );
        }
    }

    fn get_property_scale_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"scale-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scale-set` getter")
                .unwrap()
        }
    }

    fn set_property_scale_set(&self, scale_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"scale-set\0".as_ptr() as *const _,
                Value::from(&scale_set).to_glib_none().0,
            );
        }
    }

    fn get_property_size(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size` getter")
                .unwrap()
        }
    }

    fn set_property_size(&self, size: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size\0".as_ptr() as *const _,
                Value::from(&size).to_glib_none().0,
            );
        }
    }

    fn get_property_size_points(&self) -> f64 {
        unsafe {
            let mut value = Value::from_type(<f64 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size-points\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size-points` getter")
                .unwrap()
        }
    }

    fn set_property_size_points(&self, size_points: f64) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size-points\0".as_ptr() as *const _,
                Value::from(&size_points).to_glib_none().0,
            );
        }
    }

    fn get_property_size_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `size-set` getter")
                .unwrap()
        }
    }

    fn set_property_size_set(&self, size_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"size-set\0".as_ptr() as *const _,
                Value::from(&size_set).to_glib_none().0,
            );
        }
    }

    fn get_property_stretch(&self) -> pango::Stretch {
        unsafe {
            let mut value = Value::from_type(<pango::Stretch as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"stretch\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `stretch` getter")
                .unwrap()
        }
    }

    fn set_property_stretch(&self, stretch: pango::Stretch) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"stretch\0".as_ptr() as *const _,
                Value::from(&stretch).to_glib_none().0,
            );
        }
    }

    fn get_property_stretch_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"stretch-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `stretch-set` getter")
                .unwrap()
        }
    }

    fn set_property_stretch_set(&self, stretch_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"stretch-set\0".as_ptr() as *const _,
                Value::from(&stretch_set).to_glib_none().0,
            );
        }
    }

    fn get_property_strikethrough(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough` getter")
                .unwrap()
        }
    }

    fn set_property_strikethrough(&self, strikethrough: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough\0".as_ptr() as *const _,
                Value::from(&strikethrough).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-rgba` getter")
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-rgba\0".as_ptr() as *const _,
                Value::from(strikethrough_rgba).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_strikethrough_rgba_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-rgba-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-rgba-set` getter")
                .unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-rgba-set\0".as_ptr() as *const _,
                Value::from(&strikethrough_rgba_set).to_glib_none().0,
            );
        }
    }

    fn get_property_strikethrough_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `strikethrough-set` getter")
                .unwrap()
        }
    }

    fn set_property_strikethrough_set(&self, strikethrough_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"strikethrough-set\0".as_ptr() as *const _,
                Value::from(&strikethrough_set).to_glib_none().0,
            );
        }
    }

    fn get_property_style(&self) -> pango::Style {
        unsafe {
            let mut value = Value::from_type(<pango::Style as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"style\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `style` getter")
                .unwrap()
        }
    }

    fn set_property_style(&self, style: pango::Style) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"style\0".as_ptr() as *const _,
                Value::from(&style).to_glib_none().0,
            );
        }
    }

    fn get_property_style_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"style-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `style-set` getter")
                .unwrap()
        }
    }

    fn set_property_style_set(&self, style_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"style-set\0".as_ptr() as *const _,
                Value::from(&style_set).to_glib_none().0,
            );
        }
    }

    fn get_property_tabs(&self) -> Option<pango::TabArray> {
        unsafe {
            let mut value = Value::from_type(<pango::TabArray as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"tabs\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tabs` getter")
        }
    }

    fn set_property_tabs(&self, tabs: Option<&pango::TabArray>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"tabs\0".as_ptr() as *const _,
                Value::from(tabs).to_glib_none().0,
            );
        }
    }

    fn get_property_tabs_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"tabs-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `tabs-set` getter")
                .unwrap()
        }
    }

    fn set_property_tabs_set(&self, tabs_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"tabs-set\0".as_ptr() as *const _,
                Value::from(&tabs_set).to_glib_none().0,
            );
        }
    }

    fn get_property_underline(&self) -> pango::Underline {
        unsafe {
            let mut value = Value::from_type(<pango::Underline as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline` getter")
                .unwrap()
        }
    }

    fn set_property_underline(&self, underline: pango::Underline) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline\0".as_ptr() as *const _,
                Value::from(&underline).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            let mut value = Value::from_type(<gdk::RGBA as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-rgba\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-rgba` getter")
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-rgba\0".as_ptr() as *const _,
                Value::from(underline_rgba).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_property_underline_rgba_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-rgba-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-rgba-set` getter")
                .unwrap()
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_property_underline_rgba_set(&self, underline_rgba_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-rgba-set\0".as_ptr() as *const _,
                Value::from(&underline_rgba_set).to_glib_none().0,
            );
        }
    }

    fn get_property_underline_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `underline-set` getter")
                .unwrap()
        }
    }

    fn set_property_underline_set(&self, underline_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"underline-set\0".as_ptr() as *const _,
                Value::from(&underline_set).to_glib_none().0,
            );
        }
    }

    fn get_property_variant(&self) -> pango::Variant {
        unsafe {
            let mut value = Value::from_type(<pango::Variant as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"variant\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `variant` getter")
                .unwrap()
        }
    }

    fn set_property_variant(&self, variant: pango::Variant) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"variant\0".as_ptr() as *const _,
                Value::from(&variant).to_glib_none().0,
            );
        }
    }

    fn get_property_variant_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"variant-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `variant-set` getter")
                .unwrap()
        }
    }

    fn set_property_variant_set(&self, variant_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"variant-set\0".as_ptr() as *const _,
                Value::from(&variant_set).to_glib_none().0,
            );
        }
    }

    fn get_property_weight(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"weight\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `weight` getter")
                .unwrap()
        }
    }

    fn set_property_weight(&self, weight: i32) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"weight\0".as_ptr() as *const _,
                Value::from(&weight).to_glib_none().0,
            );
        }
    }

    fn get_property_weight_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"weight-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `weight-set` getter")
                .unwrap()
        }
    }

    fn set_property_weight_set(&self, weight_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"weight-set\0".as_ptr() as *const _,
                Value::from(&weight_set).to_glib_none().0,
            );
        }
    }

    fn get_property_wrap_mode(&self) -> WrapMode {
        unsafe {
            let mut value = Value::from_type(<WrapMode as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"wrap-mode\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `wrap-mode` getter")
                .unwrap()
        }
    }

    fn set_property_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"wrap-mode\0".as_ptr() as *const _,
                Value::from(&wrap_mode).to_glib_none().0,
            );
        }
    }

    fn get_property_wrap_mode_set(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"wrap-mode-set\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `wrap-mode-set` getter")
                .unwrap()
        }
    }

    fn set_property_wrap_mode_set(&self, wrap_mode_set: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"wrap-mode-set\0".as_ptr() as *const _,
                Value::from(&wrap_mode_set).to_glib_none().0,
            );
        }
    }

    fn connect_event<
        F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn event_trampoline<
            P,
            F: Fn(&P, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut gtk_sys::GtkTextTag,
            object: *mut gobject_sys::GObject,
            event: *mut gdk_sys::GdkEvent,
            iter: *mut gtk_sys::GtkTextIter,
            f: glib_sys::gpointer,
        ) -> glib_sys::gboolean
        where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextTag::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
                &from_glib_none(event),
                &from_glib_borrow(iter),
            )
            .to_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_accumulative_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_accumulative_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accumulative-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accumulative_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_direction_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::direction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_direction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_editable_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_fallback_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_font_features_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_font_features_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_foreground_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_foreground_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_invisible_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_justification_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_language_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_left_margin_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_letter_spacing_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_letter_spacing_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_paragraph_background_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_rgba_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_right_margin_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_points_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-points\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_points_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_strikethrough_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_strikethrough_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_underline_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_underline_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_wrap_mode_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_set_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextTag,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextTag>,
        {
            let f: &F = &*(f as *const F);
            f(&TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextTag {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TextTag")
    }
}
