/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.util.Comparator;

public class PropertyComparator
implements Comparator<Property> {
    private TagPath path;
    private TagPath alternatePath = null;
    private int reversed = 1;

    public PropertyComparator(String path) {
        this(new TagPath(path));
    }

    public PropertyComparator(String path, boolean reversed) {
        this(path);
        this.reversed = reversed ? -1 : 1;
    }

    public PropertyComparator(TagPath path) {
        this.path = path;
    }

    public PropertyComparator(TagPath path, TagPath alternate) {
        this.path = path;
        this.alternatePath = alternate;
    }

    public TagPath getPath() {
        return this.path;
    }

    public TagPath getAlternatePath() {
        return this.alternatePath;
    }

    @Override
    public int compare(Property p1, Property p2) {
        Property o1 = p1;
        Property o2 = p2;
        p1 = p1.getProperty(this.path);
        p2 = p2.getProperty(this.path);
        if (this.alternatePath != null) {
            if (p1 == null) {
                p1 = o1.getProperty(this.alternatePath);
            }
            if (p2 == null) {
                p2 = o2.getProperty(this.alternatePath);
            }
        }
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null) {
            return -1 * this.reversed;
        }
        if (p2 == null) {
            return 1 * this.reversed;
        }
        return p1.compareTo(p2) * this.reversed;
    }
}

