/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import ancestris.core.TextOptions;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.FrenchRCalendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.HebrewCalendar;
import genj.gedcom.time.JulianCalendar;
import genj.util.DirectAccessTokenizer;
import genj.util.Resources;
import genj.util.WordBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class PointInTime
implements Comparable<PointInTime> {
    static final Resources resources = Resources.get(PointInTime.class);
    public static final int UNKNOWN = Integer.MAX_VALUE;
    public static final GregorianCalendar GREGORIAN = new GregorianCalendar();
    public static final JulianCalendar JULIAN = new JulianCalendar();
    public static final HebrewCalendar HEBREW = new HebrewCalendar();
    public static final FrenchRCalendar FRENCHR = new FrenchRCalendar();
    public static final Calendar[] CALENDARS = new Calendar[]{GREGORIAN, JULIAN, HEBREW, FRENCHR};
    protected Calendar calendar = GREGORIAN;
    private int day = Integer.MAX_VALUE;
    private int month = Integer.MAX_VALUE;
    private int year = Integer.MAX_VALUE;
    private int jd = Integer.MAX_VALUE;
    private static DateFormat NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();

    public PointInTime() {
    }

    public PointInTime(Calendar cal) {
        this.calendar = cal;
    }

    public PointInTime(java.util.Calendar cal) {
        this.calendar = GREGORIAN;
        this.day = cal.get(5) - 1;
        this.month = cal.get(2);
        this.year = cal.get(1);
    }

    public PointInTime(int d, int m, int y) {
        this(d, m, y, GREGORIAN);
    }

    public PointInTime(int d, int m, int y, Calendar cal) {
        this.day = d;
        this.month = m;
        this.year = y;
        this.calendar = cal;
        this.jd = Integer.MAX_VALUE;
    }

    public PointInTime(String yyyymmdd) throws GedcomException {
        if (yyyymmdd == null || yyyymmdd.length() != 8) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", yyyymmdd));
        }
        try {
            this.year = Integer.parseInt(yyyymmdd.substring(0, 4));
            this.month = Integer.parseInt(yyyymmdd.substring(4, 6)) - 1;
            this.day = Integer.parseInt(yyyymmdd.substring(6, 8)) - 1;
        }
        catch (NumberFormatException e) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", yyyymmdd));
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public static PointInTime getNow() {
        java.util.Calendar now = java.util.Calendar.getInstance();
        return new PointInTime(now.get(5) - 1, now.get(2), now.get(1));
    }

    public static PointInTime getPointInTime(String string) {
        PointInTime result = new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, GREGORIAN);
        result.set(string);
        return result;
    }

    public static PointInTime getPointInTime(long millis) {
        long julian = 2440588L + millis / 24L / 60L / 60L / 1000L;
        return GREGORIAN.toPointInTime((int)julian);
    }

    public long getTimeMillis() throws GedcomException {
        return ((long)this.getJulianDay() - 2440588L) * 24L * 60L * 60L * 1000L;
    }

    public PointInTime getPointInTime(Calendar cal) throws GedcomException {
        if (this.calendar == cal) {
            return this;
        }
        PointInTime result = new PointInTime();
        result.set(this);
        result.set(cal);
        return result;
    }

    public int getJulianDay() throws GedcomException {
        if (this.jd == Integer.MAX_VALUE) {
            this.jd = this.calendar.toJulianDay(this);
        }
        return this.jd;
    }

    public void reset() {
        this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public String getDayOfWeek(boolean localize) throws GedcomException {
        return this.calendar.getDayOfWeek(this, localize);
    }

    public PointInTime add(int d, int m, int y) {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(5, this.day != Integer.MAX_VALUE ? this.day + 1 : 1);
        c.set(2, this.month != Integer.MAX_VALUE ? this.month : 0);
        c.set(1, this.year != Integer.MAX_VALUE ? this.year : 0);
        c.add(5, d);
        c.add(2, m);
        c.add(1, y);
        this.set(c.get(5) - 1, c.get(2), c.get(1));
        return this;
    }

    public PointInTime after() {
        if (this.day != Integer.MAX_VALUE) {
            return this.add(1, 0, 0);
        }
        if (this.month != Integer.MAX_VALUE) {
            return this.add(0, 1, 0);
        }
        return this.add(0, 0, 1);
    }

    public PointInTime before() {
        return this.add(-1, 0, 0);
    }

    public void set(Calendar cal) throws GedcomException {
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            this.calendar = cal;
            return;
        }
        if (!this.isValid()) {
            throw new GedcomException(resources.getString("pit.invalid"));
        }
        this.set(this.convertIncomplete(cal));
    }

    public PointInTime convertIncomplete(Calendar cal) throws GedcomException {
        if (this.day == Integer.MAX_VALUE) {
            if (this.month == Integer.MAX_VALUE) {
                PointInTime pt = cal.months.length > 6 && this.calendar.months.length > 6 ? new PointInTime(0, 6, this.year, this.calendar) : new PointInTime(0, 0, this.year, this.calendar);
                pt.set(cal);
                return new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, pt.getYear(), cal);
            }
            PointInTime pt = new PointInTime(0, this.month, this.year, this.calendar);
            pt.set(cal);
            return new PointInTime(Integer.MAX_VALUE, pt.getMonth(), pt.getYear(), cal);
        }
        return cal.toPointInTime(this.getJulianDay());
    }

    public void set(int d, int m, int y) {
        this.set(d, m, y, this.calendar);
    }

    public void set(int d, int m, int y, Calendar cal) {
        this.day = d;
        this.month = m;
        this.year = y;
        this.calendar = cal;
        this.jd = Integer.MAX_VALUE;
    }

    public void set(PointInTime other) {
        this.calendar = other.calendar;
        this.set(other.getDay(), other.getMonth(), other.getYear());
    }

    public boolean set(String txt) {
        String second;
        txt = txt.trim();
        this.calendar = GREGORIAN;
        if (txt.startsWith("@#")) {
            int i = txt.indexOf("@", 1);
            if (i < 0) {
                return false;
            }
            String esc = txt.substring(0, i + 1);
            txt = txt.substring(i + 1).trim();
            for (Calendar cal : CALENDARS) {
                if (!cal.escape.equalsIgnoreCase(esc)) continue;
                this.calendar = cal;
                break;
            }
        }
        DirectAccessTokenizer tokens = new DirectAccessTokenizer(txt, " ", true);
        String first = tokens.get(0);
        for (Calendar cal : CALENDARS) {
            if (!cal.escape7.equalsIgnoreCase(first)) continue;
            this.calendar = cal;
            txt = tokens.getSubstringFrom(1);
            break;
        }
        boolean bc = false;
        if (this.calendar == GREGORIAN && txt.endsWith("B.C.")) {
            bc = true;
            txt = txt.substring(0, txt.length() - "B.C.".length()).trim();
        }
        if ((first = (tokens = new DirectAccessTokenizer(txt, " ", true)).get(0)) == null || first.isBlank()) {
            this.reset();
            return true;
        }
        int cont = 1;
        if ((second = tokens.get(cont++)) == null) {
            try {
                this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.addc(this.calendar.getYear(first), bc));
            }
            catch (Throwable t) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE;
        }
        String third = tokens.get(cont);
        if (third == null) {
            try {
                if (this.calendar == FRENCHR) {
                    this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.calendar.getYear(first + " " + second));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.set(Integer.MAX_VALUE, this.calendar.parseMonth(first), this.addc(this.calendar.getYear(second), bc));
            }
            catch (Throwable t) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE;
        }
        third = tokens.getSubstringFrom(cont);
        try {
            this.set(Integer.parseInt(first) - 1, this.calendar.parseMonth(second), this.addc(this.calendar.getYear(third), bc));
        }
        catch (Throwable t) {
            return false;
        }
        return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE && this.getDay() != Integer.MAX_VALUE;
    }

    private int addc(int year, boolean bc) {
        if (!bc) {
            return year;
        }
        if (year == 0) {
            throw new IllegalArgumentException("no year 0 allowed");
        }
        return 0 - year;
    }

    public boolean isGregorian() {
        return this.getCalendar() == GREGORIAN;
    }

    public boolean isComplete() {
        return this.year != Integer.MAX_VALUE && this.month != Integer.MAX_VALUE && this.day != Integer.MAX_VALUE;
    }

    public boolean isYearOnly() {
        return this.year != Integer.MAX_VALUE && (this.month == Integer.MAX_VALUE || this.day == Integer.MAX_VALUE);
    }

    public boolean isEmpty() {
        return this.year == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.day == Integer.MAX_VALUE;
    }

    public boolean isValid() {
        if (this.jd != Integer.MAX_VALUE) {
            return true;
        }
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            return false;
        }
        try {
            this.jd = this.calendar.toJulianDay(this);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        return this.jd != Integer.MAX_VALUE;
    }

    @Override
    public int compareTo(PointInTime other) {
        boolean v2;
        boolean v1 = this.isValid();
        boolean bl = v2 = other != null && other.isValid();
        if (!v1 && !v2) {
            return 0;
        }
        if (!v2) {
            return 1;
        }
        if (!v1) {
            return -1;
        }
        try {
            return this.getJulianDay() - other.getJulianDay();
        }
        catch (GedcomException e) {
            return 0;
        }
    }

    public String getValue(boolean is7) {
        return this.getValue(new WordBuffer(), is7).toString();
    }

    public WordBuffer getValue(WordBuffer buffer, boolean is7) {
        if (this.calendar != GREGORIAN) {
            if (is7) {
                buffer.append(this.calendar.escape7);
            } else {
                buffer.append(this.calendar.escape);
            }
        }
        this.toString(buffer, GedcomOptions.GedcomDateFormat.GEDCOM, null);
        return buffer;
    }

    public PointInTime clone() {
        return new PointInTime(this.day, this.month, this.year, this.calendar);
    }

    public String toString() {
        return this.toString(new WordBuffer()).toString();
    }

    public String toReportString() {
        return this.toString(new WordBuffer(), GedcomOptions.getInstance().getDateFormat(), TextOptions.getInstance().getOutputLocale()).toString();
    }

    public WordBuffer toString(WordBuffer buffer) {
        return this.toString(buffer, GedcomOptions.getInstance().getDateFormat(), null);
    }

    private static DateFormat initNumericDateFormat() {
        DateFormat result = DateFormat.getDateInstance(3);
        try {
            String pattern = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
            int yyyy = pattern.indexOf("yyyy");
            if (yyyy < 0) {
                result = new SimpleDateFormat(pattern.replaceAll("yy", "yyyy"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static void localeChangedNotify() {
        NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();
    }

    public WordBuffer toString(WordBuffer buffer, GedcomOptions.GedcomDateFormat format) {
        return this.toString(buffer, format, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordBuffer toString(WordBuffer buffer, GedcomOptions.GedcomDateFormat format, Locale locale) {
        int yearAdjusted = this.year;
        boolean bc = false;
        if (this.calendar == GREGORIAN && this.year < 0) {
            yearAdjusted = 0 - this.year;
            bc = true;
        }
        if (format == GedcomOptions.GedcomDateFormat.NUMERIC || format == GedcomOptions.GedcomDateFormat.POINT) {
            if (this.calendar == GREGORIAN && this.isComplete()) {
                java.util.Calendar c = java.util.Calendar.getInstance();
                c.set(yearAdjusted, this.month, this.day + 1);
                DateFormat dateFormat = NUMERICDATEFORMAT;
                synchronized (dateFormat) {
                    String value = NUMERICDATEFORMAT.format(c.getTime());
                    if (format == GedcomOptions.GedcomDateFormat.POINT) {
                        buffer.append(value.replace("/", "."));
                    } else {
                        buffer.append(value);
                    }
                }
                if (bc) {
                    buffer.append(" B.C.");
                }
                return buffer;
            }
            format = GedcomOptions.GedcomDateFormat.SHORT;
        }
        if (!this.isValid()) {
            if (format != GedcomOptions.GedcomDateFormat.GEDCOM) {
                buffer.append("?");
            }
            return buffer;
        }
        if (this.year != Integer.MAX_VALUE) {
            if (this.month != Integer.MAX_VALUE) {
                if (this.day != Integer.MAX_VALUE) {
                    buffer.append(this.day + 1);
                }
                String displayMonth = locale != null ? this.calendar.getDisplayMonthLocalized(this.month, format == GedcomOptions.GedcomDateFormat.SHORT, locale) : this.calendar.getDisplayMonth(this.month, format == GedcomOptions.GedcomDateFormat.SHORT);
                buffer.append(format == GedcomOptions.GedcomDateFormat.GEDCOM ? this.calendar.getMonth(this.month) : displayMonth);
            }
            buffer.append(format == GedcomOptions.GedcomDateFormat.GEDCOM ? this.calendar.getYear(yearAdjusted) : this.calendar.getDisplayYear(yearAdjusted));
            if (format != GedcomOptions.GedcomDateFormat.GEDCOM && this.calendar == JULIAN) {
                buffer.append("(j)");
            }
            if (bc) {
                buffer.append(" B.C.");
            }
        }
        return buffer;
    }

    public static int getMonth(String mmm) {
        int ret = 0;
        mmm = (String)mmm + "   ";
        mmm = ((String)mmm).substring(0, 3);
        for (Calendar cal : CALENDARS) {
            Integer m = cal.getMonth((String)mmm);
            if (m == null) continue;
            return m;
        }
        return ret;
    }
}

