/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class ImportLegacy
extends Import {
    protected static final Pattern TAG_PLAC_PATTERN = Pattern.compile("(PLAC|FORM|FONE|TYPE|ROMN|MAP|LATI|LONG|NOTE|CONC|CONT)");
    private static final String PLACE_RECORD_TAG = "_PLAC_DEFN";
    private final HashMap<String, ImportPlace> hasPlaces = new HashMap();
    private static final String EVENT_RECORD_TAG = "_EVENT_DEFN";
    private final HashMap<String, String> hashEventsToNoteID = new HashMap();
    private int eventIndex = 0;
    private static final String TODO_RECORD_TAG = "_TODO";
    private int todoIndex = 0;
    private static final String HASHTAG_TAG = "_HASHTAG";
    private static final String HASHTAG_RECORD_TAG = "_HASHTAG_DEFN";
    private int hashtagIndex = 0;
    private static final String STORY_RECORD_TAG = "_STORY";

    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importlegacy_name();
    }

    protected String getImportComment() {
        return Bundle.importlegacy_note();
    }

    protected void init() {
        super.init();
        this.invalidPaths.add("ADDR:MAP");
        this.invalidPaths.add("ADDR:MAP:LATI");
        this.invalidPaths.add("ADDR:MAP:LONG");
        this.invalidPaths.add("ADDR:OBJE");
        this.invalidPaths.add("ADDR:OBJE:FILE");
        this.invalidPaths.add("ADDR:OBJE:FORM");
        this.invalidPaths.add("FAM:_STAT:DATE");
        this.hasPlaces.clear();
        this.hashEventsToNoteID.clear();
        this.eventIndex = 0;
        this.todoIndex = 0;
    }

    protected void firstPass() {
        super.firstPass();
        if (this.input.getLevel() == 0 && this.input.getTag().equals(PLACE_RECORD_TAG)) {
            try {
                ImportPlace importPlace;
                this.input.getNextLine(false);
                String key = this.input.getValue();
                if (!this.hasPlaces.containsKey(key)) {
                    importPlace = new ImportPlace();
                    this.hasPlaces.put(key, importPlace);
                }
                importPlace = this.hasPlaces.get(key);
                importPlace.used = false;
                while (this.input.getLevel() != 0) {
                    this.input.getNextLine(true);
                    Object tag = this.input.getTag();
                    if (!((String)tag).startsWith("_") && !TAG_PLAC_PATTERN.matcher((CharSequence)tag).matches()) {
                        tag = "_" + (String)tag;
                    }
                    importPlace.addLine(this.input.getLevel() - 1, (String)tag, this.input.getValue());
                    this.input.getNextLine(false);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.unknown") + e);
                return;
            }
            return;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(EVENT_RECORD_TAG)) {
            ++this.eventIndex;
            this.hashEventsToNoteID.put(this.input.getValue(), "E" + this.eventIndex);
        }
    }

    protected boolean process() throws IOException {
        String pathAfter;
        Object xref;
        String date;
        String valueBefore;
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        if ("FAM:BLES".equalsIgnoreCase(pathBefore)) {
            int level = this.input.getLevel();
            TagPath newTagPath = new TagPath(this.input.getPath().getParent().getShortName() + ":MARR");
            String valueBefore2 = this.input.getValue();
            String xref2 = this.currentXref;
            if (this.processEventValues(newTagPath)) {
                return true;
            }
            this.output.writeLine(level, newTagPath.getLast(), valueBefore2);
            this.fixes.add(new ImportFix(xref2, "invalidTagLocation.2", pathBefore, newTagPath.getShortName(), valueBefore2, valueBefore2));
            return true;
        }
        if ("SOUR:MEDI".equalsIgnoreCase(pathBefore)) {
            String valueBefore3 = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "NOTE", valueBefore3);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.2", pathBefore, path.getParent().getShortName() + ":NOTE", valueBefore3, valueBefore3));
            return true;
        }
        if ("FAM:_MARRIED".equalsIgnoreCase(pathBefore)) {
            String valueBefore4 = this.input.getValue();
            String valueAfter = "_MARRIED " + this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "EVEN", valueAfter);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", pathBefore, path.getParent().getShortName() + ":EVEN", valueBefore4, valueAfter));
            return true;
        }
        if (STORY_RECORD_TAG.equals(this.input.getTag())) {
            String valueBefore5 = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), this.input.getXref(), "NOTE", valueBefore5);
            String pathAfter2 = this.input.getLevel() == 0 ? "NOTE" : path.getParent().getShortName() + ":NOTE";
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.01", pathBefore, pathAfter2, valueBefore5, valueBefore5));
            return true;
        }
        if ("_STORY:TITL".equalsIgnoreCase(pathBefore)) {
            String valueBefore6 = this.input.getValue();
            this.output.writeLine(1, "CONC", valueBefore6);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore6, valueBefore6));
            return true;
        }
        if ("_STORY:DATE".equalsIgnoreCase(pathBefore)) {
            String valueBefore7 = this.input.getValue();
            this.output.writeLine(1, "CONT", valueBefore7);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore7, valueBefore7));
            return true;
        }
        if ("_STORY:PLAC".equalsIgnoreCase(pathBefore)) {
            String valueBefore8 = this.input.getValue();
            this.output.writeLine(1, "CONT", valueBefore8);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore8, valueBefore8));
            return true;
        }
        if ("_STORY:TEXT".equalsIgnoreCase(pathBefore)) {
            String valueBefore9 = this.input.getValue();
            this.output.writeLine(1, "CONT", valueBefore9);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore9, valueBefore9));
            return true;
        }
        if ("_STORY:TEXT:CONC".equalsIgnoreCase(pathBefore)) {
            String valueBefore10 = this.input.getValue();
            this.output.writeLine(1, "CONC", valueBefore10);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONC", valueBefore10, valueBefore10));
            return true;
        }
        if ("_STORY:TEXT:CONT".equalsIgnoreCase(pathBefore)) {
            String valueBefore11 = this.input.getValue();
            this.output.writeLine(1, "CONT", valueBefore11);
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.02", pathBefore, "NOTE:CONT", valueBefore11, valueBefore11));
            return true;
        }
        if (super.processInvalidPath(this.input.getPath())) {
            return true;
        }
        if ("DATE".equals(this.input.getTag()) && !(valueBefore = this.input.getValue()).equals(date = valueBefore.toLowerCase().replace(".", "").replace("okt", "OCT").replace("maj", "MAY").replace("eft", "AFT").replace("omkr", "ABT").replace("omk", "ABT").replace("f\u00f8r", "BEF").replace("ansl", "EST").replace("ansl", "EST").replace("fra", "FROM").replace("til", "TO").replace("mel", "BET").replace("og", "AND").toUpperCase()) && this.processInvalidDates(date, "invalidDate.2")) {
            return true;
        }
        if (super.process()) {
            return true;
        }
        if ("PLAC".equals(this.input.getTag()) && this.input.getLevel() > 1) {
            int rootlevel = this.input.getLevel();
            String key = this.input.getValue();
            ImportPlace importPlace = this.hasPlaces.get(key);
            if (importPlace != null) {
                importPlace.used = true;
                for (int i = 0; i < importPlace.levels.size(); ++i) {
                    this.output.writeLine(rootlevel + importPlace.levels.get(i), importPlace.tags.get(i), importPlace.values.get(i));
                }
                this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.06", pathBefore, pathBefore + ":..", key, key));
            } else {
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            }
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(PLACE_RECORD_TAG)) {
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                this.input.getNextLine(false);
            }
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(EVENT_RECORD_TAG)) {
            valueBefore = this.input.getValue();
            String xref3 = this.hashEventsToNoteID.get(valueBefore);
            this.output.writeLine(this.input.getLevel(), xref3, "NOTE", valueBefore);
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                Object tag = this.input.getTag();
                if (!((String)tag).startsWith("_")) {
                    tag = "_" + (String)tag;
                }
                this.output.writeLine(this.input.getLevel(), (String)tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            this.fixes.add(new ImportFix(xref3, "invalidEntity.08", pathBefore, "NOTE:..", valueBefore, valueBefore));
            return true;
        }
        if ("TYPE".equals(this.input.getTag()) && this.input.getLevel() == 2) {
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            xref = this.hashEventsToNoteID.get(this.input.getValue());
            if (xref != null) {
                String valueAfter = "@" + (String)xref + "@";
                this.output.writeLine(this.input.getLevel(), "NOTE", valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.09", pathBefore, path.getParent().getShortName() + ":NOTE", "", valueAfter));
            }
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(HASHTAG_RECORD_TAG)) {
            ++this.hashtagIndex;
            xref = "HT" + this.hashtagIndex;
            this.output.writeLine(this.input.getLevel(), (String)xref, "NOTE", this.input.getValue());
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                this.output.writeLine(this.input.getLevel(), "CONT", this.input.getValue());
                this.input.getNextLine(false);
            }
            this.fixes.add(new ImportFix((String)xref, "invalidEntity.03", pathBefore, "NOTE:..", "", ""));
            return true;
        }
        if (HASHTAG_TAG.equalsIgnoreCase(this.input.getTag())) {
            valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "NOTE", valueBefore);
            pathAfter = this.input.getPath().getParent().getShortName() + ":NOTE";
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.05", pathBefore, pathAfter, valueBefore, valueBefore));
            return true;
        }
        if (pathBefore.endsWith("_HASHTAG:NOTE")) {
            valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "CONT", valueBefore);
            pathAfter = this.input.getPath().getParent().getParent().getShortName() + ":NOTE:CONT";
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.05", pathBefore, pathAfter, valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals(TODO_RECORD_TAG)) {
            ++this.todoIndex;
            int level = this.input.getLevel();
            String value = this.input.getValue();
            if (value == null || value.isEmpty()) {
                this.input.getNextLine(false);
                value = this.input.getValue();
            }
            String xref4 = "T" + this.todoIndex;
            this.output.writeLine(level, xref4, "NOTE", value);
            this.input.getNextLine(false);
            while (this.input.getLevel() != 0) {
                this.input.getNextLine(true);
                Object tag = this.input.getTag();
                if ("DESC".equals(tag)) {
                    tag = "TODO";
                }
                if (!((String)tag).startsWith("_")) {
                    tag = "_" + (String)tag;
                }
                this.output.writeLine(this.input.getLevel(), (String)tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            this.fixes.add(new ImportFix(xref4, "invalidEntity.10", pathBefore, "NOTE:..", "", ""));
            return true;
        }
        if (this.input.getLevel() > 0 && this.input.getTag().equals(TODO_RECORD_TAG)) {
            int rootLevel = this.input.getLevel();
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.input.getNextLine(false);
            while (this.input.getLevel() > rootLevel) {
                this.input.getNextLine(true);
                Object tag = this.input.getTag();
                if ("DESC".equals(tag)) {
                    tag = TODO_RECORD_TAG;
                }
                if (!((String)tag).startsWith("_")) {
                    tag = "_" + (String)tag;
                }
                this.output.writeLine(this.input.getLevel(), (String)tag, this.input.getValue());
                this.input.getNextLine(false);
            }
            this.fixes.add(new ImportFix(this.currentXref, "invalidEntity.11", pathBefore, pathBefore + ":..", "", ""));
            return true;
        }
        return false;
    }

    protected void finalise() throws IOException {
        super.finalise();
        int p = 0;
        for (String key : this.hasPlaces.keySet()) {
            ImportPlace importPlace = this.hasPlaces.get(key);
            String valueBefore = importPlace.values.get(0);
            if (importPlace.used) continue;
            String xref = "P" + ++p;
            this.output.writeLine(0, "P" + p, "NOTE", valueBefore);
            for (int i = 0; i < importPlace.levels.size(); ++i) {
                Object tag = importPlace.tags.get(i);
                if (!((String)tag).startsWith("_")) {
                    tag = "_" + (String)tag;
                }
                this.output.writeLine(1 + importPlace.levels.get(i), (String)tag, importPlace.values.get(i));
            }
            this.fixes.add(new ImportFix(xref, "invalidEntity.07", PLACE_RECORD_TAG, "NOTE:..", valueBefore, valueBefore));
        }
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = false;
        this.fixFXfields(gedcom);
        ret |= super.fixGedcom(gedcom);
        this.incrementProgress();
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    public boolean fixOther(Gedcom gedcom) {
        Property p;
        String pathBefore;
        boolean fixed = false;
        for (Entity entity : gedcom.getIndis()) {
            for (Property buri : entity.getProperties("BURI", false)) {
                Property crem = buri.getProperty("CREM", false);
                if (crem == null) continue;
                buri.delProperty(crem);
                String valueBefore = buri.getValue();
                pathBefore = buri.getPath(true).getShortName();
                crem = entity.addProperty("CREM", valueBefore);
                for (Property p2 : buri.getProperties()) {
                    this.movePropertiesRecursively(p2, crem);
                }
                entity.delProperty(buri);
                this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.3", pathBefore, crem.getPath(true).getShortName(), valueBefore, valueBefore));
                fixed = true;
            }
        }
        for (Entity entity : gedcom.getIndis()) {
            for (Property cause : entity.getAllProperties("CAUS")) {
                Property[] props;
                for (Property source : props = cause.getProperties()) {
                    Property p2;
                    String valueBefore = source.getValue();
                    String pathBefore2 = source.getPath(true).getShortName();
                    String sourceTag = source.getTag();
                    this.movePropertiesRecursively(source, cause.getParent());
                    p2 = cause.getParent().getProperty(sourceTag, false);
                    this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.3", pathBefore2, p2.getPath(true).getShortName(), valueBefore, valueBefore));
                    fixed = true;
                }
            }
        }
        for (Entity entity : gedcom.getEntities()) {
            for (Property addr : entity.getAllProperties("ADDR")) {
                String valueBefore;
                for (Property map : addr.getAllProperties("MAP")) {
                    String pathBefore3 = map.getPath(true).getShortName();
                    String city = addr.getPropertyValue("CITY");
                    String stae = addr.getPropertyValue("STAE");
                    Property[] ctry = addr.getPropertyValue("CTRY");
                    String valueAfter = city + "," + stae + "," + (String)ctry;
                    Property plac = addr.getParent().addProperty("PLAC", valueAfter);
                    this.movePropertiesRecursively(map, plac);
                    Property p3 = plac.getProperty("MAP", false);
                    this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.4", pathBefore3, p3.getPath(true).getShortName(), "", valueAfter));
                    fixed = true;
                }
                for (Property note : addr.getAllProperties("NOTE")) {
                    valueBefore = note.getValue();
                    pathBefore = note.getPath(true).getShortName();
                    this.movePropertiesRecursively(note, addr.getParent());
                    p = addr.getParent().getProperty("NOTE", false);
                    this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.3", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                    fixed = true;
                }
                Property name = addr.getProperty("_NAME", false);
                if (!(entity instanceof Indi) || name == null) continue;
                String lastname = ((Indi)entity).getLastName();
                if (!name.getValue().equals(addr.getValue())) continue;
                valueBefore = addr.getValue();
                pathBefore = addr.getPath(true).getShortName();
                addr.delProperty(name);
                if (name.getValue().contains(lastname)) {
                    Property adr1 = addr.getProperty("ADR1", false);
                    if (adr1 != null) {
                        addr.setValue(adr1.getValue());
                        addr.delProperty(adr1);
                    } else {
                        addr.setValue("");
                    }
                    for (Property cont : addr.getProperties("CONT", false)) {
                        addr.delProperty(cont);
                    }
                    if (addr.getValue().isEmpty() && addr.getNoOfProperties() == 0) {
                        Property parent = addr.getParent();
                        parent.delProperty(addr);
                        if (parent.getValue().isEmpty() && parent.getNoOfProperties() == 0) {
                            parent.getParent().delProperty(parent);
                        }
                    }
                }
                this.fixes.add(new ImportFix(entity.getId(), "invalidInformation.1", pathBefore, pathBefore, valueBefore, ""));
                fixed = true;
            }
            for (Property place : entity.getAllProperties("PLAC")) {
                List maps = place.getAllProperties("MAP");
                if (maps.size() <= 1) continue;
                maps.remove(0);
                for (Property m : maps) {
                    place.delProperty(m);
                }
            }
        }
        for (Entity entity : gedcom.getEntities()) {
            for (Property note : entity.getAllProperties("NOTE")) {
                Property[] dates = note.getProperties("DATE", false);
                for (Property date : dates) {
                    String valueBefore = date.getValue();
                    String pathBefore4 = date.getPath(true).getShortName();
                    Property p4 = note.addProperty("_DATE", valueBefore);
                    note.delProperty(date);
                    this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.1", pathBefore4, p4.getPath(true).getShortName(), valueBefore, valueBefore));
                    fixed = true;
                }
                for (Property source : note.getAllProperties("SOUR")) {
                    String valueBefore = source.getValue();
                    String pathBefore5 = source.getPath(true).getShortName();
                    this.movePropertiesRecursively(source, note.getParent());
                    Property p5 = note.getParent().getProperty("SOUR", false);
                    this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.3", pathBefore5, p5.getPath(true).getShortName(), valueBefore, valueBefore));
                    fixed = true;
                }
            }
            for (Property type : entity.getAllProperties("TYPE")) {
                Property date = type.getProperty("DATE");
                if (date == null) continue;
                String valueBefore = date.getValue();
                String pathBefore6 = date.getPath(true).getShortName();
                Property even = entity.addProperty("EVEN", "");
                even.addProperty("TYPE", type.getValue());
                p = even.addProperty("DATE", valueBefore);
                type.delProperty(date);
                type.getParent().delProperty(type);
                this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.3", pathBefore6, p.getPath(true).getShortName(), valueBefore, valueBefore));
                fixed = true;
            }
            if (!entity.getTag().equals("SOUR")) continue;
            for (Property date : entity.getAllProperties("DATE")) {
                String valueBefore = date.getValue();
                String pathBefore7 = date.getPath(true).getShortName();
                Property p6 = entity.addProperty("_DATE", valueBefore);
                entity.delProperty(date);
                this.fixes.add(new ImportFix(entity.getId(), "invalidTagLocation.1", pathBefore7, p6.getPath(true).getShortName(), valueBefore, valueBefore));
                fixed = true;
            }
        }
        return fixed;
    }

    private boolean fixFXfields(Gedcom gedcom) {
        boolean existsFXfields;
        boolean fixed = false;
        int total = 0;
        int fx = 0;
        for (Entity indi : gedcom.getIndis()) {
            ++total;
            for (Property name : indi.getProperties("NAME", false)) {
                if (name.getProperties("NPFX", false).length <= 0 && name.getProperties("NSFX", false).length <= 0) continue;
                ++fx;
            }
        }
        if (fx == 0) {
            return false;
        }
        boolean danish = Locale.getDefault().getLanguage().equals(new Locale("da").getLanguage());
        boolean bl = existsFXfields = fx * 100 / total > 10;
        if (!danish && !existsFXfields) {
            return false;
        }
        String software = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"importlegacy.name");
        String message = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"importlegacy.issue1", (Object)software);
        Object rc = DialogManager.create((String)NbBundle.getMessage(Import.class, (String)"OpenIDE-Module-Name"), (String)message).setMessageType(3).setOptionType(0).show();
        if (rc != DialogManager.YES_OPTION) {
            return false;
        }
        for (Entity indi : gedcom.getIndis()) {
            for (Property name : indi.getProperties("NAME", false)) {
                Property nsfx;
                Property npfx = name.getProperty("NPFX", false);
                if (npfx != null) {
                    String valueBefore = npfx.getValue();
                    String pathBefore = npfx.getPath(true).getShortName();
                    Property p = indi.addProperty("OCCU", valueBefore);
                    name.delProperty(npfx);
                    this.fixes.add(new ImportFix(indi.getId(), "invalidName.9", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                    fixed = true;
                }
                if ((nsfx = name.getProperty("NSFX", false)) == null) continue;
                String valueBefore = nsfx.getValue();
                String pathBefore = nsfx.getPath(true).getShortName();
                Property p = indi.addProperty("OCCU", valueBefore);
                name.delProperty(nsfx);
                this.fixes.add(new ImportFix(indi.getId(), "invalidName.9", pathBefore, p.getPath(true).getShortName(), valueBefore, valueBefore));
                fixed = true;
            }
        }
        return fixed;
    }

    private class ImportPlace {
        protected boolean used = false;
        protected List<Integer> levels = new LinkedList<Integer>();
        protected List<String> tags = new LinkedList<String>();
        protected List<String> values = new LinkedList<String>();

        private ImportPlace() {
        }

        private void addLine(int level, String tag, String value) {
            this.levels.add(level);
            this.tags.add(tag);
            this.values.add(value);
        }
    }
}

