/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swing;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.graphstream.graph.Element;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.swing.Backend;
import org.graphstream.ui.swing.BackendJ2D;
import org.graphstream.ui.swing.BackendJ2DDummy;
import org.graphstream.ui.swing.renderer.GraphBackgroundRenderer;
import org.graphstream.ui.swing.renderer.JComponentRenderer;
import org.graphstream.ui.swing.renderer.SelectionRenderer;
import org.graphstream.ui.swing.renderer.StyleRenderer;
import org.graphstream.ui.swing.util.FPSLogger;
import org.graphstream.ui.swing.util.Selection;
import org.graphstream.ui.swing_viewer.DefaultView;
import org.graphstream.ui.swing_viewer.util.Graphics2DOutput;
import org.graphstream.ui.view.GraphRenderer;
import org.graphstream.ui.view.LayerRenderer;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.Viewer;
import org.graphstream.ui.view.camera.Camera;
import org.graphstream.ui.view.camera.DefaultCamera2D;
import org.graphstream.ui.view.util.GraphMetrics;
import org.graphstream.ui.view.util.InteractiveElement;

public class SwingGraphRenderer
implements GraphRenderer<Container, Graphics2D>,
StyleGroupListener {
    public static final String DEFAULT_RENDERER = "j2d_def_rndr";
    protected DefaultCamera2D camera = null;
    protected GraphicGraph graph = null;
    protected Selection selection = new Selection();
    protected LayerRenderer<Graphics2D> backRenderer = null;
    protected LayerRenderer<Graphics2D> foreRenderer = null;
    protected Backend swingBackend = null;
    protected Backend uhdBackend = null;
    protected FPSLogger fpsLogger = null;

    public void open(GraphicGraph graph, Container drawingSurface) {
        if (this.graph != null) {
            throw new RuntimeException("renderer already open, use close() first");
        }
        this.graph = graph;
        this.swingBackend = new BackendJ2DDummy();
        this.uhdBackend = new BackendJ2D();
        this.camera = new DefaultCamera2D(graph);
        graph.getStyleGroups().addListener((StyleGroupListener)this);
        this.swingBackend.open(drawingSurface);
        this.uhdBackend.open(drawingSurface);
    }

    public void close() {
        if (this.graph != null) {
            if (this.fpsLogger != null) {
                this.fpsLogger.close();
                this.fpsLogger = null;
            }
            this.removeRenderers();
            this.swingBackend.close();
            this.uhdBackend.close();
            this.graph.getStyleGroups().removeListener((StyleGroupListener)this);
            this.graph = null;
            this.swingBackend = null;
            this.uhdBackend = null;
            this.camera = null;
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Container renderingSurface() {
        return this.uhdBackend.drawingSurface();
    }

    protected GraphBackgroundRenderer getStyleRenderer(GraphicGraph graph) {
        if (graph.getStyle().getRenderer("dr") == null) {
            graph.getStyle().addRenderer("dr", (GraphicElement.SwingElementRenderer)new GraphBackgroundRenderer(graph, graph.getStyle()));
        }
        return (GraphBackgroundRenderer)graph.getStyle().getRenderer("dr");
    }

    protected StyleRenderer getStyleRenderer(StyleGroup style) {
        if (style.getRenderer("dr") == null) {
            style.addRenderer("dr", (GraphicElement.SwingElementRenderer)StyleRenderer.apply((StyleGroup)style, (SwingGraphRenderer)this));
        }
        return (StyleRenderer)style.getRenderer("dr");
    }

    protected StyleRenderer getStyleRenderer(GraphicElement element) {
        return this.getStyleRenderer(element.getStyle());
    }

    protected void removeRenderers() {
        this.graph.getStyle().removeRenderer("dr");
        this.graph.nodes().forEach(node -> ((GraphicNode)node).getStyle().removeRenderer("dr"));
        this.graph.edges().forEach(edge -> ((GraphicEdge)edge).getStyle().removeRenderer("dr"));
        this.graph.sprites().forEach(sprite -> sprite.getStyle().removeRenderer("dr"));
    }

    public void beginSelectionAt(double x, double y) {
        this.selection.setActive(true);
        this.selection.begins(x, y);
        Logger.getLogger(this.getClass().getSimpleName()).fine("Selection begins at " + x + " " + y);
    }

    public void selectionGrowsAt(double x, double y) {
        this.selection.grows(x, y);
    }

    public void endSelectionAt(double x, double y) {
        this.selection.grows(x, y);
        this.selection.setActive(false);
    }

    public void moveElementAtPx(GraphicElement element, double x, double y) {
        Point3 p = this.camera.transformPxToGuSwing(x, y);
        element.move(p.x, p.y, element.getZ());
    }

    public void render(Graphics2D g, int x, int y, int width, int height) {
        if (this.graph != null) {
            this.startFrame();
            if (this.swingBackend == null) {
                this.swingBackend = new BackendJ2DDummy();
            }
            if (this.uhdBackend == null) {
                this.uhdBackend = new BackendJ2D();
            }
            this.swingBackend.prepareNewFrame(g);
            this.camera.setSwingBackend((org.graphstream.ui.view.camera.Backend)this.swingBackend);
            this.uhdBackend.prepareNewFrame(g);
            this.camera.setUhdBackend((org.graphstream.ui.view.camera.Backend)this.uhdBackend);
            StyleGroupSet sgs = this.graph.getStyleGroups();
            this.setupGraphics();
            this.graph.computeBounds();
            this.camera.setBounds(this.graph);
            this.camera.setViewport(x, y, width, height);
            this.getStyleRenderer(this.graph).render(this.uhdBackend, this.camera, width, height);
            this.renderBackLayer();
            this.camera.pushView(this.graph);
            sgs.shadows().forEach(s -> this.getStyleRenderer((StyleGroup)s).renderShadow(this.uhdBackend, this.camera));
            sgs.getZIndex().forEach(groups -> groups.forEach(group -> {
                if (group.getType() != Selector.Type.GRAPH) {
                    this.getStyleRenderer((StyleGroup)group).render(this.uhdBackend, this.camera);
                }
            }));
            this.camera.popView();
            this.renderForeLayer();
            if (this.selection.getRenderer() == null) {
                this.selection.setRenderer(new SelectionRenderer(this.selection, this.graph));
            }
            this.selection.getRenderer().render(this.uhdBackend, this.camera, width, height);
            this.endFrame();
        }
    }

    protected void startFrame() {
        if (this.fpsLogger == null && this.graph.hasLabel("ui.log")) {
            this.fpsLogger = new FPSLogger(this.graph.getLabel("ui.log").toString());
        }
        if (this.fpsLogger != null) {
            this.fpsLogger.beginFrame();
        }
    }

    protected void endFrame() {
        if (this.fpsLogger != null) {
            this.fpsLogger.endFrame();
        }
    }

    protected void renderBackLayer() {
        if (this.backRenderer != null) {
            this.renderLayer(this.backRenderer);
        }
    }

    protected void renderForeLayer() {
        if (this.foreRenderer != null) {
            this.renderLayer(this.foreRenderer);
        }
    }

    protected void renderLayer(LayerRenderer<Graphics2D> renderer) {
        GraphMetrics metrics = this.camera.getMetrics();
        renderer.render((Object)this.uhdBackend.graphics2D(), this.graph, metrics.ratioPx2Gu, (int)metrics.viewport[2], (int)metrics.viewport[3], metrics.loVisible.x, metrics.loVisible.y, metrics.hiVisible.x, metrics.hiVisible.y);
    }

    protected void setupGraphics() {
        this.uhdBackend.setAntialias(Boolean.valueOf(this.graph.hasAttribute("ui.antialias")));
        this.uhdBackend.setQuality(Boolean.valueOf(this.graph.hasAttribute("ui.quality")));
    }

    public void screenshot(String filename, int width, int height) {
        block19: {
            if (filename.toLowerCase().endsWith("png")) {
                BufferedImage img = new BufferedImage(width, height, 2);
                this.render(img.createGraphics(), 0, 0, width, height);
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "png", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (filename.toLowerCase().endsWith("bmp")) {
                BufferedImage img = new BufferedImage(width, height, 1);
                this.render(img.createGraphics(), 0, 0, width, height);
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "bmp", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (filename.toLowerCase().endsWith("jpg") || filename.toLowerCase().endsWith("jpeg")) {
                BufferedImage img = new BufferedImage(width, height, 1);
                this.render(img.createGraphics(), 0, 0, width, height);
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "jpg", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (filename.toLowerCase().endsWith("svg")) {
                try {
                    String plugin = "org.graphstream.ui.batik.BatikGraphics2D";
                    Class<?> c = Class.forName(plugin);
                    Object o = c.newInstance();
                    if (o instanceof Graphics2DOutput) {
                        Graphics2DOutput out = (Graphics2DOutput)o;
                        Graphics2D g2 = out.getGraphics();
                        this.render(g2, 0, 0, width, height);
                        out.outputTo(filename);
                        break block19;
                    }
                    Logger.getLogger(this.getClass().getSimpleName()).warning("Plugin " + plugin + " is not an instance of Graphics2DOutput (" + o.getClass().getName() + ").");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Logger.getLogger(this.getClass().getSimpleName()).warning("Unknown screenshot filename extension " + filename + ", saving to jpeg.");
                BufferedImage img = new BufferedImage(width, height, 1);
                this.render(img.createGraphics(), 0, 0, width, height);
                File file = new File(filename + ".jpg");
                try {
                    ImageIO.write((RenderedImage)img, "jpg", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setBackLayerRenderer(LayerRenderer<Graphics2D> renderer) {
        this.backRenderer = renderer;
    }

    public void setForeLayoutRenderer(LayerRenderer<Graphics2D> renderer) {
        this.foreRenderer = renderer;
    }

    public void elementStyleChanged(Element element, StyleGroup oldStyle, StyleGroup style) {
        GraphicElement.SwingElementRenderer renderer;
        if (oldStyle != null && (renderer = oldStyle.getRenderer(DEFAULT_RENDERER)) != null && renderer instanceof JComponentRenderer) {
            ((JComponentRenderer)renderer).unequipElement((GraphicElement)element);
        }
    }

    public View createDefaultView(Viewer viewer, String id) {
        return new DefaultView(viewer, id, (GraphRenderer)this);
    }

    public GraphicElement findGraphicElementAt(EnumSet<InteractiveElement> types, double x, double y) {
        return this.camera.findGraphicElementAt(this.graph, types, x, y);
    }

    public Collection<GraphicElement> allGraphicElementsIn(EnumSet<InteractiveElement> types, double x1, double y1, double x2, double y2) {
        return this.camera.allGraphicElementsIn(this.graph, types, x1, y1, x2, y2);
    }
}

