/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph.graphstream;

import org.graphstream.algorithm.AStar;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class AncestrisAStar
extends AStar {
    public AncestrisAStar(Graph graphe) {
        super(graphe);
    }

    protected void aStar(Node sourceNode, Node targetNode) {
        this.clearAll();
        this.open.put(sourceNode, new AStar.AStarNode((AStar)this, sourceNode, null, null, 0.0, this.costs.heuristic(sourceNode, targetNode)));
        this.pathFound = false;
        while (!this.open.isEmpty()) {
            AStar.AStarNode current = this.getNextBetterNode();
            assert (current != null);
            if (current.node == targetNode) {
                assert (current.edge != null);
                this.pathFound = true;
                this.result = this.buildPath(current);
                return;
            }
            this.open.remove(current.node);
            this.closed.put(current.node, current);
            current.node.edges().forEach(edge -> {
                AStar.AStarNode alreadyInClosed;
                Node next = edge.getOpposite(current.node);
                double h = this.costs.heuristic(next, targetNode);
                double g = current.g + this.costs.cost(current.node, edge, next);
                double f = g + h;
                AStar.AStarNode alreadyInOpen = (AStar.AStarNode)this.open.get(next);
                if (!(alreadyInOpen != null && alreadyInOpen.rank <= f || (alreadyInClosed = (AStar.AStarNode)this.closed.get(next)) != null && alreadyInClosed.rank <= f)) {
                    this.closed.remove(next);
                    this.open.put(next, new AStar.AStarNode((AStar)this, next, edge, current, g, h));
                }
            });
        }
    }
}

