/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph.graphstream;

import java.awt.event.MouseEvent;
import java.util.EnumSet;
import javax.swing.event.MouseInputListener;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.util.InteractiveElement;
import org.graphstream.ui.view.util.MouseManager;

public class AncestrisMouseManager
implements MouseInputListener,
MouseManager {
    protected View view;
    protected GraphicGraph graph;
    private final EnumSet<InteractiveElement> types;
    protected GraphicElement curElement;
    protected float x1;
    protected float y1;

    public AncestrisMouseManager() {
        this(EnumSet.of(InteractiveElement.NODE, InteractiveElement.SPRITE));
    }

    public AncestrisMouseManager(EnumSet<InteractiveElement> types) {
        this.types = types;
    }

    public void init(GraphicGraph graph, View view) {
        this.view = view;
        this.graph = graph;
        view.addListener((Object)"Mouse", (Object)this);
        view.addListener((Object)"MouseMotion", (Object)this);
    }

    public EnumSet<InteractiveElement> getManagedTypes() {
        return this.types;
    }

    public void release() {
        this.view.removeListener((Object)"Mouse", (Object)this);
        this.view.removeListener((Object)"MouseMotion", (Object)this);
    }

    protected void mouseButtonPress(MouseEvent event) {
        this.view.requireFocus();
        if (!event.isShiftDown()) {
            this.graph.nodes().filter(n -> n.hasAttribute("ui.selected")).forEach(n -> n.removeAttribute("ui.selected"));
            this.graph.sprites().filter(s -> s.hasAttribute("ui.selected")).forEach(s -> s.removeAttribute("ui.selected"));
            this.graph.edges().filter(e -> e.hasAttribute("ui.selected")).forEach(e -> e.removeAttribute("ui.selected"));
        }
    }

    protected void mouseButtonRelease(MouseEvent event, Iterable<GraphicElement> elementsInArea) {
        for (GraphicElement element : elementsInArea) {
            if (element.hasAttribute("ui.selected")) continue;
            element.setAttribute("ui.selected", new Object[0]);
        }
    }

    protected void mouseButtonPressOnElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, true);
        if (event.getButton() == 3) {
            element.setAttribute("ui.selected", new Object[0]);
        } else {
            element.setAttribute("ui.clicked", new Object[0]);
        }
    }

    protected void elementMoving(GraphicElement element, MouseEvent event) {
        this.view.moveElementAtPx(element, (double)event.getX(), (double)event.getY());
    }

    protected void mouseButtonReleaseOffElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, false);
        if (event.getButton() != 3) {
            element.removeAttribute("ui.clicked");
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.curElement = this.view.findGraphicElementAt(this.types, (double)event.getX(), (double)event.getY());
        if (this.curElement != null) {
            this.mouseButtonPressOnElement(this.curElement, event);
        } else {
            this.x1 = event.getX();
            this.y1 = event.getY();
            this.mouseButtonPress(event);
            this.view.beginSelectionAt((double)this.x1, (double)this.y1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.curElement != null) {
            this.elementMoving(this.curElement, event);
        } else {
            double deltaX = (float)event.getX() - this.x1;
            double deltaY = (float)event.getY() - this.y1;
            Point3 p = this.view.getCamera().getViewCenter();
            Point3 p1 = this.view.getCamera().transformGuToPx(p.x, p.y, p.z);
            Point3 p2 = this.view.getCamera().transformPxToGu(p1.x - deltaX, p1.y - deltaY);
            this.view.getCamera().setViewCenter(p2.x, p2.y, p.z);
            this.x1 = event.getX();
            this.y1 = event.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.curElement != null) {
            this.mouseButtonReleaseOffElement(this.curElement, event);
            this.curElement = null;
        } else {
            float t;
            float x2 = event.getX();
            float y2 = event.getY();
            if (this.x1 > x2) {
                t = this.x1;
                this.x1 = x2;
                x2 = t;
            }
            if (this.y1 > y2) {
                t = this.y1;
                this.y1 = y2;
                y2 = t;
            }
            this.mouseButtonRelease(event, this.view.allGraphicElementsIn(this.types, (double)this.x1, (double)this.y1, (double)x2, (double)y2));
            this.view.endSelectionAt((double)x2, (double)y2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }
}

