/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.Field;
import genj.gedcom.GedcomOptions;
import org.openide.util.NbBundle;

public class RecordInfoPlace
extends Field
implements Cloneable {
    public static String EMPTY = NbBundle.getMessage(RecordInfoPlace.class, (String)"EmptyCity");
    private final int NB_JURISDICTIONS = 5;
    private String cityName = "";
    private String cityCode = "";
    private String countyName = "";
    private String stateName = "";
    private String countryName = "";
    private static final String juridictionSeparator = GedcomOptions.getInstance().isUseSpacedPlaces() ? ", " : ",";

    public RecordInfoPlace clone() throws CloneNotSupportedException {
        return (RecordInfoPlace)super.clone();
    }

    @Override
    public String getValue() {
        String[] juridictions = new String[]{this.cityName, this.cityCode, this.countyName, this.stateName, this.countryName};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < juridictions.length; ++i) {
            String juridiction = juridictions[i];
            if (juridiction == null) {
                juridiction = "";
            }
            sb.append(juridiction);
            if (i >= juridictions.length - 1) continue;
            sb.append(juridictionSeparator);
        }
        String ret = sb.toString();
        if (ret.replace(",", "").isBlank()) {
            ret = EMPTY;
        }
        return ret;
    }

    @Override
    public void setValue(String value) {
        String[] juridictions = value.split(juridictionSeparator, -1);
        this.cityName = juridictions.length > 0 ? juridictions[0] : "";
        this.cityCode = juridictions.length > 1 ? juridictions[1] : "";
        this.countyName = juridictions.length > 2 ? juridictions[2] : "";
        this.stateName = juridictions.length > 3 ? juridictions[3] : "";
        this.countryName = juridictions.length > 4 ? juridictions[4] : "";
    }

    public void setValue(String cityName, String cityCode, String county, String state, String country) {
        this.cityName = cityName;
        this.cityCode = cityCode;
        this.countyName = county;
        this.stateName = state;
        this.countryName = country;
    }

    public void setValue(RecordInfoPlace recordInfoPlace) {
        this.cityName = recordInfoPlace.getCityName();
        this.cityCode = recordInfoPlace.getCityCode();
        this.countyName = recordInfoPlace.getCountyName();
        this.stateName = recordInfoPlace.getStateName();
        this.countryName = recordInfoPlace.getCountryName();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.cityName.isEmpty() && this.cityCode.isEmpty() && this.stateName.isEmpty() && this.countyName.isEmpty() && this.countryName.isEmpty();
    }

    public String getDisplayValue() {
        return this.getValue();
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String value) {
        this.cityName = value;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String value) {
        this.cityCode = value;
    }

    public String getCountyName() {
        return this.countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }
}

