/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.laf.DefaultLookFeel;

public class DashedBorder
implements Border {
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    protected int thickness = 1;
    protected Color color;
    private BasicStroke stroke = BASIC_STROKE;
    private ResourceTableListener listener = null;

    public DashedBorder(Color color, float l1, float l2) {
        this(color, new float[]{l1, l2}, 1);
    }

    public DashedBorder(String property, Widget associated, float l1, float l2) {
        this(property, associated.getResourceTable(), new float[]{l1, l2}, 1);
    }

    public DashedBorder(String property, ResourceTable table, float l1, float l2) {
        this(property, table, new float[]{l1, l2}, 1);
    }

    public DashedBorder(Color color, float[] dash, int thickness) {
        if (thickness < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + thickness);
        }
        this.thickness = thickness;
        this.color = color != null ? color : new DefaultLookFeel().getForeground();
        this.stroke = new BasicStroke(thickness, 0, 1, 0.0f, dash, 0.0f);
    }

    public DashedBorder(String property, ResourceTable table, float[] dash, int thickness) {
        if (thickness < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + thickness);
        }
        this.thickness = thickness;
        this.stroke = new BasicStroke(thickness, 0, 1, 0.0f, dash, 0.0f);
        Object value = table.getProperty(property);
        if (value instanceof Color) {
            this.color = (Color)value;
        }
        this.listener = new ResourceTableListener();
        table.addPropertyChangeListener(property, this.listener);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public void paint(Graphics2D g, Rectangle bounds) {
        Stroke s = g.getStroke();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        g.drawRect(bounds.x, bounds.y, bounds.width - this.thickness, bounds.height - this.thickness);
        g.setStroke(s);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            DashedBorder.this.color = (Color)event.getNewValue();
        }
    }
}

